/*
 * Decompiled with CFR 0.152.
 */
package com.kikini.logging.simpledb;

import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.model.BatchPutAttributesRequest;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.amazonaws.services.simpledb.model.ReplaceableItem;
import com.kikini.logging.simpledb.ListBatcher;
import com.kikini.logging.simpledb.SimpleDBRow;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

class SimpleDBWriter {
    private static final int MAX_ATTR_SIZE_BYTES = 1024;
    private static final int MAX_BATCH_PUT = 25;
    private static final String HOST_COLUMN = "host";
    private static final String CONTEXT_COLUMN = "context";
    private static final String TIME_COLUMN = "time";
    private static final String MESSAGE_COLUMN = "msg";
    private static final String LEVEL_COLUMN = "level";
    private static final String LOGGER_COLUMN = "logger";
    private static final String MDC_COLUMN_PREFIX = "mdc.";
    private DateTimeFormatter timeFormatter = ISODateTimeFormat.dateTime();
    private final AmazonSimpleDB sdb;
    private final String dom;

    SimpleDBWriter(AmazonSimpleDB sdb, String dom) {
        this.sdb = sdb;
        this.dom = dom;
    }

    private String formatTime(long time) {
        return this.timeFormatter.print((ReadableInstant)new DateTime(time));
    }

    public void setTimeZone(DateTimeZone timeZone) {
        this.timeFormatter = ISODateTimeFormat.dateTime().withZone(timeZone);
    }

    private String truncateToSize(String string) {
        Charset utf8 = Charset.forName("UTF-8");
        int size = string.getBytes(utf8).length;
        if (size <= 1024) {
            return string;
        }
        int decrement = 16;
        int nextIdx = 1024 >= string.length() ? string.length() - 16 : 1024;
        do {
            string = string.substring(0, nextIdx);
            nextIdx -= 16;
        } while (string.getBytes(utf8).length > 1024);
        return string;
    }

    private void addIfNotNull(List<ReplaceableAttribute> atts, String key, String val) {
        if (val != null) {
            atts.add(new ReplaceableAttribute(key, this.truncateToSize(val), Boolean.valueOf(false)));
        }
    }

    void writeRows(List<SimpleDBRow> rows) {
        List<SimpleDBRow> nextBatch;
        if (rows.isEmpty()) {
            return;
        }
        ListBatcher<SimpleDBRow> batchedList = new ListBatcher<SimpleDBRow>(rows, 25);
        while ((nextBatch = batchedList.nextBatch()) != null) {
            ArrayList<ReplaceableItem> items = new ArrayList<ReplaceableItem>();
            for (SimpleDBRow row : nextBatch) {
                ArrayList<ReplaceableAttribute> atts = new ArrayList<ReplaceableAttribute>();
                this.addIfNotNull(atts, HOST_COLUMN, row.getHost());
                this.addIfNotNull(atts, MESSAGE_COLUMN, row.getMsg());
                this.addIfNotNull(atts, LEVEL_COLUMN, row.getLevel());
                this.addIfNotNull(atts, LOGGER_COLUMN, row.getLogger());
                this.addIfNotNull(atts, CONTEXT_COLUMN, row.getContext());
                this.addIfNotNull(atts, TIME_COLUMN, this.formatTime(row.getTime()));
                for (Map.Entry<String, String> mdcProperty : row.getMDCPropertyMap().entrySet()) {
                    String mdcColumnName = MDC_COLUMN_PREFIX + mdcProperty.getKey();
                    this.addIfNotNull(atts, mdcColumnName, mdcProperty.getValue());
                }
                items.add(new ReplaceableItem(UUID.randomUUID().toString(), atts));
            }
            this.sdb.batchPutAttributes(new BatchPutAttributesRequest(this.dom, items));
        }
    }
}

