(ns joints.components.http-kit.server
  (:require
   [com.stuartsierra.component :as c]
   [joints.components.ring.core :as crc]
   [org.httpkit.server :refer [run-server]]
   [ring.util.http-response :as resp]))

(defn search-handler
  [{:keys [default-handler] :as m}]
  (or (->> m
           (map val)
           (filter #(satisfies? crc/IRequestHandler %))
           (map crc/request-handler)
           first)
      default-handler
      (constantly
       (resp/service-unavailable "No request handler found"))))

(defrecord WebServer [port default-handler server]
  c/Lifecycle
  (start [this]
    (if (some? server)
      this
      (let [handler (search-handler this)
            server  (run-server handler {:port (or port 8080)})]
        (assoc this :server server))))
  (stop [this]
    (if (nil? server)
      this
      (do (server :timeout 100)
          (assoc this :server nil)))))

(defn make-web-server
  [{:keys [port default-handler]}]
  (map->WebServer {:port            port
                   :default-handler default-handler}))
