(ns joints.components.timbre.core
  (:require
   [joints.components.timbre.logger :as ctl]
   [joints.components.timbre.proto :as ctp]))

(def ILogger ctp/ILogger)

(defn log
  [ilogger]
  (ctp/log ilogger level throwable message))

(defn make-logger
  [option]
  (ctl/make-logger option))

(defn trace
  [ilogger message]
  (ctl/trace ilogger message))

(defn debug
  [ilogger message]
  (ctl/debug ilogger message))

(defn info
  [ilogger message]
  (ctl/info ilogger message))

(defn warn
  [ilogger message]
  (ctl/warn ilogger message))

(defn error
  ([ilogger throwable message]
   (ctl/error ilogger throwable message))
  ([ilogger message]
   (ctl/error ilogger message)))

(defn fatal
  ([ilogger throwable message]
   (ctl/fatal ilogger throwable message))
  ([ilogger message]
   (ctl/fatal ilogger message)))

(defn report
  [ilogger message]
  (ctl/report ilogger message))
