(ns joints.components.middleware.impl
  (:require
   [joints.components.middleware.proto :as cmp]))

(defn substitute
  [component entry]
  (if (vector? entry)
    (replace {:component component} entry)
    entry))

(defn coerce
  [entry]
  (if (vector? entry)
    #(apply (first entry) % (rest entry))
    entry))

(defn compose
  [m entries]
  (->> entries
       (map (comp
             coerce
             #(substitute m %)))
       (apply comp)))

(defn search-wrapper
  [m]
  (->> m
       (map val)
       (filter #(satisfies? cmp/IMiddleware %))
       (map cmp/wrapper)
       (apply comp)))

(defrecord Middleware [entries]
  cmp/IMiddleware
  (-wrapper [this]
    (let [wrapper       (compose this entries)
          next-wrappers (search-wrapper this)]
      (comp wrapper next-wrappers))))

(defn make-middleware
  ([{:keys [entries]}]
   (map->Middleware {:entries entries}))
  ([]
   (make-middleware {})))
