(ns parts.components.async.core
  (:require
   [clojure.spec.alpha :as s]
   [parts.components.async.channel :as cac]
   [parts.components.async.listener :as cal]
   [parts.components.async.pipeliner :as cap]
   [parts.components.async.spec :as cas]))

(s/def ::size ::cas/size)

(s/def ::channel-option ::cas/channel-option)

(s/def ::chan ::cas/chan)

(s/def ::parallelism ::cas/parallelism)

(s/def ::to ::cas/to)

(s/def ::updater-fn ::cas/updater-fn)

(s/def ::from ::cas/from)

(s/def ::close-both? ::cas/close-both?)

(s/def ::ex-handler ::cas/ex-handler)

(s/def ::xform-fn ::cas/xform-fn)

(s/def ::channel-pipeliner-option ::cas/channel-pipeliner-option)

(s/def ::async-fn ::cas/async-fn)

(s/def ::channel-pipeliner-async-option ::cas/channel-pipeliner-async-option)

#?(:clj
   (s/def ::channel-pipeliner-blocking-option
     ::cas/channel-pipeliner-blocking-option))

(def make-fixed-channel cac/make-fixed-channel)

(def make-sliding-channel cac/make-sliding-channel)

(def make-dropping-channel cac/make-dropping-channel)

(def make-channel-listener cal/make-channel-listener)

(def make-channel-pipeliner cap/make-channel-pipeliner)

(def make-channel-pipeliner-async cap/make-channel-pipeliner-async)

#?(:clj
   (def make-channel-pipeliner-blocking cap/make-channel-pipeliner-blocking))
