(ns parts.components.async.spec
  (:require
   [clojure.spec.alpha :as s]
   #?@(:clj  [[clojure.core.async :as a]]
       :cljs [[cljs.core.async :as a]])))

(s/def ::size pos-int?)

(s/def ::channel-option (s/keys :opt-un [::size]))

(s/def ::chan
  #?(:clj  #(instance? clojure.core.async.impl.channels.ManyToManyChannel %)
     :cljs #(instance? cljs.core.async.impl.channels.ManyToManyChannel %)))

(s/def ::parallelism pos-int?)

(s/def ::to (s/keys :req-un [::chan]))

(s/def ::updater-fn fn?)

(s/def ::from (s/keys :req-un [::chan]))

(s/def ::close-both? boolean?)

(s/def ::ex-handler fn?)

(s/def ::xform-fn ::updater-fn)

(s/def ::channel-pipeliner-option (s/keys :req-un [::xform-fn]
                                          :opt-un [::parallelism
                                                   ::to
                                                   ::from
                                                   ::close-both?
                                                   ::ex-handler]))

(s/def ::async-fn ::updater-fn)

(s/def ::channel-pipeliner-async-option (s/keys :req-un [::async-fn]
                                                :opt-un [::parallelism
                                                         ::to
                                                         ::from
                                                         ::close-both?]))

#?(:clj
   (s/def ::channel-pipeliner-blocking-option (s/keys :req-un [::xform-fn]
                                                      :opt-un [::parallelism
                                                               ::to
                                                               ::from
                                                               ::close-both?
                                                               ::ex-handler])))

(s/def ::handler fn?)

(s/def ::channel-listener-option (s/keys :req-un [::handler]))
