(ns parts.components.bidi.ring
  (:require
   [bidi.ring :refer [make-handler]]
   [clojure.spec.alpha :as s]
   [com.stuartsierra.component :as c]
   [parts.components.bidi.spec :as cbs]))

(defn collect-route-option
  [m]
  (when-let [rcs (into [] (comp (map val) (filter :routes)) m)]
    (let [has-resources (into [] (filter :resources) rcs)
          prefix        (or (:prefix m) "")]
      (if (seq has-resources)
        {:routes    [prefix (into {} (map :routes) has-resources)]
         :resources (into {} (map :resources) has-resources)}
        {:routes [prefix (into {} (map :routes) rcs)]}))))

(defrecord RingRouter [prefix routes not-found-handler handler]
  c/Lifecycle
  (start [this]
    (if (some? handler)
      this
      (let [{:keys [routes resources] :as route-option}
            (collect-route-option this)

            handler (some-fn
                     (cond
                       (nil? route-option)
                       (constantly {:status 503})

                       (nil? resources)
                       (make-handler routes)

                       :else
                       (make-handler routes resources))
                     (or not-found-handler
                         (constantly {:status 404})))]
        (assoc this :handler handler :routes routes))))
  (stop [this]
    (if (nil? handler)
      this
      (assoc this :handler nil :routes nil))))

(defn make-ring-router
  ([{:keys [prefix not-found-handler route-config] :as option}]
   (s/assert ::cbs/option option)
   (merge (map->RingRouter {:prefix            prefix
                            :not-found-handler not-found-handler})
          route-config))
  ([]
   (make-ring-router {})))
