(ns parts.repl.impl
  (:require
   [boot.util :as bu]
   [clojure.spec.alpha :as s]
   [clojure.tools.namespace.reload :as nsr]
   [clojure.tools.namespace.repl :refer [refresh]]
   [com.stuartsierra.component :as c]
   [parts.repl.spec :as rs]))

(def system
  nil)

(def initializer
  nil)

(defn setup!
  [sym]
  (s/assert ::rs/symbol sym)
  (alter-var-root #'initializer (constantly sym)))

(defn boot!
  []
  (alter-var-root #'system (constantly ((find-var initializer))))
  (alter-var-root #'system c/start)
  :ok)

(defn shutdown!
  []
  (alter-var-root #'system
                  (fn [sys]
                    (when (some? sys)
                      (c/stop sys))))
  :ok)

(defn reboot!
  [tracker restart?]
  (when restart?
    (bu/info "Shutting down system...\n")
    (shutdown!))
  (bu/info "Reloading namespaces...\n")
  (nsr/track-reload tracker)
  (when restart?
    (bu/info "Starting back system...\n")
    (boot!)))
