(ns pos5.request
  (:require
   [ajax.core :as jx]
   #?@(:clj  [[clojure.core.async :as a]]
       :cljs [[goog.crypt.base64 :refer [encodeString]]
              [cljs.core.async :as a]]))
  #?(:clj
     (:import
      [java.util Base64])))

;; -------------------------------------------------------------------
;; wrapper
;; -------------------------------------------------------------------

(defn wrap-content-type
  [option content-type]
  (assoc option
         :format          content-type
         :response-format content-type))

(defn- ->base64
  [input]
  #?(:clj  (.encodeToString (Base64/getEncoder) (.getBytes input))
     :cljs (encodeString input)))

(defn- wrap-authorization
  [option scheme token]
  (let [value (str scheme " " token)]
    (assoc-in option [:headers "authorization"] value)))

(defn wrap-http-basic-auth
  [option username password]
  (let [token (->base64 (str username ":" password))]
    (wrap-authorization option "Basic" token)))

(defn wrap-forget-token
  [option token]
  (wrap-authorization option "SentryForget" token))

(defn wrap-reset-token
  [option token]
  (wrap-authorization option "SentryReset" token))

;; -------------------------------------------------------------------
;; request
;; -------------------------------------------------------------------

(defn- response-handler
  [kind channel]
  (fn [response]
    (a/put! channel {:response/kind kind
                     :response/data response})))

(defn- request!
  [request-fn]
  (fn [url {:keys [channel] :as option}]
    (let [channel (or channel (a/chan))]
      (request-fn url
                  (-> option
                      (dissoc :channel)
                      (assoc :handler       (response-handler :success channel)
                             :error-handler (response-handler :fail channel))))
      channel)))

(def POST (request! jx/POST))
(def PUT (request! jx/PUT))
(def DELETE (request! jx/DELETE))
