(defproject ntestoc3/common "2.1.7"
  :description "my common libs helper"
  :url "https://github.com/ntestoc3/common"
  :license {:name "MIT"
            :url "https://opensource.org/licenses/MIT"}
  :dependencies [[org.clojure/clojure "1.10.2"]
                 [clj-http "3.12.3"]
                 [com.taoensso/timbre "5.2.1"]    ; logging
                 [me.raynes/fs "1.4.6"]            ;; file util
                 [net.lingala.zip4j/zip4j "2.10.0"] ;; zip with password
                 [clojure.java-time "0.3.3"]       ; datetime
                 [diehard "0.11.3"]                 ;; guard
                 [com.grammarly/omniconf "0.4.3"]  ;; config
                 [fipp "0.6.26"] ;; pretty print
                 [clojurewerkz/quartzite "2.1.0"] ;; cron
                 ]
  :profiles {:dev {:dependencies
                   [[midje "1.10.5" :exclusions [org.clojure/clojure]]]
                   :plugins [[lein-midje "3.2.1"]]}}
  :repl-options {:init-ns common.core})
