// Compiled by ClojureScript 1.9.946 {}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.call(null,cljs.core.mapcat.call(null,(function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.call(null,clojure.string.replace.call(null,cljs.core.name.call(null,lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join('');
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.call(null,ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv.call(null,(function (xs,ns,_){
if(cljs.core._EQ_.call(null,needle,cljs.compiler.get_first_ns_segment.call(null,ns))){
return cljs.core.reduced.call(null,needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__12241 = s;
var map__12241__$1 = ((((!((map__12241 == null)))?((((map__12241.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12241.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12241):map__12241);
var name = cljs.core.get.call(null,map__12241__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__12241__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__12244 = info;
var map__12245 = G__12244;
var map__12245__$1 = ((((!((map__12245 == null)))?((((map__12245.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12245.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12245):map__12245);
var shadow = cljs.core.get.call(null,map__12245__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__12244__$1 = G__12244;
while(true){
var d__$2 = d__$1;
var map__12247 = G__12244__$1;
var map__12247__$1 = ((((!((map__12247 == null)))?((((map__12247.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12247.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12247):map__12247);
var shadow__$1 = cljs.core.get.call(null,map__12247__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__12249 = (d__$2 + (1));
var G__12250 = shadow__$1;
d__$1 = G__12249;
G__12244__$1 = G__12250;
continue;
} else {
if(cljs.core.truth_(cljs.compiler.find_ns_starts_with.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('')))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine.call(null,cljs.core._hash.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s)),cljs.compiler.shadow_depth.call(null,s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__12251){
var map__12252 = p__12251;
var map__12252__$1 = ((((!((map__12252 == null)))?((((map__12252.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12252.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12252):map__12252);
var name_var = map__12252__$1;
var name = cljs.core.get.call(null,map__12252__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__12252__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''),"..","_DOT__DOT_");
var map__12254 = info;
var map__12254__$1 = ((((!((map__12254 == null)))?((((map__12254.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12254.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12254):map__12254);
var ns = cljs.core.get.call(null,map__12254__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.call(null,map__12254__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,"_$_",cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.call(null,cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.replace.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join(''),".","$")),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('')));
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if(!((cljs.core.get.call(null,reserved,s) == null))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__12257 = arguments.length;
switch (G__12257) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.call(null,s,cljs.compiler.js_reserved);
});

cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_.call(null,s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if(!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null))){
return cljs.compiler.fn_self_name.call(null,s);
} else {
var depth = cljs.compiler.shadow_depth.call(null,s);
var code = cljs.compiler.hash_scope.call(null,s);
var renamed = cljs.core.get.call(null,cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):((!((renamed == null)))?renamed:name
));
var munged_name = cljs.compiler.munge.call(null,name__$1,reserved);
if((field === true) || ((depth === (0)))){
return munged_name;
} else {
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace.call(null,ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved.call(null,reserved);
var ss__$2 = cljs.core.map.call(null,rf,clojure.string.split.call(null,ss__$1,/\./));
var ss__$3 = clojure.string.join.call(null,".",ss__$2);
var ms = cljs.core.munge_str.call(null,ss__$3);
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ms);
} else {
return ms;
}
}
});

cljs.compiler.munge.cljs$lang$maxFixedArity = 2;

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.call(null,",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__12259 = cp;
switch (G__12259) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if((((31) < cp)) && ((cp < (127)))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.call(null,"0000",unpadded.length);
return ["\\u",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pad),cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__12261_12265 = cljs.core.seq.call(null,s);
var chunk__12262_12266 = null;
var count__12263_12267 = (0);
var i__12264_12268 = (0);
while(true){
if((i__12264_12268 < count__12263_12267)){
var c_12269 = cljs.core._nth.call(null,chunk__12262_12266,i__12264_12268);
sb.append(cljs.compiler.escape_char.call(null,c_12269));

var G__12270 = seq__12261_12265;
var G__12271 = chunk__12262_12266;
var G__12272 = count__12263_12267;
var G__12273 = (i__12264_12268 + (1));
seq__12261_12265 = G__12270;
chunk__12262_12266 = G__12271;
count__12263_12267 = G__12272;
i__12264_12268 = G__12273;
continue;
} else {
var temp__5457__auto___12274 = cljs.core.seq.call(null,seq__12261_12265);
if(temp__5457__auto___12274){
var seq__12261_12275__$1 = temp__5457__auto___12274;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12261_12275__$1)){
var c__9319__auto___12276 = cljs.core.chunk_first.call(null,seq__12261_12275__$1);
var G__12277 = cljs.core.chunk_rest.call(null,seq__12261_12275__$1);
var G__12278 = c__9319__auto___12276;
var G__12279 = cljs.core.count.call(null,c__9319__auto___12276);
var G__12280 = (0);
seq__12261_12265 = G__12277;
chunk__12262_12266 = G__12278;
count__12263_12267 = G__12279;
i__12264_12268 = G__12280;
continue;
} else {
var c_12281 = cljs.core.first.call(null,seq__12261_12275__$1);
sb.append(cljs.compiler.escape_char.call(null,c_12281));

var G__12282 = cljs.core.next.call(null,seq__12261_12275__$1);
var G__12283 = null;
var G__12284 = (0);
var G__12285 = (0);
seq__12261_12265 = G__12282;
chunk__12262_12266 = G__12283;
count__12263_12267 = G__12284;
i__12264_12268 = G__12285;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("\""),cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\"")].join('');
});
if(typeof cljs.compiler.emit_STAR_ !== 'undefined'){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__9443__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__9444__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__9445__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__9446__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__9447__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__9447__auto__,method_table__9443__auto__,prefer_table__9444__auto__,method_cache__9445__auto__,cached_hierarchy__9446__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
var val__10638__auto__ = cljs.env._STAR_compiler_STAR_;
if((val__10638__auto__ == null)){
cljs.env._STAR_compiler_STAR_ = cljs.env.default_compiler_env.call(null);
} else {
}

try{if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__12286_12291 = ast;
var map__12286_12292__$1 = ((((!((map__12286_12291 == null)))?((((map__12286_12291.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12286_12291.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12286_12291):map__12286_12291);
var env_12293 = cljs.core.get.call(null,map__12286_12292__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_12293))){
var map__12288_12294 = env_12293;
var map__12288_12295__$1 = ((((!((map__12288_12294 == null)))?((((map__12288_12294.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12288_12294.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12288_12294):map__12288_12294);
var line_12296 = cljs.core.get.call(null,map__12288_12295__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_12297 = cljs.core.get.call(null,map__12288_12295__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,((function (map__12288_12294,map__12288_12295__$1,line_12296,column_12297,map__12286_12291,map__12286_12292__$1,env_12293,val__10638__auto__){
return (function (m){
var minfo = (function (){var G__12290 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.Keyword(null,"var","var",-769682797))){
return cljs.core.assoc.call(null,G__12290,new cljs.core.Keyword(null,"name","name",1843675177),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast)))].join(''));
} else {
return G__12290;
}
})();
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_12296 - (1))], null),cljs.core.fnil.call(null,((function (minfo,map__12288_12294,map__12288_12295__$1,line_12296,column_12297,map__12286_12291,map__12286_12292__$1,env_12293,val__10638__auto__){
return (function (line__$1){
return cljs.core.update_in.call(null,line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_12297)?(column_12297 - (1)):(0))], null),cljs.core.fnil.call(null,((function (minfo,map__12288_12294,map__12288_12295__$1,line_12296,column_12297,map__12286_12291,map__12286_12292__$1,env_12293,val__10638__auto__){
return (function (column__$1){
return cljs.core.conj.call(null,column__$1,minfo);
});})(minfo,map__12288_12294,map__12288_12295__$1,line_12296,column_12297,map__12286_12291,map__12286_12292__$1,env_12293,val__10638__auto__))
,cljs.core.PersistentVector.EMPTY));
});})(minfo,map__12288_12294,map__12288_12295__$1,line_12296,column_12297,map__12286_12291,map__12286_12292__$1,env_12293,val__10638__auto__))
,cljs.core.sorted_map.call(null)));
});})(map__12288_12294,map__12288_12295__$1,line_12296,column_12297,map__12286_12291,map__12286_12292__$1,env_12293,val__10638__auto__))
);
} else {
}
} else {
}

return cljs.compiler.emit_STAR_.call(null,ast);
}finally {if((val__10638__auto__ == null)){
cljs.env._STAR_compiler_STAR_ = null;
} else {
}
}});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var args__9674__auto__ = [];
var len__9667__auto___12304 = arguments.length;
var i__9668__auto___12305 = (0);
while(true){
if((i__9668__auto___12305 < len__9667__auto___12304)){
args__9674__auto__.push((arguments[i__9668__auto___12305]));

var G__12306 = (i__9668__auto___12305 + (1));
i__9668__auto___12305 = G__12306;
continue;
} else {
}
break;
}

var argseq__9675__auto__ = ((((0) < args__9674__auto__.length))?(new cljs.core.IndexedSeq(args__9674__auto__.slice((0)),(0),null)):null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(argseq__9675__auto__);
});

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var seq__12300_12307 = cljs.core.seq.call(null,xs);
var chunk__12301_12308 = null;
var count__12302_12309 = (0);
var i__12303_12310 = (0);
while(true){
if((i__12303_12310 < count__12302_12309)){
var x_12311 = cljs.core._nth.call(null,chunk__12301_12308,i__12303_12310);
if((x_12311 == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_.call(null,x_12311)){
cljs.compiler.emit.call(null,x_12311);
} else {
if(cljs.analyzer.cljs_seq_QMARK_.call(null,x_12311)){
cljs.core.apply.call(null,cljs.compiler.emits,x_12311);
} else {
if(goog.isFunction(x_12311)){
x_12311.call(null);
} else {
var s_12312 = cljs.core.print_str.call(null,x_12311);
if((cljs.compiler._STAR_source_map_data_STAR_ == null)){
} else {
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gen-col","gen-col",1901918303)], null),((function (seq__12300_12307,chunk__12301_12308,count__12302_12309,i__12303_12310,s_12312,x_12311){
return (function (p1__12298_SHARP_){
return (p1__12298_SHARP_ + cljs.core.count.call(null,s_12312));
});})(seq__12300_12307,chunk__12301_12308,count__12302_12309,i__12303_12310,s_12312,x_12311))
);
}

cljs.core.print.call(null,s_12312);

}
}
}
}

var G__12313 = seq__12300_12307;
var G__12314 = chunk__12301_12308;
var G__12315 = count__12302_12309;
var G__12316 = (i__12303_12310 + (1));
seq__12300_12307 = G__12313;
chunk__12301_12308 = G__12314;
count__12302_12309 = G__12315;
i__12303_12310 = G__12316;
continue;
} else {
var temp__5457__auto___12317 = cljs.core.seq.call(null,seq__12300_12307);
if(temp__5457__auto___12317){
var seq__12300_12318__$1 = temp__5457__auto___12317;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12300_12318__$1)){
var c__9319__auto___12319 = cljs.core.chunk_first.call(null,seq__12300_12318__$1);
var G__12320 = cljs.core.chunk_rest.call(null,seq__12300_12318__$1);
var G__12321 = c__9319__auto___12319;
var G__12322 = cljs.core.count.call(null,c__9319__auto___12319);
var G__12323 = (0);
seq__12300_12307 = G__12320;
chunk__12301_12308 = G__12321;
count__12302_12309 = G__12322;
i__12303_12310 = G__12323;
continue;
} else {
var x_12324 = cljs.core.first.call(null,seq__12300_12318__$1);
if((x_12324 == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_.call(null,x_12324)){
cljs.compiler.emit.call(null,x_12324);
} else {
if(cljs.analyzer.cljs_seq_QMARK_.call(null,x_12324)){
cljs.core.apply.call(null,cljs.compiler.emits,x_12324);
} else {
if(goog.isFunction(x_12324)){
x_12324.call(null);
} else {
var s_12325 = cljs.core.print_str.call(null,x_12324);
if((cljs.compiler._STAR_source_map_data_STAR_ == null)){
} else {
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gen-col","gen-col",1901918303)], null),((function (seq__12300_12307,chunk__12301_12308,count__12302_12309,i__12303_12310,s_12325,x_12324,seq__12300_12318__$1,temp__5457__auto___12317){
return (function (p1__12298_SHARP_){
return (p1__12298_SHARP_ + cljs.core.count.call(null,s_12325));
});})(seq__12300_12307,chunk__12301_12308,count__12302_12309,i__12303_12310,s_12325,x_12324,seq__12300_12318__$1,temp__5457__auto___12317))
);
}

cljs.core.print.call(null,s_12325);

}
}
}
}

var G__12326 = cljs.core.next.call(null,seq__12300_12318__$1);
var G__12327 = null;
var G__12328 = (0);
var G__12329 = (0);
seq__12300_12307 = G__12326;
chunk__12301_12308 = G__12327;
count__12302_12309 = G__12328;
i__12303_12310 = G__12329;
continue;
}
} else {
}
}
break;
}

return null;
});

cljs.compiler.emits.cljs$lang$maxFixedArity = (0);

cljs.compiler.emits.cljs$lang$applyTo = (function (seq12299){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq12299));
});

cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var args__9674__auto__ = [];
var len__9667__auto___12335 = arguments.length;
var i__9668__auto___12336 = (0);
while(true){
if((i__9668__auto___12336 < len__9667__auto___12335)){
args__9674__auto__.push((arguments[i__9668__auto___12336]));

var G__12337 = (i__9668__auto___12336 + (1));
i__9668__auto___12336 = G__12337;
continue;
} else {
}
break;
}

var argseq__9675__auto__ = ((((0) < args__9674__auto__.length))?(new cljs.core.IndexedSeq(args__9674__auto__.slice((0)),(0),null)):null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(argseq__9675__auto__);
});

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
cljs.core.apply.call(null,cljs.compiler.emits,xs);

var _STAR_flush_on_newline_STAR_12331_12338 = cljs.core._STAR_flush_on_newline_STAR_;
cljs.core._STAR_flush_on_newline_STAR_ = false;

try{cljs.core.println.call(null);
}finally {cljs.core._STAR_flush_on_newline_STAR_ = _STAR_flush_on_newline_STAR_12331_12338;
}
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (p__12332){
var map__12333 = p__12332;
var map__12333__$1 = ((((!((map__12333 == null)))?((((map__12333.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12333.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12333):map__12333);
var m = map__12333__$1;
var gen_line = cljs.core.get.call(null,map__12333__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0));
}));
} else {
}

return null;
});

cljs.compiler.emitln.cljs$lang$maxFixedArity = (0);

cljs.compiler.emitln.cljs$lang$applyTo = (function (seq12330){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq12330));
});

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__9515__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_12339_12341 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_12340_12342 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_12339_12341,_STAR_print_fn_STAR_12340_12342,sb__9515__auto__){
return (function (x__9516__auto__){
return sb__9515__auto__.append(x__9516__auto__);
});})(_STAR_print_newline_STAR_12339_12341,_STAR_print_fn_STAR_12340_12342,sb__9515__auto__))
;

try{cljs.compiler.emit.call(null,expr);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_12340_12342;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_12339_12341;
}
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__9515__auto__)].join('');
});
if(typeof cljs.compiler.emit_constant !== 'undefined'){
} else {
cljs.compiler.emit_constant = (function (){var method_table__9443__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__9444__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__9445__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__9446__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__9447__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit-constant"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__9447__auto__,method_table__9443__auto__,prefer_table__9444__auto__,method_cache__9445__auto__,cached_hierarchy__9446__auto__));
})();
}
cljs.core._add_method.call(null,cljs.compiler.emit_constant,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.call(null,["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,x))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type.call(null,x)], null));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,null,(function (x){
return cljs.compiler.emits.call(null,"null");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.call(null,"NaN");
} else {
if(cljs.core.not.call(null,isFinite(x))){
return cljs.compiler.emits.call(null,(((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.call(null,"(",x,")");

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,String,(function (x){
return cljs.compiler.emits.call(null,cljs.compiler.wrap_in_double_quotes.call(null,cljs.compiler.escape_string.call(null,x)));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,Boolean,(function (x){
return cljs.compiler.emits.call(null,(cljs.core.truth_(x)?"true":"false"));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,RegExp,(function (x){
if(cljs.core._EQ_.call(null,"",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''))){
return cljs.compiler.emits.call(null,"(new RegExp(\"\"))");
} else {
var vec__12343 = cljs.core.re_find.call(null,/^(?:\(\?([idmsux]*)\))?(.*)/,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''));
var _ = cljs.core.nth.call(null,vec__12343,(0),null);
var flags = cljs.core.nth.call(null,vec__12343,(1),null);
var pattern = cljs.core.nth.call(null,vec__12343,(2),null);
return cljs.compiler.emits.call(null,pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace.call(null,kw);
var name = cljs.core.name.call(null,kw);
cljs.compiler.emits.call(null,"new cljs.core.Keyword(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,(cljs.core.truth_(ns)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):name));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,kw));

return cljs.compiler.emits.call(null,")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace.call(null,sym);
var name = cljs.core.name.call(null,sym);
var symstr = ((!((ns == null)))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):name);
cljs.compiler.emits.call(null,"new cljs.core.Symbol(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,symstr);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,sym));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,null);

return cljs.compiler.emits.call(null,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant,cljs.core.Keyword,(function (x){
var temp__5455__auto__ = (function (){var and__8376__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__8376__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__8376__auto__;
}
})();
if(cljs.core.truth_(temp__5455__auto__)){
var value = temp__5455__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_keyword.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,cljs.core.Symbol,(function (x){
var temp__5455__auto__ = (function (){var and__8376__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__8376__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__8376__auto__;
}
})();
if(cljs.core.truth_(temp__5455__auto__)){
var value = temp__5455__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_symbol.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,Date,(function (date){
return cljs.compiler.emits.call(null,"new Date(",date.getTime(),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.call(null,"new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash.call(null,uuid_str),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"var","var",-769682797),(function (p__12347){
var map__12348 = p__12347;
var map__12348__$1 = ((((!((map__12348 == null)))?((((map__12348.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12348.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12348):map__12348);
var ast = map__12348__$1;
var info = cljs.core.get.call(null,map__12348__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.call(null,map__12348__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.call(null,map__12348__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5455__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5455__auto__)){
var const_expr = temp__5455__auto__;
return cljs.compiler.emit.call(null,cljs.core.assoc.call(null,const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__12350 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__12350__$1 = ((((!((map__12350 == null)))?((((map__12350.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12350.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12350):map__12350);
var cenv = map__12350__$1;
var options = cljs.core.get.call(null,map__12350__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.call(null,cljs.core.namespace.call(null,var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name.call(null,var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__8388__auto__ = js_module_name;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,ast));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__12352 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__8376__auto__ = cljs.compiler.es5_GT__EQ_.call(null,new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options));
if(cljs.core.truth_(and__8376__auto__)){
return !((cljs.core.namespace.call(null,var_name) == null));
} else {
return and__8376__auto__;
}
})())){
return clojure.set.difference.call(null,G__12352,cljs.analyzer.es5_allowed);
} else {
return G__12352;
}
})();
var env__12233__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,(function (){var G__12353 = info__$1;
if(cljs.core.not_EQ_.call(null,form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.call(null,G__12353,reserved);
} else {
return G__12353;
}
})());

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"var-special","var-special",1131576802),(function (p__12354){
var map__12355 = p__12354;
var map__12355__$1 = ((((!((map__12355 == null)))?((((map__12355.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12355.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12355):map__12355);
var arg = map__12355__$1;
var env = cljs.core.get.call(null,map__12355__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.call(null,map__12355__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.call(null,map__12355__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.call(null,map__12355__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_.call(null,sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_.call(null,meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__12357 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__12357__$1 = ((((!((map__12357 == null)))?((((map__12357.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12357.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12357):map__12357);
var name = cljs.core.get.call(null,map__12357__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__12233__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"new cljs.core.Var(function(){return ",cljs.compiler.munge.call(null,name),";},",sym,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),(function (p__12359){
var map__12360 = p__12359;
var map__12360__$1 = ((((!((map__12360 == null)))?((((map__12360.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12360.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12360):map__12360);
var expr = cljs.core.get.call(null,map__12360__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.call(null,map__12360__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.call(null,map__12360__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__12233__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"cljs.core.with_meta(",expr,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.array_map_threshold = (8);
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
return (cljs.core.every_QMARK_.call(null,(function (p1__12362_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__12362_SHARP_),new cljs.core.Keyword(null,"constant","constant",-379609303));
}),keys)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,keys)),cljs.core.count.call(null,keys)));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__12363){
var map__12364 = p__12363;
var map__12364__$1 = ((((!((map__12364 == null)))?((((map__12364.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12364.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12364):map__12364);
var env = cljs.core.get.call(null,map__12364__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.call(null,map__12364__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__12364__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__12233__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if((cljs.core.count.call(null,keys) === (0))){
cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count.call(null,keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_(cljs.compiler.distinct_keys_QMARK_.call(null,keys))){
cljs.compiler.emits.call(null,"new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,keys),", [",cljs.compiler.comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"], null)");
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.createAsIfByAssoc([",cljs.compiler.comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"])");
}
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentHashMap.fromArrays([",cljs.compiler.comma_sep.call(null,keys),"],[",cljs.compiler.comma_sep.call(null,vals),"])");

}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"list","list",765357683),(function (p__12366){
var map__12367 = p__12366;
var map__12367__$1 = ((((!((map__12367 == null)))?((((map__12367.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12367.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12367):map__12367);
var items = cljs.core.get.call(null,map__12367__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__12367__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__12233__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.empty_QMARK_.call(null,items)){
cljs.compiler.emits.call(null,"cljs.core.List.EMPTY");
} else {
cljs.compiler.emits.call(null,"cljs.core.list(",cljs.compiler.comma_sep.call(null,items),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__12369){
var map__12370 = p__12369;
var map__12370__$1 = ((((!((map__12370 == null)))?((((map__12370.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12370.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12370):map__12370);
var items = cljs.core.get.call(null,map__12370__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__12370__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__12233__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.empty_QMARK_.call(null,items)){
cljs.compiler.emits.call(null,"cljs.core.PersistentVector.EMPTY");
} else {
var cnt_12372 = cljs.core.count.call(null,items);
if((cnt_12372 < (32))){
cljs.compiler.emits.call(null,"new cljs.core.PersistentVector(null, ",cnt_12372,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",cljs.compiler.comma_sep.call(null,items),"], null)");
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentVector.fromArray([",cljs.compiler.comma_sep.call(null,items),"], true)");
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
return (cljs.core.every_QMARK_.call(null,(function (p1__12373_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__12373_SHARP_),new cljs.core.Keyword(null,"constant","constant",-379609303));
}),items)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,items)),cljs.core.count.call(null,items)));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set","set",304602554),(function (p__12374){
var map__12375 = p__12374;
var map__12375__$1 = ((((!((map__12375 == null)))?((((map__12375.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12375.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12375):map__12375);
var items = cljs.core.get.call(null,map__12375__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__12375__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__12233__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.empty_QMARK_.call(null,items)){
cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_(cljs.compiler.distinct_constants_QMARK_.call(null,items))){
cljs.compiler.emits.call(null,"new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,items),", [",cljs.compiler.comma_sep.call(null,cljs.core.interleave.call(null,items,cljs.core.repeat.call(null,"null"))),"], null), null)");
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.createAsIfByAssoc([",cljs.compiler.comma_sep.call(null,items),"])");

}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-value","js-value",-758336661),(function (p__12377){
var map__12378 = p__12377;
var map__12378__$1 = ((((!((map__12378 == null)))?((((map__12378.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12378.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12378):map__12378);
var items = cljs.core.get.call(null,map__12378__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var js_type = cljs.core.get.call(null,map__12378__$1,new cljs.core.Keyword(null,"js-type","js-type",539386702));
var env = cljs.core.get.call(null,map__12378__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__12233__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core._EQ_.call(null,js_type,new cljs.core.Keyword(null,"object","object",1474613949))){
cljs.compiler.emits.call(null,"({");

var temp__5457__auto___12396 = cljs.core.seq.call(null,items);
if(temp__5457__auto___12396){
var items_12397__$1 = temp__5457__auto___12396;
var vec__12380_12398 = items_12397__$1;
var seq__12381_12399 = cljs.core.seq.call(null,vec__12380_12398);
var first__12382_12400 = cljs.core.first.call(null,seq__12381_12399);
var seq__12381_12401__$1 = cljs.core.next.call(null,seq__12381_12399);
var vec__12383_12402 = first__12382_12400;
var k_12403 = cljs.core.nth.call(null,vec__12383_12402,(0),null);
var v_12404 = cljs.core.nth.call(null,vec__12383_12402,(1),null);
var r_12405 = seq__12381_12401__$1;
cljs.compiler.emits.call(null,"\"",cljs.core.name.call(null,k_12403),"\": ",v_12404);

var seq__12386_12406 = cljs.core.seq.call(null,r_12405);
var chunk__12387_12407 = null;
var count__12388_12408 = (0);
var i__12389_12409 = (0);
while(true){
if((i__12389_12409 < count__12388_12408)){
var vec__12390_12410 = cljs.core._nth.call(null,chunk__12387_12407,i__12389_12409);
var k_12411__$1 = cljs.core.nth.call(null,vec__12390_12410,(0),null);
var v_12412__$1 = cljs.core.nth.call(null,vec__12390_12410,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_12411__$1),"\": ",v_12412__$1);

var G__12413 = seq__12386_12406;
var G__12414 = chunk__12387_12407;
var G__12415 = count__12388_12408;
var G__12416 = (i__12389_12409 + (1));
seq__12386_12406 = G__12413;
chunk__12387_12407 = G__12414;
count__12388_12408 = G__12415;
i__12389_12409 = G__12416;
continue;
} else {
var temp__5457__auto___12417__$1 = cljs.core.seq.call(null,seq__12386_12406);
if(temp__5457__auto___12417__$1){
var seq__12386_12418__$1 = temp__5457__auto___12417__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12386_12418__$1)){
var c__9319__auto___12419 = cljs.core.chunk_first.call(null,seq__12386_12418__$1);
var G__12420 = cljs.core.chunk_rest.call(null,seq__12386_12418__$1);
var G__12421 = c__9319__auto___12419;
var G__12422 = cljs.core.count.call(null,c__9319__auto___12419);
var G__12423 = (0);
seq__12386_12406 = G__12420;
chunk__12387_12407 = G__12421;
count__12388_12408 = G__12422;
i__12389_12409 = G__12423;
continue;
} else {
var vec__12393_12424 = cljs.core.first.call(null,seq__12386_12418__$1);
var k_12425__$1 = cljs.core.nth.call(null,vec__12393_12424,(0),null);
var v_12426__$1 = cljs.core.nth.call(null,vec__12393_12424,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_12425__$1),"\": ",v_12426__$1);

var G__12427 = cljs.core.next.call(null,seq__12386_12418__$1);
var G__12428 = null;
var G__12429 = (0);
var G__12430 = (0);
seq__12386_12406 = G__12427;
chunk__12387_12407 = G__12428;
count__12388_12408 = G__12429;
i__12389_12409 = G__12430;
continue;
}
} else {
}
}
break;
}
} else {
}

cljs.compiler.emits.call(null,"})");
} else {
cljs.compiler.emits.call(null,"[",cljs.compiler.comma_sep.call(null,items),"]");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"record-value","record-value",-367500392),(function (p__12431){
var map__12432 = p__12431;
var map__12432__$1 = ((((!((map__12432 == null)))?((((map__12432.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12432.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12432):map__12432);
var items = cljs.core.get.call(null,map__12432__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var ns = cljs.core.get.call(null,map__12432__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var name = cljs.core.get.call(null,map__12432__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__12432__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__12233__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,ns,".map__GT_",name,"(",items,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"constant","constant",-379609303),(function (p__12434){
var map__12435 = p__12434;
var map__12435__$1 = ((((!((map__12435 == null)))?((((map__12435.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12435.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12435):map__12435);
var form = cljs.core.get.call(null,map__12435__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.call(null,map__12435__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__12233__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_constant.call(null,form);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(p__12437){
var map__12438 = p__12437;
var map__12438__$1 = ((((!((map__12438 == null)))?((((map__12438.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12438.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12438):map__12438);
var op = cljs.core.get.call(null,map__12438__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__12438__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__12438__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__8388__auto__ = (function (){var and__8376__auto__ = cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"constant","constant",-379609303));
if(and__8376__auto__){
var and__8376__auto____$1 = form;
if(cljs.core.truth_(and__8376__auto____$1)){
return !(((typeof form === 'string') && (cljs.core._EQ_.call(null,form,""))) || ((typeof form === 'number') && ((form === (0)))));
} else {
return and__8376__auto____$1;
}
} else {
return and__8376__auto__;
}
})();
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
var and__8376__auto__ = !((const_expr == null));
if(and__8376__auto__){
return cljs.compiler.truthy_constant_QMARK_.call(null,const_expr);
} else {
return and__8376__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(p__12440){
var map__12441 = p__12440;
var map__12441__$1 = ((((!((map__12441 == null)))?((((map__12441.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12441.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12441):map__12441);
var op = cljs.core.get.call(null,map__12441__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__12441__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__12441__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__8388__auto__ = (cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"constant","constant",-379609303))) && ((form === false) || ((form == null)));
if(or__8388__auto__){
return or__8388__auto__;
} else {
var and__8376__auto__ = !((const_expr == null));
if(and__8376__auto__){
return cljs.compiler.falsey_constant_QMARK_.call(null,const_expr);
} else {
return and__8376__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag.call(null,env,e);
var or__8388__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null).call(null,tag);
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_.call(null,e);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__12443){
var map__12444 = p__12443;
var map__12444__$1 = ((((!((map__12444 == null)))?((((map__12444.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12444.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12444):map__12444);
var test = cljs.core.get.call(null,map__12444__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.call(null,map__12444__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.call(null,map__12444__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.call(null,map__12444__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.call(null,map__12444__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not.call(null,(function (){var or__8388__auto__ = unchecked;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return cljs.compiler.safe_test_QMARK_.call(null,env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,else$);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"(",((checked)?"cljs.core.truth_":null),"(",test,")?",then,":",else$,")");
} else {
if(checked){
cljs.compiler.emitln.call(null,"if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.call(null,"if(",test,"){");
}

cljs.compiler.emitln.call(null,then,"} else {");

return cljs.compiler.emitln.call(null,else$,"}");
}

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"case*","case*",716180697),(function (p__12446){
var map__12447 = p__12446;
var map__12447__$1 = ((((!((map__12447 == null)))?((((map__12447.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12447.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12447):map__12447);
var v = cljs.core.get.call(null,map__12447__$1,new cljs.core.Keyword(null,"v","v",21465059));
var tests = cljs.core.get.call(null,map__12447__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var thens = cljs.core.get.call(null,map__12447__$1,new cljs.core.Keyword(null,"thens","thens",226631442));
var default$ = cljs.core.get.call(null,map__12447__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.call(null,map__12447__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.call(null,"(function(){");
} else {
}

var gs = cljs.core.gensym.call(null,"caseval__");
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"var ",gs,";");
} else {
}

cljs.compiler.emitln.call(null,"switch (",v,") {");

var seq__12449_12467 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),cljs.core.interleave.call(null,tests,thens)));
var chunk__12450_12468 = null;
var count__12451_12469 = (0);
var i__12452_12470 = (0);
while(true){
if((i__12452_12470 < count__12451_12469)){
var vec__12453_12471 = cljs.core._nth.call(null,chunk__12450_12468,i__12452_12470);
var ts_12472 = cljs.core.nth.call(null,vec__12453_12471,(0),null);
var then_12473 = cljs.core.nth.call(null,vec__12453_12471,(1),null);
var seq__12456_12474 = cljs.core.seq.call(null,ts_12472);
var chunk__12457_12475 = null;
var count__12458_12476 = (0);
var i__12459_12477 = (0);
while(true){
if((i__12459_12477 < count__12458_12476)){
var test_12478 = cljs.core._nth.call(null,chunk__12457_12475,i__12459_12477);
cljs.compiler.emitln.call(null,"case ",test_12478,":");

var G__12479 = seq__12456_12474;
var G__12480 = chunk__12457_12475;
var G__12481 = count__12458_12476;
var G__12482 = (i__12459_12477 + (1));
seq__12456_12474 = G__12479;
chunk__12457_12475 = G__12480;
count__12458_12476 = G__12481;
i__12459_12477 = G__12482;
continue;
} else {
var temp__5457__auto___12483 = cljs.core.seq.call(null,seq__12456_12474);
if(temp__5457__auto___12483){
var seq__12456_12484__$1 = temp__5457__auto___12483;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12456_12484__$1)){
var c__9319__auto___12485 = cljs.core.chunk_first.call(null,seq__12456_12484__$1);
var G__12486 = cljs.core.chunk_rest.call(null,seq__12456_12484__$1);
var G__12487 = c__9319__auto___12485;
var G__12488 = cljs.core.count.call(null,c__9319__auto___12485);
var G__12489 = (0);
seq__12456_12474 = G__12486;
chunk__12457_12475 = G__12487;
count__12458_12476 = G__12488;
i__12459_12477 = G__12489;
continue;
} else {
var test_12490 = cljs.core.first.call(null,seq__12456_12484__$1);
cljs.compiler.emitln.call(null,"case ",test_12490,":");

var G__12491 = cljs.core.next.call(null,seq__12456_12484__$1);
var G__12492 = null;
var G__12493 = (0);
var G__12494 = (0);
seq__12456_12474 = G__12491;
chunk__12457_12475 = G__12492;
count__12458_12476 = G__12493;
i__12459_12477 = G__12494;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_12473);
} else {
cljs.compiler.emitln.call(null,then_12473);
}

cljs.compiler.emitln.call(null,"break;");

var G__12495 = seq__12449_12467;
var G__12496 = chunk__12450_12468;
var G__12497 = count__12451_12469;
var G__12498 = (i__12452_12470 + (1));
seq__12449_12467 = G__12495;
chunk__12450_12468 = G__12496;
count__12451_12469 = G__12497;
i__12452_12470 = G__12498;
continue;
} else {
var temp__5457__auto___12499 = cljs.core.seq.call(null,seq__12449_12467);
if(temp__5457__auto___12499){
var seq__12449_12500__$1 = temp__5457__auto___12499;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12449_12500__$1)){
var c__9319__auto___12501 = cljs.core.chunk_first.call(null,seq__12449_12500__$1);
var G__12502 = cljs.core.chunk_rest.call(null,seq__12449_12500__$1);
var G__12503 = c__9319__auto___12501;
var G__12504 = cljs.core.count.call(null,c__9319__auto___12501);
var G__12505 = (0);
seq__12449_12467 = G__12502;
chunk__12450_12468 = G__12503;
count__12451_12469 = G__12504;
i__12452_12470 = G__12505;
continue;
} else {
var vec__12460_12506 = cljs.core.first.call(null,seq__12449_12500__$1);
var ts_12507 = cljs.core.nth.call(null,vec__12460_12506,(0),null);
var then_12508 = cljs.core.nth.call(null,vec__12460_12506,(1),null);
var seq__12463_12509 = cljs.core.seq.call(null,ts_12507);
var chunk__12464_12510 = null;
var count__12465_12511 = (0);
var i__12466_12512 = (0);
while(true){
if((i__12466_12512 < count__12465_12511)){
var test_12513 = cljs.core._nth.call(null,chunk__12464_12510,i__12466_12512);
cljs.compiler.emitln.call(null,"case ",test_12513,":");

var G__12514 = seq__12463_12509;
var G__12515 = chunk__12464_12510;
var G__12516 = count__12465_12511;
var G__12517 = (i__12466_12512 + (1));
seq__12463_12509 = G__12514;
chunk__12464_12510 = G__12515;
count__12465_12511 = G__12516;
i__12466_12512 = G__12517;
continue;
} else {
var temp__5457__auto___12518__$1 = cljs.core.seq.call(null,seq__12463_12509);
if(temp__5457__auto___12518__$1){
var seq__12463_12519__$1 = temp__5457__auto___12518__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12463_12519__$1)){
var c__9319__auto___12520 = cljs.core.chunk_first.call(null,seq__12463_12519__$1);
var G__12521 = cljs.core.chunk_rest.call(null,seq__12463_12519__$1);
var G__12522 = c__9319__auto___12520;
var G__12523 = cljs.core.count.call(null,c__9319__auto___12520);
var G__12524 = (0);
seq__12463_12509 = G__12521;
chunk__12464_12510 = G__12522;
count__12465_12511 = G__12523;
i__12466_12512 = G__12524;
continue;
} else {
var test_12525 = cljs.core.first.call(null,seq__12463_12519__$1);
cljs.compiler.emitln.call(null,"case ",test_12525,":");

var G__12526 = cljs.core.next.call(null,seq__12463_12519__$1);
var G__12527 = null;
var G__12528 = (0);
var G__12529 = (0);
seq__12463_12509 = G__12526;
chunk__12464_12510 = G__12527;
count__12465_12511 = G__12528;
i__12466_12512 = G__12529;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_12508);
} else {
cljs.compiler.emitln.call(null,then_12508);
}

cljs.compiler.emitln.call(null,"break;");

var G__12530 = cljs.core.next.call(null,seq__12449_12500__$1);
var G__12531 = null;
var G__12532 = (0);
var G__12533 = (0);
seq__12449_12467 = G__12530;
chunk__12450_12468 = G__12531;
count__12451_12469 = G__12532;
i__12452_12470 = G__12533;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.call(null,"default:");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",default$);
} else {
cljs.compiler.emitln.call(null,default$);
}
} else {
}

cljs.compiler.emitln.call(null,"}");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"return ",gs,";})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__12534){
var map__12535 = p__12534;
var map__12535__$1 = ((((!((map__12535 == null)))?((((map__12535.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12535.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12535):map__12535);
var throw$ = cljs.core.get.call(null,map__12535__$1,new cljs.core.Keyword(null,"throw","throw",-1044625833));
var env = cljs.core.get.call(null,map__12535__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.call(null,"(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.call(null,"throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.mapped_types,t))){
return cljs.core.get.call(null,cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(1))))].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__12538 = ((!(((-1) === idx)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.call(null,t,(0),idx),cljs.core.subs.call(null,t,(idx + (1)),cljs.core.count.call(null,t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.call(null,vec__12538,(0),null);
var rstr = cljs.core.nth.call(null,vec__12538,(1),null);
var ret_t = (cljs.core.truth_(rstr)?cljs.compiler.resolve_type.call(null,env,rstr):null);
var axstr = cljs.core.subs.call(null,fstr,(9),(cljs.core.count.call(null,fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_.call(null,axstr))?null:cljs.core.map.call(null,cljs.core.comp.call(null,((function (idx,vec__12538,fstr,rstr,ret_t,axstr){
return (function (p1__12537_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__12537_SHARP_);
});})(idx,vec__12538,fstr,rstr,ret_t,axstr))
,clojure.string.trim),clojure.string.split.call(null,axstr,/,/)));
var G__12541 = ["function(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null,",",args_ts)),")"].join('');
if(cljs.core.truth_(ret_t)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__12541),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__12541;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(0),(cljs.core.count.call(null,t) - (1))))),"="].join('');
} else {
return cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,env,cljs.core.symbol.call(null,t))))].join(''));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.call(null,clojure.string.trim.call(null,ts),(1),(cljs.core.count.call(null,ts) - (1)));
var xs = clojure.string.split.call(null,ts__$1,/\|/);
return ["{",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null,"|",cljs.core.map.call(null,((function (ts__$1,xs){
return (function (p1__12542_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__12542_SHARP_);
});})(ts__$1,xs))
,xs))),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find.call(null,/@param/,line))){
var vec__12543 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__12544 = cljs.core.seq.call(null,vec__12543);
var first__12545 = cljs.core.first.call(null,seq__12544);
var seq__12544__$1 = cljs.core.next.call(null,seq__12544);
var p = first__12545;
var first__12545__$1 = cljs.core.first.call(null,seq__12544__$1);
var seq__12544__$2 = cljs.core.next.call(null,seq__12544__$1);
var ts = first__12545__$1;
var first__12545__$2 = cljs.core.first.call(null,seq__12544__$2);
var seq__12544__$3 = cljs.core.next.call(null,seq__12544__$2);
var n = first__12545__$2;
var xs = seq__12544__$3;
if(cljs.core.truth_((function (){var and__8376__auto__ = cljs.core._EQ_.call(null,"@param",p);
if(and__8376__auto__){
var and__8376__auto____$1 = ts;
if(cljs.core.truth_(and__8376__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__8376__auto____$1;
}
} else {
return and__8376__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts),cljs.compiler.munge.call(null,n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find.call(null,/@return/,line))){
var vec__12546 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__12547 = cljs.core.seq.call(null,vec__12546);
var first__12548 = cljs.core.first.call(null,seq__12547);
var seq__12547__$1 = cljs.core.next.call(null,seq__12547);
var p = first__12548;
var first__12548__$1 = cljs.core.first.call(null,seq__12547__$1);
var seq__12547__$2 = cljs.core.next.call(null,seq__12547__$1);
var ts = first__12548__$1;
var xs = seq__12547__$2;
if(cljs.core.truth_((function (){var and__8376__auto__ = cljs.core._EQ_.call(null,"@return",p);
if(and__8376__auto__){
var and__8376__auto____$1 = ts;
if(cljs.core.truth_(and__8376__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__8376__auto____$1;
}
} else {
return and__8376__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null).call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null)));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__12551 = arguments.length;
switch (G__12551) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.call(null,null,doc,jsdoc);
});

cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.call(null,docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = ((function (docs,docs__$1,docs__$2){
return (function cljs$compiler$print_comment_lines(e){
var vec__12559 = cljs.core.map.call(null,((function (docs,docs__$1,docs__$2){
return (function (p1__12549_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_.call(null))){
return cljs.compiler.munge_param_return.call(null,env,p1__12549_SHARP_);
} else {
return p1__12549_SHARP_;
}
});})(docs,docs__$1,docs__$2))
,clojure.string.split_lines.call(null,e));
var seq__12560 = cljs.core.seq.call(null,vec__12559);
var first__12561 = cljs.core.first.call(null,seq__12560);
var seq__12560__$1 = cljs.core.next.call(null,seq__12560);
var x = first__12561;
var ys = seq__12560__$1;
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,x,"*/","* /"));

var seq__12562 = cljs.core.seq.call(null,ys);
var chunk__12563 = null;
var count__12564 = (0);
var i__12565 = (0);
while(true){
if((i__12565 < count__12564)){
var next_line = cljs.core._nth.call(null,chunk__12563,i__12565);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));

var G__12571 = seq__12562;
var G__12572 = chunk__12563;
var G__12573 = count__12564;
var G__12574 = (i__12565 + (1));
seq__12562 = G__12571;
chunk__12563 = G__12572;
count__12564 = G__12573;
i__12565 = G__12574;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__12562);
if(temp__5457__auto__){
var seq__12562__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12562__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__12562__$1);
var G__12575 = cljs.core.chunk_rest.call(null,seq__12562__$1);
var G__12576 = c__9319__auto__;
var G__12577 = cljs.core.count.call(null,c__9319__auto__);
var G__12578 = (0);
seq__12562 = G__12575;
chunk__12563 = G__12576;
count__12564 = G__12577;
i__12565 = G__12578;
continue;
} else {
var next_line = cljs.core.first.call(null,seq__12562__$1);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));

var G__12579 = cljs.core.next.call(null,seq__12562__$1);
var G__12580 = null;
var G__12581 = (0);
var G__12582 = (0);
seq__12562 = G__12579;
chunk__12563 = G__12580;
count__12564 = G__12581;
i__12565 = G__12582;
continue;
}
} else {
return null;
}
}
break;
}
});})(docs,docs__$1,docs__$2))
;
if(cljs.core.seq.call(null,docs__$2)){
cljs.compiler.emitln.call(null,"/**");

var seq__12566_12583 = cljs.core.seq.call(null,docs__$2);
var chunk__12567_12584 = null;
var count__12568_12585 = (0);
var i__12569_12586 = (0);
while(true){
if((i__12569_12586 < count__12568_12585)){
var e_12587 = cljs.core._nth.call(null,chunk__12567_12584,i__12569_12586);
if(cljs.core.truth_(e_12587)){
print_comment_lines.call(null,e_12587);
} else {
}

var G__12588 = seq__12566_12583;
var G__12589 = chunk__12567_12584;
var G__12590 = count__12568_12585;
var G__12591 = (i__12569_12586 + (1));
seq__12566_12583 = G__12588;
chunk__12567_12584 = G__12589;
count__12568_12585 = G__12590;
i__12569_12586 = G__12591;
continue;
} else {
var temp__5457__auto___12592 = cljs.core.seq.call(null,seq__12566_12583);
if(temp__5457__auto___12592){
var seq__12566_12593__$1 = temp__5457__auto___12592;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12566_12593__$1)){
var c__9319__auto___12594 = cljs.core.chunk_first.call(null,seq__12566_12593__$1);
var G__12595 = cljs.core.chunk_rest.call(null,seq__12566_12593__$1);
var G__12596 = c__9319__auto___12594;
var G__12597 = cljs.core.count.call(null,c__9319__auto___12594);
var G__12598 = (0);
seq__12566_12583 = G__12595;
chunk__12567_12584 = G__12596;
count__12568_12585 = G__12597;
i__12569_12586 = G__12598;
continue;
} else {
var e_12599 = cljs.core.first.call(null,seq__12566_12593__$1);
if(cljs.core.truth_(e_12599)){
print_comment_lines.call(null,e_12599);
} else {
}

var G__12600 = cljs.core.next.call(null,seq__12566_12593__$1);
var G__12601 = null;
var G__12602 = (0);
var G__12603 = (0);
seq__12566_12583 = G__12600;
chunk__12567_12584 = G__12601;
count__12568_12585 = G__12602;
i__12569_12586 = G__12603;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.call(null," */");
} else {
return null;
}
});

cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3;

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return (typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number');
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__8376__auto__ = cljs.core.some.call(null,((function (opts){
return (function (p1__12605_SHARP_){
return goog.string.startsWith(p1__12605_SHARP_,"@define");
});})(opts))
,jsdoc);
if(cljs.core.truth_(and__8376__auto__)){
var and__8376__auto____$1 = opts;
if(cljs.core.truth_(and__8376__auto____$1)){
var and__8376__auto____$2 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478));
if(and__8376__auto____$2){
var define = cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)].join('')], null));
if(cljs.core.truth_(cljs.compiler.valid_define_value_QMARK_.call(null,define))){
return cljs.core.pr_str.call(null,define);
} else {
return null;
}
} else {
return and__8376__auto____$2;
}
} else {
return and__8376__auto____$1;
}
} else {
return and__8376__auto__;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__12606){
var map__12607 = p__12606;
var map__12607__$1 = ((((!((map__12607 == null)))?((((map__12607.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12607.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12607):map__12607);
var name = cljs.core.get.call(null,map__12607__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var var$ = cljs.core.get.call(null,map__12607__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var init = cljs.core.get.call(null,map__12607__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var env = cljs.core.get.call(null,map__12607__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var doc = cljs.core.get.call(null,map__12607__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.call(null,map__12607__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var export$ = cljs.core.get.call(null,map__12607__$1,new cljs.core.Keyword(null,"export","export",214356590));
var test = cljs.core.get.call(null,map__12607__$1,new cljs.core.Keyword(null,"test","test",577538877));
var var_ast = cljs.core.get.call(null,map__12607__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__8388__auto__ = init;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.call(null,name);
cljs.compiler.emit_comment.call(null,env,doc,cljs.core.concat.call(null,jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.call(null," = ",(function (){var temp__5455__auto__ = cljs.compiler.get_define.call(null,mname,jsdoc);
if(cljs.core.truth_(temp__5455__auto__)){
var define = temp__5455__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"; return (");

cljs.compiler.emits.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"var-special","var-special",1131576802),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast));

cljs.compiler.emitln.call(null,");})()");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,")");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.call(null,";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.call(null,"goog.exportSymbol('",cljs.compiler.munge.call(null,export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__8376__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(and__8376__auto__){
return test;
} else {
return and__8376__auto__;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,";");
} else {
}

return cljs.compiler.emitln.call(null,var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__12609){
var map__12610 = p__12609;
var map__12610__$1 = ((((!((map__12610 == null)))?((((map__12610.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12610.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12610):map__12610);
var name = cljs.core.get.call(null,map__12610__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__12610__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__12610__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.call(null,"arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,name)),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function (",arglist,"){");

var seq__12612_12630 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,cljs.core.vector,cljs.core.drop_last.call(null,(2),params)));
var chunk__12613_12631 = null;
var count__12614_12632 = (0);
var i__12615_12633 = (0);
while(true){
if((i__12615_12633 < count__12614_12632)){
var vec__12616_12634 = cljs.core._nth.call(null,chunk__12613_12631,i__12615_12633);
var i_12635 = cljs.core.nth.call(null,vec__12616_12634,(0),null);
var param_12636 = cljs.core.nth.call(null,vec__12616_12634,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_12636);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");

var G__12637 = seq__12612_12630;
var G__12638 = chunk__12613_12631;
var G__12639 = count__12614_12632;
var G__12640 = (i__12615_12633 + (1));
seq__12612_12630 = G__12637;
chunk__12613_12631 = G__12638;
count__12614_12632 = G__12639;
i__12615_12633 = G__12640;
continue;
} else {
var temp__5457__auto___12641 = cljs.core.seq.call(null,seq__12612_12630);
if(temp__5457__auto___12641){
var seq__12612_12642__$1 = temp__5457__auto___12641;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12612_12642__$1)){
var c__9319__auto___12643 = cljs.core.chunk_first.call(null,seq__12612_12642__$1);
var G__12644 = cljs.core.chunk_rest.call(null,seq__12612_12642__$1);
var G__12645 = c__9319__auto___12643;
var G__12646 = cljs.core.count.call(null,c__9319__auto___12643);
var G__12647 = (0);
seq__12612_12630 = G__12644;
chunk__12613_12631 = G__12645;
count__12614_12632 = G__12646;
i__12615_12633 = G__12647;
continue;
} else {
var vec__12619_12648 = cljs.core.first.call(null,seq__12612_12642__$1);
var i_12649 = cljs.core.nth.call(null,vec__12619_12648,(0),null);
var param_12650 = cljs.core.nth.call(null,vec__12619_12648,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_12650);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");

var G__12651 = cljs.core.next.call(null,seq__12612_12642__$1);
var G__12652 = null;
var G__12653 = (0);
var G__12654 = (0);
seq__12612_12630 = G__12651;
chunk__12613_12631 = G__12652;
count__12614_12632 = G__12653;
i__12615_12633 = G__12654;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count.call(null,params))){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,cljs.core.butlast.call(null,params)));

cljs.compiler.emitln.call(null," = cljs.core.first(",arglist,");");

cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.rest(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__12622_12655 = cljs.core.seq.call(null,params);
var chunk__12623_12656 = null;
var count__12624_12657 = (0);
var i__12625_12658 = (0);
while(true){
if((i__12625_12658 < count__12624_12657)){
var param_12659 = cljs.core._nth.call(null,chunk__12623_12656,i__12625_12658);
cljs.compiler.emit.call(null,param_12659);

if(cljs.core._EQ_.call(null,param_12659,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__12660 = seq__12622_12655;
var G__12661 = chunk__12623_12656;
var G__12662 = count__12624_12657;
var G__12663 = (i__12625_12658 + (1));
seq__12622_12655 = G__12660;
chunk__12623_12656 = G__12661;
count__12624_12657 = G__12662;
i__12625_12658 = G__12663;
continue;
} else {
var temp__5457__auto___12664 = cljs.core.seq.call(null,seq__12622_12655);
if(temp__5457__auto___12664){
var seq__12622_12665__$1 = temp__5457__auto___12664;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12622_12665__$1)){
var c__9319__auto___12666 = cljs.core.chunk_first.call(null,seq__12622_12665__$1);
var G__12667 = cljs.core.chunk_rest.call(null,seq__12622_12665__$1);
var G__12668 = c__9319__auto___12666;
var G__12669 = cljs.core.count.call(null,c__9319__auto___12666);
var G__12670 = (0);
seq__12622_12655 = G__12667;
chunk__12623_12656 = G__12668;
count__12624_12657 = G__12669;
i__12625_12658 = G__12670;
continue;
} else {
var param_12671 = cljs.core.first.call(null,seq__12622_12665__$1);
cljs.compiler.emit.call(null,param_12671);

if(cljs.core._EQ_.call(null,param_12671,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__12672 = cljs.core.next.call(null,seq__12622_12665__$1);
var G__12673 = null;
var G__12674 = (0);
var G__12675 = (0);
seq__12622_12655 = G__12672;
chunk__12623_12656 = G__12673;
count__12624_12657 = G__12674;
i__12625_12658 = G__12675;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
} else {
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.seq(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__12626_12676 = cljs.core.seq.call(null,params);
var chunk__12627_12677 = null;
var count__12628_12678 = (0);
var i__12629_12679 = (0);
while(true){
if((i__12629_12679 < count__12628_12678)){
var param_12680 = cljs.core._nth.call(null,chunk__12627_12677,i__12629_12679);
cljs.compiler.emit.call(null,param_12680);

if(cljs.core._EQ_.call(null,param_12680,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__12681 = seq__12626_12676;
var G__12682 = chunk__12627_12677;
var G__12683 = count__12628_12678;
var G__12684 = (i__12629_12679 + (1));
seq__12626_12676 = G__12681;
chunk__12627_12677 = G__12682;
count__12628_12678 = G__12683;
i__12629_12679 = G__12684;
continue;
} else {
var temp__5457__auto___12685 = cljs.core.seq.call(null,seq__12626_12676);
if(temp__5457__auto___12685){
var seq__12626_12686__$1 = temp__5457__auto___12685;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12626_12686__$1)){
var c__9319__auto___12687 = cljs.core.chunk_first.call(null,seq__12626_12686__$1);
var G__12688 = cljs.core.chunk_rest.call(null,seq__12626_12686__$1);
var G__12689 = c__9319__auto___12687;
var G__12690 = cljs.core.count.call(null,c__9319__auto___12687);
var G__12691 = (0);
seq__12626_12676 = G__12688;
chunk__12627_12677 = G__12689;
count__12628_12678 = G__12690;
i__12629_12679 = G__12691;
continue;
} else {
var param_12692 = cljs.core.first.call(null,seq__12626_12686__$1);
cljs.compiler.emit.call(null,param_12692);

if(cljs.core._EQ_.call(null,param_12692,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__12693 = cljs.core.next.call(null,seq__12626_12686__$1);
var G__12694 = null;
var G__12695 = (0);
var G__12696 = (0);
seq__12626_12676 = G__12693;
chunk__12627_12677 = G__12694;
count__12628_12678 = G__12695;
i__12629_12679 = G__12696;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__12697 = cljs.core.seq.call(null,params);
var chunk__12698 = null;
var count__12699 = (0);
var i__12700 = (0);
while(true){
if((i__12700 < count__12699)){
var param = cljs.core._nth.call(null,chunk__12698,i__12700);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__12701 = seq__12697;
var G__12702 = chunk__12698;
var G__12703 = count__12699;
var G__12704 = (i__12700 + (1));
seq__12697 = G__12701;
chunk__12698 = G__12702;
count__12699 = G__12703;
i__12700 = G__12704;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__12697);
if(temp__5457__auto__){
var seq__12697__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12697__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__12697__$1);
var G__12705 = cljs.core.chunk_rest.call(null,seq__12697__$1);
var G__12706 = c__9319__auto__;
var G__12707 = cljs.core.count.call(null,c__9319__auto__);
var G__12708 = (0);
seq__12697 = G__12705;
chunk__12698 = G__12706;
count__12699 = G__12707;
i__12700 = G__12708;
continue;
} else {
var param = cljs.core.first.call(null,seq__12697__$1);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__12709 = cljs.core.next.call(null,seq__12697__$1);
var G__12710 = null;
var G__12711 = (0);
var G__12712 = (0);
seq__12697 = G__12709;
chunk__12698 = G__12710;
count__12699 = G__12711;
i__12700 = G__12712;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__12713){
var map__12714 = p__12713;
var map__12714__$1 = ((((!((map__12714 == null)))?((((map__12714.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12714.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12714):map__12714);
var type = cljs.core.get.call(null,map__12714__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__12714__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var variadic = cljs.core.get.call(null,map__12714__$1,new cljs.core.Keyword(null,"variadic","variadic",882626057));
var params = cljs.core.get.call(null,map__12714__$1,new cljs.core.Keyword(null,"params","params",710516235));
var expr = cljs.core.get.call(null,map__12714__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__12714__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__12714__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var max_fixed_arity = cljs.core.get.call(null,map__12714__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var env__12233__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(function ",cljs.compiler.munge.call(null,name),"(");

cljs.compiler.emit_fn_params.call(null,params);

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emits.call(null,"})");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if(((startslice >= (0))) && (cljs.core.integer_QMARK_.call(null,startslice))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.call(null,"var ",i," = 0, ",a," = new Array(arguments.length -  ",startslice,");");

cljs.compiler.emitln.call(null,"while (",i," < ",a,".length) {",a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}");

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__12716){
var map__12717 = p__12716;
var map__12717__$1 = ((((!((map__12717 == null)))?((((map__12717.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12717.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12717):map__12717);
var f = map__12717__$1;
var type = cljs.core.get.call(null,map__12717__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__12717__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var variadic = cljs.core.get.call(null,map__12717__$1,new cljs.core.Keyword(null,"variadic","variadic",882626057));
var params = cljs.core.get.call(null,map__12717__$1,new cljs.core.Keyword(null,"params","params",710516235));
var expr = cljs.core.get.call(null,map__12717__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__12717__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__12717__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var max_fixed_arity = cljs.core.get.call(null,map__12717__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var env__12233__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var name_12727__$1 = (function (){var or__8388__auto__ = name;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_12728 = cljs.compiler.munge.call(null,name_12727__$1);
var delegate_name_12729 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_12728),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function() { ");

cljs.compiler.emits.call(null,"var ",delegate_name_12729," = function (");

var seq__12719_12730 = cljs.core.seq.call(null,params);
var chunk__12720_12731 = null;
var count__12721_12732 = (0);
var i__12722_12733 = (0);
while(true){
if((i__12722_12733 < count__12721_12732)){
var param_12734 = cljs.core._nth.call(null,chunk__12720_12731,i__12722_12733);
cljs.compiler.emit.call(null,param_12734);

if(cljs.core._EQ_.call(null,param_12734,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__12735 = seq__12719_12730;
var G__12736 = chunk__12720_12731;
var G__12737 = count__12721_12732;
var G__12738 = (i__12722_12733 + (1));
seq__12719_12730 = G__12735;
chunk__12720_12731 = G__12736;
count__12721_12732 = G__12737;
i__12722_12733 = G__12738;
continue;
} else {
var temp__5457__auto___12739 = cljs.core.seq.call(null,seq__12719_12730);
if(temp__5457__auto___12739){
var seq__12719_12740__$1 = temp__5457__auto___12739;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12719_12740__$1)){
var c__9319__auto___12741 = cljs.core.chunk_first.call(null,seq__12719_12740__$1);
var G__12742 = cljs.core.chunk_rest.call(null,seq__12719_12740__$1);
var G__12743 = c__9319__auto___12741;
var G__12744 = cljs.core.count.call(null,c__9319__auto___12741);
var G__12745 = (0);
seq__12719_12730 = G__12742;
chunk__12720_12731 = G__12743;
count__12721_12732 = G__12744;
i__12722_12733 = G__12745;
continue;
} else {
var param_12746 = cljs.core.first.call(null,seq__12719_12740__$1);
cljs.compiler.emit.call(null,param_12746);

if(cljs.core._EQ_.call(null,param_12746,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__12747 = cljs.core.next.call(null,seq__12719_12740__$1);
var G__12748 = null;
var G__12749 = (0);
var G__12750 = (0);
seq__12719_12730 = G__12747;
chunk__12720_12731 = G__12748;
count__12721_12732 = G__12749;
i__12722_12733 = G__12750;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,"var ",mname_12728," = function (",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",(cljs.core.count.call(null,params) - (1)),") {");

var a_12751 = cljs.compiler.emit_arguments_to_array.call(null,(cljs.core.count.call(null,params) - (1)));
cljs.compiler.emitln.call(null,"  ",cljs.core.last.call(null,params)," = new cljs.core.IndexedSeq(",a_12751,",0,null);");

cljs.compiler.emitln.call(null,"} ");
} else {
}

cljs.compiler.emits.call(null,"return ",delegate_name_12729,".call(this,");

var seq__12723_12752 = cljs.core.seq.call(null,params);
var chunk__12724_12753 = null;
var count__12725_12754 = (0);
var i__12726_12755 = (0);
while(true){
if((i__12726_12755 < count__12725_12754)){
var param_12756 = cljs.core._nth.call(null,chunk__12724_12753,i__12726_12755);
cljs.compiler.emit.call(null,param_12756);

if(cljs.core._EQ_.call(null,param_12756,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__12757 = seq__12723_12752;
var G__12758 = chunk__12724_12753;
var G__12759 = count__12725_12754;
var G__12760 = (i__12726_12755 + (1));
seq__12723_12752 = G__12757;
chunk__12724_12753 = G__12758;
count__12725_12754 = G__12759;
i__12726_12755 = G__12760;
continue;
} else {
var temp__5457__auto___12761 = cljs.core.seq.call(null,seq__12723_12752);
if(temp__5457__auto___12761){
var seq__12723_12762__$1 = temp__5457__auto___12761;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12723_12762__$1)){
var c__9319__auto___12763 = cljs.core.chunk_first.call(null,seq__12723_12762__$1);
var G__12764 = cljs.core.chunk_rest.call(null,seq__12723_12762__$1);
var G__12765 = c__9319__auto___12763;
var G__12766 = cljs.core.count.call(null,c__9319__auto___12763);
var G__12767 = (0);
seq__12723_12752 = G__12764;
chunk__12724_12753 = G__12765;
count__12725_12754 = G__12766;
i__12726_12755 = G__12767;
continue;
} else {
var param_12768 = cljs.core.first.call(null,seq__12723_12762__$1);
cljs.compiler.emit.call(null,param_12768);

if(cljs.core._EQ_.call(null,param_12768,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__12769 = cljs.core.next.call(null,seq__12723_12762__$1);
var G__12770 = null;
var G__12771 = (0);
var G__12772 = (0);
seq__12723_12752 = G__12769;
chunk__12724_12753 = G__12770;
count__12725_12754 = G__12771;
i__12726_12755 = G__12772;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,");");

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,mname_12728,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.call(null,mname_12728,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to.call(null,cljs.core.assoc.call(null,f,new cljs.core.Keyword(null,"name","name",1843675177),name_12727__$1));

cljs.compiler.emitln.call(null,";");

cljs.compiler.emitln.call(null,mname_12728,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_12729,";");

cljs.compiler.emitln.call(null,"return ",mname_12728,";");

cljs.compiler.emitln.call(null,"})()");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__12776){
var map__12777 = p__12776;
var map__12777__$1 = ((((!((map__12777 == null)))?((((map__12777.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12777.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12777):map__12777);
var name = cljs.core.get.call(null,map__12777__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__12777__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.call(null,map__12777__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.call(null,map__12777__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var variadic = cljs.core.get.call(null,map__12777__$1,new cljs.core.Keyword(null,"variadic","variadic",882626057));
var recur_frames = cljs.core.get.call(null,map__12777__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var loop_lets = cljs.core.get.call(null,map__12777__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var loop_locals = cljs.core.seq.call(null,cljs.core.map.call(null,cljs.compiler.munge,cljs.core.concat.call(null,cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.filter.call(null,((function (map__12777,map__12777__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (p1__12773_SHARP_){
var and__8376__auto__ = p1__12773_SHARP_;
if(cljs.core.truth_(and__8376__auto__)){
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__12773_SHARP_));
} else {
return and__8376__auto__;
}
});})(map__12777,map__12777__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,recur_frames)),cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),loop_lets))));
if(loop_locals){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"((function (",cljs.compiler.comma_sep.call(null,cljs.core.map.call(null,cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.call(null,"return ");
}
} else {
}

if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_12812__$1 = (function (){var or__8388__auto__ = name;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_12813 = cljs.compiler.munge.call(null,name_12812__$1);
var maxparams_12814 = cljs.core.apply.call(null,cljs.core.max_key,cljs.core.count,cljs.core.map.call(null,new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_12815 = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (name_12812__$1,mname_12813,maxparams_12814,loop_locals,map__12777,map__12777__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.call(null,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_12813),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
});})(name_12812__$1,mname_12813,maxparams_12814,loop_locals,map__12777,map__12777__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,methods$));
var ms_12816 = cljs.core.sort_by.call(null,((function (name_12812__$1,mname_12813,maxparams_12814,mmap_12815,loop_locals,map__12777,map__12777__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (p1__12774_SHARP_){
return cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,p1__12774_SHARP_)));
});})(name_12812__$1,mname_12813,maxparams_12814,mmap_12815,loop_locals,map__12777,map__12777__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,cljs.core.seq.call(null,mmap_12815));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"(function() {");

cljs.compiler.emitln.call(null,"var ",mname_12813," = null;");

var seq__12779_12817 = cljs.core.seq.call(null,ms_12816);
var chunk__12780_12818 = null;
var count__12781_12819 = (0);
var i__12782_12820 = (0);
while(true){
if((i__12782_12820 < count__12781_12819)){
var vec__12783_12821 = cljs.core._nth.call(null,chunk__12780_12818,i__12782_12820);
var n_12822 = cljs.core.nth.call(null,vec__12783_12821,(0),null);
var meth_12823 = cljs.core.nth.call(null,vec__12783_12821,(1),null);
cljs.compiler.emits.call(null,"var ",n_12822," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_12823))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_12823);
} else {
cljs.compiler.emit_fn_method.call(null,meth_12823);
}

cljs.compiler.emitln.call(null,";");

var G__12824 = seq__12779_12817;
var G__12825 = chunk__12780_12818;
var G__12826 = count__12781_12819;
var G__12827 = (i__12782_12820 + (1));
seq__12779_12817 = G__12824;
chunk__12780_12818 = G__12825;
count__12781_12819 = G__12826;
i__12782_12820 = G__12827;
continue;
} else {
var temp__5457__auto___12828 = cljs.core.seq.call(null,seq__12779_12817);
if(temp__5457__auto___12828){
var seq__12779_12829__$1 = temp__5457__auto___12828;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12779_12829__$1)){
var c__9319__auto___12830 = cljs.core.chunk_first.call(null,seq__12779_12829__$1);
var G__12831 = cljs.core.chunk_rest.call(null,seq__12779_12829__$1);
var G__12832 = c__9319__auto___12830;
var G__12833 = cljs.core.count.call(null,c__9319__auto___12830);
var G__12834 = (0);
seq__12779_12817 = G__12831;
chunk__12780_12818 = G__12832;
count__12781_12819 = G__12833;
i__12782_12820 = G__12834;
continue;
} else {
var vec__12786_12835 = cljs.core.first.call(null,seq__12779_12829__$1);
var n_12836 = cljs.core.nth.call(null,vec__12786_12835,(0),null);
var meth_12837 = cljs.core.nth.call(null,vec__12786_12835,(1),null);
cljs.compiler.emits.call(null,"var ",n_12836," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_12837))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_12837);
} else {
cljs.compiler.emit_fn_method.call(null,meth_12837);
}

cljs.compiler.emitln.call(null,";");

var G__12838 = cljs.core.next.call(null,seq__12779_12829__$1);
var G__12839 = null;
var G__12840 = (0);
var G__12841 = (0);
seq__12779_12817 = G__12838;
chunk__12780_12818 = G__12839;
count__12781_12819 = G__12840;
i__12782_12820 = G__12841;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,mname_12813," = function(",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,maxparams_12814),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_12814)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,maxparams_12814));

cljs.compiler.emitln.call(null," = var_args;");
} else {
}

cljs.compiler.emitln.call(null,"switch(arguments.length){");

var seq__12789_12842 = cljs.core.seq.call(null,ms_12816);
var chunk__12790_12843 = null;
var count__12791_12844 = (0);
var i__12792_12845 = (0);
while(true){
if((i__12792_12845 < count__12791_12844)){
var vec__12793_12846 = cljs.core._nth.call(null,chunk__12790_12843,i__12792_12845);
var n_12847 = cljs.core.nth.call(null,vec__12793_12846,(0),null);
var meth_12848 = cljs.core.nth.call(null,vec__12793_12846,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_12848))){
cljs.compiler.emitln.call(null,"default:");

var restarg_12849 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_12849," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_12850 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_12849," = new cljs.core.IndexedSeq(",a_12850,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_12847,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_12814)),(((cljs.core.count.call(null,maxparams_12814) > (1)))?", ":null),restarg_12849,");");
} else {
var pcnt_12851 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_12848));
cljs.compiler.emitln.call(null,"case ",pcnt_12851,":");

cljs.compiler.emitln.call(null,"return ",n_12847,".call(this",(((pcnt_12851 === (0)))?null:cljs.core._conj.call(null,(function (){var x__9342__auto__ = cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_12851,maxparams_12814));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9342__auto__);
})(),",")),");");
}

var G__12852 = seq__12789_12842;
var G__12853 = chunk__12790_12843;
var G__12854 = count__12791_12844;
var G__12855 = (i__12792_12845 + (1));
seq__12789_12842 = G__12852;
chunk__12790_12843 = G__12853;
count__12791_12844 = G__12854;
i__12792_12845 = G__12855;
continue;
} else {
var temp__5457__auto___12856 = cljs.core.seq.call(null,seq__12789_12842);
if(temp__5457__auto___12856){
var seq__12789_12857__$1 = temp__5457__auto___12856;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12789_12857__$1)){
var c__9319__auto___12858 = cljs.core.chunk_first.call(null,seq__12789_12857__$1);
var G__12859 = cljs.core.chunk_rest.call(null,seq__12789_12857__$1);
var G__12860 = c__9319__auto___12858;
var G__12861 = cljs.core.count.call(null,c__9319__auto___12858);
var G__12862 = (0);
seq__12789_12842 = G__12859;
chunk__12790_12843 = G__12860;
count__12791_12844 = G__12861;
i__12792_12845 = G__12862;
continue;
} else {
var vec__12796_12863 = cljs.core.first.call(null,seq__12789_12857__$1);
var n_12864 = cljs.core.nth.call(null,vec__12796_12863,(0),null);
var meth_12865 = cljs.core.nth.call(null,vec__12796_12863,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_12865))){
cljs.compiler.emitln.call(null,"default:");

var restarg_12866 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_12866," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_12867 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_12866," = new cljs.core.IndexedSeq(",a_12867,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_12864,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_12814)),(((cljs.core.count.call(null,maxparams_12814) > (1)))?", ":null),restarg_12866,");");
} else {
var pcnt_12868 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_12865));
cljs.compiler.emitln.call(null,"case ",pcnt_12868,":");

cljs.compiler.emitln.call(null,"return ",n_12864,".call(this",(((pcnt_12868 === (0)))?null:cljs.core._conj.call(null,(function (){var x__9342__auto__ = cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_12868,maxparams_12814));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9342__auto__);
})(),",")),");");
}

var G__12869 = cljs.core.next.call(null,seq__12789_12857__$1);
var G__12870 = null;
var G__12871 = (0);
var G__12872 = (0);
seq__12789_12842 = G__12869;
chunk__12790_12843 = G__12870;
count__12791_12844 = G__12871;
i__12792_12845 = G__12872;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"throw(new Error('Invalid arity: ' + (arguments.length - 1)));");

cljs.compiler.emitln.call(null,"};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.call(null,mname_12813,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.call(null,mname_12813,".cljs$lang$applyTo = ",cljs.core.some.call(null,((function (name_12812__$1,mname_12813,maxparams_12814,mmap_12815,ms_12816,loop_locals,map__12777,map__12777__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (p1__12775_SHARP_){
var vec__12799 = p1__12775_SHARP_;
var n = cljs.core.nth.call(null,vec__12799,(0),null);
var m = cljs.core.nth.call(null,vec__12799,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
});})(name_12812__$1,mname_12813,maxparams_12814,mmap_12815,ms_12816,loop_locals,map__12777,map__12777__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,ms_12816),".cljs$lang$applyTo;");
} else {
}

var seq__12802_12873 = cljs.core.seq.call(null,ms_12816);
var chunk__12803_12874 = null;
var count__12804_12875 = (0);
var i__12805_12876 = (0);
while(true){
if((i__12805_12876 < count__12804_12875)){
var vec__12806_12877 = cljs.core._nth.call(null,chunk__12803_12874,i__12805_12876);
var n_12878 = cljs.core.nth.call(null,vec__12806_12877,(0),null);
var meth_12879 = cljs.core.nth.call(null,vec__12806_12877,(1),null);
var c_12880 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_12879));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_12879))){
cljs.compiler.emitln.call(null,mname_12813,".cljs$core$IFn$_invoke$arity$variadic = ",n_12878,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_12813,".cljs$core$IFn$_invoke$arity$",c_12880," = ",n_12878,";");
}

var G__12881 = seq__12802_12873;
var G__12882 = chunk__12803_12874;
var G__12883 = count__12804_12875;
var G__12884 = (i__12805_12876 + (1));
seq__12802_12873 = G__12881;
chunk__12803_12874 = G__12882;
count__12804_12875 = G__12883;
i__12805_12876 = G__12884;
continue;
} else {
var temp__5457__auto___12885 = cljs.core.seq.call(null,seq__12802_12873);
if(temp__5457__auto___12885){
var seq__12802_12886__$1 = temp__5457__auto___12885;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12802_12886__$1)){
var c__9319__auto___12887 = cljs.core.chunk_first.call(null,seq__12802_12886__$1);
var G__12888 = cljs.core.chunk_rest.call(null,seq__12802_12886__$1);
var G__12889 = c__9319__auto___12887;
var G__12890 = cljs.core.count.call(null,c__9319__auto___12887);
var G__12891 = (0);
seq__12802_12873 = G__12888;
chunk__12803_12874 = G__12889;
count__12804_12875 = G__12890;
i__12805_12876 = G__12891;
continue;
} else {
var vec__12809_12892 = cljs.core.first.call(null,seq__12802_12886__$1);
var n_12893 = cljs.core.nth.call(null,vec__12809_12892,(0),null);
var meth_12894 = cljs.core.nth.call(null,vec__12809_12892,(1),null);
var c_12895 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_12894));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_12894))){
cljs.compiler.emitln.call(null,mname_12813,".cljs$core$IFn$_invoke$arity$variadic = ",n_12893,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_12813,".cljs$core$IFn$_invoke$arity$",c_12895," = ",n_12893,";");
}

var G__12896 = cljs.core.next.call(null,seq__12802_12886__$1);
var G__12897 = null;
var G__12898 = (0);
var G__12899 = (0);
seq__12802_12873 = G__12896;
chunk__12803_12874 = G__12897;
count__12804_12875 = G__12898;
i__12805_12876 = G__12899;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"return ",mname_12813,";");

cljs.compiler.emitln.call(null,"})()");
}

if(loop_locals){
return cljs.compiler.emitln.call(null,";})(",cljs.compiler.comma_sep.call(null,loop_locals),"))");
} else {
return null;
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"do","do",46310725),(function (p__12900){
var map__12901 = p__12900;
var map__12901__$1 = ((((!((map__12901 == null)))?((((map__12901.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12901.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12901):map__12901);
var statements = cljs.core.get.call(null,map__12901__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.call(null,map__12901__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.call(null,map__12901__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var and__8376__auto__ = statements;
if(cljs.core.truth_(and__8376__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context);
} else {
return and__8376__auto__;
}
})())){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

var seq__12903_12907 = cljs.core.seq.call(null,statements);
var chunk__12904_12908 = null;
var count__12905_12909 = (0);
var i__12906_12910 = (0);
while(true){
if((i__12906_12910 < count__12905_12909)){
var s_12911 = cljs.core._nth.call(null,chunk__12904_12908,i__12906_12910);
cljs.compiler.emitln.call(null,s_12911);

var G__12912 = seq__12903_12907;
var G__12913 = chunk__12904_12908;
var G__12914 = count__12905_12909;
var G__12915 = (i__12906_12910 + (1));
seq__12903_12907 = G__12912;
chunk__12904_12908 = G__12913;
count__12905_12909 = G__12914;
i__12906_12910 = G__12915;
continue;
} else {
var temp__5457__auto___12916 = cljs.core.seq.call(null,seq__12903_12907);
if(temp__5457__auto___12916){
var seq__12903_12917__$1 = temp__5457__auto___12916;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12903_12917__$1)){
var c__9319__auto___12918 = cljs.core.chunk_first.call(null,seq__12903_12917__$1);
var G__12919 = cljs.core.chunk_rest.call(null,seq__12903_12917__$1);
var G__12920 = c__9319__auto___12918;
var G__12921 = cljs.core.count.call(null,c__9319__auto___12918);
var G__12922 = (0);
seq__12903_12907 = G__12919;
chunk__12904_12908 = G__12920;
count__12905_12909 = G__12921;
i__12906_12910 = G__12922;
continue;
} else {
var s_12923 = cljs.core.first.call(null,seq__12903_12917__$1);
cljs.compiler.emitln.call(null,s_12923);

var G__12924 = cljs.core.next.call(null,seq__12903_12917__$1);
var G__12925 = null;
var G__12926 = (0);
var G__12927 = (0);
seq__12903_12907 = G__12924;
chunk__12904_12908 = G__12925;
count__12905_12909 = G__12926;
i__12906_12910 = G__12927;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit.call(null,ret);

if(cljs.core.truth_((function (){var and__8376__auto__ = statements;
if(cljs.core.truth_(and__8376__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context);
} else {
return and__8376__auto__;
}
})())){
return cljs.compiler.emitln.call(null,"})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__12928){
var map__12929 = p__12928;
var map__12929__$1 = ((((!((map__12929 == null)))?((((map__12929.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12929.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12929):map__12929);
var env = cljs.core.get.call(null,map__12929__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var try$ = cljs.core.get.call(null,map__12929__$1,new cljs.core.Keyword(null,"try","try",1380742522));
var catch$ = cljs.core.get.call(null,map__12929__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.call(null,map__12929__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.call(null,map__12929__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__8388__auto__ = name;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,"try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.call(null,"catch (",cljs.compiler.munge.call(null,name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"constant","constant",-379609303),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(finally$))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :constant (:op finally))"].join('')));
}

cljs.compiler.emits.call(null,"finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.call(null,try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__12931,is_loop){
var map__12932 = p__12931;
var map__12932__$1 = ((((!((map__12932 == null)))?((((map__12932.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12932.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12932):map__12932);
var bindings = cljs.core.get.call(null,map__12932__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var expr = cljs.core.get.call(null,map__12932__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__12932__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var _STAR_lexical_renames_STAR_12934_12943 = cljs.compiler._STAR_lexical_renames_STAR_;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.into.call(null,cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.call(null,((function (_STAR_lexical_renames_STAR_12934_12943,context,map__12932,map__12932__$1,bindings,expr,env){
return (function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope.call(null,binding),cljs.core.gensym.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
});})(_STAR_lexical_renames_STAR_12934_12943,context,map__12932,map__12932__$1,bindings,expr,env))
,bindings):null));

try{var seq__12935_12944 = cljs.core.seq.call(null,bindings);
var chunk__12936_12945 = null;
var count__12937_12946 = (0);
var i__12938_12947 = (0);
while(true){
if((i__12938_12947 < count__12937_12946)){
var map__12939_12948 = cljs.core._nth.call(null,chunk__12936_12945,i__12938_12947);
var map__12939_12949__$1 = ((((!((map__12939_12948 == null)))?((((map__12939_12948.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12939_12948.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12939_12948):map__12939_12948);
var binding_12950 = map__12939_12949__$1;
var init_12951 = cljs.core.get.call(null,map__12939_12949__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_12950);

cljs.compiler.emitln.call(null," = ",init_12951,";");

var G__12952 = seq__12935_12944;
var G__12953 = chunk__12936_12945;
var G__12954 = count__12937_12946;
var G__12955 = (i__12938_12947 + (1));
seq__12935_12944 = G__12952;
chunk__12936_12945 = G__12953;
count__12937_12946 = G__12954;
i__12938_12947 = G__12955;
continue;
} else {
var temp__5457__auto___12956 = cljs.core.seq.call(null,seq__12935_12944);
if(temp__5457__auto___12956){
var seq__12935_12957__$1 = temp__5457__auto___12956;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12935_12957__$1)){
var c__9319__auto___12958 = cljs.core.chunk_first.call(null,seq__12935_12957__$1);
var G__12959 = cljs.core.chunk_rest.call(null,seq__12935_12957__$1);
var G__12960 = c__9319__auto___12958;
var G__12961 = cljs.core.count.call(null,c__9319__auto___12958);
var G__12962 = (0);
seq__12935_12944 = G__12959;
chunk__12936_12945 = G__12960;
count__12937_12946 = G__12961;
i__12938_12947 = G__12962;
continue;
} else {
var map__12941_12963 = cljs.core.first.call(null,seq__12935_12957__$1);
var map__12941_12964__$1 = ((((!((map__12941_12963 == null)))?((((map__12941_12963.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12941_12963.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12941_12963):map__12941_12963);
var binding_12965 = map__12941_12964__$1;
var init_12966 = cljs.core.get.call(null,map__12941_12964__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_12965);

cljs.compiler.emitln.call(null," = ",init_12966,";");

var G__12967 = cljs.core.next.call(null,seq__12935_12957__$1);
var G__12968 = null;
var G__12969 = (0);
var G__12970 = (0);
seq__12935_12944 = G__12967;
chunk__12936_12945 = G__12968;
count__12937_12946 = G__12969;
i__12938_12947 = G__12970;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}
}finally {cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR_12934_12943;
}
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let.call(null,ast,false);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let.call(null,ast,true);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__12971){
var map__12972 = p__12971;
var map__12972__$1 = ((((!((map__12972 == null)))?((((map__12972.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12972.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12972):map__12972);
var frame = cljs.core.get.call(null,map__12972__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.call(null,map__12972__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.call(null,map__12972__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec.call(null,cljs.core.take.call(null,cljs.core.count.call(null,exprs),cljs.core.repeatedly.call(null,cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__9433__auto___12974 = cljs.core.count.call(null,exprs);
var i_12975 = (0);
while(true){
if((i_12975 < n__9433__auto___12974)){
cljs.compiler.emitln.call(null,"var ",temps.call(null,i_12975)," = ",exprs.call(null,i_12975),";");

var G__12976 = (i_12975 + (1));
i_12975 = G__12976;
continue;
} else {
}
break;
}

var n__9433__auto___12977 = cljs.core.count.call(null,exprs);
var i_12978 = (0);
while(true){
if((i_12978 < n__9433__auto___12977)){
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,params.call(null,i_12978))," = ",temps.call(null,i_12978),";");

var G__12979 = (i_12978 + (1));
i_12978 = G__12979;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.call(null,"continue;");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__12980){
var map__12981 = p__12980;
var map__12981__$1 = ((((!((map__12981 == null)))?((((map__12981.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12981.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12981):map__12981);
var bindings = cljs.core.get.call(null,map__12981__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var expr = cljs.core.get.call(null,map__12981__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__12981__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var seq__12983_12991 = cljs.core.seq.call(null,bindings);
var chunk__12984_12992 = null;
var count__12985_12993 = (0);
var i__12986_12994 = (0);
while(true){
if((i__12986_12994 < count__12985_12993)){
var map__12987_12995 = cljs.core._nth.call(null,chunk__12984_12992,i__12986_12994);
var map__12987_12996__$1 = ((((!((map__12987_12995 == null)))?((((map__12987_12995.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12987_12995.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12987_12995):map__12987_12995);
var binding_12997 = map__12987_12996__$1;
var init_12998 = cljs.core.get.call(null,map__12987_12996__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_12997)," = ",init_12998,";");

var G__12999 = seq__12983_12991;
var G__13000 = chunk__12984_12992;
var G__13001 = count__12985_12993;
var G__13002 = (i__12986_12994 + (1));
seq__12983_12991 = G__12999;
chunk__12984_12992 = G__13000;
count__12985_12993 = G__13001;
i__12986_12994 = G__13002;
continue;
} else {
var temp__5457__auto___13003 = cljs.core.seq.call(null,seq__12983_12991);
if(temp__5457__auto___13003){
var seq__12983_13004__$1 = temp__5457__auto___13003;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12983_13004__$1)){
var c__9319__auto___13005 = cljs.core.chunk_first.call(null,seq__12983_13004__$1);
var G__13006 = cljs.core.chunk_rest.call(null,seq__12983_13004__$1);
var G__13007 = c__9319__auto___13005;
var G__13008 = cljs.core.count.call(null,c__9319__auto___13005);
var G__13009 = (0);
seq__12983_12991 = G__13006;
chunk__12984_12992 = G__13007;
count__12985_12993 = G__13008;
i__12986_12994 = G__13009;
continue;
} else {
var map__12989_13010 = cljs.core.first.call(null,seq__12983_13004__$1);
var map__12989_13011__$1 = ((((!((map__12989_13010 == null)))?((((map__12989_13010.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12989_13010.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12989_13010):map__12989_13010);
var binding_13012 = map__12989_13011__$1;
var init_13013 = cljs.core.get.call(null,map__12989_13011__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_13012)," = ",init_13013,";");

var G__13014 = cljs.core.next.call(null,seq__12983_13004__$1);
var G__13015 = null;
var G__13016 = (0);
var G__13017 = (0);
seq__12983_12991 = G__13014;
chunk__12984_12992 = G__13015;
count__12985_12993 = G__13016;
i__12986_12994 = G__13017;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,expr);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym)].join('').replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__13020){
var map__13021 = p__13020;
var map__13021__$1 = ((((!((map__13021 == null)))?((((map__13021.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13021.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13021):map__13021);
var expr = map__13021__$1;
var f = cljs.core.get.call(null,map__13021__$1,new cljs.core.Keyword(null,"f","f",-1597136552));
var args = cljs.core.get.call(null,map__13021__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__13021__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__8376__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(and__8376__auto__){
var and__8376__auto____$1 = cljs.core.not.call(null,new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info));
if(and__8376__auto____$1){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__8376__auto____$1;
}
} else {
return and__8376__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__8376__auto__ = protocol;
if(cljs.core.truth_(and__8376__auto__)){
var and__8376__auto____$1 = tag;
if(cljs.core.truth_(and__8376__auto____$1)){
var or__8388__auto__ = (function (){var and__8376__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(and__8376__auto____$2){
var and__8376__auto____$3 = protocol;
if(cljs.core.truth_(and__8376__auto____$3)){
return cljs.core._EQ_.call(null,tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__8376__auto____$3;
}
} else {
return and__8376__auto____$2;
}
})();
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
var and__8376__auto____$2 = (function (){var or__8388__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(or__8388__auto____$1){
return or__8388__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__8376__auto____$2)){
var or__8388__auto____$1 = cljs.core._EQ_.call(null,protocol,tag);
if(or__8388__auto____$1){
return or__8388__auto____$1;
} else {
var and__8376__auto____$3 = !(cljs.core.set_QMARK_.call(null,tag));
if(and__8376__auto____$3){
var and__8376__auto____$4 = cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null,new cljs.core.Symbol(null,"object","object",-1179821820,null),null,new cljs.core.Symbol(null,"any","any",-948528346,null),null,new cljs.core.Symbol(null,"js","js",-886355190,null),null,new cljs.core.Symbol(null,"number","number",-1084057331,null),null,new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),null,new cljs.core.Symbol(null,"array","array",-440182315,null),null,new cljs.core.Symbol(null,"string","string",-349010059,null),null,new cljs.core.Symbol(null,"function","function",-486723946,null),null,new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),null], null), null).call(null,tag));
if(and__8376__auto____$4){
var temp__5457__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var.call(null,env,tag));
if(cljs.core.truth_(temp__5457__auto__)){
var ps = temp__5457__auto__;
return ps.call(null,protocol);
} else {
return null;
}
} else {
return and__8376__auto____$4;
}
} else {
return and__8376__auto____$3;
}
}
} else {
return and__8376__auto____$2;
}
}
} else {
return and__8376__auto____$1;
}
} else {
return and__8376__auto__;
}
})();
var opt_not_QMARK_ = (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.call(null,cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr))),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var js_QMARK_ = (cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"js","js",-886355190,null))) || (cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null)));
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__8388__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__8388__auto__){
return or__8388__auto__;
} else {
var or__8388__auto____$1 = (function (){var temp__5457__auto__ = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join('');
if(cljs.core.truth_(temp__5457__auto__)){
var ns_str = temp__5457__auto__;
return cljs.core._EQ_.call(null,cljs.core.get.call(null,clojure.string.split.call(null,ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__8388__auto____$1)){
return or__8388__auto____$1;
} else {
return !(cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)),ns));
}
}
})():null);
var keyword_QMARK_ = (cljs.core._EQ_.call(null,new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),cljs.analyzer.infer_tag.call(null,env,f))) || ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f),new cljs.core.Keyword(null,"constant","constant",-379609303))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f) instanceof cljs.core.Keyword)));
var vec__13023 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count.call(null,args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if((cljs.core.not.call(null,variadic_QMARK_)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,mps),(1)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__8376__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__8376__auto__)){
return (arity > mfa);
} else {
return and__8376__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__13021,map__13021__$1,expr,f,args,env){
return (function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__13021,map__13021__$1,expr,f,args,env){
return (function (p1__13018_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__13018_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
});})(arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__13021,map__13021__$1,expr,f,args,env))
);
});})(arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__13021,map__13021__$1,expr,f,args,env))
),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.call(null,cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__13021,map__13021__$1,expr,f,args,env){
return (function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__13021,map__13021__$1,expr,f,args,env){
return (function (p1__13019_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__13019_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
});})(arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__13021,map__13021__$1,expr,f,args,env))
);
});})(arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__13021,map__13021__$1,expr,f,args,env))
),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.call(null,vec__13023,(0),null);
var variadic_invoke = cljs.core.nth.call(null,vec__13023,(1),null);
var env__12233__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.call(null,"!(",cljs.core.first.call(null,args),")");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_13026 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.compiler.protocol_prefix.call(null,protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.core.name.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
cljs.compiler.emits.call(null,cljs.core.first.call(null,args),".",pimpl_13026,"(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",cljs.core.rest.call(null,args))),")");
} else {
if(keyword_QMARK_){
cljs.compiler.emits.call(null,f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count.call(null,args),"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_13027 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,mfa_13027,args)),(((mfa_13027 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.compiler.comma_sep.call(null,cljs.core.drop.call(null,mfa_13027,args)),"], 0))");
} else {
if(cljs.core.truth_((function (){var or__8388__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
var or__8388__auto____$1 = js_QMARK_;
if(or__8388__auto____$1){
return or__8388__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if((cljs.analyzer._STAR_cljs_static_fns_STAR_) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"var","var",-769682797)))){
var fprop_13028 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
if(cljs.analyzer._STAR_fn_invoke_direct_STAR_){
cljs.compiler.emits.call(null,"(",f__$1,fprop_13028," ? ",f__$1,fprop_13028,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,"(",cljs.compiler.comma_sep.call(null,args),"))");
} else {
cljs.compiler.emits.call(null,"(",f__$1,fprop_13028," ? ",f__$1,fprop_13028,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),"))");
}
} else {
cljs.compiler.emits.call(null,f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),")");
}

}
}
}
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__13029){
var map__13030 = p__13029;
var map__13030__$1 = ((((!((map__13030 == null)))?((((map__13030.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13030.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13030):map__13030);
var ctor = cljs.core.get.call(null,map__13030__$1,new cljs.core.Keyword(null,"ctor","ctor",1750864802));
var args = cljs.core.get.call(null,map__13030__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__13030__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__12233__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(new ",ctor,"(",cljs.compiler.comma_sep.call(null,args),"))");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__13032){
var map__13033 = p__13032;
var map__13033__$1 = ((((!((map__13033 == null)))?((((map__13033.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13033.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13033):map__13033);
var target = cljs.core.get.call(null,map__13033__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.call(null,map__13033__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.call(null,map__13033__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__12233__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,target," = ",val);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__13035 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__13035__$1 = ((((!((map__13035 == null)))?((((map__13035.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13035.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13035):map__13035);
var options = cljs.core.get.call(null,map__13035__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.call(null,map__13035__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__13036 = options;
var map__13036__$1 = ((((!((map__13036 == null)))?((((map__13036.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13036.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13036):map__13036);
var target = cljs.core.get.call(null,map__13036__$1,new cljs.core.Keyword(null,"target","target",253001721));
var optimizations = cljs.core.get.call(null,map__13036__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.call(null,cljs.core.gensym.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__13037 = (function (){var libs__$1 = cljs.core.remove.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,seen)),cljs.core.filter.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,libs)),deps));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__13043 = cljs.core.group_by.call(null,cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__13043__$1 = ((((!((map__13043 == null)))?((((map__13043.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13043.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13043):map__13043);
var node_libs = cljs.core.get.call(null,map__13043__$1,true);
var libs_to_load = cljs.core.get.call(null,map__13043__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.call(null,vec__13037,(0),null);
var libs_to_load = cljs.core.nth.call(null,vec__13037,(1),null);
var map__13040 = cljs.core.group_by.call(null,cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
var map__13040__$1 = ((((!((map__13040 == null)))?((((map__13040.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13040.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13040):map__13040);
var global_exports_libs = cljs.core.get.call(null,map__13040__$1,true);
var libs_to_load__$1 = cljs.core.get.call(null,map__13040__$1,false);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__13046_13062 = cljs.core.seq.call(null,libs_to_load__$1);
var chunk__13047_13063 = null;
var count__13048_13064 = (0);
var i__13049_13065 = (0);
while(true){
if((i__13049_13065 < count__13048_13064)){
var lib_13066 = cljs.core._nth.call(null,chunk__13047_13063,i__13049_13065);
if((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_13066)) && (!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))){
} else {
if(cljs.core.truth_((function (){var or__8388__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_13066),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_13066),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__8388__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_13066),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_13066),"', 'reload-all');");
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_13066),"');");

}
}
}

var G__13067 = seq__13046_13062;
var G__13068 = chunk__13047_13063;
var G__13069 = count__13048_13064;
var G__13070 = (i__13049_13065 + (1));
seq__13046_13062 = G__13067;
chunk__13047_13063 = G__13068;
count__13048_13064 = G__13069;
i__13049_13065 = G__13070;
continue;
} else {
var temp__5457__auto___13071 = cljs.core.seq.call(null,seq__13046_13062);
if(temp__5457__auto___13071){
var seq__13046_13072__$1 = temp__5457__auto___13071;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__13046_13072__$1)){
var c__9319__auto___13073 = cljs.core.chunk_first.call(null,seq__13046_13072__$1);
var G__13074 = cljs.core.chunk_rest.call(null,seq__13046_13072__$1);
var G__13075 = c__9319__auto___13073;
var G__13076 = cljs.core.count.call(null,c__9319__auto___13073);
var G__13077 = (0);
seq__13046_13062 = G__13074;
chunk__13047_13063 = G__13075;
count__13048_13064 = G__13076;
i__13049_13065 = G__13077;
continue;
} else {
var lib_13078 = cljs.core.first.call(null,seq__13046_13072__$1);
if((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_13078)) && (!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))){
} else {
if(cljs.core.truth_((function (){var or__8388__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_13078),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_13078),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__8388__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_13078),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_13078),"', 'reload-all');");
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_13078),"');");

}
}
}

var G__13079 = cljs.core.next.call(null,seq__13046_13072__$1);
var G__13080 = null;
var G__13081 = (0);
var G__13082 = (0);
seq__13046_13062 = G__13079;
chunk__13047_13063 = G__13080;
count__13048_13064 = G__13081;
i__13049_13065 = G__13082;
continue;
}
} else {
}
}
break;
}

var seq__13050_13083 = cljs.core.seq.call(null,node_libs);
var chunk__13051_13084 = null;
var count__13052_13085 = (0);
var i__13053_13086 = (0);
while(true){
if((i__13053_13086 < count__13052_13085)){
var lib_13087 = cljs.core._nth.call(null,chunk__13051_13084,i__13053_13086);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_13087)," = require('",lib_13087,"');");

var G__13088 = seq__13050_13083;
var G__13089 = chunk__13051_13084;
var G__13090 = count__13052_13085;
var G__13091 = (i__13053_13086 + (1));
seq__13050_13083 = G__13088;
chunk__13051_13084 = G__13089;
count__13052_13085 = G__13090;
i__13053_13086 = G__13091;
continue;
} else {
var temp__5457__auto___13092 = cljs.core.seq.call(null,seq__13050_13083);
if(temp__5457__auto___13092){
var seq__13050_13093__$1 = temp__5457__auto___13092;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__13050_13093__$1)){
var c__9319__auto___13094 = cljs.core.chunk_first.call(null,seq__13050_13093__$1);
var G__13095 = cljs.core.chunk_rest.call(null,seq__13050_13093__$1);
var G__13096 = c__9319__auto___13094;
var G__13097 = cljs.core.count.call(null,c__9319__auto___13094);
var G__13098 = (0);
seq__13050_13083 = G__13095;
chunk__13051_13084 = G__13096;
count__13052_13085 = G__13097;
i__13053_13086 = G__13098;
continue;
} else {
var lib_13099 = cljs.core.first.call(null,seq__13050_13093__$1);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_13099)," = require('",lib_13099,"');");

var G__13100 = cljs.core.next.call(null,seq__13050_13093__$1);
var G__13101 = null;
var G__13102 = (0);
var G__13103 = (0);
seq__13050_13083 = G__13100;
chunk__13051_13084 = G__13101;
count__13052_13085 = G__13102;
i__13053_13086 = G__13103;
continue;
}
} else {
}
}
break;
}

var seq__13054_13104 = cljs.core.seq.call(null,global_exports_libs);
var chunk__13055_13105 = null;
var count__13056_13106 = (0);
var i__13057_13107 = (0);
while(true){
if((i__13057_13107 < count__13056_13106)){
var lib_13108 = cljs.core._nth.call(null,chunk__13055_13105,i__13057_13107);
var map__13058_13109 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,lib_13108));
var map__13058_13110__$1 = ((((!((map__13058_13109 == null)))?((((map__13058_13109.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13058_13109.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13058_13109):map__13058_13109);
var global_exports_13111 = cljs.core.get.call(null,map__13058_13110__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_global_export.call(null,lib_13108)," = goog.global.",cljs.core.get.call(null,global_exports_13111,cljs.core.symbol.call(null,lib_13108)),";");

var G__13112 = seq__13054_13104;
var G__13113 = chunk__13055_13105;
var G__13114 = count__13056_13106;
var G__13115 = (i__13057_13107 + (1));
seq__13054_13104 = G__13112;
chunk__13055_13105 = G__13113;
count__13056_13106 = G__13114;
i__13057_13107 = G__13115;
continue;
} else {
var temp__5457__auto___13116 = cljs.core.seq.call(null,seq__13054_13104);
if(temp__5457__auto___13116){
var seq__13054_13117__$1 = temp__5457__auto___13116;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__13054_13117__$1)){
var c__9319__auto___13118 = cljs.core.chunk_first.call(null,seq__13054_13117__$1);
var G__13119 = cljs.core.chunk_rest.call(null,seq__13054_13117__$1);
var G__13120 = c__9319__auto___13118;
var G__13121 = cljs.core.count.call(null,c__9319__auto___13118);
var G__13122 = (0);
seq__13054_13104 = G__13119;
chunk__13055_13105 = G__13120;
count__13056_13106 = G__13121;
i__13057_13107 = G__13122;
continue;
} else {
var lib_13123 = cljs.core.first.call(null,seq__13054_13117__$1);
var map__13060_13124 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,lib_13123));
var map__13060_13125__$1 = ((((!((map__13060_13124 == null)))?((((map__13060_13124.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13060_13124.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13060_13124):map__13060_13124);
var global_exports_13126 = cljs.core.get.call(null,map__13060_13125__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_global_export.call(null,lib_13123)," = goog.global.",cljs.core.get.call(null,global_exports_13126,cljs.core.symbol.call(null,lib_13123)),";");

var G__13127 = cljs.core.next.call(null,seq__13054_13117__$1);
var G__13128 = null;
var G__13129 = (0);
var G__13130 = (0);
seq__13054_13104 = G__13127;
chunk__13055_13105 = G__13128;
count__13056_13106 = G__13129;
i__13057_13107 = G__13130;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
return cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",loaded_libs,");");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__13131){
var map__13132 = p__13131;
var map__13132__$1 = ((((!((map__13132 == null)))?((((map__13132.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13132.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13132):map__13132);
var name = cljs.core.get.call(null,map__13132__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__13132__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__13132__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__13132__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__13132__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__13132__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__13132__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"null;");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__13134){
var map__13135 = p__13134;
var map__13135__$1 = ((((!((map__13135 == null)))?((((map__13135.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13135.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13135):map__13135);
var name = cljs.core.get.call(null,map__13135__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__13135__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__13135__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__13135__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__13135__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__13135__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__13135__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,name),"');");

if(cljs.core._EQ_.call(null,name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"deftype*","deftype*",-677871637),(function (p__13137){
var map__13138 = p__13137;
var map__13138__$1 = ((((!((map__13138 == null)))?((((map__13138.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13138.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13138):map__13138);
var t = cljs.core.get.call(null,map__13138__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__13138__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__13138__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__13138__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__13138__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.call(null,cljs.compiler.munge,fields);
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__13140_13158 = cljs.core.seq.call(null,protocols);
var chunk__13141_13159 = null;
var count__13142_13160 = (0);
var i__13143_13161 = (0);
while(true){
if((i__13143_13161 < count__13142_13160)){
var protocol_13162 = cljs.core._nth.call(null,chunk__13141_13159,i__13143_13161);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_13162)].join('')),"}");

var G__13163 = seq__13140_13158;
var G__13164 = chunk__13141_13159;
var G__13165 = count__13142_13160;
var G__13166 = (i__13143_13161 + (1));
seq__13140_13158 = G__13163;
chunk__13141_13159 = G__13164;
count__13142_13160 = G__13165;
i__13143_13161 = G__13166;
continue;
} else {
var temp__5457__auto___13167 = cljs.core.seq.call(null,seq__13140_13158);
if(temp__5457__auto___13167){
var seq__13140_13168__$1 = temp__5457__auto___13167;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__13140_13168__$1)){
var c__9319__auto___13169 = cljs.core.chunk_first.call(null,seq__13140_13168__$1);
var G__13170 = cljs.core.chunk_rest.call(null,seq__13140_13168__$1);
var G__13171 = c__9319__auto___13169;
var G__13172 = cljs.core.count.call(null,c__9319__auto___13169);
var G__13173 = (0);
seq__13140_13158 = G__13170;
chunk__13141_13159 = G__13171;
count__13142_13160 = G__13172;
i__13143_13161 = G__13173;
continue;
} else {
var protocol_13174 = cljs.core.first.call(null,seq__13140_13168__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_13174)].join('')),"}");

var G__13175 = cljs.core.next.call(null,seq__13140_13168__$1);
var G__13176 = null;
var G__13177 = (0);
var G__13178 = (0);
seq__13140_13158 = G__13175;
chunk__13141_13159 = G__13176;
count__13142_13160 = G__13177;
i__13143_13161 = G__13178;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__13144_13179 = cljs.core.seq.call(null,fields__$1);
var chunk__13145_13180 = null;
var count__13146_13181 = (0);
var i__13147_13182 = (0);
while(true){
if((i__13147_13182 < count__13146_13181)){
var fld_13183 = cljs.core._nth.call(null,chunk__13145_13180,i__13147_13182);
cljs.compiler.emitln.call(null,"this.",fld_13183," = ",fld_13183,";");

var G__13184 = seq__13144_13179;
var G__13185 = chunk__13145_13180;
var G__13186 = count__13146_13181;
var G__13187 = (i__13147_13182 + (1));
seq__13144_13179 = G__13184;
chunk__13145_13180 = G__13185;
count__13146_13181 = G__13186;
i__13147_13182 = G__13187;
continue;
} else {
var temp__5457__auto___13188 = cljs.core.seq.call(null,seq__13144_13179);
if(temp__5457__auto___13188){
var seq__13144_13189__$1 = temp__5457__auto___13188;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__13144_13189__$1)){
var c__9319__auto___13190 = cljs.core.chunk_first.call(null,seq__13144_13189__$1);
var G__13191 = cljs.core.chunk_rest.call(null,seq__13144_13189__$1);
var G__13192 = c__9319__auto___13190;
var G__13193 = cljs.core.count.call(null,c__9319__auto___13190);
var G__13194 = (0);
seq__13144_13179 = G__13191;
chunk__13145_13180 = G__13192;
count__13146_13181 = G__13193;
i__13147_13182 = G__13194;
continue;
} else {
var fld_13195 = cljs.core.first.call(null,seq__13144_13189__$1);
cljs.compiler.emitln.call(null,"this.",fld_13195," = ",fld_13195,";");

var G__13196 = cljs.core.next.call(null,seq__13144_13189__$1);
var G__13197 = null;
var G__13198 = (0);
var G__13199 = (0);
seq__13144_13179 = G__13196;
chunk__13145_13180 = G__13197;
count__13146_13181 = G__13198;
i__13147_13182 = G__13199;
continue;
}
} else {
}
}
break;
}

var seq__13148_13200 = cljs.core.seq.call(null,pmasks);
var chunk__13149_13201 = null;
var count__13150_13202 = (0);
var i__13151_13203 = (0);
while(true){
if((i__13151_13203 < count__13150_13202)){
var vec__13152_13204 = cljs.core._nth.call(null,chunk__13149_13201,i__13151_13203);
var pno_13205 = cljs.core.nth.call(null,vec__13152_13204,(0),null);
var pmask_13206 = cljs.core.nth.call(null,vec__13152_13204,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_13205,"$ = ",pmask_13206,";");

var G__13207 = seq__13148_13200;
var G__13208 = chunk__13149_13201;
var G__13209 = count__13150_13202;
var G__13210 = (i__13151_13203 + (1));
seq__13148_13200 = G__13207;
chunk__13149_13201 = G__13208;
count__13150_13202 = G__13209;
i__13151_13203 = G__13210;
continue;
} else {
var temp__5457__auto___13211 = cljs.core.seq.call(null,seq__13148_13200);
if(temp__5457__auto___13211){
var seq__13148_13212__$1 = temp__5457__auto___13211;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__13148_13212__$1)){
var c__9319__auto___13213 = cljs.core.chunk_first.call(null,seq__13148_13212__$1);
var G__13214 = cljs.core.chunk_rest.call(null,seq__13148_13212__$1);
var G__13215 = c__9319__auto___13213;
var G__13216 = cljs.core.count.call(null,c__9319__auto___13213);
var G__13217 = (0);
seq__13148_13200 = G__13214;
chunk__13149_13201 = G__13215;
count__13150_13202 = G__13216;
i__13151_13203 = G__13217;
continue;
} else {
var vec__13155_13218 = cljs.core.first.call(null,seq__13148_13212__$1);
var pno_13219 = cljs.core.nth.call(null,vec__13155_13218,(0),null);
var pmask_13220 = cljs.core.nth.call(null,vec__13155_13218,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_13219,"$ = ",pmask_13220,";");

var G__13221 = cljs.core.next.call(null,seq__13148_13212__$1);
var G__13222 = null;
var G__13223 = (0);
var G__13224 = (0);
seq__13148_13200 = G__13221;
chunk__13149_13201 = G__13222;
count__13150_13202 = G__13223;
i__13151_13203 = G__13224;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"defrecord*","defrecord*",718069562),(function (p__13225){
var map__13226 = p__13225;
var map__13226__$1 = ((((!((map__13226 == null)))?((((map__13226.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13226.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13226):map__13226);
var t = cljs.core.get.call(null,map__13226__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__13226__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__13226__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__13226__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__13226__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.call(null,cljs.core.map.call(null,cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__13228_13246 = cljs.core.seq.call(null,protocols);
var chunk__13229_13247 = null;
var count__13230_13248 = (0);
var i__13231_13249 = (0);
while(true){
if((i__13231_13249 < count__13230_13248)){
var protocol_13250 = cljs.core._nth.call(null,chunk__13229_13247,i__13231_13249);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_13250)].join('')),"}");

var G__13251 = seq__13228_13246;
var G__13252 = chunk__13229_13247;
var G__13253 = count__13230_13248;
var G__13254 = (i__13231_13249 + (1));
seq__13228_13246 = G__13251;
chunk__13229_13247 = G__13252;
count__13230_13248 = G__13253;
i__13231_13249 = G__13254;
continue;
} else {
var temp__5457__auto___13255 = cljs.core.seq.call(null,seq__13228_13246);
if(temp__5457__auto___13255){
var seq__13228_13256__$1 = temp__5457__auto___13255;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__13228_13256__$1)){
var c__9319__auto___13257 = cljs.core.chunk_first.call(null,seq__13228_13256__$1);
var G__13258 = cljs.core.chunk_rest.call(null,seq__13228_13256__$1);
var G__13259 = c__9319__auto___13257;
var G__13260 = cljs.core.count.call(null,c__9319__auto___13257);
var G__13261 = (0);
seq__13228_13246 = G__13258;
chunk__13229_13247 = G__13259;
count__13230_13248 = G__13260;
i__13231_13249 = G__13261;
continue;
} else {
var protocol_13262 = cljs.core.first.call(null,seq__13228_13256__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_13262)].join('')),"}");

var G__13263 = cljs.core.next.call(null,seq__13228_13256__$1);
var G__13264 = null;
var G__13265 = (0);
var G__13266 = (0);
seq__13228_13246 = G__13263;
chunk__13229_13247 = G__13264;
count__13230_13248 = G__13265;
i__13231_13249 = G__13266;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__13232_13267 = cljs.core.seq.call(null,fields__$1);
var chunk__13233_13268 = null;
var count__13234_13269 = (0);
var i__13235_13270 = (0);
while(true){
if((i__13235_13270 < count__13234_13269)){
var fld_13271 = cljs.core._nth.call(null,chunk__13233_13268,i__13235_13270);
cljs.compiler.emitln.call(null,"this.",fld_13271," = ",fld_13271,";");

var G__13272 = seq__13232_13267;
var G__13273 = chunk__13233_13268;
var G__13274 = count__13234_13269;
var G__13275 = (i__13235_13270 + (1));
seq__13232_13267 = G__13272;
chunk__13233_13268 = G__13273;
count__13234_13269 = G__13274;
i__13235_13270 = G__13275;
continue;
} else {
var temp__5457__auto___13276 = cljs.core.seq.call(null,seq__13232_13267);
if(temp__5457__auto___13276){
var seq__13232_13277__$1 = temp__5457__auto___13276;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__13232_13277__$1)){
var c__9319__auto___13278 = cljs.core.chunk_first.call(null,seq__13232_13277__$1);
var G__13279 = cljs.core.chunk_rest.call(null,seq__13232_13277__$1);
var G__13280 = c__9319__auto___13278;
var G__13281 = cljs.core.count.call(null,c__9319__auto___13278);
var G__13282 = (0);
seq__13232_13267 = G__13279;
chunk__13233_13268 = G__13280;
count__13234_13269 = G__13281;
i__13235_13270 = G__13282;
continue;
} else {
var fld_13283 = cljs.core.first.call(null,seq__13232_13277__$1);
cljs.compiler.emitln.call(null,"this.",fld_13283," = ",fld_13283,";");

var G__13284 = cljs.core.next.call(null,seq__13232_13277__$1);
var G__13285 = null;
var G__13286 = (0);
var G__13287 = (0);
seq__13232_13267 = G__13284;
chunk__13233_13268 = G__13285;
count__13234_13269 = G__13286;
i__13235_13270 = G__13287;
continue;
}
} else {
}
}
break;
}

var seq__13236_13288 = cljs.core.seq.call(null,pmasks);
var chunk__13237_13289 = null;
var count__13238_13290 = (0);
var i__13239_13291 = (0);
while(true){
if((i__13239_13291 < count__13238_13290)){
var vec__13240_13292 = cljs.core._nth.call(null,chunk__13237_13289,i__13239_13291);
var pno_13293 = cljs.core.nth.call(null,vec__13240_13292,(0),null);
var pmask_13294 = cljs.core.nth.call(null,vec__13240_13292,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_13293,"$ = ",pmask_13294,";");

var G__13295 = seq__13236_13288;
var G__13296 = chunk__13237_13289;
var G__13297 = count__13238_13290;
var G__13298 = (i__13239_13291 + (1));
seq__13236_13288 = G__13295;
chunk__13237_13289 = G__13296;
count__13238_13290 = G__13297;
i__13239_13291 = G__13298;
continue;
} else {
var temp__5457__auto___13299 = cljs.core.seq.call(null,seq__13236_13288);
if(temp__5457__auto___13299){
var seq__13236_13300__$1 = temp__5457__auto___13299;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__13236_13300__$1)){
var c__9319__auto___13301 = cljs.core.chunk_first.call(null,seq__13236_13300__$1);
var G__13302 = cljs.core.chunk_rest.call(null,seq__13236_13300__$1);
var G__13303 = c__9319__auto___13301;
var G__13304 = cljs.core.count.call(null,c__9319__auto___13301);
var G__13305 = (0);
seq__13236_13288 = G__13302;
chunk__13237_13289 = G__13303;
count__13238_13290 = G__13304;
i__13239_13291 = G__13305;
continue;
} else {
var vec__13243_13306 = cljs.core.first.call(null,seq__13236_13300__$1);
var pno_13307 = cljs.core.nth.call(null,vec__13243_13306,(0),null);
var pmask_13308 = cljs.core.nth.call(null,vec__13243_13306,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_13307,"$ = ",pmask_13308,";");

var G__13309 = cljs.core.next.call(null,seq__13236_13300__$1);
var G__13310 = null;
var G__13311 = (0);
var G__13312 = (0);
seq__13236_13288 = G__13309;
chunk__13237_13289 = G__13310;
count__13238_13290 = G__13311;
i__13239_13291 = G__13312;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"dot","dot",1442709401),(function (p__13313){
var map__13314 = p__13313;
var map__13314__$1 = ((((!((map__13314 == null)))?((((map__13314.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13314.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13314):map__13314);
var target = cljs.core.get.call(null,map__13314__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.call(null,map__13314__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.call(null,map__13314__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.call(null,map__13314__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__13314__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__12233__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep.call(null,args),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__13316){
var map__13317 = p__13316;
var map__13317__$1 = ((((!((map__13317 == null)))?((((map__13317.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13317.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13317):map__13317);
var op = cljs.core.get.call(null,map__13317__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.call(null,map__13317__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.call(null,map__13317__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.call(null,map__13317__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.call(null,map__13317__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__8376__auto__ = code;
if(cljs.core.truth_(and__8376__auto__)){
return goog.string.startsWith(clojure.string.trim.call(null,code),"/*");
} else {
return and__8376__auto__;
}
})())){
return cljs.compiler.emits.call(null,code);
} else {
var env__12233__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.call(null,code);
} else {
cljs.compiler.emits.call(null,cljs.core.interleave.call(null,cljs.core.concat.call(null,segs,cljs.core.repeat.call(null,null)),cljs.core.concat.call(null,args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__12233__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.build_affecting_options = (function cljs$compiler$build_affecting_options(opts){
return cljs.core.select_keys.call(null,opts,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"static-fns","static-fns",-501950748),new cljs.core.Keyword(null,"fn-invoke-direct","fn-invoke-direct",-1537311210),new cljs.core.Keyword(null,"optimize-constants","optimize-constants",232704518),new cljs.core.Keyword(null,"elide-asserts","elide-asserts",537063272),new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"cache-key","cache-key",-565448732),new cljs.core.Keyword(null,"checked-arrays","checked-arrays",-139154445),new cljs.core.Keyword(null,"language-out","language-out",334619882)], null));
});
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

var seq__13322 = cljs.core.seq.call(null,table);
var chunk__13323 = null;
var count__13324 = (0);
var i__13325 = (0);
while(true){
if((i__13325 < count__13324)){
var vec__13326 = cljs.core._nth.call(null,chunk__13323,i__13325);
var sym = cljs.core.nth.call(null,vec__13326,(0),null);
var value = cljs.core.nth.call(null,vec__13326,(1),null);
var ns_13332 = cljs.core.namespace.call(null,sym);
var name_13333 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471)], null));

}
}

cljs.compiler.emits.call(null,";\n");

var G__13334 = seq__13322;
var G__13335 = chunk__13323;
var G__13336 = count__13324;
var G__13337 = (i__13325 + (1));
seq__13322 = G__13334;
chunk__13323 = G__13335;
count__13324 = G__13336;
i__13325 = G__13337;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__13322);
if(temp__5457__auto__){
var seq__13322__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__13322__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__13322__$1);
var G__13338 = cljs.core.chunk_rest.call(null,seq__13322__$1);
var G__13339 = c__9319__auto__;
var G__13340 = cljs.core.count.call(null,c__9319__auto__);
var G__13341 = (0);
seq__13322 = G__13338;
chunk__13323 = G__13339;
count__13324 = G__13340;
i__13325 = G__13341;
continue;
} else {
var vec__13329 = cljs.core.first.call(null,seq__13322__$1);
var sym = cljs.core.nth.call(null,vec__13329,(0),null);
var value = cljs.core.nth.call(null,vec__13329,(1),null);
var ns_13342 = cljs.core.namespace.call(null,sym);
var name_13343 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471)], null));

}
}

cljs.compiler.emits.call(null,";\n");

var G__13344 = cljs.core.next.call(null,seq__13322__$1);
var G__13345 = null;
var G__13346 = (0);
var G__13347 = (0);
seq__13322 = G__13344;
chunk__13323 = G__13345;
count__13324 = G__13346;
i__13325 = G__13347;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__13349 = arguments.length;
switch (G__13349) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.call(null,cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?new cljs.core.Keyword("cljs.analyzer","externs","cljs.analyzer/externs",893359239).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)):null));
});

cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq.call(null,cljs.core.keys.call(null,externs));
while(true){
if(ks){
var k_13354 = cljs.core.first.call(null,ks);
var vec__13350_13355 = cljs.core.conj.call(null,prefix,k_13354);
var top_13356 = cljs.core.nth.call(null,vec__13350_13355,(0),null);
var prefix_SINGLEQUOTE__13357 = vec__13350_13355;
if((cljs.core.not_EQ_.call(null,new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_13354)) && ((cljs.core.get_in.call(null,known_externs,prefix_SINGLEQUOTE__13357) == null))){
if(!((cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,top_level),top_13356)) || (cljs.core.contains_QMARK_.call(null,known_externs,top_13356)))){
cljs.compiler.emitln.call(null,"var ",clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__13357)),";");

cljs.core.swap_BANG_.call(null,top_level,cljs.core.conj,top_13356);
} else {
cljs.compiler.emitln.call(null,clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__13357)),";");
}
} else {
}

var m_13358 = cljs.core.get.call(null,externs,k_13354);
if(cljs.core.empty_QMARK_.call(null,m_13358)){
} else {
cljs.compiler.emit_externs.call(null,prefix_SINGLEQUOTE__13357,m_13358,top_level,known_externs);
}

var G__13359 = cljs.core.next.call(null,ks);
ks = G__13359;
continue;
} else {
return null;
}
break;
}
});

cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4;


//# sourceMappingURL=compiler.js.map?rel=1518919046558
