// Compiled by ClojureScript 1.9.946 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__16333 = arguments.length;
switch (G__16333) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async16334 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16334 = (function (f,blockable,meta16335){
this.f = f;
this.blockable = blockable;
this.meta16335 = meta16335;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16334.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16336,meta16335__$1){
var self__ = this;
var _16336__$1 = this;
return (new cljs.core.async.t_cljs$core$async16334(self__.f,self__.blockable,meta16335__$1));
});

cljs.core.async.t_cljs$core$async16334.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16336){
var self__ = this;
var _16336__$1 = this;
return self__.meta16335;
});

cljs.core.async.t_cljs$core$async16334.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16334.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async16334.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async16334.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async16334.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta16335","meta16335",2080398084,null)], null);
});

cljs.core.async.t_cljs$core$async16334.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16334.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16334";

cljs.core.async.t_cljs$core$async16334.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async16334");
});

cljs.core.async.__GT_t_cljs$core$async16334 = (function cljs$core$async$__GT_t_cljs$core$async16334(f__$1,blockable__$1,meta16335){
return (new cljs.core.async.t_cljs$core$async16334(f__$1,blockable__$1,meta16335));
});

}

return (new cljs.core.async.t_cljs$core$async16334(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__16340 = arguments.length;
switch (G__16340) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__16343 = arguments.length;
switch (G__16343) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__16346 = arguments.length;
switch (G__16346) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_16348 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_16348);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_16348,ret){
return (function (){
return fn1.call(null,val_16348);
});})(val_16348,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__16350 = arguments.length;
switch (G__16350) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5455__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__9433__auto___16352 = n;
var x_16353 = (0);
while(true){
if((x_16353 < n__9433__auto___16352)){
(a[x_16353] = (0));

var G__16354 = (x_16353 + (1));
x_16353 = G__16354;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__16355 = (i + (1));
i = G__16355;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async16356 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16356 = (function (flag,meta16357){
this.flag = flag;
this.meta16357 = meta16357;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16356.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_16358,meta16357__$1){
var self__ = this;
var _16358__$1 = this;
return (new cljs.core.async.t_cljs$core$async16356(self__.flag,meta16357__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async16356.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_16358){
var self__ = this;
var _16358__$1 = this;
return self__.meta16357;
});})(flag))
;

cljs.core.async.t_cljs$core$async16356.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16356.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async16356.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async16356.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async16356.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta16357","meta16357",1333996950,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async16356.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16356.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16356";

cljs.core.async.t_cljs$core$async16356.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async16356");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async16356 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async16356(flag__$1,meta16357){
return (new cljs.core.async.t_cljs$core$async16356(flag__$1,meta16357));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async16356(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async16359 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16359 = (function (flag,cb,meta16360){
this.flag = flag;
this.cb = cb;
this.meta16360 = meta16360;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16359.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16361,meta16360__$1){
var self__ = this;
var _16361__$1 = this;
return (new cljs.core.async.t_cljs$core$async16359(self__.flag,self__.cb,meta16360__$1));
});

cljs.core.async.t_cljs$core$async16359.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16361){
var self__ = this;
var _16361__$1 = this;
return self__.meta16360;
});

cljs.core.async.t_cljs$core$async16359.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16359.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async16359.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async16359.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async16359.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta16360","meta16360",838046320,null)], null);
});

cljs.core.async.t_cljs$core$async16359.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16359.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16359";

cljs.core.async.t_cljs$core$async16359.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async16359");
});

cljs.core.async.__GT_t_cljs$core$async16359 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async16359(flag__$1,cb__$1,meta16360){
return (new cljs.core.async.t_cljs$core$async16359(flag__$1,cb__$1,meta16360));
});

}

return (new cljs.core.async.t_cljs$core$async16359(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16362_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16362_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16363_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16363_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__8388__auto__ = wport;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return port;
}
})()], null));
} else {
var G__16364 = (i + (1));
i = G__16364;
continue;
}
} else {
return null;
}
break;
}
})();
var or__8388__auto__ = ret;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__8376__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__8376__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__8376__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__9674__auto__ = [];
var len__9667__auto___16370 = arguments.length;
var i__9668__auto___16371 = (0);
while(true){
if((i__9668__auto___16371 < len__9667__auto___16370)){
args__9674__auto__.push((arguments[i__9668__auto___16371]));

var G__16372 = (i__9668__auto___16371 + (1));
i__9668__auto___16371 = G__16372;
continue;
} else {
}
break;
}

var argseq__9675__auto__ = ((((1) < args__9674__auto__.length))?(new cljs.core.IndexedSeq(args__9674__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9675__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__16367){
var map__16368 = p__16367;
var map__16368__$1 = ((((!((map__16368 == null)))?((((map__16368.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16368.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16368):map__16368);
var opts = map__16368__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq16365){
var G__16366 = cljs.core.first.call(null,seq16365);
var seq16365__$1 = cljs.core.next.call(null,seq16365);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16366,seq16365__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__16374 = arguments.length;
switch (G__16374) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__16273__auto___16420 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___16420){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___16420){
return (function (state_16398){
var state_val_16399 = (state_16398[(1)]);
if((state_val_16399 === (7))){
var inst_16394 = (state_16398[(2)]);
var state_16398__$1 = state_16398;
var statearr_16400_16421 = state_16398__$1;
(statearr_16400_16421[(2)] = inst_16394);

(statearr_16400_16421[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16399 === (1))){
var state_16398__$1 = state_16398;
var statearr_16401_16422 = state_16398__$1;
(statearr_16401_16422[(2)] = null);

(statearr_16401_16422[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16399 === (4))){
var inst_16377 = (state_16398[(7)]);
var inst_16377__$1 = (state_16398[(2)]);
var inst_16378 = (inst_16377__$1 == null);
var state_16398__$1 = (function (){var statearr_16402 = state_16398;
(statearr_16402[(7)] = inst_16377__$1);

return statearr_16402;
})();
if(cljs.core.truth_(inst_16378)){
var statearr_16403_16423 = state_16398__$1;
(statearr_16403_16423[(1)] = (5));

} else {
var statearr_16404_16424 = state_16398__$1;
(statearr_16404_16424[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16399 === (13))){
var state_16398__$1 = state_16398;
var statearr_16405_16425 = state_16398__$1;
(statearr_16405_16425[(2)] = null);

(statearr_16405_16425[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16399 === (6))){
var inst_16377 = (state_16398[(7)]);
var state_16398__$1 = state_16398;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16398__$1,(11),to,inst_16377);
} else {
if((state_val_16399 === (3))){
var inst_16396 = (state_16398[(2)]);
var state_16398__$1 = state_16398;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16398__$1,inst_16396);
} else {
if((state_val_16399 === (12))){
var state_16398__$1 = state_16398;
var statearr_16406_16426 = state_16398__$1;
(statearr_16406_16426[(2)] = null);

(statearr_16406_16426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16399 === (2))){
var state_16398__$1 = state_16398;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16398__$1,(4),from);
} else {
if((state_val_16399 === (11))){
var inst_16387 = (state_16398[(2)]);
var state_16398__$1 = state_16398;
if(cljs.core.truth_(inst_16387)){
var statearr_16407_16427 = state_16398__$1;
(statearr_16407_16427[(1)] = (12));

} else {
var statearr_16408_16428 = state_16398__$1;
(statearr_16408_16428[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16399 === (9))){
var state_16398__$1 = state_16398;
var statearr_16409_16429 = state_16398__$1;
(statearr_16409_16429[(2)] = null);

(statearr_16409_16429[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16399 === (5))){
var state_16398__$1 = state_16398;
if(cljs.core.truth_(close_QMARK_)){
var statearr_16410_16430 = state_16398__$1;
(statearr_16410_16430[(1)] = (8));

} else {
var statearr_16411_16431 = state_16398__$1;
(statearr_16411_16431[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16399 === (14))){
var inst_16392 = (state_16398[(2)]);
var state_16398__$1 = state_16398;
var statearr_16412_16432 = state_16398__$1;
(statearr_16412_16432[(2)] = inst_16392);

(statearr_16412_16432[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16399 === (10))){
var inst_16384 = (state_16398[(2)]);
var state_16398__$1 = state_16398;
var statearr_16413_16433 = state_16398__$1;
(statearr_16413_16433[(2)] = inst_16384);

(statearr_16413_16433[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16399 === (8))){
var inst_16381 = cljs.core.async.close_BANG_.call(null,to);
var state_16398__$1 = state_16398;
var statearr_16414_16434 = state_16398__$1;
(statearr_16414_16434[(2)] = inst_16381);

(statearr_16414_16434[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___16420))
;
return ((function (switch__16183__auto__,c__16273__auto___16420){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_16415 = [null,null,null,null,null,null,null,null];
(statearr_16415[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_16415[(1)] = (1));

return statearr_16415;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_16398){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_16398);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e16416){if((e16416 instanceof Object)){
var ex__16187__auto__ = e16416;
var statearr_16417_16435 = state_16398;
(statearr_16417_16435[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16398);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16416;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16436 = state_16398;
state_16398 = G__16436;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_16398){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_16398);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___16420))
})();
var state__16275__auto__ = (function (){var statearr_16418 = f__16274__auto__.call(null);
(statearr_16418[(6)] = c__16273__auto___16420);

return statearr_16418;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___16420))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__16437){
var vec__16438 = p__16437;
var v = cljs.core.nth.call(null,vec__16438,(0),null);
var p = cljs.core.nth.call(null,vec__16438,(1),null);
var job = vec__16438;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__16273__auto___16609 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___16609,res,vec__16438,v,p,job,jobs,results){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___16609,res,vec__16438,v,p,job,jobs,results){
return (function (state_16445){
var state_val_16446 = (state_16445[(1)]);
if((state_val_16446 === (1))){
var state_16445__$1 = state_16445;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16445__$1,(2),res,v);
} else {
if((state_val_16446 === (2))){
var inst_16442 = (state_16445[(2)]);
var inst_16443 = cljs.core.async.close_BANG_.call(null,res);
var state_16445__$1 = (function (){var statearr_16447 = state_16445;
(statearr_16447[(7)] = inst_16442);

return statearr_16447;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16445__$1,inst_16443);
} else {
return null;
}
}
});})(c__16273__auto___16609,res,vec__16438,v,p,job,jobs,results))
;
return ((function (switch__16183__auto__,c__16273__auto___16609,res,vec__16438,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_16448 = [null,null,null,null,null,null,null,null];
(statearr_16448[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_16448[(1)] = (1));

return statearr_16448;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_16445){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_16445);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e16449){if((e16449 instanceof Object)){
var ex__16187__auto__ = e16449;
var statearr_16450_16610 = state_16445;
(statearr_16450_16610[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16445);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16449;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16611 = state_16445;
state_16445 = G__16611;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_16445){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_16445);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___16609,res,vec__16438,v,p,job,jobs,results))
})();
var state__16275__auto__ = (function (){var statearr_16451 = f__16274__auto__.call(null);
(statearr_16451[(6)] = c__16273__auto___16609);

return statearr_16451;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___16609,res,vec__16438,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__16452){
var vec__16453 = p__16452;
var v = cljs.core.nth.call(null,vec__16453,(0),null);
var p = cljs.core.nth.call(null,vec__16453,(1),null);
var job = vec__16453;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__9433__auto___16612 = n;
var __16613 = (0);
while(true){
if((__16613 < n__9433__auto___16612)){
var G__16456_16614 = type;
var G__16456_16615__$1 = (((G__16456_16614 instanceof cljs.core.Keyword))?G__16456_16614.fqn:null);
switch (G__16456_16615__$1) {
case "compute":
var c__16273__auto___16617 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__16613,c__16273__auto___16617,G__16456_16614,G__16456_16615__$1,n__9433__auto___16612,jobs,results,process,async){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (__16613,c__16273__auto___16617,G__16456_16614,G__16456_16615__$1,n__9433__auto___16612,jobs,results,process,async){
return (function (state_16469){
var state_val_16470 = (state_16469[(1)]);
if((state_val_16470 === (1))){
var state_16469__$1 = state_16469;
var statearr_16471_16618 = state_16469__$1;
(statearr_16471_16618[(2)] = null);

(statearr_16471_16618[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16470 === (2))){
var state_16469__$1 = state_16469;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16469__$1,(4),jobs);
} else {
if((state_val_16470 === (3))){
var inst_16467 = (state_16469[(2)]);
var state_16469__$1 = state_16469;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16469__$1,inst_16467);
} else {
if((state_val_16470 === (4))){
var inst_16459 = (state_16469[(2)]);
var inst_16460 = process.call(null,inst_16459);
var state_16469__$1 = state_16469;
if(cljs.core.truth_(inst_16460)){
var statearr_16472_16619 = state_16469__$1;
(statearr_16472_16619[(1)] = (5));

} else {
var statearr_16473_16620 = state_16469__$1;
(statearr_16473_16620[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16470 === (5))){
var state_16469__$1 = state_16469;
var statearr_16474_16621 = state_16469__$1;
(statearr_16474_16621[(2)] = null);

(statearr_16474_16621[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16470 === (6))){
var state_16469__$1 = state_16469;
var statearr_16475_16622 = state_16469__$1;
(statearr_16475_16622[(2)] = null);

(statearr_16475_16622[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16470 === (7))){
var inst_16465 = (state_16469[(2)]);
var state_16469__$1 = state_16469;
var statearr_16476_16623 = state_16469__$1;
(statearr_16476_16623[(2)] = inst_16465);

(statearr_16476_16623[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__16613,c__16273__auto___16617,G__16456_16614,G__16456_16615__$1,n__9433__auto___16612,jobs,results,process,async))
;
return ((function (__16613,switch__16183__auto__,c__16273__auto___16617,G__16456_16614,G__16456_16615__$1,n__9433__auto___16612,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_16477 = [null,null,null,null,null,null,null];
(statearr_16477[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_16477[(1)] = (1));

return statearr_16477;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_16469){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_16469);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e16478){if((e16478 instanceof Object)){
var ex__16187__auto__ = e16478;
var statearr_16479_16624 = state_16469;
(statearr_16479_16624[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16469);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16478;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16625 = state_16469;
state_16469 = G__16625;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_16469){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_16469);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(__16613,switch__16183__auto__,c__16273__auto___16617,G__16456_16614,G__16456_16615__$1,n__9433__auto___16612,jobs,results,process,async))
})();
var state__16275__auto__ = (function (){var statearr_16480 = f__16274__auto__.call(null);
(statearr_16480[(6)] = c__16273__auto___16617);

return statearr_16480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(__16613,c__16273__auto___16617,G__16456_16614,G__16456_16615__$1,n__9433__auto___16612,jobs,results,process,async))
);


break;
case "async":
var c__16273__auto___16626 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__16613,c__16273__auto___16626,G__16456_16614,G__16456_16615__$1,n__9433__auto___16612,jobs,results,process,async){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (__16613,c__16273__auto___16626,G__16456_16614,G__16456_16615__$1,n__9433__auto___16612,jobs,results,process,async){
return (function (state_16493){
var state_val_16494 = (state_16493[(1)]);
if((state_val_16494 === (1))){
var state_16493__$1 = state_16493;
var statearr_16495_16627 = state_16493__$1;
(statearr_16495_16627[(2)] = null);

(statearr_16495_16627[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16494 === (2))){
var state_16493__$1 = state_16493;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16493__$1,(4),jobs);
} else {
if((state_val_16494 === (3))){
var inst_16491 = (state_16493[(2)]);
var state_16493__$1 = state_16493;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16493__$1,inst_16491);
} else {
if((state_val_16494 === (4))){
var inst_16483 = (state_16493[(2)]);
var inst_16484 = async.call(null,inst_16483);
var state_16493__$1 = state_16493;
if(cljs.core.truth_(inst_16484)){
var statearr_16496_16628 = state_16493__$1;
(statearr_16496_16628[(1)] = (5));

} else {
var statearr_16497_16629 = state_16493__$1;
(statearr_16497_16629[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16494 === (5))){
var state_16493__$1 = state_16493;
var statearr_16498_16630 = state_16493__$1;
(statearr_16498_16630[(2)] = null);

(statearr_16498_16630[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16494 === (6))){
var state_16493__$1 = state_16493;
var statearr_16499_16631 = state_16493__$1;
(statearr_16499_16631[(2)] = null);

(statearr_16499_16631[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16494 === (7))){
var inst_16489 = (state_16493[(2)]);
var state_16493__$1 = state_16493;
var statearr_16500_16632 = state_16493__$1;
(statearr_16500_16632[(2)] = inst_16489);

(statearr_16500_16632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__16613,c__16273__auto___16626,G__16456_16614,G__16456_16615__$1,n__9433__auto___16612,jobs,results,process,async))
;
return ((function (__16613,switch__16183__auto__,c__16273__auto___16626,G__16456_16614,G__16456_16615__$1,n__9433__auto___16612,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_16501 = [null,null,null,null,null,null,null];
(statearr_16501[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_16501[(1)] = (1));

return statearr_16501;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_16493){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_16493);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e16502){if((e16502 instanceof Object)){
var ex__16187__auto__ = e16502;
var statearr_16503_16633 = state_16493;
(statearr_16503_16633[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16493);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16502;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16634 = state_16493;
state_16493 = G__16634;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_16493){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_16493);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(__16613,switch__16183__auto__,c__16273__auto___16626,G__16456_16614,G__16456_16615__$1,n__9433__auto___16612,jobs,results,process,async))
})();
var state__16275__auto__ = (function (){var statearr_16504 = f__16274__auto__.call(null);
(statearr_16504[(6)] = c__16273__auto___16626);

return statearr_16504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(__16613,c__16273__auto___16626,G__16456_16614,G__16456_16615__$1,n__9433__auto___16612,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__16456_16615__$1)].join('')));

}

var G__16635 = (__16613 + (1));
__16613 = G__16635;
continue;
} else {
}
break;
}

var c__16273__auto___16636 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___16636,jobs,results,process,async){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___16636,jobs,results,process,async){
return (function (state_16526){
var state_val_16527 = (state_16526[(1)]);
if((state_val_16527 === (1))){
var state_16526__$1 = state_16526;
var statearr_16528_16637 = state_16526__$1;
(statearr_16528_16637[(2)] = null);

(statearr_16528_16637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (2))){
var state_16526__$1 = state_16526;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16526__$1,(4),from);
} else {
if((state_val_16527 === (3))){
var inst_16524 = (state_16526[(2)]);
var state_16526__$1 = state_16526;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16526__$1,inst_16524);
} else {
if((state_val_16527 === (4))){
var inst_16507 = (state_16526[(7)]);
var inst_16507__$1 = (state_16526[(2)]);
var inst_16508 = (inst_16507__$1 == null);
var state_16526__$1 = (function (){var statearr_16529 = state_16526;
(statearr_16529[(7)] = inst_16507__$1);

return statearr_16529;
})();
if(cljs.core.truth_(inst_16508)){
var statearr_16530_16638 = state_16526__$1;
(statearr_16530_16638[(1)] = (5));

} else {
var statearr_16531_16639 = state_16526__$1;
(statearr_16531_16639[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (5))){
var inst_16510 = cljs.core.async.close_BANG_.call(null,jobs);
var state_16526__$1 = state_16526;
var statearr_16532_16640 = state_16526__$1;
(statearr_16532_16640[(2)] = inst_16510);

(statearr_16532_16640[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (6))){
var inst_16512 = (state_16526[(8)]);
var inst_16507 = (state_16526[(7)]);
var inst_16512__$1 = cljs.core.async.chan.call(null,(1));
var inst_16513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16514 = [inst_16507,inst_16512__$1];
var inst_16515 = (new cljs.core.PersistentVector(null,2,(5),inst_16513,inst_16514,null));
var state_16526__$1 = (function (){var statearr_16533 = state_16526;
(statearr_16533[(8)] = inst_16512__$1);

return statearr_16533;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16526__$1,(8),jobs,inst_16515);
} else {
if((state_val_16527 === (7))){
var inst_16522 = (state_16526[(2)]);
var state_16526__$1 = state_16526;
var statearr_16534_16641 = state_16526__$1;
(statearr_16534_16641[(2)] = inst_16522);

(statearr_16534_16641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (8))){
var inst_16512 = (state_16526[(8)]);
var inst_16517 = (state_16526[(2)]);
var state_16526__$1 = (function (){var statearr_16535 = state_16526;
(statearr_16535[(9)] = inst_16517);

return statearr_16535;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16526__$1,(9),results,inst_16512);
} else {
if((state_val_16527 === (9))){
var inst_16519 = (state_16526[(2)]);
var state_16526__$1 = (function (){var statearr_16536 = state_16526;
(statearr_16536[(10)] = inst_16519);

return statearr_16536;
})();
var statearr_16537_16642 = state_16526__$1;
(statearr_16537_16642[(2)] = null);

(statearr_16537_16642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___16636,jobs,results,process,async))
;
return ((function (switch__16183__auto__,c__16273__auto___16636,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_16538 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16538[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_16538[(1)] = (1));

return statearr_16538;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_16526){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_16526);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e16539){if((e16539 instanceof Object)){
var ex__16187__auto__ = e16539;
var statearr_16540_16643 = state_16526;
(statearr_16540_16643[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16526);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16539;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16644 = state_16526;
state_16526 = G__16644;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_16526){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_16526);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___16636,jobs,results,process,async))
})();
var state__16275__auto__ = (function (){var statearr_16541 = f__16274__auto__.call(null);
(statearr_16541[(6)] = c__16273__auto___16636);

return statearr_16541;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___16636,jobs,results,process,async))
);


var c__16273__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto__,jobs,results,process,async){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__,jobs,results,process,async){
return (function (state_16579){
var state_val_16580 = (state_16579[(1)]);
if((state_val_16580 === (7))){
var inst_16575 = (state_16579[(2)]);
var state_16579__$1 = state_16579;
var statearr_16581_16645 = state_16579__$1;
(statearr_16581_16645[(2)] = inst_16575);

(statearr_16581_16645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16580 === (20))){
var state_16579__$1 = state_16579;
var statearr_16582_16646 = state_16579__$1;
(statearr_16582_16646[(2)] = null);

(statearr_16582_16646[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16580 === (1))){
var state_16579__$1 = state_16579;
var statearr_16583_16647 = state_16579__$1;
(statearr_16583_16647[(2)] = null);

(statearr_16583_16647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16580 === (4))){
var inst_16544 = (state_16579[(7)]);
var inst_16544__$1 = (state_16579[(2)]);
var inst_16545 = (inst_16544__$1 == null);
var state_16579__$1 = (function (){var statearr_16584 = state_16579;
(statearr_16584[(7)] = inst_16544__$1);

return statearr_16584;
})();
if(cljs.core.truth_(inst_16545)){
var statearr_16585_16648 = state_16579__$1;
(statearr_16585_16648[(1)] = (5));

} else {
var statearr_16586_16649 = state_16579__$1;
(statearr_16586_16649[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16580 === (15))){
var inst_16557 = (state_16579[(8)]);
var state_16579__$1 = state_16579;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16579__$1,(18),to,inst_16557);
} else {
if((state_val_16580 === (21))){
var inst_16570 = (state_16579[(2)]);
var state_16579__$1 = state_16579;
var statearr_16587_16650 = state_16579__$1;
(statearr_16587_16650[(2)] = inst_16570);

(statearr_16587_16650[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16580 === (13))){
var inst_16572 = (state_16579[(2)]);
var state_16579__$1 = (function (){var statearr_16588 = state_16579;
(statearr_16588[(9)] = inst_16572);

return statearr_16588;
})();
var statearr_16589_16651 = state_16579__$1;
(statearr_16589_16651[(2)] = null);

(statearr_16589_16651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16580 === (6))){
var inst_16544 = (state_16579[(7)]);
var state_16579__$1 = state_16579;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16579__$1,(11),inst_16544);
} else {
if((state_val_16580 === (17))){
var inst_16565 = (state_16579[(2)]);
var state_16579__$1 = state_16579;
if(cljs.core.truth_(inst_16565)){
var statearr_16590_16652 = state_16579__$1;
(statearr_16590_16652[(1)] = (19));

} else {
var statearr_16591_16653 = state_16579__$1;
(statearr_16591_16653[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16580 === (3))){
var inst_16577 = (state_16579[(2)]);
var state_16579__$1 = state_16579;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16579__$1,inst_16577);
} else {
if((state_val_16580 === (12))){
var inst_16554 = (state_16579[(10)]);
var state_16579__$1 = state_16579;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16579__$1,(14),inst_16554);
} else {
if((state_val_16580 === (2))){
var state_16579__$1 = state_16579;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16579__$1,(4),results);
} else {
if((state_val_16580 === (19))){
var state_16579__$1 = state_16579;
var statearr_16592_16654 = state_16579__$1;
(statearr_16592_16654[(2)] = null);

(statearr_16592_16654[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16580 === (11))){
var inst_16554 = (state_16579[(2)]);
var state_16579__$1 = (function (){var statearr_16593 = state_16579;
(statearr_16593[(10)] = inst_16554);

return statearr_16593;
})();
var statearr_16594_16655 = state_16579__$1;
(statearr_16594_16655[(2)] = null);

(statearr_16594_16655[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16580 === (9))){
var state_16579__$1 = state_16579;
var statearr_16595_16656 = state_16579__$1;
(statearr_16595_16656[(2)] = null);

(statearr_16595_16656[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16580 === (5))){
var state_16579__$1 = state_16579;
if(cljs.core.truth_(close_QMARK_)){
var statearr_16596_16657 = state_16579__$1;
(statearr_16596_16657[(1)] = (8));

} else {
var statearr_16597_16658 = state_16579__$1;
(statearr_16597_16658[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16580 === (14))){
var inst_16557 = (state_16579[(8)]);
var inst_16559 = (state_16579[(11)]);
var inst_16557__$1 = (state_16579[(2)]);
var inst_16558 = (inst_16557__$1 == null);
var inst_16559__$1 = cljs.core.not.call(null,inst_16558);
var state_16579__$1 = (function (){var statearr_16598 = state_16579;
(statearr_16598[(8)] = inst_16557__$1);

(statearr_16598[(11)] = inst_16559__$1);

return statearr_16598;
})();
if(inst_16559__$1){
var statearr_16599_16659 = state_16579__$1;
(statearr_16599_16659[(1)] = (15));

} else {
var statearr_16600_16660 = state_16579__$1;
(statearr_16600_16660[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16580 === (16))){
var inst_16559 = (state_16579[(11)]);
var state_16579__$1 = state_16579;
var statearr_16601_16661 = state_16579__$1;
(statearr_16601_16661[(2)] = inst_16559);

(statearr_16601_16661[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16580 === (10))){
var inst_16551 = (state_16579[(2)]);
var state_16579__$1 = state_16579;
var statearr_16602_16662 = state_16579__$1;
(statearr_16602_16662[(2)] = inst_16551);

(statearr_16602_16662[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16580 === (18))){
var inst_16562 = (state_16579[(2)]);
var state_16579__$1 = state_16579;
var statearr_16603_16663 = state_16579__$1;
(statearr_16603_16663[(2)] = inst_16562);

(statearr_16603_16663[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16580 === (8))){
var inst_16548 = cljs.core.async.close_BANG_.call(null,to);
var state_16579__$1 = state_16579;
var statearr_16604_16664 = state_16579__$1;
(statearr_16604_16664[(2)] = inst_16548);

(statearr_16604_16664[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto__,jobs,results,process,async))
;
return ((function (switch__16183__auto__,c__16273__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_16605 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16605[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_16605[(1)] = (1));

return statearr_16605;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_16579){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_16579);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e16606){if((e16606 instanceof Object)){
var ex__16187__auto__ = e16606;
var statearr_16607_16665 = state_16579;
(statearr_16607_16665[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16579);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16606;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16666 = state_16579;
state_16579 = G__16666;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_16579){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_16579);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__,jobs,results,process,async))
})();
var state__16275__auto__ = (function (){var statearr_16608 = f__16274__auto__.call(null);
(statearr_16608[(6)] = c__16273__auto__);

return statearr_16608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto__,jobs,results,process,async))
);

return c__16273__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__16668 = arguments.length;
switch (G__16668) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__16671 = arguments.length;
switch (G__16671) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__16674 = arguments.length;
switch (G__16674) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__16273__auto___16723 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___16723,tc,fc){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___16723,tc,fc){
return (function (state_16700){
var state_val_16701 = (state_16700[(1)]);
if((state_val_16701 === (7))){
var inst_16696 = (state_16700[(2)]);
var state_16700__$1 = state_16700;
var statearr_16702_16724 = state_16700__$1;
(statearr_16702_16724[(2)] = inst_16696);

(statearr_16702_16724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16701 === (1))){
var state_16700__$1 = state_16700;
var statearr_16703_16725 = state_16700__$1;
(statearr_16703_16725[(2)] = null);

(statearr_16703_16725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16701 === (4))){
var inst_16677 = (state_16700[(7)]);
var inst_16677__$1 = (state_16700[(2)]);
var inst_16678 = (inst_16677__$1 == null);
var state_16700__$1 = (function (){var statearr_16704 = state_16700;
(statearr_16704[(7)] = inst_16677__$1);

return statearr_16704;
})();
if(cljs.core.truth_(inst_16678)){
var statearr_16705_16726 = state_16700__$1;
(statearr_16705_16726[(1)] = (5));

} else {
var statearr_16706_16727 = state_16700__$1;
(statearr_16706_16727[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16701 === (13))){
var state_16700__$1 = state_16700;
var statearr_16707_16728 = state_16700__$1;
(statearr_16707_16728[(2)] = null);

(statearr_16707_16728[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16701 === (6))){
var inst_16677 = (state_16700[(7)]);
var inst_16683 = p.call(null,inst_16677);
var state_16700__$1 = state_16700;
if(cljs.core.truth_(inst_16683)){
var statearr_16708_16729 = state_16700__$1;
(statearr_16708_16729[(1)] = (9));

} else {
var statearr_16709_16730 = state_16700__$1;
(statearr_16709_16730[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16701 === (3))){
var inst_16698 = (state_16700[(2)]);
var state_16700__$1 = state_16700;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16700__$1,inst_16698);
} else {
if((state_val_16701 === (12))){
var state_16700__$1 = state_16700;
var statearr_16710_16731 = state_16700__$1;
(statearr_16710_16731[(2)] = null);

(statearr_16710_16731[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16701 === (2))){
var state_16700__$1 = state_16700;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16700__$1,(4),ch);
} else {
if((state_val_16701 === (11))){
var inst_16677 = (state_16700[(7)]);
var inst_16687 = (state_16700[(2)]);
var state_16700__$1 = state_16700;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16700__$1,(8),inst_16687,inst_16677);
} else {
if((state_val_16701 === (9))){
var state_16700__$1 = state_16700;
var statearr_16711_16732 = state_16700__$1;
(statearr_16711_16732[(2)] = tc);

(statearr_16711_16732[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16701 === (5))){
var inst_16680 = cljs.core.async.close_BANG_.call(null,tc);
var inst_16681 = cljs.core.async.close_BANG_.call(null,fc);
var state_16700__$1 = (function (){var statearr_16712 = state_16700;
(statearr_16712[(8)] = inst_16680);

return statearr_16712;
})();
var statearr_16713_16733 = state_16700__$1;
(statearr_16713_16733[(2)] = inst_16681);

(statearr_16713_16733[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16701 === (14))){
var inst_16694 = (state_16700[(2)]);
var state_16700__$1 = state_16700;
var statearr_16714_16734 = state_16700__$1;
(statearr_16714_16734[(2)] = inst_16694);

(statearr_16714_16734[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16701 === (10))){
var state_16700__$1 = state_16700;
var statearr_16715_16735 = state_16700__$1;
(statearr_16715_16735[(2)] = fc);

(statearr_16715_16735[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16701 === (8))){
var inst_16689 = (state_16700[(2)]);
var state_16700__$1 = state_16700;
if(cljs.core.truth_(inst_16689)){
var statearr_16716_16736 = state_16700__$1;
(statearr_16716_16736[(1)] = (12));

} else {
var statearr_16717_16737 = state_16700__$1;
(statearr_16717_16737[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___16723,tc,fc))
;
return ((function (switch__16183__auto__,c__16273__auto___16723,tc,fc){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_16718 = [null,null,null,null,null,null,null,null,null];
(statearr_16718[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_16718[(1)] = (1));

return statearr_16718;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_16700){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_16700);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e16719){if((e16719 instanceof Object)){
var ex__16187__auto__ = e16719;
var statearr_16720_16738 = state_16700;
(statearr_16720_16738[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16700);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16719;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16739 = state_16700;
state_16700 = G__16739;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_16700){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_16700);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___16723,tc,fc))
})();
var state__16275__auto__ = (function (){var statearr_16721 = f__16274__auto__.call(null);
(statearr_16721[(6)] = c__16273__auto___16723);

return statearr_16721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___16723,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__16273__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto__){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__){
return (function (state_16760){
var state_val_16761 = (state_16760[(1)]);
if((state_val_16761 === (7))){
var inst_16756 = (state_16760[(2)]);
var state_16760__$1 = state_16760;
var statearr_16762_16780 = state_16760__$1;
(statearr_16762_16780[(2)] = inst_16756);

(statearr_16762_16780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16761 === (1))){
var inst_16740 = init;
var state_16760__$1 = (function (){var statearr_16763 = state_16760;
(statearr_16763[(7)] = inst_16740);

return statearr_16763;
})();
var statearr_16764_16781 = state_16760__$1;
(statearr_16764_16781[(2)] = null);

(statearr_16764_16781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16761 === (4))){
var inst_16743 = (state_16760[(8)]);
var inst_16743__$1 = (state_16760[(2)]);
var inst_16744 = (inst_16743__$1 == null);
var state_16760__$1 = (function (){var statearr_16765 = state_16760;
(statearr_16765[(8)] = inst_16743__$1);

return statearr_16765;
})();
if(cljs.core.truth_(inst_16744)){
var statearr_16766_16782 = state_16760__$1;
(statearr_16766_16782[(1)] = (5));

} else {
var statearr_16767_16783 = state_16760__$1;
(statearr_16767_16783[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16761 === (6))){
var inst_16740 = (state_16760[(7)]);
var inst_16743 = (state_16760[(8)]);
var inst_16747 = (state_16760[(9)]);
var inst_16747__$1 = f.call(null,inst_16740,inst_16743);
var inst_16748 = cljs.core.reduced_QMARK_.call(null,inst_16747__$1);
var state_16760__$1 = (function (){var statearr_16768 = state_16760;
(statearr_16768[(9)] = inst_16747__$1);

return statearr_16768;
})();
if(inst_16748){
var statearr_16769_16784 = state_16760__$1;
(statearr_16769_16784[(1)] = (8));

} else {
var statearr_16770_16785 = state_16760__$1;
(statearr_16770_16785[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16761 === (3))){
var inst_16758 = (state_16760[(2)]);
var state_16760__$1 = state_16760;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16760__$1,inst_16758);
} else {
if((state_val_16761 === (2))){
var state_16760__$1 = state_16760;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16760__$1,(4),ch);
} else {
if((state_val_16761 === (9))){
var inst_16747 = (state_16760[(9)]);
var inst_16740 = inst_16747;
var state_16760__$1 = (function (){var statearr_16771 = state_16760;
(statearr_16771[(7)] = inst_16740);

return statearr_16771;
})();
var statearr_16772_16786 = state_16760__$1;
(statearr_16772_16786[(2)] = null);

(statearr_16772_16786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16761 === (5))){
var inst_16740 = (state_16760[(7)]);
var state_16760__$1 = state_16760;
var statearr_16773_16787 = state_16760__$1;
(statearr_16773_16787[(2)] = inst_16740);

(statearr_16773_16787[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16761 === (10))){
var inst_16754 = (state_16760[(2)]);
var state_16760__$1 = state_16760;
var statearr_16774_16788 = state_16760__$1;
(statearr_16774_16788[(2)] = inst_16754);

(statearr_16774_16788[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16761 === (8))){
var inst_16747 = (state_16760[(9)]);
var inst_16750 = cljs.core.deref.call(null,inst_16747);
var state_16760__$1 = state_16760;
var statearr_16775_16789 = state_16760__$1;
(statearr_16775_16789[(2)] = inst_16750);

(statearr_16775_16789[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto__))
;
return ((function (switch__16183__auto__,c__16273__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__16184__auto__ = null;
var cljs$core$async$reduce_$_state_machine__16184__auto____0 = (function (){
var statearr_16776 = [null,null,null,null,null,null,null,null,null,null];
(statearr_16776[(0)] = cljs$core$async$reduce_$_state_machine__16184__auto__);

(statearr_16776[(1)] = (1));

return statearr_16776;
});
var cljs$core$async$reduce_$_state_machine__16184__auto____1 = (function (state_16760){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_16760);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e16777){if((e16777 instanceof Object)){
var ex__16187__auto__ = e16777;
var statearr_16778_16790 = state_16760;
(statearr_16778_16790[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16760);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16777;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16791 = state_16760;
state_16760 = G__16791;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__16184__auto__ = function(state_16760){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__16184__auto____1.call(this,state_16760);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__16184__auto____0;
cljs$core$async$reduce_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__16184__auto____1;
return cljs$core$async$reduce_$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__))
})();
var state__16275__auto__ = (function (){var statearr_16779 = f__16274__auto__.call(null);
(statearr_16779[(6)] = c__16273__auto__);

return statearr_16779;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto__))
);

return c__16273__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__16273__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto__,f__$1){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__,f__$1){
return (function (state_16797){
var state_val_16798 = (state_16797[(1)]);
if((state_val_16798 === (1))){
var inst_16792 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_16797__$1 = state_16797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16797__$1,(2),inst_16792);
} else {
if((state_val_16798 === (2))){
var inst_16794 = (state_16797[(2)]);
var inst_16795 = f__$1.call(null,inst_16794);
var state_16797__$1 = state_16797;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16797__$1,inst_16795);
} else {
return null;
}
}
});})(c__16273__auto__,f__$1))
;
return ((function (switch__16183__auto__,c__16273__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__16184__auto__ = null;
var cljs$core$async$transduce_$_state_machine__16184__auto____0 = (function (){
var statearr_16799 = [null,null,null,null,null,null,null];
(statearr_16799[(0)] = cljs$core$async$transduce_$_state_machine__16184__auto__);

(statearr_16799[(1)] = (1));

return statearr_16799;
});
var cljs$core$async$transduce_$_state_machine__16184__auto____1 = (function (state_16797){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_16797);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e16800){if((e16800 instanceof Object)){
var ex__16187__auto__ = e16800;
var statearr_16801_16803 = state_16797;
(statearr_16801_16803[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16797);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16800;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16804 = state_16797;
state_16797 = G__16804;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__16184__auto__ = function(state_16797){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__16184__auto____1.call(this,state_16797);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__16184__auto____0;
cljs$core$async$transduce_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__16184__auto____1;
return cljs$core$async$transduce_$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__,f__$1))
})();
var state__16275__auto__ = (function (){var statearr_16802 = f__16274__auto__.call(null);
(statearr_16802[(6)] = c__16273__auto__);

return statearr_16802;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto__,f__$1))
);

return c__16273__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__16806 = arguments.length;
switch (G__16806) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__16273__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto__){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__){
return (function (state_16831){
var state_val_16832 = (state_16831[(1)]);
if((state_val_16832 === (7))){
var inst_16813 = (state_16831[(2)]);
var state_16831__$1 = state_16831;
var statearr_16833_16854 = state_16831__$1;
(statearr_16833_16854[(2)] = inst_16813);

(statearr_16833_16854[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16832 === (1))){
var inst_16807 = cljs.core.seq.call(null,coll);
var inst_16808 = inst_16807;
var state_16831__$1 = (function (){var statearr_16834 = state_16831;
(statearr_16834[(7)] = inst_16808);

return statearr_16834;
})();
var statearr_16835_16855 = state_16831__$1;
(statearr_16835_16855[(2)] = null);

(statearr_16835_16855[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16832 === (4))){
var inst_16808 = (state_16831[(7)]);
var inst_16811 = cljs.core.first.call(null,inst_16808);
var state_16831__$1 = state_16831;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16831__$1,(7),ch,inst_16811);
} else {
if((state_val_16832 === (13))){
var inst_16825 = (state_16831[(2)]);
var state_16831__$1 = state_16831;
var statearr_16836_16856 = state_16831__$1;
(statearr_16836_16856[(2)] = inst_16825);

(statearr_16836_16856[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16832 === (6))){
var inst_16816 = (state_16831[(2)]);
var state_16831__$1 = state_16831;
if(cljs.core.truth_(inst_16816)){
var statearr_16837_16857 = state_16831__$1;
(statearr_16837_16857[(1)] = (8));

} else {
var statearr_16838_16858 = state_16831__$1;
(statearr_16838_16858[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16832 === (3))){
var inst_16829 = (state_16831[(2)]);
var state_16831__$1 = state_16831;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16831__$1,inst_16829);
} else {
if((state_val_16832 === (12))){
var state_16831__$1 = state_16831;
var statearr_16839_16859 = state_16831__$1;
(statearr_16839_16859[(2)] = null);

(statearr_16839_16859[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16832 === (2))){
var inst_16808 = (state_16831[(7)]);
var state_16831__$1 = state_16831;
if(cljs.core.truth_(inst_16808)){
var statearr_16840_16860 = state_16831__$1;
(statearr_16840_16860[(1)] = (4));

} else {
var statearr_16841_16861 = state_16831__$1;
(statearr_16841_16861[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16832 === (11))){
var inst_16822 = cljs.core.async.close_BANG_.call(null,ch);
var state_16831__$1 = state_16831;
var statearr_16842_16862 = state_16831__$1;
(statearr_16842_16862[(2)] = inst_16822);

(statearr_16842_16862[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16832 === (9))){
var state_16831__$1 = state_16831;
if(cljs.core.truth_(close_QMARK_)){
var statearr_16843_16863 = state_16831__$1;
(statearr_16843_16863[(1)] = (11));

} else {
var statearr_16844_16864 = state_16831__$1;
(statearr_16844_16864[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16832 === (5))){
var inst_16808 = (state_16831[(7)]);
var state_16831__$1 = state_16831;
var statearr_16845_16865 = state_16831__$1;
(statearr_16845_16865[(2)] = inst_16808);

(statearr_16845_16865[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16832 === (10))){
var inst_16827 = (state_16831[(2)]);
var state_16831__$1 = state_16831;
var statearr_16846_16866 = state_16831__$1;
(statearr_16846_16866[(2)] = inst_16827);

(statearr_16846_16866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16832 === (8))){
var inst_16808 = (state_16831[(7)]);
var inst_16818 = cljs.core.next.call(null,inst_16808);
var inst_16808__$1 = inst_16818;
var state_16831__$1 = (function (){var statearr_16847 = state_16831;
(statearr_16847[(7)] = inst_16808__$1);

return statearr_16847;
})();
var statearr_16848_16867 = state_16831__$1;
(statearr_16848_16867[(2)] = null);

(statearr_16848_16867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto__))
;
return ((function (switch__16183__auto__,c__16273__auto__){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_16849 = [null,null,null,null,null,null,null,null];
(statearr_16849[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_16849[(1)] = (1));

return statearr_16849;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_16831){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_16831);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e16850){if((e16850 instanceof Object)){
var ex__16187__auto__ = e16850;
var statearr_16851_16868 = state_16831;
(statearr_16851_16868[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16831);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16850;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16869 = state_16831;
state_16831 = G__16869;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_16831){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_16831);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__))
})();
var state__16275__auto__ = (function (){var statearr_16852 = f__16274__auto__.call(null);
(statearr_16852[(6)] = c__16273__auto__);

return statearr_16852;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto__))
);

return c__16273__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__9121__auto__ = (((_ == null))?null:_);
var m__9122__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,_);
} else {
var m__9122__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__9121__auto__ = (((m == null))?null:m);
var m__9122__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__9122__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__9121__auto__ = (((m == null))?null:m);
var m__9122__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m,ch);
} else {
var m__9122__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__9121__auto__ = (((m == null))?null:m);
var m__9122__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m);
} else {
var m__9122__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async16870 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16870 = (function (ch,cs,meta16871){
this.ch = ch;
this.cs = cs;
this.meta16871 = meta16871;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16870.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_16872,meta16871__$1){
var self__ = this;
var _16872__$1 = this;
return (new cljs.core.async.t_cljs$core$async16870(self__.ch,self__.cs,meta16871__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async16870.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_16872){
var self__ = this;
var _16872__$1 = this;
return self__.meta16871;
});})(cs))
;

cljs.core.async.t_cljs$core$async16870.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16870.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async16870.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16870.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async16870.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async16870.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async16870.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta16871","meta16871",-1109999131,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async16870.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16870.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16870";

cljs.core.async.t_cljs$core$async16870.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async16870");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async16870 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async16870(ch__$1,cs__$1,meta16871){
return (new cljs.core.async.t_cljs$core$async16870(ch__$1,cs__$1,meta16871));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async16870(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__16273__auto___17092 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___17092,cs,m,dchan,dctr,done){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___17092,cs,m,dchan,dctr,done){
return (function (state_17007){
var state_val_17008 = (state_17007[(1)]);
if((state_val_17008 === (7))){
var inst_17003 = (state_17007[(2)]);
var state_17007__$1 = state_17007;
var statearr_17009_17093 = state_17007__$1;
(statearr_17009_17093[(2)] = inst_17003);

(statearr_17009_17093[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (20))){
var inst_16906 = (state_17007[(7)]);
var inst_16918 = cljs.core.first.call(null,inst_16906);
var inst_16919 = cljs.core.nth.call(null,inst_16918,(0),null);
var inst_16920 = cljs.core.nth.call(null,inst_16918,(1),null);
var state_17007__$1 = (function (){var statearr_17010 = state_17007;
(statearr_17010[(8)] = inst_16919);

return statearr_17010;
})();
if(cljs.core.truth_(inst_16920)){
var statearr_17011_17094 = state_17007__$1;
(statearr_17011_17094[(1)] = (22));

} else {
var statearr_17012_17095 = state_17007__$1;
(statearr_17012_17095[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (27))){
var inst_16955 = (state_17007[(9)]);
var inst_16950 = (state_17007[(10)]);
var inst_16948 = (state_17007[(11)]);
var inst_16875 = (state_17007[(12)]);
var inst_16955__$1 = cljs.core._nth.call(null,inst_16948,inst_16950);
var inst_16956 = cljs.core.async.put_BANG_.call(null,inst_16955__$1,inst_16875,done);
var state_17007__$1 = (function (){var statearr_17013 = state_17007;
(statearr_17013[(9)] = inst_16955__$1);

return statearr_17013;
})();
if(cljs.core.truth_(inst_16956)){
var statearr_17014_17096 = state_17007__$1;
(statearr_17014_17096[(1)] = (30));

} else {
var statearr_17015_17097 = state_17007__$1;
(statearr_17015_17097[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (1))){
var state_17007__$1 = state_17007;
var statearr_17016_17098 = state_17007__$1;
(statearr_17016_17098[(2)] = null);

(statearr_17016_17098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (24))){
var inst_16906 = (state_17007[(7)]);
var inst_16925 = (state_17007[(2)]);
var inst_16926 = cljs.core.next.call(null,inst_16906);
var inst_16884 = inst_16926;
var inst_16885 = null;
var inst_16886 = (0);
var inst_16887 = (0);
var state_17007__$1 = (function (){var statearr_17017 = state_17007;
(statearr_17017[(13)] = inst_16886);

(statearr_17017[(14)] = inst_16884);

(statearr_17017[(15)] = inst_16925);

(statearr_17017[(16)] = inst_16887);

(statearr_17017[(17)] = inst_16885);

return statearr_17017;
})();
var statearr_17018_17099 = state_17007__$1;
(statearr_17018_17099[(2)] = null);

(statearr_17018_17099[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (39))){
var state_17007__$1 = state_17007;
var statearr_17022_17100 = state_17007__$1;
(statearr_17022_17100[(2)] = null);

(statearr_17022_17100[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (4))){
var inst_16875 = (state_17007[(12)]);
var inst_16875__$1 = (state_17007[(2)]);
var inst_16876 = (inst_16875__$1 == null);
var state_17007__$1 = (function (){var statearr_17023 = state_17007;
(statearr_17023[(12)] = inst_16875__$1);

return statearr_17023;
})();
if(cljs.core.truth_(inst_16876)){
var statearr_17024_17101 = state_17007__$1;
(statearr_17024_17101[(1)] = (5));

} else {
var statearr_17025_17102 = state_17007__$1;
(statearr_17025_17102[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (15))){
var inst_16886 = (state_17007[(13)]);
var inst_16884 = (state_17007[(14)]);
var inst_16887 = (state_17007[(16)]);
var inst_16885 = (state_17007[(17)]);
var inst_16902 = (state_17007[(2)]);
var inst_16903 = (inst_16887 + (1));
var tmp17019 = inst_16886;
var tmp17020 = inst_16884;
var tmp17021 = inst_16885;
var inst_16884__$1 = tmp17020;
var inst_16885__$1 = tmp17021;
var inst_16886__$1 = tmp17019;
var inst_16887__$1 = inst_16903;
var state_17007__$1 = (function (){var statearr_17026 = state_17007;
(statearr_17026[(13)] = inst_16886__$1);

(statearr_17026[(14)] = inst_16884__$1);

(statearr_17026[(16)] = inst_16887__$1);

(statearr_17026[(18)] = inst_16902);

(statearr_17026[(17)] = inst_16885__$1);

return statearr_17026;
})();
var statearr_17027_17103 = state_17007__$1;
(statearr_17027_17103[(2)] = null);

(statearr_17027_17103[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (21))){
var inst_16929 = (state_17007[(2)]);
var state_17007__$1 = state_17007;
var statearr_17031_17104 = state_17007__$1;
(statearr_17031_17104[(2)] = inst_16929);

(statearr_17031_17104[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (31))){
var inst_16955 = (state_17007[(9)]);
var inst_16959 = done.call(null,null);
var inst_16960 = cljs.core.async.untap_STAR_.call(null,m,inst_16955);
var state_17007__$1 = (function (){var statearr_17032 = state_17007;
(statearr_17032[(19)] = inst_16959);

return statearr_17032;
})();
var statearr_17033_17105 = state_17007__$1;
(statearr_17033_17105[(2)] = inst_16960);

(statearr_17033_17105[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (32))){
var inst_16950 = (state_17007[(10)]);
var inst_16948 = (state_17007[(11)]);
var inst_16949 = (state_17007[(20)]);
var inst_16947 = (state_17007[(21)]);
var inst_16962 = (state_17007[(2)]);
var inst_16963 = (inst_16950 + (1));
var tmp17028 = inst_16948;
var tmp17029 = inst_16949;
var tmp17030 = inst_16947;
var inst_16947__$1 = tmp17030;
var inst_16948__$1 = tmp17028;
var inst_16949__$1 = tmp17029;
var inst_16950__$1 = inst_16963;
var state_17007__$1 = (function (){var statearr_17034 = state_17007;
(statearr_17034[(10)] = inst_16950__$1);

(statearr_17034[(22)] = inst_16962);

(statearr_17034[(11)] = inst_16948__$1);

(statearr_17034[(20)] = inst_16949__$1);

(statearr_17034[(21)] = inst_16947__$1);

return statearr_17034;
})();
var statearr_17035_17106 = state_17007__$1;
(statearr_17035_17106[(2)] = null);

(statearr_17035_17106[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (40))){
var inst_16975 = (state_17007[(23)]);
var inst_16979 = done.call(null,null);
var inst_16980 = cljs.core.async.untap_STAR_.call(null,m,inst_16975);
var state_17007__$1 = (function (){var statearr_17036 = state_17007;
(statearr_17036[(24)] = inst_16979);

return statearr_17036;
})();
var statearr_17037_17107 = state_17007__$1;
(statearr_17037_17107[(2)] = inst_16980);

(statearr_17037_17107[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (33))){
var inst_16966 = (state_17007[(25)]);
var inst_16968 = cljs.core.chunked_seq_QMARK_.call(null,inst_16966);
var state_17007__$1 = state_17007;
if(inst_16968){
var statearr_17038_17108 = state_17007__$1;
(statearr_17038_17108[(1)] = (36));

} else {
var statearr_17039_17109 = state_17007__$1;
(statearr_17039_17109[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (13))){
var inst_16896 = (state_17007[(26)]);
var inst_16899 = cljs.core.async.close_BANG_.call(null,inst_16896);
var state_17007__$1 = state_17007;
var statearr_17040_17110 = state_17007__$1;
(statearr_17040_17110[(2)] = inst_16899);

(statearr_17040_17110[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (22))){
var inst_16919 = (state_17007[(8)]);
var inst_16922 = cljs.core.async.close_BANG_.call(null,inst_16919);
var state_17007__$1 = state_17007;
var statearr_17041_17111 = state_17007__$1;
(statearr_17041_17111[(2)] = inst_16922);

(statearr_17041_17111[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (36))){
var inst_16966 = (state_17007[(25)]);
var inst_16970 = cljs.core.chunk_first.call(null,inst_16966);
var inst_16971 = cljs.core.chunk_rest.call(null,inst_16966);
var inst_16972 = cljs.core.count.call(null,inst_16970);
var inst_16947 = inst_16971;
var inst_16948 = inst_16970;
var inst_16949 = inst_16972;
var inst_16950 = (0);
var state_17007__$1 = (function (){var statearr_17042 = state_17007;
(statearr_17042[(10)] = inst_16950);

(statearr_17042[(11)] = inst_16948);

(statearr_17042[(20)] = inst_16949);

(statearr_17042[(21)] = inst_16947);

return statearr_17042;
})();
var statearr_17043_17112 = state_17007__$1;
(statearr_17043_17112[(2)] = null);

(statearr_17043_17112[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (41))){
var inst_16966 = (state_17007[(25)]);
var inst_16982 = (state_17007[(2)]);
var inst_16983 = cljs.core.next.call(null,inst_16966);
var inst_16947 = inst_16983;
var inst_16948 = null;
var inst_16949 = (0);
var inst_16950 = (0);
var state_17007__$1 = (function (){var statearr_17044 = state_17007;
(statearr_17044[(10)] = inst_16950);

(statearr_17044[(27)] = inst_16982);

(statearr_17044[(11)] = inst_16948);

(statearr_17044[(20)] = inst_16949);

(statearr_17044[(21)] = inst_16947);

return statearr_17044;
})();
var statearr_17045_17113 = state_17007__$1;
(statearr_17045_17113[(2)] = null);

(statearr_17045_17113[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (43))){
var state_17007__$1 = state_17007;
var statearr_17046_17114 = state_17007__$1;
(statearr_17046_17114[(2)] = null);

(statearr_17046_17114[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (29))){
var inst_16991 = (state_17007[(2)]);
var state_17007__$1 = state_17007;
var statearr_17047_17115 = state_17007__$1;
(statearr_17047_17115[(2)] = inst_16991);

(statearr_17047_17115[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (44))){
var inst_17000 = (state_17007[(2)]);
var state_17007__$1 = (function (){var statearr_17048 = state_17007;
(statearr_17048[(28)] = inst_17000);

return statearr_17048;
})();
var statearr_17049_17116 = state_17007__$1;
(statearr_17049_17116[(2)] = null);

(statearr_17049_17116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (6))){
var inst_16939 = (state_17007[(29)]);
var inst_16938 = cljs.core.deref.call(null,cs);
var inst_16939__$1 = cljs.core.keys.call(null,inst_16938);
var inst_16940 = cljs.core.count.call(null,inst_16939__$1);
var inst_16941 = cljs.core.reset_BANG_.call(null,dctr,inst_16940);
var inst_16946 = cljs.core.seq.call(null,inst_16939__$1);
var inst_16947 = inst_16946;
var inst_16948 = null;
var inst_16949 = (0);
var inst_16950 = (0);
var state_17007__$1 = (function (){var statearr_17050 = state_17007;
(statearr_17050[(10)] = inst_16950);

(statearr_17050[(11)] = inst_16948);

(statearr_17050[(30)] = inst_16941);

(statearr_17050[(20)] = inst_16949);

(statearr_17050[(29)] = inst_16939__$1);

(statearr_17050[(21)] = inst_16947);

return statearr_17050;
})();
var statearr_17051_17117 = state_17007__$1;
(statearr_17051_17117[(2)] = null);

(statearr_17051_17117[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (28))){
var inst_16966 = (state_17007[(25)]);
var inst_16947 = (state_17007[(21)]);
var inst_16966__$1 = cljs.core.seq.call(null,inst_16947);
var state_17007__$1 = (function (){var statearr_17052 = state_17007;
(statearr_17052[(25)] = inst_16966__$1);

return statearr_17052;
})();
if(inst_16966__$1){
var statearr_17053_17118 = state_17007__$1;
(statearr_17053_17118[(1)] = (33));

} else {
var statearr_17054_17119 = state_17007__$1;
(statearr_17054_17119[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (25))){
var inst_16950 = (state_17007[(10)]);
var inst_16949 = (state_17007[(20)]);
var inst_16952 = (inst_16950 < inst_16949);
var inst_16953 = inst_16952;
var state_17007__$1 = state_17007;
if(cljs.core.truth_(inst_16953)){
var statearr_17055_17120 = state_17007__$1;
(statearr_17055_17120[(1)] = (27));

} else {
var statearr_17056_17121 = state_17007__$1;
(statearr_17056_17121[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (34))){
var state_17007__$1 = state_17007;
var statearr_17057_17122 = state_17007__$1;
(statearr_17057_17122[(2)] = null);

(statearr_17057_17122[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (17))){
var state_17007__$1 = state_17007;
var statearr_17058_17123 = state_17007__$1;
(statearr_17058_17123[(2)] = null);

(statearr_17058_17123[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (3))){
var inst_17005 = (state_17007[(2)]);
var state_17007__$1 = state_17007;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17007__$1,inst_17005);
} else {
if((state_val_17008 === (12))){
var inst_16934 = (state_17007[(2)]);
var state_17007__$1 = state_17007;
var statearr_17059_17124 = state_17007__$1;
(statearr_17059_17124[(2)] = inst_16934);

(statearr_17059_17124[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (2))){
var state_17007__$1 = state_17007;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17007__$1,(4),ch);
} else {
if((state_val_17008 === (23))){
var state_17007__$1 = state_17007;
var statearr_17060_17125 = state_17007__$1;
(statearr_17060_17125[(2)] = null);

(statearr_17060_17125[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (35))){
var inst_16989 = (state_17007[(2)]);
var state_17007__$1 = state_17007;
var statearr_17061_17126 = state_17007__$1;
(statearr_17061_17126[(2)] = inst_16989);

(statearr_17061_17126[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (19))){
var inst_16906 = (state_17007[(7)]);
var inst_16910 = cljs.core.chunk_first.call(null,inst_16906);
var inst_16911 = cljs.core.chunk_rest.call(null,inst_16906);
var inst_16912 = cljs.core.count.call(null,inst_16910);
var inst_16884 = inst_16911;
var inst_16885 = inst_16910;
var inst_16886 = inst_16912;
var inst_16887 = (0);
var state_17007__$1 = (function (){var statearr_17062 = state_17007;
(statearr_17062[(13)] = inst_16886);

(statearr_17062[(14)] = inst_16884);

(statearr_17062[(16)] = inst_16887);

(statearr_17062[(17)] = inst_16885);

return statearr_17062;
})();
var statearr_17063_17127 = state_17007__$1;
(statearr_17063_17127[(2)] = null);

(statearr_17063_17127[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (11))){
var inst_16884 = (state_17007[(14)]);
var inst_16906 = (state_17007[(7)]);
var inst_16906__$1 = cljs.core.seq.call(null,inst_16884);
var state_17007__$1 = (function (){var statearr_17064 = state_17007;
(statearr_17064[(7)] = inst_16906__$1);

return statearr_17064;
})();
if(inst_16906__$1){
var statearr_17065_17128 = state_17007__$1;
(statearr_17065_17128[(1)] = (16));

} else {
var statearr_17066_17129 = state_17007__$1;
(statearr_17066_17129[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (9))){
var inst_16936 = (state_17007[(2)]);
var state_17007__$1 = state_17007;
var statearr_17067_17130 = state_17007__$1;
(statearr_17067_17130[(2)] = inst_16936);

(statearr_17067_17130[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (5))){
var inst_16882 = cljs.core.deref.call(null,cs);
var inst_16883 = cljs.core.seq.call(null,inst_16882);
var inst_16884 = inst_16883;
var inst_16885 = null;
var inst_16886 = (0);
var inst_16887 = (0);
var state_17007__$1 = (function (){var statearr_17068 = state_17007;
(statearr_17068[(13)] = inst_16886);

(statearr_17068[(14)] = inst_16884);

(statearr_17068[(16)] = inst_16887);

(statearr_17068[(17)] = inst_16885);

return statearr_17068;
})();
var statearr_17069_17131 = state_17007__$1;
(statearr_17069_17131[(2)] = null);

(statearr_17069_17131[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (14))){
var state_17007__$1 = state_17007;
var statearr_17070_17132 = state_17007__$1;
(statearr_17070_17132[(2)] = null);

(statearr_17070_17132[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (45))){
var inst_16997 = (state_17007[(2)]);
var state_17007__$1 = state_17007;
var statearr_17071_17133 = state_17007__$1;
(statearr_17071_17133[(2)] = inst_16997);

(statearr_17071_17133[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (26))){
var inst_16939 = (state_17007[(29)]);
var inst_16993 = (state_17007[(2)]);
var inst_16994 = cljs.core.seq.call(null,inst_16939);
var state_17007__$1 = (function (){var statearr_17072 = state_17007;
(statearr_17072[(31)] = inst_16993);

return statearr_17072;
})();
if(inst_16994){
var statearr_17073_17134 = state_17007__$1;
(statearr_17073_17134[(1)] = (42));

} else {
var statearr_17074_17135 = state_17007__$1;
(statearr_17074_17135[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (16))){
var inst_16906 = (state_17007[(7)]);
var inst_16908 = cljs.core.chunked_seq_QMARK_.call(null,inst_16906);
var state_17007__$1 = state_17007;
if(inst_16908){
var statearr_17075_17136 = state_17007__$1;
(statearr_17075_17136[(1)] = (19));

} else {
var statearr_17076_17137 = state_17007__$1;
(statearr_17076_17137[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (38))){
var inst_16986 = (state_17007[(2)]);
var state_17007__$1 = state_17007;
var statearr_17077_17138 = state_17007__$1;
(statearr_17077_17138[(2)] = inst_16986);

(statearr_17077_17138[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (30))){
var state_17007__$1 = state_17007;
var statearr_17078_17139 = state_17007__$1;
(statearr_17078_17139[(2)] = null);

(statearr_17078_17139[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (10))){
var inst_16887 = (state_17007[(16)]);
var inst_16885 = (state_17007[(17)]);
var inst_16895 = cljs.core._nth.call(null,inst_16885,inst_16887);
var inst_16896 = cljs.core.nth.call(null,inst_16895,(0),null);
var inst_16897 = cljs.core.nth.call(null,inst_16895,(1),null);
var state_17007__$1 = (function (){var statearr_17079 = state_17007;
(statearr_17079[(26)] = inst_16896);

return statearr_17079;
})();
if(cljs.core.truth_(inst_16897)){
var statearr_17080_17140 = state_17007__$1;
(statearr_17080_17140[(1)] = (13));

} else {
var statearr_17081_17141 = state_17007__$1;
(statearr_17081_17141[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (18))){
var inst_16932 = (state_17007[(2)]);
var state_17007__$1 = state_17007;
var statearr_17082_17142 = state_17007__$1;
(statearr_17082_17142[(2)] = inst_16932);

(statearr_17082_17142[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (42))){
var state_17007__$1 = state_17007;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17007__$1,(45),dchan);
} else {
if((state_val_17008 === (37))){
var inst_16966 = (state_17007[(25)]);
var inst_16875 = (state_17007[(12)]);
var inst_16975 = (state_17007[(23)]);
var inst_16975__$1 = cljs.core.first.call(null,inst_16966);
var inst_16976 = cljs.core.async.put_BANG_.call(null,inst_16975__$1,inst_16875,done);
var state_17007__$1 = (function (){var statearr_17083 = state_17007;
(statearr_17083[(23)] = inst_16975__$1);

return statearr_17083;
})();
if(cljs.core.truth_(inst_16976)){
var statearr_17084_17143 = state_17007__$1;
(statearr_17084_17143[(1)] = (39));

} else {
var statearr_17085_17144 = state_17007__$1;
(statearr_17085_17144[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17008 === (8))){
var inst_16886 = (state_17007[(13)]);
var inst_16887 = (state_17007[(16)]);
var inst_16889 = (inst_16887 < inst_16886);
var inst_16890 = inst_16889;
var state_17007__$1 = state_17007;
if(cljs.core.truth_(inst_16890)){
var statearr_17086_17145 = state_17007__$1;
(statearr_17086_17145[(1)] = (10));

} else {
var statearr_17087_17146 = state_17007__$1;
(statearr_17087_17146[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___17092,cs,m,dchan,dctr,done))
;
return ((function (switch__16183__auto__,c__16273__auto___17092,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__16184__auto__ = null;
var cljs$core$async$mult_$_state_machine__16184__auto____0 = (function (){
var statearr_17088 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17088[(0)] = cljs$core$async$mult_$_state_machine__16184__auto__);

(statearr_17088[(1)] = (1));

return statearr_17088;
});
var cljs$core$async$mult_$_state_machine__16184__auto____1 = (function (state_17007){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_17007);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e17089){if((e17089 instanceof Object)){
var ex__16187__auto__ = e17089;
var statearr_17090_17147 = state_17007;
(statearr_17090_17147[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17007);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17089;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17148 = state_17007;
state_17007 = G__17148;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__16184__auto__ = function(state_17007){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__16184__auto____1.call(this,state_17007);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__16184__auto____0;
cljs$core$async$mult_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__16184__auto____1;
return cljs$core$async$mult_$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___17092,cs,m,dchan,dctr,done))
})();
var state__16275__auto__ = (function (){var statearr_17091 = f__16274__auto__.call(null);
(statearr_17091[(6)] = c__16273__auto___17092);

return statearr_17091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___17092,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__17150 = arguments.length;
switch (G__17150) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__9121__auto__ = (((m == null))?null:m);
var m__9122__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m,ch);
} else {
var m__9122__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__9121__auto__ = (((m == null))?null:m);
var m__9122__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m,ch);
} else {
var m__9122__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__9121__auto__ = (((m == null))?null:m);
var m__9122__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m);
} else {
var m__9122__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__9121__auto__ = (((m == null))?null:m);
var m__9122__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m,state_map);
} else {
var m__9122__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__9121__auto__ = (((m == null))?null:m);
var m__9122__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m,mode);
} else {
var m__9122__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__9674__auto__ = [];
var len__9667__auto___17162 = arguments.length;
var i__9668__auto___17163 = (0);
while(true){
if((i__9668__auto___17163 < len__9667__auto___17162)){
args__9674__auto__.push((arguments[i__9668__auto___17163]));

var G__17164 = (i__9668__auto___17163 + (1));
i__9668__auto___17163 = G__17164;
continue;
} else {
}
break;
}

var argseq__9675__auto__ = ((((3) < args__9674__auto__.length))?(new cljs.core.IndexedSeq(args__9674__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9675__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__17156){
var map__17157 = p__17156;
var map__17157__$1 = ((((!((map__17157 == null)))?((((map__17157.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17157.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17157):map__17157);
var opts = map__17157__$1;
var statearr_17159_17165 = state;
(statearr_17159_17165[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts.call(null,((function (map__17157,map__17157__$1,opts){
return (function (val){
var statearr_17160_17166 = state;
(statearr_17160_17166[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__17157,map__17157__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_17161_17167 = state;
(statearr_17161_17167[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq17152){
var G__17153 = cljs.core.first.call(null,seq17152);
var seq17152__$1 = cljs.core.next.call(null,seq17152);
var G__17154 = cljs.core.first.call(null,seq17152__$1);
var seq17152__$2 = cljs.core.next.call(null,seq17152__$1);
var G__17155 = cljs.core.first.call(null,seq17152__$2);
var seq17152__$3 = cljs.core.next.call(null,seq17152__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17153,G__17154,G__17155,seq17152__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async17168 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17168 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta17169){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta17169 = meta17169;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17168.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_17170,meta17169__$1){
var self__ = this;
var _17170__$1 = this;
return (new cljs.core.async.t_cljs$core$async17168(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta17169__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17168.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_17170){
var self__ = this;
var _17170__$1 = this;
return self__.meta17169;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17168.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17168.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17168.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17168.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17168.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17168.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17168.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17168.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17168.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta17169","meta17169",1236181921,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17168.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17168.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17168";

cljs.core.async.t_cljs$core$async17168.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async17168");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async17168 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async17168(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta17169){
return (new cljs.core.async.t_cljs$core$async17168(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta17169));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async17168(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16273__auto___17332 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___17332,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___17332,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_17272){
var state_val_17273 = (state_17272[(1)]);
if((state_val_17273 === (7))){
var inst_17187 = (state_17272[(2)]);
var state_17272__$1 = state_17272;
var statearr_17274_17333 = state_17272__$1;
(statearr_17274_17333[(2)] = inst_17187);

(statearr_17274_17333[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (20))){
var inst_17199 = (state_17272[(7)]);
var state_17272__$1 = state_17272;
var statearr_17275_17334 = state_17272__$1;
(statearr_17275_17334[(2)] = inst_17199);

(statearr_17275_17334[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (27))){
var state_17272__$1 = state_17272;
var statearr_17276_17335 = state_17272__$1;
(statearr_17276_17335[(2)] = null);

(statearr_17276_17335[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (1))){
var inst_17174 = (state_17272[(8)]);
var inst_17174__$1 = calc_state.call(null);
var inst_17176 = (inst_17174__$1 == null);
var inst_17177 = cljs.core.not.call(null,inst_17176);
var state_17272__$1 = (function (){var statearr_17277 = state_17272;
(statearr_17277[(8)] = inst_17174__$1);

return statearr_17277;
})();
if(inst_17177){
var statearr_17278_17336 = state_17272__$1;
(statearr_17278_17336[(1)] = (2));

} else {
var statearr_17279_17337 = state_17272__$1;
(statearr_17279_17337[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (24))){
var inst_17223 = (state_17272[(9)]);
var inst_17246 = (state_17272[(10)]);
var inst_17232 = (state_17272[(11)]);
var inst_17246__$1 = inst_17223.call(null,inst_17232);
var state_17272__$1 = (function (){var statearr_17280 = state_17272;
(statearr_17280[(10)] = inst_17246__$1);

return statearr_17280;
})();
if(cljs.core.truth_(inst_17246__$1)){
var statearr_17281_17338 = state_17272__$1;
(statearr_17281_17338[(1)] = (29));

} else {
var statearr_17282_17339 = state_17272__$1;
(statearr_17282_17339[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (4))){
var inst_17190 = (state_17272[(2)]);
var state_17272__$1 = state_17272;
if(cljs.core.truth_(inst_17190)){
var statearr_17283_17340 = state_17272__$1;
(statearr_17283_17340[(1)] = (8));

} else {
var statearr_17284_17341 = state_17272__$1;
(statearr_17284_17341[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (15))){
var inst_17217 = (state_17272[(2)]);
var state_17272__$1 = state_17272;
if(cljs.core.truth_(inst_17217)){
var statearr_17285_17342 = state_17272__$1;
(statearr_17285_17342[(1)] = (19));

} else {
var statearr_17286_17343 = state_17272__$1;
(statearr_17286_17343[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (21))){
var inst_17222 = (state_17272[(12)]);
var inst_17222__$1 = (state_17272[(2)]);
var inst_17223 = cljs.core.get.call(null,inst_17222__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_17224 = cljs.core.get.call(null,inst_17222__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_17225 = cljs.core.get.call(null,inst_17222__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_17272__$1 = (function (){var statearr_17287 = state_17272;
(statearr_17287[(13)] = inst_17224);

(statearr_17287[(9)] = inst_17223);

(statearr_17287[(12)] = inst_17222__$1);

return statearr_17287;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_17272__$1,(22),inst_17225);
} else {
if((state_val_17273 === (31))){
var inst_17254 = (state_17272[(2)]);
var state_17272__$1 = state_17272;
if(cljs.core.truth_(inst_17254)){
var statearr_17288_17344 = state_17272__$1;
(statearr_17288_17344[(1)] = (32));

} else {
var statearr_17289_17345 = state_17272__$1;
(statearr_17289_17345[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (32))){
var inst_17231 = (state_17272[(14)]);
var state_17272__$1 = state_17272;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17272__$1,(35),out,inst_17231);
} else {
if((state_val_17273 === (33))){
var inst_17222 = (state_17272[(12)]);
var inst_17199 = inst_17222;
var state_17272__$1 = (function (){var statearr_17290 = state_17272;
(statearr_17290[(7)] = inst_17199);

return statearr_17290;
})();
var statearr_17291_17346 = state_17272__$1;
(statearr_17291_17346[(2)] = null);

(statearr_17291_17346[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (13))){
var inst_17199 = (state_17272[(7)]);
var inst_17206 = inst_17199.cljs$lang$protocol_mask$partition0$;
var inst_17207 = (inst_17206 & (64));
var inst_17208 = inst_17199.cljs$core$ISeq$;
var inst_17209 = (cljs.core.PROTOCOL_SENTINEL === inst_17208);
var inst_17210 = (inst_17207) || (inst_17209);
var state_17272__$1 = state_17272;
if(cljs.core.truth_(inst_17210)){
var statearr_17292_17347 = state_17272__$1;
(statearr_17292_17347[(1)] = (16));

} else {
var statearr_17293_17348 = state_17272__$1;
(statearr_17293_17348[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (22))){
var inst_17231 = (state_17272[(14)]);
var inst_17232 = (state_17272[(11)]);
var inst_17230 = (state_17272[(2)]);
var inst_17231__$1 = cljs.core.nth.call(null,inst_17230,(0),null);
var inst_17232__$1 = cljs.core.nth.call(null,inst_17230,(1),null);
var inst_17233 = (inst_17231__$1 == null);
var inst_17234 = cljs.core._EQ_.call(null,inst_17232__$1,change);
var inst_17235 = (inst_17233) || (inst_17234);
var state_17272__$1 = (function (){var statearr_17294 = state_17272;
(statearr_17294[(14)] = inst_17231__$1);

(statearr_17294[(11)] = inst_17232__$1);

return statearr_17294;
})();
if(cljs.core.truth_(inst_17235)){
var statearr_17295_17349 = state_17272__$1;
(statearr_17295_17349[(1)] = (23));

} else {
var statearr_17296_17350 = state_17272__$1;
(statearr_17296_17350[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (36))){
var inst_17222 = (state_17272[(12)]);
var inst_17199 = inst_17222;
var state_17272__$1 = (function (){var statearr_17297 = state_17272;
(statearr_17297[(7)] = inst_17199);

return statearr_17297;
})();
var statearr_17298_17351 = state_17272__$1;
(statearr_17298_17351[(2)] = null);

(statearr_17298_17351[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (29))){
var inst_17246 = (state_17272[(10)]);
var state_17272__$1 = state_17272;
var statearr_17299_17352 = state_17272__$1;
(statearr_17299_17352[(2)] = inst_17246);

(statearr_17299_17352[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (6))){
var state_17272__$1 = state_17272;
var statearr_17300_17353 = state_17272__$1;
(statearr_17300_17353[(2)] = false);

(statearr_17300_17353[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (28))){
var inst_17242 = (state_17272[(2)]);
var inst_17243 = calc_state.call(null);
var inst_17199 = inst_17243;
var state_17272__$1 = (function (){var statearr_17301 = state_17272;
(statearr_17301[(7)] = inst_17199);

(statearr_17301[(15)] = inst_17242);

return statearr_17301;
})();
var statearr_17302_17354 = state_17272__$1;
(statearr_17302_17354[(2)] = null);

(statearr_17302_17354[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (25))){
var inst_17268 = (state_17272[(2)]);
var state_17272__$1 = state_17272;
var statearr_17303_17355 = state_17272__$1;
(statearr_17303_17355[(2)] = inst_17268);

(statearr_17303_17355[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (34))){
var inst_17266 = (state_17272[(2)]);
var state_17272__$1 = state_17272;
var statearr_17304_17356 = state_17272__$1;
(statearr_17304_17356[(2)] = inst_17266);

(statearr_17304_17356[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (17))){
var state_17272__$1 = state_17272;
var statearr_17305_17357 = state_17272__$1;
(statearr_17305_17357[(2)] = false);

(statearr_17305_17357[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (3))){
var state_17272__$1 = state_17272;
var statearr_17306_17358 = state_17272__$1;
(statearr_17306_17358[(2)] = false);

(statearr_17306_17358[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (12))){
var inst_17270 = (state_17272[(2)]);
var state_17272__$1 = state_17272;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17272__$1,inst_17270);
} else {
if((state_val_17273 === (2))){
var inst_17174 = (state_17272[(8)]);
var inst_17179 = inst_17174.cljs$lang$protocol_mask$partition0$;
var inst_17180 = (inst_17179 & (64));
var inst_17181 = inst_17174.cljs$core$ISeq$;
var inst_17182 = (cljs.core.PROTOCOL_SENTINEL === inst_17181);
var inst_17183 = (inst_17180) || (inst_17182);
var state_17272__$1 = state_17272;
if(cljs.core.truth_(inst_17183)){
var statearr_17307_17359 = state_17272__$1;
(statearr_17307_17359[(1)] = (5));

} else {
var statearr_17308_17360 = state_17272__$1;
(statearr_17308_17360[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (23))){
var inst_17231 = (state_17272[(14)]);
var inst_17237 = (inst_17231 == null);
var state_17272__$1 = state_17272;
if(cljs.core.truth_(inst_17237)){
var statearr_17309_17361 = state_17272__$1;
(statearr_17309_17361[(1)] = (26));

} else {
var statearr_17310_17362 = state_17272__$1;
(statearr_17310_17362[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (35))){
var inst_17257 = (state_17272[(2)]);
var state_17272__$1 = state_17272;
if(cljs.core.truth_(inst_17257)){
var statearr_17311_17363 = state_17272__$1;
(statearr_17311_17363[(1)] = (36));

} else {
var statearr_17312_17364 = state_17272__$1;
(statearr_17312_17364[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (19))){
var inst_17199 = (state_17272[(7)]);
var inst_17219 = cljs.core.apply.call(null,cljs.core.hash_map,inst_17199);
var state_17272__$1 = state_17272;
var statearr_17313_17365 = state_17272__$1;
(statearr_17313_17365[(2)] = inst_17219);

(statearr_17313_17365[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (11))){
var inst_17199 = (state_17272[(7)]);
var inst_17203 = (inst_17199 == null);
var inst_17204 = cljs.core.not.call(null,inst_17203);
var state_17272__$1 = state_17272;
if(inst_17204){
var statearr_17314_17366 = state_17272__$1;
(statearr_17314_17366[(1)] = (13));

} else {
var statearr_17315_17367 = state_17272__$1;
(statearr_17315_17367[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (9))){
var inst_17174 = (state_17272[(8)]);
var state_17272__$1 = state_17272;
var statearr_17316_17368 = state_17272__$1;
(statearr_17316_17368[(2)] = inst_17174);

(statearr_17316_17368[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (5))){
var state_17272__$1 = state_17272;
var statearr_17317_17369 = state_17272__$1;
(statearr_17317_17369[(2)] = true);

(statearr_17317_17369[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (14))){
var state_17272__$1 = state_17272;
var statearr_17318_17370 = state_17272__$1;
(statearr_17318_17370[(2)] = false);

(statearr_17318_17370[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (26))){
var inst_17232 = (state_17272[(11)]);
var inst_17239 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_17232);
var state_17272__$1 = state_17272;
var statearr_17319_17371 = state_17272__$1;
(statearr_17319_17371[(2)] = inst_17239);

(statearr_17319_17371[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (16))){
var state_17272__$1 = state_17272;
var statearr_17320_17372 = state_17272__$1;
(statearr_17320_17372[(2)] = true);

(statearr_17320_17372[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (38))){
var inst_17262 = (state_17272[(2)]);
var state_17272__$1 = state_17272;
var statearr_17321_17373 = state_17272__$1;
(statearr_17321_17373[(2)] = inst_17262);

(statearr_17321_17373[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (30))){
var inst_17224 = (state_17272[(13)]);
var inst_17223 = (state_17272[(9)]);
var inst_17232 = (state_17272[(11)]);
var inst_17249 = cljs.core.empty_QMARK_.call(null,inst_17223);
var inst_17250 = inst_17224.call(null,inst_17232);
var inst_17251 = cljs.core.not.call(null,inst_17250);
var inst_17252 = (inst_17249) && (inst_17251);
var state_17272__$1 = state_17272;
var statearr_17322_17374 = state_17272__$1;
(statearr_17322_17374[(2)] = inst_17252);

(statearr_17322_17374[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (10))){
var inst_17174 = (state_17272[(8)]);
var inst_17195 = (state_17272[(2)]);
var inst_17196 = cljs.core.get.call(null,inst_17195,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_17197 = cljs.core.get.call(null,inst_17195,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_17198 = cljs.core.get.call(null,inst_17195,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_17199 = inst_17174;
var state_17272__$1 = (function (){var statearr_17323 = state_17272;
(statearr_17323[(16)] = inst_17197);

(statearr_17323[(17)] = inst_17196);

(statearr_17323[(18)] = inst_17198);

(statearr_17323[(7)] = inst_17199);

return statearr_17323;
})();
var statearr_17324_17375 = state_17272__$1;
(statearr_17324_17375[(2)] = null);

(statearr_17324_17375[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (18))){
var inst_17214 = (state_17272[(2)]);
var state_17272__$1 = state_17272;
var statearr_17325_17376 = state_17272__$1;
(statearr_17325_17376[(2)] = inst_17214);

(statearr_17325_17376[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (37))){
var state_17272__$1 = state_17272;
var statearr_17326_17377 = state_17272__$1;
(statearr_17326_17377[(2)] = null);

(statearr_17326_17377[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (8))){
var inst_17174 = (state_17272[(8)]);
var inst_17192 = cljs.core.apply.call(null,cljs.core.hash_map,inst_17174);
var state_17272__$1 = state_17272;
var statearr_17327_17378 = state_17272__$1;
(statearr_17327_17378[(2)] = inst_17192);

(statearr_17327_17378[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___17332,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__16183__auto__,c__16273__auto___17332,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__16184__auto__ = null;
var cljs$core$async$mix_$_state_machine__16184__auto____0 = (function (){
var statearr_17328 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17328[(0)] = cljs$core$async$mix_$_state_machine__16184__auto__);

(statearr_17328[(1)] = (1));

return statearr_17328;
});
var cljs$core$async$mix_$_state_machine__16184__auto____1 = (function (state_17272){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_17272);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e17329){if((e17329 instanceof Object)){
var ex__16187__auto__ = e17329;
var statearr_17330_17379 = state_17272;
(statearr_17330_17379[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17272);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17329;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17380 = state_17272;
state_17272 = G__17380;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__16184__auto__ = function(state_17272){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__16184__auto____1.call(this,state_17272);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__16184__auto____0;
cljs$core$async$mix_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__16184__auto____1;
return cljs$core$async$mix_$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___17332,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__16275__auto__ = (function (){var statearr_17331 = f__16274__auto__.call(null);
(statearr_17331[(6)] = c__16273__auto___17332);

return statearr_17331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___17332,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__9122__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,p,v,ch);
} else {
var m__9122__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__17382 = arguments.length;
switch (G__17382) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,p);
} else {
var m__9122__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,p,v);
} else {
var m__9122__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__17386 = arguments.length;
switch (G__17386) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__8388__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__8388__auto__,mults){
return (function (p1__17384_SHARP_){
if(cljs.core.truth_(p1__17384_SHARP_.call(null,topic))){
return p1__17384_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__17384_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__8388__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async17387 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17387 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta17388){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta17388 = meta17388;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17387.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_17389,meta17388__$1){
var self__ = this;
var _17389__$1 = this;
return (new cljs.core.async.t_cljs$core$async17387(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta17388__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async17387.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_17389){
var self__ = this;
var _17389__$1 = this;
return self__.meta17388;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async17387.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17387.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async17387.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17387.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async17387.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async17387.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async17387.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async17387.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta17388","meta17388",267086723,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async17387.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17387.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17387";

cljs.core.async.t_cljs$core$async17387.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async17387");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async17387 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async17387(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta17388){
return (new cljs.core.async.t_cljs$core$async17387(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta17388));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async17387(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16273__auto___17507 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___17507,mults,ensure_mult,p){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___17507,mults,ensure_mult,p){
return (function (state_17461){
var state_val_17462 = (state_17461[(1)]);
if((state_val_17462 === (7))){
var inst_17457 = (state_17461[(2)]);
var state_17461__$1 = state_17461;
var statearr_17463_17508 = state_17461__$1;
(statearr_17463_17508[(2)] = inst_17457);

(statearr_17463_17508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (20))){
var state_17461__$1 = state_17461;
var statearr_17464_17509 = state_17461__$1;
(statearr_17464_17509[(2)] = null);

(statearr_17464_17509[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (1))){
var state_17461__$1 = state_17461;
var statearr_17465_17510 = state_17461__$1;
(statearr_17465_17510[(2)] = null);

(statearr_17465_17510[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (24))){
var inst_17440 = (state_17461[(7)]);
var inst_17449 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_17440);
var state_17461__$1 = state_17461;
var statearr_17466_17511 = state_17461__$1;
(statearr_17466_17511[(2)] = inst_17449);

(statearr_17466_17511[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (4))){
var inst_17392 = (state_17461[(8)]);
var inst_17392__$1 = (state_17461[(2)]);
var inst_17393 = (inst_17392__$1 == null);
var state_17461__$1 = (function (){var statearr_17467 = state_17461;
(statearr_17467[(8)] = inst_17392__$1);

return statearr_17467;
})();
if(cljs.core.truth_(inst_17393)){
var statearr_17468_17512 = state_17461__$1;
(statearr_17468_17512[(1)] = (5));

} else {
var statearr_17469_17513 = state_17461__$1;
(statearr_17469_17513[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (15))){
var inst_17434 = (state_17461[(2)]);
var state_17461__$1 = state_17461;
var statearr_17470_17514 = state_17461__$1;
(statearr_17470_17514[(2)] = inst_17434);

(statearr_17470_17514[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (21))){
var inst_17454 = (state_17461[(2)]);
var state_17461__$1 = (function (){var statearr_17471 = state_17461;
(statearr_17471[(9)] = inst_17454);

return statearr_17471;
})();
var statearr_17472_17515 = state_17461__$1;
(statearr_17472_17515[(2)] = null);

(statearr_17472_17515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (13))){
var inst_17416 = (state_17461[(10)]);
var inst_17418 = cljs.core.chunked_seq_QMARK_.call(null,inst_17416);
var state_17461__$1 = state_17461;
if(inst_17418){
var statearr_17473_17516 = state_17461__$1;
(statearr_17473_17516[(1)] = (16));

} else {
var statearr_17474_17517 = state_17461__$1;
(statearr_17474_17517[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (22))){
var inst_17446 = (state_17461[(2)]);
var state_17461__$1 = state_17461;
if(cljs.core.truth_(inst_17446)){
var statearr_17475_17518 = state_17461__$1;
(statearr_17475_17518[(1)] = (23));

} else {
var statearr_17476_17519 = state_17461__$1;
(statearr_17476_17519[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (6))){
var inst_17440 = (state_17461[(7)]);
var inst_17392 = (state_17461[(8)]);
var inst_17442 = (state_17461[(11)]);
var inst_17440__$1 = topic_fn.call(null,inst_17392);
var inst_17441 = cljs.core.deref.call(null,mults);
var inst_17442__$1 = cljs.core.get.call(null,inst_17441,inst_17440__$1);
var state_17461__$1 = (function (){var statearr_17477 = state_17461;
(statearr_17477[(7)] = inst_17440__$1);

(statearr_17477[(11)] = inst_17442__$1);

return statearr_17477;
})();
if(cljs.core.truth_(inst_17442__$1)){
var statearr_17478_17520 = state_17461__$1;
(statearr_17478_17520[(1)] = (19));

} else {
var statearr_17479_17521 = state_17461__$1;
(statearr_17479_17521[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (25))){
var inst_17451 = (state_17461[(2)]);
var state_17461__$1 = state_17461;
var statearr_17480_17522 = state_17461__$1;
(statearr_17480_17522[(2)] = inst_17451);

(statearr_17480_17522[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (17))){
var inst_17416 = (state_17461[(10)]);
var inst_17425 = cljs.core.first.call(null,inst_17416);
var inst_17426 = cljs.core.async.muxch_STAR_.call(null,inst_17425);
var inst_17427 = cljs.core.async.close_BANG_.call(null,inst_17426);
var inst_17428 = cljs.core.next.call(null,inst_17416);
var inst_17402 = inst_17428;
var inst_17403 = null;
var inst_17404 = (0);
var inst_17405 = (0);
var state_17461__$1 = (function (){var statearr_17481 = state_17461;
(statearr_17481[(12)] = inst_17404);

(statearr_17481[(13)] = inst_17402);

(statearr_17481[(14)] = inst_17427);

(statearr_17481[(15)] = inst_17403);

(statearr_17481[(16)] = inst_17405);

return statearr_17481;
})();
var statearr_17482_17523 = state_17461__$1;
(statearr_17482_17523[(2)] = null);

(statearr_17482_17523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (3))){
var inst_17459 = (state_17461[(2)]);
var state_17461__$1 = state_17461;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17461__$1,inst_17459);
} else {
if((state_val_17462 === (12))){
var inst_17436 = (state_17461[(2)]);
var state_17461__$1 = state_17461;
var statearr_17483_17524 = state_17461__$1;
(statearr_17483_17524[(2)] = inst_17436);

(statearr_17483_17524[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (2))){
var state_17461__$1 = state_17461;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17461__$1,(4),ch);
} else {
if((state_val_17462 === (23))){
var state_17461__$1 = state_17461;
var statearr_17484_17525 = state_17461__$1;
(statearr_17484_17525[(2)] = null);

(statearr_17484_17525[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (19))){
var inst_17392 = (state_17461[(8)]);
var inst_17442 = (state_17461[(11)]);
var inst_17444 = cljs.core.async.muxch_STAR_.call(null,inst_17442);
var state_17461__$1 = state_17461;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17461__$1,(22),inst_17444,inst_17392);
} else {
if((state_val_17462 === (11))){
var inst_17402 = (state_17461[(13)]);
var inst_17416 = (state_17461[(10)]);
var inst_17416__$1 = cljs.core.seq.call(null,inst_17402);
var state_17461__$1 = (function (){var statearr_17485 = state_17461;
(statearr_17485[(10)] = inst_17416__$1);

return statearr_17485;
})();
if(inst_17416__$1){
var statearr_17486_17526 = state_17461__$1;
(statearr_17486_17526[(1)] = (13));

} else {
var statearr_17487_17527 = state_17461__$1;
(statearr_17487_17527[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (9))){
var inst_17438 = (state_17461[(2)]);
var state_17461__$1 = state_17461;
var statearr_17488_17528 = state_17461__$1;
(statearr_17488_17528[(2)] = inst_17438);

(statearr_17488_17528[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (5))){
var inst_17399 = cljs.core.deref.call(null,mults);
var inst_17400 = cljs.core.vals.call(null,inst_17399);
var inst_17401 = cljs.core.seq.call(null,inst_17400);
var inst_17402 = inst_17401;
var inst_17403 = null;
var inst_17404 = (0);
var inst_17405 = (0);
var state_17461__$1 = (function (){var statearr_17489 = state_17461;
(statearr_17489[(12)] = inst_17404);

(statearr_17489[(13)] = inst_17402);

(statearr_17489[(15)] = inst_17403);

(statearr_17489[(16)] = inst_17405);

return statearr_17489;
})();
var statearr_17490_17529 = state_17461__$1;
(statearr_17490_17529[(2)] = null);

(statearr_17490_17529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (14))){
var state_17461__$1 = state_17461;
var statearr_17494_17530 = state_17461__$1;
(statearr_17494_17530[(2)] = null);

(statearr_17494_17530[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (16))){
var inst_17416 = (state_17461[(10)]);
var inst_17420 = cljs.core.chunk_first.call(null,inst_17416);
var inst_17421 = cljs.core.chunk_rest.call(null,inst_17416);
var inst_17422 = cljs.core.count.call(null,inst_17420);
var inst_17402 = inst_17421;
var inst_17403 = inst_17420;
var inst_17404 = inst_17422;
var inst_17405 = (0);
var state_17461__$1 = (function (){var statearr_17495 = state_17461;
(statearr_17495[(12)] = inst_17404);

(statearr_17495[(13)] = inst_17402);

(statearr_17495[(15)] = inst_17403);

(statearr_17495[(16)] = inst_17405);

return statearr_17495;
})();
var statearr_17496_17531 = state_17461__$1;
(statearr_17496_17531[(2)] = null);

(statearr_17496_17531[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (10))){
var inst_17404 = (state_17461[(12)]);
var inst_17402 = (state_17461[(13)]);
var inst_17403 = (state_17461[(15)]);
var inst_17405 = (state_17461[(16)]);
var inst_17410 = cljs.core._nth.call(null,inst_17403,inst_17405);
var inst_17411 = cljs.core.async.muxch_STAR_.call(null,inst_17410);
var inst_17412 = cljs.core.async.close_BANG_.call(null,inst_17411);
var inst_17413 = (inst_17405 + (1));
var tmp17491 = inst_17404;
var tmp17492 = inst_17402;
var tmp17493 = inst_17403;
var inst_17402__$1 = tmp17492;
var inst_17403__$1 = tmp17493;
var inst_17404__$1 = tmp17491;
var inst_17405__$1 = inst_17413;
var state_17461__$1 = (function (){var statearr_17497 = state_17461;
(statearr_17497[(12)] = inst_17404__$1);

(statearr_17497[(13)] = inst_17402__$1);

(statearr_17497[(17)] = inst_17412);

(statearr_17497[(15)] = inst_17403__$1);

(statearr_17497[(16)] = inst_17405__$1);

return statearr_17497;
})();
var statearr_17498_17532 = state_17461__$1;
(statearr_17498_17532[(2)] = null);

(statearr_17498_17532[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (18))){
var inst_17431 = (state_17461[(2)]);
var state_17461__$1 = state_17461;
var statearr_17499_17533 = state_17461__$1;
(statearr_17499_17533[(2)] = inst_17431);

(statearr_17499_17533[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (8))){
var inst_17404 = (state_17461[(12)]);
var inst_17405 = (state_17461[(16)]);
var inst_17407 = (inst_17405 < inst_17404);
var inst_17408 = inst_17407;
var state_17461__$1 = state_17461;
if(cljs.core.truth_(inst_17408)){
var statearr_17500_17534 = state_17461__$1;
(statearr_17500_17534[(1)] = (10));

} else {
var statearr_17501_17535 = state_17461__$1;
(statearr_17501_17535[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___17507,mults,ensure_mult,p))
;
return ((function (switch__16183__auto__,c__16273__auto___17507,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_17502 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17502[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_17502[(1)] = (1));

return statearr_17502;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_17461){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_17461);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e17503){if((e17503 instanceof Object)){
var ex__16187__auto__ = e17503;
var statearr_17504_17536 = state_17461;
(statearr_17504_17536[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17461);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17503;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17537 = state_17461;
state_17461 = G__17537;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_17461){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_17461);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___17507,mults,ensure_mult,p))
})();
var state__16275__auto__ = (function (){var statearr_17505 = f__16274__auto__.call(null);
(statearr_17505[(6)] = c__16273__auto___17507);

return statearr_17505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___17507,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__17539 = arguments.length;
switch (G__17539) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__17542 = arguments.length;
switch (G__17542) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__17545 = arguments.length;
switch (G__17545) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__16273__auto___17612 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___17612,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___17612,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_17584){
var state_val_17585 = (state_17584[(1)]);
if((state_val_17585 === (7))){
var state_17584__$1 = state_17584;
var statearr_17586_17613 = state_17584__$1;
(statearr_17586_17613[(2)] = null);

(statearr_17586_17613[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17585 === (1))){
var state_17584__$1 = state_17584;
var statearr_17587_17614 = state_17584__$1;
(statearr_17587_17614[(2)] = null);

(statearr_17587_17614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17585 === (4))){
var inst_17548 = (state_17584[(7)]);
var inst_17550 = (inst_17548 < cnt);
var state_17584__$1 = state_17584;
if(cljs.core.truth_(inst_17550)){
var statearr_17588_17615 = state_17584__$1;
(statearr_17588_17615[(1)] = (6));

} else {
var statearr_17589_17616 = state_17584__$1;
(statearr_17589_17616[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17585 === (15))){
var inst_17580 = (state_17584[(2)]);
var state_17584__$1 = state_17584;
var statearr_17590_17617 = state_17584__$1;
(statearr_17590_17617[(2)] = inst_17580);

(statearr_17590_17617[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17585 === (13))){
var inst_17573 = cljs.core.async.close_BANG_.call(null,out);
var state_17584__$1 = state_17584;
var statearr_17591_17618 = state_17584__$1;
(statearr_17591_17618[(2)] = inst_17573);

(statearr_17591_17618[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17585 === (6))){
var state_17584__$1 = state_17584;
var statearr_17592_17619 = state_17584__$1;
(statearr_17592_17619[(2)] = null);

(statearr_17592_17619[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17585 === (3))){
var inst_17582 = (state_17584[(2)]);
var state_17584__$1 = state_17584;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17584__$1,inst_17582);
} else {
if((state_val_17585 === (12))){
var inst_17570 = (state_17584[(8)]);
var inst_17570__$1 = (state_17584[(2)]);
var inst_17571 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_17570__$1);
var state_17584__$1 = (function (){var statearr_17593 = state_17584;
(statearr_17593[(8)] = inst_17570__$1);

return statearr_17593;
})();
if(cljs.core.truth_(inst_17571)){
var statearr_17594_17620 = state_17584__$1;
(statearr_17594_17620[(1)] = (13));

} else {
var statearr_17595_17621 = state_17584__$1;
(statearr_17595_17621[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17585 === (2))){
var inst_17547 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_17548 = (0);
var state_17584__$1 = (function (){var statearr_17596 = state_17584;
(statearr_17596[(7)] = inst_17548);

(statearr_17596[(9)] = inst_17547);

return statearr_17596;
})();
var statearr_17597_17622 = state_17584__$1;
(statearr_17597_17622[(2)] = null);

(statearr_17597_17622[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17585 === (11))){
var inst_17548 = (state_17584[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_17584,(10),Object,null,(9));
var inst_17557 = chs__$1.call(null,inst_17548);
var inst_17558 = done.call(null,inst_17548);
var inst_17559 = cljs.core.async.take_BANG_.call(null,inst_17557,inst_17558);
var state_17584__$1 = state_17584;
var statearr_17598_17623 = state_17584__$1;
(statearr_17598_17623[(2)] = inst_17559);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17584__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17585 === (9))){
var inst_17548 = (state_17584[(7)]);
var inst_17561 = (state_17584[(2)]);
var inst_17562 = (inst_17548 + (1));
var inst_17548__$1 = inst_17562;
var state_17584__$1 = (function (){var statearr_17599 = state_17584;
(statearr_17599[(7)] = inst_17548__$1);

(statearr_17599[(10)] = inst_17561);

return statearr_17599;
})();
var statearr_17600_17624 = state_17584__$1;
(statearr_17600_17624[(2)] = null);

(statearr_17600_17624[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17585 === (5))){
var inst_17568 = (state_17584[(2)]);
var state_17584__$1 = (function (){var statearr_17601 = state_17584;
(statearr_17601[(11)] = inst_17568);

return statearr_17601;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17584__$1,(12),dchan);
} else {
if((state_val_17585 === (14))){
var inst_17570 = (state_17584[(8)]);
var inst_17575 = cljs.core.apply.call(null,f,inst_17570);
var state_17584__$1 = state_17584;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17584__$1,(16),out,inst_17575);
} else {
if((state_val_17585 === (16))){
var inst_17577 = (state_17584[(2)]);
var state_17584__$1 = (function (){var statearr_17602 = state_17584;
(statearr_17602[(12)] = inst_17577);

return statearr_17602;
})();
var statearr_17603_17625 = state_17584__$1;
(statearr_17603_17625[(2)] = null);

(statearr_17603_17625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17585 === (10))){
var inst_17552 = (state_17584[(2)]);
var inst_17553 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_17584__$1 = (function (){var statearr_17604 = state_17584;
(statearr_17604[(13)] = inst_17552);

return statearr_17604;
})();
var statearr_17605_17626 = state_17584__$1;
(statearr_17605_17626[(2)] = inst_17553);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17584__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17585 === (8))){
var inst_17566 = (state_17584[(2)]);
var state_17584__$1 = state_17584;
var statearr_17606_17627 = state_17584__$1;
(statearr_17606_17627[(2)] = inst_17566);

(statearr_17606_17627[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___17612,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__16183__auto__,c__16273__auto___17612,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_17607 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17607[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_17607[(1)] = (1));

return statearr_17607;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_17584){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_17584);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e17608){if((e17608 instanceof Object)){
var ex__16187__auto__ = e17608;
var statearr_17609_17628 = state_17584;
(statearr_17609_17628[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17584);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17608;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17629 = state_17584;
state_17584 = G__17629;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_17584){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_17584);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___17612,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__16275__auto__ = (function (){var statearr_17610 = f__16274__auto__.call(null);
(statearr_17610[(6)] = c__16273__auto___17612);

return statearr_17610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___17612,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__17632 = arguments.length;
switch (G__17632) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16273__auto___17686 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___17686,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___17686,out){
return (function (state_17664){
var state_val_17665 = (state_17664[(1)]);
if((state_val_17665 === (7))){
var inst_17643 = (state_17664[(7)]);
var inst_17644 = (state_17664[(8)]);
var inst_17643__$1 = (state_17664[(2)]);
var inst_17644__$1 = cljs.core.nth.call(null,inst_17643__$1,(0),null);
var inst_17645 = cljs.core.nth.call(null,inst_17643__$1,(1),null);
var inst_17646 = (inst_17644__$1 == null);
var state_17664__$1 = (function (){var statearr_17666 = state_17664;
(statearr_17666[(7)] = inst_17643__$1);

(statearr_17666[(9)] = inst_17645);

(statearr_17666[(8)] = inst_17644__$1);

return statearr_17666;
})();
if(cljs.core.truth_(inst_17646)){
var statearr_17667_17687 = state_17664__$1;
(statearr_17667_17687[(1)] = (8));

} else {
var statearr_17668_17688 = state_17664__$1;
(statearr_17668_17688[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17665 === (1))){
var inst_17633 = cljs.core.vec.call(null,chs);
var inst_17634 = inst_17633;
var state_17664__$1 = (function (){var statearr_17669 = state_17664;
(statearr_17669[(10)] = inst_17634);

return statearr_17669;
})();
var statearr_17670_17689 = state_17664__$1;
(statearr_17670_17689[(2)] = null);

(statearr_17670_17689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17665 === (4))){
var inst_17634 = (state_17664[(10)]);
var state_17664__$1 = state_17664;
return cljs.core.async.ioc_alts_BANG_.call(null,state_17664__$1,(7),inst_17634);
} else {
if((state_val_17665 === (6))){
var inst_17660 = (state_17664[(2)]);
var state_17664__$1 = state_17664;
var statearr_17671_17690 = state_17664__$1;
(statearr_17671_17690[(2)] = inst_17660);

(statearr_17671_17690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17665 === (3))){
var inst_17662 = (state_17664[(2)]);
var state_17664__$1 = state_17664;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17664__$1,inst_17662);
} else {
if((state_val_17665 === (2))){
var inst_17634 = (state_17664[(10)]);
var inst_17636 = cljs.core.count.call(null,inst_17634);
var inst_17637 = (inst_17636 > (0));
var state_17664__$1 = state_17664;
if(cljs.core.truth_(inst_17637)){
var statearr_17673_17691 = state_17664__$1;
(statearr_17673_17691[(1)] = (4));

} else {
var statearr_17674_17692 = state_17664__$1;
(statearr_17674_17692[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17665 === (11))){
var inst_17634 = (state_17664[(10)]);
var inst_17653 = (state_17664[(2)]);
var tmp17672 = inst_17634;
var inst_17634__$1 = tmp17672;
var state_17664__$1 = (function (){var statearr_17675 = state_17664;
(statearr_17675[(11)] = inst_17653);

(statearr_17675[(10)] = inst_17634__$1);

return statearr_17675;
})();
var statearr_17676_17693 = state_17664__$1;
(statearr_17676_17693[(2)] = null);

(statearr_17676_17693[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17665 === (9))){
var inst_17644 = (state_17664[(8)]);
var state_17664__$1 = state_17664;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17664__$1,(11),out,inst_17644);
} else {
if((state_val_17665 === (5))){
var inst_17658 = cljs.core.async.close_BANG_.call(null,out);
var state_17664__$1 = state_17664;
var statearr_17677_17694 = state_17664__$1;
(statearr_17677_17694[(2)] = inst_17658);

(statearr_17677_17694[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17665 === (10))){
var inst_17656 = (state_17664[(2)]);
var state_17664__$1 = state_17664;
var statearr_17678_17695 = state_17664__$1;
(statearr_17678_17695[(2)] = inst_17656);

(statearr_17678_17695[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17665 === (8))){
var inst_17643 = (state_17664[(7)]);
var inst_17645 = (state_17664[(9)]);
var inst_17644 = (state_17664[(8)]);
var inst_17634 = (state_17664[(10)]);
var inst_17648 = (function (){var cs = inst_17634;
var vec__17639 = inst_17643;
var v = inst_17644;
var c = inst_17645;
return ((function (cs,vec__17639,v,c,inst_17643,inst_17645,inst_17644,inst_17634,state_val_17665,c__16273__auto___17686,out){
return (function (p1__17630_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__17630_SHARP_);
});
;})(cs,vec__17639,v,c,inst_17643,inst_17645,inst_17644,inst_17634,state_val_17665,c__16273__auto___17686,out))
})();
var inst_17649 = cljs.core.filterv.call(null,inst_17648,inst_17634);
var inst_17634__$1 = inst_17649;
var state_17664__$1 = (function (){var statearr_17679 = state_17664;
(statearr_17679[(10)] = inst_17634__$1);

return statearr_17679;
})();
var statearr_17680_17696 = state_17664__$1;
(statearr_17680_17696[(2)] = null);

(statearr_17680_17696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___17686,out))
;
return ((function (switch__16183__auto__,c__16273__auto___17686,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_17681 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17681[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_17681[(1)] = (1));

return statearr_17681;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_17664){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_17664);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e17682){if((e17682 instanceof Object)){
var ex__16187__auto__ = e17682;
var statearr_17683_17697 = state_17664;
(statearr_17683_17697[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17664);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17682;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17698 = state_17664;
state_17664 = G__17698;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_17664){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_17664);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___17686,out))
})();
var state__16275__auto__ = (function (){var statearr_17684 = f__16274__auto__.call(null);
(statearr_17684[(6)] = c__16273__auto___17686);

return statearr_17684;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___17686,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__17700 = arguments.length;
switch (G__17700) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16273__auto___17745 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___17745,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___17745,out){
return (function (state_17724){
var state_val_17725 = (state_17724[(1)]);
if((state_val_17725 === (7))){
var inst_17706 = (state_17724[(7)]);
var inst_17706__$1 = (state_17724[(2)]);
var inst_17707 = (inst_17706__$1 == null);
var inst_17708 = cljs.core.not.call(null,inst_17707);
var state_17724__$1 = (function (){var statearr_17726 = state_17724;
(statearr_17726[(7)] = inst_17706__$1);

return statearr_17726;
})();
if(inst_17708){
var statearr_17727_17746 = state_17724__$1;
(statearr_17727_17746[(1)] = (8));

} else {
var statearr_17728_17747 = state_17724__$1;
(statearr_17728_17747[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17725 === (1))){
var inst_17701 = (0);
var state_17724__$1 = (function (){var statearr_17729 = state_17724;
(statearr_17729[(8)] = inst_17701);

return statearr_17729;
})();
var statearr_17730_17748 = state_17724__$1;
(statearr_17730_17748[(2)] = null);

(statearr_17730_17748[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17725 === (4))){
var state_17724__$1 = state_17724;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17724__$1,(7),ch);
} else {
if((state_val_17725 === (6))){
var inst_17719 = (state_17724[(2)]);
var state_17724__$1 = state_17724;
var statearr_17731_17749 = state_17724__$1;
(statearr_17731_17749[(2)] = inst_17719);

(statearr_17731_17749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17725 === (3))){
var inst_17721 = (state_17724[(2)]);
var inst_17722 = cljs.core.async.close_BANG_.call(null,out);
var state_17724__$1 = (function (){var statearr_17732 = state_17724;
(statearr_17732[(9)] = inst_17721);

return statearr_17732;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17724__$1,inst_17722);
} else {
if((state_val_17725 === (2))){
var inst_17701 = (state_17724[(8)]);
var inst_17703 = (inst_17701 < n);
var state_17724__$1 = state_17724;
if(cljs.core.truth_(inst_17703)){
var statearr_17733_17750 = state_17724__$1;
(statearr_17733_17750[(1)] = (4));

} else {
var statearr_17734_17751 = state_17724__$1;
(statearr_17734_17751[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17725 === (11))){
var inst_17701 = (state_17724[(8)]);
var inst_17711 = (state_17724[(2)]);
var inst_17712 = (inst_17701 + (1));
var inst_17701__$1 = inst_17712;
var state_17724__$1 = (function (){var statearr_17735 = state_17724;
(statearr_17735[(10)] = inst_17711);

(statearr_17735[(8)] = inst_17701__$1);

return statearr_17735;
})();
var statearr_17736_17752 = state_17724__$1;
(statearr_17736_17752[(2)] = null);

(statearr_17736_17752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17725 === (9))){
var state_17724__$1 = state_17724;
var statearr_17737_17753 = state_17724__$1;
(statearr_17737_17753[(2)] = null);

(statearr_17737_17753[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17725 === (5))){
var state_17724__$1 = state_17724;
var statearr_17738_17754 = state_17724__$1;
(statearr_17738_17754[(2)] = null);

(statearr_17738_17754[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17725 === (10))){
var inst_17716 = (state_17724[(2)]);
var state_17724__$1 = state_17724;
var statearr_17739_17755 = state_17724__$1;
(statearr_17739_17755[(2)] = inst_17716);

(statearr_17739_17755[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17725 === (8))){
var inst_17706 = (state_17724[(7)]);
var state_17724__$1 = state_17724;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17724__$1,(11),out,inst_17706);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___17745,out))
;
return ((function (switch__16183__auto__,c__16273__auto___17745,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_17740 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17740[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_17740[(1)] = (1));

return statearr_17740;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_17724){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_17724);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e17741){if((e17741 instanceof Object)){
var ex__16187__auto__ = e17741;
var statearr_17742_17756 = state_17724;
(statearr_17742_17756[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17724);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17741;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17757 = state_17724;
state_17724 = G__17757;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_17724){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_17724);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___17745,out))
})();
var state__16275__auto__ = (function (){var statearr_17743 = f__16274__auto__.call(null);
(statearr_17743[(6)] = c__16273__auto___17745);

return statearr_17743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___17745,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async17759 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17759 = (function (f,ch,meta17760){
this.f = f;
this.ch = ch;
this.meta17760 = meta17760;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17759.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17761,meta17760__$1){
var self__ = this;
var _17761__$1 = this;
return (new cljs.core.async.t_cljs$core$async17759(self__.f,self__.ch,meta17760__$1));
});

cljs.core.async.t_cljs$core$async17759.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17761){
var self__ = this;
var _17761__$1 = this;
return self__.meta17760;
});

cljs.core.async.t_cljs$core$async17759.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17759.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async17759.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async17759.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17759.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async17762 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17762 = (function (f,ch,meta17760,_,fn1,meta17763){
this.f = f;
this.ch = ch;
this.meta17760 = meta17760;
this._ = _;
this.fn1 = fn1;
this.meta17763 = meta17763;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17762.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_17764,meta17763__$1){
var self__ = this;
var _17764__$1 = this;
return (new cljs.core.async.t_cljs$core$async17762(self__.f,self__.ch,self__.meta17760,self__._,self__.fn1,meta17763__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async17762.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_17764){
var self__ = this;
var _17764__$1 = this;
return self__.meta17763;
});})(___$1))
;

cljs.core.async.t_cljs$core$async17762.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17762.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async17762.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async17762.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__17758_SHARP_){
return f1.call(null,(((p1__17758_SHARP_ == null))?null:self__.f.call(null,p1__17758_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async17762.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta17760","meta17760",729622830,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async17759","cljs.core.async/t_cljs$core$async17759",2079643716,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta17763","meta17763",1323230425,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async17762.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17762.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17762";

cljs.core.async.t_cljs$core$async17762.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async17762");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async17762 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async17762(f__$1,ch__$1,meta17760__$1,___$2,fn1__$1,meta17763){
return (new cljs.core.async.t_cljs$core$async17762(f__$1,ch__$1,meta17760__$1,___$2,fn1__$1,meta17763));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async17762(self__.f,self__.ch,self__.meta17760,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__8376__auto__ = ret;
if(cljs.core.truth_(and__8376__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__8376__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async17759.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17759.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async17759.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta17760","meta17760",729622830,null)], null);
});

cljs.core.async.t_cljs$core$async17759.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17759.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17759";

cljs.core.async.t_cljs$core$async17759.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async17759");
});

cljs.core.async.__GT_t_cljs$core$async17759 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async17759(f__$1,ch__$1,meta17760){
return (new cljs.core.async.t_cljs$core$async17759(f__$1,ch__$1,meta17760));
});

}

return (new cljs.core.async.t_cljs$core$async17759(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async17765 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17765 = (function (f,ch,meta17766){
this.f = f;
this.ch = ch;
this.meta17766 = meta17766;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17765.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17767,meta17766__$1){
var self__ = this;
var _17767__$1 = this;
return (new cljs.core.async.t_cljs$core$async17765(self__.f,self__.ch,meta17766__$1));
});

cljs.core.async.t_cljs$core$async17765.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17767){
var self__ = this;
var _17767__$1 = this;
return self__.meta17766;
});

cljs.core.async.t_cljs$core$async17765.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17765.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async17765.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17765.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async17765.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17765.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async17765.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta17766","meta17766",-974466463,null)], null);
});

cljs.core.async.t_cljs$core$async17765.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17765.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17765";

cljs.core.async.t_cljs$core$async17765.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async17765");
});

cljs.core.async.__GT_t_cljs$core$async17765 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async17765(f__$1,ch__$1,meta17766){
return (new cljs.core.async.t_cljs$core$async17765(f__$1,ch__$1,meta17766));
});

}

return (new cljs.core.async.t_cljs$core$async17765(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async17768 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17768 = (function (p,ch,meta17769){
this.p = p;
this.ch = ch;
this.meta17769 = meta17769;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17768.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17770,meta17769__$1){
var self__ = this;
var _17770__$1 = this;
return (new cljs.core.async.t_cljs$core$async17768(self__.p,self__.ch,meta17769__$1));
});

cljs.core.async.t_cljs$core$async17768.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17770){
var self__ = this;
var _17770__$1 = this;
return self__.meta17769;
});

cljs.core.async.t_cljs$core$async17768.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17768.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async17768.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async17768.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17768.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async17768.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17768.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async17768.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta17769","meta17769",-1557441020,null)], null);
});

cljs.core.async.t_cljs$core$async17768.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17768.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17768";

cljs.core.async.t_cljs$core$async17768.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async17768");
});

cljs.core.async.__GT_t_cljs$core$async17768 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async17768(p__$1,ch__$1,meta17769){
return (new cljs.core.async.t_cljs$core$async17768(p__$1,ch__$1,meta17769));
});

}

return (new cljs.core.async.t_cljs$core$async17768(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__17772 = arguments.length;
switch (G__17772) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16273__auto___17812 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___17812,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___17812,out){
return (function (state_17793){
var state_val_17794 = (state_17793[(1)]);
if((state_val_17794 === (7))){
var inst_17789 = (state_17793[(2)]);
var state_17793__$1 = state_17793;
var statearr_17795_17813 = state_17793__$1;
(statearr_17795_17813[(2)] = inst_17789);

(statearr_17795_17813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (1))){
var state_17793__$1 = state_17793;
var statearr_17796_17814 = state_17793__$1;
(statearr_17796_17814[(2)] = null);

(statearr_17796_17814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (4))){
var inst_17775 = (state_17793[(7)]);
var inst_17775__$1 = (state_17793[(2)]);
var inst_17776 = (inst_17775__$1 == null);
var state_17793__$1 = (function (){var statearr_17797 = state_17793;
(statearr_17797[(7)] = inst_17775__$1);

return statearr_17797;
})();
if(cljs.core.truth_(inst_17776)){
var statearr_17798_17815 = state_17793__$1;
(statearr_17798_17815[(1)] = (5));

} else {
var statearr_17799_17816 = state_17793__$1;
(statearr_17799_17816[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (6))){
var inst_17775 = (state_17793[(7)]);
var inst_17780 = p.call(null,inst_17775);
var state_17793__$1 = state_17793;
if(cljs.core.truth_(inst_17780)){
var statearr_17800_17817 = state_17793__$1;
(statearr_17800_17817[(1)] = (8));

} else {
var statearr_17801_17818 = state_17793__$1;
(statearr_17801_17818[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (3))){
var inst_17791 = (state_17793[(2)]);
var state_17793__$1 = state_17793;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17793__$1,inst_17791);
} else {
if((state_val_17794 === (2))){
var state_17793__$1 = state_17793;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17793__$1,(4),ch);
} else {
if((state_val_17794 === (11))){
var inst_17783 = (state_17793[(2)]);
var state_17793__$1 = state_17793;
var statearr_17802_17819 = state_17793__$1;
(statearr_17802_17819[(2)] = inst_17783);

(statearr_17802_17819[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (9))){
var state_17793__$1 = state_17793;
var statearr_17803_17820 = state_17793__$1;
(statearr_17803_17820[(2)] = null);

(statearr_17803_17820[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (5))){
var inst_17778 = cljs.core.async.close_BANG_.call(null,out);
var state_17793__$1 = state_17793;
var statearr_17804_17821 = state_17793__$1;
(statearr_17804_17821[(2)] = inst_17778);

(statearr_17804_17821[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (10))){
var inst_17786 = (state_17793[(2)]);
var state_17793__$1 = (function (){var statearr_17805 = state_17793;
(statearr_17805[(8)] = inst_17786);

return statearr_17805;
})();
var statearr_17806_17822 = state_17793__$1;
(statearr_17806_17822[(2)] = null);

(statearr_17806_17822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (8))){
var inst_17775 = (state_17793[(7)]);
var state_17793__$1 = state_17793;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17793__$1,(11),out,inst_17775);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___17812,out))
;
return ((function (switch__16183__auto__,c__16273__auto___17812,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_17807 = [null,null,null,null,null,null,null,null,null];
(statearr_17807[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_17807[(1)] = (1));

return statearr_17807;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_17793){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_17793);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e17808){if((e17808 instanceof Object)){
var ex__16187__auto__ = e17808;
var statearr_17809_17823 = state_17793;
(statearr_17809_17823[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17793);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17808;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17824 = state_17793;
state_17793 = G__17824;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_17793){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_17793);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___17812,out))
})();
var state__16275__auto__ = (function (){var statearr_17810 = f__16274__auto__.call(null);
(statearr_17810[(6)] = c__16273__auto___17812);

return statearr_17810;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___17812,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__17826 = arguments.length;
switch (G__17826) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__16273__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto__){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__){
return (function (state_17889){
var state_val_17890 = (state_17889[(1)]);
if((state_val_17890 === (7))){
var inst_17885 = (state_17889[(2)]);
var state_17889__$1 = state_17889;
var statearr_17891_17929 = state_17889__$1;
(statearr_17891_17929[(2)] = inst_17885);

(statearr_17891_17929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (20))){
var inst_17855 = (state_17889[(7)]);
var inst_17866 = (state_17889[(2)]);
var inst_17867 = cljs.core.next.call(null,inst_17855);
var inst_17841 = inst_17867;
var inst_17842 = null;
var inst_17843 = (0);
var inst_17844 = (0);
var state_17889__$1 = (function (){var statearr_17892 = state_17889;
(statearr_17892[(8)] = inst_17844);

(statearr_17892[(9)] = inst_17842);

(statearr_17892[(10)] = inst_17841);

(statearr_17892[(11)] = inst_17866);

(statearr_17892[(12)] = inst_17843);

return statearr_17892;
})();
var statearr_17893_17930 = state_17889__$1;
(statearr_17893_17930[(2)] = null);

(statearr_17893_17930[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (1))){
var state_17889__$1 = state_17889;
var statearr_17894_17931 = state_17889__$1;
(statearr_17894_17931[(2)] = null);

(statearr_17894_17931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (4))){
var inst_17830 = (state_17889[(13)]);
var inst_17830__$1 = (state_17889[(2)]);
var inst_17831 = (inst_17830__$1 == null);
var state_17889__$1 = (function (){var statearr_17895 = state_17889;
(statearr_17895[(13)] = inst_17830__$1);

return statearr_17895;
})();
if(cljs.core.truth_(inst_17831)){
var statearr_17896_17932 = state_17889__$1;
(statearr_17896_17932[(1)] = (5));

} else {
var statearr_17897_17933 = state_17889__$1;
(statearr_17897_17933[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (15))){
var state_17889__$1 = state_17889;
var statearr_17901_17934 = state_17889__$1;
(statearr_17901_17934[(2)] = null);

(statearr_17901_17934[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (21))){
var state_17889__$1 = state_17889;
var statearr_17902_17935 = state_17889__$1;
(statearr_17902_17935[(2)] = null);

(statearr_17902_17935[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (13))){
var inst_17844 = (state_17889[(8)]);
var inst_17842 = (state_17889[(9)]);
var inst_17841 = (state_17889[(10)]);
var inst_17843 = (state_17889[(12)]);
var inst_17851 = (state_17889[(2)]);
var inst_17852 = (inst_17844 + (1));
var tmp17898 = inst_17842;
var tmp17899 = inst_17841;
var tmp17900 = inst_17843;
var inst_17841__$1 = tmp17899;
var inst_17842__$1 = tmp17898;
var inst_17843__$1 = tmp17900;
var inst_17844__$1 = inst_17852;
var state_17889__$1 = (function (){var statearr_17903 = state_17889;
(statearr_17903[(14)] = inst_17851);

(statearr_17903[(8)] = inst_17844__$1);

(statearr_17903[(9)] = inst_17842__$1);

(statearr_17903[(10)] = inst_17841__$1);

(statearr_17903[(12)] = inst_17843__$1);

return statearr_17903;
})();
var statearr_17904_17936 = state_17889__$1;
(statearr_17904_17936[(2)] = null);

(statearr_17904_17936[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (22))){
var state_17889__$1 = state_17889;
var statearr_17905_17937 = state_17889__$1;
(statearr_17905_17937[(2)] = null);

(statearr_17905_17937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (6))){
var inst_17830 = (state_17889[(13)]);
var inst_17839 = f.call(null,inst_17830);
var inst_17840 = cljs.core.seq.call(null,inst_17839);
var inst_17841 = inst_17840;
var inst_17842 = null;
var inst_17843 = (0);
var inst_17844 = (0);
var state_17889__$1 = (function (){var statearr_17906 = state_17889;
(statearr_17906[(8)] = inst_17844);

(statearr_17906[(9)] = inst_17842);

(statearr_17906[(10)] = inst_17841);

(statearr_17906[(12)] = inst_17843);

return statearr_17906;
})();
var statearr_17907_17938 = state_17889__$1;
(statearr_17907_17938[(2)] = null);

(statearr_17907_17938[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (17))){
var inst_17855 = (state_17889[(7)]);
var inst_17859 = cljs.core.chunk_first.call(null,inst_17855);
var inst_17860 = cljs.core.chunk_rest.call(null,inst_17855);
var inst_17861 = cljs.core.count.call(null,inst_17859);
var inst_17841 = inst_17860;
var inst_17842 = inst_17859;
var inst_17843 = inst_17861;
var inst_17844 = (0);
var state_17889__$1 = (function (){var statearr_17908 = state_17889;
(statearr_17908[(8)] = inst_17844);

(statearr_17908[(9)] = inst_17842);

(statearr_17908[(10)] = inst_17841);

(statearr_17908[(12)] = inst_17843);

return statearr_17908;
})();
var statearr_17909_17939 = state_17889__$1;
(statearr_17909_17939[(2)] = null);

(statearr_17909_17939[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (3))){
var inst_17887 = (state_17889[(2)]);
var state_17889__$1 = state_17889;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17889__$1,inst_17887);
} else {
if((state_val_17890 === (12))){
var inst_17875 = (state_17889[(2)]);
var state_17889__$1 = state_17889;
var statearr_17910_17940 = state_17889__$1;
(statearr_17910_17940[(2)] = inst_17875);

(statearr_17910_17940[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (2))){
var state_17889__$1 = state_17889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17889__$1,(4),in$);
} else {
if((state_val_17890 === (23))){
var inst_17883 = (state_17889[(2)]);
var state_17889__$1 = state_17889;
var statearr_17911_17941 = state_17889__$1;
(statearr_17911_17941[(2)] = inst_17883);

(statearr_17911_17941[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (19))){
var inst_17870 = (state_17889[(2)]);
var state_17889__$1 = state_17889;
var statearr_17912_17942 = state_17889__$1;
(statearr_17912_17942[(2)] = inst_17870);

(statearr_17912_17942[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (11))){
var inst_17855 = (state_17889[(7)]);
var inst_17841 = (state_17889[(10)]);
var inst_17855__$1 = cljs.core.seq.call(null,inst_17841);
var state_17889__$1 = (function (){var statearr_17913 = state_17889;
(statearr_17913[(7)] = inst_17855__$1);

return statearr_17913;
})();
if(inst_17855__$1){
var statearr_17914_17943 = state_17889__$1;
(statearr_17914_17943[(1)] = (14));

} else {
var statearr_17915_17944 = state_17889__$1;
(statearr_17915_17944[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (9))){
var inst_17877 = (state_17889[(2)]);
var inst_17878 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_17889__$1 = (function (){var statearr_17916 = state_17889;
(statearr_17916[(15)] = inst_17877);

return statearr_17916;
})();
if(cljs.core.truth_(inst_17878)){
var statearr_17917_17945 = state_17889__$1;
(statearr_17917_17945[(1)] = (21));

} else {
var statearr_17918_17946 = state_17889__$1;
(statearr_17918_17946[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (5))){
var inst_17833 = cljs.core.async.close_BANG_.call(null,out);
var state_17889__$1 = state_17889;
var statearr_17919_17947 = state_17889__$1;
(statearr_17919_17947[(2)] = inst_17833);

(statearr_17919_17947[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (14))){
var inst_17855 = (state_17889[(7)]);
var inst_17857 = cljs.core.chunked_seq_QMARK_.call(null,inst_17855);
var state_17889__$1 = state_17889;
if(inst_17857){
var statearr_17920_17948 = state_17889__$1;
(statearr_17920_17948[(1)] = (17));

} else {
var statearr_17921_17949 = state_17889__$1;
(statearr_17921_17949[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (16))){
var inst_17873 = (state_17889[(2)]);
var state_17889__$1 = state_17889;
var statearr_17922_17950 = state_17889__$1;
(statearr_17922_17950[(2)] = inst_17873);

(statearr_17922_17950[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (10))){
var inst_17844 = (state_17889[(8)]);
var inst_17842 = (state_17889[(9)]);
var inst_17849 = cljs.core._nth.call(null,inst_17842,inst_17844);
var state_17889__$1 = state_17889;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17889__$1,(13),out,inst_17849);
} else {
if((state_val_17890 === (18))){
var inst_17855 = (state_17889[(7)]);
var inst_17864 = cljs.core.first.call(null,inst_17855);
var state_17889__$1 = state_17889;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17889__$1,(20),out,inst_17864);
} else {
if((state_val_17890 === (8))){
var inst_17844 = (state_17889[(8)]);
var inst_17843 = (state_17889[(12)]);
var inst_17846 = (inst_17844 < inst_17843);
var inst_17847 = inst_17846;
var state_17889__$1 = state_17889;
if(cljs.core.truth_(inst_17847)){
var statearr_17923_17951 = state_17889__$1;
(statearr_17923_17951[(1)] = (10));

} else {
var statearr_17924_17952 = state_17889__$1;
(statearr_17924_17952[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto__))
;
return ((function (switch__16183__auto__,c__16273__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_17925 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17925[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__);

(statearr_17925[(1)] = (1));

return statearr_17925;
});
var cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____1 = (function (state_17889){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_17889);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e17926){if((e17926 instanceof Object)){
var ex__16187__auto__ = e17926;
var statearr_17927_17953 = state_17889;
(statearr_17927_17953[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17889);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17926;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17954 = state_17889;
state_17889 = G__17954;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__ = function(state_17889){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____1.call(this,state_17889);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__))
})();
var state__16275__auto__ = (function (){var statearr_17928 = f__16274__auto__.call(null);
(statearr_17928[(6)] = c__16273__auto__);

return statearr_17928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto__))
);

return c__16273__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__17956 = arguments.length;
switch (G__17956) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__17959 = arguments.length;
switch (G__17959) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__17962 = arguments.length;
switch (G__17962) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16273__auto___18009 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___18009,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___18009,out){
return (function (state_17986){
var state_val_17987 = (state_17986[(1)]);
if((state_val_17987 === (7))){
var inst_17981 = (state_17986[(2)]);
var state_17986__$1 = state_17986;
var statearr_17988_18010 = state_17986__$1;
(statearr_17988_18010[(2)] = inst_17981);

(statearr_17988_18010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17987 === (1))){
var inst_17963 = null;
var state_17986__$1 = (function (){var statearr_17989 = state_17986;
(statearr_17989[(7)] = inst_17963);

return statearr_17989;
})();
var statearr_17990_18011 = state_17986__$1;
(statearr_17990_18011[(2)] = null);

(statearr_17990_18011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17987 === (4))){
var inst_17966 = (state_17986[(8)]);
var inst_17966__$1 = (state_17986[(2)]);
var inst_17967 = (inst_17966__$1 == null);
var inst_17968 = cljs.core.not.call(null,inst_17967);
var state_17986__$1 = (function (){var statearr_17991 = state_17986;
(statearr_17991[(8)] = inst_17966__$1);

return statearr_17991;
})();
if(inst_17968){
var statearr_17992_18012 = state_17986__$1;
(statearr_17992_18012[(1)] = (5));

} else {
var statearr_17993_18013 = state_17986__$1;
(statearr_17993_18013[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17987 === (6))){
var state_17986__$1 = state_17986;
var statearr_17994_18014 = state_17986__$1;
(statearr_17994_18014[(2)] = null);

(statearr_17994_18014[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17987 === (3))){
var inst_17983 = (state_17986[(2)]);
var inst_17984 = cljs.core.async.close_BANG_.call(null,out);
var state_17986__$1 = (function (){var statearr_17995 = state_17986;
(statearr_17995[(9)] = inst_17983);

return statearr_17995;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17986__$1,inst_17984);
} else {
if((state_val_17987 === (2))){
var state_17986__$1 = state_17986;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17986__$1,(4),ch);
} else {
if((state_val_17987 === (11))){
var inst_17966 = (state_17986[(8)]);
var inst_17975 = (state_17986[(2)]);
var inst_17963 = inst_17966;
var state_17986__$1 = (function (){var statearr_17996 = state_17986;
(statearr_17996[(7)] = inst_17963);

(statearr_17996[(10)] = inst_17975);

return statearr_17996;
})();
var statearr_17997_18015 = state_17986__$1;
(statearr_17997_18015[(2)] = null);

(statearr_17997_18015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17987 === (9))){
var inst_17966 = (state_17986[(8)]);
var state_17986__$1 = state_17986;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17986__$1,(11),out,inst_17966);
} else {
if((state_val_17987 === (5))){
var inst_17963 = (state_17986[(7)]);
var inst_17966 = (state_17986[(8)]);
var inst_17970 = cljs.core._EQ_.call(null,inst_17966,inst_17963);
var state_17986__$1 = state_17986;
if(inst_17970){
var statearr_17999_18016 = state_17986__$1;
(statearr_17999_18016[(1)] = (8));

} else {
var statearr_18000_18017 = state_17986__$1;
(statearr_18000_18017[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17987 === (10))){
var inst_17978 = (state_17986[(2)]);
var state_17986__$1 = state_17986;
var statearr_18001_18018 = state_17986__$1;
(statearr_18001_18018[(2)] = inst_17978);

(statearr_18001_18018[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17987 === (8))){
var inst_17963 = (state_17986[(7)]);
var tmp17998 = inst_17963;
var inst_17963__$1 = tmp17998;
var state_17986__$1 = (function (){var statearr_18002 = state_17986;
(statearr_18002[(7)] = inst_17963__$1);

return statearr_18002;
})();
var statearr_18003_18019 = state_17986__$1;
(statearr_18003_18019[(2)] = null);

(statearr_18003_18019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___18009,out))
;
return ((function (switch__16183__auto__,c__16273__auto___18009,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_18004 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18004[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_18004[(1)] = (1));

return statearr_18004;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_17986){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_17986);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e18005){if((e18005 instanceof Object)){
var ex__16187__auto__ = e18005;
var statearr_18006_18020 = state_17986;
(statearr_18006_18020[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17986);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18005;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18021 = state_17986;
state_17986 = G__18021;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_17986){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_17986);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___18009,out))
})();
var state__16275__auto__ = (function (){var statearr_18007 = f__16274__auto__.call(null);
(statearr_18007[(6)] = c__16273__auto___18009);

return statearr_18007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___18009,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__18023 = arguments.length;
switch (G__18023) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16273__auto___18089 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___18089,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___18089,out){
return (function (state_18061){
var state_val_18062 = (state_18061[(1)]);
if((state_val_18062 === (7))){
var inst_18057 = (state_18061[(2)]);
var state_18061__$1 = state_18061;
var statearr_18063_18090 = state_18061__$1;
(statearr_18063_18090[(2)] = inst_18057);

(statearr_18063_18090[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18062 === (1))){
var inst_18024 = (new Array(n));
var inst_18025 = inst_18024;
var inst_18026 = (0);
var state_18061__$1 = (function (){var statearr_18064 = state_18061;
(statearr_18064[(7)] = inst_18026);

(statearr_18064[(8)] = inst_18025);

return statearr_18064;
})();
var statearr_18065_18091 = state_18061__$1;
(statearr_18065_18091[(2)] = null);

(statearr_18065_18091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18062 === (4))){
var inst_18029 = (state_18061[(9)]);
var inst_18029__$1 = (state_18061[(2)]);
var inst_18030 = (inst_18029__$1 == null);
var inst_18031 = cljs.core.not.call(null,inst_18030);
var state_18061__$1 = (function (){var statearr_18066 = state_18061;
(statearr_18066[(9)] = inst_18029__$1);

return statearr_18066;
})();
if(inst_18031){
var statearr_18067_18092 = state_18061__$1;
(statearr_18067_18092[(1)] = (5));

} else {
var statearr_18068_18093 = state_18061__$1;
(statearr_18068_18093[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18062 === (15))){
var inst_18051 = (state_18061[(2)]);
var state_18061__$1 = state_18061;
var statearr_18069_18094 = state_18061__$1;
(statearr_18069_18094[(2)] = inst_18051);

(statearr_18069_18094[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18062 === (13))){
var state_18061__$1 = state_18061;
var statearr_18070_18095 = state_18061__$1;
(statearr_18070_18095[(2)] = null);

(statearr_18070_18095[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18062 === (6))){
var inst_18026 = (state_18061[(7)]);
var inst_18047 = (inst_18026 > (0));
var state_18061__$1 = state_18061;
if(cljs.core.truth_(inst_18047)){
var statearr_18071_18096 = state_18061__$1;
(statearr_18071_18096[(1)] = (12));

} else {
var statearr_18072_18097 = state_18061__$1;
(statearr_18072_18097[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18062 === (3))){
var inst_18059 = (state_18061[(2)]);
var state_18061__$1 = state_18061;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18061__$1,inst_18059);
} else {
if((state_val_18062 === (12))){
var inst_18025 = (state_18061[(8)]);
var inst_18049 = cljs.core.vec.call(null,inst_18025);
var state_18061__$1 = state_18061;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18061__$1,(15),out,inst_18049);
} else {
if((state_val_18062 === (2))){
var state_18061__$1 = state_18061;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18061__$1,(4),ch);
} else {
if((state_val_18062 === (11))){
var inst_18041 = (state_18061[(2)]);
var inst_18042 = (new Array(n));
var inst_18025 = inst_18042;
var inst_18026 = (0);
var state_18061__$1 = (function (){var statearr_18073 = state_18061;
(statearr_18073[(7)] = inst_18026);

(statearr_18073[(8)] = inst_18025);

(statearr_18073[(10)] = inst_18041);

return statearr_18073;
})();
var statearr_18074_18098 = state_18061__$1;
(statearr_18074_18098[(2)] = null);

(statearr_18074_18098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18062 === (9))){
var inst_18025 = (state_18061[(8)]);
var inst_18039 = cljs.core.vec.call(null,inst_18025);
var state_18061__$1 = state_18061;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18061__$1,(11),out,inst_18039);
} else {
if((state_val_18062 === (5))){
var inst_18026 = (state_18061[(7)]);
var inst_18034 = (state_18061[(11)]);
var inst_18025 = (state_18061[(8)]);
var inst_18029 = (state_18061[(9)]);
var inst_18033 = (inst_18025[inst_18026] = inst_18029);
var inst_18034__$1 = (inst_18026 + (1));
var inst_18035 = (inst_18034__$1 < n);
var state_18061__$1 = (function (){var statearr_18075 = state_18061;
(statearr_18075[(11)] = inst_18034__$1);

(statearr_18075[(12)] = inst_18033);

return statearr_18075;
})();
if(cljs.core.truth_(inst_18035)){
var statearr_18076_18099 = state_18061__$1;
(statearr_18076_18099[(1)] = (8));

} else {
var statearr_18077_18100 = state_18061__$1;
(statearr_18077_18100[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18062 === (14))){
var inst_18054 = (state_18061[(2)]);
var inst_18055 = cljs.core.async.close_BANG_.call(null,out);
var state_18061__$1 = (function (){var statearr_18079 = state_18061;
(statearr_18079[(13)] = inst_18054);

return statearr_18079;
})();
var statearr_18080_18101 = state_18061__$1;
(statearr_18080_18101[(2)] = inst_18055);

(statearr_18080_18101[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18062 === (10))){
var inst_18045 = (state_18061[(2)]);
var state_18061__$1 = state_18061;
var statearr_18081_18102 = state_18061__$1;
(statearr_18081_18102[(2)] = inst_18045);

(statearr_18081_18102[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18062 === (8))){
var inst_18034 = (state_18061[(11)]);
var inst_18025 = (state_18061[(8)]);
var tmp18078 = inst_18025;
var inst_18025__$1 = tmp18078;
var inst_18026 = inst_18034;
var state_18061__$1 = (function (){var statearr_18082 = state_18061;
(statearr_18082[(7)] = inst_18026);

(statearr_18082[(8)] = inst_18025__$1);

return statearr_18082;
})();
var statearr_18083_18103 = state_18061__$1;
(statearr_18083_18103[(2)] = null);

(statearr_18083_18103[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___18089,out))
;
return ((function (switch__16183__auto__,c__16273__auto___18089,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_18084 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18084[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_18084[(1)] = (1));

return statearr_18084;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_18061){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_18061);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e18085){if((e18085 instanceof Object)){
var ex__16187__auto__ = e18085;
var statearr_18086_18104 = state_18061;
(statearr_18086_18104[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18061);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18085;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18105 = state_18061;
state_18061 = G__18105;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_18061){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_18061);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___18089,out))
})();
var state__16275__auto__ = (function (){var statearr_18087 = f__16274__auto__.call(null);
(statearr_18087[(6)] = c__16273__auto___18089);

return statearr_18087;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___18089,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__18107 = arguments.length;
switch (G__18107) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16273__auto___18177 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___18177,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___18177,out){
return (function (state_18149){
var state_val_18150 = (state_18149[(1)]);
if((state_val_18150 === (7))){
var inst_18145 = (state_18149[(2)]);
var state_18149__$1 = state_18149;
var statearr_18151_18178 = state_18149__$1;
(statearr_18151_18178[(2)] = inst_18145);

(statearr_18151_18178[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18150 === (1))){
var inst_18108 = [];
var inst_18109 = inst_18108;
var inst_18110 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_18149__$1 = (function (){var statearr_18152 = state_18149;
(statearr_18152[(7)] = inst_18110);

(statearr_18152[(8)] = inst_18109);

return statearr_18152;
})();
var statearr_18153_18179 = state_18149__$1;
(statearr_18153_18179[(2)] = null);

(statearr_18153_18179[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18150 === (4))){
var inst_18113 = (state_18149[(9)]);
var inst_18113__$1 = (state_18149[(2)]);
var inst_18114 = (inst_18113__$1 == null);
var inst_18115 = cljs.core.not.call(null,inst_18114);
var state_18149__$1 = (function (){var statearr_18154 = state_18149;
(statearr_18154[(9)] = inst_18113__$1);

return statearr_18154;
})();
if(inst_18115){
var statearr_18155_18180 = state_18149__$1;
(statearr_18155_18180[(1)] = (5));

} else {
var statearr_18156_18181 = state_18149__$1;
(statearr_18156_18181[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18150 === (15))){
var inst_18139 = (state_18149[(2)]);
var state_18149__$1 = state_18149;
var statearr_18157_18182 = state_18149__$1;
(statearr_18157_18182[(2)] = inst_18139);

(statearr_18157_18182[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18150 === (13))){
var state_18149__$1 = state_18149;
var statearr_18158_18183 = state_18149__$1;
(statearr_18158_18183[(2)] = null);

(statearr_18158_18183[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18150 === (6))){
var inst_18109 = (state_18149[(8)]);
var inst_18134 = inst_18109.length;
var inst_18135 = (inst_18134 > (0));
var state_18149__$1 = state_18149;
if(cljs.core.truth_(inst_18135)){
var statearr_18159_18184 = state_18149__$1;
(statearr_18159_18184[(1)] = (12));

} else {
var statearr_18160_18185 = state_18149__$1;
(statearr_18160_18185[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18150 === (3))){
var inst_18147 = (state_18149[(2)]);
var state_18149__$1 = state_18149;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18149__$1,inst_18147);
} else {
if((state_val_18150 === (12))){
var inst_18109 = (state_18149[(8)]);
var inst_18137 = cljs.core.vec.call(null,inst_18109);
var state_18149__$1 = state_18149;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18149__$1,(15),out,inst_18137);
} else {
if((state_val_18150 === (2))){
var state_18149__$1 = state_18149;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18149__$1,(4),ch);
} else {
if((state_val_18150 === (11))){
var inst_18117 = (state_18149[(10)]);
var inst_18113 = (state_18149[(9)]);
var inst_18127 = (state_18149[(2)]);
var inst_18128 = [];
var inst_18129 = inst_18128.push(inst_18113);
var inst_18109 = inst_18128;
var inst_18110 = inst_18117;
var state_18149__$1 = (function (){var statearr_18161 = state_18149;
(statearr_18161[(7)] = inst_18110);

(statearr_18161[(11)] = inst_18129);

(statearr_18161[(12)] = inst_18127);

(statearr_18161[(8)] = inst_18109);

return statearr_18161;
})();
var statearr_18162_18186 = state_18149__$1;
(statearr_18162_18186[(2)] = null);

(statearr_18162_18186[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18150 === (9))){
var inst_18109 = (state_18149[(8)]);
var inst_18125 = cljs.core.vec.call(null,inst_18109);
var state_18149__$1 = state_18149;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18149__$1,(11),out,inst_18125);
} else {
if((state_val_18150 === (5))){
var inst_18110 = (state_18149[(7)]);
var inst_18117 = (state_18149[(10)]);
var inst_18113 = (state_18149[(9)]);
var inst_18117__$1 = f.call(null,inst_18113);
var inst_18118 = cljs.core._EQ_.call(null,inst_18117__$1,inst_18110);
var inst_18119 = cljs.core.keyword_identical_QMARK_.call(null,inst_18110,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_18120 = (inst_18118) || (inst_18119);
var state_18149__$1 = (function (){var statearr_18163 = state_18149;
(statearr_18163[(10)] = inst_18117__$1);

return statearr_18163;
})();
if(cljs.core.truth_(inst_18120)){
var statearr_18164_18187 = state_18149__$1;
(statearr_18164_18187[(1)] = (8));

} else {
var statearr_18165_18188 = state_18149__$1;
(statearr_18165_18188[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18150 === (14))){
var inst_18142 = (state_18149[(2)]);
var inst_18143 = cljs.core.async.close_BANG_.call(null,out);
var state_18149__$1 = (function (){var statearr_18167 = state_18149;
(statearr_18167[(13)] = inst_18142);

return statearr_18167;
})();
var statearr_18168_18189 = state_18149__$1;
(statearr_18168_18189[(2)] = inst_18143);

(statearr_18168_18189[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18150 === (10))){
var inst_18132 = (state_18149[(2)]);
var state_18149__$1 = state_18149;
var statearr_18169_18190 = state_18149__$1;
(statearr_18169_18190[(2)] = inst_18132);

(statearr_18169_18190[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18150 === (8))){
var inst_18117 = (state_18149[(10)]);
var inst_18113 = (state_18149[(9)]);
var inst_18109 = (state_18149[(8)]);
var inst_18122 = inst_18109.push(inst_18113);
var tmp18166 = inst_18109;
var inst_18109__$1 = tmp18166;
var inst_18110 = inst_18117;
var state_18149__$1 = (function (){var statearr_18170 = state_18149;
(statearr_18170[(7)] = inst_18110);

(statearr_18170[(14)] = inst_18122);

(statearr_18170[(8)] = inst_18109__$1);

return statearr_18170;
})();
var statearr_18171_18191 = state_18149__$1;
(statearr_18171_18191[(2)] = null);

(statearr_18171_18191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___18177,out))
;
return ((function (switch__16183__auto__,c__16273__auto___18177,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_18172 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18172[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_18172[(1)] = (1));

return statearr_18172;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_18149){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_18149);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e18173){if((e18173 instanceof Object)){
var ex__16187__auto__ = e18173;
var statearr_18174_18192 = state_18149;
(statearr_18174_18192[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18149);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18173;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18193 = state_18149;
state_18149 = G__18193;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_18149){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_18149);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___18177,out))
})();
var state__16275__auto__ = (function (){var statearr_18175 = f__16274__auto__.call(null);
(statearr_18175[(6)] = c__16273__auto___18177);

return statearr_18175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___18177,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1518919052398
