// Compiled by ClojureScript 1.9.946 {}
goog.provide('cljs.js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('cljs.env');
goog.require('cljs.spec.alpha');
goog.require('cljs.analyzer');
goog.require('cljs.compiler');
goog.require('cljs.tools.reader');
goog.require('cljs.tools.reader.reader_types');
goog.require('cljs.tagged_literals');
goog.require('goog.crypt.base64');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
goog.require("cljs.core$macros");
cljs.js.debug_prn = (function cljs$js$debug_prn(var_args){
var args__9674__auto__ = [];
var len__9667__auto___14190 = arguments.length;
var i__9668__auto___14191 = (0);
while(true){
if((i__9668__auto___14191 < len__9667__auto___14190)){
args__9674__auto__.push((arguments[i__9668__auto___14191]));

var G__14192 = (i__9668__auto___14191 + (1));
i__9668__auto___14191 = G__14192;
continue;
} else {
}
break;
}

var argseq__9675__auto__ = ((((0) < args__9674__auto__.length))?(new cljs.core.IndexedSeq(args__9674__auto__.slice((0)),(0),null)):null);
return cljs.js.debug_prn.cljs$core$IFn$_invoke$arity$variadic(argseq__9675__auto__);
});

cljs.js.debug_prn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var _STAR_print_fn_STAR_14189 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_fn_STAR_ = cljs.core._STAR_print_err_fn_STAR_;

try{return cljs.core.apply.call(null,cljs.core.println,args);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_14189;
}});

cljs.js.debug_prn.cljs$lang$maxFixedArity = (0);

cljs.js.debug_prn.cljs$lang$applyTo = (function (seq14188){
return cljs.js.debug_prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq14188));
});

/**
 * Given a namespace as a symbol return the relative path sans extension
 */
cljs.js.ns__GT_relpath = (function cljs$js$ns__GT_relpath(ns_sym){
return clojure.string.replace.call(null,cljs.analyzer.munge_path.call(null,ns_sym),".","/");
});
cljs.js.file__GT_ns = (function cljs$js$file__GT_ns(file){
var lib_name = cljs.core.subs.call(null,clojure.string.replace.call(null,file,"/","."),(0),(cljs.core.count.call(null,file) - (5)));
return cljs.core.symbol.call(null,cljs.core.demunge.call(null,lib_name));
});
cljs.js.drop_macros_suffix = (function cljs$js$drop_macros_suffix(ns_name){
if(cljs.core.truth_(ns_name)){
if(clojure.string.ends_with_QMARK_.call(null,ns_name,"$macros")){
return cljs.core.subs.call(null,ns_name,(0),(cljs.core.count.call(null,ns_name) - (7)));
} else {
return ns_name;
}
} else {
return null;
}
});
cljs.js.elide_macros_suffix = (function cljs$js$elide_macros_suffix(sym){
return cljs.core.symbol.call(null,cljs.js.drop_macros_suffix.call(null,cljs.core.namespace.call(null,sym)),cljs.core.name.call(null,sym));
});
cljs.js.resolve_symbol = (function cljs$js$resolve_symbol(sym){
if(clojure.string.starts_with_QMARK_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)].join(''),".")){
return sym;
} else {
return cljs.js.elide_macros_suffix.call(null,cljs.analyzer.resolve_symbol.call(null,sym));
}
});
cljs.js.read = (function cljs$js$read(eof,rdr){
var _STAR_ns_STAR_14193 = cljs.core._STAR_ns_STAR_;
cljs.core._STAR_ns_STAR_ = cljs.core.symbol.call(null,cljs.js.drop_macros_suffix.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core._STAR_ns_STAR_)].join('')));

try{return cljs.tools.reader.read.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"eof","eof",-489063237),eof,new cljs.core.Keyword(null,"read-cond","read-cond",1056899244),new cljs.core.Keyword(null,"allow","allow",-1857325745),new cljs.core.Keyword(null,"features","features",-1146962336),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cljs","cljs",1492417629),null], null), null)], null),rdr);
}finally {cljs.core._STAR_ns_STAR_ = _STAR_ns_STAR_14193;
}});
cljs.js.atom_QMARK_ = (function cljs$js$atom_QMARK_(x){
return (x instanceof cljs.core.Atom);
});
cljs.js.valid_name_QMARK_ = (function cljs$js$valid_name_QMARK_(x){
return ((x == null)) || ((x instanceof cljs.core.Symbol)) || (typeof x === 'string');
});
cljs.js.valid_opts_QMARK_ = (function cljs$js$valid_opts_QMARK_(x){
return ((x == null)) || (cljs.core.map_QMARK_.call(null,x));
});
if(typeof cljs.js._STAR_load_fn_STAR_ !== 'undefined'){
} else {
/**
 * Each runtime environment provides a different way to load a library.
 *   Whatever function *load-fn* is bound to will be passed two arguments - a
 *   map and a callback function: The map will have the following keys:
 * 
 *   :name   - the name of the library (a symbol)
 *   :macros - modifier signaling a macros namespace load
 *   :path   - munged relative library path (a string)
 * 
 *   It is up to the implementor to correctly resolve the corresponding .cljs,
 *   .cljc, or .js resource (the order must be respected). If :macros is true
 *   resolution should only consider .clj or .cljc resources (the order must be
 *   respected). Upon resolution the callback should be invoked with a map
 *   containing the following keys:
 * 
 *   :lang       - the language, :clj or :js
 *   :source     - the source of the library (a string)
 *   :file       - optional, the file path, it will be added to AST's :file keyword
 *              (but not in :meta)
 *   :cache      - optional, if a :clj namespace has been precompiled to :js, can
 *              give an analysis cache for faster loads.
 *   :source-map - optional, if a :clj namespace has been precompiled to :js, can
 *              give a V3 source map JSON
 * 
 *   If the resource could not be resolved, the callback should be invoked with
 *   nil.
 */
cljs.js._STAR_load_fn_STAR_ = (function cljs$js$_STAR_load_fn_STAR_(m,cb){
throw (new Error("No *load-fn* set"));
});
}
if(typeof cljs.js._STAR_eval_fn_STAR_ !== 'undefined'){
} else {
/**
 * Each runtime environment provides various ways to eval JavaScript
 *   source. Whatever function *eval-fn* is bound to will be passed a map
 *   containing the following keys:
 * 
 *   :source - the source of the library (string)
 *   :name   - used to unique identify the script (symbol)
 *   :cache  - if the source was originally ClojureScript, will be given the
 *          analysis cache.
 * 
 *   The result of evaluation should be the return value.
 */
cljs.js._STAR_eval_fn_STAR_ = (function cljs$js$_STAR_eval_fn_STAR_(m){
throw (new Error("No *eval-fn* set"));
});
}
/**
 * A default JavaScript evaluation function.
 */
cljs.js.js_eval = (function cljs$js$js_eval(p__14194){
var map__14195 = p__14194;
var map__14195__$1 = ((((!((map__14195 == null)))?((((map__14195.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14195.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14195):map__14195);
var resource = map__14195__$1;
var source = cljs.core.get.call(null,map__14195__$1,new cljs.core.Keyword(null,"source","source",-433931539));
return eval(source);
});
cljs.js.wrap_error = (function cljs$js$wrap_error(ex){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),ex], null);
});
/**
 * Construct an empty compiler state. Required to invoke analyze, compile,
 * eval and eval-str.
 */
cljs.js.empty_state = (function cljs$js$empty_state(var_args){
var G__14198 = arguments.length;
switch (G__14198) {
case 0:
return cljs.js.empty_state.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.js.empty_state.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.js.empty_state.cljs$core$IFn$_invoke$arity$0 = (function (){
var G__14199 = cljs.env.default_compiler_env.call(null);
cljs.core.swap_BANG_.call(null,G__14199,((function (G__14199){
return (function (state){
return cljs.core.assoc_in.call(null,state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"rename-macros","rename-macros",1076432512),new cljs.core.Keyword(null,"renames","renames",343278368),new cljs.core.Keyword(null,"externs","externs",221720677),new cljs.core.Keyword(null,"use-macros","use-macros",-905638393),new cljs.core.Keyword(null,"excludes","excludes",-1791725945),new cljs.core.Keyword(null,"macros","macros",811339431),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"imports","imports",-1249933394),new cljs.core.Keyword(null,"requires","requires",-1201390927),new cljs.core.Keyword(null,"uses","uses",232664692),new cljs.core.Keyword(null,"defs","defs",1398449717),new cljs.core.Keyword(null,"require-macros","require-macros",707947416),new cljs.core.Keyword("cljs.analyzer","constants","cljs.analyzer/constants",1697083770),new cljs.core.Keyword(null,"doc","doc",1913296891)],[cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"process","process",-1011242831,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"hrtime","hrtime",-429399352,null),cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.Symbol(null,"goog","goog",-70603925,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"isArrayLike","isArrayLike",1707204182,null),cljs.core.PersistentArrayMap.EMPTY], null)], null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentHashSet.EMPTY,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"unsafe-bit-and","unsafe-bit-and",110395584,null),new cljs.core.Symbol(null,"macroexpand","macroexpand",1509933344,null),new cljs.core.Symbol(null,"unchecked-remainder-int","unchecked-remainder-int",1427188224,null),new cljs.core.Symbol(null,"when-first","when-first",821699168,null),new cljs.core.Symbol(null,"cond->>","cond->>",348844960,null),new cljs.core.Symbol(null,"bit-set","bit-set",-910710655,null),new cljs.core.Symbol(null,"import-macros","import-macros",-2058517343,null),new cljs.core.Symbol(null,"while","while",-1691317983,null),new cljs.core.Symbol(null,"satisfies?","satisfies?",-433227199,null),new cljs.core.Symbol(null,"unchecked-subtract-int","unchecked-subtract-int",-1899147615,null),new cljs.core.Symbol(null,"ns-unmap","ns-unmap",1255260993,null),new cljs.core.Symbol(null,"import","import",241030818,null),new cljs.core.Symbol(null,"bit-shift-right","bit-shift-right",884046498,null),new cljs.core.Symbol(null,"aget","aget",1491056546,null),new cljs.core.Symbol(null,"specify","specify",1712789507,null),new cljs.core.Symbol(null,"vswap!","vswap!",-574070781,null),new cljs.core.Symbol(null,"caching-hash","caching-hash",-1406165565,null),new cljs.core.Symbol(null,"bit-shift-left","bit-shift-left",-1814765981,null),new cljs.core.Symbol(null,"coercive-not","coercive-not",735107747,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null),new cljs.core.Symbol(null,"unchecked-get","unchecked-get",-1670542461,null),new cljs.core.Symbol(null,"ns-publics","ns-publics",903350436,null),new cljs.core.Symbol(null,"<","<",993667236,null),new cljs.core.Symbol(null,"this-as","this-as",-848995740,null),new cljs.core.Symbol(null,"..","..",-300507420,null),new cljs.core.Symbol(null,"delay","delay",1066306308,null),new cljs.core.Symbol(null,"some?","some?",234752293,null),new cljs.core.Symbol(null,"unchecked-negate","unchecked-negate",-1669067451,null),new cljs.core.Symbol(null,"simple-benchmark","simple-benchmark",62919109,null),new cljs.core.Symbol(null,"unchecked-inc-int","unchecked-inc-int",1402783397,null),new cljs.core.Symbol(null,"unchecked-set","unchecked-set",-986164507,null),new cljs.core.Symbol(null,"js-str","js-str",-1708707067,null),new cljs.core.Symbol(null,"bit-shift-right-zero-fill","bit-shift-right-zero-fill",-779613275,null),new cljs.core.Symbol(null,"implements?","implements?",424528006,null),new cljs.core.Symbol(null,"goog-define","goog-define",592226086,null),new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"specify!","specify!",-2049251450,null),new cljs.core.Symbol(null,"if-not","if-not",-265415609,null),new cljs.core.Symbol(null,"alength","alength",-1268305401,null),new cljs.core.Symbol(null,"bit-xor","bit-xor",-1334295033,null),new cljs.core.Symbol(null,"doseq","doseq",221164135,null),new cljs.core.Symbol(null,"unsigned-bit-shift-right","unsigned-bit-shift-right",-1953076601,null),new cljs.core.Symbol(null,"neg?","neg?",-1902175577,null),new cljs.core.Symbol(null,"unchecked-float","unchecked-float",1485658216,null),new cljs.core.Symbol(null,"undefined?","undefined?",1356377224,null),new cljs.core.Symbol(null,"deftype","deftype",1980826088,null),new cljs.core.Symbol(null,"mask","mask",1054783080,null),new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.Symbol(null,"divide","divide",-545489112,null),new cljs.core.Symbol(null,"coercive-boolean","coercive-boolean",-1069860952,null),new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"if-some","if-some",1960677609,null),new cljs.core.Symbol(null,"*","*",345799209,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"lazy-seq","lazy-seq",489632906,null),new cljs.core.Symbol(null,"js-delete","js-delete",170306730,null),new cljs.core.Symbol(null,"truth_","truth_",231933130,null),new cljs.core.Symbol(null,"defcurried","defcurried",112017674,null),new cljs.core.Symbol(null,"js-debugger","js-debugger",-1600472694,null),new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.Symbol(null,"->","->",-2139605430,null),new cljs.core.Symbol(null,"coercive-not=","coercive-not=",-1445527958,null),new cljs.core.Symbol(null,"doto","doto",1252536074,null),new cljs.core.Symbol(null,"areduce","areduce",-1873477878,null),new cljs.core.Symbol(null,"double","double",-1769548886,null),new cljs.core.Symbol(null,"bit-and-not","bit-and-not",-254338837,null),new cljs.core.Symbol(null,"unchecked-add-int","unchecked-add-int",-1821763285,null),new cljs.core.Symbol(null,"fn","fn",465265323,null),new cljs.core.Symbol(null,"short","short",-725675253,null),new cljs.core.Symbol(null,"js-this","js-this",972633228,null),new cljs.core.Symbol(null,"unchecked-double","unchecked-double",-1593778036,null),new cljs.core.Symbol(null,"string?","string?",-1129175764,null),new cljs.core.Symbol(null,"js-arguments","js-arguments",812196332,null),new cljs.core.Symbol(null,"unchecked-multiply-int","unchecked-multiply-int",-788546068,null),new cljs.core.Symbol(null,"as->","as->",1430690540,null),new cljs.core.Symbol(null,"when-not","when-not",-1223136340,null),new cljs.core.Symbol(null,"when","when",1064114221,null),new cljs.core.Symbol(null,"int","int",-100885395,null),new cljs.core.Symbol(null,">",">",1085014381,null),new cljs.core.Symbol(null,"keyword?","keyword?",1917797069,null),new cljs.core.Symbol(null,"use-macros","use-macros",734893134,null),new cljs.core.Symbol(null,"unchecked-multiply","unchecked-multiply",-1019161490,null),new cljs.core.Symbol(null,"gen-apply-to","gen-apply-to",1885071470,null),new cljs.core.Symbol(null,"some->>","some->>",-1499987794,null),new cljs.core.Symbol(null,"unchecked-dec","unchecked-dec",2095823150,null),new cljs.core.Symbol(null,"defn","defn",-126010802,null),new cljs.core.Symbol(null,"float","float",-91857841,null),new cljs.core.Symbol(null,"js-in","js-in",1388959023,null),new cljs.core.Symbol(null,"es6-iterable","es6-iterable",1296253359,null),new cljs.core.Symbol(null,"amap","amap",635923055,null),new cljs.core.Symbol(null,"use","use",-205850897,null),new cljs.core.Symbol(null,"declare","declare",654042991,null),new cljs.core.Symbol(null,"-","-",-471816912,null),new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,"extend-type","extend-type",1123355921,null),new cljs.core.Symbol(null,"macroexpand-1","macroexpand-1",659241329,null),new cljs.core.Symbol(null,"bit-test","bit-test",543456753,null),new cljs.core.Symbol(null,"defmethod","defmethod",-579171823,null),new cljs.core.Symbol(null,"time","time",-1268547887,null),new cljs.core.Symbol(null,"zero?","zero?",325758897,null),new cljs.core.Symbol(null,"require","require",1172530194,null),new cljs.core.Symbol(null,"unchecked-dec-int","unchecked-dec-int",1339067442,null),new cljs.core.Symbol(null,"memfn","memfn",-881453486,null),new cljs.core.Symbol(null,"js-obj","js-obj",342383250,null),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"extend-protocol","extend-protocol",306378578,null),new cljs.core.Symbol(null,"cond->","cond->",561741875,null),new cljs.core.Symbol(null,"dotimes","dotimes",-818708397,null),new cljs.core.Symbol(null,"bit-and","bit-and",-479352589,null),new cljs.core.Symbol(null,"reify","reify",1885539699,null),new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol(null,"load-file*","load-file*",-203331981,null),new cljs.core.Symbol(null,"defonce","defonce",-1681484013,null),new cljs.core.Symbol(null,"unchecked-add","unchecked-add",-2030665965,null),new cljs.core.Symbol(null,"rfn","rfn",649648083,null),new cljs.core.Symbol(null,"identical?","identical?",-745864205,null),new cljs.core.Symbol(null,"unchecked-divide-int","unchecked-divide-int",1613116468,null),new cljs.core.Symbol(null,"defn-","defn-",1097765044,null),new cljs.core.Symbol(null,"defprotocol","defprotocol",1388695348,null),new cljs.core.Symbol(null,"unchecked-subtract","unchecked-subtract",-2137458667,null),new cljs.core.Symbol(null,"assert","assert",677428501,null),new cljs.core.Symbol(null,"true?","true?",-1600332395,null),new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"letfn","letfn",-480490827,null),new cljs.core.Symbol(null,"/","/",-1371932971,null),new cljs.core.Symbol(null,"bitpos","bitpos",1020040021,null),new cljs.core.Symbol(null,"bit-or","bit-or",-1144943723,null),new cljs.core.Symbol(null,"vector","vector",-751469611,null),new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"loop","loop",1244978678,null),new cljs.core.Symbol(null,"bit-flip","bit-flip",809639606,null),new cljs.core.Symbol(null,"js-mod","js-mod",-143822890,null),new cljs.core.Symbol(null,"with-out-str","with-out-str",-140201577,null),new cljs.core.Symbol(null,"condp","condp",1054325175,null),new cljs.core.Symbol(null,"cond","cond",1606708055,null),new cljs.core.Symbol(null,"some->","some->",-1011172200,null),new cljs.core.Symbol(null,"ns-interns","ns-interns",535532824,null),new cljs.core.Symbol(null,"for","for",316745208,null),new cljs.core.Symbol(null,"binding","binding",-2114503176,null),new cljs.core.Symbol(null,"array-map","array-map",1555038968,null),new cljs.core.Symbol(null,"unchecked-byte","unchecked-byte",1091664664,null),new cljs.core.Symbol(null,"ns-imports","ns-imports",1111168888,null),new cljs.core.Symbol(null,"defmacro","defmacro",2054157304,null),new cljs.core.Symbol(null,"unchecked-short","unchecked-short",27848057,null),new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"with-redefs","with-redefs",-1143728263,null),new cljs.core.Symbol(null,"bit-clear","bit-clear",-1194520583,null),new cljs.core.Symbol(null,"locking","locking",1542862874,null),new cljs.core.Symbol(null,"list","list",-1889078086,null),new cljs.core.Symbol(null,"+","+",-740910886,null),new cljs.core.Symbol(null,"aset","aset",900773178,null),new cljs.core.Symbol(null,"defmulti","defmulti",1936112154,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"coercive-=","coercive-=",-531587302,null),new cljs.core.Symbol(null,"hash-map","hash-map",-439030950,null),new cljs.core.Symbol(null,"gen-apply-to-simple","gen-apply-to-simple",-1022796870,null),new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.Symbol(null,"false?","false?",-1522377573,null),new cljs.core.Symbol(null,"case","case",-1510733573,null),new cljs.core.Symbol(null,"exists?","exists?",-1239962053,null),new cljs.core.Symbol(null,"bit-not","bit-not",1508529851,null),new cljs.core.Symbol(null,"byte","byte",-1970660549,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"==","==",-234118149,null),new cljs.core.Symbol(null,"lazy-cat","lazy-cat",-89906116,null),new cljs.core.Symbol(null,"comment","comment",-2122229700,null),new cljs.core.Symbol(null,"copy-arguments","copy-arguments",-1087334820,null),new cljs.core.Symbol(null,"when-assert","when-assert",-1377495396,null),new cljs.core.Symbol(null,"unsafe-cast","unsafe-cast",-1683245380,null),new cljs.core.Symbol(null,"resolve","resolve",56086045,null),new cljs.core.Symbol(null,"defrecord","defrecord",273038109,null),new cljs.core.Symbol(null,"make-array","make-array",-1135103906,null),new cljs.core.Symbol(null,"unchecked-negate-int","unchecked-negate-int",-825297602,null),new cljs.core.Symbol(null,"unchecked-inc","unchecked-inc",-1170131490,null),new cljs.core.Symbol(null,"and","and",668631710,null),new cljs.core.Symbol(null,"number?","number?",-1747282210,null),new cljs.core.Symbol(null,"js-comment","js-comment",942332991,null),new cljs.core.Symbol(null,"symbol?","symbol?",1820680511,null),new cljs.core.Symbol(null,"when-some","when-some",1700415903,null),new cljs.core.Symbol(null,"unchecked-char","unchecked-char",1662742943,null),new cljs.core.Symbol(null,"require-macros","require-macros",-1946488353,null),new cljs.core.Symbol(null,"->>","->>",-1874332161,null),new cljs.core.Symbol(null,"js-inline-comment","js-inline-comment",-1290439105,null),new cljs.core.Symbol(null,"refer-clojure","refer-clojure",-1840651329,null)],[new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1169,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unsafe-bit-and","cljs.core/unsafe-bit-and",2116762989,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"quoted","quoted",-537090817,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Repeatedly calls macroexpand-1 on form until it no longer\n  represents a macro form, then returns it.  Note neither\n  macroexpand-1 nor macroexpand expand macros in subforms.",new cljs.core.Keyword(null,"line","line",212345235),2965,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","macroexpand","cljs.core/macroexpand",1715305549,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1076,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-remainder-int","cljs.core/unchecked-remainder-int",-1923905875,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"bindings","bindings",-1383038577,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"bindings => x xs\n\n  Roughly the same as (when (seq xs) (let [x (first xs)] body)) but xs is evaluated only once",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),4566,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","when-first","cljs.core/when-first",-667185267,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"expr","expr",-1908713478,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"clauses","clauses",-1199594528,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an expression and a set of test/form pairs. Threads expr (via ->>)\n  through each form for which the corresponding test expression\n  is true.  Note that, unlike cond branching, cond->> threading does not short circuit\n  after the first true test expression.",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),7475,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","cond->>","cljs.core/cond->>",738809549,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1209,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","bit-set","cljs.core/bit-set",-512404180,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"vars","vars",-406425690,null)], null)], null)),new cljs.core.Keyword(null,"line","line",212345235),64,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","import-macros","cljs.core/import-macros",-1399971066,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Repeatedly executes body while test expression is true. Presumes\n  some side-effect will cause test to become false/nil. Returns nil",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),6253,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","while","cljs.core/while",1131484550,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"psym","psym",752521989,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if x satisfies the protocol",new cljs.core.Keyword(null,"line","line",212345235),2082,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","satisfies?","cljs.core/satisfies?",-1074798682,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"xs","xs",-2004992428,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1082,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-subtract-int","cljs.core/unchecked-subtract-int",-695292980,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"quoted-ns","quoted-ns",-2054280928,null),new cljs.core.Symbol(null,"quoted-sym","quoted-sym",474507191,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Removes the mappings for the symbol from the namespace.",new cljs.core.Keyword(null,"line","line",212345235),2827,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","ns-unmap","cljs.core/ns-unmap",-1559056406,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"import-symbols-or-lists","import-symbols-or-lists",-2088338377,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"import-list => (closure-namespace constructor-name-symbols*)\n\n  For each name in constructor-name-symbols, adds a mapping from name to the\n  constructor named by closure-namespace to the current namespace. Use :import in the ns\n  macro in preference to calling this directly.",new cljs.core.Keyword(null,"line","line",212345235),2928,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","import","cljs.core/import",-165988913,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1200,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","bit-shift-right","cljs.core/bit-shift-right",1827903237,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"idxs","idxs",-2145941206,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),985,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","aget","cljs.core/aget",6345791,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"expr","expr",-1908713478,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"impls","impls",326516674,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Identical to specify! but does not mutate its first argument. The first\n  argument must be an ICloneable instance.",new cljs.core.Keyword(null,"line","line",212345235),1355,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","specify","cljs.core/specify",1070972072,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vol","vol",1137570949,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Non-atomically swaps the value of the volatile as if:\n   (apply f current-value-of-vol args). Returns the value that\n   was swapped in.",new cljs.core.Keyword(null,"line","line",212345235),2839,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","vswap!","cljs.core/vswap!",-2062892188,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"hash-fn","hash-fn",-2120171249,null),new cljs.core.Symbol(null,"hash-key","hash-key",1649875379,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1221,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","caching-hash","cljs.core/caching-hash",-1804846488,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1197,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","bit-shift-left","cljs.core/bit-shift-left",-342508802,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),882,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","coercive-not","cljs.core/coercive-not",303282494,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1131,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","dec","cljs.core/dec",-443230268,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"INTERNAL. Compiles to JavaScript property access using bracket notation. Does\n  not distinguish between object and array types and not subject to compiler\n  static analysis.",new cljs.core.Keyword(null,"line","line",212345235),1012,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-get","cljs.core/unchecked-get",-1271763170,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"quoted-ns","quoted-ns",-2054280928,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a map of the public intern mappings for the namespace.",new cljs.core.Keyword(null,"line","line",212345235),2783,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","ns-publics","cljs.core/ns-publics",488240955,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1106,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","<","cljs.core/<",1677496129,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Defines a scope where JavaScript's implicit \"this\" is bound to the name provided.",new cljs.core.Keyword(null,"line","line",212345235),1365,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","this-as","cljs.core/this-as",623378171,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"form","form",16469056,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"form","form",16469056,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"form => fieldName-symbol or (instanceMethodName-symbol args*)\n\n  Expands into a member access (.) of the first member on the first\n  argument, followed by the next member on the result, etc. For\n  instance:\n\n  (.. System (getProperties) (get \"os.name\"))\n\n  expands to:\n\n  (. (. System (getProperties)) (get \"os.name\"))\n\n  but is easier to write, read, and understand.",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),1651,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","..","cljs.core/..",-1211008191,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes a body of expressions and yields a Delay object that will\n  invoke the body only the first time it is forced (with force or deref/@), and\n  will cache the result and return it on all subsequent force\n  calls.",new cljs.core.Keyword(null,"line","line",212345235),2120,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","delay","cljs.core/delay",-406049125,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),879,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","some?","cljs.core/some?",-440439360,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1070,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-negate","cljs.core/unchecked-negate",-1262131040,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"bindings","bindings",-1383038577,null),new cljs.core.Symbol(null,"expr","expr",-1908713478,null),new cljs.core.Symbol(null,"iterations","iterations",237820637,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"print-fn","print-fn",-80428962,null)], null),new cljs.core.Keyword(null,"or","or",235744169),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"print-fn","print-fn",-80428962,null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"println","println",-733595439,null))], null)], null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Runs expr iterations times in the context of a let expression with\n  the given bindings, then prints out the bindings and the expr\n  followed by number of iterations and total time. The optional\n  argument print-fn, defaulting to println, sets function used to\n  print the result. expr's string representation will be produced\n  using pr-str in any case.",new cljs.core.Keyword(null,"line","line",212345235),2685,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","simple-benchmark","cljs.core/simple-benchmark",2063709536,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1061,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-inc-int","cljs.core/unchecked-inc-int",-2007014592,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"INTERNAL. Compiles to JavaScript property access using bracket notation. Does\n  not distinguish between object and array types and not subject to compiler\n  static analysis.",new cljs.core.Keyword(null,"line","line",212345235),1019,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-set","cljs.core/unchecked-set",763360576,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),2774,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","js-str","cljs.core/js-str",-228548960,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1203,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","bit-shift-right-zero-fill","cljs.core/bit-shift-right-zero-fill",-1177982976,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"psym","psym",752521989,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"EXPERIMENTAL",new cljs.core.Keyword(null,"line","line",212345235),2056,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","implements?","cljs.core/implements?",-251485149,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"sym","sym",195671222,null),new cljs.core.Symbol(null,"default","default",-347290801,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Defines a var using `goog.define`. Passed default value must be\n  string, number or boolean.\n\n  Default value can be overridden at compile time using the\n  compiler option `:closure-defines`.\n\n  Example:\n    (ns your-app.core)\n    (goog-define DEBUG! false)\n    ;; can be overridden with\n    :closure-defines {\"your_app.core.DEBUG_BANG_\" true}\n    or\n    :closure-defines {'your-app.core/DEBUG! true}",new cljs.core.Keyword(null,"line","line",212345235),729,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","goog-define","cljs.core/goog-define",143539075,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1140,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","pos?","cljs.core/pos?",-652182749,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"expr","expr",-1908713478,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"impls","impls",326516674,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Identical to reify but mutates its first argument.",new cljs.core.Keyword(null,"line","line",212345235),1347,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","specify!","cljs.core/specify!",-585401629,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"then","then",2101129597,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"then","then",2101129597,null),new cljs.core.Symbol(null,"else","else",132154381,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Evaluates test. If logical false, evaluates and returns then expr, \n  otherwise else expr, if supplied, else nil.",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),759,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","if-not","cljs.core/if-not",-1997686824,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),2567,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","alength","cljs.core/alength",-1012804190,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1180,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","bit-xor","cljs.core/bit-xor",1480189292,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"seq-exprs","seq-exprs",-637209651,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Repeatedly executes body (presumably for side-effects) with\n  bindings and filtering as provided by \"for\".  Does not retain\n  the head of the sequence. Returns nil.",new cljs.core.Keyword(null,"line","line",212345235),2401,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","doseq","cljs.core/doseq",-169320766,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1206,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unsigned-bit-shift-right","cljs.core/unsigned-bit-shift-right",-1545024020,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1143,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","neg?","cljs.core/neg?",2002812728,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1040,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-float","cljs.core/unchecked-float",550172037,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return true if argument is identical to the JavaScript undefined value.",new cljs.core.Keyword(null,"line","line",212345235),959,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","undefined?","cljs.core/undefined?",-1206515693,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"impls","impls",326516674,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"(deftype name [fields*]  options* specs*)\n\n  Currently there are no options.\n\n  Each spec consists of a protocol or interface name followed by zero\n  or more method bodies:\n\n  protocol-or-Object\n  (methodName [args*] body)*\n\n  The type will have the (by default, immutable) fields named by\n  fields, which can have type hints. Protocols and methods\n  are optional. The only methods that can be supplied are those\n  declared in the protocols/interfaces.  Note that method bodies are\n  not closures, the local environment includes only the named fields,\n  and those fields can be accessed directly. Fields can be qualified\n  with the metadata :mutable true at which point (set! afield aval) will be\n  supported in method bodies. Note well that mutable fields are extremely\n  difficult to use correctly, and are present only to facilitate the building\n  of higherlevel constructs, such as ClojureScript's reference types, in\n  ClojureScript itself. They are for experts only - if the semantics and\n  implications of :mutable are not immediately apparent to you, you should not\n  be using them.\n\n  Method definitions take the form:\n\n  (methodname [args*] body)\n\n  The argument and return types can be hinted on the arg and\n  methodname symbols. If not supplied, they will be inferred, so type\n  hints should be reserved for disambiguation.\n\n  Methods should be supplied for all methods of the desired\n  protocol(s). You can also define overrides for methods of Object. Note that\n  a parameter must be supplied to correspond to the target object\n  ('this' in JavaScript parlance). Note also that recur calls to the method\n  head should *not* pass the target object, it will be supplied\n  automatically and can not be substituted.\n\n  In the method bodies, the (unqualified) name can be used to name the\n  class (for calls to new, instance? etc).\n\n  One constructor will be defined, taking the designated fields.  Note\n  that the field names __meta and __extmap are currently reserved and\n  should not be used when defining your own types.\n\n  Given (deftype TypeName ...), a factory function called ->TypeName\n  will be defined, taking positional parameters for the fields",new cljs.core.Keyword(null,"line","line",212345235),1691,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","deftype","cljs.core/deftype",-1630339979,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"hash","hash",1626749931,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1213,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","mask","cljs.core/mask",1721570575,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"bindings","bindings",-1383038577,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"bindings => binding-form test\n\n  When test is true, evaluates body with binding-form bound to the value of test",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),1853,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","when-let","cljs.core/when-let",-2049838349,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1101,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","divide","cljs.core/divide",-1212490827,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),891,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","coercive-boolean","cljs.core/coercive-boolean",-386297147,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1111,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","<=","cljs.core/<=",1677001748,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"bindings","bindings",-1383038577,null),new cljs.core.Symbol(null,"then","then",2101129597,null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"bindings","bindings",-1383038577,null),new cljs.core.Symbol(null,"then","then",2101129597,null),new cljs.core.Symbol(null,"else","else",132154381,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"oldform","oldform",1995222417,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"bindings => binding-form test\n\n   If test is not nil, evaluates then with binding-form bound to the\n   value of test, if not, yields else",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),1868,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","if-some","cljs.core/if-some",790328718,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1090,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","*","cljs.core/*",-857794892,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1152,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","min","cljs.core/min",1166879476,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes a body of expressions that returns an ISeq or nil, and yields\n  a ISeqable object that will invoke the body only the first time seq\n  is called, and will cache the result and return it on all subsequent\n  seq calls.",new cljs.core.Keyword(null,"line","line",212345235),2112,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","lazy-seq","cljs.core/lazy-seq",627681297,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),903,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","js-delete","cljs.core/js-delete",-496744137,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),896,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","truth_","cljs.core/truth_",-183371689,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"macro","macro",-867863404)],[true,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"doc","doc",-741138878,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"args","args",-1338879193,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null)),"Builds another arity of the fn that returns a fn awaiting the last\n  param",1239,1,"cljs/core.cljc",new cljs.core.Symbol("cljs.core","defcurried","cljs.core/defcurried",2129634477,null),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),true]),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY),new cljs.core.Keyword(null,"doc","doc",1913296891),"Emit JavaScript \"debugger;\" statement",new cljs.core.Keyword(null,"line","line",212345235),909,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","js-debugger","cljs.core/js-debugger",1222190119,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"bindings","bindings",-1383038577,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"binding => binding-form init-expr\n\n  Evaluates the exprs in a lexical context in which the symbols in\n  the binding-forms are bound to their respective init-exprs or parts\n  therein.",new cljs.core.Keyword(null,"line","line",212345235),759,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"forms","forms",-608443419,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Threads the expr through the forms. Inserts x as the\n  second item in the first form, making a list of it if it is not a\n  list already. If there are more forms, inserts the first form as the\n  second item in second form, etc.",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),1669,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),885,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","coercive-not=","cljs.core/coercive-not=",1100243703,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"forms","forms",-608443419,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Evaluates x then calls all of the methods and functions with the\n  value of x supplied at the front of the given arguments.  The forms\n  are evaluated in order.  Returns x.\n\n  (doto (new java.util.HashMap) (.put \"a\" 1) (.put \"b\" 2))",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),3818,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","doto","cljs.core/doto",-1284816239,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null),new cljs.core.Symbol(null,"ret","ret",1172308713,null),new cljs.core.Symbol(null,"init","init",-234949907,null),new cljs.core.Symbol(null,"expr","expr",-1908713478,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Reduces an expression across an array a, using an index named idx,\n  and return value named ret, initialized to init, setting ret to the\n  evaluation of expr at each step, returning ret.",new cljs.core.Keyword(null,"line","line",212345235),2588,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","areduce","cljs.core/areduce",-1206546281,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1035,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","double","cljs.core/double",-1119390159,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1184,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","bit-and-not","cljs.core/bit-and-not",-929778682,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"xs","xs",-2004992428,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1046,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-add-int","cljs.core/unchecked-add-int",-1532265040,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"sigs","sigs",-12588095,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"params => positional-params* , or positional-params* & next-param\n  positional-param => binding-form\n  next-param => binding-form\n  name => symbol\n\n  Defines a function",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),4479,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1033,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","short","cljs.core/short",-1126139994,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY),new cljs.core.Keyword(null,"line","line",212345235),1362,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","js-this","cljs.core/js-this",29003817,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1041,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-double","cljs.core/unchecked-double",2034337059,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),947,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY),new cljs.core.Keyword(null,"line","line",212345235),900,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","js-arguments","cljs.core/js-arguments",464029257,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"xs","xs",-2004992428,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1067,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-multiply-int","cljs.core/unchecked-multiply-int",-12705513,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"expr","expr",-1908713478,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"forms","forms",-608443419,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Binds name to expr, evaluates the first form in the lexical context\n  of that binding, then binds name to that result, repeating for each\n  successive form, returning the result of the last form.",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),7492,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","as->","cljs.core/as->",1829234505,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Evaluates test. If logical false, evaluates body in an implicit do.",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),499,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","when-not","cljs.core/when-not",-556141047,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Evaluates test. If logical true, evaluates body in an implicit do.",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),493,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","when","cljs.core/when",120293186,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1177,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","int","cljs.core/int",20935062,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1116,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core",">","cljs.core/>",2020535938,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),982,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Similar to use but only for macros.",new cljs.core.Keyword(null,"line","line",212345235),2923,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","use-macros","cljs.core/use-macros",51182571,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"xs","xs",-2004992428,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1064,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-multiply","cljs.core/unchecked-multiply",-1425837163,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY),new cljs.core.Keyword(null,"line","line",212345235),2716,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","gen-apply-to","cljs.core/gen-apply-to",-1986377835,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"expr","expr",-1908713478,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"forms","forms",-608443419,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"When expr is not nil, threads it into the first form (via ->>),\n  and when that result is not nil, through the next etc",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),7518,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","some->>","cljs.core/some->>",-244881963,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1049,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-dec","cljs.core/unchecked-dec",1420123595,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Same as (def name (core/fn [params* ] exprs*)) or (def\n    name (core/fn ([params* ] exprs*)+)) with any doc-string or attrs added\n    to the var metadata. prepost-map defines a map with optional keys\n    :pre and :post that contain collections of pre or post conditions.",new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"doc-string?","doc-string?",393166599,null),new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"params*","params*",336153603,null)], null),new cljs.core.Symbol(null,"prepost-map?","prepost-map?",869562481,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"doc-string?","doc-string?",393166599,null),new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"params*","params*",336153603,null)], null),new cljs.core.Symbol(null,"prepost-map?","prepost-map?",869562481,null),new cljs.core.Symbol(null,"body","body",-408674142,null)),new cljs.core.Symbol(null,"+","+",-740910886,null),new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),3133,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","defn","cljs.core/defn",-1606493717,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1034,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","float","cljs.core/float",-1027278358,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),906,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","js-in","cljs.core/js-in",-1970636406,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ty","ty",1798822352,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),2777,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","es6-iterable","cljs.core/es6-iterable",-1794314742,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null),new cljs.core.Symbol(null,"ret","ret",1172308713,null),new cljs.core.Symbol(null,"expr","expr",-1908713478,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Maps an expression across an array a, using an index named idx, and\n  return value named ret, initialized to a clone of a, then setting\n  each element of ret to the evaluation of expr, returning the new\n  array ret.",new cljs.core.Keyword(null,"line","line",212345235),2572,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","amap","cljs.core/amap",220647316,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Like require, but referring vars specified by the mandatory\n  :only option.\n\n  Example:\n\n  The following would load the library clojure.set while referring\n  the intersection var.\n\n  (use '[clojure.set :only [intersection]])",new cljs.core.Keyword(null,"line","line",212345235),2910,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","use","cljs.core/use",-881108598,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"names","names",-302543131,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"defs the supplied var names with no bindings, useful for making forward declarations.",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),2768,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","declare","cljs.core/declare",1312638100,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1085,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","-","cljs.core/-",187040141,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"xs","xs",-2004992428,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),2524,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","hash-set","cljs.core/hash-set",1130426749,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"next","next",1522830042,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Evaluates exprs one at a time, from left to right. If a form\n  returns a logical true value, or returns that value and doesn't\n  evaluate any of the other expressions, otherwise it returns the\n  value of the last expression. (or) returns nil.",new cljs.core.Keyword(null,"line","line",212345235),858,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","or","cljs.core/or",1201033885,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"type-sym","type-sym",-1942856509,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"impls","impls",326516674,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Extend a type to a series of protocols. Useful when you are\n  supplying the definitions explicitly inline. Propagates the\n  type as a type hint on the first argument of all fns.\n\n  type-sym may be\n\n   * default, meaning the definitions will apply for any value,\n     unless an extend-type exists for one of the more specific\n     cases below.\n   * nil, meaning the definitions will apply for the nil value.\n   * any of object, boolean, number, string, array, or function,\n     indicating the definitions will apply for values of the\n     associated base JavaScript types. Note that, for example,\n     string should be used instead of js/String.\n   * a JavaScript type not covered by the previous list, such\n     as js/RegExp.\n   * a type defined by deftype or defrecord.\n\n  (extend-type MyType\n    ICounted\n    (-count [c] ...)\n    Foo\n    (bar [x y] ...)\n    (baz ([x] ...) ([x y] ...) ...)",new cljs.core.Keyword(null,"line","line",212345235),1583,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","extend-type","cljs.core/extend-type",2058791100,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"quoted","quoted",-537090817,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"If form represents a macro form, returns its expansion,\n  else returns form.",new cljs.core.Keyword(null,"line","line",212345235),2954,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","macroexpand-1","cljs.core/macroexpand-1",1326097868,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1194,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","bit-test","cljs.core/bit-test",1218697292,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"multifn","multifn",-1904313150,null),new cljs.core.Symbol(null,"dispatch-val","dispatch-val",69061000,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"fn-tail","fn-tail",-178337841,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and installs a new method of multimethod associated with dispatch-value. ",new cljs.core.Keyword(null,"line","line",212345235),2670,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","defmethod","cljs.core/defmethod",-180785162,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"expr","expr",-1908713478,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Evaluates expr and prints the time it took. Returns the value of expr.",new cljs.core.Keyword(null,"line","line",212345235),2675,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","time","cljs.core/time",-333131220,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1137,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","zero?","cljs.core/zero?",-341242858,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Loads libs, skipping any that are already loaded. Each argument is\n  either a libspec that identifies a lib or a flag that modifies how all the identified\n  libs are loaded. Use :require in the ns macro in preference to calling this\n  directly.\n\n  Libs\n\n  A 'lib' is a named set of resources in classpath whose contents define a\n  library of ClojureScript code. Lib names are symbols and each lib is associated\n  with a ClojureScript namespace. A lib's name also locates its root directory\n  within classpath using Java's package name to classpath-relative path mapping.\n  All resources in a lib should be contained in the directory structure under its\n  root directory. All definitions a lib makes should be in its associated namespace.\n\n  'require loads a lib by loading its root resource. The root resource path\n  is derived from the lib name in the following manner:\n  Consider a lib named by the symbol 'x.y.z; it has the root directory\n  <classpath>/x/y/, and its root resource is <classpath>/x/y/z.clj. The root\n  resource should contain code to create the lib's namespace (usually by using\n  the ns macro) and load any additional lib resources.\n\n  Libspecs\n\n  A libspec is a lib name or a vector containing a lib name followed by\n  options expressed as sequential keywords and arguments.\n\n  Recognized options:\n  :as takes a symbol as its argument and makes that symbol an alias to the\n    lib's namespace in the current namespace.\n  :refer takes a list of symbols to refer from the namespace.\n  :refer-macros takes a list of macro symbols to refer from the namespace.\n  :include-macros true causes macros from the namespace to be required.\n  :rename specifies a map from referred var names to different\n    symbols (and can be used to prevent clashes)\n\n\n  Flags\n\n  A flag is a keyword.\n  Recognized flags: :reload, :reload-all, :verbose\n  :reload forces loading of all the identified libs even if they are\n    already loaded\n  :reload-all implies :reload and also forces loading of all libs that the\n    identified libs directly or indirectly load via require or use\n  :verbose triggers printing information about each load, alias, and refer\n\n  Example:\n\n  The following would load the library clojure.string :as string.\n\n  (require '[clojure.string :as string])",new cljs.core.Keyword(null,"line","line",212345235),2850,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","require","cljs.core/require",2107770869,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1052,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-dec-int","cljs.core/unchecked-dec-int",-1215045409,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Expands into code that creates a fn that expects to be passed an\n  object and any args and calls the named instance method on the\n  object passing the args. Use when you want to treat a JavaScript\n  method as a first-class fn.",new cljs.core.Keyword(null,"line","line",212345235),380,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","memfn","cljs.core/memfn",-222856199,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"rest","rest",398835108,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),2547,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","js-obj","cljs.core/js-obj",1009370607,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),876,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"specs","specs",-1227865028,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Useful when you want to provide several implementations of the same\n  protocol all at once. Takes a single protocol and the implementation\n  of that protocol for one or more types. Expands into calls to\n  extend-type:\n\n  (extend-protocol Protocol\n    AType\n      (foo [x] ...)\n      (bar [x y] ...)\n    BType\n      (foo [x] ...)\n      (bar [x y] ...)\n    AClass\n      (foo [x] ...)\n      (bar [x y] ...)\n    nil\n      (foo [x] ...)\n      (bar [x y] ...))\n\n  expands into:\n\n  (do\n   (clojure.core/extend-type AType Protocol \n     (foo [x] ...) \n     (bar [x y] ...))\n   (clojure.core/extend-type BType Protocol \n     (foo [x] ...) \n     (bar [x y] ...))\n   (clojure.core/extend-type AClass Protocol \n     (foo [x] ...) \n     (bar [x y] ...))\n   (clojure.core/extend-type nil Protocol \n     (foo [x] ...) \n     (bar [x y] ...)))",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core_deftype.clj",new cljs.core.Keyword(null,"line","line",212345235),846,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","extend-protocol","cljs.core/extend-protocol",-100428625,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"expr","expr",-1908713478,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"clauses","clauses",-1199594528,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an expression and a set of test/form pairs. Threads expr (via ->)\n  through each form for which the corresponding test\n  expression is true. Note that, unlike cond branching, cond-> threading does\n  not short circuit after the first true test expression.",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),7458,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","cond->","cljs.core/cond->",-113941356,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"bindings","bindings",-1383038577,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"bindings => name n\n\n  Repeatedly executes body (presumably for side-effects) with name\n  bound to integers from 0 through n-1.",new cljs.core.Keyword(null,"line","line",212345235),2600,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","dotimes","cljs.core/dotimes",-1326291458,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1164,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","bit-and","cljs.core/bit-and",-617818210,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"impls","impls",326516674,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"reify is a macro with the following structure:\n\n (reify options* specs*)\n\n  Currently there are no options.\n\n  Each spec consists of the protocol name followed by zero\n  or more method bodies:\n\n  protocol\n  (methodName [args+] body)*\n\n  Methods should be supplied for all methods of the desired\n  protocol(s). You can also define overrides for Object methods. Note that\n  the first parameter must be supplied to correspond to the target object\n  ('this' in JavaScript parlance). Note also that recur calls\n  to the method head should *not* pass the target object, it will be supplied\n  automatically and can not be substituted.\n\n  recur works to method heads The method bodies of reify are lexical\n  closures, and can refer to the surrounding local scope:\n\n  (str (let [f \"foo\"]\n       (reify Object\n         (toString [this] f))))\n  == \"foo\"\n\n  (seq (let [f \"foo\"]\n       (reify ISeqable\n         (-seq [this] (seq f)))))\n  == (\"f\" \"o\" \"o\"))\n\n  reify always implements IMeta and IWithMeta and transfers meta\n  data of the form to the created object.\n\n  (meta ^{:k :v} (reify Object (toString [this] \"foo\")))\n  == {:k :v}",new cljs.core.Keyword(null,"line","line",212345235),1287,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","reify","cljs.core/reify",463577556,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"c","c",-122660552,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),967,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","instance?","cljs.core/instance?",2044751870,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),2951,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","load-file*","cljs.core/load-file*",-1423926504,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"init","init",-234949907,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"defs name to have the root value of init iff the named var has no root value,\n  else init is unevaluated",new cljs.core.Keyword(null,"line","line",212345235),619,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","defonce","cljs.core/defonce",-1291833100,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"xs","xs",-2004992428,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1043,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-add","cljs.core/unchecked-add",1865931960,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"macro","macro",-867863404)],[true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f1","f1",-939903380,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null),new cljs.core.Symbol(null,"fkv","fkv",-1678363055,null)], null)),"Builds 3-arity reducing fn given names of wrapped fn and key, and k/v impl.",1256,1,"cljs/core.cljc",new cljs.core.Symbol("cljs.core","rfn","cljs.core/rfn",528200568,null),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),true]),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"b","b",-1172211299,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),964,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","identical?","cljs.core/identical?",608476750,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"xs","xs",-2004992428,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1055,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-divide-int","cljs.core/unchecked-divide-int",1483182239,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"decls","decls",-1311111277,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"same as defn, yielding non-public def",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),4865,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","defn-","cljs.core/defn-",1764521227,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"psym","psym",752521989,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"doc+methods","doc+methods",2036080922,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"A protocol is a named set of named methods and their signatures:\n\n  (defprotocol AProtocolName\n    ;optional doc string\n    \"A doc string for AProtocol abstraction\"\n\n  ;method signatures\n    (bar [this a b] \"bar docs\")\n    (baz [this a] [this a b] [this a b c] \"baz docs\"))\n\n  No implementations are provided. Docs can be specified for the\n  protocol overall and for each method. The above yields a set of\n  polymorphic functions and a protocol object. All are\n  namespace-qualified by the ns enclosing the definition The resulting\n  functions dispatch on the type of their first argument, which is\n  required and corresponds to the implicit target object ('this' in\n  JavaScript parlance). defprotocol is dynamic, has no special compile-time\n  effect, and defines no new types.\n\n  (defprotocol P\n    (foo [this])\n    (bar-me [this] [this y]))\n\n  (deftype Foo [a b c]\n    P\n    (foo [this] a)\n    (bar-me [this] b)\n    (bar-me [this y] (+ c y)))\n\n  (bar-me (Foo. 1 2 3) 42)\n  => 45\n\n  (foo\n    (let [x 42]\n      (reify P\n        (foo [this] 17)\n        (bar-me [this] x)\n        (bar-me [this y] x))))\n  => 17",new cljs.core.Keyword(null,"line","line",212345235),1937,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","defprotocol","cljs.core/defprotocol",1787210635,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"xs","xs",-2004992428,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1079,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-subtract","cljs.core/unchecked-subtract",1482268158,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"message","message",1234475525,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Evaluates expr and throws an exception if it does not evaluate to\n  logical true.",new cljs.core.Keyword(null,"line","line",212345235),2301,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","assert","cljs.core/assert",1075777968,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),941,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","true?","cljs.core/true?",-77973136,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"rest","rest",398835108,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),2457,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","array","cljs.core/array",486685886,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"fnspecs","fnspecs",-958581686,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"fnspec ==> (fname [params*] exprs) or (fname ([params*] exprs)+)\n\n  Takes a vector of function specs and a body, and generates a set of\n  bindings of functions to their names. All of the names are available\n  in all of the definitions of the functions, as well as the body.",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),6463,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","letfn","cljs.core/letfn",-874326064,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1096,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","/","cljs.core//",-696756880,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"hash","hash",1626749931,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1217,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","bitpos","cljs.core/bitpos",1687041598,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1173,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","bit-or","cljs.core/bit-or",1134521392,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"xs","xs",-2004992428,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),2493,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","vector","cljs.core/vector",720641726,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1121,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core",">=","cljs.core/>=",350096541,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"bindings","bindings",-1383038577,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Evaluates the exprs in a lexical context in which the symbols in\n  the binding-forms are bound to their respective init-exprs or parts\n  therein. Acts as a recur target.",new cljs.core.Keyword(null,"line","line",212345235),771,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","loop","cljs.core/loop",-1829423021,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1191,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","bit-flip","cljs.core/bit-flip",1754103069,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"num","num",-669195096,null),new cljs.core.Symbol(null,"div","div",-1597244137,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1158,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","js-mod","cljs.core/js-mod",-1356070221,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Evaluates exprs in a context in which *print-fn* is bound to .append\n  on a fresh StringBuffer.  Returns the string created by any nested\n  printing calls.",new cljs.core.Keyword(null,"line","line",212345235),2754,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","with-out-str","cljs.core/with-out-str",-538618510,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"added","added",2057651688),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"macro","macro",-867863404)],[cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"expr","expr",-1908713478,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"clauses","clauses",-1199594528,null)], null)),"Takes a binary predicate, an expression, and a set of clauses.\n  Each clause can take the form of either:\n\n  test-expr result-expr\n\n  test-expr :>> result-fn\n\n  Note :>> is an ordinary keyword.\n\n  For each clause, (pred test-expr expr) is evaluated. If it returns\n  logical true, the clause is a match. If a binary clause matches, the\n  result-expr is returned, if a ternary clause matches, its result-fn,\n  which must be a unary function, is called with the result of the\n  predicate as its argument, the result of that call being the return\n  value of condp. A single default expression can follow the clauses,\n  and its value will be returned if no clause matches. If no default\n  expression is provided and no clause matches, an\n  IllegalArgumentException is thrown.","1.0",2163,1,"cljs/core.cljc",new cljs.core.Symbol("cljs.core","condp","cljs.core/condp",353371154,null),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),true]),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"clauses","clauses",-1199594528,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes a set of test/expr pairs. It evaluates each test one at a\n  time.  If a test returns logical true, cond evaluates and returns\n  the value of the corresponding expr and doesn't evaluate any of the\n  other tests or exprs. (cond) returns nil.",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),591,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","cond","cljs.core/cond",2005388338,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"expr","expr",-1908713478,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"forms","forms",-608443419,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"When expr is not nil, threads it into the first form (via ->),\n  and when that result is not nil, through the next etc",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),7504,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","some->","cljs.core/some->",-67411995,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"quoted-ns","quoted-ns",-2054280928,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a map of the intern mappings for the namespace.",new cljs.core.Keyword(null,"line","line",212345235),2813,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","ns-interns","cljs.core/ns-interns",-1003949633,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"seq-exprs","seq-exprs",-637209651,null),new cljs.core.Symbol(null,"body-expr","body-expr",-2125506601,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"List comprehension. Takes a vector of one or more\n   binding-form/collection-expr pairs, each followed by zero or more\n   modifiers, and yields a lazy sequence of evaluations of expr.\n   Collections are iterated in a nested fashion, rightmost fastest,\n   and nested coll-exprs can refer to bindings created in prior\n   binding-forms.  Supported modifiers are: :let [binding-form expr ...],\n   :while test, :when test.\n\n  (take 100 (for [x (range 100000000) y (range 1000000) :while (< y x)]  [x y]))",new cljs.core.Keyword(null,"line","line",212345235),2314,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","for","cljs.core/for",-89947499,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"bindings","bindings",-1383038577,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"binding => var-symbol init-expr\n\n  Creates new bindings for the (already-existing) vars, with the\n  supplied initial values, executes the exprs in an implicit do, then\n  re-establishes the bindings that existed before.  The new bindings\n  are made in parallel (unlike let); all init-exprs are evaluated\n  before the vars are bound to their new values.",new cljs.core.Keyword(null,"line","line",212345235),2150,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","binding","cljs.core/binding",2050379843,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),2504,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","array-map","cljs.core/array-map",-1519210683,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1037,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-byte","cljs.core/unchecked-byte",2035472319,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"quoted-ns","quoted-ns",-2054280928,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a map of the import mappings for the namespace.",new cljs.core.Keyword(null,"line","line",212345235),2799,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","ns-imports","cljs.core/ns-imports",721090581,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"doc-string?","doc-string?",393166599,null),new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"params*","params*",336153603,null)], null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"doc-string?","doc-string?",393166599,null),new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"params*","params*",336153603,null)], null),new cljs.core.Symbol(null,"body","body",-408674142,null)),new cljs.core.Symbol(null,"+","+",-740910886,null),new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Like defn, but the resulting function name is declared as a\n  macro and will be used as a macro by the compiler when it is\n  called.",new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"line","line",212345235),3208,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","defmacro","cljs.core/defmacro",-1834053857,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1039,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-short","cljs.core/unchecked-short",-160544318,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1134,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","inc","cljs.core/inc",-879172610,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"bindings","bindings",-1383038577,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"binding => var-symbol temp-value-expr\n\n  Temporarily redefines vars while executing the body.  The\n  temp-value-exprs will be evaluated and each resulting value will\n  replace in parallel the root value of its var.  After the body is\n  executed, the root values of all the vars will be set back to their\n  old values. Useful for mocking out functions during testing.",new cljs.core.Keyword(null,"line","line",212345235),2128,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","with-redefs","cljs.core/with-redefs",1134293954,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1188,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","bit-clear","cljs.core/bit-clear",-1869977534,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"forms","forms",-608443419,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),2846,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","locking","cljs.core/locking",-2088182937,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"xs","xs",-2004992428,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),2484,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","list","cljs.core/list",-1331406371,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1026,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","+","cljs.core/+",-342754435,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null),new cljs.core.Symbol(null,"val","val",1769233139,null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null),new cljs.core.Symbol(null,"idx2","idx2",195459820,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"idxv","idxv",-1163260636,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),998,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","aset","cljs.core/aset",-898215545,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"mm-name","mm-name",596697898,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"options","options",1740170016,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a new multimethod with the associated dispatch function.\n  The docstring and attribute-map are optional.\n\n  Options are key-value pairs and may be one of:\n    :default    the default dispatch value, defaults to :default\n    :hierarchy  the isa? hierarchy to use for dispatching\n                defaults to the global hierarchy",new cljs.core.Keyword(null,"line","line",212345235),2624,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","defmulti","cljs.core/defmulti",723984225,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"xs","xs",-2004992428,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),821,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","str","cljs.core/str",-1971828991,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),888,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","coercive-=","cljs.core/coercive-=",-2012120473,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),2514,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","hash-map","cljs.core/hash-map",303385767,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"num-args","num-args",-467699682,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),2750,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","gen-apply-to-simple","cljs.core/gen-apply-to-simple",-1396115881,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"bindings","bindings",-1383038577,null),new cljs.core.Symbol(null,"then","then",2101129597,null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"bindings","bindings",-1383038577,null),new cljs.core.Symbol(null,"then","then",2101129597,null),new cljs.core.Symbol(null,"else","else",132154381,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"oldform","oldform",1995222417,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"bindings => binding-form test\n\n  If test is true, evaluates then with binding-form bound to the value of \n  test, if not, yields else",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),1833,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","if-let","cljs.core/if-let",1346583165,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),944,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","false?","cljs.core/false?",-1660815306,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"e","e",-1273166571,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"clauses","clauses",-1199594528,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an expression, and a set of clauses.\n\n  Each clause can take the form of either:\n\n  test-constant result-expr\n\n  (test-constant1 ... test-constantN)  result-expr\n\n  The test-constants are not evaluated. They must be compile-time\n  literals, and need not be quoted.  If the expression is equal to a\n  test-constant, the corresponding result-expr is returned. A single\n  default expression can follow the clauses, and its value will be\n  returned if no clause matches. If no default expression is provided\n  and no clause matches, an Error is thrown.\n\n  Unlike cond and condp, case does a constant-time dispatch, the\n  clauses are not considered sequentially.  All manner of constant\n  expressions are acceptable in case, including numbers, strings,\n  symbols, keywords, and (ClojureScript) composites thereof. Note that since\n  lists are used to group multiple constants that map to the same\n  expression, a vector can be used to match a list if needed. The\n  test-constants need not be all of the same type.",new cljs.core.Keyword(null,"line","line",212345235),2227,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","case","cljs.core/case",-1674122212,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return true if argument exists, analogous to usage of typeof operator\n   in JavaScript.",new cljs.core.Keyword(null,"line","line",212345235),951,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","exists?","cljs.core/exists?",1852387968,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1161,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","bit-not","cljs.core/bit-not",-2119879204,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1032,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","byte","cljs.core/byte",1388930944,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1146,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","max","cljs.core/max",1303529718,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1126,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","==","cljs.core/==",-632471488,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"colls","colls",-397642425,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Expands to code which yields a lazy sequence of the concatenation\n  of the supplied colls.  Each coll expr is not evaluated until it is\n  needed.\n\n  (lazy-cat xs ys zs) === (concat (lazy-seq xs) (lazy-seq ys) (lazy-seq zs))",new cljs.core.Keyword(null,"line","line",212345235),2765,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","lazy-cat","cljs.core/lazy-cat",-1562015833,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Ignores body, yields nil",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),4677,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","comment","cljs.core/comment",1774254937,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"dest","dest",1605962050,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),3020,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","copy-arguments","cljs.core/copy-arguments",1735553785,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),2298,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","when-assert","cljs.core/when-assert",-1782908615,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"EXPERIMENTAL: Subject to change. Unsafely cast a value to a different type.",new cljs.core.Keyword(null,"line","line",212345235),930,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unsafe-cast","cljs.core/unsafe-cast",-1284975143,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"quoted-sym","quoted-sym",474507191,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the var to which a symbol will be resolved in the namespace else nil.",new cljs.core.Keyword(null,"line","line",212345235),3254,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","resolve","cljs.core/resolve",1796776582,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"rsym","rsym",204230332,null),new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"impls","impls",326516674,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"(defrecord name [fields*]  options* specs*)\n\n  Currently there are no options.\n\n  Each spec consists of a protocol or interface name followed by zero\n  or more method bodies:\n\n  protocol-or-Object\n  (methodName [args*] body)*\n\n  The record will have the (immutable) fields named by\n  fields, which can have type hints. Protocols and methods\n  are optional. The only methods that can be supplied are those\n  declared in the protocols.  Note that method bodies are\n  not closures, the local environment includes only the named fields,\n  and those fields can be accessed directly.\n\n  Method definitions take the form:\n\n  (methodname [args*] body)\n\n  The argument and return types can be hinted on the arg and\n  methodname symbols. If not supplied, they will be inferred, so type\n  hints should be reserved for disambiguation.\n\n  Methods should be supplied for all methods of the desired\n  protocol(s). You can also define overrides for\n  methods of Object. Note that a parameter must be supplied to\n  correspond to the target object ('this' in JavaScript parlance). Note also\n  that recur calls to the method head should *not* pass the target object, it\n  will be supplied automatically and can not be substituted.\n\n  In the method bodies, the (unqualified) name can be used to name the\n  class (for calls to new, instance? etc).\n\n  The type will have implementations of several ClojureScript\n  protocol generated automatically: IMeta/IWithMeta (metadata support) and\n  IMap, etc.\n\n  In addition, defrecord will define type-and-value-based =,\n  and will define ClojureScript IHash and IEquiv.\n\n  Two constructors will be defined, one taking the designated fields\n  followed by a metadata map (nil for none) and an extension field\n  map (nil for none), and one taking only the fields (using nil for\n  meta and extension fields). Note that the field names __meta\n  and __extmap are currently reserved and should not be used when\n  defining your own records.\n\n  Given (defrecord TypeName ...), two factory functions will be\n  defined: ->TypeName, taking positional parameters for the fields,\n  and map->TypeName, taking a map of keywords to field values.",new cljs.core.Keyword(null,"line","line",212345235),1868,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","defrecord","cljs.core/defrecord",948295858,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"size","size",-1555742762,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"type","type",-1480165421,null),new cljs.core.Symbol(null,"size","size",-1555742762,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"type","type",-1480165421,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more-sizes","more-sizes",-763736162,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),2466,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","make-array","cljs.core/make-array",-1802166799,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1073,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-negate-int","cljs.core/unchecked-negate-int",-435316571,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("cljs.analyzer","numeric","cljs.analyzer/numeric",1415704188),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1058,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-inc","cljs.core/unchecked-inc",-501313167,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"next","next",1522830042,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Evaluates exprs one at a time, from left to right. If a form\n  returns logical false (nil or false), and returns that value and\n  doesn't evaluate any of the other expressions, otherwise it returns\n  the value of the last expr. (and) returns true.",new cljs.core.Keyword(null,"line","line",212345235),840,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","and","cljs.core/and",-6692549,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),976,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"comment","comment",-2122229700,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Emit a top-level JavaScript multi-line comment. New lines will create a\n  new comment line. Comment block will be preceded and followed by a newline",new cljs.core.Keyword(null,"line","line",212345235),916,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","js-comment","cljs.core/js-comment",-672892582,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),979,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"bindings","bindings",-1383038577,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"body","body",-408674142,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"bindings => binding-form test\n\n   When test is not nil, evaluates body with binding-form bound to the\n   value of test",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),1888,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","when-some","cljs.core/when-some",1033431610,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"line","line",212345235),1038,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","unchecked-char","cljs.core/unchecked-char",1541049860,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Similar to require but only for macros.",new cljs.core.Keyword(null,"line","line",212345235),2905,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","require-macros","cljs.core/require-macros",1941527674,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"forms","forms",-608443419,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Threads the expr through the forms. Inserts x as the\n  last item in the first form, making a list of it if it is not a\n  list already. If there are more forms, inserts the first form as the\n  last item in second form, etc.",new cljs.core.Keyword(null,"file","file",-1269645878),"clojure/core.clj",new cljs.core.Keyword(null,"line","line",212345235),1685,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","->>","cljs.core/->>",-1207871206,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null)], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"comment","comment",-2122229700,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Emit an inline JavaScript comment.",new cljs.core.Keyword(null,"line","line",212345235),936,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","js-inline-comment","cljs.core/js-inline-comment",1792529242,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Refers to all the public vars of `cljs.core`, subject to\n  filters.\n  Filters can include at most one each of:\n\n  :exclude list-of-symbols\n  :rename map-of-fromsymbol-tosymbol\n\n  Filters can be used to select a subset, via exclusion, or to provide a mapping\n  to a symbol different from the var's name, in order to prevent clashes.",new cljs.core.Keyword(null,"line","line",212345235),2937,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","refer-clojure","cljs.core/refer-clojure",-913605094,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null)]),new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"StringBuffer","StringBuffer",864531538,null),new cljs.core.Symbol(null,"goog.string.StringBuffer","goog.string.StringBuffer",-1220229842,null)], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"gstring","gstring",566706563,null),new cljs.core.Symbol(null,"goog.string","goog.string",-2055533048,null),new cljs.core.Symbol(null,"goog.Uri","goog.Uri",-173187830,null),new cljs.core.Symbol(null,"garray","garray",386979466,null),new cljs.core.Symbol(null,"goog.object","goog.object",678593132,null),new cljs.core.Symbol(null,"goog.math.Integer","goog.math.Integer",1056644301,null),new cljs.core.Symbol(null,"StringBuffer","StringBuffer",864531538,null),new cljs.core.Symbol(null,"gobject","gobject",315468408,null),new cljs.core.Symbol(null,"goog.array","goog.array",-671977860,null),new cljs.core.Symbol(null,"goog.math.Long","goog.math.Long",25335006,null)],[new cljs.core.Symbol(null,"goog.string","goog.string",-2055533048,null),new cljs.core.Symbol(null,"goog.string","goog.string",-2055533048,null),new cljs.core.Symbol(null,"goog.Uri","goog.Uri",-173187830,null),new cljs.core.Symbol(null,"goog.array","goog.array",-671977860,null),new cljs.core.Symbol(null,"goog.object","goog.object",678593132,null),new cljs.core.Symbol(null,"goog.math.Integer","goog.math.Integer",1056644301,null),new cljs.core.Symbol(null,"goog.string.StringBuffer","goog.string.StringBuffer",-1220229842,null),new cljs.core.Symbol(null,"goog.object","goog.object",678593132,null),new cljs.core.Symbol(null,"goog.array","goog.array",-671977860,null),new cljs.core.Symbol(null,"goog.math.Long","goog.math.Long",25335006,null)]),null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"->PersistentHashSet","->PersistentHashSet",1541772352,null),new cljs.core.Symbol(null,"js->clj","js->clj",1544462432,null),new cljs.core.Symbol(null,"sort-by","sort-by",1317932224,null),new cljs.core.Symbol(null,"ITransientAssociative","ITransientAssociative",-1612754624,null),new cljs.core.Symbol(null,"chunk-first","chunk-first",1379046752,null),new cljs.core.Symbol(null,"print-meta?","print-meta?",-413746784,null),new cljs.core.Symbol(null,"m3-hash-int","m3-hash-int",-541236832,null),new cljs.core.Symbol(null,"pr-str*","pr-str*",-1606885952,null),new cljs.core.Symbol(null,"eduction","eduction",1445227968,null),new cljs.core.Symbol(null,"tree-seq","tree-seq",-1800921632,null),new cljs.core.Symbol(null,"unchecked-remainder-int","unchecked-remainder-int",1427188224,null),new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),new cljs.core.Symbol(null,"seq","seq",-177272256,null),new cljs.core.Symbol(null,"Volatile","Volatile",1455598144,null),new cljs.core.Symbol(null,"reduce","reduce",1358839360,null),new cljs.core.Symbol(null,"IUUID","IUUID",2021444160,null),new cljs.core.Symbol(null,"INIT","INIT",1059431008,null),new cljs.core.Symbol(null,"find-ns","find-ns",-884829568,null),new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.Symbol(null,"every?","every?",2083724064,null),new cljs.core.Symbol(null,"->ES6IteratorSeq","->ES6IteratorSeq",-1351536832,null),new cljs.core.Symbol(null,"Var","Var",-1833791616,null),new cljs.core.Symbol(null,"keep-indexed","keep-indexed",-2020916352,null),new cljs.core.Symbol(null,"->PersistentQueueSeq","->PersistentQueueSeq",2079422368,null),new cljs.core.Symbol(null,"subs","subs",1453849536,null),new cljs.core.Symbol(null,"IFind","IFind",1095321601,null),new cljs.core.Symbol(null,"set","set",1945134081,null),new cljs.core.Symbol(null,"MODULE_URIS","MODULE_URIS",-1286258655,null),new cljs.core.Symbol(null,"compare-indexed","compare-indexed",2129316897,null),new cljs.core.Symbol(null,"take-last","take-last",-41013151,null),new cljs.core.Symbol(null,"IndexedSeq","IndexedSeq",-635580319,null),new cljs.core.Symbol(null,"bit-set","bit-set",-910710655,null),new cljs.core.Symbol(null,"string-hash-cache-count","string-hash-cache-count",538807457,null),new cljs.core.Symbol(null,"qualified-keyword?","qualified-keyword?",375456001,null),new cljs.core.Symbol(null,"->Eduction","->Eduction",-188511967,null),new cljs.core.Symbol(null,"tree-map-add","tree-map-add",-246509279,null),new cljs.core.Symbol(null,"->ES6SetEntriesIterator","->ES6SetEntriesIterator",264025377,null),new cljs.core.Symbol(null,"-with-meta","-with-meta",-1610713823,null),new cljs.core.Symbol(null,"reset-cache","reset-cache",-68289215,null),new cljs.core.Symbol(null,"->PersistentArrayMapIterator","->PersistentArrayMapIterator",974019937,null),new cljs.core.Symbol(null,"PersistentArrayMapIterator","PersistentArrayMapIterator",-1513711231,null),new cljs.core.Symbol(null,"butlast","butlast",1573039585,null),new cljs.core.Symbol(null,"tail-off","tail-off",853615265,null),new cljs.core.Symbol(null,"unchecked-subtract-int","unchecked-subtract-int",-1899147615,null),new cljs.core.Symbol(null,"-iterator","-iterator",310937281,null),new cljs.core.Symbol(null,"*print-namespace-maps*","*print-namespace-maps*",-1759108415,null),new cljs.core.Symbol(null,"take-nth","take-nth",1378204353,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"native-satisfies?","native-satisfies?",1880666849,null),new cljs.core.Symbol(null,"seq?","seq?",-1951934719,null),new cljs.core.Symbol(null,"-global-hierarchy","-global-hierarchy",1334390561,null),new cljs.core.Symbol(null,"UUID","UUID",-880853215,null),new cljs.core.Symbol(null,"-sorted-seq-from","-sorted-seq-from",1178430241,null),new cljs.core.Symbol(null,"println-str","println-str",-2049216703,null),new cljs.core.Symbol(null,"inst-ms","inst-ms",-653961375,null),new cljs.core.Symbol(null,"linear-traversal-nth","linear-traversal-nth",1982705569,null),new cljs.core.Symbol(null,"iterate","iterate",694501410,null),new cljs.core.Symbol(null,"checked-aget'","checked-aget'",212330530,null),new cljs.core.Symbol(null,"-empty","-empty",347797538,null),new cljs.core.Symbol(null,"newline","newline",-864364446,null),new cljs.core.Symbol(null,"ILookup","ILookup",784647298,null),new cljs.core.Symbol(null,"-chunked-rest","-chunked-rest",-1297725246,null),new cljs.core.Symbol(null,"write-all","write-all",-528404254,null),new cljs.core.Symbol(null,"fn?","fn?",1820990818,null),new cljs.core.Symbol(null,"-prefer-method","-prefer-method",-1145514654,null),new cljs.core.Symbol(null,"-assoc","-assoc",-416089758,null),new cljs.core.Symbol(null,"doall","doall",988520834,null),new cljs.core.Symbol(null,"keyword-identical?","keyword-identical?",931555714,null),new cljs.core.Symbol(null,"*print-err-fn*","*print-err-fn*",1241679298,null),new cljs.core.Symbol(null,"pv-aset","pv-aset",-2013590078,null),new cljs.core.Symbol(null,"prefers","prefers",-374265406,null),new cljs.core.Symbol(null,"-js->clj","-js->clj",2131199458,null),new cljs.core.Symbol(null,"LazySeq","LazySeq",1579450882,null),new cljs.core.Symbol(null,"dedupe","dedupe",-461856254,null),new cljs.core.Symbol(null,"unchecked-editable-array-for","unchecked-editable-array-for",1749896770,null),new cljs.core.Symbol(null,"->ES6Iterator","->ES6Iterator",1714120258,null),new cljs.core.Symbol(null,"VectorNode","VectorNode",-1615965598,null),new cljs.core.Symbol(null,"dissoc","dissoc",1039760994,null),new cljs.core.Symbol(null,"atom","atom",1243487874,null),new cljs.core.Symbol(null,"bit-shift-right","bit-shift-right",884046498,null),new cljs.core.Symbol(null,"MapEntry","MapEntry",344542914,null),new cljs.core.Symbol(null,"*clojurescript-version*","*clojurescript-version*",-271466686,null),new cljs.core.Symbol(null,"-first","-first",-120590526,null),new cljs.core.Symbol(null,"peek","peek",1349135202,null),new cljs.core.Symbol(null,"IKVReduce","IKVReduce",-870856862,null),new cljs.core.Symbol(null,"iter-reduce","iter-reduce",-785074302,null),new cljs.core.Symbol(null,"aget","aget",1491056546,null),new cljs.core.Symbol(null,"PersistentTreeMapSeq","PersistentTreeMapSeq",928502690,null),new cljs.core.Symbol(null,"-write","-write",1999625154,null),new cljs.core.Symbol(null,"iter","iter",-1346195486,null),new cljs.core.Symbol(null,"mk-bound-fn","mk-bound-fn",-1889363965,null),new cljs.core.Symbol(null,"last","last",-1548700637,null),new cljs.core.Symbol(null,"-default-dispatch-val","-default-dispatch-val",582006819,null),new cljs.core.Symbol(null,"pr","pr",1056937027,null),new cljs.core.Symbol(null,"tree-map-seq-push","tree-map-seq-push",-1895781277,null),new cljs.core.Symbol(null,"namespace","namespace",1263021155,null),new cljs.core.Symbol(null,"empty-unordered-hash","empty-unordered-hash",-443789181,null),new cljs.core.Symbol(null,"obj-map","obj-map",-1344260957,null),new cljs.core.Symbol(null,"Reduced","Reduced",1613436099,null),new cljs.core.Symbol(null,"-conj","-conj",1373798691,null),new cljs.core.Symbol(null,"NodeSeq","NodeSeq",-1476140733,null),new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"ITransientMap","ITransientMap",298423651,null),new cljs.core.Symbol(null,"push-tail","push-tail",1551853923,null),new cljs.core.Symbol(null,"take","take",871646627,null),new cljs.core.Symbol(null,"vector?","vector?",-61367869,null),new cljs.core.Symbol(null,"array-index-of-equiv?","array-index-of-equiv?",-463954493,null),new cljs.core.Symbol(null,"bitmap-indexed-node-index","bitmap-indexed-node-index",584051139,null),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Symbol(null,"IChunk","IChunk",1024226883,null),new cljs.core.Symbol(null,"bit-shift-left","bit-shift-left",-1814765981,null),new cljs.core.Symbol(null,"random-uuid","random-uuid",-1574409597,null),new cljs.core.Symbol(null,"any?","any?",-318999933,null),new cljs.core.Symbol(null,"rand-int","rand-int",-495012157,null),new cljs.core.Symbol(null,"aclone","aclone",722978531,null),new cljs.core.Symbol(null,"BlackNode","BlackNode",-941768957,null),new cljs.core.Symbol(null,"vreset!","vreset!",1237177091,null),new cljs.core.Symbol(null,"chunk","chunk",449371907,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null),new cljs.core.Symbol(null,"->TransformerIterator","->TransformerIterator",2083203971,null),new cljs.core.Symbol(null,"APersistentVector","APersistentVector",-52305916,null),new cljs.core.Symbol(null,"map","map",-1282745308,null),new cljs.core.Symbol(null,"juxt","juxt",671085604,null),new cljs.core.Symbol(null,"->PersistentQueueIter","->PersistentQueueIter",-1175035836,null),new cljs.core.Symbol(null,"<","<",993667236,null),new cljs.core.Symbol(null,"inode-kv-reduce","inode-kv-reduce",-309251868,null),new cljs.core.Symbol(null,"obj-map->hash-map","obj-map->hash-map",32284932,null),new cljs.core.Symbol(null,"t_cljs$core8988","t_cljs$core8988",-1710731996,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"ex-data","ex-data",1331491268,null),new cljs.core.Symbol(null,"PersistentArrayMapSeq","PersistentArrayMapSeq",1381254788,null),new cljs.core.Symbol(null,"-drop-first","-drop-first",-2095262076,null),new cljs.core.Symbol(null,"isa?","isa?",1358492324,null),new cljs.core.Symbol(null,"boolean?","boolean?",1790940868,null),new cljs.core.Symbol(null,"-clone","-clone",227130084,null),new cljs.core.Symbol(null,"munge","munge",-174396700,null),new cljs.core.Symbol(null,"empty-ordered-hash","empty-ordered-hash",1309512452,null),new cljs.core.Symbol(null,"DEMUNGE_MAP","DEMUNGE_MAP",-2093159676,null),new cljs.core.Symbol(null,"ES6IteratorSeq","ES6IteratorSeq",-1632696476,null),new cljs.core.Symbol(null,"->NeverEquiv","->NeverEquiv",-1289941148,null),new cljs.core.Symbol(null,"re-seq","re-seq",-2105554076,null),new cljs.core.Symbol(null,"char?","char?",-1072221244,null),new cljs.core.Symbol(null,"make-hierarchy","make-hierarchy",-241558556,null),new cljs.core.Symbol(null,"Symbol","Symbol",716452869,null),new cljs.core.Symbol(null,"PROTOCOL_SENTINEL","PROTOCOL_SENTINEL",1421964293,null),new cljs.core.Symbol(null,"tv-push-tail","tv-push-tail",1835535397,null),new cljs.core.Symbol(null,"-reduce","-reduce",791630885,null),new cljs.core.Symbol(null,"-count","-count",416049189,null),new cljs.core.Symbol(null,"swap-vals!","swap-vals!",-1192983419,null),new cljs.core.Symbol(null,"keep","keep",-492807003,null),new cljs.core.Symbol(null,"char","char",998943941,null),new cljs.core.Symbol(null,"mapcat","mapcat",-601348859,null),new cljs.core.Symbol(null,"unchecked-long","unchecked-long",1306610949,null),new cljs.core.Symbol(null,"m3-seed","m3-seed",-887468795,null),new cljs.core.Symbol(null,"some?","some?",234752293,null),new cljs.core.Symbol(null,"unchecked-negate","unchecked-negate",-1669067451,null),new cljs.core.Symbol(null,"symbol-identical?","symbol-identical?",1707158917,null),new cljs.core.Symbol(null,"*command-line-args*","*command-line-args*",-451214875,null),new cljs.core.Symbol(null,"reverse","reverse",752076261,null),new cljs.core.Symbol(null,"inst?","inst?",1614698981,null),new cljs.core.Symbol(null,"range","range",-1014743483,null),new cljs.core.Symbol(null,"bit-count","bit-count",1400227397,null),new cljs.core.Symbol(null,"create-node","create-node",1335492197,null),new cljs.core.Symbol(null,"sort","sort",-1700969851,null),new cljs.core.Symbol(null,"->MetaFn","->MetaFn",-1885454683,null),new cljs.core.Symbol(null,"unchecked-inc-int","unchecked-inc-int",1402783397,null),new cljs.core.Symbol(null,"-compare","-compare",-1976016187,null),new cljs.core.Symbol(null,"map-indexed","map-indexed",-1391025435,null),new cljs.core.Symbol(null,"array-list","array-list",-1850729723,null),new cljs.core.Symbol(null,"rand-nth","rand-nth",-1227719931,null),new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"array-chunk","array-chunk",-1223578811,null),new cljs.core.Symbol(null,"dispatch-fn","dispatch-fn",-1401088155,null),new cljs.core.Symbol(null,"bit-shift-right-zero-fill","bit-shift-right-zero-fill",-779613275,null),new cljs.core.Symbol(null,"js-reserved?","js-reserved?",-1093153819,null),new cljs.core.Symbol(null,"-as-transient","-as-transient",1558996006,null),new cljs.core.Symbol(null,"dorun","dorun",560426022,null),new cljs.core.Symbol(null,"pr-sequential-writer","pr-sequential-writer",-1751706458,null),new cljs.core.Symbol(null,"simple-symbol?","simple-symbol?",1408454822,null),new cljs.core.Symbol(null,"accumulating-seq-count","accumulating-seq-count",-1933637306,null),new cljs.core.Symbol(null,"IIndexed","IIndexed",-574812826,null),new cljs.core.Symbol(null,"disj","disj",-1076545178,null),new cljs.core.Symbol(null,"MultiIterator","MultiIterator",-1824863866,null),new cljs.core.Symbol(null,"IPrintWithWriter","IPrintWithWriter",-1205316154,null),new cljs.core.Symbol(null,"->UUID","->UUID",-1263807034,null),new cljs.core.Symbol(null,"IVector","IVector",-1120721434,null),new cljs.core.Symbol(null,"IIterable","IIterable",577191430,null),new cljs.core.Symbol(null,"->MultiIterator","->MultiIterator",-786621914,null),new cljs.core.Symbol(null,"*2","*2",1728229926,null),new cljs.core.Symbol(null,"Eduction","Eduction",-1730426298,null),new cljs.core.Symbol(null,"pv-clone-node","pv-clone-node",1938156102,null),new cljs.core.Symbol(null,"cons","cons",755448454,null),new cljs.core.Symbol(null,"PersistentTreeSet","PersistentTreeSet",1854386982,null),new cljs.core.Symbol(null,"->HashSetIter","->HashSetIter",-1124913338,null),new cljs.core.Symbol(null,"ns-lookup","ns-lookup",-1693731002,null),new cljs.core.Symbol(null,"floats","floats",513591110,null),new cljs.core.Symbol(null,"TransientVector","TransientVector",-476998778,null),new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"fnil","fnil",-187395162,null),new cljs.core.Symbol(null,"merge-with","merge-with",1025434534,null),new cljs.core.Symbol(null,"nthrest","nthrest",1219890118,null),new cljs.core.Symbol(null,"*warn-on-infer*","*warn-on-infer*",1890277318,null),new cljs.core.Symbol(null,"-find","-find",1229817895,null),new cljs.core.Symbol(null,"sequential?","sequential?",1102351463,null),new cljs.core.Symbol(null,"tree-map-replace","tree-map-replace",-1247144857,null),new cljs.core.Symbol(null,"checked-aset'","checked-aset'",-510930777,null),new cljs.core.Symbol(null,"m3-mix-H1","m3-mix-H1",143369415,null),new cljs.core.Symbol(null,"RecordIter","RecordIter",232140999,null),new cljs.core.Symbol(null,"->TransientArrayMap","->TransientArrayMap",164422919,null),new cljs.core.Symbol(null,"prim-seq","prim-seq",246326599,null),new cljs.core.Symbol(null,"*print-level*","*print-level*",-634488505,null),new cljs.core.Symbol(null,"shuffle","shuffle",-1393023609,null),new cljs.core.Symbol(null,"ChunkedSeq","ChunkedSeq",1188410759,null),new cljs.core.Symbol(null,"hash-keyword","hash-keyword",169730503,null),new cljs.core.Symbol(null,"find","find",2136810983,null),new cljs.core.Symbol(null,"alength","alength",-1268305401,null),new cljs.core.Symbol(null,"bit-xor","bit-xor",-1334295033,null),new cljs.core.Symbol(null,"->IndexedSeq","->IndexedSeq",1426754151,null),new cljs.core.Symbol(null,"ObjMap","ObjMap",107265639,null),new cljs.core.Symbol(null,"unsigned-bit-shift-right","unsigned-bit-shift-right",-1953076601,null),new cljs.core.Symbol(null,"ES6SetEntriesIterator","ES6SetEntriesIterator",107780775,null),new cljs.core.Symbol(null,"neg?","neg?",-1902175577,null),new cljs.core.Symbol(null,"Cons","Cons",738259623,null),new cljs.core.Symbol(null,"-remove-method","-remove-method",801114951,null),new cljs.core.Symbol(null,"->StringIter","->StringIter",-1468941433,null),new cljs.core.Symbol(null,"js-invoke","js-invoke",-834721817,null),new cljs.core.Symbol(null,"->List","->List",-634022904,null),new cljs.core.Symbol(null,"m3-mix-K1","m3-mix-K1",1610594376,null),new cljs.core.Symbol(null,"unchecked-float","unchecked-float",1485658216,null),new cljs.core.Symbol(null,"undefined?","undefined?",1356377224,null),new cljs.core.Symbol(null,"IMeta","IMeta",1095313672,null),new cljs.core.Symbol(null,"reduced?","reduced?",1361797384,null),new cljs.core.Symbol(null,"apply-to","apply-to",-1858571928,null),new cljs.core.Symbol(null,"disj!","disj!",-1383872088,null),new cljs.core.Symbol(null,"-lookup","-lookup",-1438393944,null),new cljs.core.Symbol(null,"float?","float?",673884616,null),new cljs.core.Symbol(null,"ICloneable","ICloneable",1882653160,null),new cljs.core.Symbol(null,"IEncodeClojure","IEncodeClojure",-2105637400,null),new cljs.core.Symbol(null,"booleans","booleans",756846088,null),new cljs.core.Symbol(null,"->ArrayList","->ArrayList",-1688019448,null),new cljs.core.Symbol(null,"RSeq","RSeq",-1953618360,null),new cljs.core.Symbol(null,"mask","mask",1054783080,null),new cljs.core.Symbol(null,"int-array","int-array",459176616,null),new cljs.core.Symbol(null,"find-and-cache-best-method","find-and-cache-best-method",-486932824,null),new cljs.core.Symbol(null,"set?","set?",1636014792,null),new cljs.core.Symbol(null,"iterable?","iterable?",-1991611704,null),new cljs.core.Symbol(null,"cat","cat",182721320,null),new cljs.core.Symbol(null,"->ES6EntriesIterator","->ES6EntriesIterator",-1104260312,null),new cljs.core.Symbol(null,"divide","divide",-545489112,null),new cljs.core.Symbol(null,"js-reserved-arr","js-reserved-arr",-136935576,null),new cljs.core.Symbol(null,"-pr-writer","-pr-writer",-445354136,null),new cljs.core.Symbol(null,"flush","flush",501820328,null),new cljs.core.Symbol(null,"set-from-indexed-seq","set-from-indexed-seq",-309748760,null),new cljs.core.Symbol(null,"take-while","take-while",2007268328,null),new cljs.core.Symbol(null,"vary-meta","vary-meta",-1580067831,null),new cljs.core.Symbol(null,"INext","INext",562211849,null),new cljs.core.Symbol(null,"is_proto_","is_proto_",-1171522551,null),new cljs.core.Symbol(null,"START","START",1074500649,null),new cljs.core.Symbol(null,"ICounted","ICounted",-1705786327,null),new cljs.core.Symbol(null,"IMapEntry","IMapEntry",-943754199,null),new cljs.core.Symbol(null,"pv-reduce","pv-reduce",507711593,null),new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"MODULE_INFOS","MODULE_INFOS",-1578442615,null),new cljs.core.Symbol(null,"conj!","conj!",-841007895,null),new cljs.core.Symbol(null,"-pop","-pop",1448233193,null),new cljs.core.Symbol(null,"array-index-of-identical?","array-index-of-identical?",1618059529,null),new cljs.core.Symbol(null,"repeatedly","repeatedly",1199964457,null),new cljs.core.Symbol(null,"zipmap","zipmap",-690049687,null),new cljs.core.Symbol(null,"reset-vals!","reset-vals!",-1522009719,null),new cljs.core.Symbol(null,"IStack","IStack",1136769449,null),new cljs.core.Symbol(null,"-remove-watch","-remove-watch",-644943415,null),new cljs.core.Symbol(null,"IVolatile","IVolatile",694974953,null),new cljs.core.Symbol(null,"remove","remove",1509103113,null),new cljs.core.Symbol(null,"->BitmapIndexedNode","->BitmapIndexedNode",783620617,null),new cljs.core.Symbol(null,"*","*",345799209,null),new cljs.core.Symbol(null,"re-pattern","re-pattern",1047705161,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"array-index-of-nil?","array-index-of-nil?",-1566794135,null),new cljs.core.Symbol(null,"-persistent!","-persistent!",-1399611735,null),new cljs.core.Symbol(null,"-nth","-nth",911195817,null),new cljs.core.Symbol(null,"pop!","pop!",-1253383511,null),new cljs.core.Symbol(null,"chunk-append","chunk-append",-1447349559,null),new cljs.core.Symbol(null,"*unchecked-arrays*","*unchecked-arrays*",-381849911,null),new cljs.core.Symbol(null,"prn-str","prn-str",-145225943,null),new cljs.core.Symbol(null,"IReversible","IReversible",-723048599,null),new cljs.core.Symbol(null,"reversible?","reversible?",314107817,null),new cljs.core.Symbol(null,"-realized?","-realized?",-1202464791,null),new cljs.core.Symbol(null,"-add-watch","-add-watch",-1481811991,null),new cljs.core.Symbol(null,"-deref-with-timeout","-deref-with-timeout",-645779446,null),new cljs.core.Symbol(null,"conj","conj",-1127293942,null),new cljs.core.Symbol(null,"-sorted-seq","-sorted-seq",1418818666,null),new cljs.core.Symbol(null,"flatten1","flatten1",543848554,null),new cljs.core.Symbol(null,"transduce","transduce",-2083619734,null),new cljs.core.Symbol(null,"fixture1","fixture1",118645898,null),new cljs.core.Symbol(null,"-swap!","-swap!",-535359318,null),new cljs.core.Symbol(null,"*print-length*","*print-length*",-687693654,null),new cljs.core.Symbol(null,"js-delete","js-delete",170306730,null),new cljs.core.Symbol(null,"truth_","truth_",231933130,null),new cljs.core.Symbol(null,"array-index-of","array-index-of",-1658616598,null),new cljs.core.Symbol(null,"->MultiFn","->MultiFn",-787284758,null),new cljs.core.Symbol(null,"key->js","key->js",-831468278,null),new cljs.core.Symbol(null,"IEncodeJS","IEncodeJS",-7449302,null),new cljs.core.Symbol(null,"new-path","new-path",-921435830,null),new cljs.core.Symbol(null,"compare-and-set!","compare-and-set!",-1997299382,null),new cljs.core.Symbol(null,"array-seq","array-seq",1251699018,null),new cljs.core.Symbol(null,"array-copy-downward","array-copy-downward",-1091031702,null),new cljs.core.Symbol(null,"pack-array-node","pack-array-node",-1474023062,null),new cljs.core.Symbol(null,"interleave","interleave",165488106,null),new cljs.core.Symbol(null,"print-map","print-map",-990905878,null),new cljs.core.Symbol(null,"map?","map?",-1780568534,null),new cljs.core.Symbol(null,"m3-C1","m3-C1",64175850,null),new cljs.core.Symbol(null,"get","get",-971253014,null),new cljs.core.Symbol(null,"identity","identity",-1007039734,null),new cljs.core.Symbol(null,"into","into",1489695498,null),new cljs.core.Symbol(null,"long","long",1469079434,null),new cljs.core.Symbol(null,"double","double",-1769548886,null),new cljs.core.Symbol(null,"volatile?","volatile?",-984469558,null),new cljs.core.Symbol(null,"ChunkBuffer","ChunkBuffer",227689418,null),new cljs.core.Symbol(null,"HashSetIter","HashSetIter",-740176918,null),new cljs.core.Symbol(null,"-key","-key",957928426,null),new cljs.core.Symbol(null,"nfirst","nfirst",-554736533,null),new cljs.core.Symbol(null,"StringBufferWriter","StringBufferWriter",-237365109,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"tv-editable-tail","tv-editable-tail",1373809803,null),new cljs.core.Symbol(null,"-kv-reduce","-kv-reduce",456218795,null),new cljs.core.Symbol(null,"IHash","IHash",-1495374645,null),new cljs.core.Symbol(null,"bit-and-not","bit-and-not",-254338837,null),new cljs.core.Symbol(null,"var?","var?",230455531,null),new cljs.core.Symbol(null,"-comparator","-comparator",-973909749,null),new cljs.core.Symbol(null,"unchecked-add-int","unchecked-add-int",-1821763285,null),new cljs.core.Symbol(null,"hash-ordered-coll","hash-ordered-coll",114448715,null),new cljs.core.Symbol(null,"extend-object!","extend-object!",486230379,null),new cljs.core.Symbol(null,"do-assoc","do-assoc",-350679637,null),new cljs.core.Symbol(null,"reset-meta!","reset-meta!",1699493291,null),new cljs.core.Symbol(null,"->KeySeq","->KeySeq",649979339,null),new cljs.core.Symbol(null,"IEquiv","IEquiv",-1912850869,null),new cljs.core.Symbol(null,"tree-map-kv-reduce","tree-map-kv-reduce",1209851531,null),new cljs.core.Symbol(null,"cycle","cycle",-1944070485,null),new cljs.core.Symbol(null,"-deref","-deref",-283116853,null),new cljs.core.Symbol(null,"pr-writer-ex-info","pr-writer-ex-info",-983867669,null),new cljs.core.Symbol(null,"empty?","empty?",76408555,null),new cljs.core.Symbol(null,"TaggedLiteral","TaggedLiteral",1614051051,null),new cljs.core.Symbol(null,"short","short",-725675253,null),new cljs.core.Symbol(null,"-clj->js","-clj->js",-1214918837,null),new cljs.core.Symbol(null,"-chunked-first","-chunked-first",-1211450485,null),new cljs.core.Symbol(null,"filterv","filterv",1977739179,null),new cljs.core.Symbol(null,"->TaggedLiteral","->TaggedLiteral",-1806425141,null),new cljs.core.Symbol(null,"tv-editable-root","tv-editable-root",-583749653,null),new cljs.core.Symbol(null,"hash","hash",1626749931,null),new cljs.core.Symbol(null,"quot","quot",-1125214196,null),new cljs.core.Symbol(null,"ns-interns*","ns-interns*",-200426388,null),new cljs.core.Symbol(null,"unchecked-double","unchecked-double",-1593778036,null),new cljs.core.Symbol(null,"*target*","*target*",-1336537940,null),new cljs.core.Symbol(null,"->ChunkedCons","->ChunkedCons",1160249548,null),new cljs.core.Symbol(null,"ranged-iterator","ranged-iterator",-2032554804,null),new cljs.core.Symbol(null,"ITransientVector","ITransientVector",1978793164,null),new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"longs","longs",-1017696020,null),new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.Symbol(null,"set-print-err-fn!","set-print-err-fn!",-456712948,null),new cljs.core.Symbol(null,"string?","string?",-1129175764,null),new cljs.core.Symbol(null,"uri?","uri?",2029475116,null),new cljs.core.Symbol(null,"es6-iterator","es6-iterator",1531136332,null),new cljs.core.Symbol(null,"Delay","Delay",-956795572,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),new cljs.core.Symbol(null,"pr-str-with-opts","pr-str-with-opts",1488207244,null),new cljs.core.Symbol(null,"->RecordIter","->RecordIter",-1315127924,null),new cljs.core.Symbol(null,"m3-C2","m3-C2",-650805876,null),new cljs.core.Symbol(null,"->Symbol","->Symbol",-1564137012,null),new cljs.core.Symbol(null,"*print-newline*","*print-newline*",1478078956,null),new cljs.core.Symbol(null,"unchecked-multiply-int","unchecked-multiply-int",-788546068,null),new cljs.core.Symbol(null,"chunk-rest","chunk-rest",-1853526420,null),new cljs.core.Symbol(null,"remove-all-methods","remove-all-methods",-728267092,null),new cljs.core.Symbol(null,"trampoline","trampoline",-71368916,null),new cljs.core.Symbol(null,"double?","double?",-2146564276,null),new cljs.core.Symbol(null,"pr-opts","pr-opts",-900888692,null),new cljs.core.Symbol(null,"*1","*1",2110258092,null),new cljs.core.Symbol(null,"vec","vec",982683596,null),new cljs.core.Symbol(null,"*print-meta*","*print-meta*",-919406644,null),new cljs.core.Symbol(null,"-notify-watches","-notify-watches",-835153940,null),new cljs.core.Symbol(null,"MultiFn","MultiFn",-2140417011,null),new cljs.core.Symbol(null,"NONE","NONE",-2098891731,null),new cljs.core.Symbol(null,"int","int",-100885395,null),new cljs.core.Symbol(null,"->ValSeq","->ValSeq",1460121709,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"second","second",1195829517,null),new cljs.core.Symbol(null,"find-ns-obj","find-ns-obj",-1848379123,null),new cljs.core.Symbol(null,"IEditableCollection","IEditableCollection",-906687187,null),new cljs.core.Symbol(null,"hash-combine","hash-combine",1136881997,null),new cljs.core.Symbol(null,">",">",1085014381,null),new cljs.core.Symbol(null,"-name","-name",2075138477,null),new cljs.core.Symbol(null,"t_cljs$core10492","t_cljs$core10492",521028013,null),new cljs.core.Symbol(null,"replace","replace",853943757,null),new cljs.core.Symbol(null,"int?","int?",1799729645,null),new cljs.core.Symbol(null,"->Subvec","->Subvec",808121837,null),new cljs.core.Symbol(null,"associative?","associative?",-141666771,null),new cljs.core.Symbol(null,"unchecked-int","unchecked-int",1672898125,null),new cljs.core.Symbol(null,"js-keys","js-keys",-1388365203,null),new cljs.core.Symbol(null,"inst-ms*","inst-ms*",-1185945939,null),new cljs.core.Symbol(null,"ES6EntriesIterator","ES6EntriesIterator",1381168813,null),new cljs.core.Symbol(null,"keyword?","keyword?",1917797069,null),new cljs.core.Symbol(null,"array-iter","array-iter",194817773,null),new cljs.core.Symbol(null,"force","force",-1872478483,null),new cljs.core.Symbol(null,"group-by","group-by",1261391725,null),new cljs.core.Symbol(null,"-rseq","-rseq",-1692326003,null),new cljs.core.Symbol(null,"prn","prn",1561684909,null),new cljs.core.Symbol(null,"tv-pop-tail","tv-pop-tail",-570370034,null),new cljs.core.Symbol(null,"default-dispatch-val","default-dispatch-val",-1231201266,null),new cljs.core.Symbol(null,"->Atom","->Atom",-687623122,null),new cljs.core.Symbol(null,"PersistentHashMap","PersistentHashMap",-1137768338,null),new cljs.core.Symbol(null,"unchecked-multiply","unchecked-multiply",-1019161490,null),new cljs.core.Symbol(null,"ArrayNodeSeq","ArrayNodeSeq",822826190,null),new cljs.core.Symbol(null,"even?","even?",-1827825394,null),new cljs.core.Symbol(null,"es6-iterator-seq","es6-iterator-seq",-53147346,null),new cljs.core.Symbol(null,"unchecked-dec","unchecked-dec",2095823150,null),new cljs.core.Symbol(null,"Inst","Inst",292408622,null),new cljs.core.Symbol(null,"hash-collision-node-find-index","hash-collision-node-find-index",1550469454,null),new cljs.core.Symbol(null,"persistent-array-map-seq","persistent-array-map-seq",1313422702,null),new cljs.core.Symbol(null,"RangeIterator","RangeIterator",635213198,null),new cljs.core.Symbol(null,"tagged-literal?","tagged-literal?",1117865390,null),new cljs.core.Symbol(null,"double-array","double-array",257035726,null),new cljs.core.Symbol(null,"create-ns","create-ns",-782886354,null),new cljs.core.Symbol(null,"->EmptyList","->EmptyList",79581838,null),new cljs.core.Symbol(null,"seq-reduce","seq-reduce",569373326,null),new cljs.core.Symbol(null,"spread","spread",-1792098578,null),new cljs.core.Symbol(null,"balance-left","balance-left",-2052094194,null),new cljs.core.Symbol(null,"rseq","rseq",-1719353554,null),new cljs.core.Symbol(null,"ex-cause","ex-cause",95392590,null),new cljs.core.Symbol(null,"IReset","IReset",-1893729426,null),new cljs.core.Symbol(null,"IEmptyableCollection","IEmptyableCollection",1477271438,null),new cljs.core.Symbol(null,"array-map-index-of","array-map-index-of",908248014,null),new cljs.core.Symbol(null,"ex-message","ex-message",-1128293394,null),new cljs.core.Symbol(null,"->NodeIterator","->NodeIterator",-820063217,null),new cljs.core.Symbol(null,"*print-fn-bodies*","*print-fn-bodies*",1924960335,null),new cljs.core.Symbol(null,"string-print","string-print",-1952246705,null),new cljs.core.Symbol(null,"float","float",-91857841,null),new cljs.core.Symbol(null,"fixture2","fixture2",-394501041,null),new cljs.core.Symbol(null,"IRecord","IRecord",-903221169,null),new cljs.core.Symbol(null,"pr-str","pr-str",-2066912145,null),new cljs.core.Symbol(null,"first-array-for-longvec","first-array-for-longvec",-1115655057,null),new cljs.core.Symbol(null,"es6-set-entries-iterator","es6-set-entries-iterator",-1859217265,null),new cljs.core.Symbol(null,"concat","concat",-467652465,null),new cljs.core.Symbol(null,"-methods","-methods",-421239665,null),new cljs.core.Symbol(null,"js-reserved","js-reserved",740533423,null),new cljs.core.Symbol(null,"IDerefWithTimeout","IDerefWithTimeout",2140974319,null),new cljs.core.Symbol(null,"symbol","symbol",601958831,null),new cljs.core.Symbol(null,"to-array-2d","to-array-2d",-1563270737,null),new cljs.core.Symbol(null,"Subvec","Subvec",-38340113,null),new cljs.core.Symbol(null,"ExceptionInfo","ExceptionInfo",294935087,null),new cljs.core.Symbol(null,"mod","mod",1510044207,null),new cljs.core.Symbol(null,"ISet","ISet",-1398072657,null),new cljs.core.Symbol(null,"pop","pop",-94247249,null),new cljs.core.Symbol(null,"IPending","IPending",1229113039,null),new cljs.core.Symbol(null,"-entry-key","-entry-key",1690687343,null),new cljs.core.Symbol(null,"CHAR_MAP","CHAR_MAP",951510991,null),new cljs.core.Symbol(null,"pop-tail","pop-tail",292015087,null),new cljs.core.Symbol(null,"dissoc!","dissoc!",333592624,null),new cljs.core.Symbol(null,"reductions","reductions",549963952,null),new cljs.core.Symbol(null,"indexed?","indexed?",1234610384,null),new cljs.core.Symbol(null,"-","-",-471816912,null),new cljs.core.Symbol(null,"-equiv","-equiv",320124272,null),new cljs.core.Symbol(null,"->RangeIterator","->RangeIterator",-479835792,null),new cljs.core.Symbol(null,"->ArrayNode","->ArrayNode",946775440,null),new cljs.core.Symbol(null,"assoc!","assoc!",-847603280,null),new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),new cljs.core.Symbol(null,"reduce-kv","reduce-kv",1856296400,null),new cljs.core.Symbol(null,"reset!","reset!",527275632,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"->RedNode","->RedNode",538338992,null),new cljs.core.Symbol(null,"unchecked-array-for","unchecked-array-for",1392533200,null),new cljs.core.Symbol(null,"Fn","Fn",239694576,null),new cljs.core.Symbol(null,"ffirst","ffirst",-694902000,null),new cljs.core.Symbol(null,"->ArrayNodeIterator","->ArrayNodeIterator",1017821968,null),new cljs.core.Symbol(null,"sorted-set","sorted-set",992325424,null),new cljs.core.Symbol(null,"pr-with-opts","pr-with-opts",-1458147536,null),new cljs.core.Symbol(null,"PersistentTreeMap","PersistentTreeMap",323423120,null),new cljs.core.Symbol(null,"strip-ns","strip-ns",308416432,null),new cljs.core.Symbol(null,"->PersistentTreeMap","->PersistentTreeMap",-485779536,null),new cljs.core.Symbol(null,"array-reduce","array-reduce",154113968,null),new cljs.core.Symbol(null,"counted?","counted?",1703071664,null),new cljs.core.Symbol(null,"tagged-literal","tagged-literal",-896422703,null),new cljs.core.Symbol(null,"println","println",-733595439,null),new cljs.core.Symbol(null,"assoc-in","assoc-in",-113585743,null),new cljs.core.Symbol(null,"PersistentHashSet","PersistentHashSet",781756881,null),new cljs.core.Symbol(null,"bit-test","bit-test",543456753,null),new cljs.core.Symbol(null,"->Namespace","->Namespace",1025194513,null),new cljs.core.Symbol(null,"TransientHashMap","TransientHashMap",2015217169,null),new cljs.core.Symbol(null,"->PersistentHashMap","->PersistentHashMap",740284945,null),new cljs.core.Symbol(null,"array-extend-kv","array-extend-kv",1407114801,null),new cljs.core.Symbol(null,"ISwap","ISwap",484378193,null),new cljs.core.Symbol(null,"ChunkedCons","ChunkedCons",1331601073,null),new cljs.core.Symbol(null,"memoize","memoize",2019341169,null),new cljs.core.Symbol(null,"alter-meta!","alter-meta!",1510444945,null),new cljs.core.Symbol(null,"->StringBufferWriter","->StringBufferWriter",243739537,null),new cljs.core.Symbol(null,"zero?","zero?",325758897,null),new cljs.core.Symbol(null,"tv-ensure-editable","tv-ensure-editable",-1341881391,null),new cljs.core.Symbol(null,"simple-keyword?","simple-keyword?",-367134735,null),new cljs.core.Symbol(null,"-indexOf","-indexOf",-442719214,null),new cljs.core.Symbol(null,"*main-cli-fn*","*main-cli-fn*",1002586130,null),new cljs.core.Symbol(null,"-assoc-n","-assoc-n",-1670943726,null),new cljs.core.Symbol(null,"unchecked-dec-int","unchecked-dec-int",1339067442,null),new cljs.core.Symbol(null,"hash-imap","hash-imap",-1047446478,null),new cljs.core.Symbol(null,"dominates","dominates",917816370,null),new cljs.core.Symbol(null,"persistent!","persistent!",1286555698,null),new cljs.core.Symbol(null,"set-print-fn!","set-print-fn!",-2101712846,null),new cljs.core.Symbol(null,"nnext","nnext",-2065435598,null),new cljs.core.Symbol(null,"Box","Box",2112194642,null),new cljs.core.Symbol(null,"balance-right","balance-right",-256154542,null),new cljs.core.Symbol(null,"throw-no-method-error","throw-no-method-error",-453572494,null),new cljs.core.Symbol(null,"demunge-str","demunge-str",-1935885198,null),new cljs.core.Symbol(null,"add-watch","add-watch",1389887634,null),new cljs.core.Symbol(null,"not-every?","not-every?",-729672558,null),new cljs.core.Symbol(null,"rem","rem",664046770,null),new cljs.core.Symbol(null,"ifind?","ifind?",1940593874,null),new cljs.core.Symbol(null,"pr-sb-with-opts","pr-sb-with-opts",2116636978,null),new cljs.core.Symbol(null,"->t_cljs$core8988","->t_cljs$core8988",-1976964814,null),new cljs.core.Symbol(null,"->HashMapIter","->HashMapIter",783017330,null),new cljs.core.Symbol(null,"BitmapIndexedNode","BitmapIndexedNode",1323485586,null),new cljs.core.Symbol(null,"->NodeSeq","->NodeSeq",1266079122,null),new cljs.core.Symbol(null,"some","some",-310548046,null),new cljs.core.Symbol(null,"INamed","INamed",357992946,null),new cljs.core.Symbol(null,"->Box","->Box",779176434,null),new cljs.core.Symbol(null,"IReduce","IReduce",-440384974,null),new cljs.core.Symbol(null,"neg-int?","neg-int?",-1610409390,null),new cljs.core.Symbol(null,"drop","drop",2005013138,null),new cljs.core.Symbol(null,"NodeIterator","NodeIterator",-1869558126,null),new cljs.core.Symbol(null,"js-obj","js-obj",342383250,null),new cljs.core.Symbol(null,"ITransientCollection","ITransientCollection",252832402,null),new cljs.core.Symbol(null,"Atom","Atom",-1761773934,null),new cljs.core.Symbol(null,"nth","nth",1529209554,null),new cljs.core.Symbol(null,"sorted?","sorted?",892797714,null),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"split-at","split-at",-60953742,null),new cljs.core.Symbol(null,"TransientHashSet","TransientHashSet",-410389614,null),new cljs.core.Symbol(null,"*e","*e",329170866,null),new cljs.core.Symbol(null,"array-map-extend-kv","array-map-extend-kv",-256947278,null),new cljs.core.Symbol(null,"prn-str-with-opts","prn-str-with-opts",1883629522,null),new cljs.core.Symbol(null,"not-native","not-native",-236392494,null),new cljs.core.Symbol(null,"random-sample","random-sample",-914181101,null),new cljs.core.Symbol(null,"select-keys","select-keys",-708556589,null),new cljs.core.Symbol(null,"bit-and","bit-and",-479352589,null),new cljs.core.Symbol(null,"bounded-count","bounded-count",1030640883,null),new cljs.core.Symbol(null,"update","update",-1608859373,null),new cljs.core.Symbol(null,"gensym_counter","gensym_counter",1281181971,null),new cljs.core.Symbol(null,"find-macros-ns","find-macros-ns",1923422515,null),new cljs.core.Symbol(null,"list*","list*",765415731,null),new cljs.core.Symbol(null,"array-index-of-keyword?","array-index-of-keyword?",-426479277,null),new cljs.core.Symbol(null,"->Keyword","->Keyword",-70022797,null),new cljs.core.Symbol(null,"update-in","update-in",-1445516941,null),new cljs.core.Symbol(null,"prefer-method","prefer-method",-876100205,null),new cljs.core.Symbol(null,"hash-symbol","hash-symbol",194800019,null),new cljs.core.Symbol(null,"ensure-reduced","ensure-reduced",-1606421005,null),new cljs.core.Symbol(null,"edit-and-set","edit-and-set",-341005773,null),new cljs.core.Symbol(null,"->PersistentArrayMap","->PersistentArrayMap",-1510490573,null),new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol(null,"mix-collection-hash","mix-collection-hash",1960468083,null),new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),new cljs.core.Symbol(null,"run!","run!",-2055483725,null),new cljs.core.Symbol(null,"char-escapes","char-escapes",-128862509,null),new cljs.core.Symbol(null,"ES6Iterator","ES6Iterator",1021379315,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"unchecked-add","unchecked-add",-2030665965,null),new cljs.core.Symbol(null,"transformer-iterator","transformer-iterator",-1627376845,null),new cljs.core.Symbol(null,"not","not",1044554643,null),new cljs.core.Symbol(null,"-vreset!","-vreset!",1350866867,null),new cljs.core.Symbol(null,"fn->comparator","fn->comparator",-1700176973,null),new cljs.core.Symbol(null,"with-meta","with-meta",73674707,null),new cljs.core.Symbol(null,"unreduced","unreduced",780976083,null),new cljs.core.Symbol(null,"record?","record?",-1305224237,null),new cljs.core.Symbol(null,"type","type",-1480165421,null),new cljs.core.Symbol(null,"identical?","identical?",-745864205,null),new cljs.core.Symbol(null,"-namespace","-namespace",1721751539,null),new cljs.core.Symbol(null,"unchecked-divide-int","unchecked-divide-int",1613116468,null),new cljs.core.Symbol(null,"ns-name","ns-name",-436814796,null),new cljs.core.Symbol(null,"swap-global-hierarchy!","swap-global-hierarchy!",-1131849644,null),new cljs.core.Symbol(null,"max-key","max-key",-2132814732,null),new cljs.core.Symbol(null,"->PersistentTreeSet","->PersistentTreeSet",499740884,null),new cljs.core.Symbol(null,"*out*","*out*",1277591796,null),new cljs.core.Symbol(null,"->ChunkBuffer","->ChunkBuffer",-274147052,null),new cljs.core.Symbol(null,"hash-string","hash-string",-402119340,null),new cljs.core.Symbol(null,"ValSeq","ValSeq",-587010732,null),new cljs.core.Symbol(null,"-prefers","-prefers",-1347601932,null),new cljs.core.Symbol(null,"set-validator!","set-validator!",-805770668,null),new cljs.core.Symbol(null,"ident?","ident?",-2061359468,null),new cljs.core.Symbol(null,"-meta","-meta",494863156,null),new cljs.core.Symbol(null,"RedNode","RedNode",-1774604492,null),new cljs.core.Symbol(null,"-dispatch-fn","-dispatch-fn",-1486833868,null),new cljs.core.Symbol(null,"->IndexedSeqIterator","->IndexedSeqIterator",784171892,null),new cljs.core.Symbol(null,"-add-method","-add-method",181112692,null),new cljs.core.Symbol(null,"balance-left-del","balance-left-del",931180436,null),new cljs.core.Symbol(null,"swap!","swap!",-655677516,null),new cljs.core.Symbol(null,"vals","vals",-1886377036,null),new cljs.core.Symbol(null,"-chunked-next","-chunked-next",-1456224300,null),new cljs.core.Symbol(null,"Single","Single",-458818604,null),new cljs.core.Symbol(null,"unchecked-subtract","unchecked-subtract",-2137458667,null),new cljs.core.Symbol(null,"remove-pair","remove-pair",272143413,null),new cljs.core.Symbol(null,"IMap","IMap",992876629,null),new cljs.core.Symbol(null,"->SeqIter","->SeqIter",-262876075,null),new cljs.core.Symbol(null,"sorted-set-by","sorted-set-by",899099765,null),new cljs.core.Symbol(null,"PersistentVector","PersistentVector",-837570443,null),new cljs.core.Symbol(null,"cloneable?","cloneable?",776826997,null),new cljs.core.Symbol(null,"qualified-ident?","qualified-ident?",-928894763,null),new cljs.core.Symbol(null,"hash-string*","hash-string*",1228257493,null),new cljs.core.Symbol(null,"key-test","key-test",1727763701,null),new cljs.core.Symbol(null,"-reset","-reset",1448715669,null),new cljs.core.Symbol(null,"true?","true?",-1600332395,null),new cljs.core.Symbol(null,"find-ns-obj*","find-ns-obj*",-561205835,null),new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"print","print",-1354873355,null),new cljs.core.Symbol(null,"-peek","-peek",2046549493,null),new cljs.core.Symbol(null,"ISeq","ISeq",1517365813,null),new cljs.core.Symbol(null,"empty","empty",-1886564811,null),new cljs.core.Symbol(null,"remove-method","remove-method",72923733,null),new cljs.core.Symbol(null,"PersistentQueueSeq","PersistentQueueSeq",1093350037,null),new cljs.core.Symbol(null,"balance-right-del","balance-right-del",-1287163243,null),new cljs.core.Symbol(null,"volatile!","volatile!",919368405,null),new cljs.core.Symbol(null,"/","/",-1371932971,null),new cljs.core.Symbol(null,"bitpos","bitpos",1020040021,null),new cljs.core.Symbol(null,"Many","Many",1778730837,null),new cljs.core.Symbol(null,"bit-or","bit-or",-1144943723,null),new cljs.core.Symbol(null,"m3-fmix","m3-fmix",1102500757,null),new cljs.core.Symbol(null,"vector","vector",-751469611,null),new cljs.core.Symbol(null,"hash-coll","hash-coll",1632738293,null),new cljs.core.Symbol(null,"clone-and-set","clone-and-set",-1184747531,null),new cljs.core.Symbol(null,"array->transient-hash-map","array->transient-hash-map",1952725014,null),new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"->TransientHashSet","->TransientHashSet",2075023446,null),new cljs.core.Symbol(null,"drop-last","drop-last",-1123611530,null),new cljs.core.Symbol(null,"->ArrayIter","->ArrayIter",-1261538186,null),new cljs.core.Symbol(null,"object?","object?",327472310,null),new cljs.core.Symbol(null,"->ArrayNodeSeq","->ArrayNodeSeq",532278454,null),new cljs.core.Symbol(null,"lift-ns","lift-ns",602311926,null),new cljs.core.Symbol(null,"tree-map-append","tree-map-append",351783158,null),new cljs.core.Symbol(null,"not-empty","not-empty",2029453590,null),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null),new cljs.core.Symbol(null,"partition","partition",-1479695018,null),new cljs.core.Symbol(null,"IMultiFn","IMultiFn",-1848282794,null),new cljs.core.Symbol(null,"->Many","->Many",-324867722,null),new cljs.core.Symbol(null,"DEMUNGE_PATTERN","DEMUNGE_PATTERN",1397419414,null),new cljs.core.Symbol(null,"fix","fix",608758198,null),new cljs.core.Symbol(null,"EmptyList","EmptyList",632334934,null),new cljs.core.Symbol(null,"HashMapIter","HashMapIter",339783254,null),new cljs.core.Symbol(null,"IAssociative","IAssociative",-1306431882,null),new cljs.core.Symbol(null,"->Single","->Single",1812779670,null),new cljs.core.Symbol(null,"bit-flip","bit-flip",809639606,null),new cljs.core.Symbol(null,"long-array","long-array",217579190,null),new cljs.core.Symbol(null,"descendants","descendants",-829549738,null),new cljs.core.Symbol(null,"imul","imul",-1639153802,null),new cljs.core.Symbol(null,"->Delay","->Delay",84086678,null),new cljs.core.Symbol(null,"array-for","array-for",-483639402,null),new cljs.core.Symbol(null,"merge","merge",-163787882,null),new cljs.core.Symbol(null,"ISeqable","ISeqable",1349682102,null),new cljs.core.Symbol(null,"Empty","Empty",-79405098,null),new cljs.core.Symbol(null,"js-mod","js-mod",-143822890,null),new cljs.core.Symbol(null,"integer?","integer?",1303791671,null),new cljs.core.Symbol(null,"MetaFn","MetaFn",-1517402057,null),new cljs.core.Symbol(null,"NS_CACHE","NS_CACHE",858475639,null),new cljs.core.Symbol(null,"mapv","mapv",-241595241,null),new cljs.core.Symbol(null,"infinite?","infinite?",-377355081,null),new cljs.core.Symbol(null,"partition-all","partition-all",-1985005385,null),new cljs.core.Symbol(null,"partition-by","partition-by",-1329938249,null),new cljs.core.Symbol(null,"ISequential","ISequential",-1626174217,null),new cljs.core.Symbol(null,"->LazySeq","->LazySeq",1398137079,null),new cljs.core.Symbol(null,"equiv-map","equiv-map",-1852413705,null),new cljs.core.Symbol(null,"->Volatile","->Volatile",-136040105,null),new cljs.core.Symbol(null,"object-array","object-array",206434647,null),new cljs.core.Symbol(null,"Keyword","Keyword",-850065993,null),new cljs.core.Symbol(null,"derive","derive",1727397303,null),new cljs.core.Symbol(null,"seq-iter","seq-iter",2048231959,null),new cljs.core.Symbol(null,"->Empty","->Empty",1337008663,null),new cljs.core.Symbol(null,"IChunkedSeq","IChunkedSeq",-1299765705,null),new cljs.core.Symbol(null,"special-symbol?","special-symbol?",-731144617,null),new cljs.core.Symbol(null,"compare-keywords","compare-keywords",1200021175,null),new cljs.core.Symbol(null,"ancestors","ancestors",864486103,null),new cljs.core.Symbol(null,"subseq","subseq",-1558995241,null),new cljs.core.Symbol(null,"gensym","gensym",-1693147401,null),new cljs.core.Symbol(null,"-next","-next",1002429175,null),new cljs.core.Symbol(null,"->HashCollisionNode","->HashCollisionNode",-1731424393,null),new cljs.core.Symbol(null,"delay?","delay?",-1528239209,null),new cljs.core.Symbol(null,"create-inode-seq","create-inode-seq",854169527,null),new cljs.core.Symbol(null,"flatten","flatten",-1441633353,null),new cljs.core.Symbol(null,"-dissoc","-dissoc",1638079447,null),new cljs.core.Symbol(null,"doubles","doubles",-1517872169,null),new cljs.core.Symbol(null,"halt-when","halt-when",-140999689,null),new cljs.core.Symbol(null,"-contains-key?","-contains-key?",418646007,null),new cljs.core.Symbol(null,"remove-watch","remove-watch",-1105301448,null),new cljs.core.Symbol(null,"ex-info","ex-info",-539875240,null),new cljs.core.Symbol(null,"ifn?","ifn?",-2106461064,null),new cljs.core.Symbol(null,"IAtom","IAtom",-1411134312,null),new cljs.core.Symbol(null,"->PersistentQueue","->PersistentQueue",-755319624,null),new cljs.core.Symbol(null,"nat-int?","nat-int?",-1879663400,null),new cljs.core.Symbol(null,"IWatchable","IWatchable",-1929659016,null),new cljs.core.Symbol(null,"pv-fresh-node","pv-fresh-node",-556702312,null),new cljs.core.Symbol(null,"subvec","subvec",364611032,null),new cljs.core.Symbol(null,"-pop!","-pop!",1055647192,null),new cljs.core.Symbol(null,"partial","partial",1881673272,null),new cljs.core.Symbol(null,"chunked-seq?","chunked-seq?",1044846168,null),new cljs.core.Symbol(null,"replicate","replicate",-1605853608,null),new cljs.core.Symbol(null,"PersistentQueue","PersistentQueue",-160870792,null),new cljs.core.Symbol(null,"min-key","min-key",246826648,null),new cljs.core.Symbol(null,"hash-iset","hash-iset",-1750674792,null),new cljs.core.Symbol(null,"reduced","reduced",-1189224808,null),new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"pr-writer-impl","pr-writer-impl",1493645016,null),new cljs.core.Symbol(null,"array-map","array-map",1555038968,null),new cljs.core.Symbol(null,"ITransientSet","ITransientSet",-575559912,null),new cljs.core.Symbol(null,"ITER_SYMBOL","ITER_SYMBOL",2065001240,null),new cljs.core.Symbol(null,"unchecked-byte","unchecked-byte",1091664664,null),new cljs.core.Symbol(null,"checked-aset","checked-aset",1556136760,null),new cljs.core.Symbol(null,"ArrayNode","ArrayNode",-1767596168,null),new cljs.core.Symbol(null,"->ChunkedSeq","->ChunkedSeq",1766540313,null),new cljs.core.Symbol(null,"every-pred","every-pred",-1346958247,null),new cljs.core.Symbol(null,"keys","keys",-1586012071,null),new cljs.core.Symbol(null,"missing-protocol","missing-protocol",-965753735,null),new cljs.core.Symbol(null,"->t_cljs$core10492","->t_cljs$core10492",1815493785,null),new cljs.core.Symbol(null,"load-file","load-file",1215944857,null),new cljs.core.Symbol(null,"PersistentArrayMap","PersistentArrayMap",-715498343,null),new cljs.core.Symbol(null,"distinct?","distinct?",-1684357959,null),new cljs.core.Symbol(null,"pos-int?","pos-int?",-1205815015,null),new cljs.core.Symbol(null,"never-equiv","never-equiv",-1779311335,null),new cljs.core.Symbol(null,"unchecked-short","unchecked-short",27848057,null),new cljs.core.Symbol(null,"->Range","->Range",632205721,null),new cljs.core.Symbol(null,"->MapEntry","->MapEntry",-545334887,null),new cljs.core.Symbol(null,"apply-to-simple","apply-to-simple",919605689,null),new cljs.core.Symbol(null,"methods","methods",2094462393,null),new cljs.core.Symbol(null,"odd?","odd?",-1458588199,null),new cljs.core.Symbol(null,"->ArrayChunk","->ArrayChunk",-603095591,null),new cljs.core.Symbol(null,"ci-reduce","ci-reduce",1257017,null),new cljs.core.Symbol(null,"*3","*3",105062009,null),new cljs.core.Symbol(null,"-get-method","-get-method",1812663961,null),new cljs.core.Symbol(null,"->Var","->Var",698626713,null),new cljs.core.Symbol(null,"frequencies","frequencies",1757430425,null),new cljs.core.Symbol(null,"reduceable?","reduceable?",474283737,null),new cljs.core.Symbol(null,"string-hash-cache","string-hash-cache",-246541543,null),new cljs.core.Symbol(null,"rsubseq","rsubseq",-710070471,null),new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"type->str","type->str",360030041,null),new cljs.core.Symbol(null,"obj-clone","obj-clone",-1796656295,null),new cljs.core.Symbol(null,"get-method","get-method",185754457,null),new cljs.core.Symbol(null,"uuid?","uuid?",400077689,null),new cljs.core.Symbol(null,"vector-index-out-of-bounds","vector-index-out-of-bounds",-1188210823,null),new cljs.core.Symbol(null,"es6-entries-iterator","es6-entries-iterator",1717750745,null),new cljs.core.Symbol(null,"bit-clear","bit-clear",-1194520583,null),new cljs.core.Symbol(null,"Range","Range",201476089,null),new cljs.core.Symbol(null,"filter","filter",691993593,null),new cljs.core.Symbol(null,"->PersistentTreeMapSeq","->PersistentTreeMapSeq",-1858260966,null),new cljs.core.Symbol(null,"create-array-node-seq","create-array-node-seq",-1056359398,null),new cljs.core.Symbol(null,"-assoc-n!","-assoc-n!",-792125382,null),new cljs.core.Symbol(null,"IWithMeta","IWithMeta",-509493158,null),new cljs.core.Symbol(null,"list","list",-1889078086,null),new cljs.core.Symbol(null,"+","+",-740910886,null),new cljs.core.Symbol(null,"IndexedSeqIterator","IndexedSeqIterator",1564294362,null),new cljs.core.Symbol(null,"split-with","split-with",1853047034,null),new cljs.core.Symbol(null,"->VectorNode","->VectorNode",-62319334,null),new cljs.core.Symbol(null,"aset","aset",900773178,null),new cljs.core.Symbol(null,"int-rotate-left","int-rotate-left",-1331350214,null),new cljs.core.Symbol(null,"keyword","keyword",-1843046022,null),new cljs.core.Symbol(null,"->Cons","->Cons",-1208723046,null),new cljs.core.Symbol(null,"*ns*","*ns*",740153818,null),new cljs.core.Symbol(null,"*assert*","*assert*",1479636474,null),new cljs.core.Symbol(null,"create-tree-map-seq","create-tree-map-seq",-197592582,null),new cljs.core.Symbol(null,"ICollection","ICollection",-686709190,null),new cljs.core.Symbol(null,"chars","chars",545901210,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"next","next",1522830042,null),new cljs.core.Symbol(null,"ASeq","ASeq",266390234,null),new cljs.core.Symbol(null,"pr-seq-writer","pr-seq-writer",-411871526,null),new cljs.core.Symbol(null,"SeqIter","SeqIter",2085605114,null),new cljs.core.Symbol(null,"IFn","IFn",-244881638,null),new cljs.core.Symbol(null,"regexp?","regexp?",-1015402694,null),new cljs.core.Symbol(null,"hash-map","hash-map",-439030950,null),new cljs.core.Symbol(null,"underive","underive",-242982950,null),new cljs.core.Symbol(null,"array-copy","array-copy",1758625786,null),new cljs.core.Symbol(null,"obj-map-compare-keys","obj-map-compare-keys",1240335387,null),new cljs.core.Symbol(null,"-reset!","-reset!",1965723739,null),new cljs.core.Symbol(null,"-rest","-rest",1245085819,null),new cljs.core.Symbol(null,"nil-iter","nil-iter",1101030523,null),new cljs.core.Symbol(null,"pr-writer","pr-writer",2117969051,null),new cljs.core.Symbol(null,"false?","false?",-1522377573,null),new cljs.core.Symbol(null,"RangedIterator","RangedIterator",1152147611,null),new cljs.core.Symbol(null,"*print-readably*","*print-readably*",-761361221,null),new cljs.core.Symbol(null,"ints","ints",-1761239845,null),new cljs.core.Symbol(null,"some-fn","some-fn",-490044165,null),new cljs.core.Symbol(null,"demunge-pattern","demunge-pattern",518725883,null),new cljs.core.Symbol(null,"*flush-on-newline*","*flush-on-newline*",-737526501,null),new cljs.core.Symbol(null,"to-array","to-array",-585705189,null),new cljs.core.Symbol(null,"build-subvec","build-subvec",-504432357,null),new cljs.core.Symbol(null,"maybe-warn","maybe-warn",976067899,null),new cljs.core.Symbol(null,"Namespace","Namespace",-133658213,null),new cljs.core.Symbol(null,"list?","list?",-1494629,null),new cljs.core.Symbol(null,"tree-map-remove","tree-map-remove",568963483,null),new cljs.core.Symbol(null,"PersistentQueueIter","PersistentQueueIter",-371665509,null),new cljs.core.Symbol(null,"HashCollisionNode","HashCollisionNode",1527585211,null),new cljs.core.Symbol(null,"array?","array?",-1249008197,null),new cljs.core.Symbol(null,"prefers*","prefers*",1366670811,null),new cljs.core.Symbol(null,"simple-ident?","simple-ident?",194189851,null),new cljs.core.Symbol(null,"clone","clone",-1942688197,null),new cljs.core.Symbol(null,"scan-array","scan-array",1967806043,null),new cljs.core.Symbol(null,"demunge","demunge",-1865491845,null),new cljs.core.Symbol(null,"bit-not","bit-not",1508529851,null),new cljs.core.Symbol(null,"quote-string","quote-string",-1712290021,null),new cljs.core.Symbol(null,"byte","byte",-1970660549,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"IComparable","IComparable",1834481627,null),new cljs.core.Symbol(null,"==","==",-234118149,null),new cljs.core.Symbol(null,"parents","parents",-387007364,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"-disjoin!","-disjoin!",886301884,null),new cljs.core.Symbol(null,"*loaded-libs*","*loaded-libs*",1951428860,null),new cljs.core.Symbol(null,"EMPTY","EMPTY",-1786490468,null),new cljs.core.Symbol(null,"->TransientHashMap","->TransientHashMap",-534881892,null),new cljs.core.Symbol(null,"array-index-of-symbol?","array-index-of-symbol?",-99324516,null),new cljs.core.Symbol(null,"ArrayChunk","ArrayChunk",-1723882052,null),new cljs.core.Symbol(null,"sorted-map-by","sorted-map-by",218894812,null),new cljs.core.Symbol(null,"apply","apply",-1334050276,null),new cljs.core.Symbol(null,"get-global-hierarchy","get-global-hierarchy",1780260380,null),new cljs.core.Symbol(null,"add-to-string-hash-cache","add-to-string-hash-cache",-1620502980,null),new cljs.core.Symbol(null,"clj->js","clj->js",-1880244676,null),new cljs.core.Symbol(null,"TransientArrayMap","TransientArrayMap",1809645180,null),new cljs.core.Symbol(null,"->TransientVector","->TransientVector",-392772964,null),new cljs.core.Symbol(null,"IChunkedNext","IChunkedNext",1193289532,null),new cljs.core.Symbol(null,"interpose","interpose",-2078295140,null),new cljs.core.Symbol(null,"TransformerIterator","TransformerIterator",-1226795076,null),new cljs.core.Symbol(null,"->BlackNode","->BlackNode",1709225916,null),new cljs.core.Symbol(null,"deref","deref",1494944732,null),new cljs.core.Symbol(null,"pv-aget","pv-aget",1877752796,null),new cljs.core.Symbol(null,"assoc","assoc",2071440380,null),new cljs.core.Symbol(null,"transient","transient",899115069,null),new cljs.core.Symbol(null,"-disjoin","-disjoin",789814397,null),new cljs.core.Symbol(null,"chunk-cons","chunk-cons",433801405,null),new cljs.core.Symbol(null,"ArrayIter","ArrayIter",72450269,null),new cljs.core.Symbol(null,"comparator","comparator",-509539107,null),new cljs.core.Symbol(null,"print-prefix-map","print-prefix-map",1737660669,null),new cljs.core.Symbol(null,"sorted-map","sorted-map",-521216771,null),new cljs.core.Symbol(null,"drop-while","drop-while",719206685,null),new cljs.core.Symbol(null,"IWriter","IWriter",-1681087107,null),new cljs.core.Symbol(null,"KeySeq","KeySeq",-1097476739,null),new cljs.core.Symbol(null,"realized?","realized?",207229341,null),new cljs.core.Symbol(null,"*print-fn*","*print-fn*",138509853,null),new cljs.core.Symbol(null,"compare","compare",1109853757,null),new cljs.core.Symbol(null,"complement","complement",-913606051,null),new cljs.core.Symbol(null,"lookup-sentinel","lookup-sentinel",331711101,null),new cljs.core.Symbol(null,"-assoc!","-assoc!",1857497789,null),new cljs.core.Symbol(null,"*print-dup*","*print-dup*",103854877,null),new cljs.core.Symbol(null,"string-iter","string-iter",-745476227,null),new cljs.core.Symbol(null,"-key->js","-key->js",-156339331,null),new cljs.core.Symbol(null,"IDeref","IDeref",1738423197,null),new cljs.core.Symbol(null,"sequence","sequence",-1727628355,null),new cljs.core.Symbol(null,"constantly","constantly",-271143939,null),new cljs.core.Symbol(null,"->RangedIterator","->RangedIterator",1146874877,null),new cljs.core.Symbol(null,"chunked-seq","chunked-seq",-524681186,null),new cljs.core.Symbol(null,"ISorted","ISorted",-253627362,null),new cljs.core.Symbol(null,"make-array","make-array",-1135103906,null),new cljs.core.Symbol(null,"checked-aget","checked-aget",950823006,null),new cljs.core.Symbol(null,"shorts","shorts",107738238,null),new cljs.core.Symbol(null,"*unchecked-if*","*unchecked-if*",1542408350,null),new cljs.core.Symbol(null,"->RSeq","->RSeq",48834750,null),new cljs.core.Symbol(null,"enable-console-print!","enable-console-print!",1128662238,null),new cljs.core.Symbol(null,"-flush","-flush",666396894,null),new cljs.core.Symbol(null,"-lastIndexOf","-lastIndexOf",802973950,null),new cljs.core.Symbol(null,"completing","completing",565832990,null),new cljs.core.Symbol(null,"unchecked-negate-int","unchecked-negate-int",-825297602,null),new cljs.core.Symbol(null,"->PersistentVector","->PersistentVector",1436717470,null),new cljs.core.Symbol(null,"equiv-sequential","equiv-sequential",1288258974,null),new cljs.core.Symbol(null,"hash-unordered-coll","hash-unordered-coll",-240471618,null),new cljs.core.Symbol(null,"repeat","repeat",-1821743682,null),new cljs.core.Symbol(null,"unchecked-inc","unchecked-inc",-1170131490,null),new cljs.core.Symbol(null,"nthnext","nthnext",1677356670,null),new cljs.core.Symbol(null,"preserving-reduced","preserving-reduced",-1339828546,null),new cljs.core.Symbol(null,"get-validator","get-validator",-1350927682,null),new cljs.core.Symbol(null,"StringIter","StringIter",56917694,null),new cljs.core.Symbol(null,"number?","number?",-1747282210,null),new cljs.core.Symbol(null,"-conj!","-conj!",481699582,null),new cljs.core.Symbol(null,"->PersistentArrayMapSeq","->PersistentArrayMapSeq",-317193346,null),new cljs.core.Symbol(null,"chunk-next","chunk-next",-547810434,null),new cljs.core.Symbol(null,"ArrayList","ArrayList",-1071687810,null),new cljs.core.Symbol(null,"print-str","print-str",-699700354,null),new cljs.core.Symbol(null,"not-any?","not-any?",-2114707554,null),new cljs.core.Symbol(null,"into-array","into-array",-1875808354,null),new cljs.core.Symbol(null,"-hash","-hash",-630070274,null),new cljs.core.Symbol(null,"qualified-symbol?","qualified-symbol?",98763807,null),new cljs.core.Symbol(null,"-dissoc!","-dissoc!",-807915489,null),new cljs.core.Symbol(null,"->Reduced","->Reduced",-418187169,null),new cljs.core.Symbol(null,"chunk-buffer","chunk-buffer",789680287,null),new cljs.core.Symbol(null,"seqable?","seqable?",72462495,null),new cljs.core.Symbol(null,"symbol?","symbol?",1820680511,null),new cljs.core.Symbol(null,"m3-hash-unencoded-chars","m3-hash-unencoded-chars",1339254143,null),new cljs.core.Symbol(null,"unchecked-char","unchecked-char",1662742943,null),new cljs.core.Symbol(null,"system-time","system-time",1690633727,null),new cljs.core.Symbol(null,"NeverEquiv","NeverEquiv",-1321419265,null),new cljs.core.Symbol(null,"chunkIteratorSeq","chunkIteratorSeq",1822959135,null),new cljs.core.Symbol(null,"-invoke","-invoke",1821963807,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"fnext","fnext",1424835295,null),new cljs.core.Symbol(null,"IList","IList",1682281311,null),new cljs.core.Symbol(null,"ArrayNodeIterator","ArrayNodeIterator",-421093537,null),new cljs.core.Symbol(null,"List","List",-1919074465,null),new cljs.core.Symbol(null,"-val","-val",671367039,null),new cljs.core.Symbol(null,"bytes","bytes",-1478569089,null),new cljs.core.Symbol(null,"->ObjMap","->ObjMap",-958500929,null),new cljs.core.Symbol(null,"compare-symbols","compare-symbols",-329616449,null),new cljs.core.Symbol(null,"-seq","-seq",1019896831,null)],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","IEditableCollection","cljs.core/IEditableCollection",297050504,null),null,new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","ISet","cljs.core/ISet",2003412810,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ICloneable","cljs.core/ICloneable",-1712216461,null),null,new cljs.core.Symbol("cljs.core","IIterable","cljs.core/IIterable",178674073,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","ILookup","cljs.core/ILookup",-150575073,null),null], null), null),"cljs/core.cljs",(27),(10),new cljs.core.Keyword(null,"positional","positional",-203580463),(8784),(8784),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"hash-map","hash-map",-439030950,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","IEditableCollection","cljs.core/IEditableCollection",297050504,null),null,new cljs.core.Symbol("cljs.core","ISet","cljs.core/ISet",2003412810,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ICloneable","cljs.core/ICloneable",-1712216461,null),null,new cljs.core.Symbol("cljs.core","IIterable","cljs.core/IIterable",178674073,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","ILookup","cljs.core/ILookup",-150575073,null),null], null), null)]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","IEditableCollection","cljs.core/IEditableCollection",297050504,null),null,new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","ISet","cljs.core/ISet",2003412810,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ICloneable","cljs.core/ICloneable",-1712216461,null),null,new cljs.core.Symbol("cljs.core","IIterable","cljs.core/IIterable",178674073,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","ILookup","cljs.core/ILookup",-150575073,null),null], null), null),new cljs.core.Symbol("cljs.core","->PersistentHashSet","cljs.core/->PersistentHashSet",1931702507,null),false,"cljs/core.cljs",(27),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"hash-map","hash-map",-439030950,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null)),null,cljs.core.list(null,null),(1),new cljs.core.Keyword(null,"positional","positional",-203580463),(8784),(8784),(3),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"hash-map","hash-map",-439030950,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","IEditableCollection","cljs.core/IEditableCollection",297050504,null),null,new cljs.core.Symbol("cljs.core","ISet","cljs.core/ISet",2003412810,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ICloneable","cljs.core/ICloneable",-1712216461,null),null,new cljs.core.Symbol("cljs.core","IIterable","cljs.core/IIterable",178674073,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","ILookup","cljs.core/ILookup",-150575073,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(10280),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(10280),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(14),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Recursively transforms JavaScript arrays into ClojureScript\n  vectors, and JavaScript objects into ClojureScript maps.  With\n  option ':keywordize-keys true' will convert object fields from\n  strings to keywords.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),new cljs.core.Symbol("cljs.core","js->clj","cljs.core/js->clj",79692683,null),true,"cljs/core.cljs",(14),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(10280),(10280),(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null)], null)),"Recursively transforms JavaScript arrays into ClojureScript\n  vectors, and JavaScript objects into ClojureScript maps.  With\n  option ':keywordize-keys true' will convert object fields from\n  strings to keywords."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2414),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2414),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(14),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a sorted sequence of the items in coll, where the sort\n   order is determined by comparing (keyfn item).  Comp can be\n   boolean-valued comparison funcion, or a -/0/+ valued comparator.\n   Comp defaults to compare.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),new cljs.core.Symbol("cljs.core","sort-by","cljs.core/sort-by",424472669,null),false,"cljs/core.cljs",(14),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(2414),(2414),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"Returns a sorted sequence of the items in coll, where the sort\n   order is determined by comparing (keyfn item).  Comp can be\n   boolean-valued comparison funcion, or a -/0/+ valued comparator.\n   Comp defaults to compare."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"impls","impls",-1314014853),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[true,"cljs/core.cljs",(35),(14),(782),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-assoc!","-assoc!",1857497789,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tcoll","tcoll",-1341294481,null),new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null)], null)], null)], null)], null),(782),"Protocol for adding associativity to transient collections.",cljs.core.list("@interface")]),true,new cljs.core.Symbol("cljs.core","ITransientAssociative","cljs.core/ITransientAssociative",2006904029,null),"cljs/core.cljs",(35),(1),(782),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-assoc!","-assoc!",1857497789,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tcoll","tcoll",-1341294481,null),new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null)], null)], null)], null)], null),null,(782),new cljs.core.Symbol(null,"any","any",-948528346,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Symbol("cljs.core","TransientVector","cljs.core/TransientVector",-1152354525,null),null,new cljs.core.Symbol("cljs.core","TransientHashMap","cljs.core/TransientHashMap",-1872864404,null),null,new cljs.core.Symbol("cljs.core","TransientArrayMap","cljs.core/TransientArrayMap",1343364371,null),null], null), null),"Protocol for adding associativity to transient collections.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(3582),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(3582),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(18),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null)))], null),new cljs.core.Symbol("cljs.core","chunk-first","cljs.core/chunk-first",-1157877305,null),false,"cljs/core.cljs",(18),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null)),null,cljs.core.list(null,null),(1),(3582),(3582),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(9638),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(9638),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(27),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)], null)))], null),new cljs.core.Symbol("cljs.core","print-meta?","cljs.core/print-meta?",261609991,null),false,"cljs/core.cljs",(27),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)], null)),null,cljs.core.list(null,null),(1),(9638),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(9638),(2),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(918),new cljs.core.Keyword(null,"column","column",2078222095),(15),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(918),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(26),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"number","number",-1084057331,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"in","in",109346662,null)], null)))], null),new cljs.core.Symbol("cljs.core","m3-hash-int","cljs.core/m3-hash-int",-1216363315,null),false,"cljs/core.cljs",(26),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"in","in",109346662,null)], null)),null,cljs.core.list(null,null),(1),(918),new cljs.core.Symbol(null,"number","number",-1084057331,null),(918),(1),new cljs.core.Symbol(null,"number","number",-1084057331,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"in","in",109346662,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(866),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(866),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(14),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Support so that collections can implement toString without\n   loading all the printing machinery."], null),new cljs.core.Symbol("cljs.core","pr-str*","cljs.core/pr-str*",-126275477,null),false,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null)], null)),null,cljs.core.list(null,null),(1),(866),(866),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null)], null))),"Support so that collections can implement toString without\n   loading all the printing machinery."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(10223),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(10223),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(15),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xform*","xform*",264470622,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a reducible/iterable application of the transducers\n  to the items in coll. Transducers are applied in order as if\n  combined with comp. Note that these applications will be\n  performed every time reduce/iterator is called.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(0),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"xforms","xforms",2065058426,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"xforms","xforms",2065058426,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null),new cljs.core.Symbol("cljs.core","eduction","cljs.core/eduction",241633629,null),true,"cljs/core.cljs",(15),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(0),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"xforms","xforms",2065058426,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"xforms","xforms",2065058426,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"xforms","xforms",2065058426,null))], null),null,cljs.core.list(null),(1),(10223),(10223),(0),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"xforms","xforms",2065058426,null)], null)),"Returns a reducible/iterable application of the transducers\n  to the items in coll. Transducers are applied in order as if\n  combined with comp. Note that these applications will be\n  performed every time reduce/iterator is called."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(4910),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(4910),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(15),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"branch?","branch?",641208520,null),new cljs.core.Symbol(null,"children","children",699969545,null),new cljs.core.Symbol(null,"root","root",1191874074,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a lazy sequence of the nodes in a tree, via a depth-first walk.\n  branch? must be a fn of one arg that returns true if passed a node\n  that can have children (but may not).  children must be a fn of one\n  arg that returns a sequence of the children. Will only be called on\n  nodes for which branch? returns true. Root is the root node of the\n  tree."], null),new cljs.core.Symbol("cljs.core","tree-seq","cljs.core/tree-seq",-76832501,null),false,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"branch?","branch?",641208520,null),new cljs.core.Symbol(null,"children","children",699969545,null),new cljs.core.Symbol(null,"root","root",1191874074,null)], null)),null,cljs.core.list(null,null),(1),(4910),(4910),(3),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"branch?","branch?",641208520,null),new cljs.core.Symbol(null,"children","children",699969545,null),new cljs.core.Symbol(null,"root","root",1191874074,null)], null))),"Returns a lazy sequence of the nodes in a tree, via a depth-first walk.\n  branch? must be a fn of one arg that returns true if passed a node\n  that can have children (but may not).  children must be a fn of one\n  arg that returns a sequence of the children. Will only be called on\n  nodes for which branch? returns true. Root is the root node of the\n  tree."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2741),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2741),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(30),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)))], null),new cljs.core.Symbol("cljs.core","unchecked-remainder-int","cljs.core/unchecked-remainder-int",-1923905875,null),false,"cljs/core.cljs",(30),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),(1),(2741),(2741),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(10807),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(10807),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(11),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null)))], null),new cljs.core.Symbol("cljs.core","uuid","cljs.core/uuid",959287997,null),false,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null)),null,cljs.core.list(null,null),(1),(10807),(10807),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(1191),new cljs.core.Keyword(null,"column","column",2078222095),(12),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(1191),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(15),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"seq","seq",-177272256,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a seq on the collection. If the collection is\n  empty, returns nil.  (seq nil) returns nil. seq also works on\n  Strings."], null),new cljs.core.Symbol("cljs.core","seq","cljs.core/seq",-1649497689,null),false,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(1191),new cljs.core.Symbol(null,"seq","seq",-177272256,null),(1191),(1),new cljs.core.Symbol(null,"seq","seq",-177272256,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns a seq on the collection. If the collection is\n  empty, returns nil.  (seq nil) returns nil. seq also works on\n  Strings."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[(1),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol("cljs.core","IVolatile","cljs.core/IVolatile",1369627278,null),null,new cljs.core.Symbol("cljs.core","IDeref","cljs.core/IDeref",1331648568,null),null], null), null),new cljs.core.Symbol("cljs.core","Volatile","cljs.core/Volatile",-1098692185,null),"cljs/core.cljs",(18),true,(10),(4504),false,(4504),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","IDeref","cljs.core/IDeref",1331648568,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2471),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2471),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(13),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"f should be a function of 2 arguments. If val is not supplied,\n  returns the result of applying f to the first 2 items in coll, then\n  applying f to that result and the 3rd item, etc. If coll contains no\n  items, f must accept no arguments as well, and reduce returns the\n  result of calling f with no arguments.  If coll has only 1 item, it\n  is returned and f is not called.  If val is supplied, returns the\n  result of applying f to val and the first item in coll, then\n  applying f to that result and the 2nd item, etc. If coll contains no\n  items, returns val and f is not called.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),new cljs.core.Symbol("cljs.core","reduce","cljs.core/reduce",2025430439,null),false,"cljs/core.cljs",(13),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(2471),(2471),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"f should be a function of 2 arguments. If val is not supplied,\n  returns the result of applying f to the first 2 items in coll, then\n  applying f to that result and the 3rd item, etc. If coll contains no\n  items, f must accept no arguments as well, and reduce returns the\n  result of calling f with no arguments.  If coll has only 1 item, it\n  is returned and f is not called.  If val is supplied, returns the\n  result of applying f to val and the first item in coll, then\n  applying f to that result and the 2nd item, etc. If coll contains no\n  items, returns val and f is not called."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"impls","impls",-1314014853),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[true,"cljs/core.cljs",(19),(14),(10779),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),cljs.core.PersistentArrayMap.EMPTY], null),(10779),"A marker protocol for UUIDs",cljs.core.list("@interface")]),true,new cljs.core.Symbol("cljs.core","IUUID","cljs.core/IUUID",-1606521379,null),"cljs/core.cljs",(19),(1),(10779),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),cljs.core.PersistentArrayMap.EMPTY], null),null,(10779),new cljs.core.Symbol(null,"any","any",-948528346,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","UUID","cljs.core/UUID",-1279419460,null),null], null), null),"A marker protocol for UUIDs",cljs.core.list("@interface")]),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","INIT","cljs.core/INIT",1424279293,null),new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(3977),new cljs.core.Keyword(null,"column","column",2078222095),(1),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(3977),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(10),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(3977),new cljs.core.Keyword(null,"column","column",2078222095),(6),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(3977),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(10)], null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"object","object",-1179821820,null)], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(11139),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(11139),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(14),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the namespace named by the symbol or nil if it doesn't exist.\n  Bootstrap only."], null),new cljs.core.Symbol("cljs.core","find-ns","cljs.core/find-ns",-486459417,null),false,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null)], null)),null,cljs.core.list(null,null),(1),(11139),(11139),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null)], null))),"Returns the namespace named by the symbol or nil if it doesn't exist.\n  Bootstrap only."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2303),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2303),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(25),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if key is present in the given collection, otherwise\n  returns false.  Note that for numerically indexed collections like\n  vectors and arrays, this tests if the numeric key is within the\n  range of indexes. 'contains?' operates constant or logarithmic time;\n  it will not perform a linear search for a value.  See also 'some'."], null),new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),false,"cljs/core.cljs",(25),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),null,cljs.core.list(null,null),(1),(2303),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(2303),(2),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),"Returns true if key is present in the given collection, otherwise\n  returns false.  Note that for numerically indexed collections like\n  vectors and arrays, this tests if the numeric key is within the\n  range of indexes. 'contains?' operates constant or logarithmic time;\n  it will not perform a linear search for a value.  See also 'some'."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(4164),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(4164),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(22),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if (pred x) is logical true for every x in coll, else\n  false."], null),new cljs.core.Symbol("cljs.core","every?","cljs.core/every?",1416822717,null),false,"cljs/core.cljs",(22),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(4164),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(4164),(2),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns true if (pred x) is logical true for every x in coll, else\n  false."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null], null), null),"cljs/core.cljs",(24),(10),new cljs.core.Keyword(null,"positional","positional",-203580463),(1282),(1282),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"value","value",1946509744,null),new cljs.core.Symbol(null,"iter","iter",-1346195486,null),new cljs.core.Symbol(null,"_rest","_rest",-2100466189,null)], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null], null), null)]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null], null), null),new cljs.core.Symbol("cljs.core","->ES6IteratorSeq","cljs.core/->ES6IteratorSeq",1463012061,null),false,"cljs/core.cljs",(24),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"value","value",1946509744,null),new cljs.core.Symbol(null,"iter","iter",-1346195486,null),new cljs.core.Symbol(null,"_rest","_rest",-2100466189,null)], null)),null,cljs.core.list(null,null),(1),new cljs.core.Keyword(null,"positional","positional",-203580463),(1282),(1282),(3),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"value","value",1946509744,null),new cljs.core.Symbol(null,"iter","iter",-1346195486,null),new cljs.core.Symbol(null,"_rest","_rest",-2100466189,null)], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[(3),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","Fn","cljs.core/Fn",-695281833,null),null,new cljs.core.Symbol("cljs.core","IDeref","cljs.core/IDeref",1331648568,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null], null), null),new cljs.core.Symbol("cljs.core","Var","cljs.core/Var",2071014443,null),"cljs/core.cljs",(13),true,(10),(1099),false,(1099),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","IDeref","cljs.core/IDeref",1331648568,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(4526),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(4526),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(19),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a lazy sequence of the non-nil results of (f index item). Note,\n  this means false return values will be included.  f must be free of\n  side-effects.  Returns a stateful transducer when no collection is\n  provided.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),new cljs.core.Symbol("cljs.core","keep-indexed","cljs.core/keep-indexed",1480892647,null),false,"cljs/core.cljs",(19),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(4526),(4526),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"Returns a lazy sequence of the non-nil results of (f index item). Note,\n  this means false return values will be included.  f must be free of\n  side-effects.  Returns a stateful transducer when no collection is\n  provided."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","INext","cljs.core/INext",-113000046,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null], null), null),"cljs/core.cljs",(28),(10),new cljs.core.Keyword(null,"positional","positional",-203580463),(5901),(5901),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","INext","cljs.core/INext",-113000046,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null], null), null)]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","INext","cljs.core/INext",-113000046,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null], null), null),new cljs.core.Symbol("cljs.core","->PersistentQueueSeq","cljs.core/->PersistentQueueSeq",574066695,null),false,"cljs/core.cljs",(28),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null)),null,cljs.core.list(null,null),(1),new cljs.core.Keyword(null,"positional","positional",-203580463),(5901),(5901),(4),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","INext","cljs.core/INext",-113000046,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2937),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2937),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(11),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.Symbol(null,"start","start",1285322546,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the substring of s beginning at start inclusive, and ending\n  at end (defaults to length of string), exclusive.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.Symbol(null,"start","start",1285322546,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.Symbol(null,"start","start",1285322546,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),new cljs.core.Symbol("cljs.core","subs","cljs.core/subs",-1092266147,null),false,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.Symbol(null,"start","start",1285322546,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.Symbol(null,"start","start",1285322546,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.Symbol(null,"start","start",1285322546,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null)),null,cljs.core.list(null,null),(1),(2937),(2937),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.Symbol(null,"start","start",1285322546,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null)),"Returns the substring of s beginning at start inclusive, and ending\n  at end (defaults to length of string), exclusive."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"impls","impls",-1314014853),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[true,"cljs/core.cljs",(19),(14),(623),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-find","-find",1229817895,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null)], null)], null)], null),(623),"Protocol for implementing entry finding in collections.",cljs.core.list("@interface")]),true,new cljs.core.Symbol("cljs.core","IFind","cljs.core/IFind",-1727519574,null),"cljs/core.cljs",(19),(1),(623),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-find","-find",1229817895,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null)], null)], null)], null),null,(623),new cljs.core.Symbol(null,"any","any",-948528346,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [new cljs.core.Symbol("cljs.core","PersistentHashMap","cljs.core/PersistentHashMap",-454120575,null),null,new cljs.core.Symbol("cljs.core","ObjMap","cljs.core/ObjMap",799478018,null),null,new cljs.core.Symbol("cljs.core","PersistentArrayMap","cljs.core/PersistentArrayMap",1025194468,null),null,new cljs.core.Symbol("cljs.core","BlackNode","cljs.core/BlackNode",-1625498712,null),null,new cljs.core.Symbol("cljs.core","MapEntry","cljs.core/MapEntry",-858280599,null),null,new cljs.core.Symbol("cljs.core","Subvec","cljs.core/Subvec",621298762,null),null,new cljs.core.Symbol("cljs.core","PersistentVector","cljs.core/PersistentVector",-1211028272,null),null,new cljs.core.Symbol("cljs.core","PersistentTreeMap","cljs.core/PersistentTreeMap",998680439,null),null,new cljs.core.Symbol("cljs.core","RedNode","cljs.core/RedNode",-1367391329,null),null], null), null),"Protocol for implementing entry finding in collections.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(9040),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(9040),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(10),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a set of the distinct elements of coll."], null),new cljs.core.Symbol("cljs.core","set","cljs.core/set",724680876,null),false,"cljs/core.cljs",(10),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(9040),(9040),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns a set of the distinct elements of coll."]),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","MODULE_URIS","cljs.core/MODULE_URIS",-460053686,null),new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(39),new cljs.core.Keyword(null,"column","column",2078222095),(1),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(39),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(17),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(39),new cljs.core.Keyword(null,"column","column",2078222095),(6),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(39),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(17)], null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null)], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[true,"cljs/core.cljs",(32),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(4),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xs","xs",-2004992428,null),new cljs.core.Symbol(null,"ys","ys",1606115702,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xs","xs",-2004992428,null),new cljs.core.Symbol(null,"ys","ys",1606115702,null),new cljs.core.Symbol(null,"len","len",-1230778691,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xs","xs",-2004992428,null),new cljs.core.Symbol(null,"ys","ys",1606115702,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xs","xs",-2004992428,null),new cljs.core.Symbol(null,"ys","ys",1606115702,null),new cljs.core.Symbol(null,"len","len",-1230778691,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),(17),(2368),(2368),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xs","xs",-2004992428,null),new cljs.core.Symbol(null,"ys","ys",1606115702,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xs","xs",-2004992428,null),new cljs.core.Symbol(null,"ys","ys",1606115702,null),new cljs.core.Symbol(null,"len","len",-1230778691,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Compare indexed collection."]),true,new cljs.core.Symbol("cljs.core","compare-indexed","cljs.core/compare-indexed",-2043401908,null),false,"cljs/core.cljs",(32),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(4),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xs","xs",-2004992428,null),new cljs.core.Symbol(null,"ys","ys",1606115702,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xs","xs",-2004992428,null),new cljs.core.Symbol(null,"ys","ys",1606115702,null),new cljs.core.Symbol(null,"len","len",-1230778691,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xs","xs",-2004992428,null),new cljs.core.Symbol(null,"ys","ys",1606115702,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xs","xs",-2004992428,null),new cljs.core.Symbol(null,"ys","ys",1606115702,null),new cljs.core.Symbol(null,"len","len",-1230778691,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xs","xs",-2004992428,null),new cljs.core.Symbol(null,"ys","ys",1606115702,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xs","xs",-2004992428,null),new cljs.core.Symbol(null,"ys","ys",1606115702,null),new cljs.core.Symbol(null,"len","len",-1230778691,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),(1),(2368),(2368),(4),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xs","xs",-2004992428,null),new cljs.core.Symbol(null,"ys","ys",1606115702,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xs","xs",-2004992428,null),new cljs.core.Symbol(null,"ys","ys",1606115702,null),new cljs.core.Symbol(null,"len","len",-1230778691,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),"Compare indexed collection."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(4744),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(4744),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(16),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a seq of the last n items in coll.  Depending on the type\n  of coll may be no better than linear time.  For vectors, see also subvec."], null),new cljs.core.Symbol("cljs.core","take-last","cljs.core/take-last",374295804,null),false,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(4744),(4744),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns a seq of the last n items in coll.  Depending on the type\n  of coll may be no better than linear time.  For vectors, see also subvec."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"declared","declared",92336021),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(1174),new cljs.core.Keyword(null,"column","column",2078222095),(29),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(1174),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(39),new cljs.core.Keyword(null,"declared","declared",92336021),true], null),(3),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Symbol("cljs.core","IIndexed","cljs.core/IIndexed",-436490749,null),null,new cljs.core.Symbol("cljs.core","IReversible","cljs.core/IReversible",-1422278012,null),null,new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","ASeq","cljs.core/ASeq",1738946087,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),null,new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","INext","cljs.core/INext",-113000046,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ICloneable","cljs.core/ICloneable",-1712216461,null),null,new cljs.core.Symbol("cljs.core","IIterable","cljs.core/IIterable",178674073,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null),new cljs.core.Symbol("cljs.core","IndexedSeq","cljs.core/IndexedSeq",-228688698,null),"cljs/core.cljs",(20),true,(10),(1557),false,true,(1557),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [new cljs.core.Symbol("cljs.core","IIndexed","cljs.core/IIndexed",-436490749,null),null,new cljs.core.Symbol("cljs.core","IReversible","cljs.core/IReversible",-1422278012,null),null,new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","ASeq","cljs.core/ASeq",1738946087,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),null,new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","INext","cljs.core/INext",-113000046,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ICloneable","cljs.core/ICloneable",-1712216461,null),null,new cljs.core.Symbol("cljs.core","IIterable","cljs.core/IIterable",178674073,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2852),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2852),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(14),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Set bit at index n"], null),new cljs.core.Symbol("cljs.core","bit-set","cljs.core/bit-set",-512404180,null),false,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),(1),(2852),(2852),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Set bit at index n"]),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","string-hash-cache-count","cljs.core/string-hash-cache-count",140192204,null),new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(945),new cljs.core.Keyword(null,"column","column",2078222095),(1),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(945),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(29),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(945),new cljs.core.Keyword(null,"column","column",2078222095),(6),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(945),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(29)], null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"number","number",-1084057331,null)], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(3342),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(3342),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(34),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return true if x is a keyword with a namespace"], null),new cljs.core.Symbol("cljs.core","qualified-keyword?","cljs.core/qualified-keyword?",-308091478,null),false,"cljs/core.cljs",(34),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(3342),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(3342),(1),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Return true if x is a keyword with a namespace"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IPrintWithWriter","cljs.core/IPrintWithWriter",1349251417,null),null,new cljs.core.Symbol("cljs.core","IIterable","cljs.core/IIterable",178674073,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null),"cljs/core.cljs",(18),(10),new cljs.core.Keyword(null,"positional","positional",-203580463),(10193),(10193),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xform","xform",-85179481,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IPrintWithWriter","cljs.core/IPrintWithWriter",1349251417,null),null,new cljs.core.Symbol("cljs.core","IIterable","cljs.core/IIterable",178674073,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null)]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IPrintWithWriter","cljs.core/IPrintWithWriter",1349251417,null),null,new cljs.core.Symbol("cljs.core","IIterable","cljs.core/IIterable",178674073,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null),new cljs.core.Symbol("cljs.core","->Eduction","cljs.core/->Eduction",-1694159798,null),false,"cljs/core.cljs",(18),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xform","xform",-85179481,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),new cljs.core.Keyword(null,"positional","positional",-203580463),(10193),(10193),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xform","xform",-85179481,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IPrintWithWriter","cljs.core/IPrintWithWriter",1349251417,null),null,new cljs.core.Symbol("cljs.core","IIterable","cljs.core/IIterable",178674073,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(8269),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(8269),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(20),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"tree","tree",1444219499,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"found","found",1055831357,null)], null)))], null),true,new cljs.core.Symbol("cljs.core","tree-map-add","cljs.core/tree-map-add",-661687222,null),false,"cljs/core.cljs",(20),cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"tree","tree",1444219499,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"found","found",1055831357,null)], null)),null,cljs.core.list(null,null),(1),(8269),(8269),(5),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"tree","tree",1444219499,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"found","found",1055831357,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null], null), null),"cljs/core.cljs",(31),(10),new cljs.core.Keyword(null,"positional","positional",-203580463),(6244),(6244),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null))),null]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null], null), null),new cljs.core.Symbol("cljs.core","->ES6SetEntriesIterator","cljs.core/->ES6SetEntriesIterator",-402713012,null),false,"cljs/core.cljs",(31),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null)),null,cljs.core.list(null,null),(1),new cljs.core.Keyword(null,"positional","positional",-203580463),(6244),(6244),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null))),null]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),"cljs/core.cljs",(19),(9),(675),(675),new cljs.core.Symbol(null,"clj","clj",980036099,null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"o","o",290524299,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null))),"Returns a new object with value of o and metadata meta added to it."]),new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),new cljs.core.Symbol("cljs.core","-with-meta","cljs.core/-with-meta",-146937782,null),false,"cljs/core.cljs",(19),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"o","o",290524299,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null)),null,cljs.core.list(null,null),(1),(673),new cljs.core.Symbol(null,"clj","clj",980036099,null),(675),(2),new cljs.core.Symbol(null,"clj","clj",980036099,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"o","o",290524299,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null))),"Returns a new object with value of o and metadata meta added to it."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(10487),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(10487),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(19),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"method-cache","method-cache",1230193905,null),new cljs.core.Symbol(null,"method-table","method-table",-1878263165,null),new cljs.core.Symbol(null,"cached-hierarchy","cached-hierarchy",-1085460203,null),new cljs.core.Symbol(null,"hierarchy","hierarchy",587061186,null)], null)))], null),true,new cljs.core.Symbol("cljs.core","reset-cache","cljs.core/reset-cache",330259164,null),false,"cljs/core.cljs",(19),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"method-cache","method-cache",1230193905,null),new cljs.core.Symbol(null,"method-table","method-table",-1878263165,null),new cljs.core.Symbol(null,"cached-hierarchy","cached-hierarchy",-1085460203,null),new cljs.core.Symbol(null,"hierarchy","hierarchy",587061186,null)], null)),null,cljs.core.list(null,null),(1),(10487),(10487),(4),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"method-cache","method-cache",1230193905,null),new cljs.core.Symbol(null,"method-table","method-table",-1878263165,null),new cljs.core.Symbol(null,"cached-hierarchy","cached-hierarchy",-1085460203,null),new cljs.core.Symbol(null,"hierarchy","hierarchy",587061186,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null], null), null),"cljs/core.cljs",(36),(10),new cljs.core.Keyword(null,"positional","positional",-203580463),(6496),(6496),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null)], null))),null]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null], null), null),new cljs.core.Symbol("cljs.core","->PersistentArrayMapIterator","cljs.core/->PersistentArrayMapIterator",-498468724,null),false,"cljs/core.cljs",(36),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null)], null)),null,cljs.core.list(null,null),(1),new cljs.core.Keyword(null,"positional","positional",-203580463),(6496),(6496),(3),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null)], null))),null]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[(3),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null], null), null),new cljs.core.Symbol("cljs.core","PersistentArrayMapIterator","cljs.core/PersistentArrayMapIterator",2047083804,null),"cljs/core.cljs",(36),true,(10),(6496),false,(6496),null]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(9118),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(9118),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(14),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a seq of all but the last item in coll, in linear time"], null),new cljs.core.Symbol("cljs.core","butlast","cljs.core/butlast",1778584188,null),false,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null)),null,cljs.core.list(null,null),(1),(9118),(9118),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null))),"Return a seq of all but the last item in coll, in linear time"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(5083),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(5083),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(16),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pv","pv",1695555867,null)], null)))], null),true,new cljs.core.Symbol("cljs.core","tail-off","cljs.core/tail-off",-627015222,null),false,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pv","pv",1695555867,null)], null)),null,cljs.core.list(null,null),(1),(5083),(5083),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pv","pv",1695555867,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],["cljs/core.cljs",(37),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null)], null),(15),(2751),(2751),new cljs.core.Symbol(null,"number","number",-1084057331,null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null))),"If no ys are supplied, returns the negation of x, else subtracts\n  the ys from x and returns the result."]),new cljs.core.Symbol("cljs.core","unchecked-subtract-int","cljs.core/unchecked-subtract-int",-695292980,null),true,"cljs/core.cljs",(37),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null)),null,cljs.core.list(null,null,null),(1),(2751),new cljs.core.Symbol(null,"number","number",-1084057331,null),(2751),(2),new cljs.core.Symbol(null,"number","number",-1084057331,null),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),"If no ys are supplied, returns the negation of x, else subtracts\n  the ys from x and returns the result."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(856),new cljs.core.Keyword(null,"column","column",2078222095),(4),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(856),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(13),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Symbol("cljs.core","IIterable","cljs.core/IIterable",178674073,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an iterator for coll.",new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)))], null),new cljs.core.Symbol("cljs.core","IIterable","cljs.core/IIterable",178674073,null),new cljs.core.Symbol("cljs.core","-iterator","cljs.core/-iterator",1833427494,null),false,"cljs/core.cljs",(13),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(854),(856),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns an iterator for coll."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"dynamic","dynamic",704819571),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"doc","doc",1913296891)],[new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(129),new cljs.core.Keyword(null,"column","column",2078222095),(3),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(129),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(25),new cljs.core.Keyword(null,"dynamic","dynamic",704819571),true,new cljs.core.Keyword(null,"doc","doc",1913296891),"*print-namespace-maps* controls whether the printer will print\n  namespace map literal syntax.\n\n  Defaults to false, but the REPL binds it to true."], null),new cljs.core.Symbol("cljs.core","*print-namespace-maps*","cljs.core/*print-namespace-maps*",1331740198,null),"cljs/core.cljs",(25),(1),true,(123),(129),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"*print-namespace-maps* controls whether the printer will print\n  namespace map literal syntax.\n\n  Defaults to false, but the REPL binds it to true."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(9375),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(9375),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(15),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a lazy seq of every nth item in coll.  Returns a stateful\n  transducer when no collection is provided.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),new cljs.core.Symbol("cljs.core","take-nth","cljs.core/take-nth",2053562218,null),false,"cljs/core.cljs",(15),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(9375),(9375),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"Returns a lazy seq of every nth item in coll.  Returns a stateful\n  transducer when no collection is provided."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(1214),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(1214),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(12),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the first item in the collection. Calls seq on its\n  argument. If coll is nil, returns nil."], null),new cljs.core.Symbol("cljs.core","first","cljs.core/first",-752535972,null),false,"cljs/core.cljs",(12),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(1214),(1214),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns the first item in the collection. Calls seq on its\n  argument. If coll is nil, returns nil."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(269),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(269),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(33),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Internal - do not use!"], null),new cljs.core.Symbol("cljs.core","native-satisfies?","cljs.core/native-satisfies?",1482305036,null),false,"cljs/core.cljs",(33),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(269),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(269),(2),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Internal - do not use!"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2198),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2198),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(20),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return true if s satisfies ISeq"], null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),false,"cljs/core.cljs",(20),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null)),null,cljs.core.list(null,null),(1),(2198),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(2198),(1),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null))),"Return true if s satisfies ISeq"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(10377),new cljs.core.Keyword(null,"column","column",2078222095),(3),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(10377),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(20),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {*}"], null)], null),true,new cljs.core.Symbol("cljs.core","-global-hierarchy","cljs.core/-global-hierarchy",-1269910966,null),"cljs/core.cljs",(20),(1),(10374),(10377),new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {*}"], null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[(2),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","IPrintWithWriter","cljs.core/IPrintWithWriter",1349251417,null),null,new cljs.core.Symbol("cljs.core","IComparable","cljs.core/IComparable",1166626940,null),null,new cljs.core.Symbol("cljs.core","IUUID","cljs.core/IUUID",-1606521379,null),null], null), null),new cljs.core.Symbol("cljs.core","UUID","cljs.core/UUID",-1279419460,null),"cljs/core.cljs",(14),true,(10),(10781),false,(10781),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","IPrintWithWriter","cljs.core/IPrintWithWriter",1349251417,null),null,new cljs.core.Symbol("cljs.core","IComparable","cljs.core/IComparable",1166626940,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[new cljs.core.Symbol("cljs.core","ISorted","cljs.core/ISorted",-1734125647,null),"cljs/core.cljs",(25),(9),(727),(727),new cljs.core.Symbol(null,"clj","clj",980036099,null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"ascending?","ascending?",-1938452653,null)], null))),"Returns a sorted seq from coll in either ascending or descending order.\n     If ascending is true, the result should contain all items which are > or >=\n     than k. If ascending is false, the result should contain all items which\n     are < or <= than k, e.g.\n     (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)\n     (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)"]),new cljs.core.Symbol("cljs.core","ISorted","cljs.core/ISorted",-1734125647,null),new cljs.core.Symbol("cljs.core","-sorted-seq-from","cljs.core/-sorted-seq-from",-1635809402,null),false,"cljs/core.cljs",(25),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"ascending?","ascending?",-1938452653,null)], null)),null,cljs.core.list(null,null),(1),(722),new cljs.core.Symbol(null,"clj","clj",980036099,null),(727),(3),new cljs.core.Symbol(null,"clj","clj",980036099,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"ascending?","ascending?",-1938452653,null)], null))),"Returns a sorted seq from coll in either ascending or descending order.\n     If ascending is true, the result should contain all items which are > or >=\n     than k. If ascending is false, the result should contain all items which\n     are < or <= than k, e.g.\n     (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)\n     (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(9823),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(9823),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(18),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"objs","objs",-170194107,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"println to a string, returning it",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(0),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"objs","objs",-170194107,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"objs","objs",-170194107,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null),new cljs.core.Symbol("cljs.core","println-str","cljs.core/println-str",-576402454,null),true,"cljs/core.cljs",(18),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(0),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"objs","objs",-170194107,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"objs","objs",-170194107,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"objs","objs",-170194107,null))], null),null,cljs.core.list(null),(1),(9823),(9823),(0),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"objs","objs",-170194107,null)], null)),"println to a string, returning it"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(1373),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(1373),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(14),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"inst","inst",-2008473268,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return the number of milliseconds since January 1, 1970, 00:00:00 GMT"], null),new cljs.core.Symbol("cljs.core","inst-ms","cljs.core/inst-ms",-515575156,null),false,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"inst","inst",-2008473268,null)], null)),null,cljs.core.list(null,null),(1),(1373),(1373),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"inst","inst",-2008473268,null)], null))),"Return the number of milliseconds since January 1, 1970, 00:00:00 GMT"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(1810),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(1810),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(28),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"not-found","not-found",1011451547,null)], null))),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"not-found","not-found",1011451547,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"not-found","not-found",1011451547,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),true,new cljs.core.Symbol("cljs.core","linear-traversal-nth","cljs.core/linear-traversal-nth",803942918,null),false,"cljs/core.cljs",(28),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"not-found","not-found",1011451547,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"not-found","not-found",1011451547,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"not-found","not-found",1011451547,null)], null)),null,cljs.core.list(null,null),(1),(1810),(1810),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"not-found","not-found",1011451547,null)], null))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"added","added",2057651688),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(4806),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(4806),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(14),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects",new cljs.core.Keyword(null,"added","added",2057651688),"1.0"], null),"1.0",new cljs.core.Symbol("cljs.core","iterate","cljs.core/iterate",19572041,null),false,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(4806),(4806),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(469),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(469),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(21),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"idxs","idxs",-2145941206,null)], null))),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"idxs","idxs",-2145941206,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),true,new cljs.core.Symbol("cljs.core","checked-aget'","cljs.core/checked-aget'",1960922245,null),true,"cljs/core.cljs",(21),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"idxs","idxs",-2145941206,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null)], null)),null,cljs.core.list(null,null),(1),(469),(469),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"idxs","idxs",-2145941206,null)], null))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(566),new cljs.core.Keyword(null,"column","column",2078222095),(4),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(566),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(10),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an empty collection of the same category as coll. Used\n     by cljs.core/empty.",new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)))], null),new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),new cljs.core.Symbol("cljs.core","-empty","cljs.core/-empty",754474117,null),false,"cljs/core.cljs",(10),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(564),(566),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns an empty collection of the same category as coll. Used\n     by cljs.core/empty."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(9778),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(9778),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(14),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"opts","opts",1795607228,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Prints a newline using *print-fn*",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"opts","opts",1795607228,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"opts","opts",1795607228,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),new cljs.core.Symbol("cljs.core","newline","cljs.core/newline",-465886011,null),false,"cljs/core.cljs",(14),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"opts","opts",1795607228,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"opts","opts",1795607228,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"opts","opts",1795607228,null)], null)),null,cljs.core.list(null,null),(1),(9778),(9778),(1),true,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"opts","opts",1795607228,null)], null)),"Prints a newline using *print-fn*"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"impls","impls",-1314014853),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[true,"cljs/core.cljs",(21),(14),(608),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-lookup","-lookup",-1438393944,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"o","o",290524299,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"o","o",290524299,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"not-found","not-found",1011451547,null)], null)], null)], null)], null),(608),"Protocol for looking up a value in a data structure.",cljs.core.list("@interface")]),true,new cljs.core.Symbol("cljs.core","ILookup","cljs.core/ILookup",-150575073,null),"cljs/core.cljs",(21),(1),(608),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-lookup","-lookup",-1438393944,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"o","o",290524299,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"o","o",290524299,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"not-found","not-found",1011451547,null)], null)], null)], null)], null),null,(608),new cljs.core.Symbol(null,"any","any",-948528346,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Symbol("cljs.core","PersistentHashMap","cljs.core/PersistentHashMap",-454120575,null),null,new cljs.core.Symbol("cljs.core","ObjMap","cljs.core/ObjMap",799478018,null),null,new cljs.core.Symbol("cljs.core","TransientVector","cljs.core/TransientVector",-1152354525,null),null,new cljs.core.Symbol("cljs.core","PersistentArrayMap","cljs.core/PersistentArrayMap",1025194468,null),null,new cljs.core.Symbol("cljs.core","BlackNode","cljs.core/BlackNode",-1625498712,null),null,new cljs.core.Symbol("cljs.core","MapEntry","cljs.core/MapEntry",-858280599,null),null,new cljs.core.Symbol("cljs.core","Subvec","cljs.core/Subvec",621298762,null),null,new cljs.core.Symbol("cljs.core","TransientHashMap","cljs.core/TransientHashMap",-1872864404,null),null,new cljs.core.Symbol("cljs.core","TaggedLiteral","cljs.core/TaggedLiteral",-2005478516,null),null,new cljs.core.Symbol("cljs.tools.reader.impl.utils","ReaderConditional","cljs.tools.reader.impl.utils/ReaderConditional",-2077570001,null),null,new cljs.core.Symbol("cljs.core","PersistentVector","cljs.core/PersistentVector",-1211028272,null),null,new cljs.core.Symbol("cljs.core","TransientArrayMap","cljs.core/TransientArrayMap",1343364371,null),null,new cljs.core.Symbol("cljs.core","TransientHashSet","cljs.core/TransientHashSet",1070110581,null),null,new cljs.core.Symbol("cljs.core","PersistentHashSet","cljs.core/PersistentHashSet",-967232330,null),null,new cljs.core.Symbol("cljs.core","PersistentTreeMap","cljs.core/PersistentTreeMap",998680439,null),null,new cljs.core.Symbol("cljs.core","PersistentTreeSet","cljs.core/PersistentTreeSet",-2033838151,null),null,new cljs.core.Symbol("cljs.spec.alpha","t_cljs$spec$alpha14135","cljs.spec.alpha/t_cljs$spec$alpha14135",1715537370,null),null,new cljs.core.Symbol("cljs.core","RedNode","cljs.core/RedNode",-1367391329,null),null], null), null),"Protocol for looking up a value in a data structure.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(820),new cljs.core.Keyword(null,"column","column",2078222095),(4),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(820),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(17),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Symbol("cljs.core","IChunkedSeq","cljs.core/IChunkedSeq",-892943716,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a new collection of coll with the first chunk removed.",new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)))], null),new cljs.core.Symbol("cljs.core","IChunkedSeq","cljs.core/IChunkedSeq",-892943716,null),new cljs.core.Symbol("cljs.core","-chunked-rest","cljs.core/-chunked-rest",1793401951,null),false,"cljs/core.cljs",(17),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(816),(820),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Return a new collection of coll with the first chunk removed."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(9606),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(9606),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(16),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"writer","writer",1362963291,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"ss","ss",177481949,null)], null))),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"writer","writer",1362963291,null),new cljs.core.Symbol(null,"ss","ss",177481949,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"writer","writer",1362963291,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"ss","ss",177481949,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null),new cljs.core.Symbol("cljs.core","write-all","cljs.core/write-all",147036031,null),true,"cljs/core.cljs",(16),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"writer","writer",1362963291,null),new cljs.core.Symbol(null,"ss","ss",177481949,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"writer","writer",1362963291,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"ss","ss",177481949,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"writer","writer",1362963291,null),new cljs.core.Symbol(null,"ss","ss",177481949,null))], null),null,cljs.core.list(null),(1),(9606),(9606),(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"writer","writer",1362963291,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"ss","ss",177481949,null)], null))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(1977),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(1977),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(19),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return true if f is a JavaScript function or satisfies the Fn protocol."], null),new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null),false,"cljs/core.cljs",(19),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)),null,cljs.core.list(null,null),(1),(1977),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(1977),(1),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null))),"Return true if f is a JavaScript function or satisfies the Fn protocol."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(10546),new cljs.core.Keyword(null,"column","column",2078222095),(4),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(10546),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(18),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Symbol("cljs.core","IMultiFn","cljs.core/IMultiFn",1177212073,null),new cljs.core.Keyword(null,"doc","doc",1913296891),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"mf","mf",420183542,null),new cljs.core.Symbol(null,"dispatch-val","dispatch-val",69061000,null),new cljs.core.Symbol(null,"dispatch-val-y","dispatch-val-y",1016388320,null)], null)))], null),new cljs.core.Symbol("cljs.core","IMultiFn","cljs.core/IMultiFn",1177212073,null),new cljs.core.Symbol("cljs.core","-prefer-method","cljs.core/-prefer-method",1678227593,null),false,"cljs/core.cljs",(18),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"mf","mf",420183542,null),new cljs.core.Symbol(null,"dispatch-val","dispatch-val",69061000,null),new cljs.core.Symbol(null,"dispatch-val-y","dispatch-val-y",1016388320,null)], null)),null,cljs.core.list(null,null),(1),(10542),(10546),(3),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"mf","mf",420183542,null),new cljs.core.Symbol(null,"dispatch-val","dispatch-val",69061000,null),new cljs.core.Symbol(null,"dispatch-val-y","dispatch-val-y",1016388320,null)], null))),null]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[new cljs.core.Symbol("cljs.core","IAssociative","cljs.core/IAssociative",-1700920611,null),"cljs/core.cljs",(15),(9),(619),(619),new cljs.core.Symbol(null,"clj","clj",980036099,null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),"Returns a new collection of coll with a mapping from key k to\n     value v added to it."]),new cljs.core.Symbol("cljs.core","IAssociative","cljs.core/IAssociative",-1700920611,null),new cljs.core.Symbol("cljs.core","-assoc","cljs.core/-assoc",-814539323,null),false,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),null,cljs.core.list(null,null),(1),(614),new cljs.core.Symbol(null,"clj","clj",980036099,null),(619),(3),new cljs.core.Symbol(null,"clj","clj",980036099,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),"Returns a new collection of coll with a mapping from key k to\n     value v added to it."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(9516),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(9516),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(12),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"When lazy sequences are produced via functions that have side\n  effects, any effects other than those needed to produce the first\n  element in the seq do not occur until the seq is consumed. doall can\n  be used to force any effects. Walks through the successive nexts of\n  the seq, retains the head and returns it, thus causing the entire\n  seq to reside in memory at one time.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),new cljs.core.Symbol("cljs.core","doall","cljs.core/doall",1093272293,null),false,"cljs/core.cljs",(12),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(9516),(9516),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"When lazy sequences are produced via functions that have side\n  effects, any effects other than those needed to produce the first\n  element in the seq do not occur until the seq is consumed. doall can\n  be used to force any effects. Walks through the successive nexts of\n  the seq, retains the head and returns it, thus causing the entire\n  seq to reside in memory at one time."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(3293),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(3293),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(34),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Efficient test to determine that two keywords are identical."], null),new cljs.core.Symbol("cljs.core","keyword-identical?","cljs.core/keyword-identical?",1598491177,null),false,"cljs/core.cljs",(34),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null)),null,cljs.core.list(null,null),(1),(3293),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(3293),(2),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null))),"Efficient test to determine that two keywords are identical."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"dynamic","dynamic",704819571),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"doc","doc",1913296891)],[new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(75),new cljs.core.Keyword(null,"column","column",2078222095),(3),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(75),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(17),new cljs.core.Keyword(null,"doc","doc",1913296891),"Each runtime environment provides a different way to print error output.\n  Whatever function *print-err-fn* is bound to will be passed any\n  Strings which should be printed.",new cljs.core.Keyword(null,"dynamic","dynamic",704819571),true], null),new cljs.core.Symbol("cljs.core","*print-err-fn*","cljs.core/*print-err-fn*",1648367909,null),"cljs/core.cljs",(17),(1),true,(71),(75),new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"Each runtime environment provides a different way to print error output.\n  Whatever function *print-err-fn* is bound to will be passed any\n  Strings which should be printed."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(5077),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(5077),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(15),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null),new cljs.core.Symbol(null,"val","val",1769233139,null)], null)))], null),true,new cljs.core.Symbol("cljs.core","pv-aset","cljs.core/pv-aset",-566890145,null),false,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null),new cljs.core.Symbol(null,"val","val",1769233139,null)], null)),null,cljs.core.list(null,null),(1),(5077),(5077),(3),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null),new cljs.core.Symbol(null,"val","val",1769233139,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(10766),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(10766),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(14),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"multifn","multifn",-1904313150,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a multimethod, returns a map of preferred value -> set of other values"], null),new cljs.core.Symbol("cljs.core","prefers","cljs.core/prefers",-764228503,null),false,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"multifn","multifn",-1904313150,null)], null)),null,cljs.core.list(null,null),(1),(10766),(10766),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"multifn","multifn",-1904313150,null)], null))),"Given a multimethod, returns a map of preferred value -> set of other values"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(10278),new cljs.core.Keyword(null,"column","column",2078222095),(4),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(10278),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(12),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Symbol("cljs.core","IEncodeClojure","cljs.core/IEncodeClojure",1514086517,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Transforms JavaScript values to Clojure",new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"options","options",1740170016,null)], null)))], null),new cljs.core.Symbol("cljs.core","IEncodeClojure","cljs.core/IEncodeClojure",1514086517,null),new cljs.core.Symbol("cljs.core","-js->clj","cljs.core/-js->clj",-1748442871,null),false,"cljs/core.cljs",(12),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"options","options",1740170016,null)], null)),null,cljs.core.list(null,null),(1),(10277),(10278),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"options","options",1740170016,null)], null))),"Transforms JavaScript values to Clojure"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[(4),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","IPending","cljs.core/IPending",-1635423702,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","INext","cljs.core/INext",-113000046,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null),new cljs.core.Symbol("cljs.core","LazySeq","cljs.core/LazySeq",1986389673,null),"cljs/core.cljs",(17),true,(10),(3370),false,(3370),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","IPending","cljs.core/IPending",-1635423702,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","INext","cljs.core/INext",-113000046,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(10166),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(10166),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(13),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a lazy sequence removing consecutive duplicates in coll.\n  Returns a transducer when no collection is provided.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),new cljs.core.Symbol("cljs.core","dedupe","cljs.core/dedupe",-1145436503,null),false,"cljs/core.cljs",(13),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(10166),(10166),(1),true,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"Returns a lazy sequence removing consecutive duplicates in coll.\n  Returns a transducer when no collection is provided."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(5737),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(5737),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(36),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tv","tv",-164675832,null),new cljs.core.Symbol(null,"i","i",253690212,null)], null)))], null),true,new cljs.core.Symbol("cljs.core","unchecked-editable-array-for","cljs.core/unchecked-editable-array-for",1074571685,null),false,"cljs/core.cljs",(36),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tv","tv",-164675832,null),new cljs.core.Symbol(null,"i","i",253690212,null)], null)),null,cljs.core.list(null,null),(1),(5737),(5737),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tv","tv",-164675832,null),new cljs.core.Symbol(null,"i","i",253690212,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null], null), null),"cljs/core.cljs",(21),(10),new cljs.core.Keyword(null,"positional","positional",-203580463),(1266),(1266),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null))),null]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null], null), null),new cljs.core.Symbol("cljs.core","->ES6Iterator","cljs.core/->ES6Iterator",1315621609,null),false,"cljs/core.cljs",(21),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null)),null,cljs.core.list(null,null),(1),new cljs.core.Keyword(null,"positional","positional",-203580463),(1266),(1266),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null))),null]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[(2),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Symbol("cljs.core","VectorNode","cljs.core/VectorNode",-144126267,null),"cljs/core.cljs",(20),true,(10),(5069),false,(5069),null]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(1963),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(1963),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(13),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"ks","ks",-754231827,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"dissoc[iate]. Returns a new map of the same (hashed/sorted) type,\n  that does not contain a mapping for key(s).",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"ks","ks",-754231827,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null)], null)], null),new cljs.core.Symbol("cljs.core","dissoc","cljs.core/dissoc",-432349815,null),true,"cljs/core.cljs",(13),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"ks","ks",-754231827,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null)),null,cljs.core.list(null,null,null),(1),(1963),(1963),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"ks","ks",-754231827,null)], null)),"dissoc[iate]. Returns a new map of the same (hashed/sorted) type,\n  that does not contain a mapping for key(s)."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(4390),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(4390),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(11),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"validator","validator",-325659154,null)], null)], null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns an Atom with an initial value of x and zero or\n  more options (in any order):\n\n  :meta metadata-map\n\n  :validator validate-fn\n\n  If metadata-map is supplied, it will be come the metadata on the\n  atom. validate-fn must be nil or a side-effect-free fn of one\n  argument, which will be passed the intended new state on any state\n  change. If the new state is unacceptable, the validate-fn should\n  return false or throw an Error.  If either of these error conditions\n  occur, then the value of the atom will not change.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"validator","validator",-325659154,null)], null)], null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),new cljs.core.Symbol("cljs.core","atom","cljs.core/atom",1943839529,null),true,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"validator","validator",-325659154,null)], null)], null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(4390),(4390),(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"validator","validator",-325659154,null)], null)], null)], null)),"Creates and returns an Atom with an initial value of x and zero or\n  more options (in any order):\n\n  :meta metadata-map\n\n  :validator validate-fn\n\n  If metadata-map is supplied, it will be come the metadata on the\n  atom. validate-fn must be nil or a side-effect-free fn of one\n  argument, which will be passed the intended new state on any state\n  change. If the new state is unacceptable, the validate-fn should\n  return false or throw an Error.  If either of these error conditions\n  occur, then the value of the atom will not change."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2866),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2866),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(22),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Bitwise shift right"], null),new cljs.core.Symbol("cljs.core","bit-shift-right","cljs.core/bit-shift-right",1827903237,null),false,"cljs/core.cljs",(22),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),(1),(2866),(2866),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Bitwise shift right"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[(3),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 19, [new cljs.core.Symbol("cljs.core","IIndexed","cljs.core/IIndexed",-436490749,null),null,new cljs.core.Symbol("cljs.core","IVector","cljs.core/IVector",1711112835,null),null,new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","IFind","cljs.core/IFind",-1727519574,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","IStack","cljs.core/IStack",1746883636,null),null,new cljs.core.Symbol("cljs.core","IMapEntry","cljs.core/IMapEntry",535941300,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","IAssociative","cljs.core/IAssociative",-1700920611,null),null,new cljs.core.Symbol("cljs.core","ILookup","cljs.core/ILookup",-150575073,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null),new cljs.core.Symbol("cljs.core","MapEntry","cljs.core/MapEntry",-858280599,null),"cljs/core.cljs",(18),true,(10),(6335),false,(6335),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [new cljs.core.Symbol("cljs.core","IIndexed","cljs.core/IIndexed",-436490749,null),null,new cljs.core.Symbol("cljs.core","IVector","cljs.core/IVector",1711112835,null),null,new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","IStack","cljs.core/IStack",1746883636,null),null,new cljs.core.Symbol("cljs.core","IMapEntry","cljs.core/IMapEntry",535941300,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","IAssociative","cljs.core/IAssociative",-1700920611,null),null,new cljs.core.Symbol("cljs.core","ILookup","cljs.core/ILookup",-150575073,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null)]),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","*clojurescript-version*","cljs.core/*clojurescript-version*",-677501969,null),new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(19),new cljs.core.Keyword(null,"column","column",2078222095),(1),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(19),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(29),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(19),new cljs.core.Keyword(null,"column","column",2078222095),(6),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(19),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(29)], null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"string","string",-349010059,null)], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(592),new cljs.core.Keyword(null,"column","column",2078222095),(4),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(592),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(10),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the first item in the collection coll. Used by cljs.core/first.",new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)))], null),new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),new cljs.core.Symbol("cljs.core","-first","cljs.core/-first",545297391,null),false,"cljs/core.cljs",(10),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(590),(592),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns the first item in the collection coll. Used by cljs.core/first."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2051),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2051),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(11),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"For a list or queue, same as first, for a vector, same as, but much\n  more efficient than, last. If the collection is empty, returns nil."], null),new cljs.core.Symbol("cljs.core","peek","cljs.core/peek",942197903,null),false,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(2051),(2051),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"For a list or queue, same as first, for a vector, same as, but much\n  more efficient than, last. If the collection is empty, returns nil."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"impls","impls",-1314014853),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[true,"cljs/core.cljs",(23),(14),(686),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-kv-reduce","-kv-reduce",456218795,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"init","init",-234949907,null)], null)], null)], null)], null),(686),"Protocol for associative types that can reduce themselves\n  via a function of key and val. Called by cljs.core/reduce-kv.",cljs.core.list("@interface")]),true,new cljs.core.Symbol("cljs.core","IKVReduce","cljs.core/IKVReduce",878013381,null),"cljs/core.cljs",(23),(1),(686),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-kv-reduce","-kv-reduce",456218795,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"init","init",-234949907,null)], null)], null)], null)], null),null,(686),new cljs.core.Symbol(null,"any","any",-948528346,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Symbol("cljs.core","PersistentHashMap","cljs.core/PersistentHashMap",-454120575,null),null,new cljs.core.Symbol("cljs.core","ObjMap","cljs.core/ObjMap",799478018,null),null,new cljs.core.Symbol("cljs.core","PersistentArrayMap","cljs.core/PersistentArrayMap",1025194468,null),null,new cljs.core.Symbol("cljs.core","Subvec","cljs.core/Subvec",621298762,null),null,new cljs.core.Symbol("cljs.core","PersistentVector","cljs.core/PersistentVector",-1211028272,null),null,new cljs.core.Symbol("cljs.core","PersistentTreeMap","cljs.core/PersistentTreeMap",998680439,null),null], null), null),"Protocol for associative types that can reduce themselves\n  via a function of key and val. Called by cljs.core/reduce-kv.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2448),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2448),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(19),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"init","init",-234949907,null)], null))),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"init","init",-234949907,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"init","init",-234949907,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),true,new cljs.core.Symbol("cljs.core","iter-reduce","cljs.core/iter-reduce",158667311,null),false,"cljs/core.cljs",(19),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"init","init",-234949907,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"init","init",-234949907,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"init","init",-234949907,null)], null)),null,cljs.core.list(null,null),(1),(2448),(2448),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"init","init",-234949907,null)], null))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(485),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(485),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(11),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"idxs","idxs",-2145941206,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the value at the index/indices. Works on JavaScript arrays.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"idxs","idxs",-2145941206,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),new cljs.core.Symbol("cljs.core","aget","cljs.core/aget",6345791,null),true,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"idxs","idxs",-2145941206,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null)], null)),null,cljs.core.list(null,null),(1),(485),(485),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"array","array",-440182315,null),new cljs.core.Symbol(null,"idx","idx",-1600747296,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"idxs","idxs",-2145941206,null)], null)),"Returns the value at the index/indices. Works on JavaScript arrays."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[(5),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),null,new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","INext","cljs.core/INext",-113000046,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null),new cljs.core.Symbol("cljs.core","PersistentTreeMapSeq","cljs.core/PersistentTreeMapSeq",-552308673,null),"cljs/core.cljs",(30),true,(10),(7814),false,(7814),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),null,new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","INext","cljs.core/INext",-113000046,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(741),new cljs.core.Keyword(null,"column","column",2078222095),(4),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(741),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(10),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Symbol("cljs.core","IWriter","cljs.core/IWriter",-1282590490,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Writes s with writer and returns the result.",new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"writer","writer",1362963291,null),new cljs.core.Symbol(null,"s","s",-948495851,null)], null)))], null),new cljs.core.Symbol("cljs.core","IWriter","cljs.core/IWriter",-1282590490,null),new cljs.core.Symbol("cljs.core","-write","cljs.core/-write",527220517,null),false,"cljs/core.cljs",(10),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"writer","writer",1362963291,null),new cljs.core.Symbol(null,"s","s",-948495851,null)], null)),null,cljs.core.list(null,null),(1),(739),(741),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"writer","writer",1362963291,null),new cljs.core.Symbol(null,"s","s",-948495851,null)], null))),"Writes s with writer and returns the result."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(4001),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(4001),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(11),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)))], null),new cljs.core.Symbol("cljs.core","iter","cljs.core/iter",-2021438711,null),false,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(4001),(4001),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(9222),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(9222),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(18),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"sc","sc",-1506412737,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)))], null),new cljs.core.Symbol("cljs.core","mk-bound-fn","cljs.core/mk-bound-fn",-148554584,null),false,"cljs/core.cljs",(18),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"sc","sc",-1506412737,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),null,cljs.core.list(null,null),(1),(9222),(9222),(3),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"sc","sc",-1506412737,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(1750),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(1750),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(11),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return the last item in coll, in linear time"], null),new cljs.core.Symbol("cljs.core","last","cljs.core/last",1273893704,null),false,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null)),null,cljs.core.list(null,null),(1),(1750),(1750),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null))),"Return the last item in coll, in linear time"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(10550),new cljs.core.Keyword(null,"column","column",2078222095),(4),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(10550),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(25),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Symbol("cljs.core","IMultiFn","cljs.core/IMultiFn",1177212073,null),new cljs.core.Keyword(null,"doc","doc",1913296891),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"mf","mf",420183542,null)], null)))], null),new cljs.core.Symbol("cljs.core","IMultiFn","cljs.core/IMultiFn",1177212073,null),new cljs.core.Symbol("cljs.core","-default-dispatch-val","cljs.core/-default-dispatch-val",-613022588,null),false,"cljs/core.cljs",(25),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"mf","mf",420183542,null)], null)),null,cljs.core.list(null,null),(1),(10542),(10550),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"mf","mf",420183542,null)], null))),null]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(9796),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(9796),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(9),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"objs","objs",-170194107,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Prints the object(s) using string-print.  Prints the\n  object(s), separated by spaces if there is more than one.\n  By default, pr and prn print in a way that objects can be\n  read by the reader",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(0),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"objs","objs",-170194107,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"objs","objs",-170194107,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null),new cljs.core.Symbol("cljs.core","pr","cljs.core/pr",1715302632,null),true,"cljs/core.cljs",(9),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(0),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"objs","objs",-170194107,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"objs","objs",-170194107,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"objs","objs",-170194107,null))], null),null,cljs.core.list(null),(1),(9796),(9796),(0),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"objs","objs",-170194107,null)], null)),"Prints the object(s) using string-print.  Prints the\n  object(s), separated by spaces if there is more than one.\n  By default, pr and prn print in a way that objects can be\n  read by the reader"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(7807),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(7807),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(25),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol(null,"stack","stack",847125597,null),new cljs.core.Symbol(null,"ascending?","ascending?",-1938452653,null)], null)))], null),true,new cljs.core.Symbol("cljs.core","tree-map-seq-push","cljs.core/tree-map-seq-push",-1212010104,null),false,"cljs/core.cljs",(25),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol(null,"stack","stack",847125597,null),new cljs.core.Symbol(null,"ascending?","ascending?",-1938452653,null)], null)),null,cljs.core.list(null,null),(1),(7807),(7807),(3),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol(null,"stack","stack",847125597,null),new cljs.core.Symbol(null,"ascending?","ascending?",-1938452653,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(3311),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(3311),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(16),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the namespace String of a symbol or keyword, or nil if not present."], null),new cljs.core.Symbol("cljs.core","namespace","cljs.core/namespace",1653264270,null),false,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(3311),(3311),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Returns the namespace String of a symbol or keyword, or nil if not present."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223)],[new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(1340),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(1340),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(36),new cljs.core.Keyword(null,"private","private",-558947994),true], null),true,new cljs.core.Symbol("cljs.core","empty-unordered-hash","cljs.core/empty-unordered-hash",-842273762,null),"cljs/core.cljs",(36),(1),(1340),(1340),new cljs.core.Symbol(null,"number","number",-1084057331,null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(8548),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(8548),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(14),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"keyvals","keyvals",-2067234787,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"keyval => key val\n  Returns a new object map with supplied mappings.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(0),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"keyvals","keyvals",-2067234787,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"keyvals","keyvals",-2067234787,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null),new cljs.core.Symbol("cljs.core","obj-map","cljs.core/obj-map",1948374788,null),true,"cljs/core.cljs",(14),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(0),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"keyvals","keyvals",-2067234787,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"keyvals","keyvals",-2067234787,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"keyvals","keyvals",-2067234787,null))], null),null,cljs.core.list(null),(1),(8548),(8548),(0),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"keyvals","keyvals",-2067234787,null)], null)),"keyval => key val\n  Returns a new object map with supplied mappings."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[(1),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","IDeref","cljs.core/IDeref",1331648568,null),null], null), null),new cljs.core.Symbol("cljs.core","Reduced","cljs.core/Reduced",971663396,null),"cljs/core.cljs",(17),true,(10),(1406),false,(1406),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","IDeref","cljs.core/IDeref",1331648568,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),"cljs/core.cljs",(14),(9),(572),(572),new cljs.core.Symbol(null,"clj","clj",980036099,null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"o","o",290524299,null)], null))),"Returns a new collection of coll with o added to it. The new item\n     should be added to the most efficient place, e.g.\n     (conj [1 2 3 4] 5) => [1 2 3 4 5]\n     (conj '(2 3 4 5) 1) => '(1 2 3 4 5)"]),new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),new cljs.core.Symbol("cljs.core","-conj","cljs.core/-conj",2040622670,null),false,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"o","o",290524299,null)], null)),null,cljs.core.list(null,null),(1),(570),new cljs.core.Symbol(null,"clj","clj",980036099,null),(572),(2),new cljs.core.Symbol(null,"clj","clj",980036099,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"o","o",290524299,null)], null))),"Returns a new collection of coll with o added to it. The new item\n     should be added to the most efficient place, e.g.\n     (conj [1 2 3 4] 5) => [1 2 3 4 5]\n     (conj '(2 3 4 5) 1) => '(1 2 3 4 5)"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[(5),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","INext","cljs.core/INext",-113000046,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null),new cljs.core.Symbol("cljs.core","NodeSeq","cljs.core/NodeSeq",1136673444,null),"cljs/core.cljs",(17),true,(10),(7370),false,(7370),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","INext","cljs.core/INext",-113000046,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],["cljs/core.cljs",(17),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null)], null),(16),(1247),(1247),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null))),"Equality. Returns true if x equals y, false if not. Compares\n  numbers and collections in a type-independent manner.  Clojure's immutable data\n  structures define -equiv (and thus =) as a value, not an identity,\n  comparison."]),new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),true,"cljs/core.cljs",(17),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null)),null,cljs.core.list(null,null,null),(1),(1247),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(1247),(2),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),"Equality. Returns true if x equals y, false if not. Compares\n  numbers and collections in a type-independent manner.  Clojure's immutable data\n  structures define -equiv (and thus =) as a value, not an identity,\n  comparison."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"impls","impls",-1314014853),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[true,"cljs/core.cljs",(27),(14),(788),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-dissoc!","-dissoc!",-807915489,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tcoll","tcoll",-1341294481,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)], null)], null)], null),(788),"Protocol for adding mapping functionality to transient collections.",cljs.core.list("@interface")]),true,new cljs.core.Symbol("cljs.core","ITransientMap","cljs.core/ITransientMap",965243528,null),"cljs/core.cljs",(27),(1),(788),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-dissoc!","-dissoc!",-807915489,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tcoll","tcoll",-1341294481,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)], null)], null)], null),null,(788),new cljs.core.Symbol(null,"any","any",-948528346,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol("cljs.core","TransientHashMap","cljs.core/TransientHashMap",-1872864404,null),null,new cljs.core.Symbol("cljs.core","TransientArrayMap","cljs.core/TransientArrayMap",1343364371,null),null], null), null),"Protocol for adding mapping functionality to transient collections.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(5099),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(5099),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(17),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pv","pv",1695555867,null),new cljs.core.Symbol(null,"level","level",-1363938217,null),new cljs.core.Symbol(null,"parent","parent",761652748,null),new cljs.core.Symbol(null,"tailnode","tailnode",-355628741,null)], null)))], null),true,new cljs.core.Symbol("cljs.core","push-tail","cljs.core/push-tail",1950225550,null),false,"cljs/core.cljs",(17),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pv","pv",1695555867,null),new cljs.core.Symbol(null,"level","level",-1363938217,null),new cljs.core.Symbol(null,"parent","parent",761652748,null),new cljs.core.Symbol(null,"tailnode","tailnode",-355628741,null)], null)),null,cljs.core.list(null,null),(1),(5099),(5099),(4),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pv","pv",1695555867,null),new cljs.core.Symbol(null,"level","level",-1363938217,null),new cljs.core.Symbol(null,"parent","parent",761652748,null),new cljs.core.Symbol(null,"tailnode","tailnode",-355628741,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(4687),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(4687),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(11),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a lazy sequence of the first n items in coll, or all items if\n  there are fewer than n.  Returns a stateful transducer when\n  no collection is provided.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),new cljs.core.Symbol("cljs.core","take","cljs.core/take",439591112,null),false,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(4687),(4687),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"Returns a lazy sequence of the first n items in coll, or all items if\n  there are fewer than n.  Returns a stateful transducer when\n  no collection is provided."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2132),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2132),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(23),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return true if x satisfies IVector"], null),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),false,"cljs/core.cljs",(23),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(2132),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(2132),(1),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Return true if x satisfies IVector"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(6294),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(6294),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(29),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null)))], null),true,new cljs.core.Symbol("cljs.core","array-index-of-equiv?","cljs.core/array-index-of-equiv?",-602275490,null),false,"cljs/core.cljs",(29),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null)),null,cljs.core.list(null,null),(1),(6294),(6294),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(6832),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(6832),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(33),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"bitmap","bitmap",501334601,null),new cljs.core.Symbol(null,"bit","bit",1708448927,null)], null)))], null),true,new cljs.core.Symbol("cljs.core","bitmap-indexed-node-index","cljs.core/bitmap-indexed-node-index",-99707794,null),false,"cljs/core.cljs",(33),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"bitmap","bitmap",501334601,null),new cljs.core.Symbol(null,"bit","bit",1708448927,null)], null)),null,cljs.core.list(null,null),(1),(6832),(6832),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"bitmap","bitmap",501334601,null),new cljs.core.Symbol(null,"bit","bit",1708448927,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2213),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2213),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(23),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerce to boolean"], null),new cljs.core.Symbol("cljs.core","boolean","cljs.core/boolean",-1222483266,null),false,"cljs/core.cljs",(23),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(2213),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(2213),(1),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Coerce to boolean"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"impls","impls",-1314014853),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[true,"cljs/core.cljs",(20),(14),(811),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-drop-first","-drop-first",-2095262076,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)], null)], null)], null),(811),"Protocol for accessing the items of a chunk.",cljs.core.list("@interface")]),true,new cljs.core.Symbol("cljs.core","IChunk","cljs.core/IChunk",357422046,null),"cljs/core.cljs",(20),(1),(811),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-drop-first","-drop-first",-2095262076,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)], null)], null)], null),null,(811),new cljs.core.Symbol(null,"any","any",-948528346,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","ArrayChunk","cljs.core/ArrayChunk",-1023606567,null),null], null), null),"Protocol for accessing the items of a chunk.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2862),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2862),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(21),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Bitwise shift left"], null),new cljs.core.Symbol("cljs.core","bit-shift-left","cljs.core/bit-shift-left",-342508802,null),false,"cljs/core.cljs",(21),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),(1),(2862),(2862),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Bitwise shift left"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(10811),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(10811),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(18),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null),new cljs.core.Symbol("cljs.core","random-uuid","cljs.core/random-uuid",1256838686,null),false,"cljs/core.cljs",(18),cljs.core.list(cljs.core.PersistentVector.EMPTY),null,cljs.core.list(null,null),(1),(10811),(10811),(0),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(264),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(264),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(20),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if given any argument."], null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),false,"cljs/core.cljs",(20),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(264),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(264),(1),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Returns true if given any argument."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(10347),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(10347),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(15),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a random integer between 0 (inclusive) and n (exclusive)."], null),new cljs.core.Symbol("cljs.core","rand-int","cljs.core/rand-int",901720936,null),false,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),(1),(10347),(10347),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Returns a random integer between 0 (inclusive) and n (exclusive)."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(415),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(415),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(13),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a javascript array, cloned from the passed in array"], null),new cljs.core.Symbol("cljs.core","aclone","cljs.core/aclone",-758078968,null),false,"cljs/core.cljs",(13),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null)),null,cljs.core.list(null,null),(1),(415),(415),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null))),"Returns a javascript array, cloned from the passed in array"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"declared","declared",92336021),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(7886),new cljs.core.Keyword(null,"column","column",2078222095),(18),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(7886),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(27),new cljs.core.Keyword(null,"declared","declared",92336021),true], null),(5),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 19, [new cljs.core.Symbol("cljs.core","IIndexed","cljs.core/IIndexed",-436490749,null),null,new cljs.core.Symbol("cljs.core","IVector","cljs.core/IVector",1711112835,null),null,new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","IFind","cljs.core/IFind",-1727519574,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","IStack","cljs.core/IStack",1746883636,null),null,new cljs.core.Symbol("cljs.core","IMapEntry","cljs.core/IMapEntry",535941300,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","IAssociative","cljs.core/IAssociative",-1700920611,null),null,new cljs.core.Symbol("cljs.core","ILookup","cljs.core/ILookup",-150575073,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null),new cljs.core.Symbol("cljs.core","BlackNode","cljs.core/BlackNode",-1625498712,null),"cljs/core.cljs",(19),true,(10),(7986),false,true,(7986),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [new cljs.core.Symbol("cljs.core","IIndexed","cljs.core/IIndexed",-436490749,null),null,new cljs.core.Symbol("cljs.core","IVector","cljs.core/IVector",1711112835,null),null,new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","IStack","cljs.core/IStack",1746883636,null),null,new cljs.core.Symbol("cljs.core","IMapEntry","cljs.core/IMapEntry",535941300,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","IAssociative","cljs.core/IAssociative",-1700920611,null),null,new cljs.core.Symbol("cljs.core","ILookup","cljs.core/ILookup",-150575073,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(4521),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(4521),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(14),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vol","vol",1137570949,null),new cljs.core.Symbol(null,"newval","newval",717803975,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Sets the value of volatile to newval without regard for the\n   current value. Returns newval."], null),new cljs.core.Symbol("cljs.core","vreset!","cljs.core/vreset!",-1308835928,null),false,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vol","vol",1137570949,null),new cljs.core.Symbol(null,"newval","newval",717803975,null)], null)),null,cljs.core.list(null,null),(1),(4521),(4521),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vol","vol",1137570949,null),new cljs.core.Symbol(null,"newval","newval",717803975,null)], null))),"Sets the value of volatile to newval without regard for the\n   current value. Returns newval."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(3579),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(3579),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(12),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"b","b",-1172211299,null)], null)))], null),new cljs.core.Symbol("cljs.core","chunk","cljs.core/chunk",847936424,null),false,"cljs/core.cljs",(12),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"b","b",-1172211299,null)], null)),null,cljs.core.list(null,null),(1),(3579),(3579),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"b","b",-1172211299,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2644),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2644),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(10),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a number one less than num."], null),new cljs.core.Symbol("cljs.core","dec","cljs.core/dec",-443230268,null),false,"cljs/core.cljs",(10),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(2644),(2644),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Returns a number one less than num."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null], null), null),"cljs/core.cljs",(29),(10),new cljs.core.Keyword(null,"positional","positional",-203580463),(4083),(4083),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"buffer","buffer",-2037140571,null),new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.Symbol(null,"completed","completed",1154475024,null),new cljs.core.Symbol(null,"xf","xf",2042434515,null),new cljs.core.Symbol(null,"sourceIter","sourceIter",1068220306,null),new cljs.core.Symbol(null,"multi","multi",1450238522,null)], null))),null]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null], null), null),new cljs.core.Symbol("cljs.core","->TransformerIterator","cljs.core/->TransformerIterator",-1527984600,null),false,"cljs/core.cljs",(29),cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"buffer","buffer",-2037140571,null),new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.Symbol(null,"completed","completed",1154475024,null),new cljs.core.Symbol(null,"xf","xf",2042434515,null),new cljs.core.Symbol(null,"sourceIter","sourceIter",1068220306,null),new cljs.core.Symbol(null,"multi","multi",1450238522,null)], null)),null,cljs.core.list(null,null),(1),new cljs.core.Keyword(null,"positional","positional",-203580463),(4083),(4083),(6),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"buffer","buffer",-2037140571,null),new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.Symbol(null,"completed","completed",1154475024,null),new cljs.core.Symbol(null,"xf","xf",2042434515,null),new cljs.core.Symbol(null,"sourceIter","sourceIter",1068220306,null),new cljs.core.Symbol(null,"multi","multi",1450238522,null)], null))),null]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"impls","impls",-1314014853),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[true,"cljs/core.cljs",(31),(14),(5204),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),cljs.core.PersistentArrayMap.EMPTY], null),(5204),"Marker protocol",cljs.core.list("@interface")]),true,new cljs.core.Symbol("cljs.core","APersistentVector","cljs.core/APersistentVector",-1809416799,null),"cljs/core.cljs",(31),(1),(5204),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),cljs.core.PersistentArrayMap.EMPTY], null),null,(5204),new cljs.core.Symbol(null,"any","any",-948528346,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","PersistentVector","cljs.core/PersistentVector",-1211028272,null),null], null), null),"Marker protocol",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(4640),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(4640),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(10),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"c1","c1",-1521904966,null),new cljs.core.Symbol(null,"c2","c2",78651156,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"c1","c1",-1521904966,null),new cljs.core.Symbol(null,"c2","c2",78651156,null),new cljs.core.Symbol(null,"c3","c3",468715789,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"c1","c1",-1521904966,null),new cljs.core.Symbol(null,"c2","c2",78651156,null),new cljs.core.Symbol(null,"c3","c3",468715789,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"colls","colls",-397642425,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a lazy sequence consisting of the result of applying f to\n  the set of first items of each coll, followed by applying f to the\n  set of second items in each coll, until any one of the colls is\n  exhausted.  Any remaining items in other colls are ignored. Function\n  f should accept number-of-colls arguments. Returns a transducer when\n  no collection is provided.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(4),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"c1","c1",-1521904966,null),new cljs.core.Symbol(null,"c2","c2",78651156,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"c1","c1",-1521904966,null),new cljs.core.Symbol(null,"c2","c2",78651156,null),new cljs.core.Symbol(null,"c3","c3",468715789,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"c1","c1",-1521904966,null),new cljs.core.Symbol(null,"c2","c2",78651156,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"c1","c1",-1521904966,null),new cljs.core.Symbol(null,"c2","c2",78651156,null),new cljs.core.Symbol(null,"c3","c3",468715789,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"c1","c1",-1521904966,null),new cljs.core.Symbol(null,"c2","c2",78651156,null),new cljs.core.Symbol(null,"c3","c3",468715789,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"colls","colls",-397642425,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null,null,null)], null)], null),new cljs.core.Symbol("cljs.core","map","cljs.core/map",-338988913,null),true,"cljs/core.cljs",(10),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(4),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"c1","c1",-1521904966,null),new cljs.core.Symbol(null,"c2","c2",78651156,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"c1","c1",-1521904966,null),new cljs.core.Symbol(null,"c2","c2",78651156,null),new cljs.core.Symbol(null,"c3","c3",468715789,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"c1","c1",-1521904966,null),new cljs.core.Symbol(null,"c2","c2",78651156,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"c1","c1",-1521904966,null),new cljs.core.Symbol(null,"c2","c2",78651156,null),new cljs.core.Symbol(null,"c3","c3",468715789,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"c1","c1",-1521904966,null),new cljs.core.Symbol(null,"c2","c2",78651156,null),new cljs.core.Symbol(null,"c3","c3",468715789,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"colls","colls",-397642425,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"c1","c1",-1521904966,null),new cljs.core.Symbol(null,"c2","c2",78651156,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"c1","c1",-1521904966,null),new cljs.core.Symbol(null,"c2","c2",78651156,null),new cljs.core.Symbol(null,"c3","c3",468715789,null)], null)),null,cljs.core.list(null,null,null,null,null),(1),(4640),(4640),(4),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"c1","c1",-1521904966,null),new cljs.core.Symbol(null,"c2","c2",78651156,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"c1","c1",-1521904966,null),new cljs.core.Symbol(null,"c2","c2",78651156,null),new cljs.core.Symbol(null,"c3","c3",468715789,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"c1","c1",-1521904966,null),new cljs.core.Symbol(null,"c2","c2",78651156,null),new cljs.core.Symbol(null,"c3","c3",468715789,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"colls","colls",-397642425,null)], null)),"Returns a lazy sequence consisting of the result of applying f to\n  the set of first items of each coll, followed by applying f to the\n  set of second items in each coll, until any one of the colls is\n  exhausted.  Any remaining items in other colls are ignored. Function\n  f should accept number-of-colls arguments. Returns a transducer when\n  no collection is provided."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(9467),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(9467),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(11),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null),new cljs.core.Symbol(null,"h","h",-1544777029,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"fs","fs",-482394717,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes a set of functions and returns a fn that is the juxtaposition\n  of those fns.  The returned fn takes a variable number of args, and\n  returns a vector containing the result of applying each fn to the\n  args (left-to-right).\n  ((juxt a b c) x) => [(a x) (b x) (c x)]",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null),new cljs.core.Symbol(null,"h","h",-1544777029,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"fs","fs",-482394717,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null,null)], null)], null),new cljs.core.Symbol("cljs.core","juxt","cljs.core/juxt",263800975,null),true,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null),new cljs.core.Symbol(null,"h","h",-1544777029,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"fs","fs",-482394717,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null)),null,cljs.core.list(null,null,null,null),(1),(9467),(9467),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null),new cljs.core.Symbol(null,"h","h",-1544777029,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"fs","fs",-482394717,null)], null)),"Takes a set of functions and returns a fn that is the juxtaposition\n  of those fns.  The returned fn takes a variable number of args, and\n  returns a vector containing the result of applying each fn to the\n  args (left-to-right).\n  ((juxt a b c) x) => [(a x) (b x) (c x)]"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null], null), null),"cljs/core.cljs",(29),(10),new cljs.core.Keyword(null,"positional","positional",-203580463),(5886),(5886),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"fseq","fseq",-1466412450,null),new cljs.core.Symbol(null,"riter","riter",-237834262,null)], null))),null]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null], null), null),new cljs.core.Symbol("cljs.core","->PersistentQueueIter","cljs.core/->PersistentQueueIter",-1053457489,null),false,"cljs/core.cljs",(29),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"fseq","fseq",-1466412450,null),new cljs.core.Symbol(null,"riter","riter",-237834262,null)], null)),null,cljs.core.list(null,null),(1),new cljs.core.Keyword(null,"positional","positional",-203580463),(5886),(5886),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"fseq","fseq",-1466412450,null),new cljs.core.Symbol(null,"riter","riter",-237834262,null)], null))),null]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],["cljs/core.cljs",(17),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null)], null),(16),(2596),(2596),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null))),"Returns non-nil if nums are in monotonically increasing order,\n  otherwise false."]),new cljs.core.Symbol("cljs.core","<","cljs.core/<",1677496129,null),true,"cljs/core.cljs",(17),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null)),null,cljs.core.list(null,null,null),(1),(2596),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(2596),(2),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),"Returns non-nil if nums are in monotonically increasing order,\n  otherwise false."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(6849),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(6849),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(23),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"init","init",-234949907,null)], null)))], null),true,new cljs.core.Symbol("cljs.core","inode-kv-reduce","cljs.core/inode-kv-reduce",-715680389,null),false,"cljs/core.cljs",(23),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"init","init",-234949907,null)], null)),null,cljs.core.list(null,null),(1),(6849),(6849),(3),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"init","init",-234949907,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(6077),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(6077),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(25),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m","m",-1021758608,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"v","v",1661996586,null)], null)))], null),true,new cljs.core.Symbol("cljs.core","obj-map->hash-map","cljs.core/obj-map->hash-map",942343791,null),false,"cljs/core.cljs",(25),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m","m",-1021758608,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),null,cljs.core.list(null,null),(1),(6077),(6077),(3),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m","m",-1021758608,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"v","v",1661996586,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[(1),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null], null), null),new cljs.core.Symbol("cljs.core","t_cljs$core8988","cljs.core/t_cljs$core8988",1112451457,null),"cljs/core.cljs",true,true,(3),(3947),false,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(10912),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(10912),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(11),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"test [v] finds fn at key :test in var metadata and calls it,\n  presuming failure will throw exception"], null),new cljs.core.Symbol("cljs.core","test","cljs.core/test",-51203345,null),false,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),null,cljs.core.list(null,null),(1),(10912),(10912),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),"test [v] finds fn at key :test in var metadata and calls it,\n  presuming failure will throw exception"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(1225),new cljs.core.Keyword(null,"column","column",2078222095),(12),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(1225),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(16),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"seq","seq",-177272256,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a possibly empty seq of the items after the first. Calls seq on its\n  argument."], null),new cljs.core.Symbol("cljs.core","rest","cljs.core/rest",-285075455,null),false,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(1225),new cljs.core.Symbol(null,"seq","seq",-177272256,null),(1225),(1),new cljs.core.Symbol(null,"seq","seq",-177272256,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns a possibly empty seq of the items after the first. Calls seq on its\n  argument."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(10876),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(10876),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(14),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ex","ex",226760186,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns exception data (a map) if ex is an ExceptionInfo.\n  Otherwise returns nil."], null),new cljs.core.Symbol("cljs.core","ex-data","cljs.core/ex-data",-1491231397,null),false,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ex","ex",226760186,null)], null)),null,cljs.core.list(null,null),(1),(10876),(10876),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ex","ex",226760186,null)], null))),"Returns exception data (a map) if ex is an ExceptionInfo.\n  Otherwise returns nil."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[(3),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),null,new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","INext","cljs.core/INext",-113000046,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null),new cljs.core.Symbol("cljs.core","PersistentArrayMapSeq","cljs.core/PersistentArrayMapSeq",-1147819025,null),"cljs/core.cljs",(31),true,(10),(6427),false,(6427),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),null,new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","INext","cljs.core/INext",-113000046,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(813),new cljs.core.Keyword(null,"column","column",2078222095),(4),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(813),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(15),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Symbol("cljs.core","IChunk","cljs.core/IChunk",357422046,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a new chunk of coll with the first item removed.",new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)))], null),new cljs.core.Symbol("cljs.core","IChunk","cljs.core/IChunk",357422046,null),new cljs.core.Symbol("cljs.core","-drop-first","cljs.core/-drop-first",-1151486495,null),false,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(811),(813),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Return a new chunk of coll with the first item removed."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],["cljs/core.cljs",(20),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"child","child",-2030468224,null),new cljs.core.Symbol(null,"parent","parent",761652748,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"h","h",-1544777029,null),new cljs.core.Symbol(null,"child","child",-2030468224,null),new cljs.core.Symbol(null,"parent","parent",761652748,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"child","child",-2030468224,null),new cljs.core.Symbol(null,"parent","parent",761652748,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"h","h",-1544777029,null),new cljs.core.Symbol(null,"child","child",-2030468224,null),new cljs.core.Symbol(null,"parent","parent",761652748,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),(16),(10387),(10387),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"child","child",-2030468224,null),new cljs.core.Symbol(null,"parent","parent",761652748,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"h","h",-1544777029,null),new cljs.core.Symbol(null,"child","child",-2030468224,null),new cljs.core.Symbol(null,"parent","parent",761652748,null)], null))),"Returns true if (= child parent), or child is directly or indirectly derived from\n  parent, either via a JavaScript type inheritance relationship or a\n  relationship established via derive. h must be a hierarchy obtained\n  from make-hierarchy, if not supplied defaults to the global\n  hierarchy"]),new cljs.core.Symbol("cljs.core","isa?","cljs.core/isa?",951980347,null),false,"cljs/core.cljs",(20),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"child","child",-2030468224,null),new cljs.core.Symbol(null,"parent","parent",761652748,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"h","h",-1544777029,null),new cljs.core.Symbol(null,"child","child",-2030468224,null),new cljs.core.Symbol(null,"parent","parent",761652748,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"child","child",-2030468224,null),new cljs.core.Symbol(null,"parent","parent",761652748,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"h","h",-1544777029,null),new cljs.core.Symbol(null,"child","child",-2030468224,null),new cljs.core.Symbol(null,"parent","parent",761652748,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"child","child",-2030468224,null),new cljs.core.Symbol(null,"parent","parent",761652748,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"h","h",-1544777029,null),new cljs.core.Symbol(null,"child","child",-2030468224,null),new cljs.core.Symbol(null,"parent","parent",761652748,null)], null)),null,cljs.core.list(null,null),(1),(10387),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(10387),(3),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"child","child",-2030468224,null),new cljs.core.Symbol(null,"parent","parent",761652748,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"h","h",-1544777029,null),new cljs.core.Symbol(null,"child","child",-2030468224,null),new cljs.core.Symbol(null,"parent","parent",761652748,null)], null)),"Returns true if (= child parent), or child is directly or indirectly derived from\n  parent, either via a JavaScript type inheritance relationship or a\n  relationship established via derive. h must be a hierarchy obtained\n  from make-hierarchy, if not supplied defaults to the global\n  hierarchy"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2189),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2189),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(24),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return true if x is a Boolean"], null),new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null),false,"cljs/core.cljs",(24),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(2189),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(2189),(1),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Return true if x is a Boolean"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[new cljs.core.Symbol("cljs.core","ICloneable","cljs.core/ICloneable",-1712216461,null),"cljs/core.cljs",(15),(9),(556),(556),new cljs.core.Symbol(null,"clj","clj",980036099,null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"value","value",1946509744,null)], null))),"Creates a clone of value."]),new cljs.core.Symbol("cljs.core","ICloneable","cljs.core/ICloneable",-1712216461,null),new cljs.core.Symbol("cljs.core","-clone","cljs.core/-clone",608837499,null),false,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"value","value",1946509744,null)], null)),null,cljs.core.list(null,null),(1),(554),new cljs.core.Symbol(null,"clj","clj",980036099,null),(556),(1),new cljs.core.Symbol(null,"clj","clj",980036099,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"value","value",1946509744,null)], null))),"Creates a clone of value."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(11021),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(11021),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(12),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)))], null),new cljs.core.Symbol("cljs.core","munge","cljs.core/munge",232476539,null),false,"cljs/core.cljs",(12),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,cljs.core.list(null,null),(1),(11021),(11021),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223)],[new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(1325),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(1325),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(34),new cljs.core.Keyword(null,"private","private",-558947994),true], null),true,new cljs.core.Symbol("cljs.core","empty-ordered-hash","cljs.core/empty-ordered-hash",1716319899,null),"cljs/core.cljs",(34),(1),(1325),(1325),new cljs.core.Symbol(null,"number","number",-1084057331,null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(352),new cljs.core.Keyword(null,"column","column",2078222095),(3),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(352),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(14),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@enum {string}"], null)], null),new cljs.core.Symbol("cljs.core","DEMUNGE_MAP","cljs.core/DEMUNGE_MAP",-1417841055,null),"cljs/core.cljs",(14),(1),(351),(352),new cljs.core.Symbol(null,"object","object",-1179821820,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@enum {string}"], null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[(3),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null], null), null),new cljs.core.Symbol("cljs.core","ES6IteratorSeq","cljs.core/ES6IteratorSeq",-1502766129,null),"cljs/core.cljs",(24),true,(10),(1282),false,(1282),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null], null), null),"cljs/core.cljs",(20),(10),new cljs.core.Keyword(null,"positional","positional",-203580463),(6026),(6026),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null], null), null)]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null], null), null),new cljs.core.Symbol("cljs.core","->NeverEquiv","cljs.core/->NeverEquiv",-1688230975,null),false,"cljs/core.cljs",(20),cljs.core.list(cljs.core.PersistentVector.EMPTY),null,cljs.core.list(null,null),(1),new cljs.core.Keyword(null,"positional","positional",-203580463),(6026),(6026),(0),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(9563),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(9563),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(13),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"re","re",1869207729,null),new cljs.core.Symbol(null,"s","s",-948495851,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a lazy sequence of successive matches of re in s."], null),new cljs.core.Symbol("cljs.core","re-seq","cljs.core/re-seq",-1438765119,null),false,"cljs/core.cljs",(13),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"re","re",1869207729,null),new cljs.core.Symbol(null,"s","s",-948495851,null)], null)),null,cljs.core.list(null,null),(1),(9563),(9563),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"re","re",1869207729,null),new cljs.core.Symbol(null,"s","s",-948495851,null)], null))),"Returns a lazy sequence of successive matches of re in s."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(259),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(259),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(21),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if x is a JavaScript string of length one."], null),new cljs.core.Symbol("cljs.core","char?","cljs.core/char?",416405281,null),false,"cljs/core.cljs",(21),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(259),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(259),(1),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Returns true if x is a JavaScript string of length one."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(10370),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(10370),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(21),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a hierarchy object for use with derive, isa? etc."], null),new cljs.core.Symbol("cljs.core","make-hierarchy","cljs.core/make-hierarchy",433978497,null),false,"cljs/core.cljs",(21),cljs.core.list(cljs.core.PersistentVector.EMPTY),null,cljs.core.list(null,null),(1),(10370),(10370),(0),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY)),"Creates a hierarchy object for use with derive, isa? etc."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"declared","declared",92336021),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(941),new cljs.core.Keyword(null,"column","column",2078222095),(15),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(941),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(21),new cljs.core.Keyword(null,"declared","declared",92336021),true], null),(5),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","INamed","cljs.core/INamed",-857199025,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","IPrintWithWriter","cljs.core/IPrintWithWriter",1349251417,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null], null), null),new cljs.core.Symbol("cljs.core","Symbol","cljs.core/Symbol",292989338,null),"cljs/core.cljs",(16),true,(10),(1049),false,true,(1049),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","INamed","cljs.core/INamed",-857199025,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","IPrintWithWriter","cljs.core/IPrintWithWriter",1349251417,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null], null), null)]),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","PROTOCOL_SENTINEL","cljs.core/PROTOCOL_SENTINEL",210209696,null),new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(37),new cljs.core.Keyword(null,"column","column",2078222095),(1),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(37),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(27),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(37),new cljs.core.Keyword(null,"column","column",2078222095),(10),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(37),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(27)], null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"object","object",-1179821820,null)], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(5711),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(5711),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(20),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tv","tv",-164675832,null),new cljs.core.Symbol(null,"level","level",-1363938217,null),new cljs.core.Symbol(null,"parent","parent",761652748,null),new cljs.core.Symbol(null,"tail-node","tail-node",266838306,null)], null)))], null),true,new cljs.core.Symbol("cljs.core","tv-push-tail","cljs.core/tv-push-tail",984180928,null),false,"cljs/core.cljs",(20),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tv","tv",-164675832,null),new cljs.core.Symbol(null,"level","level",-1363938217,null),new cljs.core.Symbol(null,"parent","parent",761652748,null),new cljs.core.Symbol(null,"tail-node","tail-node",266838306,null)], null)),null,cljs.core.list(null,null),(1),(5711),(5711),(4),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tv","tv",-164675832,null),new cljs.core.Symbol(null,"level","level",-1363938217,null),new cljs.core.Symbol(null,"parent","parent",761652748,null),new cljs.core.Symbol(null,"tail-node","tail-node",266838306,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"start","start",1285322546,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"start","start",1285322546,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),(4),(681),(681),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"start","start",1285322546,null)], null))),"f should be a function of 2 arguments. If start is not supplied,\n     returns the result of applying f to the first 2 items in coll, then\n     applying f to that result and the 3rd item, etc."]),new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),new cljs.core.Symbol("cljs.core","-reduce","cljs.core/-reduce",124694714,null),false,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"start","start",1285322546,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"start","start",1285322546,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"start","start",1285322546,null)], null)),null,cljs.core.list(null,null),(1),(678),(681),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"start","start",1285322546,null)], null)),"f should be a function of 2 arguments. If start is not supplied,\n     returns the result of applying f to the first 2 items in coll, then\n     applying f to that result and the 3rd item, etc."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),"cljs/core.cljs",(18),(12),(561),(561),new cljs.core.Symbol(null,"number","number",-1084057331,null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Calculates the count of coll in constant time. Used by cljs.core/count."]),new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),new cljs.core.Symbol("cljs.core","-count","cljs.core/-count",1619166350,null),false,"cljs/core.cljs",(18),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(559),new cljs.core.Symbol(null,"number","number",-1084057331,null),(561),(1),new cljs.core.Symbol(null,"number","number",-1084057331,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Calculates the count of coll in constant time. Used by cljs.core/count."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"added","added",2057651688),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"added","added",2057651688),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],["1.9","cljs/core.cljs",(17),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(4),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null,null)], null),(7),(4462),(4462),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null))),"Atomically swaps the value of atom to be:\n  (apply f current-value-of-atom args). Note that f may be called\n  multiple times, and thus should be free of side effects.\n  Returns [old new], the value of the atom before and after the swap."]),"1.9",new cljs.core.Symbol("cljs.core","swap-vals!","cljs.core/swap-vals!",1629970458,null),true,"cljs/core.cljs",(17),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(4),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null)),null,cljs.core.list(null,null,null,null),(1),(4462),(4462),(4),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"more","more",-418290273,null)], null)),"Atomically swaps the value of atom to be:\n  (apply f current-value-of-atom args). Note that f may be called\n  multiple times, and thus should be free of side effects.\n  Returns [old new], the value of the atom before and after the swap."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(4327),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(4327),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(11),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a lazy sequence of the non-nil results of (f item). Note,\n  this means false return values will be included.  f must be free of\n  side-effects.  Returns a transducer when no collection is provided.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),new cljs.core.Symbol("cljs.core","keep","cljs.core/keep",451059968,null),false,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(4327),(4327),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"Returns a lazy sequence of the non-nil results of (f item). Note,\n  this means false return values will be included.  f must be free of\n  side-effects.  Returns a transducer when no collection is provided."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2664),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2664),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(11),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerce to char"], null),new cljs.core.Symbol("cljs.core","char","cljs.core/char",-1068683232,null),false,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(2664),(2664),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Coerce to char"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"added","added",2057651688),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"static","static",1214358571),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"added","added",2057651688),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"static","static",1214358571),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],["1.0","cljs/core.cljs",(13),true,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"colls","colls",-397642425,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),(7),(4863),(4863),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"colls","colls",-397642425,null)], null))),"Returns the result of applying concat to the result of applying map\n  to f and colls.  Thus function f should return a collection. Returns\n  a transducer when no collections are provided"]),"1.0",new cljs.core.Symbol("cljs.core","mapcat","cljs.core/mapcat",619397280,null),true,"cljs/core.cljs",(13),true,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"colls","colls",-397642425,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)),null,cljs.core.list(null,null),(1),(4863),(4863),(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"colls","colls",-397642425,null)], null)),"Returns the result of applying concat to the result of applying map\n  to f and colls.  Thus function f should return a collection. Returns\n  a transducer when no collections are provided"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2778),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2778),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(21),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerce to long by stripping decimal places. Identical to `int'."], null),new cljs.core.Symbol("cljs.core","unchecked-long","cljs.core/unchecked-long",2050992288,null),false,"cljs/core.cljs",(21),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(2778),(2778),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Coerce to long by stripping decimal places. Identical to `int'."]),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","m3-seed","cljs.core/m3-seed",324659866,null),new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(899),new cljs.core.Keyword(null,"column","column",2078222095),(1),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(899),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(13),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(899),new cljs.core.Keyword(null,"column","column",2078222095),(6),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(899),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(13)], null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"number","number",-1084057331,null)], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(243),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(243),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(21),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if x is not nil, false otherwise."], null),new cljs.core.Symbol("cljs.core","some?","cljs.core/some?",-440439360,null),false,"cljs/core.cljs",(21),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(243),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(243),(1),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Returns true if x is not nil, false otherwise."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2733),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2733),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(23),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)))], null),new cljs.core.Symbol("cljs.core","unchecked-negate","cljs.core/unchecked-negate",-1262131040,null),false,"cljs/core.cljs",(23),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(2733),(2733),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(3302),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(3302),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(33),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Efficient test to determine that two symbols are identical."], null),new cljs.core.Symbol("cljs.core","symbol-identical?","cljs.core/symbol-identical?",-1927295264,null),false,"cljs/core.cljs",(33),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null)),null,cljs.core.list(null,null),(1),(3302),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(3302),(2),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null))),"Efficient test to determine that two symbols are identical."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"doc","doc",1913296891)],[new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(292),new cljs.core.Keyword(null,"column","column",2078222095),(3),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(292),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(22),new cljs.core.Keyword(null,"doc","doc",1913296891),"A sequence of the supplied command line arguments, or nil if\n  none were supplied"], null),new cljs.core.Symbol("cljs.core","*command-line-args*","cljs.core/*command-line-args*",-891641266,null),"cljs/core.cljs",(22),(1),(289),(292),new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"A sequence of the supplied command line arguments, or nil if\n  none were supplied"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(3156),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(3156),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(14),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a seq of the items in coll in reverse order. Not lazy."], null),new cljs.core.Symbol("cljs.core","reverse","cljs.core/reverse",1527953530,null),false,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(3156),(3156),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns a seq of the items in coll in reverse order. Not lazy."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(1378),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(1378),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(21),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return true if x satisfies Inst"], null),new cljs.core.Symbol("cljs.core","inst?","cljs.core/inst?",1216133710,null),false,"cljs/core.cljs",(21),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(1378),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(1378),(1),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Return true if x satisfies Inst"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(9366),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(9366),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(12),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"end","end",1372345569,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"step","step",-1365547645,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a lazy seq of nums from start (inclusive) to end\n   (exclusive), by step, where start defaults to 0, step to 1,\n   and end to infinity.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"end","end",1372345569,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"step","step",-1365547645,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"end","end",1372345569,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"step","step",-1365547645,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null,null)], null)], null),new cljs.core.Symbol("cljs.core","range","cljs.core/range",-1421369894,null),false,"cljs/core.cljs",(12),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"end","end",1372345569,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"step","step",-1365547645,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"end","end",1372345569,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"step","step",-1365547645,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null,null)], null),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"end","end",1372345569,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"step","step",-1365547645,null)], null)),null,cljs.core.list(null,null,null,null),(1),(9366),(9366),(3),true,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"end","end",1372345569,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"step","step",-1365547645,null)], null)),"Returns a lazy seq of nums from start (inclusive) to end\n   (exclusive), by step, where start defaults to 0, step to 1,\n   and end to infinity."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2878),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(16),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Counts the number of bits set in n"], null),new cljs.core.Symbol("cljs.core","bit-count","cljs.core/bit-count",2075421088,null),false,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),null,cljs.core.list(null,null),(1),(2878),(2878),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),"Counts the number of bits set in n"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(7352),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(7352),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(19),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"key1","key1",870881380,null),new cljs.core.Symbol(null,"val1","val1",1513671953,null),new cljs.core.Symbol(null,"key2hash","key2hash",-1145861373,null),new cljs.core.Symbol(null,"key2","key2",-1509780911,null),new cljs.core.Symbol(null,"val2","val2",-516062888,null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"key1","key1",870881380,null),new cljs.core.Symbol(null,"val1","val1",1513671953,null),new cljs.core.Symbol(null,"key2hash","key2hash",-1145861373,null),new cljs.core.Symbol(null,"key2","key2",-1509780911,null),new cljs.core.Symbol(null,"val2","val2",-516062888,null)], null))),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(7),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"key1","key1",870881380,null),new cljs.core.Symbol(null,"val1","val1",1513671953,null),new cljs.core.Symbol(null,"key2hash","key2hash",-1145861373,null),new cljs.core.Symbol(null,"key2","key2",-1509780911,null),new cljs.core.Symbol(null,"val2","val2",-516062888,null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"key1","key1",870881380,null),new cljs.core.Symbol(null,"val1","val1",1513671953,null),new cljs.core.Symbol(null,"key2hash","key2hash",-1145861373,null),new cljs.core.Symbol(null,"key2","key2",-1509780911,null),new cljs.core.Symbol(null,"val2","val2",-516062888,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"key1","key1",870881380,null),new cljs.core.Symbol(null,"val1","val1",1513671953,null),new cljs.core.Symbol(null,"key2hash","key2hash",-1145861373,null),new cljs.core.Symbol(null,"key2","key2",-1509780911,null),new cljs.core.Symbol(null,"val2","val2",-516062888,null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"key1","key1",870881380,null),new cljs.core.Symbol(null,"val1","val1",1513671953,null),new cljs.core.Symbol(null,"key2hash","key2hash",-1145861373,null),new cljs.core.Symbol(null,"key2","key2",-1509780911,null),new cljs.core.Symbol(null,"val2","val2",-516062888,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),true,new cljs.core.Symbol("cljs.core","create-node","cljs.core/create-node",1742344896,null),false,"cljs/core.cljs",(19),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(7),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"key1","key1",870881380,null),new cljs.core.Symbol(null,"val1","val1",1513671953,null),new cljs.core.Symbol(null,"key2hash","key2hash",-1145861373,null),new cljs.core.Symbol(null,"key2","key2",-1509780911,null),new cljs.core.Symbol(null,"val2","val2",-516062888,null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"key1","key1",870881380,null),new cljs.core.Symbol(null,"val1","val1",1513671953,null),new cljs.core.Symbol(null,"key2hash","key2hash",-1145861373,null),new cljs.core.Symbol(null,"key2","key2",-1509780911,null),new cljs.core.Symbol(null,"val2","val2",-516062888,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"key1","key1",870881380,null),new cljs.core.Symbol(null,"val1","val1",1513671953,null),new cljs.core.Symbol(null,"key2hash","key2hash",-1145861373,null),new cljs.core.Symbol(null,"key2","key2",-1509780911,null),new cljs.core.Symbol(null,"val2","val2",-516062888,null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"key1","key1",870881380,null),new cljs.core.Symbol(null,"val1","val1",1513671953,null),new cljs.core.Symbol(null,"key2hash","key2hash",-1145861373,null),new cljs.core.Symbol(null,"key2","key2",-1509780911,null),new cljs.core.Symbol(null,"val2","val2",-516062888,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"key1","key1",870881380,null),new cljs.core.Symbol(null,"val1","val1",1513671953,null),new cljs.core.Symbol(null,"key2hash","key2hash",-1145861373,null),new cljs.core.Symbol(null,"key2","key2",-1509780911,null),new cljs.core.Symbol(null,"val2","val2",-516062888,null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"key1","key1",870881380,null),new cljs.core.Symbol(null,"val1","val1",1513671953,null),new cljs.core.Symbol(null,"key2hash","key2hash",-1145861373,null),new cljs.core.Symbol(null,"key2","key2",-1509780911,null),new cljs.core.Symbol(null,"val2","val2",-516062888,null)], null)),null,cljs.core.list(null,null),(1),(7352),(7352),(7),true,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"key1","key1",870881380,null),new cljs.core.Symbol(null,"val1","val1",1513671953,null),new cljs.core.Symbol(null,"key2hash","key2hash",-1145861373,null),new cljs.core.Symbol(null,"key2","key2",-1509780911,null),new cljs.core.Symbol(null,"val2","val2",-516062888,null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"key1","key1",870881380,null),new cljs.core.Symbol(null,"val1","val1",1513671953,null),new cljs.core.Symbol(null,"key2hash","key2hash",-1145861373,null),new cljs.core.Symbol(null,"key2","key2",-1509780911,null),new cljs.core.Symbol(null,"val2","val2",-516062888,null)], null))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2400),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2400),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(11),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a sorted sequence of the items in coll. Comp can be\n   boolean-valued comparison function, or a -/0/+ valued comparator.\n   Comp defaults to compare.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),new cljs.core.Symbol("cljs.core","sort","cljs.core/sort",1126425070,null),false,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(2400),(2400),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"Returns a sorted sequence of the items in coll. Comp can be\n   boolean-valued comparison function, or a -/0/+ valued comparator.\n   Comp defaults to compare."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","Fn","cljs.core/Fn",-695281833,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null], null), null),"cljs/core.cljs",(16),(10),new cljs.core.Keyword(null,"positional","positional",-203580463),(1982),(1982),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null], null), null)]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","Fn","cljs.core/Fn",-695281833,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null], null), null),new cljs.core.Symbol("cljs.core","->MetaFn","cljs.core/->MetaFn",-1478536448,null),false,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null)),null,cljs.core.list(null,null),(1),new cljs.core.Keyword(null,"positional","positional",-203580463),(1982),(1982),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2716),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2716),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(24),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)))], null),new cljs.core.Symbol("cljs.core","unchecked-inc-int","cljs.core/unchecked-inc-int",-2007014592,null),false,"cljs/core.cljs",(24),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(2716),(2716),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[new cljs.core.Symbol("cljs.core","IComparable","cljs.core/IComparable",1166626940,null),"cljs/core.cljs",(20),(12),(807),(807),new cljs.core.Symbol(null,"number","number",-1084057331,null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null))),"Returns a negative number, zero, or a positive number when x is logically\n     'less than', 'equal to', or 'greater than' y."]),new cljs.core.Symbol("cljs.core","IComparable","cljs.core/IComparable",1166626940,null),new cljs.core.Symbol("cljs.core","-compare","cljs.core/-compare",-1300838866,null),false,"cljs/core.cljs",(20),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null)),null,cljs.core.list(null,null),(1),(805),new cljs.core.Symbol(null,"number","number",-1084057331,null),(807),(2),new cljs.core.Symbol(null,"number","number",-1084057331,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null))),"Returns a negative number, zero, or a positive number when x is logically\n     'less than', 'equal to', or 'greater than' y."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(4299),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(4299),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(18),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a lazy sequence consisting of the result of applying f to 0\n  and the first item of coll, followed by applying f to 1 and the second\n  item in coll, etc, until coll is exhausted. Thus function f should\n  accept 2 arguments, index and item. Returns a stateful transducer when\n  no collection is provided.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),new cljs.core.Symbol("cljs.core","map-indexed","cljs.core/map-indexed",1154761082,null),false,"cljs/core.cljs",(18),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(4299),(4299),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"Returns a lazy sequence consisting of the result of applying f to 0\n  and the first item of coll, followed by applying f to 1 and the second\n  item in coll, etc, until coll is exhausted. Thus function f should\n  accept 2 arguments, index and item. Returns a stateful transducer when\n  no collection is provided."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(9169),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(9169),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(17),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null),new cljs.core.Symbol("cljs.core","array-list","cljs.core/array-list",2045879968,null),false,"cljs/core.cljs",(17),cljs.core.list(cljs.core.PersistentVector.EMPTY),null,cljs.core.list(null,null),(1),(9169),(9169),(0),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(10351),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(10351),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(15),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a random element of the (sequential) collection. Will have\n  the same performance characteristics as nth for the given\n  collection."], null),new cljs.core.Symbol("cljs.core","rand-nth","cljs.core/rand-nth",-290660754,null),false,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(10351),(10351),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Return a random element of the (sequential) collection. Will have\n  the same performance characteristics as nth for the given\n  collection."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(4216),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(4216),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(11),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f1","f1",-939903380,null),new cljs.core.Symbol(null,"f2","f2",2036700123,null),new cljs.core.Symbol(null,"f3","f3",-699606726,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"fs","fs",-482394717,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes a set of functions and returns a fn that is the composition\n  of those fns.  The returned fn takes a variable number of args,\n  applies the rightmost of fns to the args, the next\n  fn (right-to-left) to the result, etc.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f1","f1",-939903380,null),new cljs.core.Symbol(null,"f2","f2",2036700123,null),new cljs.core.Symbol(null,"f3","f3",-699606726,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"fs","fs",-482394717,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null,null,null)], null)], null),new cljs.core.Symbol("cljs.core","comp","cljs.core/comp",-2137591872,null),true,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f1","f1",-939903380,null),new cljs.core.Symbol(null,"f2","f2",2036700123,null),new cljs.core.Symbol(null,"f3","f3",-699606726,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"fs","fs",-482394717,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null,null,null)], null),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null)),null,cljs.core.list(null,null,null,null,null),(1),(4216),(4216),(3),true,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"g","g",-916345864,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f1","f1",-939903380,null),new cljs.core.Symbol(null,"f2","f2",2036700123,null),new cljs.core.Symbol(null,"f3","f3",-699606726,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"fs","fs",-482394717,null)], null)),"Takes a set of functions and returns a fn that is the composition\n  of those fns.  The returned fn takes a variable number of args,\n  applies the rightmost of fns to the args, the next\n  fn (right-to-left) to the result, etc."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(3491),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(3491),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(18),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null))),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null)], null)], null),new cljs.core.Symbol("cljs.core","array-chunk","cljs.core/array-chunk",1599128750,null),false,"cljs/core.cljs",(18),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(3),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null)),null,cljs.core.list(null,null,null),(1),(3491),(3491),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(10774),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(10774),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(18),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"multifn","multifn",-1904313150,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a multimethod, return it's dispatch-fn."], null),new cljs.core.Symbol("cljs.core","dispatch-fn","cljs.core/dispatch-fn",-189025344,null),false,"cljs/core.cljs",(18),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"multifn","multifn",-1904313150,null)], null)),null,cljs.core.list(null,null),(1),(10774),(10774),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"multifn","multifn",-1904313150,null)], null))),"Given a multimethod, return it's dispatch-fn."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2870),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2870),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(32),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"DEPRECATED: Bitwise shift right with zero fill"], null),new cljs.core.Symbol("cljs.core","bit-shift-right-zero-fill","cljs.core/bit-shift-right-zero-fill",-1177982976,null),false,"cljs/core.cljs",(32),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),(1),(2870),(2870),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"DEPRECATED: Bitwise shift right with zero fill"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(10986),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(10986),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(20),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)))], null),true,new cljs.core.Symbol("cljs.core","js-reserved?","cljs.core/js-reserved?",1729717326,null),false,"cljs/core.cljs",(20),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(10986),(10986),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[new cljs.core.Symbol("cljs.core","IEditableCollection","cljs.core/IEditableCollection",297050504,null),"cljs/core.cljs",(22),(9),(772),(772),new cljs.core.Symbol(null,"clj","clj",980036099,null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns a new, transient version of the collection, in constant time."]),new cljs.core.Symbol("cljs.core","IEditableCollection","cljs.core/IEditableCollection",297050504,null),new cljs.core.Symbol("cljs.core","-as-transient","cljs.core/-as-transient",70109325,null),false,"cljs/core.cljs",(22),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(770),new cljs.core.Symbol(null,"clj","clj",980036099,null),(772),(1),new cljs.core.Symbol(null,"clj","clj",980036099,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns a new, transient version of the collection, in constant time."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(9503),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(9503),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(12),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"When lazy sequences are produced via functions that have side\n  effects, any effects other than those needed to produce the first\n  element in the seq do not occur until the seq is consumed. dorun can\n  be used to force any effects. Walks through the successive nexts of\n  the seq, does not retain the head and returns nil.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null)], null),new cljs.core.Symbol("cljs.core","dorun","cljs.core/dorun",1487325315,null),false,"cljs/core.cljs",(12),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(9503),(9503),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"When lazy sequences are produced via functions that have side\n  effects, any effects other than those needed to produce the first\n  element in the seq do not occur until the seq is consumed. dorun can\n  be used to force any effects. Walks through the successive nexts of\n  the seq, does not retain the head and returns nil."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(9583),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(9583),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(27),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"writer","writer",1362963291,null),new cljs.core.Symbol(null,"print-one","print-one",-1291317310,null),new cljs.core.Symbol(null,"begin","begin",1321497208,null),new cljs.core.Symbol(null,"sep","sep",-684005239,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)))], null),new cljs.core.Symbol("cljs.core","pr-sequential-writer","cljs.core/pr-sequential-writer",-1101677821,null),false,"cljs/core.cljs",(27),cljs.core.list(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"writer","writer",1362963291,null),new cljs.core.Symbol(null,"print-one","print-one",-1291317310,null),new cljs.core.Symbol(null,"begin","begin",1321497208,null),new cljs.core.Symbol(null,"sep","sep",-684005239,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(9583),(9583),(7),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"writer","writer",1362963291,null),new cljs.core.Symbol(null,"print-one","print-one",-1291317310,null),new cljs.core.Symbol(null,"begin","begin",1321497208,null),new cljs.core.Symbol(null,"sep","sep",-684005239,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(3330),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(3330),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(30),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return true if x is a symbol without a namespace"], null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),false,"cljs/core.cljs",(30),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(3330),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(3330),(1),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Return true if x is a symbol without a namespace"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(1783),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(1783),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(30),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)))], null),true,new cljs.core.Symbol("cljs.core","accumulating-seq-count","cljs.core/accumulating-seq-count",1434359011,null),false,"cljs/core.cljs",(30),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(1783),(1783),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"impls","impls",-1314014853),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[true,"cljs/core.cljs",(22),(14),(581),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-nth","-nth",911195817,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"not-found","not-found",1011451547,null)], null)], null)], null)], null),(581),"Protocol for collections to provide indexed-based access to their items.",cljs.core.list("@interface")]),true,new cljs.core.Symbol("cljs.core","IIndexed","cljs.core/IIndexed",-436490749,null),"cljs/core.cljs",(22),(1),(581),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-nth","-nth",911195817,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"not-found","not-found",1011451547,null)], null)], null)], null)], null),null,(581),new cljs.core.Symbol(null,"any","any",-948528346,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [new cljs.core.Symbol("cljs.core","TransientVector","cljs.core/TransientVector",-1152354525,null),null,new cljs.core.Symbol("cljs.core","IndexedSeq","cljs.core/IndexedSeq",-228688698,null),null,new cljs.core.Symbol("cljs.core","BlackNode","cljs.core/BlackNode",-1625498712,null),null,new cljs.core.Symbol("cljs.core","MapEntry","cljs.core/MapEntry",-858280599,null),null,new cljs.core.Symbol("cljs.core","Subvec","cljs.core/Subvec",621298762,null),null,new cljs.core.Symbol("cljs.core","PersistentVector","cljs.core/PersistentVector",-1211028272,null),null,new cljs.core.Symbol("cljs.core","ArrayChunk","cljs.core/ArrayChunk",-1023606567,null),null,new cljs.core.Symbol("cljs.core","Range","cljs.core/Range",-742073570,null),null,new cljs.core.Symbol("cljs.core","RedNode","cljs.core/RedNode",-1367391329,null),null], null), null),"Protocol for collections to provide indexed-based access to their items.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2066),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2066),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(11),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"ks","ks",-754231827,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"disj[oin]. Returns a new set of the same (hashed/sorted) type, that\n  does not contain key(s).",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"ks","ks",-754231827,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null)], null)], null),new cljs.core.Symbol("cljs.core","disj","cljs.core/disj",1679005177,null),true,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(2),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"ks","ks",-754231827,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null)),null,cljs.core.list(null,null,null),(1),(2066),(2066),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"ks","ks",-754231827,null)], null)),"disj[oin]. Returns a new set of the same (hashed/sorted) type, that\n  does not contain key(s)."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[(1),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null], null), null),new cljs.core.Symbol("cljs.core","MultiIterator","cljs.core/MultiIterator",-67556061,null),"cljs/core.cljs",(23),true,(10),(4056),false,(4056),null]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"impls","impls",-1314014853),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[true,"cljs/core.cljs",(30),(14),(746),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-pr-writer","-pr-writer",-445354136,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"o","o",290524299,null),new cljs.core.Symbol(null,"writer","writer",1362963291,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null)], null)], null)], null)], null),(746),"The old IPrintable protocol's implementation consisted of building a giant\n   list of strings to concatenate.  This involved lots of concat calls,\n   intermediate vectors, and lazy-seqs, and was very slow in some older JS\n   engines.  IPrintWithWriter implements printing via the IWriter protocol, so it\n   be implemented efficiently in terms of e.g. a StringBuffer append.",cljs.core.list("@interface")]),true,new cljs.core.Symbol("cljs.core","IPrintWithWriter","cljs.core/IPrintWithWriter",1349251417,null),"cljs/core.cljs",(30),(1),(746),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-pr-writer","-pr-writer",-445354136,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"o","o",290524299,null),new cljs.core.Symbol(null,"writer","writer",1362963291,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null)], null)], null)], null)], null),null,(746),new cljs.core.Symbol(null,"any","any",-948528346,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 39, [new cljs.core.Symbol("cljs.core","PersistentHashMap","cljs.core/PersistentHashMap",-454120575,null),null,new cljs.core.Symbol("cljs.core","ObjMap","cljs.core/ObjMap",799478018,null),null,new cljs.core.Symbol("cljs.core","Cons","cljs.core/Cons",1413586690,null),null,new cljs.core.Symbol("cljs.core","Eduction","cljs.core/Eduction",-1331861597,null),null,new cljs.core.Symbol("cljs.core","PersistentArrayMap","cljs.core/PersistentArrayMap",1025194468,null),null,new cljs.core.Symbol("cljs.core","NodeSeq","cljs.core/NodeSeq",1136673444,null),null,new cljs.core.Symbol("cljs.core","PersistentQueue","cljs.core/PersistentQueue",-1909468475,null),null,new cljs.core.Symbol("cljs.core","IndexedSeq","cljs.core/IndexedSeq",-228688698,null),null,new cljs.core.Symbol("cljs.core","Volatile","cljs.core/Volatile",-1098692185,null),null,new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),null,new cljs.core.Symbol("cljs.core","BlackNode","cljs.core/BlackNode",-1625498712,null),null,new cljs.core.Symbol("cljs.core","EmptyList","cljs.core/EmptyList",233903529,null),null,new cljs.core.Symbol("cljs.core","LazySeq","cljs.core/LazySeq",1986389673,null),null,new cljs.core.Symbol("cljs.core","Subvec","cljs.core/Subvec",621298762,null),null,new cljs.core.Symbol("cljs.core","PersistentQueueSeq","cljs.core/PersistentQueueSeq",-1720330774,null),null,new cljs.core.Symbol("cljs.core","ExceptionInfo","cljs.core/ExceptionInfo",701839050,null),null,new cljs.core.Symbol("cljs.core","Var","cljs.core/Var",2071014443,null),null,new cljs.core.Symbol("cljs.core","ArrayNodeSeq","cljs.core/ArrayNodeSeq",1766699115,null),null,new cljs.core.Symbol("cljs.core","ValSeq","cljs.core/ValSeq",-2059304789,null),null,new cljs.core.Symbol("cljs.core","TaggedLiteral","cljs.core/TaggedLiteral",-2005478516,null),null,new cljs.core.Symbol("cljs.tools.reader.impl.utils","ReaderConditional","cljs.tools.reader.impl.utils/ReaderConditional",-2077570001,null),null,new cljs.core.Symbol("cljs.core","ES6IteratorSeq","cljs.core/ES6IteratorSeq",-1502766129,null),null,new cljs.core.Symbol("cljs.core","PersistentArrayMapSeq","cljs.core/PersistentArrayMapSeq",-1147819025,null),null,new cljs.core.Symbol("cljs.core","PersistentVector","cljs.core/PersistentVector",-1211028272,null),null,new cljs.core.Symbol("cljs.core","List","cljs.core/List",1708954352,null),null,new cljs.core.Symbol("cljs.core","TransformerIterator","cljs.core/TransformerIterator",-1053937581,null),null,new cljs.core.Symbol("cljs.core","RSeq","cljs.core/RSeq",1934590931,null),null,new cljs.core.Symbol("cljs.core","PersistentHashSet","cljs.core/PersistentHashSet",-967232330,null),null,new cljs.core.Symbol("cljs.core","PersistentTreeMap","cljs.core/PersistentTreeMap",998680439,null),null,new cljs.core.Symbol("cljs.core","KeySeq","cljs.core/KeySeq",-959139688,null),null,new cljs.core.Symbol("cljs.core","ChunkedSeq","cljs.core/ChunkedSeq",1855394072,null),null,new cljs.core.Symbol("cljs.core","Atom","cljs.core/Atom",1320999481,null),null,new cljs.core.Symbol("cljs.core","PersistentTreeSet","cljs.core/PersistentTreeSet",-2033838151,null),null,new cljs.core.Symbol("cljs.core","ChunkedCons","cljs.core/ChunkedCons",2006464858,null),null,new cljs.core.Symbol("cljs.core","Symbol","cljs.core/Symbol",292989338,null),null,new cljs.core.Symbol("cljs.core","UUID","cljs.core/UUID",-1279419460,null),null,new cljs.core.Symbol("cljs.core","Range","cljs.core/Range",-742073570,null),null,new cljs.core.Symbol("cljs.core","PersistentTreeMapSeq","cljs.core/PersistentTreeMapSeq",-552308673,null),null,new cljs.core.Symbol("cljs.core","RedNode","cljs.core/RedNode",-1367391329,null),null], null), null),"The old IPrintable protocol's implementation consisted of building a giant\n   list of strings to concatenate.  This involved lots of concat calls,\n   intermediate vectors, and lazy-seqs, and was very slow in some older JS\n   engines.  IPrintWithWriter implements printing via the IWriter protocol, so it\n   be implemented efficiently in terms of e.g. a StringBuffer append.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","IPrintWithWriter","cljs.core/IPrintWithWriter",1349251417,null),null,new cljs.core.Symbol("cljs.core","IComparable","cljs.core/IComparable",1166626940,null),null,new cljs.core.Symbol("cljs.core","IUUID","cljs.core/IUUID",-1606521379,null),null], null), null),"cljs/core.cljs",(14),(10),new cljs.core.Keyword(null,"positional","positional",-203580463),(10781),(10781),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","IPrintWithWriter","cljs.core/IPrintWithWriter",1349251417,null),null,new cljs.core.Symbol("cljs.core","IComparable","cljs.core/IComparable",1166626940,null),null], null), null)]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","IPrintWithWriter","cljs.core/IPrintWithWriter",1349251417,null),null,new cljs.core.Symbol("cljs.core","IComparable","cljs.core/IComparable",1166626940,null),null,new cljs.core.Symbol("cljs.core","IUUID","cljs.core/IUUID",-1606521379,null),null], null), null),new cljs.core.Symbol("cljs.core","->UUID","cljs.core/->UUID",-278302375,null),false,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null)),null,cljs.core.list(null,null),(1),new cljs.core.Keyword(null,"positional","positional",-203580463),(10781),(10781),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","IPrintWithWriter","cljs.core/IPrintWithWriter",1349251417,null),null,new cljs.core.Symbol("cljs.core","IComparable","cljs.core/IComparable",1166626940,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"impls","impls",-1314014853),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[true,"cljs/core.cljs",(21),(14),(655),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-assoc-n","-assoc-n",-1670943726,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"val","val",1769233139,null)], null)], null)], null)], null),(655),"Protocol for adding vector functionality to collections.",cljs.core.list("@interface")]),true,new cljs.core.Symbol("cljs.core","IVector","cljs.core/IVector",1711112835,null),"cljs/core.cljs",(21),(1),(655),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-assoc-n","-assoc-n",-1670943726,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"val","val",1769233139,null)], null)], null)], null)], null),null,(655),new cljs.core.Symbol(null,"any","any",-948528346,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Symbol("cljs.core","BlackNode","cljs.core/BlackNode",-1625498712,null),null,new cljs.core.Symbol("cljs.core","MapEntry","cljs.core/MapEntry",-858280599,null),null,new cljs.core.Symbol("cljs.core","Subvec","cljs.core/Subvec",621298762,null),null,new cljs.core.Symbol("cljs.core","PersistentVector","cljs.core/PersistentVector",-1211028272,null),null,new cljs.core.Symbol("cljs.core","RedNode","cljs.core/RedNode",-1367391329,null),null], null), null),"Protocol for adding vector functionality to collections.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"impls","impls",-1314014853),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)],[true,"cljs/core.cljs",(23),(14),(854),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-iterator","-iterator",310937281,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)], null)], null)], null),(854),"Protocol for iterating over a collection.",cljs.core.list("@interface")]),true,new cljs.core.Symbol("cljs.core","IIterable","cljs.core/IIterable",178674073,null),"cljs/core.cljs",(23),(1),(854),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"-iterator","-iterator",310937281,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)], null)], null)], null),null,(854),new cljs.core.Symbol(null,"any","any",-948528346,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [new cljs.core.Symbol("cljs.core","PersistentHashMap","cljs.core/PersistentHashMap",-454120575,null),null,new cljs.core.Symbol("cljs.core","Eduction","cljs.core/Eduction",-1331861597,null),null,new cljs.core.Symbol("cljs.core","PersistentArrayMap","cljs.core/PersistentArrayMap",1025194468,null),null,new cljs.core.Symbol("cljs.core","PersistentQueue","cljs.core/PersistentQueue",-1909468475,null),null,new cljs.core.Symbol("cljs.core","IndexedSeq","cljs.core/IndexedSeq",-228688698,null),null,new cljs.core.Symbol("cljs.core","Subvec","cljs.core/Subvec",621298762,null),null,new cljs.core.Symbol("cljs.tools.reader.impl.utils","ReaderConditional","cljs.tools.reader.impl.utils/ReaderConditional",-2077570001,null),null,new cljs.core.Symbol("cljs.core","PersistentVector","cljs.core/PersistentVector",-1211028272,null),null,new cljs.core.Symbol("cljs.core","ArrayNode","cljs.core/ArrayNode",-1100546027,null),null,new cljs.core.Symbol("cljs.core","PersistentHashSet","cljs.core/PersistentHashSet",-967232330,null),null,new cljs.core.Symbol("cljs.core","HashCollisionNode","cljs.core/HashCollisionNode",-2083619620,null),null,new cljs.core.Symbol("cljs.core","Range","cljs.core/Range",-742073570,null),null,new cljs.core.Symbol("cljs.core","BitmapIndexedNode","cljs.core/BitmapIndexedNode",379612479,null),null], null), null),"Protocol for iterating over a collection.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null], null), null),"cljs/core.cljs",(23),(10),new cljs.core.Keyword(null,"positional","positional",-203580463),(4056),(4056),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"iters","iters",719353031,null)], null))),null]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null], null), null),new cljs.core.Symbol("cljs.core","->MultiIterator","cljs.core/->MultiIterator",-1453558087,null),false,"cljs/core.cljs",(23),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"iters","iters",719353031,null)], null)),null,cljs.core.list(null,null),(1),new cljs.core.Keyword(null,"positional","positional",-203580463),(4056),(4056),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"iters","iters",719353031,null)], null))),null]),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","*2","cljs.core/*2",-1899817277,null),new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(192),new cljs.core.Keyword(null,"column","column",2078222095),(1),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(194),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(5),new cljs.core.Keyword(null,"doc","doc",1913296891),"bound in a repl thread to the second most recent value printed",new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(194),new cljs.core.Keyword(null,"column","column",2078222095),(3),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(194),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(5),new cljs.core.Keyword(null,"doc","doc",1913296891),"bound in a repl thread to the second most recent value printed"], null)], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[(2),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IPrintWithWriter","cljs.core/IPrintWithWriter",1349251417,null),null,new cljs.core.Symbol("cljs.core","IIterable","cljs.core/IIterable",178674073,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null),new cljs.core.Symbol("cljs.core","Eduction","cljs.core/Eduction",-1331861597,null),"cljs/core.cljs",(18),true,(10),(10193),false,(10193),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IPrintWithWriter","cljs.core/IPrintWithWriter",1349251417,null),null,new cljs.core.Symbol("cljs.core","IIterable","cljs.core/IIterable",178674073,null),null,new cljs.core.Symbol("cljs.core","ISequential","cljs.core/ISequential",-950981796,null),null,new cljs.core.Symbol("cljs.core","IReduce","cljs.core/IReduce",-577837345,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(5080),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(5080),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(21),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"node","node",-2073234571,null)], null)))], null),true,new cljs.core.Symbol("cljs.core","pv-clone-node","cljs.core/pv-clone-node",1271286189,null),false,"cljs/core.cljs",(21),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"node","node",-2073234571,null)], null)),null,cljs.core.list(null,null),(1),(5080),(5080),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"node","node",-2073234571,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(3237),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(3237),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(11),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new seq where x is the first element and coll is the rest."], null),new cljs.core.Symbol("cljs.core","cons","cljs.core/cons",96507417,null),false,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),(1),(3237),(3237),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns a new seq where x is the first element and coll is the rest."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[(3),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [new cljs.core.Symbol("cljs.core","IReversible","cljs.core/IReversible",-1422278012,null),null,new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null,new cljs.core.Symbol("cljs.core","ISet","cljs.core/ISet",2003412810,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),null,new cljs.core.Symbol("cljs.core","ISorted","cljs.core/ISorted",-1734125647,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ICloneable","cljs.core/ICloneable",-1712216461,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","ILookup","cljs.core/ILookup",-150575073,null),null], null), null),new cljs.core.Symbol("cljs.core","PersistentTreeSet","cljs.core/PersistentTreeSet",-2033838151,null),"cljs/core.cljs",(27),true,(10),(8939),false,(8939),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Symbol("cljs.core","IReversible","cljs.core/IReversible",-1422278012,null),null,new cljs.core.Symbol("cljs.core","IEquiv","cljs.core/IEquiv",-1245752602,null),null,new cljs.core.Symbol("cljs.core","IHash","cljs.core/IHash",-32453786,null),null,new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","ICollection","cljs.core/ICollection",802638471,null),null,new cljs.core.Symbol("cljs.core","ISet","cljs.core/ISet",2003412810,null),null,new cljs.core.Symbol("cljs.core","IEmptyableCollection","cljs.core/IEmptyableCollection",5045035,null),null,new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),null,new cljs.core.Symbol("cljs.core","ISorted","cljs.core/ISorted",-1734125647,null),null,new cljs.core.Symbol("cljs.core","ISeqable","cljs.core/ISeqable",137437203,null),null,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null),null,new cljs.core.Symbol("cljs.core","ICloneable","cljs.core/ICloneable",-1712216461,null),null,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null),null,new cljs.core.Symbol("cljs.core","ILookup","cljs.core/ILookup",-150575073,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null], null), null),"cljs/core.cljs",(21),(10),new cljs.core.Keyword(null,"positional","positional",-203580463),(8774),(8774),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"iter","iter",-1346195486,null)], null))),null]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","Object","cljs.core/Object",-345545431,null),null], null), null),new cljs.core.Symbol("cljs.core","->HashSetIter","cljs.core/->HashSetIter",-460469085,null),false,"cljs/core.cljs",(21),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"iter","iter",-1346195486,null)], null)),null,cljs.core.list(null,null),(1),new cljs.core.Keyword(null,"positional","positional",-203580463),(8774),(8774),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"iter","iter",-1346195486,null)], null))),null]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(11058),new cljs.core.Keyword(null,"column","column",2078222095),(8),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(11058),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(17),new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns-obj","ns-obj",-635821906,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Bootstrap only."], null),true,new cljs.core.Symbol("cljs.core","ns-lookup","cljs.core/ns-lookup",-1010035549,null),false,"cljs/core.cljs",(17),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns-obj","ns-obj",-635821906,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null)),null,cljs.core.list(null,null),(1),(11058),(11058),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns-obj","ns-obj",-635821906,null),new cljs.core.Symbol(null,"k","k",-505765866,null)], null))),"Bootstrap only."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2788),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2788),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(13),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)))], null),new cljs.core.Symbol("cljs.core","floats","cljs.core/floats",912155865,null),false,"cljs/core.cljs",(13),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(2788),(2788),(1),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"num-fields","num-fields",1529154024),new cljs.core.Keyword(null,"protocols","protocols",-5615896),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"record","record",-779106859),new cljs.core.Keyword(null,"declared","declared",92336021),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630)],[new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(5201),new cljs.core.Keyword(null,"column","column",2078222095),(44),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(5201),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(59),new cljs.core.Keyword(null,"declared","declared",92336021),true], null),(4),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Symbol("cljs.core","IIndexed","cljs.core/IIndexed",-436490749,null),null,new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),null,new cljs.core.Symbol("cljs.core","ITransientCollection","cljs.core/ITransientCollection",659687029,null),null,new cljs.core.Symbol("cljs.core","ITransientVector","cljs.core/ITransientVector",-1380049033,null),null,new cljs.core.Symbol("cljs.core","ITransientAssociative","cljs.core/ITransientAssociative",2006904029,null),null,new cljs.core.Symbol("cljs.core","ILookup","cljs.core/ILookup",-150575073,null),null], null), null),new cljs.core.Symbol("cljs.core","TransientVector","cljs.core/TransientVector",-1152354525,null),"cljs/core.cljs",(25),true,(10),(5753),false,true,(5753),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Symbol("cljs.core","IIndexed","cljs.core/IIndexed",-436490749,null),null,new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null),null,new cljs.core.Symbol("cljs.core","ICounted","cljs.core/ICounted",-1299011378,null),null,new cljs.core.Symbol("cljs.core","ITransientCollection","cljs.core/ITransientCollection",659687029,null),null,new cljs.core.Symbol("cljs.core","ITransientVector","cljs.core/ITransientVector",-1380049033,null),null,new cljs.core.Symbol("cljs.core","ITransientAssociative","cljs.core/ITransientAssociative",2006904029,null),null,new cljs.core.Symbol("cljs.core","ILookup","cljs.core/ILookup",-150575073,null),null], null), null)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(2898),new cljs.core.Keyword(null,"column","column",2078222095),(16),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(2898),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(20),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if num is greater than zero, else false"], null),new cljs.core.Symbol("cljs.core","pos?","cljs.core/pos?",-652182749,null),false,"cljs/core.cljs",(20),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),(1),(2898),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),(2898),(1),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Returns true if num is greater than zero, else false"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(4274),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(4274),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(11),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"z","z",851004344,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes a function f, and returns a function that calls f, replacing\n  a nil first argument to f with the supplied value x. Higher arity\n  versions can replace arguments in the second and third\n  positions (y, z). Note that the function f can take any number of\n  arguments, not just the one(s) being nil-patched.",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(4),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"z","z",851004344,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"z","z",851004344,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null)], null)], null),new cljs.core.Symbol("cljs.core","fnil","cljs.core/fnil",479587341,null),false,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),false,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(4),new cljs.core.Keyword(null,"method-params","method-params",-980792179),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"z","z",851004344,null)], null)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"z","z",851004344,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"z","z",851004344,null)], null)),null,cljs.core.list(null,null,null),(1),(4274),(4274),(4),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"z","z",851004344,null)], null)),"Takes a function f, and returns a function that calls f, replacing\n  a nil first argument to f with the supplied value x. Higher arity\n  versions can replace arguments in the second and third\n  positions (y, z). Note that the function f can take any number of\n  arguments, not just the one(s) being nil-patched."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(8740),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(8740),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(17),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"maps","maps",-71029607,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a map that consists of the rest of the maps conj-ed onto\n  the first.  If a key occurs in more than one map, the mapping(s)\n  from the latter (left-to-right) will be combined with the mapping in\n  the result by calling (f val-in-result val-in-latter).",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"maps","maps",-71029607,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"maps","maps",-71029607,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null),new cljs.core.Symbol("cljs.core","merge-with","cljs.core/merge-with",366771213,null),true,"cljs/core.cljs",(17),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"maps","maps",-71029607,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"maps","maps",-71029607,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"maps","maps",-71029607,null))], null),null,cljs.core.list(null),(1),(8740),(8740),(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"maps","maps",-71029607,null)], null)),"Returns a map that consists of the rest of the maps conj-ed onto\n  the first.  If a key occurs in more than one map, the mapping(s)\n  from the latter (left-to-right) will be combined with the mapping in\n  the result by calling (f val-in-result val-in-latter)."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"variadic","variadic",882626057),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"cljs/core.cljs",new cljs.core.Keyword(null,"line","line",212345235),(1896),new cljs.core.Keyword(null,"column","column",2078222095),(7),new cljs.core.Keyword(null,"end-line","end-line",1837326455),(1896),new cljs.core.Keyword(null,"end-column","end-column",1425389514),(14),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the nth rest of coll, coll when n is 0."], null),new cljs.core.Symbol("cljs.core","nthrest","cljs.core/nthrest",1634834275,null),false,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),(1),(1896),(1896),(2),true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Returns the nth rest of coll, coll when n is 0."]),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"name","name",1843675177