// Compiled by ClojureScript 1.9.946 {}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.call(null,(function (m,p__11619){
var vec__11620 = p__11619;
var i = cljs.core.nth.call(null,vec__11620,(0),null);
var v = cljs.core.nth.call(null,vec__11620,(1),null);
return cljs.core.assoc.call(null,m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.call(null,(function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources.call(null,sources);
return ((function (sources__$1){
return (function (a,b){
return cljs.core.compare.call(null,sources__$1.call(null,a),sources__$1.call(null,b));
});
;})(sources__$1))
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__11623 = seg;
var gcol = cljs.core.nth.call(null,vec__11623,(0),null);
var source = cljs.core.nth.call(null,vec__11623,(1),null);
var line = cljs.core.nth.call(null,vec__11623,(2),null);
var col = cljs.core.nth.call(null,vec__11623,(3),null);
var name = cljs.core.nth.call(null,vec__11623,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5457__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,seg));
if(cljs.core.truth_(temp__5457__auto__)){
var name__$1 = temp__5457__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__11626 = seg;
var gcol = cljs.core.nth.call(null,vec__11626,(0),null);
var source = cljs.core.nth.call(null,vec__11626,(1),null);
var line = cljs.core.nth.call(null,vec__11626,(2),null);
var col = cljs.core.nth.call(null,vec__11626,(3),null);
var name = cljs.core.nth.call(null,vec__11626,(4),null);
var vec__11629 = relseg;
var rgcol = cljs.core.nth.call(null,vec__11629,(0),null);
var rsource = cljs.core.nth.call(null,vec__11629,(1),null);
var rline = cljs.core.nth.call(null,vec__11629,(2),null);
var rcol = cljs.core.nth.call(null,vec__11629,(3),null);
var rname = cljs.core.nth.call(null,vec__11629,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__8388__auto__ = source;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__8388__auto__ = line;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__8388__auto__ = col;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__8388__auto__ = name;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta.call(null,nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__11632 = segmap;
var map__11632__$1 = ((((!((map__11632 == null)))?((((map__11632.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11632.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11632):map__11632);
var gcol = cljs.core.get.call(null,map__11632__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__11632__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__11632__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__11632__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__11632__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.call(null,((function (map__11632,map__11632__$1,gcol,source,line,col,name,d,d__$1){
return (function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.call(null,((function (map__11632,map__11632__$1,gcol,source,line,col,name,d,d__$1){
return (function (m__$1){
return cljs.core.update_in.call(null,m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.call(null,((function (map__11632,map__11632__$1,gcol,source,line,col,name,d,d__$1){
return (function (v){
return cljs.core.conj.call(null,v,d__$1);
});})(map__11632,map__11632__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.PersistentVector.EMPTY));
});})(map__11632,map__11632__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map.call(null)));
});})(map__11632,map__11632__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__11635 = arguments.length;
switch (G__11635) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.call(null,goog.object.get(source_map,"mappings"),source_map);
});

cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by.call(null,cljs.source_map.source_compare.call(null,sources));
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__11636 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__11640 = cljs.core.next.call(null,segs__$1);
var G__11641 = nrelseg;
var G__11642 = cljs.source_map.update_reverse_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__11640;
relseg__$1 = G__11641;
result__$1 = G__11642;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__11636,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__11636,(1),null);
var G__11643 = (gline + (1));
var G__11644 = cljs.core.next.call(null,lines__$1);
var G__11645 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__11646 = result__$1;
gline = G__11643;
lines__$1 = G__11644;
relseg = G__11645;
result = G__11646;
continue;
} else {
return result;
}
break;
}
});

cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2;

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__11648 = segmap;
var map__11648__$1 = ((((!((map__11648 == null)))?((((map__11648.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11648.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11648):map__11648);
var gcol = cljs.core.get.call(null,map__11648__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__11648__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__11648__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__11648__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__11648__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.call(null,((function (map__11648,map__11648__$1,gcol,source,line,col,name,d,d__$1){
return (function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.call(null,((function (map__11648,map__11648__$1,gcol,source,line,col,name,d,d__$1){
return (function (p1__11647_SHARP_){
return cljs.core.conj.call(null,p1__11647_SHARP_,d__$1);
});})(map__11648,map__11648__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.PersistentVector.EMPTY));
});})(map__11648,map__11648__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__11651 = arguments.length;
switch (G__11651) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.call(null,goog.object.get(source_map,"mappings"),source_map);
});

cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__11652 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__11656 = cljs.core.next.call(null,segs__$1);
var G__11657 = nrelseg;
var G__11658 = cljs.source_map.update_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__11656;
relseg__$1 = G__11657;
result__$1 = G__11658;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__11652,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__11652,(1),null);
var G__11659 = (gline + (1));
var G__11660 = cljs.core.next.call(null,lines__$1);
var G__11661 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__11662 = result__$1;
gline = G__11659;
lines__$1 = G__11660;
relseg = G__11661;
result = G__11662;
continue;
} else {
return result;
}
break;
}
});

cljs.source_map.decode.cljs$lang$maxFixedArity = 2;

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.call(null,((function (relseg){
return (function (segs,cols){
cljs.core.swap_BANG_.call(null,relseg,((function (relseg){
return (function (p__11663){
var vec__11664 = p__11663;
var _ = cljs.core.nth.call(null,vec__11664,(0),null);
var source = cljs.core.nth.call(null,vec__11664,(1),null);
var line = cljs.core.nth.call(null,vec__11664,(2),null);
var col = cljs.core.nth.call(null,vec__11664,(3),null);
var name = cljs.core.nth.call(null,vec__11664,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
});})(relseg))
);

return cljs.core.conj.call(null,segs,cljs.core.reduce.call(null,((function (relseg){
return (function (cols__$1,p__11667){
var vec__11668 = p__11667;
var gcol = cljs.core.nth.call(null,vec__11668,(0),null);
var sidx = cljs.core.nth.call(null,vec__11668,(1),null);
var line = cljs.core.nth.call(null,vec__11668,(2),null);
var col = cljs.core.nth.call(null,vec__11668,(3),null);
var name = cljs.core.nth.call(null,vec__11668,(4),null);
var seg = vec__11668;
var offset = cljs.core.map.call(null,cljs.core._,seg,cljs.core.deref.call(null,relseg));
cljs.core.swap_BANG_.call(null,relseg,((function (offset,vec__11668,gcol,sidx,line,col,name,seg,relseg){
return (function (p__11671){
var vec__11672 = p__11671;
var _ = cljs.core.nth.call(null,vec__11672,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__11672,(1),null);
var ___$2 = cljs.core.nth.call(null,vec__11672,(2),null);
var ___$3 = cljs.core.nth.call(null,vec__11672,(3),null);
var lname = cljs.core.nth.call(null,vec__11672,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__8388__auto__ = name;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return lname;
}
})()], null);
});})(offset,vec__11668,gcol,sidx,line,col,name,seg,relseg))
);

return cljs.core.conj.call(null,cols__$1,cljs.source_map.base64_vlq.encode.call(null,offset));
});})(relseg))
,cljs.core.PersistentVector.EMPTY,cols));
});})(relseg))
,cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.call(null,(0));
var preamble_lines = cljs.core.take.call(null,(function (){var or__8388__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY));
var info__GT_segv = ((function (lines,names__GT_idx,name_idx,preamble_lines){
return (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5455__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5455__auto__)){
var name = temp__5455__auto__;
var idx = (function (){var temp__5455__auto____$1 = cljs.core.get.call(null,cljs.core.deref.call(null,names__GT_idx),name);
if(cljs.core.truth_(temp__5455__auto____$1)){
var idx = temp__5455__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref.call(null,name_idx);
cljs.core.swap_BANG_.call(null,names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.call(null,name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.call(null,segv,idx);
} else {
return segv;
}
});})(lines,names__GT_idx,name_idx,preamble_lines))
;
var encode_cols = ((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (infos,source_idx,line,col){
var seq__11678 = cljs.core.seq.call(null,infos);
var chunk__11679 = null;
var count__11680 = (0);
var i__11681 = (0);
while(true){
if((i__11681 < count__11680)){
var info = cljs.core._nth.call(null,chunk__11679,i__11681);
var segv_11760 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_11761 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_11762 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_11761 > (lc_11762 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__11678,chunk__11679,count__11680,i__11681,segv_11760,gline_11761,lc_11762,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_11761 - (lc_11762 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_11760], null));
});})(seq__11678,chunk__11679,count__11680,i__11681,segv_11760,gline_11761,lc_11762,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__11678,chunk__11679,count__11680,i__11681,segv_11760,gline_11761,lc_11762,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11761], null),cljs.core.conj,segv_11760);
});})(seq__11678,chunk__11679,count__11680,i__11681,segv_11760,gline_11761,lc_11762,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}

var G__11763 = seq__11678;
var G__11764 = chunk__11679;
var G__11765 = count__11680;
var G__11766 = (i__11681 + (1));
seq__11678 = G__11763;
chunk__11679 = G__11764;
count__11680 = G__11765;
i__11681 = G__11766;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__11678);
if(temp__5457__auto__){
var seq__11678__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11678__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__11678__$1);
var G__11767 = cljs.core.chunk_rest.call(null,seq__11678__$1);
var G__11768 = c__9319__auto__;
var G__11769 = cljs.core.count.call(null,c__9319__auto__);
var G__11770 = (0);
seq__11678 = G__11767;
chunk__11679 = G__11768;
count__11680 = G__11769;
i__11681 = G__11770;
continue;
} else {
var info = cljs.core.first.call(null,seq__11678__$1);
var segv_11771 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_11772 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_11773 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_11772 > (lc_11773 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__11678,chunk__11679,count__11680,i__11681,segv_11771,gline_11772,lc_11773,info,seq__11678__$1,temp__5457__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_11772 - (lc_11773 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_11771], null));
});})(seq__11678,chunk__11679,count__11680,i__11681,segv_11771,gline_11772,lc_11773,info,seq__11678__$1,temp__5457__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__11678,chunk__11679,count__11680,i__11681,segv_11771,gline_11772,lc_11773,info,seq__11678__$1,temp__5457__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11772], null),cljs.core.conj,segv_11771);
});})(seq__11678,chunk__11679,count__11680,i__11681,segv_11771,gline_11772,lc_11773,info,seq__11678__$1,temp__5457__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}

var G__11774 = cljs.core.next.call(null,seq__11678__$1);
var G__11775 = null;
var G__11776 = (0);
var G__11777 = (0);
seq__11678 = G__11774;
chunk__11679 = G__11775;
count__11680 = G__11776;
i__11681 = G__11777;
continue;
}
} else {
return null;
}
}
break;
}
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
;
var seq__11682_11778 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__11683_11779 = null;
var count__11684_11780 = (0);
var i__11685_11781 = (0);
while(true){
if((i__11685_11781 < count__11684_11780)){
var vec__11686_11782 = cljs.core._nth.call(null,chunk__11683_11779,i__11685_11781);
var source_idx_11783 = cljs.core.nth.call(null,vec__11686_11782,(0),null);
var vec__11689_11784 = cljs.core.nth.call(null,vec__11686_11782,(1),null);
var __11785 = cljs.core.nth.call(null,vec__11689_11784,(0),null);
var lines_11786__$1 = cljs.core.nth.call(null,vec__11689_11784,(1),null);
var seq__11692_11787 = cljs.core.seq.call(null,lines_11786__$1);
var chunk__11693_11788 = null;
var count__11694_11789 = (0);
var i__11695_11790 = (0);
while(true){
if((i__11695_11790 < count__11694_11789)){
var vec__11696_11791 = cljs.core._nth.call(null,chunk__11693_11788,i__11695_11790);
var line_11792 = cljs.core.nth.call(null,vec__11696_11791,(0),null);
var cols_11793 = cljs.core.nth.call(null,vec__11696_11791,(1),null);
var seq__11699_11794 = cljs.core.seq.call(null,cols_11793);
var chunk__11700_11795 = null;
var count__11701_11796 = (0);
var i__11702_11797 = (0);
while(true){
if((i__11702_11797 < count__11701_11796)){
var vec__11703_11798 = cljs.core._nth.call(null,chunk__11700_11795,i__11702_11797);
var col_11799 = cljs.core.nth.call(null,vec__11703_11798,(0),null);
var infos_11800 = cljs.core.nth.call(null,vec__11703_11798,(1),null);
encode_cols.call(null,infos_11800,source_idx_11783,line_11792,col_11799);

var G__11801 = seq__11699_11794;
var G__11802 = chunk__11700_11795;
var G__11803 = count__11701_11796;
var G__11804 = (i__11702_11797 + (1));
seq__11699_11794 = G__11801;
chunk__11700_11795 = G__11802;
count__11701_11796 = G__11803;
i__11702_11797 = G__11804;
continue;
} else {
var temp__5457__auto___11805 = cljs.core.seq.call(null,seq__11699_11794);
if(temp__5457__auto___11805){
var seq__11699_11806__$1 = temp__5457__auto___11805;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11699_11806__$1)){
var c__9319__auto___11807 = cljs.core.chunk_first.call(null,seq__11699_11806__$1);
var G__11808 = cljs.core.chunk_rest.call(null,seq__11699_11806__$1);
var G__11809 = c__9319__auto___11807;
var G__11810 = cljs.core.count.call(null,c__9319__auto___11807);
var G__11811 = (0);
seq__11699_11794 = G__11808;
chunk__11700_11795 = G__11809;
count__11701_11796 = G__11810;
i__11702_11797 = G__11811;
continue;
} else {
var vec__11706_11812 = cljs.core.first.call(null,seq__11699_11806__$1);
var col_11813 = cljs.core.nth.call(null,vec__11706_11812,(0),null);
var infos_11814 = cljs.core.nth.call(null,vec__11706_11812,(1),null);
encode_cols.call(null,infos_11814,source_idx_11783,line_11792,col_11813);

var G__11815 = cljs.core.next.call(null,seq__11699_11806__$1);
var G__11816 = null;
var G__11817 = (0);
var G__11818 = (0);
seq__11699_11794 = G__11815;
chunk__11700_11795 = G__11816;
count__11701_11796 = G__11817;
i__11702_11797 = G__11818;
continue;
}
} else {
}
}
break;
}

var G__11819 = seq__11692_11787;
var G__11820 = chunk__11693_11788;
var G__11821 = count__11694_11789;
var G__11822 = (i__11695_11790 + (1));
seq__11692_11787 = G__11819;
chunk__11693_11788 = G__11820;
count__11694_11789 = G__11821;
i__11695_11790 = G__11822;
continue;
} else {
var temp__5457__auto___11823 = cljs.core.seq.call(null,seq__11692_11787);
if(temp__5457__auto___11823){
var seq__11692_11824__$1 = temp__5457__auto___11823;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11692_11824__$1)){
var c__9319__auto___11825 = cljs.core.chunk_first.call(null,seq__11692_11824__$1);
var G__11826 = cljs.core.chunk_rest.call(null,seq__11692_11824__$1);
var G__11827 = c__9319__auto___11825;
var G__11828 = cljs.core.count.call(null,c__9319__auto___11825);
var G__11829 = (0);
seq__11692_11787 = G__11826;
chunk__11693_11788 = G__11827;
count__11694_11789 = G__11828;
i__11695_11790 = G__11829;
continue;
} else {
var vec__11709_11830 = cljs.core.first.call(null,seq__11692_11824__$1);
var line_11831 = cljs.core.nth.call(null,vec__11709_11830,(0),null);
var cols_11832 = cljs.core.nth.call(null,vec__11709_11830,(1),null);
var seq__11712_11833 = cljs.core.seq.call(null,cols_11832);
var chunk__11713_11834 = null;
var count__11714_11835 = (0);
var i__11715_11836 = (0);
while(true){
if((i__11715_11836 < count__11714_11835)){
var vec__11716_11837 = cljs.core._nth.call(null,chunk__11713_11834,i__11715_11836);
var col_11838 = cljs.core.nth.call(null,vec__11716_11837,(0),null);
var infos_11839 = cljs.core.nth.call(null,vec__11716_11837,(1),null);
encode_cols.call(null,infos_11839,source_idx_11783,line_11831,col_11838);

var G__11840 = seq__11712_11833;
var G__11841 = chunk__11713_11834;
var G__11842 = count__11714_11835;
var G__11843 = (i__11715_11836 + (1));
seq__11712_11833 = G__11840;
chunk__11713_11834 = G__11841;
count__11714_11835 = G__11842;
i__11715_11836 = G__11843;
continue;
} else {
var temp__5457__auto___11844__$1 = cljs.core.seq.call(null,seq__11712_11833);
if(temp__5457__auto___11844__$1){
var seq__11712_11845__$1 = temp__5457__auto___11844__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11712_11845__$1)){
var c__9319__auto___11846 = cljs.core.chunk_first.call(null,seq__11712_11845__$1);
var G__11847 = cljs.core.chunk_rest.call(null,seq__11712_11845__$1);
var G__11848 = c__9319__auto___11846;
var G__11849 = cljs.core.count.call(null,c__9319__auto___11846);
var G__11850 = (0);
seq__11712_11833 = G__11847;
chunk__11713_11834 = G__11848;
count__11714_11835 = G__11849;
i__11715_11836 = G__11850;
continue;
} else {
var vec__11719_11851 = cljs.core.first.call(null,seq__11712_11845__$1);
var col_11852 = cljs.core.nth.call(null,vec__11719_11851,(0),null);
var infos_11853 = cljs.core.nth.call(null,vec__11719_11851,(1),null);
encode_cols.call(null,infos_11853,source_idx_11783,line_11831,col_11852);

var G__11854 = cljs.core.next.call(null,seq__11712_11845__$1);
var G__11855 = null;
var G__11856 = (0);
var G__11857 = (0);
seq__11712_11833 = G__11854;
chunk__11713_11834 = G__11855;
count__11714_11835 = G__11856;
i__11715_11836 = G__11857;
continue;
}
} else {
}
}
break;
}

var G__11858 = cljs.core.next.call(null,seq__11692_11824__$1);
var G__11859 = null;
var G__11860 = (0);
var G__11861 = (0);
seq__11692_11787 = G__11858;
chunk__11693_11788 = G__11859;
count__11694_11789 = G__11860;
i__11695_11790 = G__11861;
continue;
}
} else {
}
}
break;
}

var G__11862 = seq__11682_11778;
var G__11863 = chunk__11683_11779;
var G__11864 = count__11684_11780;
var G__11865 = (i__11685_11781 + (1));
seq__11682_11778 = G__11862;
chunk__11683_11779 = G__11863;
count__11684_11780 = G__11864;
i__11685_11781 = G__11865;
continue;
} else {
var temp__5457__auto___11866 = cljs.core.seq.call(null,seq__11682_11778);
if(temp__5457__auto___11866){
var seq__11682_11867__$1 = temp__5457__auto___11866;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11682_11867__$1)){
var c__9319__auto___11868 = cljs.core.chunk_first.call(null,seq__11682_11867__$1);
var G__11869 = cljs.core.chunk_rest.call(null,seq__11682_11867__$1);
var G__11870 = c__9319__auto___11868;
var G__11871 = cljs.core.count.call(null,c__9319__auto___11868);
var G__11872 = (0);
seq__11682_11778 = G__11869;
chunk__11683_11779 = G__11870;
count__11684_11780 = G__11871;
i__11685_11781 = G__11872;
continue;
} else {
var vec__11722_11873 = cljs.core.first.call(null,seq__11682_11867__$1);
var source_idx_11874 = cljs.core.nth.call(null,vec__11722_11873,(0),null);
var vec__11725_11875 = cljs.core.nth.call(null,vec__11722_11873,(1),null);
var __11876 = cljs.core.nth.call(null,vec__11725_11875,(0),null);
var lines_11877__$1 = cljs.core.nth.call(null,vec__11725_11875,(1),null);
var seq__11728_11878 = cljs.core.seq.call(null,lines_11877__$1);
var chunk__11729_11879 = null;
var count__11730_11880 = (0);
var i__11731_11881 = (0);
while(true){
if((i__11731_11881 < count__11730_11880)){
var vec__11732_11882 = cljs.core._nth.call(null,chunk__11729_11879,i__11731_11881);
var line_11883 = cljs.core.nth.call(null,vec__11732_11882,(0),null);
var cols_11884 = cljs.core.nth.call(null,vec__11732_11882,(1),null);
var seq__11735_11885 = cljs.core.seq.call(null,cols_11884);
var chunk__11736_11886 = null;
var count__11737_11887 = (0);
var i__11738_11888 = (0);
while(true){
if((i__11738_11888 < count__11737_11887)){
var vec__11739_11889 = cljs.core._nth.call(null,chunk__11736_11886,i__11738_11888);
var col_11890 = cljs.core.nth.call(null,vec__11739_11889,(0),null);
var infos_11891 = cljs.core.nth.call(null,vec__11739_11889,(1),null);
encode_cols.call(null,infos_11891,source_idx_11874,line_11883,col_11890);

var G__11892 = seq__11735_11885;
var G__11893 = chunk__11736_11886;
var G__11894 = count__11737_11887;
var G__11895 = (i__11738_11888 + (1));
seq__11735_11885 = G__11892;
chunk__11736_11886 = G__11893;
count__11737_11887 = G__11894;
i__11738_11888 = G__11895;
continue;
} else {
var temp__5457__auto___11896__$1 = cljs.core.seq.call(null,seq__11735_11885);
if(temp__5457__auto___11896__$1){
var seq__11735_11897__$1 = temp__5457__auto___11896__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11735_11897__$1)){
var c__9319__auto___11898 = cljs.core.chunk_first.call(null,seq__11735_11897__$1);
var G__11899 = cljs.core.chunk_rest.call(null,seq__11735_11897__$1);
var G__11900 = c__9319__auto___11898;
var G__11901 = cljs.core.count.call(null,c__9319__auto___11898);
var G__11902 = (0);
seq__11735_11885 = G__11899;
chunk__11736_11886 = G__11900;
count__11737_11887 = G__11901;
i__11738_11888 = G__11902;
continue;
} else {
var vec__11742_11903 = cljs.core.first.call(null,seq__11735_11897__$1);
var col_11904 = cljs.core.nth.call(null,vec__11742_11903,(0),null);
var infos_11905 = cljs.core.nth.call(null,vec__11742_11903,(1),null);
encode_cols.call(null,infos_11905,source_idx_11874,line_11883,col_11904);

var G__11906 = cljs.core.next.call(null,seq__11735_11897__$1);
var G__11907 = null;
var G__11908 = (0);
var G__11909 = (0);
seq__11735_11885 = G__11906;
chunk__11736_11886 = G__11907;
count__11737_11887 = G__11908;
i__11738_11888 = G__11909;
continue;
}
} else {
}
}
break;
}

var G__11910 = seq__11728_11878;
var G__11911 = chunk__11729_11879;
var G__11912 = count__11730_11880;
var G__11913 = (i__11731_11881 + (1));
seq__11728_11878 = G__11910;
chunk__11729_11879 = G__11911;
count__11730_11880 = G__11912;
i__11731_11881 = G__11913;
continue;
} else {
var temp__5457__auto___11914__$1 = cljs.core.seq.call(null,seq__11728_11878);
if(temp__5457__auto___11914__$1){
var seq__11728_11915__$1 = temp__5457__auto___11914__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11728_11915__$1)){
var c__9319__auto___11916 = cljs.core.chunk_first.call(null,seq__11728_11915__$1);
var G__11917 = cljs.core.chunk_rest.call(null,seq__11728_11915__$1);
var G__11918 = c__9319__auto___11916;
var G__11919 = cljs.core.count.call(null,c__9319__auto___11916);
var G__11920 = (0);
seq__11728_11878 = G__11917;
chunk__11729_11879 = G__11918;
count__11730_11880 = G__11919;
i__11731_11881 = G__11920;
continue;
} else {
var vec__11745_11921 = cljs.core.first.call(null,seq__11728_11915__$1);
var line_11922 = cljs.core.nth.call(null,vec__11745_11921,(0),null);
var cols_11923 = cljs.core.nth.call(null,vec__11745_11921,(1),null);
var seq__11748_11924 = cljs.core.seq.call(null,cols_11923);
var chunk__11749_11925 = null;
var count__11750_11926 = (0);
var i__11751_11927 = (0);
while(true){
if((i__11751_11927 < count__11750_11926)){
var vec__11752_11928 = cljs.core._nth.call(null,chunk__11749_11925,i__11751_11927);
var col_11929 = cljs.core.nth.call(null,vec__11752_11928,(0),null);
var infos_11930 = cljs.core.nth.call(null,vec__11752_11928,(1),null);
encode_cols.call(null,infos_11930,source_idx_11874,line_11922,col_11929);

var G__11931 = seq__11748_11924;
var G__11932 = chunk__11749_11925;
var G__11933 = count__11750_11926;
var G__11934 = (i__11751_11927 + (1));
seq__11748_11924 = G__11931;
chunk__11749_11925 = G__11932;
count__11750_11926 = G__11933;
i__11751_11927 = G__11934;
continue;
} else {
var temp__5457__auto___11935__$2 = cljs.core.seq.call(null,seq__11748_11924);
if(temp__5457__auto___11935__$2){
var seq__11748_11936__$1 = temp__5457__auto___11935__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11748_11936__$1)){
var c__9319__auto___11937 = cljs.core.chunk_first.call(null,seq__11748_11936__$1);
var G__11938 = cljs.core.chunk_rest.call(null,seq__11748_11936__$1);
var G__11939 = c__9319__auto___11937;
var G__11940 = cljs.core.count.call(null,c__9319__auto___11937);
var G__11941 = (0);
seq__11748_11924 = G__11938;
chunk__11749_11925 = G__11939;
count__11750_11926 = G__11940;
i__11751_11927 = G__11941;
continue;
} else {
var vec__11755_11942 = cljs.core.first.call(null,seq__11748_11936__$1);
var col_11943 = cljs.core.nth.call(null,vec__11755_11942,(0),null);
var infos_11944 = cljs.core.nth.call(null,vec__11755_11942,(1),null);
encode_cols.call(null,infos_11944,source_idx_11874,line_11922,col_11943);

var G__11945 = cljs.core.next.call(null,seq__11748_11936__$1);
var G__11946 = null;
var G__11947 = (0);
var G__11948 = (0);
seq__11748_11924 = G__11945;
chunk__11749_11925 = G__11946;
count__11750_11926 = G__11947;
i__11751_11927 = G__11948;
continue;
}
} else {
}
}
break;
}

var G__11949 = cljs.core.next.call(null,seq__11728_11915__$1);
var G__11950 = null;
var G__11951 = (0);
var G__11952 = (0);
seq__11728_11878 = G__11949;
chunk__11729_11879 = G__11950;
count__11730_11880 = G__11951;
i__11731_11881 = G__11952;
continue;
}
} else {
}
}
break;
}

var G__11953 = cljs.core.next.call(null,seq__11682_11867__$1);
var G__11954 = null;
var G__11955 = (0);
var G__11956 = (0);
seq__11682_11778 = G__11953;
chunk__11683_11779 = G__11954;
count__11684_11780 = G__11955;
i__11685_11781 = G__11956;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__11758 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys.call(null,m);
var f = cljs.core.comp.call(null,((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?((function (paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__11675_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__11675_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
});})(paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
:cljs.core.identity),((function (paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__11676_SHARP_){
return cljs.core.last.call(null,clojure.string.split.call(null,p1__11676_SHARP_,/\//));
});})(paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
);
return cljs.core.into_array.call(null,cljs.core.map.call(null,f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.call(null,";",cljs.core.map.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__11677_SHARP_){
return clojure.string.join.call(null,",",p1__11677_SHARP_);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,cljs.source_map.lines__GT_segs.call(null,cljs.core.concat.call(null,preamble_lines,cljs.core.deref.call(null,lines))))), "names": cljs.core.into_array.call(null,cljs.core.map.call(null,clojure.set.map_invert.call(null,cljs.core.deref.call(null,names__GT_idx)),cljs.core.range.call(null,cljs.core.count.call(null,cljs.core.deref.call(null,names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__11759 = G__11758;
goog.object.set(G__11759,"sourcesContent",cljs.core.into_array.call(null,new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__11759;
} else {
return G__11758;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq.call(null,cljs_map);
var new_lines = cljs.core.sorted_map.call(null);
while(true){
if(line_map_seq){
var vec__11957 = cljs.core.first.call(null,line_map_seq);
var line = cljs.core.nth.call(null,vec__11957,(0),null);
var col_map = cljs.core.nth.call(null,vec__11957,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq.call(null,col_map);
var new_cols = cljs.core.sorted_map.call(null);
while(true){
if(col_map_seq){
var vec__11960 = cljs.core.first.call(null,col_map_seq);
var col = cljs.core.nth.call(null,vec__11960,(0),null);
var infos = cljs.core.nth.call(null,vec__11960,(1),null);
var G__11966 = cljs.core.next.call(null,col_map_seq);
var G__11967 = cljs.core.assoc.call(null,new_cols,col,cljs.core.reduce.call(null,((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__11960,col,infos,vec__11957,line,col_map){
return (function (v,p__11963){
var map__11964 = p__11963;
var map__11964__$1 = ((((!((map__11964 == null)))?((((map__11964.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11964.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11964):map__11964);
var gline = cljs.core.get.call(null,map__11964__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.call(null,map__11964__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.call(null,v,cljs.core.get_in.call(null,js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__11960,col,infos,vec__11957,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__11966;
new_cols = G__11967;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__11968 = cljs.core.next.call(null,line_map_seq);
var G__11969 = cljs.core.assoc.call(null,new_lines,line,new_cols);
line_map_seq = G__11968;
new_lines = G__11969;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.call(null,cljs.core.sorted_map.call(null));
var seq__11970_12032 = cljs.core.seq.call(null,reverse_map);
var chunk__11971_12033 = null;
var count__11972_12034 = (0);
var i__11973_12035 = (0);
while(true){
if((i__11973_12035 < count__11972_12034)){
var vec__11974_12036 = cljs.core._nth.call(null,chunk__11971_12033,i__11973_12035);
var line_12037 = cljs.core.nth.call(null,vec__11974_12036,(0),null);
var columns_12038 = cljs.core.nth.call(null,vec__11974_12036,(1),null);
var seq__11977_12039 = cljs.core.seq.call(null,columns_12038);
var chunk__11978_12040 = null;
var count__11979_12041 = (0);
var i__11980_12042 = (0);
while(true){
if((i__11980_12042 < count__11979_12041)){
var vec__11981_12043 = cljs.core._nth.call(null,chunk__11978_12040,i__11980_12042);
var column_12044 = cljs.core.nth.call(null,vec__11981_12043,(0),null);
var column_info_12045 = cljs.core.nth.call(null,vec__11981_12043,(1),null);
var seq__11984_12046 = cljs.core.seq.call(null,column_info_12045);
var chunk__11985_12047 = null;
var count__11986_12048 = (0);
var i__11987_12049 = (0);
while(true){
if((i__11987_12049 < count__11986_12048)){
var map__11988_12050 = cljs.core._nth.call(null,chunk__11985_12047,i__11987_12049);
var map__11988_12051__$1 = ((((!((map__11988_12050 == null)))?((((map__11988_12050.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11988_12050.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11988_12050):map__11988_12050);
var gline_12052 = cljs.core.get.call(null,map__11988_12051__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_12053 = cljs.core.get.call(null,map__11988_12051__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_12054 = cljs.core.get.call(null,map__11988_12051__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12052], null),cljs.core.fnil.call(null,((function (seq__11984_12046,chunk__11985_12047,count__11986_12048,i__11987_12049,seq__11977_12039,chunk__11978_12040,count__11979_12041,i__11980_12042,seq__11970_12032,chunk__11971_12033,count__11972_12034,i__11973_12035,map__11988_12050,map__11988_12051__$1,gline_12052,gcol_12053,name_12054,vec__11981_12043,column_12044,column_info_12045,vec__11974_12036,line_12037,columns_12038,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_12053], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_12037,new cljs.core.Keyword(null,"col","col",-1959363084),column_12044,new cljs.core.Keyword(null,"name","name",1843675177),name_12054], null));
});})(seq__11984_12046,chunk__11985_12047,count__11986_12048,i__11987_12049,seq__11977_12039,chunk__11978_12040,count__11979_12041,i__11980_12042,seq__11970_12032,chunk__11971_12033,count__11972_12034,i__11973_12035,map__11988_12050,map__11988_12051__$1,gline_12052,gcol_12053,name_12054,vec__11981_12043,column_12044,column_info_12045,vec__11974_12036,line_12037,columns_12038,inverted))
,cljs.core.sorted_map.call(null)));

var G__12055 = seq__11984_12046;
var G__12056 = chunk__11985_12047;
var G__12057 = count__11986_12048;
var G__12058 = (i__11987_12049 + (1));
seq__11984_12046 = G__12055;
chunk__11985_12047 = G__12056;
count__11986_12048 = G__12057;
i__11987_12049 = G__12058;
continue;
} else {
var temp__5457__auto___12059 = cljs.core.seq.call(null,seq__11984_12046);
if(temp__5457__auto___12059){
var seq__11984_12060__$1 = temp__5457__auto___12059;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11984_12060__$1)){
var c__9319__auto___12061 = cljs.core.chunk_first.call(null,seq__11984_12060__$1);
var G__12062 = cljs.core.chunk_rest.call(null,seq__11984_12060__$1);
var G__12063 = c__9319__auto___12061;
var G__12064 = cljs.core.count.call(null,c__9319__auto___12061);
var G__12065 = (0);
seq__11984_12046 = G__12062;
chunk__11985_12047 = G__12063;
count__11986_12048 = G__12064;
i__11987_12049 = G__12065;
continue;
} else {
var map__11990_12066 = cljs.core.first.call(null,seq__11984_12060__$1);
var map__11990_12067__$1 = ((((!((map__11990_12066 == null)))?((((map__11990_12066.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11990_12066.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11990_12066):map__11990_12066);
var gline_12068 = cljs.core.get.call(null,map__11990_12067__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_12069 = cljs.core.get.call(null,map__11990_12067__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_12070 = cljs.core.get.call(null,map__11990_12067__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12068], null),cljs.core.fnil.call(null,((function (seq__11984_12046,chunk__11985_12047,count__11986_12048,i__11987_12049,seq__11977_12039,chunk__11978_12040,count__11979_12041,i__11980_12042,seq__11970_12032,chunk__11971_12033,count__11972_12034,i__11973_12035,map__11990_12066,map__11990_12067__$1,gline_12068,gcol_12069,name_12070,seq__11984_12060__$1,temp__5457__auto___12059,vec__11981_12043,column_12044,column_info_12045,vec__11974_12036,line_12037,columns_12038,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_12069], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_12037,new cljs.core.Keyword(null,"col","col",-1959363084),column_12044,new cljs.core.Keyword(null,"name","name",1843675177),name_12070], null));
});})(seq__11984_12046,chunk__11985_12047,count__11986_12048,i__11987_12049,seq__11977_12039,chunk__11978_12040,count__11979_12041,i__11980_12042,seq__11970_12032,chunk__11971_12033,count__11972_12034,i__11973_12035,map__11990_12066,map__11990_12067__$1,gline_12068,gcol_12069,name_12070,seq__11984_12060__$1,temp__5457__auto___12059,vec__11981_12043,column_12044,column_info_12045,vec__11974_12036,line_12037,columns_12038,inverted))
,cljs.core.sorted_map.call(null)));

var G__12071 = cljs.core.next.call(null,seq__11984_12060__$1);
var G__12072 = null;
var G__12073 = (0);
var G__12074 = (0);
seq__11984_12046 = G__12071;
chunk__11985_12047 = G__12072;
count__11986_12048 = G__12073;
i__11987_12049 = G__12074;
continue;
}
} else {
}
}
break;
}

var G__12075 = seq__11977_12039;
var G__12076 = chunk__11978_12040;
var G__12077 = count__11979_12041;
var G__12078 = (i__11980_12042 + (1));
seq__11977_12039 = G__12075;
chunk__11978_12040 = G__12076;
count__11979_12041 = G__12077;
i__11980_12042 = G__12078;
continue;
} else {
var temp__5457__auto___12079 = cljs.core.seq.call(null,seq__11977_12039);
if(temp__5457__auto___12079){
var seq__11977_12080__$1 = temp__5457__auto___12079;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11977_12080__$1)){
var c__9319__auto___12081 = cljs.core.chunk_first.call(null,seq__11977_12080__$1);
var G__12082 = cljs.core.chunk_rest.call(null,seq__11977_12080__$1);
var G__12083 = c__9319__auto___12081;
var G__12084 = cljs.core.count.call(null,c__9319__auto___12081);
var G__12085 = (0);
seq__11977_12039 = G__12082;
chunk__11978_12040 = G__12083;
count__11979_12041 = G__12084;
i__11980_12042 = G__12085;
continue;
} else {
var vec__11992_12086 = cljs.core.first.call(null,seq__11977_12080__$1);
var column_12087 = cljs.core.nth.call(null,vec__11992_12086,(0),null);
var column_info_12088 = cljs.core.nth.call(null,vec__11992_12086,(1),null);
var seq__11995_12089 = cljs.core.seq.call(null,column_info_12088);
var chunk__11996_12090 = null;
var count__11997_12091 = (0);
var i__11998_12092 = (0);
while(true){
if((i__11998_12092 < count__11997_12091)){
var map__11999_12093 = cljs.core._nth.call(null,chunk__11996_12090,i__11998_12092);
var map__11999_12094__$1 = ((((!((map__11999_12093 == null)))?((((map__11999_12093.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11999_12093.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11999_12093):map__11999_12093);
var gline_12095 = cljs.core.get.call(null,map__11999_12094__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_12096 = cljs.core.get.call(null,map__11999_12094__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_12097 = cljs.core.get.call(null,map__11999_12094__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12095], null),cljs.core.fnil.call(null,((function (seq__11995_12089,chunk__11996_12090,count__11997_12091,i__11998_12092,seq__11977_12039,chunk__11978_12040,count__11979_12041,i__11980_12042,seq__11970_12032,chunk__11971_12033,count__11972_12034,i__11973_12035,map__11999_12093,map__11999_12094__$1,gline_12095,gcol_12096,name_12097,vec__11992_12086,column_12087,column_info_12088,seq__11977_12080__$1,temp__5457__auto___12079,vec__11974_12036,line_12037,columns_12038,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_12096], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_12037,new cljs.core.Keyword(null,"col","col",-1959363084),column_12087,new cljs.core.Keyword(null,"name","name",1843675177),name_12097], null));
});})(seq__11995_12089,chunk__11996_12090,count__11997_12091,i__11998_12092,seq__11977_12039,chunk__11978_12040,count__11979_12041,i__11980_12042,seq__11970_12032,chunk__11971_12033,count__11972_12034,i__11973_12035,map__11999_12093,map__11999_12094__$1,gline_12095,gcol_12096,name_12097,vec__11992_12086,column_12087,column_info_12088,seq__11977_12080__$1,temp__5457__auto___12079,vec__11974_12036,line_12037,columns_12038,inverted))
,cljs.core.sorted_map.call(null)));

var G__12098 = seq__11995_12089;
var G__12099 = chunk__11996_12090;
var G__12100 = count__11997_12091;
var G__12101 = (i__11998_12092 + (1));
seq__11995_12089 = G__12098;
chunk__11996_12090 = G__12099;
count__11997_12091 = G__12100;
i__11998_12092 = G__12101;
continue;
} else {
var temp__5457__auto___12102__$1 = cljs.core.seq.call(null,seq__11995_12089);
if(temp__5457__auto___12102__$1){
var seq__11995_12103__$1 = temp__5457__auto___12102__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11995_12103__$1)){
var c__9319__auto___12104 = cljs.core.chunk_first.call(null,seq__11995_12103__$1);
var G__12105 = cljs.core.chunk_rest.call(null,seq__11995_12103__$1);
var G__12106 = c__9319__auto___12104;
var G__12107 = cljs.core.count.call(null,c__9319__auto___12104);
var G__12108 = (0);
seq__11995_12089 = G__12105;
chunk__11996_12090 = G__12106;
count__11997_12091 = G__12107;
i__11998_12092 = G__12108;
continue;
} else {
var map__12001_12109 = cljs.core.first.call(null,seq__11995_12103__$1);
var map__12001_12110__$1 = ((((!((map__12001_12109 == null)))?((((map__12001_12109.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12001_12109.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12001_12109):map__12001_12109);
var gline_12111 = cljs.core.get.call(null,map__12001_12110__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_12112 = cljs.core.get.call(null,map__12001_12110__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_12113 = cljs.core.get.call(null,map__12001_12110__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12111], null),cljs.core.fnil.call(null,((function (seq__11995_12089,chunk__11996_12090,count__11997_12091,i__11998_12092,seq__11977_12039,chunk__11978_12040,count__11979_12041,i__11980_12042,seq__11970_12032,chunk__11971_12033,count__11972_12034,i__11973_12035,map__12001_12109,map__12001_12110__$1,gline_12111,gcol_12112,name_12113,seq__11995_12103__$1,temp__5457__auto___12102__$1,vec__11992_12086,column_12087,column_info_12088,seq__11977_12080__$1,temp__5457__auto___12079,vec__11974_12036,line_12037,columns_12038,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_12112], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_12037,new cljs.core.Keyword(null,"col","col",-1959363084),column_12087,new cljs.core.Keyword(null,"name","name",1843675177),name_12113], null));
});})(seq__11995_12089,chunk__11996_12090,count__11997_12091,i__11998_12092,seq__11977_12039,chunk__11978_12040,count__11979_12041,i__11980_12042,seq__11970_12032,chunk__11971_12033,count__11972_12034,i__11973_12035,map__12001_12109,map__12001_12110__$1,gline_12111,gcol_12112,name_12113,seq__11995_12103__$1,temp__5457__auto___12102__$1,vec__11992_12086,column_12087,column_info_12088,seq__11977_12080__$1,temp__5457__auto___12079,vec__11974_12036,line_12037,columns_12038,inverted))
,cljs.core.sorted_map.call(null)));

var G__12114 = cljs.core.next.call(null,seq__11995_12103__$1);
var G__12115 = null;
var G__12116 = (0);
var G__12117 = (0);
seq__11995_12089 = G__12114;
chunk__11996_12090 = G__12115;
count__11997_12091 = G__12116;
i__11998_12092 = G__12117;
continue;
}
} else {
}
}
break;
}

var G__12118 = cljs.core.next.call(null,seq__11977_12080__$1);
var G__12119 = null;
var G__12120 = (0);
var G__12121 = (0);
seq__11977_12039 = G__12118;
chunk__11978_12040 = G__12119;
count__11979_12041 = G__12120;
i__11980_12042 = G__12121;
continue;
}
} else {
}
}
break;
}

var G__12122 = seq__11970_12032;
var G__12123 = chunk__11971_12033;
var G__12124 = count__11972_12034;
var G__12125 = (i__11973_12035 + (1));
seq__11970_12032 = G__12122;
chunk__11971_12033 = G__12123;
count__11972_12034 = G__12124;
i__11973_12035 = G__12125;
continue;
} else {
var temp__5457__auto___12126 = cljs.core.seq.call(null,seq__11970_12032);
if(temp__5457__auto___12126){
var seq__11970_12127__$1 = temp__5457__auto___12126;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11970_12127__$1)){
var c__9319__auto___12128 = cljs.core.chunk_first.call(null,seq__11970_12127__$1);
var G__12129 = cljs.core.chunk_rest.call(null,seq__11970_12127__$1);
var G__12130 = c__9319__auto___12128;
var G__12131 = cljs.core.count.call(null,c__9319__auto___12128);
var G__12132 = (0);
seq__11970_12032 = G__12129;
chunk__11971_12033 = G__12130;
count__11972_12034 = G__12131;
i__11973_12035 = G__12132;
continue;
} else {
var vec__12003_12133 = cljs.core.first.call(null,seq__11970_12127__$1);
var line_12134 = cljs.core.nth.call(null,vec__12003_12133,(0),null);
var columns_12135 = cljs.core.nth.call(null,vec__12003_12133,(1),null);
var seq__12006_12136 = cljs.core.seq.call(null,columns_12135);
var chunk__12007_12137 = null;
var count__12008_12138 = (0);
var i__12009_12139 = (0);
while(true){
if((i__12009_12139 < count__12008_12138)){
var vec__12010_12140 = cljs.core._nth.call(null,chunk__12007_12137,i__12009_12139);
var column_12141 = cljs.core.nth.call(null,vec__12010_12140,(0),null);
var column_info_12142 = cljs.core.nth.call(null,vec__12010_12140,(1),null);
var seq__12013_12143 = cljs.core.seq.call(null,column_info_12142);
var chunk__12014_12144 = null;
var count__12015_12145 = (0);
var i__12016_12146 = (0);
while(true){
if((i__12016_12146 < count__12015_12145)){
var map__12017_12147 = cljs.core._nth.call(null,chunk__12014_12144,i__12016_12146);
var map__12017_12148__$1 = ((((!((map__12017_12147 == null)))?((((map__12017_12147.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12017_12147.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12017_12147):map__12017_12147);
var gline_12149 = cljs.core.get.call(null,map__12017_12148__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_12150 = cljs.core.get.call(null,map__12017_12148__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_12151 = cljs.core.get.call(null,map__12017_12148__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12149], null),cljs.core.fnil.call(null,((function (seq__12013_12143,chunk__12014_12144,count__12015_12145,i__12016_12146,seq__12006_12136,chunk__12007_12137,count__12008_12138,i__12009_12139,seq__11970_12032,chunk__11971_12033,count__11972_12034,i__11973_12035,map__12017_12147,map__12017_12148__$1,gline_12149,gcol_12150,name_12151,vec__12010_12140,column_12141,column_info_12142,vec__12003_12133,line_12134,columns_12135,seq__11970_12127__$1,temp__5457__auto___12126,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_12150], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_12134,new cljs.core.Keyword(null,"col","col",-1959363084),column_12141,new cljs.core.Keyword(null,"name","name",1843675177),name_12151], null));
});})(seq__12013_12143,chunk__12014_12144,count__12015_12145,i__12016_12146,seq__12006_12136,chunk__12007_12137,count__12008_12138,i__12009_12139,seq__11970_12032,chunk__11971_12033,count__11972_12034,i__11973_12035,map__12017_12147,map__12017_12148__$1,gline_12149,gcol_12150,name_12151,vec__12010_12140,column_12141,column_info_12142,vec__12003_12133,line_12134,columns_12135,seq__11970_12127__$1,temp__5457__auto___12126,inverted))
,cljs.core.sorted_map.call(null)));

var G__12152 = seq__12013_12143;
var G__12153 = chunk__12014_12144;
var G__12154 = count__12015_12145;
var G__12155 = (i__12016_12146 + (1));
seq__12013_12143 = G__12152;
chunk__12014_12144 = G__12153;
count__12015_12145 = G__12154;
i__12016_12146 = G__12155;
continue;
} else {
var temp__5457__auto___12156__$1 = cljs.core.seq.call(null,seq__12013_12143);
if(temp__5457__auto___12156__$1){
var seq__12013_12157__$1 = temp__5457__auto___12156__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12013_12157__$1)){
var c__9319__auto___12158 = cljs.core.chunk_first.call(null,seq__12013_12157__$1);
var G__12159 = cljs.core.chunk_rest.call(null,seq__12013_12157__$1);
var G__12160 = c__9319__auto___12158;
var G__12161 = cljs.core.count.call(null,c__9319__auto___12158);
var G__12162 = (0);
seq__12013_12143 = G__12159;
chunk__12014_12144 = G__12160;
count__12015_12145 = G__12161;
i__12016_12146 = G__12162;
continue;
} else {
var map__12019_12163 = cljs.core.first.call(null,seq__12013_12157__$1);
var map__12019_12164__$1 = ((((!((map__12019_12163 == null)))?((((map__12019_12163.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12019_12163.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12019_12163):map__12019_12163);
var gline_12165 = cljs.core.get.call(null,map__12019_12164__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_12166 = cljs.core.get.call(null,map__12019_12164__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_12167 = cljs.core.get.call(null,map__12019_12164__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12165], null),cljs.core.fnil.call(null,((function (seq__12013_12143,chunk__12014_12144,count__12015_12145,i__12016_12146,seq__12006_12136,chunk__12007_12137,count__12008_12138,i__12009_12139,seq__11970_12032,chunk__11971_12033,count__11972_12034,i__11973_12035,map__12019_12163,map__12019_12164__$1,gline_12165,gcol_12166,name_12167,seq__12013_12157__$1,temp__5457__auto___12156__$1,vec__12010_12140,column_12141,column_info_12142,vec__12003_12133,line_12134,columns_12135,seq__11970_12127__$1,temp__5457__auto___12126,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_12166], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_12134,new cljs.core.Keyword(null,"col","col",-1959363084),column_12141,new cljs.core.Keyword(null,"name","name",1843675177),name_12167], null));
});})(seq__12013_12143,chunk__12014_12144,count__12015_12145,i__12016_12146,seq__12006_12136,chunk__12007_12137,count__12008_12138,i__12009_12139,seq__11970_12032,chunk__11971_12033,count__11972_12034,i__11973_12035,map__12019_12163,map__12019_12164__$1,gline_12165,gcol_12166,name_12167,seq__12013_12157__$1,temp__5457__auto___12156__$1,vec__12010_12140,column_12141,column_info_12142,vec__12003_12133,line_12134,columns_12135,seq__11970_12127__$1,temp__5457__auto___12126,inverted))
,cljs.core.sorted_map.call(null)));

var G__12168 = cljs.core.next.call(null,seq__12013_12157__$1);
var G__12169 = null;
var G__12170 = (0);
var G__12171 = (0);
seq__12013_12143 = G__12168;
chunk__12014_12144 = G__12169;
count__12015_12145 = G__12170;
i__12016_12146 = G__12171;
continue;
}
} else {
}
}
break;
}

var G__12172 = seq__12006_12136;
var G__12173 = chunk__12007_12137;
var G__12174 = count__12008_12138;
var G__12175 = (i__12009_12139 + (1));
seq__12006_12136 = G__12172;
chunk__12007_12137 = G__12173;
count__12008_12138 = G__12174;
i__12009_12139 = G__12175;
continue;
} else {
var temp__5457__auto___12176__$1 = cljs.core.seq.call(null,seq__12006_12136);
if(temp__5457__auto___12176__$1){
var seq__12006_12177__$1 = temp__5457__auto___12176__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12006_12177__$1)){
var c__9319__auto___12178 = cljs.core.chunk_first.call(null,seq__12006_12177__$1);
var G__12179 = cljs.core.chunk_rest.call(null,seq__12006_12177__$1);
var G__12180 = c__9319__auto___12178;
var G__12181 = cljs.core.count.call(null,c__9319__auto___12178);
var G__12182 = (0);
seq__12006_12136 = G__12179;
chunk__12007_12137 = G__12180;
count__12008_12138 = G__12181;
i__12009_12139 = G__12182;
continue;
} else {
var vec__12021_12183 = cljs.core.first.call(null,seq__12006_12177__$1);
var column_12184 = cljs.core.nth.call(null,vec__12021_12183,(0),null);
var column_info_12185 = cljs.core.nth.call(null,vec__12021_12183,(1),null);
var seq__12024_12186 = cljs.core.seq.call(null,column_info_12185);
var chunk__12025_12187 = null;
var count__12026_12188 = (0);
var i__12027_12189 = (0);
while(true){
if((i__12027_12189 < count__12026_12188)){
var map__12028_12190 = cljs.core._nth.call(null,chunk__12025_12187,i__12027_12189);
var map__12028_12191__$1 = ((((!((map__12028_12190 == null)))?((((map__12028_12190.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12028_12190.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12028_12190):map__12028_12190);
var gline_12192 = cljs.core.get.call(null,map__12028_12191__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_12193 = cljs.core.get.call(null,map__12028_12191__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_12194 = cljs.core.get.call(null,map__12028_12191__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12192], null),cljs.core.fnil.call(null,((function (seq__12024_12186,chunk__12025_12187,count__12026_12188,i__12027_12189,seq__12006_12136,chunk__12007_12137,count__12008_12138,i__12009_12139,seq__11970_12032,chunk__11971_12033,count__11972_12034,i__11973_12035,map__12028_12190,map__12028_12191__$1,gline_12192,gcol_12193,name_12194,vec__12021_12183,column_12184,column_info_12185,seq__12006_12177__$1,temp__5457__auto___12176__$1,vec__12003_12133,line_12134,columns_12135,seq__11970_12127__$1,temp__5457__auto___12126,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_12193], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_12134,new cljs.core.Keyword(null,"col","col",-1959363084),column_12184,new cljs.core.Keyword(null,"name","name",1843675177),name_12194], null));
});})(seq__12024_12186,chunk__12025_12187,count__12026_12188,i__12027_12189,seq__12006_12136,chunk__12007_12137,count__12008_12138,i__12009_12139,seq__11970_12032,chunk__11971_12033,count__11972_12034,i__11973_12035,map__12028_12190,map__12028_12191__$1,gline_12192,gcol_12193,name_12194,vec__12021_12183,column_12184,column_info_12185,seq__12006_12177__$1,temp__5457__auto___12176__$1,vec__12003_12133,line_12134,columns_12135,seq__11970_12127__$1,temp__5457__auto___12126,inverted))
,cljs.core.sorted_map.call(null)));

var G__12195 = seq__12024_12186;
var G__12196 = chunk__12025_12187;
var G__12197 = count__12026_12188;
var G__12198 = (i__12027_12189 + (1));
seq__12024_12186 = G__12195;
chunk__12025_12187 = G__12196;
count__12026_12188 = G__12197;
i__12027_12189 = G__12198;
continue;
} else {
var temp__5457__auto___12199__$2 = cljs.core.seq.call(null,seq__12024_12186);
if(temp__5457__auto___12199__$2){
var seq__12024_12200__$1 = temp__5457__auto___12199__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12024_12200__$1)){
var c__9319__auto___12201 = cljs.core.chunk_first.call(null,seq__12024_12200__$1);
var G__12202 = cljs.core.chunk_rest.call(null,seq__12024_12200__$1);
var G__12203 = c__9319__auto___12201;
var G__12204 = cljs.core.count.call(null,c__9319__auto___12201);
var G__12205 = (0);
seq__12024_12186 = G__12202;
chunk__12025_12187 = G__12203;
count__12026_12188 = G__12204;
i__12027_12189 = G__12205;
continue;
} else {
var map__12030_12206 = cljs.core.first.call(null,seq__12024_12200__$1);
var map__12030_12207__$1 = ((((!((map__12030_12206 == null)))?((((map__12030_12206.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12030_12206.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12030_12206):map__12030_12206);
var gline_12208 = cljs.core.get.call(null,map__12030_12207__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_12209 = cljs.core.get.call(null,map__12030_12207__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_12210 = cljs.core.get.call(null,map__12030_12207__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12208], null),cljs.core.fnil.call(null,((function (seq__12024_12186,chunk__12025_12187,count__12026_12188,i__12027_12189,seq__12006_12136,chunk__12007_12137,count__12008_12138,i__12009_12139,seq__11970_12032,chunk__11971_12033,count__11972_12034,i__11973_12035,map__12030_12206,map__12030_12207__$1,gline_12208,gcol_12209,name_12210,seq__12024_12200__$1,temp__5457__auto___12199__$2,vec__12021_12183,column_12184,column_info_12185,seq__12006_12177__$1,temp__5457__auto___12176__$1,vec__12003_12133,line_12134,columns_12135,seq__11970_12127__$1,temp__5457__auto___12126,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_12209], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_12134,new cljs.core.Keyword(null,"col","col",-1959363084),column_12184,new cljs.core.Keyword(null,"name","name",1843675177),name_12210], null));
});})(seq__12024_12186,chunk__12025_12187,count__12026_12188,i__12027_12189,seq__12006_12136,chunk__12007_12137,count__12008_12138,i__12009_12139,seq__11970_12032,chunk__11971_12033,count__11972_12034,i__11973_12035,map__12030_12206,map__12030_12207__$1,gline_12208,gcol_12209,name_12210,seq__12024_12200__$1,temp__5457__auto___12199__$2,vec__12021_12183,column_12184,column_info_12185,seq__12006_12177__$1,temp__5457__auto___12176__$1,vec__12003_12133,line_12134,columns_12135,seq__11970_12127__$1,temp__5457__auto___12126,inverted))
,cljs.core.sorted_map.call(null)));

var G__12211 = cljs.core.next.call(null,seq__12024_12200__$1);
var G__12212 = null;
var G__12213 = (0);
var G__12214 = (0);
seq__12024_12186 = G__12211;
chunk__12025_12187 = G__12212;
count__12026_12188 = G__12213;
i__12027_12189 = G__12214;
continue;
}
} else {
}
}
break;
}

var G__12215 = cljs.core.next.call(null,seq__12006_12177__$1);
var G__12216 = null;
var G__12217 = (0);
var G__12218 = (0);
seq__12006_12136 = G__12215;
chunk__12007_12137 = G__12216;
count__12008_12138 = G__12217;
i__12009_12139 = G__12218;
continue;
}
} else {
}
}
break;
}

var G__12219 = cljs.core.next.call(null,seq__11970_12127__$1);
var G__12220 = null;
var G__12221 = (0);
var G__12222 = (0);
seq__11970_12032 = G__12219;
chunk__11971_12033 = G__12220;
count__11972_12034 = G__12221;
i__11973_12035 = G__12222;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,inverted);
});

//# sourceMappingURL=source_map.js.map?rel=1518919046092
