(ns m.client
  (:require [clojure.set :refer [select]]
            [cljs.core.async :refer [put!]]
            [cognitect.transit :as t]
            [m.core :refer [e m]]))

(defn on-torrent [t & [{:keys [to]}]]
  (js/console.log (.-infoHash t))
  (m {:m/seeds {:infohash (.-infoHash t) :time (js/Date.)}} {:f conj})
  (when to (put! to t))
  t)

(defn on-remove [infohash & [{:keys [to]}]]
  (m {:m/seeds (select #(not= (:infohash %) infohash) (e :m/seeds))})
  (when to (put! to infohash))
  infohash)

(defn s [data & [opts]]
  (.seed (e :m/client) data #(on-torrent % opts)))

(defn t [infohash]
  (.get (e :m/client) infohash))

(defn r [infohash & [opts]]
  (.remove (e :m/client) infohash #(on-remove infohash opts)))

(defn a [infohash & [opts]]
  (let [client-opts #js {:announce (clj->js (e :m/trackers))}]
    (.add (e :m/client) infohash client-opts #(on-torrent % opts))))

(defn get-buffer [f & [{:keys [to]}]]
  (.getBuffer f (when to #(put! to %2))))

(defn get-blob-url [f & [{:keys [to]}]]
  (.getBlobURL f (when to #(put! to %2))))
