(ns m.comps
  (:require-macros [cljs.core.async.macros :refer [go go-loop]])
  (:require [cljs.core.async :refer
             [chan to-chan onto-chan put! take! >! <! close! pipeline-async]]
            [m.core :refer [e m]]
            [m.async :refer [chan' *>]]
            [m.client :refer [s t r a get-buffer]]
            [m.xfs :refer [files-to-chan maf]]
            [m.local :refer [gl sl]]))

(defn ee [ks]
  (select-keys (e) ks))

(defn am [infohash & [opts]]
  (let [pipeline #(pipeline-async 4 (:to %2) (partial maf infohash) %)] ; not :from because files-to-chan
    (as-> (*> (partial a infohash) {:xf files-to-chan}) from
          (*> pipeline (merge opts {:from from})))))
