(ns m.local
  (:require [cljs.core.async :refer [put!]]
            [cognitect.transit :as t]
            [cljsjs.localforage]
            [m.core :refer [e m]]))

(defn gl [k & [{:keys [to]}]]
  (let [k' (name k)
        cb (when to #(put! to (t/read (e :m/r) %2)))]
    (.getItem js/localforage k' cb)))

(defn sl
  ([k] (sl k (e k)))
  ([k v & [{:keys [to]}]]
   (let [k' (name k)
         v' (t/write (e :m/w) v)
         cb #(when to (put! to (nil? %)))]
     (.setItem js/localforage k' v' cb))))

(defn lks [& [{:keys [to]}]]
  (.keys js/localforage (when to #(put! to %2))))
