(ns m.peer
  (:require [cljs.core.async :refer [put! chan]]
            [cljsjs.simple-peer]
            [m.core :refer [e m]]
            [m.client :refer [s a get-buffer]]
            [m.xfs :refer [serialize deserialize]]
            [m.async :refer [*>]]))

(defonce stun-config
  {:config
   {:iceServers
    [{:urls
      ["stun:stun.l.google.com:19302",
       "stun:stun1.l.google.com:19302",
       "stun:stun2.l.google.com:19302",
       "stun:stun3.l.google.com:19302"]}]}})

(defn create-peer [id config]
  (js/console.log "create-peer")
  (let [p (js/simplePeer. (clj->js config))]
    (when (nil? (e :peer/channel))
      (m {:peer/channel (chan)}))
    (.on p "signal" #(s (serialize {:id id :signal %})))
    (.on p "connect" #(js/console.log "connected!"))
    (.on p "data" #(put! (e :peer/channel) {:id id :value (deserialize %)}))
    (.on p "stream" #(m {:peer/peers {id {:stream %}}}))
    (.on p "error" #(js/console.log "error!"))
    (.on p "close" #(m {:peer/peers {id {:peer nil :stream nil}}}))
    (m {:peer/peers {id {:peer p}}})
    p))

(defn signal-peer [config {:keys [id signal]}]
  (let [p (or (e :peer/peers id :peer)
              (create-peer id config))]
    (.signal p (clj->js signal))))

(defn connect-peer [infohash config]
  (js/console.log "connect-peer")
  (as-> (*> (partial a infohash) {:xf (map #(first (.-files %)))}) from
        (*> get-buffer {:from from :xf (map deserialize)})
        (*> (partial signal-peer config) {:from from})))

(defn send-data [id data]
  (js/console.log "sending to " (name id) ": " (clj->js data))
  (.send (e :peer/peers id :peer) (serialize data)))

(defn destroy-peer [id]
  (js/console.log "destroying " (name id))
  (.destroy (e :peer/peers id :peer)))
