// Compiled by ClojureScript 1.9.946 {}
goog.provide('re_frame.events');
goog.require('cljs.core');
goog.require('re_frame.db');
goog.require('re_frame.utils');
goog.require('re_frame.interop');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.interceptor');
goog.require('re_frame.trace');
re_frame.events.kind = new cljs.core.Keyword(null,"event","event",301435442);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.events.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * `interceptors` might have nested collections, and contain nil elements.
 *   return a flat collection, with all nils removed.
 *   This function is 9/10 about giving good error messages.
 */
re_frame.events.flatten_and_remove_nils = (function re_frame$events$flatten_and_remove_nils(id,interceptors){
var make_chain = (function (p1__32733_SHARP_){
return cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,p1__32733_SHARP_));
});
if(!(re_frame.interop.debug_enabled_QMARK_)){
return make_chain.call(null,interceptors);
} else {
if(cljs.core.coll_QMARK_.call(null,interceptors)){
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", expected a collection of interceptors, got: ",interceptors);
}

var chain = make_chain.call(null,interceptors);
if(cljs.core.empty_QMARK_.call(null,chain)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", given an empty interceptor chain");
} else {
}

var temp__5457__auto___32734 = cljs.core.first.call(null,cljs.core.remove.call(null,re_frame.interceptor.interceptor_QMARK_,chain));
if(cljs.core.truth_(temp__5457__auto___32734)){
var not_i_32735 = temp__5457__auto___32734;
if(cljs.core.fn_QMARK_.call(null,not_i_32735)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", got a function instead of an interceptor. Did you provide old style middleware by mistake? Got: ",not_i_32735);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", expected interceptors, but got: ",not_i_32735);
}
} else {
}

return chain;
}
});
/**
 * Associate the given event `id` with the given collection of `interceptors`.
 * 
 * `interceptors` may contain nested collections and there may be nils
 * at any level,so process this structure into a simple, nil-less vector
 * before registration.
 * 
 * Typically, an `event handler` will be at the end of the chain (wrapped
 * in an interceptor).
 */
re_frame.events.register = (function re_frame$events$register(id,interceptors){
return re_frame.registrar.register_handler.call(null,re_frame.events.kind,id,re_frame.events.flatten_and_remove_nils.call(null,id,interceptors));
});
re_frame.events._STAR_handling_STAR_ = null;
/**
 * Given an event vector `event-v`, look up the associated interceptor chain, and execute it.
 */
re_frame.events.handle = (function re_frame$events$handle(event_v){
var event_id = re_frame.utils.first_in_vector.call(null,event_v);
var temp__5455__auto__ = re_frame.registrar.get_handler.call(null,re_frame.events.kind,event_id,true);
if(cljs.core.truth_(temp__5455__auto__)){
var interceptors = temp__5455__auto__;
if(cljs.core.truth_(re_frame.events._STAR_handling_STAR_)){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: while handling \"",re_frame.events._STAR_handling_STAR_,"\", dispatch-sync was called for \"",event_v,"\". You can't call dispatch-sync within an event handler.");
} else {
var _STAR_handling_STAR_32736 = re_frame.events._STAR_handling_STAR_;
re_frame.events._STAR_handling_STAR_ = event_v;

try{if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR_32737 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"operation","operation",-1267664310),event_id,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),re_frame.events.kind,new cljs.core.Keyword(null,"tags","tags",1771418977),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"event","event",301435442),event_v], null)], null));

try{try{return re_frame.interceptor.execute.call(null,event_v,interceptors);
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__19291__auto___32750 = re_frame.interop.now.call(null);
var duration__19292__auto___32751 = (end__19291__auto___32750 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
var seq__32738_32752 = cljs.core.seq.call(null,cljs.core.deref.call(null,re_frame.trace.trace_cbs));
var chunk__32739_32753 = null;
var count__32740_32754 = (0);
var i__32741_32755 = (0);
while(true){
if((i__32741_32755 < count__32740_32754)){
var vec__32742_32756 = cljs.core._nth.call(null,chunk__32739_32753,i__32741_32755);
var k__19293__auto___32757 = cljs.core.nth.call(null,vec__32742_32756,(0),null);
var cb__19294__auto___32758 = cljs.core.nth.call(null,vec__32742_32756,(1),null);
try{cb__19294__auto___32758.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__19292__auto___32751,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e32745){if((e32745 instanceof java.lang.Exception)){
var e__19295__auto___32759 = e32745;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__19293__auto___32757,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__19295__auto___32759);
} else {
throw e32745;

}
}
var G__32760 = seq__32738_32752;
var G__32761 = chunk__32739_32753;
var G__32762 = count__32740_32754;
var G__32763 = (i__32741_32755 + (1));
seq__32738_32752 = G__32760;
chunk__32739_32753 = G__32761;
count__32740_32754 = G__32762;
i__32741_32755 = G__32763;
continue;
} else {
var temp__5457__auto___32764 = cljs.core.seq.call(null,seq__32738_32752);
if(temp__5457__auto___32764){
var seq__32738_32765__$1 = temp__5457__auto___32764;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32738_32765__$1)){
var c__9319__auto___32766 = cljs.core.chunk_first.call(null,seq__32738_32765__$1);
var G__32767 = cljs.core.chunk_rest.call(null,seq__32738_32765__$1);
var G__32768 = c__9319__auto___32766;
var G__32769 = cljs.core.count.call(null,c__9319__auto___32766);
var G__32770 = (0);
seq__32738_32752 = G__32767;
chunk__32739_32753 = G__32768;
count__32740_32754 = G__32769;
i__32741_32755 = G__32770;
continue;
} else {
var vec__32746_32771 = cljs.core.first.call(null,seq__32738_32765__$1);
var k__19293__auto___32772 = cljs.core.nth.call(null,vec__32746_32771,(0),null);
var cb__19294__auto___32773 = cljs.core.nth.call(null,vec__32746_32771,(1),null);
try{cb__19294__auto___32773.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__19292__auto___32751,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e32749){if((e32749 instanceof java.lang.Exception)){
var e__19295__auto___32774 = e32749;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__19293__auto___32772,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__19295__auto___32774);
} else {
throw e32749;

}
}
var G__32775 = cljs.core.next.call(null,seq__32738_32765__$1);
var G__32776 = null;
var G__32777 = (0);
var G__32778 = (0);
seq__32738_32752 = G__32775;
chunk__32739_32753 = G__32776;
count__32740_32754 = G__32777;
i__32741_32755 = G__32778;
continue;
}
} else {
}
}
break;
}
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_32737;
}} else {
return re_frame.interceptor.execute.call(null,event_v,interceptors);
}
}finally {re_frame.events._STAR_handling_STAR_ = _STAR_handling_STAR_32736;
}}
} else {
return null;
}
});
