// Compiled by ClojureScript 1.9.946 {:target :nodejs}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__16997 = arguments.length;
switch (G__16997) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async16998 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16998 = (function (f,blockable,meta16999){
this.f = f;
this.blockable = blockable;
this.meta16999 = meta16999;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16998.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17000,meta16999__$1){
var self__ = this;
var _17000__$1 = this;
return (new cljs.core.async.t_cljs$core$async16998(self__.f,self__.blockable,meta16999__$1));
});

cljs.core.async.t_cljs$core$async16998.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17000){
var self__ = this;
var _17000__$1 = this;
return self__.meta16999;
});

cljs.core.async.t_cljs$core$async16998.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16998.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async16998.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async16998.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async16998.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta16999","meta16999",1635332608,null)], null);
});

cljs.core.async.t_cljs$core$async16998.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16998.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16998";

cljs.core.async.t_cljs$core$async16998.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async16998");
});

cljs.core.async.__GT_t_cljs$core$async16998 = (function cljs$core$async$__GT_t_cljs$core$async16998(f__$1,blockable__$1,meta16999){
return (new cljs.core.async.t_cljs$core$async16998(f__$1,blockable__$1,meta16999));
});

}

return (new cljs.core.async.t_cljs$core$async16998(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__17004 = arguments.length;
switch (G__17004) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__17007 = arguments.length;
switch (G__17007) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__17010 = arguments.length;
switch (G__17010) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_17012 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_17012);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_17012,ret){
return (function (){
return fn1.call(null,val_17012);
});})(val_17012,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__17014 = arguments.length;
switch (G__17014) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5455__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__9433__auto___17016 = n;
var x_17017 = (0);
while(true){
if((x_17017 < n__9433__auto___17016)){
(a[x_17017] = (0));

var G__17018 = (x_17017 + (1));
x_17017 = G__17018;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__17019 = (i + (1));
i = G__17019;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async17020 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17020 = (function (flag,meta17021){
this.flag = flag;
this.meta17021 = meta17021;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17020.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17022,meta17021__$1){
var self__ = this;
var _17022__$1 = this;
return (new cljs.core.async.t_cljs$core$async17020(self__.flag,meta17021__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17020.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17022){
var self__ = this;
var _17022__$1 = this;
return self__.meta17021;
});})(flag))
;

cljs.core.async.t_cljs$core$async17020.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17020.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17020.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17020.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17020.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta17021","meta17021",831317466,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17020.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17020.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17020";

cljs.core.async.t_cljs$core$async17020.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async17020");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17020 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17020(flag__$1,meta17021){
return (new cljs.core.async.t_cljs$core$async17020(flag__$1,meta17021));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17020(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17023 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17023 = (function (flag,cb,meta17024){
this.flag = flag;
this.cb = cb;
this.meta17024 = meta17024;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17023.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17025,meta17024__$1){
var self__ = this;
var _17025__$1 = this;
return (new cljs.core.async.t_cljs$core$async17023(self__.flag,self__.cb,meta17024__$1));
});

cljs.core.async.t_cljs$core$async17023.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17025){
var self__ = this;
var _17025__$1 = this;
return self__.meta17024;
});

cljs.core.async.t_cljs$core$async17023.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17023.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async17023.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17023.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17023.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta17024","meta17024",2050316398,null)], null);
});

cljs.core.async.t_cljs$core$async17023.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17023.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17023";

cljs.core.async.t_cljs$core$async17023.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async17023");
});

cljs.core.async.__GT_t_cljs$core$async17023 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17023(flag__$1,cb__$1,meta17024){
return (new cljs.core.async.t_cljs$core$async17023(flag__$1,cb__$1,meta17024));
});

}

return (new cljs.core.async.t_cljs$core$async17023(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17026_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17026_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17027_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17027_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__8388__auto__ = wport;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17028 = (i + (1));
i = G__17028;
continue;
}
} else {
return null;
}
break;
}
})();
var or__8388__auto__ = ret;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__8376__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__8376__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__8376__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__9674__auto__ = [];
var len__9667__auto___17034 = arguments.length;
var i__9668__auto___17035 = (0);
while(true){
if((i__9668__auto___17035 < len__9667__auto___17034)){
args__9674__auto__.push((arguments[i__9668__auto___17035]));

var G__17036 = (i__9668__auto___17035 + (1));
i__9668__auto___17035 = G__17036;
continue;
} else {
}
break;
}

var argseq__9675__auto__ = ((((1) < args__9674__auto__.length))?(new cljs.core.IndexedSeq(args__9674__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9675__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17031){
var map__17032 = p__17031;
var map__17032__$1 = ((((!((map__17032 == null)))?((((map__17032.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17032.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17032):map__17032);
var opts = map__17032__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17029){
var G__17030 = cljs.core.first.call(null,seq17029);
var seq17029__$1 = cljs.core.next.call(null,seq17029);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17030,seq17029__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__17038 = arguments.length;
switch (G__17038) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__16937__auto___17084 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16937__auto___17084){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (c__16937__auto___17084){
return (function (state_17062){
var state_val_17063 = (state_17062[(1)]);
if((state_val_17063 === (7))){
var inst_17058 = (state_17062[(2)]);
var state_17062__$1 = state_17062;
var statearr_17064_17085 = state_17062__$1;
(statearr_17064_17085[(2)] = inst_17058);

(statearr_17064_17085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17063 === (1))){
var state_17062__$1 = state_17062;
var statearr_17065_17086 = state_17062__$1;
(statearr_17065_17086[(2)] = null);

(statearr_17065_17086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17063 === (4))){
var inst_17041 = (state_17062[(7)]);
var inst_17041__$1 = (state_17062[(2)]);
var inst_17042 = (inst_17041__$1 == null);
var state_17062__$1 = (function (){var statearr_17066 = state_17062;
(statearr_17066[(7)] = inst_17041__$1);

return statearr_17066;
})();
if(cljs.core.truth_(inst_17042)){
var statearr_17067_17087 = state_17062__$1;
(statearr_17067_17087[(1)] = (5));

} else {
var statearr_17068_17088 = state_17062__$1;
(statearr_17068_17088[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17063 === (13))){
var state_17062__$1 = state_17062;
var statearr_17069_17089 = state_17062__$1;
(statearr_17069_17089[(2)] = null);

(statearr_17069_17089[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17063 === (6))){
var inst_17041 = (state_17062[(7)]);
var state_17062__$1 = state_17062;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17062__$1,(11),to,inst_17041);
} else {
if((state_val_17063 === (3))){
var inst_17060 = (state_17062[(2)]);
var state_17062__$1 = state_17062;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17062__$1,inst_17060);
} else {
if((state_val_17063 === (12))){
var state_17062__$1 = state_17062;
var statearr_17070_17090 = state_17062__$1;
(statearr_17070_17090[(2)] = null);

(statearr_17070_17090[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17063 === (2))){
var state_17062__$1 = state_17062;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17062__$1,(4),from);
} else {
if((state_val_17063 === (11))){
var inst_17051 = (state_17062[(2)]);
var state_17062__$1 = state_17062;
if(cljs.core.truth_(inst_17051)){
var statearr_17071_17091 = state_17062__$1;
(statearr_17071_17091[(1)] = (12));

} else {
var statearr_17072_17092 = state_17062__$1;
(statearr_17072_17092[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17063 === (9))){
var state_17062__$1 = state_17062;
var statearr_17073_17093 = state_17062__$1;
(statearr_17073_17093[(2)] = null);

(statearr_17073_17093[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17063 === (5))){
var state_17062__$1 = state_17062;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17074_17094 = state_17062__$1;
(statearr_17074_17094[(1)] = (8));

} else {
var statearr_17075_17095 = state_17062__$1;
(statearr_17075_17095[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17063 === (14))){
var inst_17056 = (state_17062[(2)]);
var state_17062__$1 = state_17062;
var statearr_17076_17096 = state_17062__$1;
(statearr_17076_17096[(2)] = inst_17056);

(statearr_17076_17096[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17063 === (10))){
var inst_17048 = (state_17062[(2)]);
var state_17062__$1 = state_17062;
var statearr_17077_17097 = state_17062__$1;
(statearr_17077_17097[(2)] = inst_17048);

(statearr_17077_17097[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17063 === (8))){
var inst_17045 = cljs.core.async.close_BANG_.call(null,to);
var state_17062__$1 = state_17062;
var statearr_17078_17098 = state_17062__$1;
(statearr_17078_17098[(2)] = inst_17045);

(statearr_17078_17098[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16937__auto___17084))
;
return ((function (switch__16847__auto__,c__16937__auto___17084){
return (function() {
var cljs$core$async$state_machine__16848__auto__ = null;
var cljs$core$async$state_machine__16848__auto____0 = (function (){
var statearr_17079 = [null,null,null,null,null,null,null,null];
(statearr_17079[(0)] = cljs$core$async$state_machine__16848__auto__);

(statearr_17079[(1)] = (1));

return statearr_17079;
});
var cljs$core$async$state_machine__16848__auto____1 = (function (state_17062){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_17062);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e17080){if((e17080 instanceof Object)){
var ex__16851__auto__ = e17080;
var statearr_17081_17099 = state_17062;
(statearr_17081_17099[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17062);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17080;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17100 = state_17062;
state_17062 = G__17100;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$state_machine__16848__auto__ = function(state_17062){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16848__auto____1.call(this,state_17062);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16848__auto____0;
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16848__auto____1;
return cljs$core$async$state_machine__16848__auto__;
})()
;})(switch__16847__auto__,c__16937__auto___17084))
})();
var state__16939__auto__ = (function (){var statearr_17082 = f__16938__auto__.call(null);
(statearr_17082[(6)] = c__16937__auto___17084);

return statearr_17082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(c__16937__auto___17084))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__17101){
var vec__17102 = p__17101;
var v = cljs.core.nth.call(null,vec__17102,(0),null);
var p = cljs.core.nth.call(null,vec__17102,(1),null);
var job = vec__17102;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__16937__auto___17273 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16937__auto___17273,res,vec__17102,v,p,job,jobs,results){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (c__16937__auto___17273,res,vec__17102,v,p,job,jobs,results){
return (function (state_17109){
var state_val_17110 = (state_17109[(1)]);
if((state_val_17110 === (1))){
var state_17109__$1 = state_17109;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17109__$1,(2),res,v);
} else {
if((state_val_17110 === (2))){
var inst_17106 = (state_17109[(2)]);
var inst_17107 = cljs.core.async.close_BANG_.call(null,res);
var state_17109__$1 = (function (){var statearr_17111 = state_17109;
(statearr_17111[(7)] = inst_17106);

return statearr_17111;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17109__$1,inst_17107);
} else {
return null;
}
}
});})(c__16937__auto___17273,res,vec__17102,v,p,job,jobs,results))
;
return ((function (switch__16847__auto__,c__16937__auto___17273,res,vec__17102,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____0 = (function (){
var statearr_17112 = [null,null,null,null,null,null,null,null];
(statearr_17112[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__);

(statearr_17112[(1)] = (1));

return statearr_17112;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____1 = (function (state_17109){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_17109);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e17113){if((e17113 instanceof Object)){
var ex__16851__auto__ = e17113;
var statearr_17114_17274 = state_17109;
(statearr_17114_17274[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17109);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17113;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17275 = state_17109;
state_17109 = G__17275;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__ = function(state_17109){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____1.call(this,state_17109);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__;
})()
;})(switch__16847__auto__,c__16937__auto___17273,res,vec__17102,v,p,job,jobs,results))
})();
var state__16939__auto__ = (function (){var statearr_17115 = f__16938__auto__.call(null);
(statearr_17115[(6)] = c__16937__auto___17273);

return statearr_17115;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(c__16937__auto___17273,res,vec__17102,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17116){
var vec__17117 = p__17116;
var v = cljs.core.nth.call(null,vec__17117,(0),null);
var p = cljs.core.nth.call(null,vec__17117,(1),null);
var job = vec__17117;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__9433__auto___17276 = n;
var __17277 = (0);
while(true){
if((__17277 < n__9433__auto___17276)){
var G__17120_17278 = type;
var G__17120_17279__$1 = (((G__17120_17278 instanceof cljs.core.Keyword))?G__17120_17278.fqn:null);
switch (G__17120_17279__$1) {
case "compute":
var c__16937__auto___17281 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17277,c__16937__auto___17281,G__17120_17278,G__17120_17279__$1,n__9433__auto___17276,jobs,results,process,async){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (__17277,c__16937__auto___17281,G__17120_17278,G__17120_17279__$1,n__9433__auto___17276,jobs,results,process,async){
return (function (state_17133){
var state_val_17134 = (state_17133[(1)]);
if((state_val_17134 === (1))){
var state_17133__$1 = state_17133;
var statearr_17135_17282 = state_17133__$1;
(statearr_17135_17282[(2)] = null);

(statearr_17135_17282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (2))){
var state_17133__$1 = state_17133;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17133__$1,(4),jobs);
} else {
if((state_val_17134 === (3))){
var inst_17131 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17133__$1,inst_17131);
} else {
if((state_val_17134 === (4))){
var inst_17123 = (state_17133[(2)]);
var inst_17124 = process.call(null,inst_17123);
var state_17133__$1 = state_17133;
if(cljs.core.truth_(inst_17124)){
var statearr_17136_17283 = state_17133__$1;
(statearr_17136_17283[(1)] = (5));

} else {
var statearr_17137_17284 = state_17133__$1;
(statearr_17137_17284[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (5))){
var state_17133__$1 = state_17133;
var statearr_17138_17285 = state_17133__$1;
(statearr_17138_17285[(2)] = null);

(statearr_17138_17285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (6))){
var state_17133__$1 = state_17133;
var statearr_17139_17286 = state_17133__$1;
(statearr_17139_17286[(2)] = null);

(statearr_17139_17286[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (7))){
var inst_17129 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17140_17287 = state_17133__$1;
(statearr_17140_17287[(2)] = inst_17129);

(statearr_17140_17287[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17277,c__16937__auto___17281,G__17120_17278,G__17120_17279__$1,n__9433__auto___17276,jobs,results,process,async))
;
return ((function (__17277,switch__16847__auto__,c__16937__auto___17281,G__17120_17278,G__17120_17279__$1,n__9433__auto___17276,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____0 = (function (){
var statearr_17141 = [null,null,null,null,null,null,null];
(statearr_17141[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__);

(statearr_17141[(1)] = (1));

return statearr_17141;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____1 = (function (state_17133){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_17133);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e17142){if((e17142 instanceof Object)){
var ex__16851__auto__ = e17142;
var statearr_17143_17288 = state_17133;
(statearr_17143_17288[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17133);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17142;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17289 = state_17133;
state_17133 = G__17289;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__ = function(state_17133){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____1.call(this,state_17133);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__;
})()
;})(__17277,switch__16847__auto__,c__16937__auto___17281,G__17120_17278,G__17120_17279__$1,n__9433__auto___17276,jobs,results,process,async))
})();
var state__16939__auto__ = (function (){var statearr_17144 = f__16938__auto__.call(null);
(statearr_17144[(6)] = c__16937__auto___17281);

return statearr_17144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(__17277,c__16937__auto___17281,G__17120_17278,G__17120_17279__$1,n__9433__auto___17276,jobs,results,process,async))
);


break;
case "async":
var c__16937__auto___17290 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17277,c__16937__auto___17290,G__17120_17278,G__17120_17279__$1,n__9433__auto___17276,jobs,results,process,async){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (__17277,c__16937__auto___17290,G__17120_17278,G__17120_17279__$1,n__9433__auto___17276,jobs,results,process,async){
return (function (state_17157){
var state_val_17158 = (state_17157[(1)]);
if((state_val_17158 === (1))){
var state_17157__$1 = state_17157;
var statearr_17159_17291 = state_17157__$1;
(statearr_17159_17291[(2)] = null);

(statearr_17159_17291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17158 === (2))){
var state_17157__$1 = state_17157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17157__$1,(4),jobs);
} else {
if((state_val_17158 === (3))){
var inst_17155 = (state_17157[(2)]);
var state_17157__$1 = state_17157;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17157__$1,inst_17155);
} else {
if((state_val_17158 === (4))){
var inst_17147 = (state_17157[(2)]);
var inst_17148 = async.call(null,inst_17147);
var state_17157__$1 = state_17157;
if(cljs.core.truth_(inst_17148)){
var statearr_17160_17292 = state_17157__$1;
(statearr_17160_17292[(1)] = (5));

} else {
var statearr_17161_17293 = state_17157__$1;
(statearr_17161_17293[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17158 === (5))){
var state_17157__$1 = state_17157;
var statearr_17162_17294 = state_17157__$1;
(statearr_17162_17294[(2)] = null);

(statearr_17162_17294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17158 === (6))){
var state_17157__$1 = state_17157;
var statearr_17163_17295 = state_17157__$1;
(statearr_17163_17295[(2)] = null);

(statearr_17163_17295[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17158 === (7))){
var inst_17153 = (state_17157[(2)]);
var state_17157__$1 = state_17157;
var statearr_17164_17296 = state_17157__$1;
(statearr_17164_17296[(2)] = inst_17153);

(statearr_17164_17296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17277,c__16937__auto___17290,G__17120_17278,G__17120_17279__$1,n__9433__auto___17276,jobs,results,process,async))
;
return ((function (__17277,switch__16847__auto__,c__16937__auto___17290,G__17120_17278,G__17120_17279__$1,n__9433__auto___17276,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____0 = (function (){
var statearr_17165 = [null,null,null,null,null,null,null];
(statearr_17165[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__);

(statearr_17165[(1)] = (1));

return statearr_17165;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____1 = (function (state_17157){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_17157);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e17166){if((e17166 instanceof Object)){
var ex__16851__auto__ = e17166;
var statearr_17167_17297 = state_17157;
(statearr_17167_17297[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17157);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17166;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17298 = state_17157;
state_17157 = G__17298;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__ = function(state_17157){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____1.call(this,state_17157);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__;
})()
;})(__17277,switch__16847__auto__,c__16937__auto___17290,G__17120_17278,G__17120_17279__$1,n__9433__auto___17276,jobs,results,process,async))
})();
var state__16939__auto__ = (function (){var statearr_17168 = f__16938__auto__.call(null);
(statearr_17168[(6)] = c__16937__auto___17290);

return statearr_17168;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(__17277,c__16937__auto___17290,G__17120_17278,G__17120_17279__$1,n__9433__auto___17276,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17120_17279__$1)].join('')));

}

var G__17299 = (__17277 + (1));
__17277 = G__17299;
continue;
} else {
}
break;
}

var c__16937__auto___17300 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16937__auto___17300,jobs,results,process,async){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (c__16937__auto___17300,jobs,results,process,async){
return (function (state_17190){
var state_val_17191 = (state_17190[(1)]);
if((state_val_17191 === (1))){
var state_17190__$1 = state_17190;
var statearr_17192_17301 = state_17190__$1;
(statearr_17192_17301[(2)] = null);

(statearr_17192_17301[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17191 === (2))){
var state_17190__$1 = state_17190;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17190__$1,(4),from);
} else {
if((state_val_17191 === (3))){
var inst_17188 = (state_17190[(2)]);
var state_17190__$1 = state_17190;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17190__$1,inst_17188);
} else {
if((state_val_17191 === (4))){
var inst_17171 = (state_17190[(7)]);
var inst_17171__$1 = (state_17190[(2)]);
var inst_17172 = (inst_17171__$1 == null);
var state_17190__$1 = (function (){var statearr_17193 = state_17190;
(statearr_17193[(7)] = inst_17171__$1);

return statearr_17193;
})();
if(cljs.core.truth_(inst_17172)){
var statearr_17194_17302 = state_17190__$1;
(statearr_17194_17302[(1)] = (5));

} else {
var statearr_17195_17303 = state_17190__$1;
(statearr_17195_17303[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17191 === (5))){
var inst_17174 = cljs.core.async.close_BANG_.call(null,jobs);
var state_17190__$1 = state_17190;
var statearr_17196_17304 = state_17190__$1;
(statearr_17196_17304[(2)] = inst_17174);

(statearr_17196_17304[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17191 === (6))){
var inst_17176 = (state_17190[(8)]);
var inst_17171 = (state_17190[(7)]);
var inst_17176__$1 = cljs.core.async.chan.call(null,(1));
var inst_17177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17178 = [inst_17171,inst_17176__$1];
var inst_17179 = (new cljs.core.PersistentVector(null,2,(5),inst_17177,inst_17178,null));
var state_17190__$1 = (function (){var statearr_17197 = state_17190;
(statearr_17197[(8)] = inst_17176__$1);

return statearr_17197;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17190__$1,(8),jobs,inst_17179);
} else {
if((state_val_17191 === (7))){
var inst_17186 = (state_17190[(2)]);
var state_17190__$1 = state_17190;
var statearr_17198_17305 = state_17190__$1;
(statearr_17198_17305[(2)] = inst_17186);

(statearr_17198_17305[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17191 === (8))){
var inst_17176 = (state_17190[(8)]);
var inst_17181 = (state_17190[(2)]);
var state_17190__$1 = (function (){var statearr_17199 = state_17190;
(statearr_17199[(9)] = inst_17181);

return statearr_17199;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17190__$1,(9),results,inst_17176);
} else {
if((state_val_17191 === (9))){
var inst_17183 = (state_17190[(2)]);
var state_17190__$1 = (function (){var statearr_17200 = state_17190;
(statearr_17200[(10)] = inst_17183);

return statearr_17200;
})();
var statearr_17201_17306 = state_17190__$1;
(statearr_17201_17306[(2)] = null);

(statearr_17201_17306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__16937__auto___17300,jobs,results,process,async))
;
return ((function (switch__16847__auto__,c__16937__auto___17300,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____0 = (function (){
var statearr_17202 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17202[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__);

(statearr_17202[(1)] = (1));

return statearr_17202;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____1 = (function (state_17190){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_17190);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e17203){if((e17203 instanceof Object)){
var ex__16851__auto__ = e17203;
var statearr_17204_17307 = state_17190;
(statearr_17204_17307[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17190);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17203;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17308 = state_17190;
state_17190 = G__17308;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__ = function(state_17190){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____1.call(this,state_17190);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__;
})()
;})(switch__16847__auto__,c__16937__auto___17300,jobs,results,process,async))
})();
var state__16939__auto__ = (function (){var statearr_17205 = f__16938__auto__.call(null);
(statearr_17205[(6)] = c__16937__auto___17300);

return statearr_17205;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(c__16937__auto___17300,jobs,results,process,async))
);


var c__16937__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16937__auto__,jobs,results,process,async){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (c__16937__auto__,jobs,results,process,async){
return (function (state_17243){
var state_val_17244 = (state_17243[(1)]);
if((state_val_17244 === (7))){
var inst_17239 = (state_17243[(2)]);
var state_17243__$1 = state_17243;
var statearr_17245_17309 = state_17243__$1;
(statearr_17245_17309[(2)] = inst_17239);

(statearr_17245_17309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (20))){
var state_17243__$1 = state_17243;
var statearr_17246_17310 = state_17243__$1;
(statearr_17246_17310[(2)] = null);

(statearr_17246_17310[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (1))){
var state_17243__$1 = state_17243;
var statearr_17247_17311 = state_17243__$1;
(statearr_17247_17311[(2)] = null);

(statearr_17247_17311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (4))){
var inst_17208 = (state_17243[(7)]);
var inst_17208__$1 = (state_17243[(2)]);
var inst_17209 = (inst_17208__$1 == null);
var state_17243__$1 = (function (){var statearr_17248 = state_17243;
(statearr_17248[(7)] = inst_17208__$1);

return statearr_17248;
})();
if(cljs.core.truth_(inst_17209)){
var statearr_17249_17312 = state_17243__$1;
(statearr_17249_17312[(1)] = (5));

} else {
var statearr_17250_17313 = state_17243__$1;
(statearr_17250_17313[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (15))){
var inst_17221 = (state_17243[(8)]);
var state_17243__$1 = state_17243;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17243__$1,(18),to,inst_17221);
} else {
if((state_val_17244 === (21))){
var inst_17234 = (state_17243[(2)]);
var state_17243__$1 = state_17243;
var statearr_17251_17314 = state_17243__$1;
(statearr_17251_17314[(2)] = inst_17234);

(statearr_17251_17314[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (13))){
var inst_17236 = (state_17243[(2)]);
var state_17243__$1 = (function (){var statearr_17252 = state_17243;
(statearr_17252[(9)] = inst_17236);

return statearr_17252;
})();
var statearr_17253_17315 = state_17243__$1;
(statearr_17253_17315[(2)] = null);

(statearr_17253_17315[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (6))){
var inst_17208 = (state_17243[(7)]);
var state_17243__$1 = state_17243;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17243__$1,(11),inst_17208);
} else {
if((state_val_17244 === (17))){
var inst_17229 = (state_17243[(2)]);
var state_17243__$1 = state_17243;
if(cljs.core.truth_(inst_17229)){
var statearr_17254_17316 = state_17243__$1;
(statearr_17254_17316[(1)] = (19));

} else {
var statearr_17255_17317 = state_17243__$1;
(statearr_17255_17317[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (3))){
var inst_17241 = (state_17243[(2)]);
var state_17243__$1 = state_17243;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17243__$1,inst_17241);
} else {
if((state_val_17244 === (12))){
var inst_17218 = (state_17243[(10)]);
var state_17243__$1 = state_17243;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17243__$1,(14),inst_17218);
} else {
if((state_val_17244 === (2))){
var state_17243__$1 = state_17243;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17243__$1,(4),results);
} else {
if((state_val_17244 === (19))){
var state_17243__$1 = state_17243;
var statearr_17256_17318 = state_17243__$1;
(statearr_17256_17318[(2)] = null);

(statearr_17256_17318[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (11))){
var inst_17218 = (state_17243[(2)]);
var state_17243__$1 = (function (){var statearr_17257 = state_17243;
(statearr_17257[(10)] = inst_17218);

return statearr_17257;
})();
var statearr_17258_17319 = state_17243__$1;
(statearr_17258_17319[(2)] = null);

(statearr_17258_17319[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (9))){
var state_17243__$1 = state_17243;
var statearr_17259_17320 = state_17243__$1;
(statearr_17259_17320[(2)] = null);

(statearr_17259_17320[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (5))){
var state_17243__$1 = state_17243;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17260_17321 = state_17243__$1;
(statearr_17260_17321[(1)] = (8));

} else {
var statearr_17261_17322 = state_17243__$1;
(statearr_17261_17322[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (14))){
var inst_17223 = (state_17243[(11)]);
var inst_17221 = (state_17243[(8)]);
var inst_17221__$1 = (state_17243[(2)]);
var inst_17222 = (inst_17221__$1 == null);
var inst_17223__$1 = cljs.core.not.call(null,inst_17222);
var state_17243__$1 = (function (){var statearr_17262 = state_17243;
(statearr_17262[(11)] = inst_17223__$1);

(statearr_17262[(8)] = inst_17221__$1);

return statearr_17262;
})();
if(inst_17223__$1){
var statearr_17263_17323 = state_17243__$1;
(statearr_17263_17323[(1)] = (15));

} else {
var statearr_17264_17324 = state_17243__$1;
(statearr_17264_17324[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (16))){
var inst_17223 = (state_17243[(11)]);
var state_17243__$1 = state_17243;
var statearr_17265_17325 = state_17243__$1;
(statearr_17265_17325[(2)] = inst_17223);

(statearr_17265_17325[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (10))){
var inst_17215 = (state_17243[(2)]);
var state_17243__$1 = state_17243;
var statearr_17266_17326 = state_17243__$1;
(statearr_17266_17326[(2)] = inst_17215);

(statearr_17266_17326[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (18))){
var inst_17226 = (state_17243[(2)]);
var state_17243__$1 = state_17243;
var statearr_17267_17327 = state_17243__$1;
(statearr_17267_17327[(2)] = inst_17226);

(statearr_17267_17327[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (8))){
var inst_17212 = cljs.core.async.close_BANG_.call(null,to);
var state_17243__$1 = state_17243;
var statearr_17268_17328 = state_17243__$1;
(statearr_17268_17328[(2)] = inst_17212);

(statearr_17268_17328[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16937__auto__,jobs,results,process,async))
;
return ((function (switch__16847__auto__,c__16937__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____0 = (function (){
var statearr_17269 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17269[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__);

(statearr_17269[(1)] = (1));

return statearr_17269;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____1 = (function (state_17243){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_17243);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e17270){if((e17270 instanceof Object)){
var ex__16851__auto__ = e17270;
var statearr_17271_17329 = state_17243;
(statearr_17271_17329[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17243);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17270;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17330 = state_17243;
state_17243 = G__17330;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__ = function(state_17243){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____1.call(this,state_17243);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16848__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16848__auto__;
})()
;})(switch__16847__auto__,c__16937__auto__,jobs,results,process,async))
})();
var state__16939__auto__ = (function (){var statearr_17272 = f__16938__auto__.call(null);
(statearr_17272[(6)] = c__16937__auto__);

return statearr_17272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(c__16937__auto__,jobs,results,process,async))
);

return c__16937__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__17332 = arguments.length;
switch (G__17332) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__17335 = arguments.length;
switch (G__17335) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__17338 = arguments.length;
switch (G__17338) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__16937__auto___17387 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16937__auto___17387,tc,fc){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (c__16937__auto___17387,tc,fc){
return (function (state_17364){
var state_val_17365 = (state_17364[(1)]);
if((state_val_17365 === (7))){
var inst_17360 = (state_17364[(2)]);
var state_17364__$1 = state_17364;
var statearr_17366_17388 = state_17364__$1;
(statearr_17366_17388[(2)] = inst_17360);

(statearr_17366_17388[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17365 === (1))){
var state_17364__$1 = state_17364;
var statearr_17367_17389 = state_17364__$1;
(statearr_17367_17389[(2)] = null);

(statearr_17367_17389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17365 === (4))){
var inst_17341 = (state_17364[(7)]);
var inst_17341__$1 = (state_17364[(2)]);
var inst_17342 = (inst_17341__$1 == null);
var state_17364__$1 = (function (){var statearr_17368 = state_17364;
(statearr_17368[(7)] = inst_17341__$1);

return statearr_17368;
})();
if(cljs.core.truth_(inst_17342)){
var statearr_17369_17390 = state_17364__$1;
(statearr_17369_17390[(1)] = (5));

} else {
var statearr_17370_17391 = state_17364__$1;
(statearr_17370_17391[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17365 === (13))){
var state_17364__$1 = state_17364;
var statearr_17371_17392 = state_17364__$1;
(statearr_17371_17392[(2)] = null);

(statearr_17371_17392[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17365 === (6))){
var inst_17341 = (state_17364[(7)]);
var inst_17347 = p.call(null,inst_17341);
var state_17364__$1 = state_17364;
if(cljs.core.truth_(inst_17347)){
var statearr_17372_17393 = state_17364__$1;
(statearr_17372_17393[(1)] = (9));

} else {
var statearr_17373_17394 = state_17364__$1;
(statearr_17373_17394[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17365 === (3))){
var inst_17362 = (state_17364[(2)]);
var state_17364__$1 = state_17364;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17364__$1,inst_17362);
} else {
if((state_val_17365 === (12))){
var state_17364__$1 = state_17364;
var statearr_17374_17395 = state_17364__$1;
(statearr_17374_17395[(2)] = null);

(statearr_17374_17395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17365 === (2))){
var state_17364__$1 = state_17364;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17364__$1,(4),ch);
} else {
if((state_val_17365 === (11))){
var inst_17341 = (state_17364[(7)]);
var inst_17351 = (state_17364[(2)]);
var state_17364__$1 = state_17364;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17364__$1,(8),inst_17351,inst_17341);
} else {
if((state_val_17365 === (9))){
var state_17364__$1 = state_17364;
var statearr_17375_17396 = state_17364__$1;
(statearr_17375_17396[(2)] = tc);

(statearr_17375_17396[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17365 === (5))){
var inst_17344 = cljs.core.async.close_BANG_.call(null,tc);
var inst_17345 = cljs.core.async.close_BANG_.call(null,fc);
var state_17364__$1 = (function (){var statearr_17376 = state_17364;
(statearr_17376[(8)] = inst_17344);

return statearr_17376;
})();
var statearr_17377_17397 = state_17364__$1;
(statearr_17377_17397[(2)] = inst_17345);

(statearr_17377_17397[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17365 === (14))){
var inst_17358 = (state_17364[(2)]);
var state_17364__$1 = state_17364;
var statearr_17378_17398 = state_17364__$1;
(statearr_17378_17398[(2)] = inst_17358);

(statearr_17378_17398[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17365 === (10))){
var state_17364__$1 = state_17364;
var statearr_17379_17399 = state_17364__$1;
(statearr_17379_17399[(2)] = fc);

(statearr_17379_17399[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17365 === (8))){
var inst_17353 = (state_17364[(2)]);
var state_17364__$1 = state_17364;
if(cljs.core.truth_(inst_17353)){
var statearr_17380_17400 = state_17364__$1;
(statearr_17380_17400[(1)] = (12));

} else {
var statearr_17381_17401 = state_17364__$1;
(statearr_17381_17401[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16937__auto___17387,tc,fc))
;
return ((function (switch__16847__auto__,c__16937__auto___17387,tc,fc){
return (function() {
var cljs$core$async$state_machine__16848__auto__ = null;
var cljs$core$async$state_machine__16848__auto____0 = (function (){
var statearr_17382 = [null,null,null,null,null,null,null,null,null];
(statearr_17382[(0)] = cljs$core$async$state_machine__16848__auto__);

(statearr_17382[(1)] = (1));

return statearr_17382;
});
var cljs$core$async$state_machine__16848__auto____1 = (function (state_17364){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_17364);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e17383){if((e17383 instanceof Object)){
var ex__16851__auto__ = e17383;
var statearr_17384_17402 = state_17364;
(statearr_17384_17402[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17364);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17383;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17403 = state_17364;
state_17364 = G__17403;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$state_machine__16848__auto__ = function(state_17364){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16848__auto____1.call(this,state_17364);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16848__auto____0;
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16848__auto____1;
return cljs$core$async$state_machine__16848__auto__;
})()
;})(switch__16847__auto__,c__16937__auto___17387,tc,fc))
})();
var state__16939__auto__ = (function (){var statearr_17385 = f__16938__auto__.call(null);
(statearr_17385[(6)] = c__16937__auto___17387);

return statearr_17385;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(c__16937__auto___17387,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__16937__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16937__auto__){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (c__16937__auto__){
return (function (state_17424){
var state_val_17425 = (state_17424[(1)]);
if((state_val_17425 === (7))){
var inst_17420 = (state_17424[(2)]);
var state_17424__$1 = state_17424;
var statearr_17426_17444 = state_17424__$1;
(statearr_17426_17444[(2)] = inst_17420);

(statearr_17426_17444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17425 === (1))){
var inst_17404 = init;
var state_17424__$1 = (function (){var statearr_17427 = state_17424;
(statearr_17427[(7)] = inst_17404);

return statearr_17427;
})();
var statearr_17428_17445 = state_17424__$1;
(statearr_17428_17445[(2)] = null);

(statearr_17428_17445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17425 === (4))){
var inst_17407 = (state_17424[(8)]);
var inst_17407__$1 = (state_17424[(2)]);
var inst_17408 = (inst_17407__$1 == null);
var state_17424__$1 = (function (){var statearr_17429 = state_17424;
(statearr_17429[(8)] = inst_17407__$1);

return statearr_17429;
})();
if(cljs.core.truth_(inst_17408)){
var statearr_17430_17446 = state_17424__$1;
(statearr_17430_17446[(1)] = (5));

} else {
var statearr_17431_17447 = state_17424__$1;
(statearr_17431_17447[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17425 === (6))){
var inst_17404 = (state_17424[(7)]);
var inst_17407 = (state_17424[(8)]);
var inst_17411 = (state_17424[(9)]);
var inst_17411__$1 = f.call(null,inst_17404,inst_17407);
var inst_17412 = cljs.core.reduced_QMARK_.call(null,inst_17411__$1);
var state_17424__$1 = (function (){var statearr_17432 = state_17424;
(statearr_17432[(9)] = inst_17411__$1);

return statearr_17432;
})();
if(inst_17412){
var statearr_17433_17448 = state_17424__$1;
(statearr_17433_17448[(1)] = (8));

} else {
var statearr_17434_17449 = state_17424__$1;
(statearr_17434_17449[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17425 === (3))){
var inst_17422 = (state_17424[(2)]);
var state_17424__$1 = state_17424;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17424__$1,inst_17422);
} else {
if((state_val_17425 === (2))){
var state_17424__$1 = state_17424;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17424__$1,(4),ch);
} else {
if((state_val_17425 === (9))){
var inst_17411 = (state_17424[(9)]);
var inst_17404 = inst_17411;
var state_17424__$1 = (function (){var statearr_17435 = state_17424;
(statearr_17435[(7)] = inst_17404);

return statearr_17435;
})();
var statearr_17436_17450 = state_17424__$1;
(statearr_17436_17450[(2)] = null);

(statearr_17436_17450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17425 === (5))){
var inst_17404 = (state_17424[(7)]);
var state_17424__$1 = state_17424;
var statearr_17437_17451 = state_17424__$1;
(statearr_17437_17451[(2)] = inst_17404);

(statearr_17437_17451[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17425 === (10))){
var inst_17418 = (state_17424[(2)]);
var state_17424__$1 = state_17424;
var statearr_17438_17452 = state_17424__$1;
(statearr_17438_17452[(2)] = inst_17418);

(statearr_17438_17452[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17425 === (8))){
var inst_17411 = (state_17424[(9)]);
var inst_17414 = cljs.core.deref.call(null,inst_17411);
var state_17424__$1 = state_17424;
var statearr_17439_17453 = state_17424__$1;
(statearr_17439_17453[(2)] = inst_17414);

(statearr_17439_17453[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__16937__auto__))
;
return ((function (switch__16847__auto__,c__16937__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__16848__auto__ = null;
var cljs$core$async$reduce_$_state_machine__16848__auto____0 = (function (){
var statearr_17440 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17440[(0)] = cljs$core$async$reduce_$_state_machine__16848__auto__);

(statearr_17440[(1)] = (1));

return statearr_17440;
});
var cljs$core$async$reduce_$_state_machine__16848__auto____1 = (function (state_17424){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_17424);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e17441){if((e17441 instanceof Object)){
var ex__16851__auto__ = e17441;
var statearr_17442_17454 = state_17424;
(statearr_17442_17454[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17424);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17441;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17455 = state_17424;
state_17424 = G__17455;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__16848__auto__ = function(state_17424){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__16848__auto____1.call(this,state_17424);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__16848__auto____0;
cljs$core$async$reduce_$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__16848__auto____1;
return cljs$core$async$reduce_$_state_machine__16848__auto__;
})()
;})(switch__16847__auto__,c__16937__auto__))
})();
var state__16939__auto__ = (function (){var statearr_17443 = f__16938__auto__.call(null);
(statearr_17443[(6)] = c__16937__auto__);

return statearr_17443;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(c__16937__auto__))
);

return c__16937__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__16937__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16937__auto__,f__$1){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (c__16937__auto__,f__$1){
return (function (state_17461){
var state_val_17462 = (state_17461[(1)]);
if((state_val_17462 === (1))){
var inst_17456 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_17461__$1 = state_17461;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17461__$1,(2),inst_17456);
} else {
if((state_val_17462 === (2))){
var inst_17458 = (state_17461[(2)]);
var inst_17459 = f__$1.call(null,inst_17458);
var state_17461__$1 = state_17461;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17461__$1,inst_17459);
} else {
return null;
}
}
});})(c__16937__auto__,f__$1))
;
return ((function (switch__16847__auto__,c__16937__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__16848__auto__ = null;
var cljs$core$async$transduce_$_state_machine__16848__auto____0 = (function (){
var statearr_17463 = [null,null,null,null,null,null,null];
(statearr_17463[(0)] = cljs$core$async$transduce_$_state_machine__16848__auto__);

(statearr_17463[(1)] = (1));

return statearr_17463;
});
var cljs$core$async$transduce_$_state_machine__16848__auto____1 = (function (state_17461){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_17461);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e17464){if((e17464 instanceof Object)){
var ex__16851__auto__ = e17464;
var statearr_17465_17467 = state_17461;
(statearr_17465_17467[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17461);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17464;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17468 = state_17461;
state_17461 = G__17468;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__16848__auto__ = function(state_17461){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__16848__auto____1.call(this,state_17461);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__16848__auto____0;
cljs$core$async$transduce_$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__16848__auto____1;
return cljs$core$async$transduce_$_state_machine__16848__auto__;
})()
;})(switch__16847__auto__,c__16937__auto__,f__$1))
})();
var state__16939__auto__ = (function (){var statearr_17466 = f__16938__auto__.call(null);
(statearr_17466[(6)] = c__16937__auto__);

return statearr_17466;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(c__16937__auto__,f__$1))
);

return c__16937__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__17470 = arguments.length;
switch (G__17470) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__16937__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16937__auto__){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (c__16937__auto__){
return (function (state_17495){
var state_val_17496 = (state_17495[(1)]);
if((state_val_17496 === (7))){
var inst_17477 = (state_17495[(2)]);
var state_17495__$1 = state_17495;
var statearr_17497_17518 = state_17495__$1;
(statearr_17497_17518[(2)] = inst_17477);

(statearr_17497_17518[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17496 === (1))){
var inst_17471 = cljs.core.seq.call(null,coll);
var inst_17472 = inst_17471;
var state_17495__$1 = (function (){var statearr_17498 = state_17495;
(statearr_17498[(7)] = inst_17472);

return statearr_17498;
})();
var statearr_17499_17519 = state_17495__$1;
(statearr_17499_17519[(2)] = null);

(statearr_17499_17519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17496 === (4))){
var inst_17472 = (state_17495[(7)]);
var inst_17475 = cljs.core.first.call(null,inst_17472);
var state_17495__$1 = state_17495;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17495__$1,(7),ch,inst_17475);
} else {
if((state_val_17496 === (13))){
var inst_17489 = (state_17495[(2)]);
var state_17495__$1 = state_17495;
var statearr_17500_17520 = state_17495__$1;
(statearr_17500_17520[(2)] = inst_17489);

(statearr_17500_17520[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17496 === (6))){
var inst_17480 = (state_17495[(2)]);
var state_17495__$1 = state_17495;
if(cljs.core.truth_(inst_17480)){
var statearr_17501_17521 = state_17495__$1;
(statearr_17501_17521[(1)] = (8));

} else {
var statearr_17502_17522 = state_17495__$1;
(statearr_17502_17522[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17496 === (3))){
var inst_17493 = (state_17495[(2)]);
var state_17495__$1 = state_17495;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17495__$1,inst_17493);
} else {
if((state_val_17496 === (12))){
var state_17495__$1 = state_17495;
var statearr_17503_17523 = state_17495__$1;
(statearr_17503_17523[(2)] = null);

(statearr_17503_17523[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17496 === (2))){
var inst_17472 = (state_17495[(7)]);
var state_17495__$1 = state_17495;
if(cljs.core.truth_(inst_17472)){
var statearr_17504_17524 = state_17495__$1;
(statearr_17504_17524[(1)] = (4));

} else {
var statearr_17505_17525 = state_17495__$1;
(statearr_17505_17525[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17496 === (11))){
var inst_17486 = cljs.core.async.close_BANG_.call(null,ch);
var state_17495__$1 = state_17495;
var statearr_17506_17526 = state_17495__$1;
(statearr_17506_17526[(2)] = inst_17486);

(statearr_17506_17526[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17496 === (9))){
var state_17495__$1 = state_17495;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17507_17527 = state_17495__$1;
(statearr_17507_17527[(1)] = (11));

} else {
var statearr_17508_17528 = state_17495__$1;
(statearr_17508_17528[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17496 === (5))){
var inst_17472 = (state_17495[(7)]);
var state_17495__$1 = state_17495;
var statearr_17509_17529 = state_17495__$1;
(statearr_17509_17529[(2)] = inst_17472);

(statearr_17509_17529[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17496 === (10))){
var inst_17491 = (state_17495[(2)]);
var state_17495__$1 = state_17495;
var statearr_17510_17530 = state_17495__$1;
(statearr_17510_17530[(2)] = inst_17491);

(statearr_17510_17530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17496 === (8))){
var inst_17472 = (state_17495[(7)]);
var inst_17482 = cljs.core.next.call(null,inst_17472);
var inst_17472__$1 = inst_17482;
var state_17495__$1 = (function (){var statearr_17511 = state_17495;
(statearr_17511[(7)] = inst_17472__$1);

return statearr_17511;
})();
var statearr_17512_17531 = state_17495__$1;
(statearr_17512_17531[(2)] = null);

(statearr_17512_17531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16937__auto__))
;
return ((function (switch__16847__auto__,c__16937__auto__){
return (function() {
var cljs$core$async$state_machine__16848__auto__ = null;
var cljs$core$async$state_machine__16848__auto____0 = (function (){
var statearr_17513 = [null,null,null,null,null,null,null,null];
(statearr_17513[(0)] = cljs$core$async$state_machine__16848__auto__);

(statearr_17513[(1)] = (1));

return statearr_17513;
});
var cljs$core$async$state_machine__16848__auto____1 = (function (state_17495){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_17495);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e17514){if((e17514 instanceof Object)){
var ex__16851__auto__ = e17514;
var statearr_17515_17532 = state_17495;
(statearr_17515_17532[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17495);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17514;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17533 = state_17495;
state_17495 = G__17533;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$state_machine__16848__auto__ = function(state_17495){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16848__auto____1.call(this,state_17495);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16848__auto____0;
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16848__auto____1;
return cljs$core$async$state_machine__16848__auto__;
})()
;})(switch__16847__auto__,c__16937__auto__))
})();
var state__16939__auto__ = (function (){var statearr_17516 = f__16938__auto__.call(null);
(statearr_17516[(6)] = c__16937__auto__);

return statearr_17516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(c__16937__auto__))
);

return c__16937__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__9121__auto__ = (((_ == null))?null:_);
var m__9122__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,_);
} else {
var m__9122__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m__$1,ch,close_QMARK_){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m__$1.cljs$core$async$Mult$tap_STAR_$arity$3(m__$1,ch,close_QMARK_);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1,ch,close_QMARK_);
} else {
var m__9122__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m__$1);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m__$1,ch){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mult$untap_STAR_$arity$2(m__$1,ch);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1,ch);
} else {
var m__9122__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m__$1);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m__$1){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m__$1.cljs$core$async$Mult$untap_all_STAR_$arity$1(m__$1);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1);
} else {
var m__9122__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m__$1);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m__$1 = (function (){
if(typeof cljs.core.async.t_cljs$core$async17534 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17534 = (function (ch,cs,meta17535){
this.ch = ch;
this.cs = cs;
this.meta17535 = meta17535;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17534.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_17536,meta17535__$1){
var self__ = this;
var _17536__$1 = this;
return (new cljs.core.async.t_cljs$core$async17534(self__.ch,self__.cs,meta17535__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async17534.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_17536){
var self__ = this;
var _17536__$1 = this;
return self__.meta17535;
});})(cs))
;

cljs.core.async.t_cljs$core$async17534.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17534.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async17534.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17534.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17534.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17534.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17534.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta17535","meta17535",1948636629,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async17534.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17534.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17534";

cljs.core.async.t_cljs$core$async17534.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async17534");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async17534 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async17534(ch__$1,cs__$1,meta17535){
return (new cljs.core.async.t_cljs$core$async17534(ch__$1,cs__$1,meta17535));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async17534(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m__$1,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m__$1,dchan,dctr))
;
var c__16937__auto___17756 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16937__auto___17756,cs,m__$1,dchan,dctr,done){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (c__16937__auto___17756,cs,m__$1,dchan,dctr,done){
return (function (state_17671){
var state_val_17672 = (state_17671[(1)]);
if((state_val_17672 === (7))){
var inst_17667 = (state_17671[(2)]);
var state_17671__$1 = state_17671;
var statearr_17673_17757 = state_17671__$1;
(statearr_17673_17757[(2)] = inst_17667);

(statearr_17673_17757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (20))){
var inst_17570 = (state_17671[(7)]);
var inst_17582 = cljs.core.first.call(null,inst_17570);
var inst_17583 = cljs.core.nth.call(null,inst_17582,(0),null);
var inst_17584 = cljs.core.nth.call(null,inst_17582,(1),null);
var state_17671__$1 = (function (){var statearr_17674 = state_17671;
(statearr_17674[(8)] = inst_17583);

return statearr_17674;
})();
if(cljs.core.truth_(inst_17584)){
var statearr_17675_17758 = state_17671__$1;
(statearr_17675_17758[(1)] = (22));

} else {
var statearr_17676_17759 = state_17671__$1;
(statearr_17676_17759[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (27))){
var inst_17539 = (state_17671[(9)]);
var inst_17612 = (state_17671[(10)]);
var inst_17619 = (state_17671[(11)]);
var inst_17614 = (state_17671[(12)]);
var inst_17619__$1 = cljs.core._nth.call(null,inst_17612,inst_17614);
var inst_17620 = cljs.core.async.put_BANG_.call(null,inst_17619__$1,inst_17539,done);
var state_17671__$1 = (function (){var statearr_17677 = state_17671;
(statearr_17677[(11)] = inst_17619__$1);

return statearr_17677;
})();
if(cljs.core.truth_(inst_17620)){
var statearr_17678_17760 = state_17671__$1;
(statearr_17678_17760[(1)] = (30));

} else {
var statearr_17679_17761 = state_17671__$1;
(statearr_17679_17761[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (1))){
var state_17671__$1 = state_17671;
var statearr_17680_17762 = state_17671__$1;
(statearr_17680_17762[(2)] = null);

(statearr_17680_17762[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (24))){
var inst_17570 = (state_17671[(7)]);
var inst_17589 = (state_17671[(2)]);
var inst_17590 = cljs.core.next.call(null,inst_17570);
var inst_17548 = inst_17590;
var inst_17549 = null;
var inst_17550 = (0);
var inst_17551 = (0);
var state_17671__$1 = (function (){var statearr_17681 = state_17671;
(statearr_17681[(13)] = inst_17550);

(statearr_17681[(14)] = inst_17549);

(statearr_17681[(15)] = inst_17589);

(statearr_17681[(16)] = inst_17551);

(statearr_17681[(17)] = inst_17548);

return statearr_17681;
})();
var statearr_17682_17763 = state_17671__$1;
(statearr_17682_17763[(2)] = null);

(statearr_17682_17763[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (39))){
var state_17671__$1 = state_17671;
var statearr_17686_17764 = state_17671__$1;
(statearr_17686_17764[(2)] = null);

(statearr_17686_17764[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (4))){
var inst_17539 = (state_17671[(9)]);
var inst_17539__$1 = (state_17671[(2)]);
var inst_17540 = (inst_17539__$1 == null);
var state_17671__$1 = (function (){var statearr_17687 = state_17671;
(statearr_17687[(9)] = inst_17539__$1);

return statearr_17687;
})();
if(cljs.core.truth_(inst_17540)){
var statearr_17688_17765 = state_17671__$1;
(statearr_17688_17765[(1)] = (5));

} else {
var statearr_17689_17766 = state_17671__$1;
(statearr_17689_17766[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (15))){
var inst_17550 = (state_17671[(13)]);
var inst_17549 = (state_17671[(14)]);
var inst_17551 = (state_17671[(16)]);
var inst_17548 = (state_17671[(17)]);
var inst_17566 = (state_17671[(2)]);
var inst_17567 = (inst_17551 + (1));
var tmp17683 = inst_17550;
var tmp17684 = inst_17549;
var tmp17685 = inst_17548;
var inst_17548__$1 = tmp17685;
var inst_17549__$1 = tmp17684;
var inst_17550__$1 = tmp17683;
var inst_17551__$1 = inst_17567;
var state_17671__$1 = (function (){var statearr_17690 = state_17671;
(statearr_17690[(13)] = inst_17550__$1);

(statearr_17690[(14)] = inst_17549__$1);

(statearr_17690[(16)] = inst_17551__$1);

(statearr_17690[(17)] = inst_17548__$1);

(statearr_17690[(18)] = inst_17566);

return statearr_17690;
})();
var statearr_17691_17767 = state_17671__$1;
(statearr_17691_17767[(2)] = null);

(statearr_17691_17767[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (21))){
var inst_17593 = (state_17671[(2)]);
var state_17671__$1 = state_17671;
var statearr_17695_17768 = state_17671__$1;
(statearr_17695_17768[(2)] = inst_17593);

(statearr_17695_17768[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (31))){
var inst_17619 = (state_17671[(11)]);
var inst_17623 = done.call(null,null);
var inst_17624 = cljs.core.async.untap_STAR_.call(null,m__$1,inst_17619);
var state_17671__$1 = (function (){var statearr_17696 = state_17671;
(statearr_17696[(19)] = inst_17623);

return statearr_17696;
})();
var statearr_17697_17769 = state_17671__$1;
(statearr_17697_17769[(2)] = inst_17624);

(statearr_17697_17769[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (32))){
var inst_17612 = (state_17671[(10)]);
var inst_17613 = (state_17671[(20)]);
var inst_17611 = (state_17671[(21)]);
var inst_17614 = (state_17671[(12)]);
var inst_17626 = (state_17671[(2)]);
var inst_17627 = (inst_17614 + (1));
var tmp17692 = inst_17612;
var tmp17693 = inst_17613;
var tmp17694 = inst_17611;
var inst_17611__$1 = tmp17694;
var inst_17612__$1 = tmp17692;
var inst_17613__$1 = tmp17693;
var inst_17614__$1 = inst_17627;
var state_17671__$1 = (function (){var statearr_17698 = state_17671;
(statearr_17698[(10)] = inst_17612__$1);

(statearr_17698[(22)] = inst_17626);

(statearr_17698[(20)] = inst_17613__$1);

(statearr_17698[(21)] = inst_17611__$1);

(statearr_17698[(12)] = inst_17614__$1);

return statearr_17698;
})();
var statearr_17699_17770 = state_17671__$1;
(statearr_17699_17770[(2)] = null);

(statearr_17699_17770[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (40))){
var inst_17639 = (state_17671[(23)]);
var inst_17643 = done.call(null,null);
var inst_17644 = cljs.core.async.untap_STAR_.call(null,m__$1,inst_17639);
var state_17671__$1 = (function (){var statearr_17700 = state_17671;
(statearr_17700[(24)] = inst_17643);

return statearr_17700;
})();
var statearr_17701_17771 = state_17671__$1;
(statearr_17701_17771[(2)] = inst_17644);

(statearr_17701_17771[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (33))){
var inst_17630 = (state_17671[(25)]);
var inst_17632 = cljs.core.chunked_seq_QMARK_.call(null,inst_17630);
var state_17671__$1 = state_17671;
if(inst_17632){
var statearr_17702_17772 = state_17671__$1;
(statearr_17702_17772[(1)] = (36));

} else {
var statearr_17703_17773 = state_17671__$1;
(statearr_17703_17773[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (13))){
var inst_17560 = (state_17671[(26)]);
var inst_17563 = cljs.core.async.close_BANG_.call(null,inst_17560);
var state_17671__$1 = state_17671;
var statearr_17704_17774 = state_17671__$1;
(statearr_17704_17774[(2)] = inst_17563);

(statearr_17704_17774[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (22))){
var inst_17583 = (state_17671[(8)]);
var inst_17586 = cljs.core.async.close_BANG_.call(null,inst_17583);
var state_17671__$1 = state_17671;
var statearr_17705_17775 = state_17671__$1;
(statearr_17705_17775[(2)] = inst_17586);

(statearr_17705_17775[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (36))){
var inst_17630 = (state_17671[(25)]);
var inst_17634 = cljs.core.chunk_first.call(null,inst_17630);
var inst_17635 = cljs.core.chunk_rest.call(null,inst_17630);
var inst_17636 = cljs.core.count.call(null,inst_17634);
var inst_17611 = inst_17635;
var inst_17612 = inst_17634;
var inst_17613 = inst_17636;
var inst_17614 = (0);
var state_17671__$1 = (function (){var statearr_17706 = state_17671;
(statearr_17706[(10)] = inst_17612);

(statearr_17706[(20)] = inst_17613);

(statearr_17706[(21)] = inst_17611);

(statearr_17706[(12)] = inst_17614);

return statearr_17706;
})();
var statearr_17707_17776 = state_17671__$1;
(statearr_17707_17776[(2)] = null);

(statearr_17707_17776[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (41))){
var inst_17630 = (state_17671[(25)]);
var inst_17646 = (state_17671[(2)]);
var inst_17647 = cljs.core.next.call(null,inst_17630);
var inst_17611 = inst_17647;
var inst_17612 = null;
var inst_17613 = (0);
var inst_17614 = (0);
var state_17671__$1 = (function (){var statearr_17708 = state_17671;
(statearr_17708[(10)] = inst_17612);

(statearr_17708[(27)] = inst_17646);

(statearr_17708[(20)] = inst_17613);

(statearr_17708[(21)] = inst_17611);

(statearr_17708[(12)] = inst_17614);

return statearr_17708;
})();
var statearr_17709_17777 = state_17671__$1;
(statearr_17709_17777[(2)] = null);

(statearr_17709_17777[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (43))){
var state_17671__$1 = state_17671;
var statearr_17710_17778 = state_17671__$1;
(statearr_17710_17778[(2)] = null);

(statearr_17710_17778[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (29))){
var inst_17655 = (state_17671[(2)]);
var state_17671__$1 = state_17671;
var statearr_17711_17779 = state_17671__$1;
(statearr_17711_17779[(2)] = inst_17655);

(statearr_17711_17779[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (44))){
var inst_17664 = (state_17671[(2)]);
var state_17671__$1 = (function (){var statearr_17712 = state_17671;
(statearr_17712[(28)] = inst_17664);

return statearr_17712;
})();
var statearr_17713_17780 = state_17671__$1;
(statearr_17713_17780[(2)] = null);

(statearr_17713_17780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (6))){
var inst_17603 = (state_17671[(29)]);
var inst_17602 = cljs.core.deref.call(null,cs);
var inst_17603__$1 = cljs.core.keys.call(null,inst_17602);
var inst_17604 = cljs.core.count.call(null,inst_17603__$1);
var inst_17605 = cljs.core.reset_BANG_.call(null,dctr,inst_17604);
var inst_17610 = cljs.core.seq.call(null,inst_17603__$1);
var inst_17611 = inst_17610;
var inst_17612 = null;
var inst_17613 = (0);
var inst_17614 = (0);
var state_17671__$1 = (function (){var statearr_17714 = state_17671;
(statearr_17714[(30)] = inst_17605);

(statearr_17714[(29)] = inst_17603__$1);

(statearr_17714[(10)] = inst_17612);

(statearr_17714[(20)] = inst_17613);

(statearr_17714[(21)] = inst_17611);

(statearr_17714[(12)] = inst_17614);

return statearr_17714;
})();
var statearr_17715_17781 = state_17671__$1;
(statearr_17715_17781[(2)] = null);

(statearr_17715_17781[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (28))){
var inst_17630 = (state_17671[(25)]);
var inst_17611 = (state_17671[(21)]);
var inst_17630__$1 = cljs.core.seq.call(null,inst_17611);
var state_17671__$1 = (function (){var statearr_17716 = state_17671;
(statearr_17716[(25)] = inst_17630__$1);

return statearr_17716;
})();
if(inst_17630__$1){
var statearr_17717_17782 = state_17671__$1;
(statearr_17717_17782[(1)] = (33));

} else {
var statearr_17718_17783 = state_17671__$1;
(statearr_17718_17783[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (25))){
var inst_17613 = (state_17671[(20)]);
var inst_17614 = (state_17671[(12)]);
var inst_17616 = (inst_17614 < inst_17613);
var inst_17617 = inst_17616;
var state_17671__$1 = state_17671;
if(cljs.core.truth_(inst_17617)){
var statearr_17719_17784 = state_17671__$1;
(statearr_17719_17784[(1)] = (27));

} else {
var statearr_17720_17785 = state_17671__$1;
(statearr_17720_17785[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (34))){
var state_17671__$1 = state_17671;
var statearr_17721_17786 = state_17671__$1;
(statearr_17721_17786[(2)] = null);

(statearr_17721_17786[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (17))){
var state_17671__$1 = state_17671;
var statearr_17722_17787 = state_17671__$1;
(statearr_17722_17787[(2)] = null);

(statearr_17722_17787[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (3))){
var inst_17669 = (state_17671[(2)]);
var state_17671__$1 = state_17671;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17671__$1,inst_17669);
} else {
if((state_val_17672 === (12))){
var inst_17598 = (state_17671[(2)]);
var state_17671__$1 = state_17671;
var statearr_17723_17788 = state_17671__$1;
(statearr_17723_17788[(2)] = inst_17598);

(statearr_17723_17788[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (2))){
var state_17671__$1 = state_17671;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17671__$1,(4),ch);
} else {
if((state_val_17672 === (23))){
var state_17671__$1 = state_17671;
var statearr_17724_17789 = state_17671__$1;
(statearr_17724_17789[(2)] = null);

(statearr_17724_17789[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (35))){
var inst_17653 = (state_17671[(2)]);
var state_17671__$1 = state_17671;
var statearr_17725_17790 = state_17671__$1;
(statearr_17725_17790[(2)] = inst_17653);

(statearr_17725_17790[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (19))){
var inst_17570 = (state_17671[(7)]);
var inst_17574 = cljs.core.chunk_first.call(null,inst_17570);
var inst_17575 = cljs.core.chunk_rest.call(null,inst_17570);
var inst_17576 = cljs.core.count.call(null,inst_17574);
var inst_17548 = inst_17575;
var inst_17549 = inst_17574;
var inst_17550 = inst_17576;
var inst_17551 = (0);
var state_17671__$1 = (function (){var statearr_17726 = state_17671;
(statearr_17726[(13)] = inst_17550);

(statearr_17726[(14)] = inst_17549);

(statearr_17726[(16)] = inst_17551);

(statearr_17726[(17)] = inst_17548);

return statearr_17726;
})();
var statearr_17727_17791 = state_17671__$1;
(statearr_17727_17791[(2)] = null);

(statearr_17727_17791[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (11))){
var inst_17570 = (state_17671[(7)]);
var inst_17548 = (state_17671[(17)]);
var inst_17570__$1 = cljs.core.seq.call(null,inst_17548);
var state_17671__$1 = (function (){var statearr_17728 = state_17671;
(statearr_17728[(7)] = inst_17570__$1);

return statearr_17728;
})();
if(inst_17570__$1){
var statearr_17729_17792 = state_17671__$1;
(statearr_17729_17792[(1)] = (16));

} else {
var statearr_17730_17793 = state_17671__$1;
(statearr_17730_17793[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (9))){
var inst_17600 = (state_17671[(2)]);
var state_17671__$1 = state_17671;
var statearr_17731_17794 = state_17671__$1;
(statearr_17731_17794[(2)] = inst_17600);

(statearr_17731_17794[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (5))){
var inst_17546 = cljs.core.deref.call(null,cs);
var inst_17547 = cljs.core.seq.call(null,inst_17546);
var inst_17548 = inst_17547;
var inst_17549 = null;
var inst_17550 = (0);
var inst_17551 = (0);
var state_17671__$1 = (function (){var statearr_17732 = state_17671;
(statearr_17732[(13)] = inst_17550);

(statearr_17732[(14)] = inst_17549);

(statearr_17732[(16)] = inst_17551);

(statearr_17732[(17)] = inst_17548);

return statearr_17732;
})();
var statearr_17733_17795 = state_17671__$1;
(statearr_17733_17795[(2)] = null);

(statearr_17733_17795[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (14))){
var state_17671__$1 = state_17671;
var statearr_17734_17796 = state_17671__$1;
(statearr_17734_17796[(2)] = null);

(statearr_17734_17796[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (45))){
var inst_17661 = (state_17671[(2)]);
var state_17671__$1 = state_17671;
var statearr_17735_17797 = state_17671__$1;
(statearr_17735_17797[(2)] = inst_17661);

(statearr_17735_17797[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (26))){
var inst_17603 = (state_17671[(29)]);
var inst_17657 = (state_17671[(2)]);
var inst_17658 = cljs.core.seq.call(null,inst_17603);
var state_17671__$1 = (function (){var statearr_17736 = state_17671;
(statearr_17736[(31)] = inst_17657);

return statearr_17736;
})();
if(inst_17658){
var statearr_17737_17798 = state_17671__$1;
(statearr_17737_17798[(1)] = (42));

} else {
var statearr_17738_17799 = state_17671__$1;
(statearr_17738_17799[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (16))){
var inst_17570 = (state_17671[(7)]);
var inst_17572 = cljs.core.chunked_seq_QMARK_.call(null,inst_17570);
var state_17671__$1 = state_17671;
if(inst_17572){
var statearr_17739_17800 = state_17671__$1;
(statearr_17739_17800[(1)] = (19));

} else {
var statearr_17740_17801 = state_17671__$1;
(statearr_17740_17801[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (38))){
var inst_17650 = (state_17671[(2)]);
var state_17671__$1 = state_17671;
var statearr_17741_17802 = state_17671__$1;
(statearr_17741_17802[(2)] = inst_17650);

(statearr_17741_17802[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (30))){
var state_17671__$1 = state_17671;
var statearr_17742_17803 = state_17671__$1;
(statearr_17742_17803[(2)] = null);

(statearr_17742_17803[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (10))){
var inst_17549 = (state_17671[(14)]);
var inst_17551 = (state_17671[(16)]);
var inst_17559 = cljs.core._nth.call(null,inst_17549,inst_17551);
var inst_17560 = cljs.core.nth.call(null,inst_17559,(0),null);
var inst_17561 = cljs.core.nth.call(null,inst_17559,(1),null);
var state_17671__$1 = (function (){var statearr_17743 = state_17671;
(statearr_17743[(26)] = inst_17560);

return statearr_17743;
})();
if(cljs.core.truth_(inst_17561)){
var statearr_17744_17804 = state_17671__$1;
(statearr_17744_17804[(1)] = (13));

} else {
var statearr_17745_17805 = state_17671__$1;
(statearr_17745_17805[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (18))){
var inst_17596 = (state_17671[(2)]);
var state_17671__$1 = state_17671;
var statearr_17746_17806 = state_17671__$1;
(statearr_17746_17806[(2)] = inst_17596);

(statearr_17746_17806[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (42))){
var state_17671__$1 = state_17671;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17671__$1,(45),dchan);
} else {
if((state_val_17672 === (37))){
var inst_17539 = (state_17671[(9)]);
var inst_17630 = (state_17671[(25)]);
var inst_17639 = (state_17671[(23)]);
var inst_17639__$1 = cljs.core.first.call(null,inst_17630);
var inst_17640 = cljs.core.async.put_BANG_.call(null,inst_17639__$1,inst_17539,done);
var state_17671__$1 = (function (){var statearr_17747 = state_17671;
(statearr_17747[(23)] = inst_17639__$1);

return statearr_17747;
})();
if(cljs.core.truth_(inst_17640)){
var statearr_17748_17807 = state_17671__$1;
(statearr_17748_17807[(1)] = (39));

} else {
var statearr_17749_17808 = state_17671__$1;
(statearr_17749_17808[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17672 === (8))){
var inst_17550 = (state_17671[(13)]);
var inst_17551 = (state_17671[(16)]);
var inst_17553 = (inst_17551 < inst_17550);
var inst_17554 = inst_17553;
var state_17671__$1 = state_17671;
if(cljs.core.truth_(inst_17554)){
var statearr_17750_17809 = state_17671__$1;
(statearr_17750_17809[(1)] = (10));

} else {
var statearr_17751_17810 = state_17671__$1;
(statearr_17751_17810[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16937__auto___17756,cs,m__$1,dchan,dctr,done))
;
return ((function (switch__16847__auto__,c__16937__auto___17756,cs,m__$1,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__16848__auto__ = null;
var cljs$core$async$mult_$_state_machine__16848__auto____0 = (function (){
var statearr_17752 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17752[(0)] = cljs$core$async$mult_$_state_machine__16848__auto__);

(statearr_17752[(1)] = (1));

return statearr_17752;
});
var cljs$core$async$mult_$_state_machine__16848__auto____1 = (function (state_17671){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_17671);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e17753){if((e17753 instanceof Object)){
var ex__16851__auto__ = e17753;
var statearr_17754_17811 = state_17671;
(statearr_17754_17811[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17671);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17753;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17812 = state_17671;
state_17671 = G__17812;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__16848__auto__ = function(state_17671){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__16848__auto____1.call(this,state_17671);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__16848__auto____0;
cljs$core$async$mult_$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__16848__auto____1;
return cljs$core$async$mult_$_state_machine__16848__auto__;
})()
;})(switch__16847__auto__,c__16937__auto___17756,cs,m__$1,dchan,dctr,done))
})();
var state__16939__auto__ = (function (){var statearr_17755 = f__16938__auto__.call(null);
(statearr_17755[(6)] = c__16937__auto___17756);

return statearr_17755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(c__16937__auto___17756,cs,m__$1,dchan,dctr,done))
);


return m__$1;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__17814 = arguments.length;
switch (G__17814) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m__$1,ch){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mix$admix_STAR_$arity$2(m__$1,ch);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1,ch);
} else {
var m__9122__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m__$1);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m__$1,ch){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mix$unmix_STAR_$arity$2(m__$1,ch);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1,ch);
} else {
var m__9122__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m__$1);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m__$1){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m__$1.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m__$1);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1);
} else {
var m__9122__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m__$1);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m__$1,state_map){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mix$toggle_STAR_$arity$2(m__$1,state_map);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1,state_map);
} else {
var m__9122__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m__$1);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m__$1,mode){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m__$1,mode);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1,mode);
} else {
var m__9122__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m__$1);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__9674__auto__ = [];
var len__9667__auto___17826 = arguments.length;
var i__9668__auto___17827 = (0);
while(true){
if((i__9668__auto___17827 < len__9667__auto___17826)){
args__9674__auto__.push((arguments[i__9668__auto___17827]));

var G__17828 = (i__9668__auto___17827 + (1));
i__9668__auto___17827 = G__17828;
continue;
} else {
}
break;
}

var argseq__9675__auto__ = ((((3) < args__9674__auto__.length))?(new cljs.core.IndexedSeq(args__9674__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9675__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__17820){
var map__17821 = p__17820;
var map__17821__$1 = ((((!((map__17821 == null)))?((((map__17821.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17821.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17821):map__17821);
var opts = map__17821__$1;
var statearr_17823_17829 = state;
(statearr_17823_17829[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts.call(null,((function (map__17821,map__17821__$1,opts){
return (function (val){
var statearr_17824_17830 = state;
(statearr_17824_17830[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__17821,map__17821__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_17825_17831 = state;
(statearr_17825_17831[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq17816){
var G__17817 = cljs.core.first.call(null,seq17816);
var seq17816__$1 = cljs.core.next.call(null,seq17816);
var G__17818 = cljs.core.first.call(null,seq17816__$1);
var seq17816__$2 = cljs.core.next.call(null,seq17816__$1);
var G__17819 = cljs.core.first.call(null,seq17816__$2);
var seq17816__$3 = cljs.core.next.call(null,seq17816__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17817,G__17818,G__17819,seq17816__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m__$1 = (function (){
if(typeof cljs.core.async.t_cljs$core$async17832 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17832 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta17833){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta17833 = meta17833;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17832.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_17834,meta17833__$1){
var self__ = this;
var _17834__$1 = this;
return (new cljs.core.async.t_cljs$core$async17832(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta17833__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17832.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_17834){
var self__ = this;
var _17834__$1 = this;
return self__.meta17833;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17832.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17832.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17832.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17832.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17832.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17832.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17832.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17832.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17832.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta17833","meta17833",78110575,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17832.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17832.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17832";

cljs.core.async.t_cljs$core$async17832.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async17832");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async17832 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async17832(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta17833){
return (new cljs.core.async.t_cljs$core$async17832(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta17833));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async17832(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16937__auto___17996 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16937__auto___17996,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (c__16937__auto___17996,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1){
return (function (state_17936){
var state_val_17937 = (state_17936[(1)]);
if((state_val_17937 === (7))){
var inst_17851 = (state_17936[(2)]);
var state_17936__$1 = state_17936;
var statearr_17938_17997 = state_17936__$1;
(statearr_17938_17997[(2)] = inst_17851);

(statearr_17938_17997[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (20))){
var inst_17863 = (state_17936[(7)]);
var state_17936__$1 = state_17936;
var statearr_17939_17998 = state_17936__$1;
(statearr_17939_17998[(2)] = inst_17863);

(statearr_17939_17998[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (27))){
var state_17936__$1 = state_17936;
var statearr_17940_17999 = state_17936__$1;
(statearr_17940_17999[(2)] = null);

(statearr_17940_17999[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (1))){
var inst_17838 = (state_17936[(8)]);
var inst_17838__$1 = calc_state.call(null);
var inst_17840 = (inst_17838__$1 == null);
var inst_17841 = cljs.core.not.call(null,inst_17840);
var state_17936__$1 = (function (){var statearr_17941 = state_17936;
(statearr_17941[(8)] = inst_17838__$1);

return statearr_17941;
})();
if(inst_17841){
var statearr_17942_18000 = state_17936__$1;
(statearr_17942_18000[(1)] = (2));

} else {
var statearr_17943_18001 = state_17936__$1;
(statearr_17943_18001[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (24))){
var inst_17910 = (state_17936[(9)]);
var inst_17896 = (state_17936[(10)]);
var inst_17887 = (state_17936[(11)]);
var inst_17910__$1 = inst_17887.call(null,inst_17896);
var state_17936__$1 = (function (){var statearr_17944 = state_17936;
(statearr_17944[(9)] = inst_17910__$1);

return statearr_17944;
})();
if(cljs.core.truth_(inst_17910__$1)){
var statearr_17945_18002 = state_17936__$1;
(statearr_17945_18002[(1)] = (29));

} else {
var statearr_17946_18003 = state_17936__$1;
(statearr_17946_18003[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (4))){
var inst_17854 = (state_17936[(2)]);
var state_17936__$1 = state_17936;
if(cljs.core.truth_(inst_17854)){
var statearr_17947_18004 = state_17936__$1;
(statearr_17947_18004[(1)] = (8));

} else {
var statearr_17948_18005 = state_17936__$1;
(statearr_17948_18005[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (15))){
var inst_17881 = (state_17936[(2)]);
var state_17936__$1 = state_17936;
if(cljs.core.truth_(inst_17881)){
var statearr_17949_18006 = state_17936__$1;
(statearr_17949_18006[(1)] = (19));

} else {
var statearr_17950_18007 = state_17936__$1;
(statearr_17950_18007[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (21))){
var inst_17886 = (state_17936[(12)]);
var inst_17886__$1 = (state_17936[(2)]);
var inst_17887 = cljs.core.get.call(null,inst_17886__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_17888 = cljs.core.get.call(null,inst_17886__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_17889 = cljs.core.get.call(null,inst_17886__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_17936__$1 = (function (){var statearr_17951 = state_17936;
(statearr_17951[(12)] = inst_17886__$1);

(statearr_17951[(13)] = inst_17888);

(statearr_17951[(11)] = inst_17887);

return statearr_17951;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_17936__$1,(22),inst_17889);
} else {
if((state_val_17937 === (31))){
var inst_17918 = (state_17936[(2)]);
var state_17936__$1 = state_17936;
if(cljs.core.truth_(inst_17918)){
var statearr_17952_18008 = state_17936__$1;
(statearr_17952_18008[(1)] = (32));

} else {
var statearr_17953_18009 = state_17936__$1;
(statearr_17953_18009[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (32))){
var inst_17895 = (state_17936[(14)]);
var state_17936__$1 = state_17936;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17936__$1,(35),out,inst_17895);
} else {
if((state_val_17937 === (33))){
var inst_17886 = (state_17936[(12)]);
var inst_17863 = inst_17886;
var state_17936__$1 = (function (){var statearr_17954 = state_17936;
(statearr_17954[(7)] = inst_17863);

return statearr_17954;
})();
var statearr_17955_18010 = state_17936__$1;
(statearr_17955_18010[(2)] = null);

(statearr_17955_18010[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (13))){
var inst_17863 = (state_17936[(7)]);
var inst_17870 = inst_17863.cljs$lang$protocol_mask$partition0$;
var inst_17871 = (inst_17870 & (64));
var inst_17872 = inst_17863.cljs$core$ISeq$;
var inst_17873 = (cljs.core.PROTOCOL_SENTINEL === inst_17872);
var inst_17874 = (inst_17871) || (inst_17873);
var state_17936__$1 = state_17936;
if(cljs.core.truth_(inst_17874)){
var statearr_17956_18011 = state_17936__$1;
(statearr_17956_18011[(1)] = (16));

} else {
var statearr_17957_18012 = state_17936__$1;
(statearr_17957_18012[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (22))){
var inst_17895 = (state_17936[(14)]);
var inst_17896 = (state_17936[(10)]);
var inst_17894 = (state_17936[(2)]);
var inst_17895__$1 = cljs.core.nth.call(null,inst_17894,(0),null);
var inst_17896__$1 = cljs.core.nth.call(null,inst_17894,(1),null);
var inst_17897 = (inst_17895__$1 == null);
var inst_17898 = cljs.core._EQ_.call(null,inst_17896__$1,change);
var inst_17899 = (inst_17897) || (inst_17898);
var state_17936__$1 = (function (){var statearr_17958 = state_17936;
(statearr_17958[(14)] = inst_17895__$1);

(statearr_17958[(10)] = inst_17896__$1);

return statearr_17958;
})();
if(cljs.core.truth_(inst_17899)){
var statearr_17959_18013 = state_17936__$1;
(statearr_17959_18013[(1)] = (23));

} else {
var statearr_17960_18014 = state_17936__$1;
(statearr_17960_18014[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (36))){
var inst_17886 = (state_17936[(12)]);
var inst_17863 = inst_17886;
var state_17936__$1 = (function (){var statearr_17961 = state_17936;
(statearr_17961[(7)] = inst_17863);

return statearr_17961;
})();
var statearr_17962_18015 = state_17936__$1;
(statearr_17962_18015[(2)] = null);

(statearr_17962_18015[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (29))){
var inst_17910 = (state_17936[(9)]);
var state_17936__$1 = state_17936;
var statearr_17963_18016 = state_17936__$1;
(statearr_17963_18016[(2)] = inst_17910);

(statearr_17963_18016[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (6))){
var state_17936__$1 = state_17936;
var statearr_17964_18017 = state_17936__$1;
(statearr_17964_18017[(2)] = false);

(statearr_17964_18017[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (28))){
var inst_17906 = (state_17936[(2)]);
var inst_17907 = calc_state.call(null);
var inst_17863 = inst_17907;
var state_17936__$1 = (function (){var statearr_17965 = state_17936;
(statearr_17965[(15)] = inst_17906);

(statearr_17965[(7)] = inst_17863);

return statearr_17965;
})();
var statearr_17966_18018 = state_17936__$1;
(statearr_17966_18018[(2)] = null);

(statearr_17966_18018[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (25))){
var inst_17932 = (state_17936[(2)]);
var state_17936__$1 = state_17936;
var statearr_17967_18019 = state_17936__$1;
(statearr_17967_18019[(2)] = inst_17932);

(statearr_17967_18019[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (34))){
var inst_17930 = (state_17936[(2)]);
var state_17936__$1 = state_17936;
var statearr_17968_18020 = state_17936__$1;
(statearr_17968_18020[(2)] = inst_17930);

(statearr_17968_18020[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (17))){
var state_17936__$1 = state_17936;
var statearr_17969_18021 = state_17936__$1;
(statearr_17969_18021[(2)] = false);

(statearr_17969_18021[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (3))){
var state_17936__$1 = state_17936;
var statearr_17970_18022 = state_17936__$1;
(statearr_17970_18022[(2)] = false);

(statearr_17970_18022[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (12))){
var inst_17934 = (state_17936[(2)]);
var state_17936__$1 = state_17936;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17936__$1,inst_17934);
} else {
if((state_val_17937 === (2))){
var inst_17838 = (state_17936[(8)]);
var inst_17843 = inst_17838.cljs$lang$protocol_mask$partition0$;
var inst_17844 = (inst_17843 & (64));
var inst_17845 = inst_17838.cljs$core$ISeq$;
var inst_17846 = (cljs.core.PROTOCOL_SENTINEL === inst_17845);
var inst_17847 = (inst_17844) || (inst_17846);
var state_17936__$1 = state_17936;
if(cljs.core.truth_(inst_17847)){
var statearr_17971_18023 = state_17936__$1;
(statearr_17971_18023[(1)] = (5));

} else {
var statearr_17972_18024 = state_17936__$1;
(statearr_17972_18024[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (23))){
var inst_17895 = (state_17936[(14)]);
var inst_17901 = (inst_17895 == null);
var state_17936__$1 = state_17936;
if(cljs.core.truth_(inst_17901)){
var statearr_17973_18025 = state_17936__$1;
(statearr_17973_18025[(1)] = (26));

} else {
var statearr_17974_18026 = state_17936__$1;
(statearr_17974_18026[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (35))){
var inst_17921 = (state_17936[(2)]);
var state_17936__$1 = state_17936;
if(cljs.core.truth_(inst_17921)){
var statearr_17975_18027 = state_17936__$1;
(statearr_17975_18027[(1)] = (36));

} else {
var statearr_17976_18028 = state_17936__$1;
(statearr_17976_18028[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (19))){
var inst_17863 = (state_17936[(7)]);
var inst_17883 = cljs.core.apply.call(null,cljs.core.hash_map,inst_17863);
var state_17936__$1 = state_17936;
var statearr_17977_18029 = state_17936__$1;
(statearr_17977_18029[(2)] = inst_17883);

(statearr_17977_18029[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (11))){
var inst_17863 = (state_17936[(7)]);
var inst_17867 = (inst_17863 == null);
var inst_17868 = cljs.core.not.call(null,inst_17867);
var state_17936__$1 = state_17936;
if(inst_17868){
var statearr_17978_18030 = state_17936__$1;
(statearr_17978_18030[(1)] = (13));

} else {
var statearr_17979_18031 = state_17936__$1;
(statearr_17979_18031[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (9))){
var inst_17838 = (state_17936[(8)]);
var state_17936__$1 = state_17936;
var statearr_17980_18032 = state_17936__$1;
(statearr_17980_18032[(2)] = inst_17838);

(statearr_17980_18032[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (5))){
var state_17936__$1 = state_17936;
var statearr_17981_18033 = state_17936__$1;
(statearr_17981_18033[(2)] = true);

(statearr_17981_18033[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (14))){
var state_17936__$1 = state_17936;
var statearr_17982_18034 = state_17936__$1;
(statearr_17982_18034[(2)] = false);

(statearr_17982_18034[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (26))){
var inst_17896 = (state_17936[(10)]);
var inst_17903 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_17896);
var state_17936__$1 = state_17936;
var statearr_17983_18035 = state_17936__$1;
(statearr_17983_18035[(2)] = inst_17903);

(statearr_17983_18035[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (16))){
var state_17936__$1 = state_17936;
var statearr_17984_18036 = state_17936__$1;
(statearr_17984_18036[(2)] = true);

(statearr_17984_18036[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (38))){
var inst_17926 = (state_17936[(2)]);
var state_17936__$1 = state_17936;
var statearr_17985_18037 = state_17936__$1;
(statearr_17985_18037[(2)] = inst_17926);

(statearr_17985_18037[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (30))){
var inst_17888 = (state_17936[(13)]);
var inst_17896 = (state_17936[(10)]);
var inst_17887 = (state_17936[(11)]);
var inst_17913 = cljs.core.empty_QMARK_.call(null,inst_17887);
var inst_17914 = inst_17888.call(null,inst_17896);
var inst_17915 = cljs.core.not.call(null,inst_17914);
var inst_17916 = (inst_17913) && (inst_17915);
var state_17936__$1 = state_17936;
var statearr_17986_18038 = state_17936__$1;
(statearr_17986_18038[(2)] = inst_17916);

(statearr_17986_18038[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (10))){
var inst_17838 = (state_17936[(8)]);
var inst_17859 = (state_17936[(2)]);
var inst_17860 = cljs.core.get.call(null,inst_17859,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_17861 = cljs.core.get.call(null,inst_17859,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_17862 = cljs.core.get.call(null,inst_17859,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_17863 = inst_17838;
var state_17936__$1 = (function (){var statearr_17987 = state_17936;
(statearr_17987[(16)] = inst_17862);

(statearr_17987[(17)] = inst_17861);

(statearr_17987[(18)] = inst_17860);

(statearr_17987[(7)] = inst_17863);

return statearr_17987;
})();
var statearr_17988_18039 = state_17936__$1;
(statearr_17988_18039[(2)] = null);

(statearr_17988_18039[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (18))){
var inst_17878 = (state_17936[(2)]);
var state_17936__$1 = state_17936;
var statearr_17989_18040 = state_17936__$1;
(statearr_17989_18040[(2)] = inst_17878);

(statearr_17989_18040[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (37))){
var state_17936__$1 = state_17936;
var statearr_17990_18041 = state_17936__$1;
(statearr_17990_18041[(2)] = null);

(statearr_17990_18041[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17937 === (8))){
var inst_17838 = (state_17936[(8)]);
var inst_17856 = cljs.core.apply.call(null,cljs.core.hash_map,inst_17838);
var state_17936__$1 = state_17936;
var statearr_17991_18042 = state_17936__$1;
(statearr_17991_18042[(2)] = inst_17856);

(statearr_17991_18042[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16937__auto___17996,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1))
;
return ((function (switch__16847__auto__,c__16937__auto___17996,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1){
return (function() {
var cljs$core$async$mix_$_state_machine__16848__auto__ = null;
var cljs$core$async$mix_$_state_machine__16848__auto____0 = (function (){
var statearr_17992 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17992[(0)] = cljs$core$async$mix_$_state_machine__16848__auto__);

(statearr_17992[(1)] = (1));

return statearr_17992;
});
var cljs$core$async$mix_$_state_machine__16848__auto____1 = (function (state_17936){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_17936);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e17993){if((e17993 instanceof Object)){
var ex__16851__auto__ = e17993;
var statearr_17994_18043 = state_17936;
(statearr_17994_18043[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17936);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17993;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18044 = state_17936;
state_17936 = G__18044;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__16848__auto__ = function(state_17936){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__16848__auto____1.call(this,state_17936);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__16848__auto____0;
cljs$core$async$mix_$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__16848__auto____1;
return cljs$core$async$mix_$_state_machine__16848__auto__;
})()
;})(switch__16847__auto__,c__16937__auto___17996,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1))
})();
var state__16939__auto__ = (function (){var statearr_17995 = f__16938__auto__.call(null);
(statearr_17995[(6)] = c__16937__auto___17996);

return statearr_17995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(c__16937__auto___17996,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1))
);


return m__$1;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__9122__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,p,v,ch);
} else {
var m__9122__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__18046 = arguments.length;
switch (G__18046) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,p);
} else {
var m__9122__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,p,v);
} else {
var m__9122__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__18050 = arguments.length;
switch (G__18050) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__8388__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__8388__auto__,mults){
return (function (p1__18048_SHARP_){
if(cljs.core.truth_(p1__18048_SHARP_.call(null,topic))){
return p1__18048_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__18048_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__8388__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async18051 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18051 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta18052){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta18052 = meta18052;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18051.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_18053,meta18052__$1){
var self__ = this;
var _18053__$1 = this;
return (new cljs.core.async.t_cljs$core$async18051(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta18052__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18051.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_18053){
var self__ = this;
var _18053__$1 = this;
return self__.meta18052;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18051.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18051.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18051.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18051.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m__$1 = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m__$1,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18051.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m__$1 = temp__5457__auto__;
return cljs.core.async.untap.call(null,m__$1,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18051.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18051.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18051.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta18052","meta18052",1901799799,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18051.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18051.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18051";

cljs.core.async.t_cljs$core$async18051.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async18051");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async18051 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async18051(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18052){
return (new cljs.core.async.t_cljs$core$async18051(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18052));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async18051(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16937__auto___18171 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16937__auto___18171,mults,ensure_mult,p){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (c__16937__auto___18171,mults,ensure_mult,p){
return (function (state_18125){
var state_val_18126 = (state_18125[(1)]);
if((state_val_18126 === (7))){
var inst_18121 = (state_18125[(2)]);
var state_18125__$1 = state_18125;
var statearr_18127_18172 = state_18125__$1;
(statearr_18127_18172[(2)] = inst_18121);

(statearr_18127_18172[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (20))){
var state_18125__$1 = state_18125;
var statearr_18128_18173 = state_18125__$1;
(statearr_18128_18173[(2)] = null);

(statearr_18128_18173[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (1))){
var state_18125__$1 = state_18125;
var statearr_18129_18174 = state_18125__$1;
(statearr_18129_18174[(2)] = null);

(statearr_18129_18174[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (24))){
var inst_18104 = (state_18125[(7)]);
var inst_18113 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_18104);
var state_18125__$1 = state_18125;
var statearr_18130_18175 = state_18125__$1;
(statearr_18130_18175[(2)] = inst_18113);

(statearr_18130_18175[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (4))){
var inst_18056 = (state_18125[(8)]);
var inst_18056__$1 = (state_18125[(2)]);
var inst_18057 = (inst_18056__$1 == null);
var state_18125__$1 = (function (){var statearr_18131 = state_18125;
(statearr_18131[(8)] = inst_18056__$1);

return statearr_18131;
})();
if(cljs.core.truth_(inst_18057)){
var statearr_18132_18176 = state_18125__$1;
(statearr_18132_18176[(1)] = (5));

} else {
var statearr_18133_18177 = state_18125__$1;
(statearr_18133_18177[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (15))){
var inst_18098 = (state_18125[(2)]);
var state_18125__$1 = state_18125;
var statearr_18134_18178 = state_18125__$1;
(statearr_18134_18178[(2)] = inst_18098);

(statearr_18134_18178[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (21))){
var inst_18118 = (state_18125[(2)]);
var state_18125__$1 = (function (){var statearr_18135 = state_18125;
(statearr_18135[(9)] = inst_18118);

return statearr_18135;
})();
var statearr_18136_18179 = state_18125__$1;
(statearr_18136_18179[(2)] = null);

(statearr_18136_18179[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (13))){
var inst_18080 = (state_18125[(10)]);
var inst_18082 = cljs.core.chunked_seq_QMARK_.call(null,inst_18080);
var state_18125__$1 = state_18125;
if(inst_18082){
var statearr_18137_18180 = state_18125__$1;
(statearr_18137_18180[(1)] = (16));

} else {
var statearr_18138_18181 = state_18125__$1;
(statearr_18138_18181[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (22))){
var inst_18110 = (state_18125[(2)]);
var state_18125__$1 = state_18125;
if(cljs.core.truth_(inst_18110)){
var statearr_18139_18182 = state_18125__$1;
(statearr_18139_18182[(1)] = (23));

} else {
var statearr_18140_18183 = state_18125__$1;
(statearr_18140_18183[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (6))){
var inst_18106 = (state_18125[(11)]);
var inst_18104 = (state_18125[(7)]);
var inst_18056 = (state_18125[(8)]);
var inst_18104__$1 = topic_fn.call(null,inst_18056);
var inst_18105 = cljs.core.deref.call(null,mults);
var inst_18106__$1 = cljs.core.get.call(null,inst_18105,inst_18104__$1);
var state_18125__$1 = (function (){var statearr_18141 = state_18125;
(statearr_18141[(11)] = inst_18106__$1);

(statearr_18141[(7)] = inst_18104__$1);

return statearr_18141;
})();
if(cljs.core.truth_(inst_18106__$1)){
var statearr_18142_18184 = state_18125__$1;
(statearr_18142_18184[(1)] = (19));

} else {
var statearr_18143_18185 = state_18125__$1;
(statearr_18143_18185[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (25))){
var inst_18115 = (state_18125[(2)]);
var state_18125__$1 = state_18125;
var statearr_18144_18186 = state_18125__$1;
(statearr_18144_18186[(2)] = inst_18115);

(statearr_18144_18186[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (17))){
var inst_18080 = (state_18125[(10)]);
var inst_18089 = cljs.core.first.call(null,inst_18080);
var inst_18090 = cljs.core.async.muxch_STAR_.call(null,inst_18089);
var inst_18091 = cljs.core.async.close_BANG_.call(null,inst_18090);
var inst_18092 = cljs.core.next.call(null,inst_18080);
var inst_18066 = inst_18092;
var inst_18067 = null;
var inst_18068 = (0);
var inst_18069 = (0);
var state_18125__$1 = (function (){var statearr_18145 = state_18125;
(statearr_18145[(12)] = inst_18066);

(statearr_18145[(13)] = inst_18068);

(statearr_18145[(14)] = inst_18067);

(statearr_18145[(15)] = inst_18091);

(statearr_18145[(16)] = inst_18069);

return statearr_18145;
})();
var statearr_18146_18187 = state_18125__$1;
(statearr_18146_18187[(2)] = null);

(statearr_18146_18187[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (3))){
var inst_18123 = (state_18125[(2)]);
var state_18125__$1 = state_18125;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18125__$1,inst_18123);
} else {
if((state_val_18126 === (12))){
var inst_18100 = (state_18125[(2)]);
var state_18125__$1 = state_18125;
var statearr_18147_18188 = state_18125__$1;
(statearr_18147_18188[(2)] = inst_18100);

(statearr_18147_18188[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (2))){
var state_18125__$1 = state_18125;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18125__$1,(4),ch);
} else {
if((state_val_18126 === (23))){
var state_18125__$1 = state_18125;
var statearr_18148_18189 = state_18125__$1;
(statearr_18148_18189[(2)] = null);

(statearr_18148_18189[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (19))){
var inst_18106 = (state_18125[(11)]);
var inst_18056 = (state_18125[(8)]);
var inst_18108 = cljs.core.async.muxch_STAR_.call(null,inst_18106);
var state_18125__$1 = state_18125;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18125__$1,(22),inst_18108,inst_18056);
} else {
if((state_val_18126 === (11))){
var inst_18066 = (state_18125[(12)]);
var inst_18080 = (state_18125[(10)]);
var inst_18080__$1 = cljs.core.seq.call(null,inst_18066);
var state_18125__$1 = (function (){var statearr_18149 = state_18125;
(statearr_18149[(10)] = inst_18080__$1);

return statearr_18149;
})();
if(inst_18080__$1){
var statearr_18150_18190 = state_18125__$1;
(statearr_18150_18190[(1)] = (13));

} else {
var statearr_18151_18191 = state_18125__$1;
(statearr_18151_18191[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (9))){
var inst_18102 = (state_18125[(2)]);
var state_18125__$1 = state_18125;
var statearr_18152_18192 = state_18125__$1;
(statearr_18152_18192[(2)] = inst_18102);

(statearr_18152_18192[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (5))){
var inst_18063 = cljs.core.deref.call(null,mults);
var inst_18064 = cljs.core.vals.call(null,inst_18063);
var inst_18065 = cljs.core.seq.call(null,inst_18064);
var inst_18066 = inst_18065;
var inst_18067 = null;
var inst_18068 = (0);
var inst_18069 = (0);
var state_18125__$1 = (function (){var statearr_18153 = state_18125;
(statearr_18153[(12)] = inst_18066);

(statearr_18153[(13)] = inst_18068);

(statearr_18153[(14)] = inst_18067);

(statearr_18153[(16)] = inst_18069);

return statearr_18153;
})();
var statearr_18154_18193 = state_18125__$1;
(statearr_18154_18193[(2)] = null);

(statearr_18154_18193[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (14))){
var state_18125__$1 = state_18125;
var statearr_18158_18194 = state_18125__$1;
(statearr_18158_18194[(2)] = null);

(statearr_18158_18194[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (16))){
var inst_18080 = (state_18125[(10)]);
var inst_18084 = cljs.core.chunk_first.call(null,inst_18080);
var inst_18085 = cljs.core.chunk_rest.call(null,inst_18080);
var inst_18086 = cljs.core.count.call(null,inst_18084);
var inst_18066 = inst_18085;
var inst_18067 = inst_18084;
var inst_18068 = inst_18086;
var inst_18069 = (0);
var state_18125__$1 = (function (){var statearr_18159 = state_18125;
(statearr_18159[(12)] = inst_18066);

(statearr_18159[(13)] = inst_18068);

(statearr_18159[(14)] = inst_18067);

(statearr_18159[(16)] = inst_18069);

return statearr_18159;
})();
var statearr_18160_18195 = state_18125__$1;
(statearr_18160_18195[(2)] = null);

(statearr_18160_18195[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (10))){
var inst_18066 = (state_18125[(12)]);
var inst_18068 = (state_18125[(13)]);
var inst_18067 = (state_18125[(14)]);
var inst_18069 = (state_18125[(16)]);
var inst_18074 = cljs.core._nth.call(null,inst_18067,inst_18069);
var inst_18075 = cljs.core.async.muxch_STAR_.call(null,inst_18074);
var inst_18076 = cljs.core.async.close_BANG_.call(null,inst_18075);
var inst_18077 = (inst_18069 + (1));
var tmp18155 = inst_18066;
var tmp18156 = inst_18068;
var tmp18157 = inst_18067;
var inst_18066__$1 = tmp18155;
var inst_18067__$1 = tmp18157;
var inst_18068__$1 = tmp18156;
var inst_18069__$1 = inst_18077;
var state_18125__$1 = (function (){var statearr_18161 = state_18125;
(statearr_18161[(12)] = inst_18066__$1);

(statearr_18161[(13)] = inst_18068__$1);

(statearr_18161[(17)] = inst_18076);

(statearr_18161[(14)] = inst_18067__$1);

(statearr_18161[(16)] = inst_18069__$1);

return statearr_18161;
})();
var statearr_18162_18196 = state_18125__$1;
(statearr_18162_18196[(2)] = null);

(statearr_18162_18196[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (18))){
var inst_18095 = (state_18125[(2)]);
var state_18125__$1 = state_18125;
var statearr_18163_18197 = state_18125__$1;
(statearr_18163_18197[(2)] = inst_18095);

(statearr_18163_18197[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18126 === (8))){
var inst_18068 = (state_18125[(13)]);
var inst_18069 = (state_18125[(16)]);
var inst_18071 = (inst_18069 < inst_18068);
var inst_18072 = inst_18071;
var state_18125__$1 = state_18125;
if(cljs.core.truth_(inst_18072)){
var statearr_18164_18198 = state_18125__$1;
(statearr_18164_18198[(1)] = (10));

} else {
var statearr_18165_18199 = state_18125__$1;
(statearr_18165_18199[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16937__auto___18171,mults,ensure_mult,p))
;
return ((function (switch__16847__auto__,c__16937__auto___18171,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__16848__auto__ = null;
var cljs$core$async$state_machine__16848__auto____0 = (function (){
var statearr_18166 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18166[(0)] = cljs$core$async$state_machine__16848__auto__);

(statearr_18166[(1)] = (1));

return statearr_18166;
});
var cljs$core$async$state_machine__16848__auto____1 = (function (state_18125){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_18125);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e18167){if((e18167 instanceof Object)){
var ex__16851__auto__ = e18167;
var statearr_18168_18200 = state_18125;
(statearr_18168_18200[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18125);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18167;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18201 = state_18125;
state_18125 = G__18201;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$state_machine__16848__auto__ = function(state_18125){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16848__auto____1.call(this,state_18125);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16848__auto____0;
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16848__auto____1;
return cljs$core$async$state_machine__16848__auto__;
})()
;})(switch__16847__auto__,c__16937__auto___18171,mults,ensure_mult,p))
})();
var state__16939__auto__ = (function (){var statearr_18169 = f__16938__auto__.call(null);
(statearr_18169[(6)] = c__16937__auto___18171);

return statearr_18169;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(c__16937__auto___18171,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__18203 = arguments.length;
switch (G__18203) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__18206 = arguments.length;
switch (G__18206) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__18209 = arguments.length;
switch (G__18209) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__16937__auto___18276 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16937__auto___18276,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (c__16937__auto___18276,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_18248){
var state_val_18249 = (state_18248[(1)]);
if((state_val_18249 === (7))){
var state_18248__$1 = state_18248;
var statearr_18250_18277 = state_18248__$1;
(statearr_18250_18277[(2)] = null);

(statearr_18250_18277[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18249 === (1))){
var state_18248__$1 = state_18248;
var statearr_18251_18278 = state_18248__$1;
(statearr_18251_18278[(2)] = null);

(statearr_18251_18278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18249 === (4))){
var inst_18212 = (state_18248[(7)]);
var inst_18214 = (inst_18212 < cnt);
var state_18248__$1 = state_18248;
if(cljs.core.truth_(inst_18214)){
var statearr_18252_18279 = state_18248__$1;
(statearr_18252_18279[(1)] = (6));

} else {
var statearr_18253_18280 = state_18248__$1;
(statearr_18253_18280[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18249 === (15))){
var inst_18244 = (state_18248[(2)]);
var state_18248__$1 = state_18248;
var statearr_18254_18281 = state_18248__$1;
(statearr_18254_18281[(2)] = inst_18244);

(statearr_18254_18281[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18249 === (13))){
var inst_18237 = cljs.core.async.close_BANG_.call(null,out);
var state_18248__$1 = state_18248;
var statearr_18255_18282 = state_18248__$1;
(statearr_18255_18282[(2)] = inst_18237);

(statearr_18255_18282[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18249 === (6))){
var state_18248__$1 = state_18248;
var statearr_18256_18283 = state_18248__$1;
(statearr_18256_18283[(2)] = null);

(statearr_18256_18283[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18249 === (3))){
var inst_18246 = (state_18248[(2)]);
var state_18248__$1 = state_18248;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18248__$1,inst_18246);
} else {
if((state_val_18249 === (12))){
var inst_18234 = (state_18248[(8)]);
var inst_18234__$1 = (state_18248[(2)]);
var inst_18235 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_18234__$1);
var state_18248__$1 = (function (){var statearr_18257 = state_18248;
(statearr_18257[(8)] = inst_18234__$1);

return statearr_18257;
})();
if(cljs.core.truth_(inst_18235)){
var statearr_18258_18284 = state_18248__$1;
(statearr_18258_18284[(1)] = (13));

} else {
var statearr_18259_18285 = state_18248__$1;
(statearr_18259_18285[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18249 === (2))){
var inst_18211 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_18212 = (0);
var state_18248__$1 = (function (){var statearr_18260 = state_18248;
(statearr_18260[(9)] = inst_18211);

(statearr_18260[(7)] = inst_18212);

return statearr_18260;
})();
var statearr_18261_18286 = state_18248__$1;
(statearr_18261_18286[(2)] = null);

(statearr_18261_18286[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18249 === (11))){
var inst_18212 = (state_18248[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_18248,(10),Object,null,(9));
var inst_18221 = chs__$1.call(null,inst_18212);
var inst_18222 = done.call(null,inst_18212);
var inst_18223 = cljs.core.async.take_BANG_.call(null,inst_18221,inst_18222);
var state_18248__$1 = state_18248;
var statearr_18262_18287 = state_18248__$1;
(statearr_18262_18287[(2)] = inst_18223);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18248__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18249 === (9))){
var inst_18212 = (state_18248[(7)]);
var inst_18225 = (state_18248[(2)]);
var inst_18226 = (inst_18212 + (1));
var inst_18212__$1 = inst_18226;
var state_18248__$1 = (function (){var statearr_18263 = state_18248;
(statearr_18263[(7)] = inst_18212__$1);

(statearr_18263[(10)] = inst_18225);

return statearr_18263;
})();
var statearr_18264_18288 = state_18248__$1;
(statearr_18264_18288[(2)] = null);

(statearr_18264_18288[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18249 === (5))){
var inst_18232 = (state_18248[(2)]);
var state_18248__$1 = (function (){var statearr_18265 = state_18248;
(statearr_18265[(11)] = inst_18232);

return statearr_18265;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18248__$1,(12),dchan);
} else {
if((state_val_18249 === (14))){
var inst_18234 = (state_18248[(8)]);
var inst_18239 = cljs.core.apply.call(null,f,inst_18234);
var state_18248__$1 = state_18248;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18248__$1,(16),out,inst_18239);
} else {
if((state_val_18249 === (16))){
var inst_18241 = (state_18248[(2)]);
var state_18248__$1 = (function (){var statearr_18266 = state_18248;
(statearr_18266[(12)] = inst_18241);

return statearr_18266;
})();
var statearr_18267_18289 = state_18248__$1;
(statearr_18267_18289[(2)] = null);

(statearr_18267_18289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18249 === (10))){
var inst_18216 = (state_18248[(2)]);
var inst_18217 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_18248__$1 = (function (){var statearr_18268 = state_18248;
(statearr_18268[(13)] = inst_18216);

return statearr_18268;
})();
var statearr_18269_18290 = state_18248__$1;
(statearr_18269_18290[(2)] = inst_18217);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18248__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18249 === (8))){
var inst_18230 = (state_18248[(2)]);
var state_18248__$1 = state_18248;
var statearr_18270_18291 = state_18248__$1;
(statearr_18270_18291[(2)] = inst_18230);

(statearr_18270_18291[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16937__auto___18276,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__16847__auto__,c__16937__auto___18276,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__16848__auto__ = null;
var cljs$core$async$state_machine__16848__auto____0 = (function (){
var statearr_18271 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18271[(0)] = cljs$core$async$state_machine__16848__auto__);

(statearr_18271[(1)] = (1));

return statearr_18271;
});
var cljs$core$async$state_machine__16848__auto____1 = (function (state_18248){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_18248);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e18272){if((e18272 instanceof Object)){
var ex__16851__auto__ = e18272;
var statearr_18273_18292 = state_18248;
(statearr_18273_18292[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18248);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18272;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18293 = state_18248;
state_18248 = G__18293;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$state_machine__16848__auto__ = function(state_18248){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16848__auto____1.call(this,state_18248);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16848__auto____0;
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16848__auto____1;
return cljs$core$async$state_machine__16848__auto__;
})()
;})(switch__16847__auto__,c__16937__auto___18276,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__16939__auto__ = (function (){var statearr_18274 = f__16938__auto__.call(null);
(statearr_18274[(6)] = c__16937__auto___18276);

return statearr_18274;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(c__16937__auto___18276,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__18296 = arguments.length;
switch (G__18296) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16937__auto___18350 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16937__auto___18350,out){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (c__16937__auto___18350,out){
return (function (state_18328){
var state_val_18329 = (state_18328[(1)]);
if((state_val_18329 === (7))){
var inst_18308 = (state_18328[(7)]);
var inst_18307 = (state_18328[(8)]);
var inst_18307__$1 = (state_18328[(2)]);
var inst_18308__$1 = cljs.core.nth.call(null,inst_18307__$1,(0),null);
var inst_18309 = cljs.core.nth.call(null,inst_18307__$1,(1),null);
var inst_18310 = (inst_18308__$1 == null);
var state_18328__$1 = (function (){var statearr_18330 = state_18328;
(statearr_18330[(7)] = inst_18308__$1);

(statearr_18330[(9)] = inst_18309);

(statearr_18330[(8)] = inst_18307__$1);

return statearr_18330;
})();
if(cljs.core.truth_(inst_18310)){
var statearr_18331_18351 = state_18328__$1;
(statearr_18331_18351[(1)] = (8));

} else {
var statearr_18332_18352 = state_18328__$1;
(statearr_18332_18352[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18329 === (1))){
var inst_18297 = cljs.core.vec.call(null,chs);
var inst_18298 = inst_18297;
var state_18328__$1 = (function (){var statearr_18333 = state_18328;
(statearr_18333[(10)] = inst_18298);

return statearr_18333;
})();
var statearr_18334_18353 = state_18328__$1;
(statearr_18334_18353[(2)] = null);

(statearr_18334_18353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18329 === (4))){
var inst_18298 = (state_18328[(10)]);
var state_18328__$1 = state_18328;
return cljs.core.async.ioc_alts_BANG_.call(null,state_18328__$1,(7),inst_18298);
} else {
if((state_val_18329 === (6))){
var inst_18324 = (state_18328[(2)]);
var state_18328__$1 = state_18328;
var statearr_18335_18354 = state_18328__$1;
(statearr_18335_18354[(2)] = inst_18324);

(statearr_18335_18354[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18329 === (3))){
var inst_18326 = (state_18328[(2)]);
var state_18328__$1 = state_18328;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18328__$1,inst_18326);
} else {
if((state_val_18329 === (2))){
var inst_18298 = (state_18328[(10)]);
var inst_18300 = cljs.core.count.call(null,inst_18298);
var inst_18301 = (inst_18300 > (0));
var state_18328__$1 = state_18328;
if(cljs.core.truth_(inst_18301)){
var statearr_18337_18355 = state_18328__$1;
(statearr_18337_18355[(1)] = (4));

} else {
var statearr_18338_18356 = state_18328__$1;
(statearr_18338_18356[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18329 === (11))){
var inst_18298 = (state_18328[(10)]);
var inst_18317 = (state_18328[(2)]);
var tmp18336 = inst_18298;
var inst_18298__$1 = tmp18336;
var state_18328__$1 = (function (){var statearr_18339 = state_18328;
(statearr_18339[(10)] = inst_18298__$1);

(statearr_18339[(11)] = inst_18317);

return statearr_18339;
})();
var statearr_18340_18357 = state_18328__$1;
(statearr_18340_18357[(2)] = null);

(statearr_18340_18357[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18329 === (9))){
var inst_18308 = (state_18328[(7)]);
var state_18328__$1 = state_18328;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18328__$1,(11),out,inst_18308);
} else {
if((state_val_18329 === (5))){
var inst_18322 = cljs.core.async.close_BANG_.call(null,out);
var state_18328__$1 = state_18328;
var statearr_18341_18358 = state_18328__$1;
(statearr_18341_18358[(2)] = inst_18322);

(statearr_18341_18358[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18329 === (10))){
var inst_18320 = (state_18328[(2)]);
var state_18328__$1 = state_18328;
var statearr_18342_18359 = state_18328__$1;
(statearr_18342_18359[(2)] = inst_18320);

(statearr_18342_18359[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18329 === (8))){
var inst_18298 = (state_18328[(10)]);
var inst_18308 = (state_18328[(7)]);
var inst_18309 = (state_18328[(9)]);
var inst_18307 = (state_18328[(8)]);
var inst_18312 = (function (){var cs = inst_18298;
var vec__18303 = inst_18307;
var v = inst_18308;
var c = inst_18309;
return ((function (cs,vec__18303,v,c,inst_18298,inst_18308,inst_18309,inst_18307,state_val_18329,c__16937__auto___18350,out){
return (function (p1__18294_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__18294_SHARP_);
});
;})(cs,vec__18303,v,c,inst_18298,inst_18308,inst_18309,inst_18307,state_val_18329,c__16937__auto___18350,out))
})();
var inst_18313 = cljs.core.filterv.call(null,inst_18312,inst_18298);
var inst_18298__$1 = inst_18313;
var state_18328__$1 = (function (){var statearr_18343 = state_18328;
(statearr_18343[(10)] = inst_18298__$1);

return statearr_18343;
})();
var statearr_18344_18360 = state_18328__$1;
(statearr_18344_18360[(2)] = null);

(statearr_18344_18360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16937__auto___18350,out))
;
return ((function (switch__16847__auto__,c__16937__auto___18350,out){
return (function() {
var cljs$core$async$state_machine__16848__auto__ = null;
var cljs$core$async$state_machine__16848__auto____0 = (function (){
var statearr_18345 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18345[(0)] = cljs$core$async$state_machine__16848__auto__);

(statearr_18345[(1)] = (1));

return statearr_18345;
});
var cljs$core$async$state_machine__16848__auto____1 = (function (state_18328){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_18328);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e18346){if((e18346 instanceof Object)){
var ex__16851__auto__ = e18346;
var statearr_18347_18361 = state_18328;
(statearr_18347_18361[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18328);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18346;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18362 = state_18328;
state_18328 = G__18362;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$state_machine__16848__auto__ = function(state_18328){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16848__auto____1.call(this,state_18328);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16848__auto____0;
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16848__auto____1;
return cljs$core$async$state_machine__16848__auto__;
})()
;})(switch__16847__auto__,c__16937__auto___18350,out))
})();
var state__16939__auto__ = (function (){var statearr_18348 = f__16938__auto__.call(null);
(statearr_18348[(6)] = c__16937__auto___18350);

return statearr_18348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(c__16937__auto___18350,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__18364 = arguments.length;
switch (G__18364) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16937__auto___18409 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16937__auto___18409,out){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (c__16937__auto___18409,out){
return (function (state_18388){
var state_val_18389 = (state_18388[(1)]);
if((state_val_18389 === (7))){
var inst_18370 = (state_18388[(7)]);
var inst_18370__$1 = (state_18388[(2)]);
var inst_18371 = (inst_18370__$1 == null);
var inst_18372 = cljs.core.not.call(null,inst_18371);
var state_18388__$1 = (function (){var statearr_18390 = state_18388;
(statearr_18390[(7)] = inst_18370__$1);

return statearr_18390;
})();
if(inst_18372){
var statearr_18391_18410 = state_18388__$1;
(statearr_18391_18410[(1)] = (8));

} else {
var statearr_18392_18411 = state_18388__$1;
(statearr_18392_18411[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18389 === (1))){
var inst_18365 = (0);
var state_18388__$1 = (function (){var statearr_18393 = state_18388;
(statearr_18393[(8)] = inst_18365);

return statearr_18393;
})();
var statearr_18394_18412 = state_18388__$1;
(statearr_18394_18412[(2)] = null);

(statearr_18394_18412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18389 === (4))){
var state_18388__$1 = state_18388;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18388__$1,(7),ch);
} else {
if((state_val_18389 === (6))){
var inst_18383 = (state_18388[(2)]);
var state_18388__$1 = state_18388;
var statearr_18395_18413 = state_18388__$1;
(statearr_18395_18413[(2)] = inst_18383);

(statearr_18395_18413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18389 === (3))){
var inst_18385 = (state_18388[(2)]);
var inst_18386 = cljs.core.async.close_BANG_.call(null,out);
var state_18388__$1 = (function (){var statearr_18396 = state_18388;
(statearr_18396[(9)] = inst_18385);

return statearr_18396;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18388__$1,inst_18386);
} else {
if((state_val_18389 === (2))){
var inst_18365 = (state_18388[(8)]);
var inst_18367 = (inst_18365 < n);
var state_18388__$1 = state_18388;
if(cljs.core.truth_(inst_18367)){
var statearr_18397_18414 = state_18388__$1;
(statearr_18397_18414[(1)] = (4));

} else {
var statearr_18398_18415 = state_18388__$1;
(statearr_18398_18415[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18389 === (11))){
var inst_18365 = (state_18388[(8)]);
var inst_18375 = (state_18388[(2)]);
var inst_18376 = (inst_18365 + (1));
var inst_18365__$1 = inst_18376;
var state_18388__$1 = (function (){var statearr_18399 = state_18388;
(statearr_18399[(8)] = inst_18365__$1);

(statearr_18399[(10)] = inst_18375);

return statearr_18399;
})();
var statearr_18400_18416 = state_18388__$1;
(statearr_18400_18416[(2)] = null);

(statearr_18400_18416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18389 === (9))){
var state_18388__$1 = state_18388;
var statearr_18401_18417 = state_18388__$1;
(statearr_18401_18417[(2)] = null);

(statearr_18401_18417[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18389 === (5))){
var state_18388__$1 = state_18388;
var statearr_18402_18418 = state_18388__$1;
(statearr_18402_18418[(2)] = null);

(statearr_18402_18418[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18389 === (10))){
var inst_18380 = (state_18388[(2)]);
var state_18388__$1 = state_18388;
var statearr_18403_18419 = state_18388__$1;
(statearr_18403_18419[(2)] = inst_18380);

(statearr_18403_18419[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18389 === (8))){
var inst_18370 = (state_18388[(7)]);
var state_18388__$1 = state_18388;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18388__$1,(11),out,inst_18370);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16937__auto___18409,out))
;
return ((function (switch__16847__auto__,c__16937__auto___18409,out){
return (function() {
var cljs$core$async$state_machine__16848__auto__ = null;
var cljs$core$async$state_machine__16848__auto____0 = (function (){
var statearr_18404 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18404[(0)] = cljs$core$async$state_machine__16848__auto__);

(statearr_18404[(1)] = (1));

return statearr_18404;
});
var cljs$core$async$state_machine__16848__auto____1 = (function (state_18388){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_18388);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e18405){if((e18405 instanceof Object)){
var ex__16851__auto__ = e18405;
var statearr_18406_18420 = state_18388;
(statearr_18406_18420[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18388);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18405;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18421 = state_18388;
state_18388 = G__18421;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$state_machine__16848__auto__ = function(state_18388){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16848__auto____1.call(this,state_18388);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16848__auto____0;
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16848__auto____1;
return cljs$core$async$state_machine__16848__auto__;
})()
;})(switch__16847__auto__,c__16937__auto___18409,out))
})();
var state__16939__auto__ = (function (){var statearr_18407 = f__16938__auto__.call(null);
(statearr_18407[(6)] = c__16937__auto___18409);

return statearr_18407;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(c__16937__auto___18409,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async18423 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18423 = (function (f,ch,meta18424){
this.f = f;
this.ch = ch;
this.meta18424 = meta18424;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18423.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18425,meta18424__$1){
var self__ = this;
var _18425__$1 = this;
return (new cljs.core.async.t_cljs$core$async18423(self__.f,self__.ch,meta18424__$1));
});

cljs.core.async.t_cljs$core$async18423.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18425){
var self__ = this;
var _18425__$1 = this;
return self__.meta18424;
});

cljs.core.async.t_cljs$core$async18423.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18423.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async18423.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async18423.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18423.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async18426 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18426 = (function (f,ch,meta18424,_,fn1,meta18427){
this.f = f;
this.ch = ch;
this.meta18424 = meta18424;
this._ = _;
this.fn1 = fn1;
this.meta18427 = meta18427;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18426.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_18428,meta18427__$1){
var self__ = this;
var _18428__$1 = this;
return (new cljs.core.async.t_cljs$core$async18426(self__.f,self__.ch,self__.meta18424,self__._,self__.fn1,meta18427__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async18426.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_18428){
var self__ = this;
var _18428__$1 = this;
return self__.meta18427;
});})(___$1))
;

cljs.core.async.t_cljs$core$async18426.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18426.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async18426.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async18426.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__18422_SHARP_){
return f1.call(null,(((p1__18422_SHARP_ == null))?null:self__.f.call(null,p1__18422_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async18426.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta18424","meta18424",-461057077,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async18423","cljs.core.async/t_cljs$core$async18423",-388031721,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta18427","meta18427",1591368758,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async18426.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18426.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18426";

cljs.core.async.t_cljs$core$async18426.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async18426");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async18426 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18426(f__$1,ch__$1,meta18424__$1,___$2,fn1__$1,meta18427){
return (new cljs.core.async.t_cljs$core$async18426(f__$1,ch__$1,meta18424__$1,___$2,fn1__$1,meta18427));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async18426(self__.f,self__.ch,self__.meta18424,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__8376__auto__ = ret;
if(cljs.core.truth_(and__8376__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__8376__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async18423.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18423.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async18423.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta18424","meta18424",-461057077,null)], null);
});

cljs.core.async.t_cljs$core$async18423.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18423.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18423";

cljs.core.async.t_cljs$core$async18423.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async18423");
});

cljs.core.async.__GT_t_cljs$core$async18423 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18423(f__$1,ch__$1,meta18424){
return (new cljs.core.async.t_cljs$core$async18423(f__$1,ch__$1,meta18424));
});

}

return (new cljs.core.async.t_cljs$core$async18423(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async18429 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18429 = (function (f,ch,meta18430){
this.f = f;
this.ch = ch;
this.meta18430 = meta18430;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18429.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18431,meta18430__$1){
var self__ = this;
var _18431__$1 = this;
return (new cljs.core.async.t_cljs$core$async18429(self__.f,self__.ch,meta18430__$1));
});

cljs.core.async.t_cljs$core$async18429.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18431){
var self__ = this;
var _18431__$1 = this;
return self__.meta18430;
});

cljs.core.async.t_cljs$core$async18429.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18429.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async18429.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18429.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async18429.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18429.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async18429.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta18430","meta18430",259142862,null)], null);
});

cljs.core.async.t_cljs$core$async18429.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18429.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18429";

cljs.core.async.t_cljs$core$async18429.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async18429");
});

cljs.core.async.__GT_t_cljs$core$async18429 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async18429(f__$1,ch__$1,meta18430){
return (new cljs.core.async.t_cljs$core$async18429(f__$1,ch__$1,meta18430));
});

}

return (new cljs.core.async.t_cljs$core$async18429(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async18432 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18432 = (function (p,ch,meta18433){
this.p = p;
this.ch = ch;
this.meta18433 = meta18433;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18432.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18434,meta18433__$1){
var self__ = this;
var _18434__$1 = this;
return (new cljs.core.async.t_cljs$core$async18432(self__.p,self__.ch,meta18433__$1));
});

cljs.core.async.t_cljs$core$async18432.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18434){
var self__ = this;
var _18434__$1 = this;
return self__.meta18433;
});

cljs.core.async.t_cljs$core$async18432.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18432.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async18432.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async18432.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18432.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async18432.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18432.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async18432.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta18433","meta18433",1777587574,null)], null);
});

cljs.core.async.t_cljs$core$async18432.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18432.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18432";

cljs.core.async.t_cljs$core$async18432.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async18432");
});

cljs.core.async.__GT_t_cljs$core$async18432 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async18432(p__$1,ch__$1,meta18433){
return (new cljs.core.async.t_cljs$core$async18432(p__$1,ch__$1,meta18433));
});

}

return (new cljs.core.async.t_cljs$core$async18432(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__18436 = arguments.length;
switch (G__18436) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16937__auto___18476 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16937__auto___18476,out){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (c__16937__auto___18476,out){
return (function (state_18457){
var state_val_18458 = (state_18457[(1)]);
if((state_val_18458 === (7))){
var inst_18453 = (state_18457[(2)]);
var state_18457__$1 = state_18457;
var statearr_18459_18477 = state_18457__$1;
(statearr_18459_18477[(2)] = inst_18453);

(statearr_18459_18477[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18458 === (1))){
var state_18457__$1 = state_18457;
var statearr_18460_18478 = state_18457__$1;
(statearr_18460_18478[(2)] = null);

(statearr_18460_18478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18458 === (4))){
var inst_18439 = (state_18457[(7)]);
var inst_18439__$1 = (state_18457[(2)]);
var inst_18440 = (inst_18439__$1 == null);
var state_18457__$1 = (function (){var statearr_18461 = state_18457;
(statearr_18461[(7)] = inst_18439__$1);

return statearr_18461;
})();
if(cljs.core.truth_(inst_18440)){
var statearr_18462_18479 = state_18457__$1;
(statearr_18462_18479[(1)] = (5));

} else {
var statearr_18463_18480 = state_18457__$1;
(statearr_18463_18480[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18458 === (6))){
var inst_18439 = (state_18457[(7)]);
var inst_18444 = p.call(null,inst_18439);
var state_18457__$1 = state_18457;
if(cljs.core.truth_(inst_18444)){
var statearr_18464_18481 = state_18457__$1;
(statearr_18464_18481[(1)] = (8));

} else {
var statearr_18465_18482 = state_18457__$1;
(statearr_18465_18482[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18458 === (3))){
var inst_18455 = (state_18457[(2)]);
var state_18457__$1 = state_18457;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18457__$1,inst_18455);
} else {
if((state_val_18458 === (2))){
var state_18457__$1 = state_18457;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18457__$1,(4),ch);
} else {
if((state_val_18458 === (11))){
var inst_18447 = (state_18457[(2)]);
var state_18457__$1 = state_18457;
var statearr_18466_18483 = state_18457__$1;
(statearr_18466_18483[(2)] = inst_18447);

(statearr_18466_18483[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18458 === (9))){
var state_18457__$1 = state_18457;
var statearr_18467_18484 = state_18457__$1;
(statearr_18467_18484[(2)] = null);

(statearr_18467_18484[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18458 === (5))){
var inst_18442 = cljs.core.async.close_BANG_.call(null,out);
var state_18457__$1 = state_18457;
var statearr_18468_18485 = state_18457__$1;
(statearr_18468_18485[(2)] = inst_18442);

(statearr_18468_18485[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18458 === (10))){
var inst_18450 = (state_18457[(2)]);
var state_18457__$1 = (function (){var statearr_18469 = state_18457;
(statearr_18469[(8)] = inst_18450);

return statearr_18469;
})();
var statearr_18470_18486 = state_18457__$1;
(statearr_18470_18486[(2)] = null);

(statearr_18470_18486[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18458 === (8))){
var inst_18439 = (state_18457[(7)]);
var state_18457__$1 = state_18457;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18457__$1,(11),out,inst_18439);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16937__auto___18476,out))
;
return ((function (switch__16847__auto__,c__16937__auto___18476,out){
return (function() {
var cljs$core$async$state_machine__16848__auto__ = null;
var cljs$core$async$state_machine__16848__auto____0 = (function (){
var statearr_18471 = [null,null,null,null,null,null,null,null,null];
(statearr_18471[(0)] = cljs$core$async$state_machine__16848__auto__);

(statearr_18471[(1)] = (1));

return statearr_18471;
});
var cljs$core$async$state_machine__16848__auto____1 = (function (state_18457){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_18457);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e18472){if((e18472 instanceof Object)){
var ex__16851__auto__ = e18472;
var statearr_18473_18487 = state_18457;
(statearr_18473_18487[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18457);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18472;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18488 = state_18457;
state_18457 = G__18488;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$state_machine__16848__auto__ = function(state_18457){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16848__auto____1.call(this,state_18457);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16848__auto____0;
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16848__auto____1;
return cljs$core$async$state_machine__16848__auto__;
})()
;})(switch__16847__auto__,c__16937__auto___18476,out))
})();
var state__16939__auto__ = (function (){var statearr_18474 = f__16938__auto__.call(null);
(statearr_18474[(6)] = c__16937__auto___18476);

return statearr_18474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(c__16937__auto___18476,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__18490 = arguments.length;
switch (G__18490) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__16937__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16937__auto__){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (c__16937__auto__){
return (function (state_18553){
var state_val_18554 = (state_18553[(1)]);
if((state_val_18554 === (7))){
var inst_18549 = (state_18553[(2)]);
var state_18553__$1 = state_18553;
var statearr_18555_18593 = state_18553__$1;
(statearr_18555_18593[(2)] = inst_18549);

(statearr_18555_18593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18554 === (20))){
var inst_18519 = (state_18553[(7)]);
var inst_18530 = (state_18553[(2)]);
var inst_18531 = cljs.core.next.call(null,inst_18519);
var inst_18505 = inst_18531;
var inst_18506 = null;
var inst_18507 = (0);
var inst_18508 = (0);
var state_18553__$1 = (function (){var statearr_18556 = state_18553;
(statearr_18556[(8)] = inst_18530);

(statearr_18556[(9)] = inst_18506);

(statearr_18556[(10)] = inst_18507);

(statearr_18556[(11)] = inst_18505);

(statearr_18556[(12)] = inst_18508);

return statearr_18556;
})();
var statearr_18557_18594 = state_18553__$1;
(statearr_18557_18594[(2)] = null);

(statearr_18557_18594[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18554 === (1))){
var state_18553__$1 = state_18553;
var statearr_18558_18595 = state_18553__$1;
(statearr_18558_18595[(2)] = null);

(statearr_18558_18595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18554 === (4))){
var inst_18494 = (state_18553[(13)]);
var inst_18494__$1 = (state_18553[(2)]);
var inst_18495 = (inst_18494__$1 == null);
var state_18553__$1 = (function (){var statearr_18559 = state_18553;
(statearr_18559[(13)] = inst_18494__$1);

return statearr_18559;
})();
if(cljs.core.truth_(inst_18495)){
var statearr_18560_18596 = state_18553__$1;
(statearr_18560_18596[(1)] = (5));

} else {
var statearr_18561_18597 = state_18553__$1;
(statearr_18561_18597[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18554 === (15))){
var state_18553__$1 = state_18553;
var statearr_18565_18598 = state_18553__$1;
(statearr_18565_18598[(2)] = null);

(statearr_18565_18598[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18554 === (21))){
var state_18553__$1 = state_18553;
var statearr_18566_18599 = state_18553__$1;
(statearr_18566_18599[(2)] = null);

(statearr_18566_18599[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18554 === (13))){
var inst_18506 = (state_18553[(9)]);
var inst_18507 = (state_18553[(10)]);
var inst_18505 = (state_18553[(11)]);
var inst_18508 = (state_18553[(12)]);
var inst_18515 = (state_18553[(2)]);
var inst_18516 = (inst_18508 + (1));
var tmp18562 = inst_18506;
var tmp18563 = inst_18507;
var tmp18564 = inst_18505;
var inst_18505__$1 = tmp18564;
var inst_18506__$1 = tmp18562;
var inst_18507__$1 = tmp18563;
var inst_18508__$1 = inst_18516;
var state_18553__$1 = (function (){var statearr_18567 = state_18553;
(statearr_18567[(9)] = inst_18506__$1);

(statearr_18567[(10)] = inst_18507__$1);

(statearr_18567[(11)] = inst_18505__$1);

(statearr_18567[(12)] = inst_18508__$1);

(statearr_18567[(14)] = inst_18515);

return statearr_18567;
})();
var statearr_18568_18600 = state_18553__$1;
(statearr_18568_18600[(2)] = null);

(statearr_18568_18600[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18554 === (22))){
var state_18553__$1 = state_18553;
var statearr_18569_18601 = state_18553__$1;
(statearr_18569_18601[(2)] = null);

(statearr_18569_18601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18554 === (6))){
var inst_18494 = (state_18553[(13)]);
var inst_18503 = f.call(null,inst_18494);
var inst_18504 = cljs.core.seq.call(null,inst_18503);
var inst_18505 = inst_18504;
var inst_18506 = null;
var inst_18507 = (0);
var inst_18508 = (0);
var state_18553__$1 = (function (){var statearr_18570 = state_18553;
(statearr_18570[(9)] = inst_18506);

(statearr_18570[(10)] = inst_18507);

(statearr_18570[(11)] = inst_18505);

(statearr_18570[(12)] = inst_18508);

return statearr_18570;
})();
var statearr_18571_18602 = state_18553__$1;
(statearr_18571_18602[(2)] = null);

(statearr_18571_18602[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18554 === (17))){
var inst_18519 = (state_18553[(7)]);
var inst_18523 = cljs.core.chunk_first.call(null,inst_18519);
var inst_18524 = cljs.core.chunk_rest.call(null,inst_18519);
var inst_18525 = cljs.core.count.call(null,inst_18523);
var inst_18505 = inst_18524;
var inst_18506 = inst_18523;
var inst_18507 = inst_18525;
var inst_18508 = (0);
var state_18553__$1 = (function (){var statearr_18572 = state_18553;
(statearr_18572[(9)] = inst_18506);

(statearr_18572[(10)] = inst_18507);

(statearr_18572[(11)] = inst_18505);

(statearr_18572[(12)] = inst_18508);

return statearr_18572;
})();
var statearr_18573_18603 = state_18553__$1;
(statearr_18573_18603[(2)] = null);

(statearr_18573_18603[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18554 === (3))){
var inst_18551 = (state_18553[(2)]);
var state_18553__$1 = state_18553;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18553__$1,inst_18551);
} else {
if((state_val_18554 === (12))){
var inst_18539 = (state_18553[(2)]);
var state_18553__$1 = state_18553;
var statearr_18574_18604 = state_18553__$1;
(statearr_18574_18604[(2)] = inst_18539);

(statearr_18574_18604[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18554 === (2))){
var state_18553__$1 = state_18553;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18553__$1,(4),in$);
} else {
if((state_val_18554 === (23))){
var inst_18547 = (state_18553[(2)]);
var state_18553__$1 = state_18553;
var statearr_18575_18605 = state_18553__$1;
(statearr_18575_18605[(2)] = inst_18547);

(statearr_18575_18605[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18554 === (19))){
var inst_18534 = (state_18553[(2)]);
var state_18553__$1 = state_18553;
var statearr_18576_18606 = state_18553__$1;
(statearr_18576_18606[(2)] = inst_18534);

(statearr_18576_18606[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18554 === (11))){
var inst_18519 = (state_18553[(7)]);
var inst_18505 = (state_18553[(11)]);
var inst_18519__$1 = cljs.core.seq.call(null,inst_18505);
var state_18553__$1 = (function (){var statearr_18577 = state_18553;
(statearr_18577[(7)] = inst_18519__$1);

return statearr_18577;
})();
if(inst_18519__$1){
var statearr_18578_18607 = state_18553__$1;
(statearr_18578_18607[(1)] = (14));

} else {
var statearr_18579_18608 = state_18553__$1;
(statearr_18579_18608[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18554 === (9))){
var inst_18541 = (state_18553[(2)]);
var inst_18542 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_18553__$1 = (function (){var statearr_18580 = state_18553;
(statearr_18580[(15)] = inst_18541);

return statearr_18580;
})();
if(cljs.core.truth_(inst_18542)){
var statearr_18581_18609 = state_18553__$1;
(statearr_18581_18609[(1)] = (21));

} else {
var statearr_18582_18610 = state_18553__$1;
(statearr_18582_18610[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18554 === (5))){
var inst_18497 = cljs.core.async.close_BANG_.call(null,out);
var state_18553__$1 = state_18553;
var statearr_18583_18611 = state_18553__$1;
(statearr_18583_18611[(2)] = inst_18497);

(statearr_18583_18611[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18554 === (14))){
var inst_18519 = (state_18553[(7)]);
var inst_18521 = cljs.core.chunked_seq_QMARK_.call(null,inst_18519);
var state_18553__$1 = state_18553;
if(inst_18521){
var statearr_18584_18612 = state_18553__$1;
(statearr_18584_18612[(1)] = (17));

} else {
var statearr_18585_18613 = state_18553__$1;
(statearr_18585_18613[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18554 === (16))){
var inst_18537 = (state_18553[(2)]);
var state_18553__$1 = state_18553;
var statearr_18586_18614 = state_18553__$1;
(statearr_18586_18614[(2)] = inst_18537);

(statearr_18586_18614[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18554 === (10))){
var inst_18506 = (state_18553[(9)]);
var inst_18508 = (state_18553[(12)]);
var inst_18513 = cljs.core._nth.call(null,inst_18506,inst_18508);
var state_18553__$1 = state_18553;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18553__$1,(13),out,inst_18513);
} else {
if((state_val_18554 === (18))){
var inst_18519 = (state_18553[(7)]);
var inst_18528 = cljs.core.first.call(null,inst_18519);
var state_18553__$1 = state_18553;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18553__$1,(20),out,inst_18528);
} else {
if((state_val_18554 === (8))){
var inst_18507 = (state_18553[(10)]);
var inst_18508 = (state_18553[(12)]);
var inst_18510 = (inst_18508 < inst_18507);
var inst_18511 = inst_18510;
var state_18553__$1 = state_18553;
if(cljs.core.truth_(inst_18511)){
var statearr_18587_18615 = state_18553__$1;
(statearr_18587_18615[(1)] = (10));

} else {
var statearr_18588_18616 = state_18553__$1;
(statearr_18588_18616[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16937__auto__))
;
return ((function (switch__16847__auto__,c__16937__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__16848__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__16848__auto____0 = (function (){
var statearr_18589 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18589[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__16848__auto__);

(statearr_18589[(1)] = (1));

return statearr_18589;
});
var cljs$core$async$mapcat_STAR__$_state_machine__16848__auto____1 = (function (state_18553){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_18553);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e18590){if((e18590 instanceof Object)){
var ex__16851__auto__ = e18590;
var statearr_18591_18617 = state_18553;
(statearr_18591_18617[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18553);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18590;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18618 = state_18553;
state_18553 = G__18618;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__16848__auto__ = function(state_18553){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__16848__auto____1.call(this,state_18553);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__16848__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__16848__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__16848__auto__;
})()
;})(switch__16847__auto__,c__16937__auto__))
})();
var state__16939__auto__ = (function (){var statearr_18592 = f__16938__auto__.call(null);
(statearr_18592[(6)] = c__16937__auto__);

return statearr_18592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(c__16937__auto__))
);

return c__16937__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__18620 = arguments.length;
switch (G__18620) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__18623 = arguments.length;
switch (G__18623) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__18626 = arguments.length;
switch (G__18626) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16937__auto___18673 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16937__auto___18673,out){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (c__16937__auto___18673,out){
return (function (state_18650){
var state_val_18651 = (state_18650[(1)]);
if((state_val_18651 === (7))){
var inst_18645 = (state_18650[(2)]);
var state_18650__$1 = state_18650;
var statearr_18652_18674 = state_18650__$1;
(statearr_18652_18674[(2)] = inst_18645);

(statearr_18652_18674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18651 === (1))){
var inst_18627 = null;
var state_18650__$1 = (function (){var statearr_18653 = state_18650;
(statearr_18653[(7)] = inst_18627);

return statearr_18653;
})();
var statearr_18654_18675 = state_18650__$1;
(statearr_18654_18675[(2)] = null);

(statearr_18654_18675[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18651 === (4))){
var inst_18630 = (state_18650[(8)]);
var inst_18630__$1 = (state_18650[(2)]);
var inst_18631 = (inst_18630__$1 == null);
var inst_18632 = cljs.core.not.call(null,inst_18631);
var state_18650__$1 = (function (){var statearr_18655 = state_18650;
(statearr_18655[(8)] = inst_18630__$1);

return statearr_18655;
})();
if(inst_18632){
var statearr_18656_18676 = state_18650__$1;
(statearr_18656_18676[(1)] = (5));

} else {
var statearr_18657_18677 = state_18650__$1;
(statearr_18657_18677[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18651 === (6))){
var state_18650__$1 = state_18650;
var statearr_18658_18678 = state_18650__$1;
(statearr_18658_18678[(2)] = null);

(statearr_18658_18678[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18651 === (3))){
var inst_18647 = (state_18650[(2)]);
var inst_18648 = cljs.core.async.close_BANG_.call(null,out);
var state_18650__$1 = (function (){var statearr_18659 = state_18650;
(statearr_18659[(9)] = inst_18647);

return statearr_18659;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18650__$1,inst_18648);
} else {
if((state_val_18651 === (2))){
var state_18650__$1 = state_18650;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18650__$1,(4),ch);
} else {
if((state_val_18651 === (11))){
var inst_18630 = (state_18650[(8)]);
var inst_18639 = (state_18650[(2)]);
var inst_18627 = inst_18630;
var state_18650__$1 = (function (){var statearr_18660 = state_18650;
(statearr_18660[(10)] = inst_18639);

(statearr_18660[(7)] = inst_18627);

return statearr_18660;
})();
var statearr_18661_18679 = state_18650__$1;
(statearr_18661_18679[(2)] = null);

(statearr_18661_18679[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18651 === (9))){
var inst_18630 = (state_18650[(8)]);
var state_18650__$1 = state_18650;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18650__$1,(11),out,inst_18630);
} else {
if((state_val_18651 === (5))){
var inst_18627 = (state_18650[(7)]);
var inst_18630 = (state_18650[(8)]);
var inst_18634 = cljs.core._EQ_.call(null,inst_18630,inst_18627);
var state_18650__$1 = state_18650;
if(inst_18634){
var statearr_18663_18680 = state_18650__$1;
(statearr_18663_18680[(1)] = (8));

} else {
var statearr_18664_18681 = state_18650__$1;
(statearr_18664_18681[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18651 === (10))){
var inst_18642 = (state_18650[(2)]);
var state_18650__$1 = state_18650;
var statearr_18665_18682 = state_18650__$1;
(statearr_18665_18682[(2)] = inst_18642);

(statearr_18665_18682[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18651 === (8))){
var inst_18627 = (state_18650[(7)]);
var tmp18662 = inst_18627;
var inst_18627__$1 = tmp18662;
var state_18650__$1 = (function (){var statearr_18666 = state_18650;
(statearr_18666[(7)] = inst_18627__$1);

return statearr_18666;
})();
var statearr_18667_18683 = state_18650__$1;
(statearr_18667_18683[(2)] = null);

(statearr_18667_18683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16937__auto___18673,out))
;
return ((function (switch__16847__auto__,c__16937__auto___18673,out){
return (function() {
var cljs$core$async$state_machine__16848__auto__ = null;
var cljs$core$async$state_machine__16848__auto____0 = (function (){
var statearr_18668 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18668[(0)] = cljs$core$async$state_machine__16848__auto__);

(statearr_18668[(1)] = (1));

return statearr_18668;
});
var cljs$core$async$state_machine__16848__auto____1 = (function (state_18650){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_18650);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e18669){if((e18669 instanceof Object)){
var ex__16851__auto__ = e18669;
var statearr_18670_18684 = state_18650;
(statearr_18670_18684[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18650);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18669;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18685 = state_18650;
state_18650 = G__18685;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$state_machine__16848__auto__ = function(state_18650){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16848__auto____1.call(this,state_18650);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16848__auto____0;
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16848__auto____1;
return cljs$core$async$state_machine__16848__auto__;
})()
;})(switch__16847__auto__,c__16937__auto___18673,out))
})();
var state__16939__auto__ = (function (){var statearr_18671 = f__16938__auto__.call(null);
(statearr_18671[(6)] = c__16937__auto___18673);

return statearr_18671;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(c__16937__auto___18673,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__18687 = arguments.length;
switch (G__18687) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16937__auto___18753 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16937__auto___18753,out){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (c__16937__auto___18753,out){
return (function (state_18725){
var state_val_18726 = (state_18725[(1)]);
if((state_val_18726 === (7))){
var inst_18721 = (state_18725[(2)]);
var state_18725__$1 = state_18725;
var statearr_18727_18754 = state_18725__$1;
(statearr_18727_18754[(2)] = inst_18721);

(statearr_18727_18754[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18726 === (1))){
var inst_18688 = (new Array(n));
var inst_18689 = inst_18688;
var inst_18690 = (0);
var state_18725__$1 = (function (){var statearr_18728 = state_18725;
(statearr_18728[(7)] = inst_18689);

(statearr_18728[(8)] = inst_18690);

return statearr_18728;
})();
var statearr_18729_18755 = state_18725__$1;
(statearr_18729_18755[(2)] = null);

(statearr_18729_18755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18726 === (4))){
var inst_18693 = (state_18725[(9)]);
var inst_18693__$1 = (state_18725[(2)]);
var inst_18694 = (inst_18693__$1 == null);
var inst_18695 = cljs.core.not.call(null,inst_18694);
var state_18725__$1 = (function (){var statearr_18730 = state_18725;
(statearr_18730[(9)] = inst_18693__$1);

return statearr_18730;
})();
if(inst_18695){
var statearr_18731_18756 = state_18725__$1;
(statearr_18731_18756[(1)] = (5));

} else {
var statearr_18732_18757 = state_18725__$1;
(statearr_18732_18757[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18726 === (15))){
var inst_18715 = (state_18725[(2)]);
var state_18725__$1 = state_18725;
var statearr_18733_18758 = state_18725__$1;
(statearr_18733_18758[(2)] = inst_18715);

(statearr_18733_18758[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18726 === (13))){
var state_18725__$1 = state_18725;
var statearr_18734_18759 = state_18725__$1;
(statearr_18734_18759[(2)] = null);

(statearr_18734_18759[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18726 === (6))){
var inst_18690 = (state_18725[(8)]);
var inst_18711 = (inst_18690 > (0));
var state_18725__$1 = state_18725;
if(cljs.core.truth_(inst_18711)){
var statearr_18735_18760 = state_18725__$1;
(statearr_18735_18760[(1)] = (12));

} else {
var statearr_18736_18761 = state_18725__$1;
(statearr_18736_18761[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18726 === (3))){
var inst_18723 = (state_18725[(2)]);
var state_18725__$1 = state_18725;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18725__$1,inst_18723);
} else {
if((state_val_18726 === (12))){
var inst_18689 = (state_18725[(7)]);
var inst_18713 = cljs.core.vec.call(null,inst_18689);
var state_18725__$1 = state_18725;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18725__$1,(15),out,inst_18713);
} else {
if((state_val_18726 === (2))){
var state_18725__$1 = state_18725;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18725__$1,(4),ch);
} else {
if((state_val_18726 === (11))){
var inst_18705 = (state_18725[(2)]);
var inst_18706 = (new Array(n));
var inst_18689 = inst_18706;
var inst_18690 = (0);
var state_18725__$1 = (function (){var statearr_18737 = state_18725;
(statearr_18737[(7)] = inst_18689);

(statearr_18737[(8)] = inst_18690);

(statearr_18737[(10)] = inst_18705);

return statearr_18737;
})();
var statearr_18738_18762 = state_18725__$1;
(statearr_18738_18762[(2)] = null);

(statearr_18738_18762[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18726 === (9))){
var inst_18689 = (state_18725[(7)]);
var inst_18703 = cljs.core.vec.call(null,inst_18689);
var state_18725__$1 = state_18725;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18725__$1,(11),out,inst_18703);
} else {
if((state_val_18726 === (5))){
var inst_18698 = (state_18725[(11)]);
var inst_18689 = (state_18725[(7)]);
var inst_18690 = (state_18725[(8)]);
var inst_18693 = (state_18725[(9)]);
var inst_18697 = (inst_18689[inst_18690] = inst_18693);
var inst_18698__$1 = (inst_18690 + (1));
var inst_18699 = (inst_18698__$1 < n);
var state_18725__$1 = (function (){var statearr_18739 = state_18725;
(statearr_18739[(12)] = inst_18697);

(statearr_18739[(11)] = inst_18698__$1);

return statearr_18739;
})();
if(cljs.core.truth_(inst_18699)){
var statearr_18740_18763 = state_18725__$1;
(statearr_18740_18763[(1)] = (8));

} else {
var statearr_18741_18764 = state_18725__$1;
(statearr_18741_18764[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18726 === (14))){
var inst_18718 = (state_18725[(2)]);
var inst_18719 = cljs.core.async.close_BANG_.call(null,out);
var state_18725__$1 = (function (){var statearr_18743 = state_18725;
(statearr_18743[(13)] = inst_18718);

return statearr_18743;
})();
var statearr_18744_18765 = state_18725__$1;
(statearr_18744_18765[(2)] = inst_18719);

(statearr_18744_18765[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18726 === (10))){
var inst_18709 = (state_18725[(2)]);
var state_18725__$1 = state_18725;
var statearr_18745_18766 = state_18725__$1;
(statearr_18745_18766[(2)] = inst_18709);

(statearr_18745_18766[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18726 === (8))){
var inst_18698 = (state_18725[(11)]);
var inst_18689 = (state_18725[(7)]);
var tmp18742 = inst_18689;
var inst_18689__$1 = tmp18742;
var inst_18690 = inst_18698;
var state_18725__$1 = (function (){var statearr_18746 = state_18725;
(statearr_18746[(7)] = inst_18689__$1);

(statearr_18746[(8)] = inst_18690);

return statearr_18746;
})();
var statearr_18747_18767 = state_18725__$1;
(statearr_18747_18767[(2)] = null);

(statearr_18747_18767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16937__auto___18753,out))
;
return ((function (switch__16847__auto__,c__16937__auto___18753,out){
return (function() {
var cljs$core$async$state_machine__16848__auto__ = null;
var cljs$core$async$state_machine__16848__auto____0 = (function (){
var statearr_18748 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18748[(0)] = cljs$core$async$state_machine__16848__auto__);

(statearr_18748[(1)] = (1));

return statearr_18748;
});
var cljs$core$async$state_machine__16848__auto____1 = (function (state_18725){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_18725);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e18749){if((e18749 instanceof Object)){
var ex__16851__auto__ = e18749;
var statearr_18750_18768 = state_18725;
(statearr_18750_18768[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18725);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18749;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18769 = state_18725;
state_18725 = G__18769;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$state_machine__16848__auto__ = function(state_18725){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16848__auto____1.call(this,state_18725);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16848__auto____0;
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16848__auto____1;
return cljs$core$async$state_machine__16848__auto__;
})()
;})(switch__16847__auto__,c__16937__auto___18753,out))
})();
var state__16939__auto__ = (function (){var statearr_18751 = f__16938__auto__.call(null);
(statearr_18751[(6)] = c__16937__auto___18753);

return statearr_18751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(c__16937__auto___18753,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__18771 = arguments.length;
switch (G__18771) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16937__auto___18841 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16937__auto___18841,out){
return (function (){
var f__16938__auto__ = (function (){var switch__16847__auto__ = ((function (c__16937__auto___18841,out){
return (function (state_18813){
var state_val_18814 = (state_18813[(1)]);
if((state_val_18814 === (7))){
var inst_18809 = (state_18813[(2)]);
var state_18813__$1 = state_18813;
var statearr_18815_18842 = state_18813__$1;
(statearr_18815_18842[(2)] = inst_18809);

(statearr_18815_18842[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18814 === (1))){
var inst_18772 = [];
var inst_18773 = inst_18772;
var inst_18774 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_18813__$1 = (function (){var statearr_18816 = state_18813;
(statearr_18816[(7)] = inst_18774);

(statearr_18816[(8)] = inst_18773);

return statearr_18816;
})();
var statearr_18817_18843 = state_18813__$1;
(statearr_18817_18843[(2)] = null);

(statearr_18817_18843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18814 === (4))){
var inst_18777 = (state_18813[(9)]);
var inst_18777__$1 = (state_18813[(2)]);
var inst_18778 = (inst_18777__$1 == null);
var inst_18779 = cljs.core.not.call(null,inst_18778);
var state_18813__$1 = (function (){var statearr_18818 = state_18813;
(statearr_18818[(9)] = inst_18777__$1);

return statearr_18818;
})();
if(inst_18779){
var statearr_18819_18844 = state_18813__$1;
(statearr_18819_18844[(1)] = (5));

} else {
var statearr_18820_18845 = state_18813__$1;
(statearr_18820_18845[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18814 === (15))){
var inst_18803 = (state_18813[(2)]);
var state_18813__$1 = state_18813;
var statearr_18821_18846 = state_18813__$1;
(statearr_18821_18846[(2)] = inst_18803);

(statearr_18821_18846[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18814 === (13))){
var state_18813__$1 = state_18813;
var statearr_18822_18847 = state_18813__$1;
(statearr_18822_18847[(2)] = null);

(statearr_18822_18847[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18814 === (6))){
var inst_18773 = (state_18813[(8)]);
var inst_18798 = inst_18773.length;
var inst_18799 = (inst_18798 > (0));
var state_18813__$1 = state_18813;
if(cljs.core.truth_(inst_18799)){
var statearr_18823_18848 = state_18813__$1;
(statearr_18823_18848[(1)] = (12));

} else {
var statearr_18824_18849 = state_18813__$1;
(statearr_18824_18849[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18814 === (3))){
var inst_18811 = (state_18813[(2)]);
var state_18813__$1 = state_18813;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18813__$1,inst_18811);
} else {
if((state_val_18814 === (12))){
var inst_18773 = (state_18813[(8)]);
var inst_18801 = cljs.core.vec.call(null,inst_18773);
var state_18813__$1 = state_18813;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18813__$1,(15),out,inst_18801);
} else {
if((state_val_18814 === (2))){
var state_18813__$1 = state_18813;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18813__$1,(4),ch);
} else {
if((state_val_18814 === (11))){
var inst_18781 = (state_18813[(10)]);
var inst_18777 = (state_18813[(9)]);
var inst_18791 = (state_18813[(2)]);
var inst_18792 = [];
var inst_18793 = inst_18792.push(inst_18777);
var inst_18773 = inst_18792;
var inst_18774 = inst_18781;
var state_18813__$1 = (function (){var statearr_18825 = state_18813;
(statearr_18825[(11)] = inst_18793);

(statearr_18825[(7)] = inst_18774);

(statearr_18825[(8)] = inst_18773);

(statearr_18825[(12)] = inst_18791);

return statearr_18825;
})();
var statearr_18826_18850 = state_18813__$1;
(statearr_18826_18850[(2)] = null);

(statearr_18826_18850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18814 === (9))){
var inst_18773 = (state_18813[(8)]);
var inst_18789 = cljs.core.vec.call(null,inst_18773);
var state_18813__$1 = state_18813;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18813__$1,(11),out,inst_18789);
} else {
if((state_val_18814 === (5))){
var inst_18781 = (state_18813[(10)]);
var inst_18774 = (state_18813[(7)]);
var inst_18777 = (state_18813[(9)]);
var inst_18781__$1 = f.call(null,inst_18777);
var inst_18782 = cljs.core._EQ_.call(null,inst_18781__$1,inst_18774);
var inst_18783 = cljs.core.keyword_identical_QMARK_.call(null,inst_18774,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_18784 = (inst_18782) || (inst_18783);
var state_18813__$1 = (function (){var statearr_18827 = state_18813;
(statearr_18827[(10)] = inst_18781__$1);

return statearr_18827;
})();
if(cljs.core.truth_(inst_18784)){
var statearr_18828_18851 = state_18813__$1;
(statearr_18828_18851[(1)] = (8));

} else {
var statearr_18829_18852 = state_18813__$1;
(statearr_18829_18852[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18814 === (14))){
var inst_18806 = (state_18813[(2)]);
var inst_18807 = cljs.core.async.close_BANG_.call(null,out);
var state_18813__$1 = (function (){var statearr_18831 = state_18813;
(statearr_18831[(13)] = inst_18806);

return statearr_18831;
})();
var statearr_18832_18853 = state_18813__$1;
(statearr_18832_18853[(2)] = inst_18807);

(statearr_18832_18853[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18814 === (10))){
var inst_18796 = (state_18813[(2)]);
var state_18813__$1 = state_18813;
var statearr_18833_18854 = state_18813__$1;
(statearr_18833_18854[(2)] = inst_18796);

(statearr_18833_18854[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18814 === (8))){
var inst_18781 = (state_18813[(10)]);
var inst_18777 = (state_18813[(9)]);
var inst_18773 = (state_18813[(8)]);
var inst_18786 = inst_18773.push(inst_18777);
var tmp18830 = inst_18773;
var inst_18773__$1 = tmp18830;
var inst_18774 = inst_18781;
var state_18813__$1 = (function (){var statearr_18834 = state_18813;
(statearr_18834[(14)] = inst_18786);

(statearr_18834[(7)] = inst_18774);

(statearr_18834[(8)] = inst_18773__$1);

return statearr_18834;
})();
var statearr_18835_18855 = state_18813__$1;
(statearr_18835_18855[(2)] = null);

(statearr_18835_18855[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16937__auto___18841,out))
;
return ((function (switch__16847__auto__,c__16937__auto___18841,out){
return (function() {
var cljs$core$async$state_machine__16848__auto__ = null;
var cljs$core$async$state_machine__16848__auto____0 = (function (){
var statearr_18836 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18836[(0)] = cljs$core$async$state_machine__16848__auto__);

(statearr_18836[(1)] = (1));

return statearr_18836;
});
var cljs$core$async$state_machine__16848__auto____1 = (function (state_18813){
while(true){
var ret_value__16849__auto__ = (function (){try{while(true){
var result__16850__auto__ = switch__16847__auto__.call(null,state_18813);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16850__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16850__auto__;
}
break;
}
}catch (e18837){if((e18837 instanceof Object)){
var ex__16851__auto__ = e18837;
var statearr_18838_18856 = state_18813;
(statearr_18838_18856[(5)] = ex__16851__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18813);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18837;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16849__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18857 = state_18813;
state_18813 = G__18857;
continue;
} else {
return ret_value__16849__auto__;
}
break;
}
});
cljs$core$async$state_machine__16848__auto__ = function(state_18813){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16848__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16848__auto____1.call(this,state_18813);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16848__auto____0;
cljs$core$async$state_machine__16848__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16848__auto____1;
return cljs$core$async$state_machine__16848__auto__;
})()
;})(switch__16847__auto__,c__16937__auto___18841,out))
})();
var state__16939__auto__ = (function (){var statearr_18839 = f__16938__auto__.call(null);
(statearr_18839[(6)] = c__16937__auto___18841);

return statearr_18839;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16939__auto__);
});})(c__16937__auto___18841,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

