// Compiled by ClojureScript 1.9.946 {:target :nodejs}
goog.provide('re_frame.events');
goog.require('cljs.core');
goog.require('re_frame.db');
goog.require('re_frame.utils');
goog.require('re_frame.interop');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.interceptor');
goog.require('re_frame.trace');
re_frame.events.kind = new cljs.core.Keyword(null,"event","event",301435442);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.events.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * `interceptors` might have nested collections, and contain nil elements.
 *   return a flat collection, with all nils removed.
 *   This function is 9/10 about giving good error messages.
 */
re_frame.events.flatten_and_remove_nils = (function re_frame$events$flatten_and_remove_nils(id,interceptors){
var make_chain = (function (p1__14442_SHARP_){
return cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,p1__14442_SHARP_));
});
if(!(re_frame.interop.debug_enabled_QMARK_)){
return make_chain.call(null,interceptors);
} else {
if(cljs.core.coll_QMARK_.call(null,interceptors)){
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", expected a collection of interceptors, got: ",interceptors);
}

var chain = make_chain.call(null,interceptors);
if(cljs.core.empty_QMARK_.call(null,chain)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", given an empty interceptor chain");
} else {
}

var temp__5457__auto___14443 = cljs.core.first.call(null,cljs.core.remove.call(null,re_frame.interceptor.interceptor_QMARK_,chain));
if(cljs.core.truth_(temp__5457__auto___14443)){
var not_i_14444 = temp__5457__auto___14443;
if(cljs.core.fn_QMARK_.call(null,not_i_14444)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", got a function instead of an interceptor. Did you provide old style middleware by mistake? Got: ",not_i_14444);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", expected interceptors, but got: ",not_i_14444);
}
} else {
}

return chain;
}
});
/**
 * Associate the given event `id` with the given collection of `interceptors`.
 * 
 * `interceptors` may contain nested collections and there may be nils
 * at any level,so process this structure into a simple, nil-less vector
 * before registration.
 * 
 * Typically, an `event handler` will be at the end of the chain (wrapped
 * in an interceptor).
 */
re_frame.events.register = (function re_frame$events$register(id,interceptors){
return re_frame.registrar.register_handler.call(null,re_frame.events.kind,id,re_frame.events.flatten_and_remove_nils.call(null,id,interceptors));
});
re_frame.events._STAR_handling_STAR_ = null;
/**
 * Given an event vector `event-v`, look up the associated interceptor chain, and execute it.
 */
re_frame.events.handle = (function re_frame$events$handle(event_v){
var event_id = re_frame.utils.first_in_vector.call(null,event_v);
var temp__5455__auto__ = re_frame.registrar.get_handler.call(null,re_frame.events.kind,event_id,true);
if(cljs.core.truth_(temp__5455__auto__)){
var interceptors = temp__5455__auto__;
if(cljs.core.truth_(re_frame.events._STAR_handling_STAR_)){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: while handling \"",re_frame.events._STAR_handling_STAR_,"\", dispatch-sync was called for \"",event_v,"\". You can't call dispatch-sync within an event handler.");
} else {
var _STAR_handling_STAR_14445 = re_frame.events._STAR_handling_STAR_;
re_frame.events._STAR_handling_STAR_ = event_v;

try{if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR_14446 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"operation","operation",-1267664310),event_id,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),re_frame.events.kind,new cljs.core.Keyword(null,"tags","tags",1771418977),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"event","event",301435442),event_v], null)], null));

try{try{return re_frame.interceptor.execute.call(null,event_v,interceptors);
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__14390__auto___14459 = re_frame.interop.now.call(null);
var duration__14391__auto___14460 = (end__14390__auto___14459 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
var seq__14447_14461 = cljs.core.seq.call(null,cljs.core.deref.call(null,re_frame.trace.trace_cbs));
var chunk__14448_14462 = null;
var count__14449_14463 = (0);
var i__14450_14464 = (0);
while(true){
if((i__14450_14464 < count__14449_14463)){
var vec__14451_14465 = cljs.core._nth.call(null,chunk__14448_14462,i__14450_14464);
var k__14392__auto___14466 = cljs.core.nth.call(null,vec__14451_14465,(0),null);
var cb__14393__auto___14467 = cljs.core.nth.call(null,vec__14451_14465,(1),null);
try{cb__14393__auto___14467.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__14391__auto___14460,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e14454){if((e14454 instanceof java.lang.Exception)){
var e__14394__auto___14468 = e14454;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__14392__auto___14466,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__14394__auto___14468);
} else {
throw e14454;

}
}
var G__14469 = seq__14447_14461;
var G__14470 = chunk__14448_14462;
var G__14471 = count__14449_14463;
var G__14472 = (i__14450_14464 + (1));
seq__14447_14461 = G__14469;
chunk__14448_14462 = G__14470;
count__14449_14463 = G__14471;
i__14450_14464 = G__14472;
continue;
} else {
var temp__5457__auto___14473 = cljs.core.seq.call(null,seq__14447_14461);
if(temp__5457__auto___14473){
var seq__14447_14474__$1 = temp__5457__auto___14473;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__14447_14474__$1)){
var c__9319__auto___14475 = cljs.core.chunk_first.call(null,seq__14447_14474__$1);
var G__14476 = cljs.core.chunk_rest.call(null,seq__14447_14474__$1);
var G__14477 = c__9319__auto___14475;
var G__14478 = cljs.core.count.call(null,c__9319__auto___14475);
var G__14479 = (0);
seq__14447_14461 = G__14476;
chunk__14448_14462 = G__14477;
count__14449_14463 = G__14478;
i__14450_14464 = G__14479;
continue;
} else {
var vec__14455_14480 = cljs.core.first.call(null,seq__14447_14474__$1);
var k__14392__auto___14481 = cljs.core.nth.call(null,vec__14455_14480,(0),null);
var cb__14393__auto___14482 = cljs.core.nth.call(null,vec__14455_14480,(1),null);
try{cb__14393__auto___14482.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__14391__auto___14460,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e14458){if((e14458 instanceof java.lang.Exception)){
var e__14394__auto___14483 = e14458;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__14392__auto___14481,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__14394__auto___14483);
} else {
throw e14458;

}
}
var G__14484 = cljs.core.next.call(null,seq__14447_14474__$1);
var G__14485 = null;
var G__14486 = (0);
var G__14487 = (0);
seq__14447_14461 = G__14484;
chunk__14448_14462 = G__14485;
count__14449_14463 = G__14486;
i__14450_14464 = G__14487;
continue;
}
} else {
}
}
break;
}
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_14446;
}} else {
return re_frame.interceptor.execute.call(null,event_v,interceptors);
}
}finally {re_frame.events._STAR_handling_STAR_ = _STAR_handling_STAR_14445;
}}
} else {
return null;
}
});
