// Compiled by ClojureScript 1.9.946 {:target :nodejs}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
var seq__14562 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__14563 = null;
var count__14564 = (0);
var i__14565 = (0);
while(true){
if((i__14565 < count__14564)){
var vec__14566 = cljs.core._nth.call(null,chunk__14563,i__14565);
var effect_key = cljs.core.nth.call(null,vec__14566,(0),null);
var effect_value = cljs.core.nth.call(null,vec__14566,(1),null);
var temp__5455__auto___14572 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___14572)){
var effect_fn_14573 = temp__5455__auto___14572;
effect_fn_14573.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring.");
}

var G__14574 = seq__14562;
var G__14575 = chunk__14563;
var G__14576 = count__14564;
var G__14577 = (i__14565 + (1));
seq__14562 = G__14574;
chunk__14563 = G__14575;
count__14564 = G__14576;
i__14565 = G__14577;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__14562);
if(temp__5457__auto__){
var seq__14562__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__14562__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__14562__$1);
var G__14578 = cljs.core.chunk_rest.call(null,seq__14562__$1);
var G__14579 = c__9319__auto__;
var G__14580 = cljs.core.count.call(null,c__9319__auto__);
var G__14581 = (0);
seq__14562 = G__14578;
chunk__14563 = G__14579;
count__14564 = G__14580;
i__14565 = G__14581;
continue;
} else {
var vec__14569 = cljs.core.first.call(null,seq__14562__$1);
var effect_key = cljs.core.nth.call(null,vec__14569,(0),null);
var effect_value = cljs.core.nth.call(null,vec__14569,(1),null);
var temp__5455__auto___14582 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___14582)){
var effect_fn_14583 = temp__5455__auto___14582;
effect_fn_14583.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring.");
}

var G__14584 = cljs.core.next.call(null,seq__14562__$1);
var G__14585 = null;
var G__14586 = (0);
var G__14587 = (0);
seq__14562 = G__14584;
chunk__14563 = G__14585;
count__14564 = G__14586;
i__14565 = G__14587;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__14588 = cljs.core.seq.call(null,value);
var chunk__14589 = null;
var count__14590 = (0);
var i__14591 = (0);
while(true){
if((i__14591 < count__14590)){
var map__14592 = cljs.core._nth.call(null,chunk__14589,i__14591);
var map__14592__$1 = ((((!((map__14592 == null)))?((((map__14592.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14592.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14592):map__14592);
var effect = map__14592__$1;
var ms = cljs.core.get.call(null,map__14592__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__14592__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__14588,chunk__14589,count__14590,i__14591,map__14592,map__14592__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__14588,chunk__14589,count__14590,i__14591,map__14592,map__14592__$1,effect,ms,dispatch))
,ms);
}

var G__14596 = seq__14588;
var G__14597 = chunk__14589;
var G__14598 = count__14590;
var G__14599 = (i__14591 + (1));
seq__14588 = G__14596;
chunk__14589 = G__14597;
count__14590 = G__14598;
i__14591 = G__14599;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__14588);
if(temp__5457__auto__){
var seq__14588__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__14588__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__14588__$1);
var G__14600 = cljs.core.chunk_rest.call(null,seq__14588__$1);
var G__14601 = c__9319__auto__;
var G__14602 = cljs.core.count.call(null,c__9319__auto__);
var G__14603 = (0);
seq__14588 = G__14600;
chunk__14589 = G__14601;
count__14590 = G__14602;
i__14591 = G__14603;
continue;
} else {
var map__14594 = cljs.core.first.call(null,seq__14588__$1);
var map__14594__$1 = ((((!((map__14594 == null)))?((((map__14594.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14594.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14594):map__14594);
var effect = map__14594__$1;
var ms = cljs.core.get.call(null,map__14594__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__14594__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__14588,chunk__14589,count__14590,i__14591,map__14594,map__14594__$1,effect,ms,dispatch,seq__14588__$1,temp__5457__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__14588,chunk__14589,count__14590,i__14591,map__14594,map__14594__$1,effect,ms,dispatch,seq__14588__$1,temp__5457__auto__))
,ms);
}

var G__14604 = cljs.core.next.call(null,seq__14588__$1);
var G__14605 = null;
var G__14606 = (0);
var G__14607 = (0);
seq__14588 = G__14604;
chunk__14589 = G__14605;
count__14590 = G__14606;
i__14591 = G__14607;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value);
} else {
var seq__14608 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__14609 = null;
var count__14610 = (0);
var i__14611 = (0);
while(true){
if((i__14611 < count__14610)){
var event = cljs.core._nth.call(null,chunk__14609,i__14611);
re_frame.router.dispatch.call(null,event);

var G__14612 = seq__14608;
var G__14613 = chunk__14609;
var G__14614 = count__14610;
var G__14615 = (i__14611 + (1));
seq__14608 = G__14612;
chunk__14609 = G__14613;
count__14610 = G__14614;
i__14611 = G__14615;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__14608);
if(temp__5457__auto__){
var seq__14608__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__14608__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__14608__$1);
var G__14616 = cljs.core.chunk_rest.call(null,seq__14608__$1);
var G__14617 = c__9319__auto__;
var G__14618 = cljs.core.count.call(null,c__9319__auto__);
var G__14619 = (0);
seq__14608 = G__14616;
chunk__14609 = G__14617;
count__14610 = G__14618;
i__14611 = G__14619;
continue;
} else {
var event = cljs.core.first.call(null,seq__14608__$1);
re_frame.router.dispatch.call(null,event);

var G__14620 = cljs.core.next.call(null,seq__14608__$1);
var G__14621 = null;
var G__14622 = (0);
var G__14623 = (0);
seq__14608 = G__14620;
chunk__14609 = G__14621;
count__14610 = G__14622;
i__14611 = G__14623;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__14624 = cljs.core.seq.call(null,value);
var chunk__14625 = null;
var count__14626 = (0);
var i__14627 = (0);
while(true){
if((i__14627 < count__14626)){
var event = cljs.core._nth.call(null,chunk__14625,i__14627);
clear_event.call(null,event);

var G__14628 = seq__14624;
var G__14629 = chunk__14625;
var G__14630 = count__14626;
var G__14631 = (i__14627 + (1));
seq__14624 = G__14628;
chunk__14625 = G__14629;
count__14626 = G__14630;
i__14627 = G__14631;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__14624);
if(temp__5457__auto__){
var seq__14624__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__14624__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__14624__$1);
var G__14632 = cljs.core.chunk_rest.call(null,seq__14624__$1);
var G__14633 = c__9319__auto__;
var G__14634 = cljs.core.count.call(null,c__9319__auto__);
var G__14635 = (0);
seq__14624 = G__14632;
chunk__14625 = G__14633;
count__14626 = G__14634;
i__14627 = G__14635;
continue;
} else {
var event = cljs.core.first.call(null,seq__14624__$1);
clear_event.call(null,event);

var G__14636 = cljs.core.next.call(null,seq__14624__$1);
var G__14637 = null;
var G__14638 = (0);
var G__14639 = (0);
seq__14624 = G__14636;
chunk__14625 = G__14637;
count__14626 = G__14638;
i__14627 = G__14639;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if(!((cljs.core.deref.call(null,re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));
