(ns abracad.random
  (:require [abracad.avro :as avro]
            [abracad.avro.edn :as edn]
            [cheshire.core :as json])
  (:import [java.net InetAddress]))

(comment
  (let [big-decimal-schema (avro/parse-schema
                             {:name           'abracad.avro.edn.BigDecimal
                              :type           :record
                              :abracad.reader :BigDecimal
                              :fields         [{:name "value", :type {:name           :abracad.avro.edn.BigInteger
                                                                      :type           :record
                                                                      :abracad.reader :BigInteger
                                                                      :fields         [{:name "value", :type :bytes}]}}
                                               {:name "scale", :type :int}]})
        schema             (avro/parse-schema
                             {:name   "example"
                              :type   :record
                              :fields [{:name "venue-lat"
                                        :type [:null :double]}
                                       {:name "venue-lng"
                                        :type [{:name           'abracad.avro.edn.BigDecimal
                                                :type           :record
                                                :abracad.reader :BigDecimal
                                                :fields         [{:name "value", :type {:name           :abracad.avro.edn.BigInteger
                                                                                        :type           :record
                                                                                        :abracad.reader :BigInteger
                                                                                        :fields         [{:name "value", :type :bytes}]}}
                                                                 {:name "scale", :type :int}]} :null]}
                                       {:name "lng"
                                        :type ['abracad.avro.edn.BigDecimal :null]}]})]
    (->> {:venue-lat 10.5
          :venue-lng 10.5M
          :lng       9.8M
          }
         (avro/binary-encoded schema)
         (avro/decode schema)))


  (let [schema (edn/new-schema
                 {:name   "example"
                  :type   :record
                  :fields [{:name "bar"
                            :type :BigInteger}
                           {:name "foo"
                            :type :long}]})]
    (->> {:bar (biginteger 10)
          :foo 10.5}
         (avro/binary-encoded schema)
         (avro/decode schema)))

  (let [schema (avro/parse-schema
                 {:type   :record
                  :name   "example" 
                  :fields [{:name "bar"
                            :type :int}
                           {:name "foo"
                            :type :long}]})]
    (->> {:bar 10
          :foo 10}
         (avro/binary-encoded schema)
         (avro/decode schema)))

  (avro/parse-schema {:type   "record"
                      :name   "User"
                      :fields [{:name "name" :type :string}
                               {:name "favorite_number" :type [:int :null]}
                               {:name "favorite_color" :type [:string :null]}]})


  (avro/parse-schema "abracad.avro.edn.BigDecimal")


  (def big-integer-schema (avro/parse-schema {:name           'abracad.avro.edn.BigInteger
                                              :type           :record
                                              :abracad.reader :BigInteger
                                              :fields         [{:name "value", :type :bytes}]}))
  (def big-decimal-schema (avro/parse-schema big-integer-schema
                                             {:name           'abracad.avro.edn.BigDecimal
                                              :type           :record
                                              :abracad.reader :BigDecimal
                                              :fields         [{:name "value" :type 'abracad.avro.edn.BigInteger}
                                                               {:name "scale", :type :int}]}))


  (let [schema (avro/parse-schema big-decimal-schema
                                  {:name   "example"
                                   :type   :record
                                   :fields [{:name "venue-lat"
                                             :type [:double :null]}
                                            {:name "venue-lng"
                                             :type ['abracad.avro.edn.BigDecimal :null]}
                                            #_{:name "lng"
                                               :type ['abracad.avro.edn.BigDecimal :null]}]})]
    (->> {:venue-lat 10.2
          :venue-lng 10.2M
          ;; :lng nil
          }
         (avro/binary-encoded schema)
         (avro/decode schema)))

  (let [schema (avro/parse-schema {:name   "example"
                                   :type   :record
                                   :fields [{:name "venue-lat"
                                             :type :double}
                                            {:name "venue-lng"
                                             :type big-decimal-schema}
                                            {:name "lng"
                                             :type 'abracad.avro.edn.BigDecimal}]})]
    (->> {:venue-lat 1.2
          :venue-lng 10.2M
          :lng       4.3M}
         (avro/binary-encoded schema)
         (avro/decode schema)))
  #_(avro/parse-schema
      {:name   "example"
       :type   :record
       :fields [{:name "venue-lat"
                 :type [:null :double]}
                {:name "venue-lng"
                 :type [{:name           'abracad.avro.edn.BigDecimal
                         :type           :record
                         :abracad.reader :BigDecimal
                         :fields         [{:name "value", :type {:name           :abracad.avro.edn.BigInteger
                                                                 :type           :record
                                                                 :abracad.reader :BigInteger
                                                                 :fields         [{:name "value", :type :bytes}]}}
                                          {:name "scale", :type :int}]} :null]}
                {:name "lng"
                 :type ['abracad.avro.edn.BigDecimal :null]}]}))

