(ns kubernetes-api.my-scratch
  (:require [camel-snake-kebab.core :as csk]
            [kubernetes-api.core :refer :all]
            [kubernetes-api.internals.client :as internals.client]
            [martian.core :as martian]
            [tripod.log :as log])
  (:import (java.security KeyStore)
           (javax.net.ssl KeyManager SSLContext TrustManager)))

(defn ssl-engine-ca []
  (let [home         (System/getProperty "user.home")
        ca-cert-file (str home "/.kube/ca-br-prod-u.crt")]
    (less.awful.ssl/ssl-context->engine
     (doto (SSLContext/getInstance "TLS")
       (.init (into-array KeyManager [])
              (into-array TrustManager [])
              nil)
       #_(KeyStore/getInstance (KeyStore/getDefaultType))))))

(comment

  (def fmc-k8s (client "https://test-fmc-c-kubernetes-api.nubank.com.br"
                       {:token (slurp "/tmp/testtoken")}))

  (def staging-k8s (client "https://staging-global-j-kubernetes-api.nubank.com.br"
                           {:token (slurp "/tmp/staging-token")}))

  (def fmc-k8s2) @(org.httpkit.client/request
                   (assoc (request fmc-k8s {:kind    :Deployment
                                            :action  :list
                                            :request {:namespace "leal"}})
       ;:sslengine (ssl-engine-ca)
                          :insecure? false)))

(comment

  (new-route-name :get :tekton.dev :v1alpha1 :Namespaced :Task)

  (def home "/Users/rafaeleal/.kube")

  (def c (client "https://kubernetes.docker.internal:6443"
                 {:ca-cert     (str home "/ca-docker.crt")
                  :client-cert (str home "/client-cert.pem")
                  :client-key  (str home "/client-java.key")}))

  (martian/explore c)
  (actions k8s :Deployment)

  (def c2 (extend-client c {:api     "tekton.dev"
                            :version "v1alpha1"}))

  (martian/explore c)

  (def swag (swagger/read))

  (map name (keys (:paths swag)))

  (keys (-> swag :definitions :io.k8s.api.core.v1.Volume :properties))

  (misc/first-index-of #(= "v1" %) ["v2" "v1"])

  (sort-by (fn [v] (misc/first-index-of #(= % v) versions)) ["v1beta1" "v1" "v1alpha1"])

  (map (partial version-of c) [:ReadRbacAuthorizationV1beta1ClusterRole
                               :ReadRbacAuthorizationV1ClusterRole
                               :ReadRbacAuthorizationV1alpha1ClusterRole]) (choose-latest-version c [:ReadRbacAuthorizationV1beta1ClusterRole
                                                                                                     :ReadRbacAuthorizationV1ClusterRole
                                                                                                     :ReadRbacAuthorizationV1alpha1ClusterRole]) (explore-kind c :CustomResourceDefinition)

  (explore-kind k8s :Deployment)

  (explore-kind c2 :TaskRun)

  (martian/explore k8s :GetCoreApiVersions)
  @(martian/response-for k8s :GetCoreApiVersions)
  (explore k8s :Deployment)

  (find-preferred-action k8s {:kind            :Task
                              :all-namespaces? true
                              :action          :list})

  (explore-kind c2 nil)
  (martian/explore c :ListApiextensionsV1CustomResourceDefinition)

  (martian/request-for c :GetApiextensionsV1beta1ApiResources)

  @(martian/response-for c :ListApiextensionsV1beta1CustomResourceDefinition)

  @(martian/response-for c :GetApiextensionsV1beta1ApiResources)

  @(org.httpkit.client/request
    (assoc (martian/request-for c :ListApiextensionsV1beta1CustomResourceDefinition)
           :url "https://kubernetes.docker.internal:6443/apis/tekton.dev/v1alpha1/tasks"))

  @(org.httpkit.client/request
    (assoc (martian/request-for c :ListApiextensionsV1beta1CustomResourceDefinition)
           :url "https://kubernetes.docker.internal:6443/apis/tekton.dev/v1alpha1/namespaces/default/tasks")) @(org.httpkit.client/request
                                                                                                                (assoc (martian/request-for c :ListApiextensionsV1beta1CustomResourceDefinition)
                                                                                                                       :url "https://kubernetes.docker.internal:6443/apis/tekton.dev/v1alpha1"))

  @(martian/response-for c :ListApiextensionsV1beta1CustomResourceDefinition)

  (swagger-definition-for-route c :ReadRbacAuthorizationV1beta1ClusterRoleBinding)

  (->> (:handlers c)
       (misc/find-first #(= :ReadRbacAuthorizationV1beta1ClusterRoleBinding (:route-name %)))
       :swagger-definition)
  (clojure.data/diff {} {:foo 42})

  (explore-kind c nil)
  (martian/explore c :GetArbitraryApiResources)

  @(martian/response-for c :GetArbitraryApiResources {:api     "tekton.dev"
                                                      :version "v1alpha1"})

  (->> (:handlers c)
       (filter #(= (:route-name %) :ReadApiextensionsV1beta1CustomResourceDefinition))
       first
       :swagger-definition
       :x-kubernetes-group-version-kind)

  (actions c :CustomResourceDefinition)

  (martian/explore c)

  (martian/explore c :GetApiVersions) @(martian/response-for c :GetApiVersions)
  @(martian/response-for c :GetCoreApiVersions)

  (martian/explore c :ReadApiextensionsV1CustomResourceDefinition)

  (entities c)
  (core-versions k8s)

  (actions c :Pod)

  (find-action c {:kind   :Deployment
                  :action :get})

  (martian/request-for c :ReadAppsV1NamespacedDeployment {:namespace "default"
                                                          :name      "nginx-deployment"}) @(martian/response-for c :ListCoreV1NamespacedPod {:namespace "default"}))

(comment

  (def c (client "https://kubernetes.docker.internal:6443"
                 {:ca-cert     (str home "/ca-docker.crt")
                  :client-cert (str home "/client-cert.pem")
                  :client-key  (str home "/client-java.key")}))

  (require '[kubernetes-api.listeners :as listeners])

  (def ctx (listeners/new-context {:client c}))

  (def list-id (listeners/register ctx
                                   {:kind      "Deployment"
                                    :name      "nginx-deployment"
                                    :namespace "default"}
                                   listeners/print-version))

  (listeners/deregister ctx list-id)

  (listeners/status ctx list-id) {(keyword "/apis/{api}/{version}/") {:get        {:consumes     ["application/json"
                                                                                                  "application/yaml"
                                                                                                  "application/vnd.kubernetes.protobuf"]
                                                                                   :descriptiion "get available resources for arbitrary api"
                                                                                   :operationId  "GetArbitraryAPIResources"
                                                                                   :produces     ["application/json"
                                                                                                  "application/yaml"
                                                                                                  "application/vnd.kubernetes.protobuf"]
                                                                                   :responses    {"200" {:description "OK"
                                                                                                         :schema      {:$ref "#/definitions/io.k8s.apimachinery.pkg.apis.meta.v1.APIResourceList"}}
                                                                                                  "401" {:description "Unauthorized"}}
                                                                                   :schemes      ["https"]}
                                                                      :parameters [{:in     "path"
                                                                                    :name   "api"
                                                                                    :schema {:type "string"}}
                                                                                   {:in     "path"
                                                                                    :name   "version"
                                                                                    :schema {:type "string"}}]}})

(comment
  (def k8s (let [home (System/getProperty "user.home")]
             (-> "https://kubernetes.docker.internal:6443"
                 (client
                  {:ca-cert     (str home "/.kube/ca-docker.crt")
                   :client-cert (str home "/.kube/client-cert.pem")
                   :client-key  (str home "/.kube/client-java.key")})
                 (extend-client {:api     "tekton.dev"
                                 :version "v1alpha1"}))))

  (require '[kubernetes-api.listeners :as listeners]) (def ctx (listeners/new-context {:client k8s}))

  (def list-id (listeners/register ctx
                                   {:kind    :TaskRun
                                    :action  :get
                                    :request {:namespace "default"
                                              :name      "echo-hello-world-task-run-2"}}
                                   (fn [task-run]
                                     (prn (mapv
                                           (juxt :name (comp :startedAt :terminated))
                                           (:steps (:status task-run))))))) (let [{:keys [api version] :as extension-api} {:api "tekton.dev" :version "v1alpha1"}
                                                                                  api-resources @(martian/response-for k8s :GetArbitraryApiResources
                                                                                                                       {:api     api
                                                                                                                        :version version})
                                                                                  crds          @(martian/response-for k8s :ListApiextensionsV1beta1CustomResourceDefinition)]
                                                                              api-resources
                                                                              #_(crd/swagger-from extension-api api-resources crds))

  (martian/explore k8s)

  (explore k8s) (internals.client/kind {:route-name :ReadExtensionsV1beta1NamespacedDeploymentScale})
  (map internals.client/kind
       (filter #(= (internals.client/kind %) :Scale/Scale)
               (filter (partial internals.client/preffered-version? k8s) (:handlers k8s))))
  @(martian/response-for k8s :GetApiVersions)
  (internals.client/all-versions k8s)
  (filter
   (fn [[kind & actions]]
     (letfn [(has-duplicates [coll] (= (count coll)
                                       (count (set coll))))]
       (not (has-duplicates (map first actions)))))
   (explore k8s)) (take 3 (map :route-name (filter #(and (= (internals.client/handler-action %) :get)
                                                         (= (internals.client/handler-kind %) :Pod)) (:handlers k8s))))

  (info k8s {:kind :Pod
             :action :list})

  (map :route-name (:handlers k8s))

  (map (juxt internals.client/handler-kind :route-name) (:handlers k8s)) (invoke k8s {:kind :Pod
                                                                                      :action :list
                                                                                      :request {:namespace "default"}})

  (csk/->camelCase (csk/->kebab-case "apiVersionV1beta1"))

  (find-action k8s {:kind   :Deployment
                    :action :create})

  (info k8s {:kind    :Deployment
             :action  :post
             :request {:namespace "default"}})

  (walk/postwalk

   (fn [form]
     (if (s/optional-key? form)
       (:k form)
       form))
   (info k8s {:kind    :Deployment
              :action  :create
              :request {:namespace "default"}})) (csk/->snake_case "Foo_Case1Foo")

  (nth (:handlers k8s) 3)

  (invoke k8s {:kind    :TaskRun
               :action  :update
               :request {:namespace "default"
                         :name      "echo-hello-world-task-run-2"
                         :body      {:apiVersion "tekton.dev/v1alpha1"
                                     :kind       "TaskRun"
                                     :metadata   {:name            "echo-hello-world-task-run-2"
                                                  :resourceVersion "1149313"}
                                     :spec       {:taskRef {:name "echo-hello-world"}}}}})

  (invoke k8s {:kind    :PipelineResource
               :action  :create
               :request {:namespace "default"
                         :body      {:apiVersion "tekton.dev/v1alpha1"
                                     :kind       "PipelineResource"
                                     :metadata   {:name "dummy-lib-git"}
                                     :spec       {:type   "git"
                                                  :params [{:name  "revision"
                                                            :value "master"}
                                                           {:name  "url"
                                                            :value "git@github.com:nubank/dummy-lib.git"}]}}}}) (invoke k8s {:kind    :TaskRun
                                                                                                                             :action  :create
                                                                                                                             :request {:namespace "default"
                                                                                                                                       :body      {:apiVersion "tekton.dev/v1alpha1"
                                                                                                                                                   :kind       "TaskRun"
                                                                                                                                                   :metadata   {:name "run-ls-on-git-3"}
                                                                                                                                                   :spec       {:serviceAccountName "build-bot"
                                                                                                                                                                :taskRef            {:name "run-ls"}
                                                                                                                                                                :inputs             {:resources [{:name        "workspace"
                                                                                                                                                                                                  :resourceRef {:name "dummy-lib-git"}}]}}}}})

  (invoke k8s {:kind    :TaskRun
               :action  "create"
               :request {:namespace "default"
                         :body      {:apiVersion "tekton.dev/v1alpha1"
                                     :kind       "TaskRun"
                                     :metadata   {:name      "test-taskrun-with-sa-git-ssh"
                                                  :namespace "default"}
                                     :spec       {:serviceAccountName "build-bot"
                                                  :taskSpec           {:inputs {:resources [{:name "gitssh"
                                                                                             :type "git"}]}
                                                                       :steps  [{:command ["/bin/bash"]
                                                                                 :args    ["-c" "cat /workspace/gitssh/README.md"]
                                                                                 :image   "ubuntu"
                                                                                 :name    "readreadme"}]}
                                                  :inputs             {:resources [{:name         "gitssh"
                                                                                    :resourceSpec {:type   "git"
                                                                                                   :params [{:name  "revision"
                                                                                                             :value "master"}
                                                                                                            {:name  "url"
                                                                                                             :value "git@github.com:cognitect-labs/aws-api.git"}]}}]}}}}})

  (invoke k8s {:kind    :ServiceAccount
               :action  :create
               :request {:namespace "default"
                         :metadata  {:name "build-bot"}
                         :secrets   [{:name "ssh-key"}]}})

  (request k8s {:kind    :ConfigMap
                :action  :create
                :request {:namespace "default"
                          :body      {:apiVersion "v1"
                                      :data       {"foo" "bar"}}}})

  (invoke k8s {:kind    :Task
               :action  :get
               :request {:namespace "default"
                         :name      "echo-hello-world"}})

  (invoke k8s {:kind    :Task
               :action  :create
               :request {:namespace "default"
                         :body      {:apiVersion "tekton.dev/v1alpha1"
                                     :kind       "Task"
                                     :metadata   {:name "run-ls"}
                                     :spec       {:inputs {:resources [{:name       "workspace"
                                                                        :type       "git"
                                                                        :targetPath "dummy-lib"}]}
                                                  :steps  [{:command    ["ls"]
                                                            :image      "ubuntu"
                                                            :name       "ls"
                                                            :workingDir "/workspace/dummy-lib"}]}}}}) (find-preferred-action k8s {:kind   :Deployment
                                                                                                                                  :action :create})

  (invoke k8s {:kind    :TaskRun
               :action  :get
               :request {:namespace "default"
                         :name      "echo-hello-world-task-run-2"}})

  (first (:handlers k8s))

  (defn base64 [s]
    (.encodeToString (Base64/getEncoder) (.getBytes s)))

  (def ssh-key {:api-version "v1"
                :kind        "Secret"
                :metadata    {:name        "ssh-key"
                              :annotations {"tekton.dev/git-0" "github.com"}}
                :type        "kubernetes.io/ssh-auth"
                :data        {:ssh-privatekey (base64 (slurp (str (System/getProperty "user.home")
                                                                  "/.ssh/id_github")))
                              :known_hosts    (base64 (slurp (str (System/getProperty "user.home")
                                                                  "/.ssh/known_hosts")))}}) (swagger-definition-for-route k8s (find-preferred-action k8s {:kind   :Secret
                                                                                                                                                          :action :create})) (explore k8s :Secret)

  (entities k8s)
  (set (map first (drop 1 [:MutatingWebhookConfiguration
                           [:deletecollection "delete collection of MutatingWebhookConfiguration"]
                           [:list "list or watch objects of kind MutatingWebhookConfiguration"]
                           [:create "create a MutatingWebhookConfiguration"]
                           [:deletecollection "delete collection of MutatingWebhookConfiguration"]
                           [:list "list or watch objects of kind MutatingWebhookConfiguration"]
                           [:create "create a MutatingWebhookConfiguration"]
                           [:delete "delete a MutatingWebhookConfiguration"]
                           [:get "read the specified MutatingWebhookConfiguration"]
                           [:patch "partially update the specified MutatingWebhookConfiguration"]
                           [:update "replace the specified MutatingWebhookConfiguration"]
                           [:delete "delete a MutatingWebhookConfiguration"]
                           [:get "read the specified MutatingWebhookConfiguration"]
                           [:patch "partially update the specified MutatingWebhookConfiguration"]
                           [:update "replace the specified MutatingWebhookConfiguration"]])))

  (explore k8s)
  (explore k8s :Deployment)
  (info k8s {:kind :Deployment
             :action :create})
  (invoke k8s {:kind    :Secret
               :action  :create
               :request {:namespace "default"
                         :name      "ssh-key"
                         :body      ssh-key}}))

(comment

  (binding [log/*logfn* println]
    (def k8s (let [home (System/getProperty "user.home")]
               (-> "https://F651B8C9233B8F2F016254B3516CEAEA.yl4.us-east-1.eks.amazonaws.com"
                   (client
                    {:insecure? true
                     :token     "k8s-aws-v1.aHR0cHM6Ly9zdHMuYW1hem9uYXdzLmNvbS8_QWN0aW9uPUdldENhbGxlcklkZW50aXR5JlZlcnNpb249MjAxMS0wNi0xNSZYLUFtei1BbGdvcml0aG09QVdTNC1ITUFDLVNIQTI1NiZYLUFtei1DcmVkZW50aWFsPUFLSUFTMklCWUtQNlBSWDZPMzZDJTJGMjAyMDAxMTYlMkZ1cy1lYXN0LTElMkZzdHMlMkZhd3M0X3JlcXVlc3QmWC1BbXotRGF0ZT0yMDIwMDExNlQxNjU1NDNaJlgtQW16LUV4cGlyZXM9MCZYLUFtei1TaWduZWRIZWFkZXJzPWhvc3QlM0J4LWs4cy1hd3MtaWQmWC1BbXotU2lnbmF0dXJlPTg2ZDY5ZTE0MzI0MzFkODJiYjZmMGJiYTM1YTcyZDgzYjRiN2ZmOGI2MzIxMjIxZjIwOGFlZjQ5YmFlODhmYzI"})
                   (extend-client {:api     "tekton.dev"
                                   :version "v1alpha1"})))))

  (def k8s (let [home (System/getProperty "user.home")]
             (-> "http://127.0.0.1:8001"
                 (client
                  {:insecure? true})
                 (extend-client {:api     "tekton.dev"
                                 :version "v1alpha1"})))) (keys k8s)

  (keys (kubernetes-api.swagger/read))

  (-> (kubernetes-api.swagger/from-api "https://F651B8C9233B8F2F016254B3516CEAEA.yl4.us-east-1.eks.amazonaws.com"
                                       {:insecure? true
                                        :token     "k8s-aws-v1.aHR0cHM6Ly9zdHMuYW1hem9uYXdzLmNvbS8_QWN0aW9uPUdldENhbGxlcklkZW50aXR5JlZlcnNpb249MjAxMS0wNi0xNSZYLUFtei1BbGdvcml0aG09QVdTNC1ITUFDLVNIQTI1NiZYLUFtei1DcmVkZW50aWFsPUFLSUFTMklCWUtQNlBSWDZPMzZDJTJGMjAyMDAxMTYlMkZ1cy1lYXN0LTElMkZzdHMlMkZhd3M0X3JlcXVlc3QmWC1BbXotRGF0ZT0yMDIwMDExNlQxNjM0MzZaJlgtQW16LUV4cGlyZXM9MCZYLUFtei1TaWduZWRIZWFkZXJzPWhvc3QlM0J4LWs4cy1hd3MtaWQmWC1BbXotU2lnbmF0dXJlPTBiNDExODBiMjM4M2Y5MjUwYTZhNmEwOTJiMDliNmZiYzA4OWVmZGNkMWZjMDZjZWYxMjZlYjUzNzgwNGU5NjI"})
      :paths
      (get  "/api/v1/namespaces/{namespace}/serviceaccounts/{name}")
      :get
      :summary)
  @(martian/response-for k8s :GetApiVersions)

  (explore k8s))
