(ns {{name}}.handlers
    [re-frame.core :as rf :refer [dispatch dispatch-sync register-handler]]
    [{{name}}.db :as db])

(register-handler
  :initialize-db
  (fn  [_ _]
    db/default-db))

(register-handler
  :set-active-panel
  (fn [db [_ active-panel]]
    (assoc db :active-panel active-panel)))

(register-handler
  :set
  (fn [db [_ key value]]
    (assoc db key value)))

(register-handler
  :set-in
  (fn [db [_ keys value]]
    (assoc-in db keys value)))
