(ns {{name}}.routes
    (:require-macros [secretary.core :refer [defroute]])
    (:require [secretary.core :as secretary]
              [goog.events :as events]
              [goog.history.EventType :as EventType]
              [re-frame.core :as rf :refer [dispatch dispatch-sync]]
              [accountant.core :as accountant]))

(def BASE-URL "/")

(defn app-routes []
  (secretary/set-config! :prefix "")

  (defroute home (str BASE-URL "/") [] (dispatch [:set-active-panel :home]))

  (accountant/configure-navigation!
    {:nav-handler  (fn [path] (secretary/dispatch! path))
     :path-exists? (fn [path] (secretary/locate-route path))})

  (accountant/dispatch-current!))
