(ns leiningen.new.o2w
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files raw-resourcer]]
            [leiningen.core.main :as main]
            [clojure.java.io :as io]
            [clojure.string :as str]
            [clj-jgit.porcelain :refer :all]))


(def render (renderer "o2w"))
(def resource (raw-resourcer "o2w"))

(def resources
  {:all [".gitignore"
         "README.md"
         "project.clj"
         "resources/log4j.properties"
         "resources/public/index.html"
         "src/cljc/o2w/common.cljc"

         ]

   :clj ["dev/user.clj"

         "src/clj/o2w/core.clj"
         "src/clj/o2w/layout.clj"
         "src/clj/o2w/handler.clj"
         "src/clj/o2w/core.clj"
         "src/clj/o2w/system.clj"

         "test/clj/o2w/example_test.clj"
         ]

   :cljs [
          "src/cljs/o2w/core.cljs"
          "src/cljs/o2w/handlers.cljs"
          "src/cljs/o2w/db.cljs"
          "src/cljs/o2w/routes.cljs"
          "src/cljs/o2w/views.cljs"
          "src/cljs/o2w/subs.cljs"
          ]

   :sass ["src/scss/main.scss"]
   })

(defn get-resources [options]
  (->> options
    (filter (fn [[k v]] v))
    keys
    (into #{:all})
    (map #(% resources))
    (remove nil?)
    flatten))

(defn get-files [options]
  (->> (get-resources options)
    (map #(vector
            (str/replace % "o2w" "{{sanitized}}")
            (render % options)))))


(def default-options
  {:clj  true
   :cljs false
   :sass false})


(defn get-options [opts]
  (->> opts
    (map #(hash-map
            (keyword (subs % 1))
            (if (= "+" (subs % 0 1)) true false)))
    (into {})
    (merge default-options)))


(defn o2w
  "FIXME: write documentation"
  [name & params]
  (let [options (get-options params)
        data    (merge
                  {:name      name
                   :sanitized (name-to-path name)} options)]

    (main/info "Generating fresh 'lein new' o2w project.")
    (apply ->files data (get-files data))

    (git-init name)
    (let [repo (load-repo name)]
      (git-add repo ".")
      (git-commit repo (str "lein new " name)))))


(comment

  (get-options ["-clj" "+cljs" "+aoeuao"])
  (get-files (get-options {}))

  )
