(ns obis-shared.activiti.engines
  (:import org.activiti.engine.ProcessEngines))

(def ^:dynamic *engine* nil)

(let [default-pe (delay (ProcessEngines/getDefaultProcessEngine))]
  (defn get-process-engine
    []
    (or *engine* @default-pe)))

(let [pe get-process-engine]
  (defn repository-service [] (.getRepositoryService (pe)))
  (defn runtime-service [] (.getRuntimeService (pe)))
  (defn history-service [] (.getHistoryService (pe)))
  (defn management-service [] (.getManagementService (pe)))
  (defn task-service [] (.getTaskService (pe))))
