(ns obis-shared.activiti.rest-client
  (:use obis-shared.utils.gen-class)
  (:require [clojure.data.json :as json])
  (:require [obis-shared.config :as cfg])
  (:require [clj-http.client :as client]))

(defn ensure-trailing-slash
  [s]
  (if (= "/" (subs s (dec (count s))))
    s
    (str s "/")))

(def rest-url
  (delay
    (ensure-trailing-slash
      (cfg/get-prop "activiti.rest.url"))))

(defn url
  [s]
  (str @rest-url "service/" s))

(defn process-definitions
  []
  (->
    (url "process-definitions")
    client/get
    :body
    json/read-json
    :data))

; Should cache this eh?
; Actually we might not even need it.
(defn pd-id-from-key
  [pdkey]
  (->>
    (process-definitions)
    (filter #(= pdkey (:key %)))
    (sort-by :version)
    last
    :id))

; If we're going to be enhancing activiti-rest at all, letting it
; accept a key here would be nice.
;
; Nevermind it already accepts one, it's just undocumented.
(defn start-process-instance
  "Variables must be all string-valued. A :businessKey can be passed
  in as a variable."
  ([pdkey] (start-process-instance pdkey {}))
  ([pdkey variables]
    ; This route only accepts string variables. In fact if you send anything
    ; else it fails silently, setting the variables to null.
    {:pre [(every? string? (vals variables))]}
    (->
      (url "process-instance")
      (client/post
        {:body (json/json-str (merge (into {} variables) {:processDefinitionKey pdkey}))})
      :body
      json/read-json)))

; Warning -- I think this paginates at 10 or something like that. Checkit.
(defn process-instances
  [pd-id]
  (->
    (url "process-instances")
    (client/get
      {:query-params {:processDefinitionId pd-id}})
    :body
    json/read-json
    :data))

(defn task-summary
  [user-id])


(gen-class-with-exports)
