(ns obis-shared.entity
  (:use obis-shared.utils.gen-class)
  (:require [obis-shared.entity.http-json :as http]))

(def project-role "project_role")

(defn all-projects
  []
  (http/get-simple ["projects"]))

(defn create-project
  [attrs]
  (http/post ["projects"] 
        {:attributes attrs,
         :identifiers {}}))

(defn update-project
  [obisid attrs]
  (http/put ["projects" obisid]
       {:attributes attrs,
        :identifiers {}}))

(defn get-project
  [obisid]
  (http/get ["projects" obisid]))

(defn delete-project
  [obisid]
  (http/delete ["projects" obisid]))

(defn add-notification
  "value is expected to be a map"
  [obisid value]
  (http/post ["projects" obisid "notifications"]
    value))

(defn all-notifications
  [obisid]
  (http/get ["projects" obisid "notifications"]))

(defn all-updates
  [obisid]
  (http/get ["projects" obisid "updates"]))

(defn all-relationships
  [obisid]
  (http/get ["projects" obisid "relationships"]))

(defn all-relationships-by-type
  [obisid relationship-type]
  (let [r (all-relationships obisid)]
    (filter #(= (:relationship_type %) relationship-type) r)))

(defn all-project-roles
  [obisid]
  (all-relationships-by-type obisid project-role))

(defn all-class-notifications
  []
  (http/get ["projects" "notifications"]))

(defn create-class-notification
  [value]
  (http/post ["projects" "notifications"] value))

(defn find-entity-by-identifier
  [ident-name ident-value]
  (http/get ["identifiers" ident-name ident-value]))

(gen-class-with-exports)
