(ns obis-shared.entity.config
  (:require [clojure.string :as string])
  (:use [obis-shared.config :only [get-prop]]))


;; TODO: MORE POJECTISH CRAP
(defn base-url
  []
  (format "http://%s:%s/"
          (get-prop "obis.entity.host")
          (get-prop "obis.entity.port")))

(defn couchdb-url
  []
  (format "http://%s:%s/%s/"
          (get-prop "obis.entity.host")
          (get-prop "obis.couchdb.port")
          (get-prop "obis.couchdb.db")))

(defn url
  "Returns a url with the path elements given, either as multiple string
   arguments or a single list of string elements."
  [& args]
  (if (and (= 1 (count args)) (sequential? (first args)))
    (apply url (first args))
    (str
      (base-url)
      (string/join "/" (map str args)))))
