(ns obis-shared.entity.http-json
  (:refer-clojure :exclude [get])
  (:use [clojure.data.json :only [json-str write-json read-json]])
  (:use obis-shared.entity.config)
  (:require [clj-http.client :as client]))

(defn request
  ([method sub-uri path] (request method sub-uri path nil))
  ([method sub-uri path body-or-param-map]
    (let [f ({:get client/get,
              :post client/post,
              :delete client/delete,
              :put client/put} method),
          f (partial f (url (cons sub-uri path)))]
      (let [resp (if body-or-param-map
                   (if (= method :get)
                     (f {:query-params body-or-param-map})
                     (f {:body (json-str body-or-param-map)}))
                   (f))]
        (try
          (-> resp :body read-json)
          (catch Exception e
            (println "Could not parse this response!")
            (prn resp)
            (throw e)))))))

(def get (partial request :get "obisentity"))
(def post (partial request :post "obisentity"))
(def delete (partial request :delete "obisentity"))
(def put (partial request :put "obisentity"))

(def get-simple (partial request :get "obissimple"))
(def post-simple (partial request :post "obissimple"))
(def delete-simple (partial request :delete "obissimple"))
(def put-simple (partial request :put "obissimple"))
