(ns obis-shared.entity.notifications
  (:require [clj-http.client :as client]
            [clojure.data.json :as json]
            [obis-shared.config :as config]))

(defn new-message-url
  [sender]
  (str "http://" (config/get-prop "obis.notifier.host") "/" sender "/notifications"))

(defn create-notification
  [sender to-uid to-email subject body]
  (client/post (new-message-url sender)
               {:content-type :json
                :accept :json
                :body (json/json-str {:to {:uid to-uid
                                           :email to-email}
                                      :subject subject
                                      :body body})}))
