(ns obis-shared.entity.services
  (:use obis-shared.utils.gen-class
        obis-shared.entity.utils
        clojure.set)
  (:require [obis-shared.entity.http-json :as http]))

(defn all
  []
  (http/get-simple ["services"]))

(defn get-service
  [id]
  (http/get-simple ["services" id]))

(defn relationships
  [obis-id]
  (http/get ["services" obis-id "relationships"]))

(defn related-organizational-unit-type
  [simple-service]
  (some #{:program_id :core_id :provider_id} (keys simple-service)))

(defn related-organizational-unit
  [simple-service]
  (let [t (related-organizational-unit-type simple-service)]
    (t simple-service)))

(gen-class-with-exports)
