(ns obis-shared.entity.utils
  (:import [java.text SimpleDateFormat]))

(def yyyy-mm-dd (SimpleDateFormat. "yyyy-MM-dd HH:mm:ss")) 

(defn new-relationship
  [type from to attributes]
  {:relationship_type type
   :to to
   :from from
   :attributes attributes})

(defn filter-by
  "A shortcut function for filtering collections"
  [key id c]
  (doall (filter #(= (key %) id) c)))

(defn insert-into-vector
  [vec pos item]
  (apply conj (subvec vec 0 pos) item (subvec vec pos)))

(defn remove-from-vector
  [vec pos]
  (apply conj (subvec vec 0 pos) (subvec vec (+ 1 pos))))
