(ns obis-shared.utils.mailer
  (:require [postal.core :as postal]
            [obis-shared.config :as config]))

(def mail-server
  {:host (config/get-prop "obis.mail.server.host")
   :user (config/get-prop "obis.mail.server.username")
   :pass (config/get-prop "obis.mail.server.password")
   :ssl :yes})

(defn send-email
  "Takes a map with :to :from :subject and :body keys."
  [message-params]
  (postal/send-message #^mail-server
                       message-params))
