(ns batman.core
  "Batman's utility belt for Clojure. Aims to complement functions and macros found in
   clojure.core"
  (:require [clojure.string :as string]))

(defmacro fmt [^String s]
  "Provides Ruby-like string interpolation using ~{} instead of #{}."
  ;; Original credit to blacktaxi:  https://gist.github.com/blacktaxi/1676575
  ;; Updated to handle set literals and not print nils
  (let [re #"~\{(.*?)\}"
        fstr (string/replace s re "%s")
        fargs (map #(read-string (second %)) (re-seq re s))]
    `(->> (map #(or % "") (list ~@fargs))
          (apply format ~fstr))))


