(ns batman.string
  "A comprehensive set of Clojure String utilities including all of those found in
   clojure.string.

   As a rule, all functions provide nil handling by default"
  (:require [clojure.string :as string]))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Functions Shadowed from clojure.string

(def split #(when % (string/split % %2)))
(def reverse #(when % (string/reverse %)))
(def replace #(when % (apply string/replace % %&)))
(def replace-first #(when % (apply string/replace-first % %&)))
(def trim-newline #(when % (string/trim-newline %)))
(def triml #(when % (string/triml %)))
(def trimr #(when % (string/trimr %)))
(def trim #(when % (string/trim %)))
(def upper-case #(when % (string/upper-case %)))
(def lower-case #(when % (string/lower-case %)))
(def escape #(when % (string/escape % %2)))
(def split-lines #(when % (string/split-lines %)))

(def join string/join)
(def blank? string/blank?)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; New Functions

(defn ^:private positive-integer? [i]
  (and (integer? i) (>= i 0)))

(defn slice [^CharSequence s lower upper]
  {:pre [(positive-integer? lower) (positive-integer? upper)]}
  (->> (drop lower s)
       (take (+ 1 (- upper lower)))
       (apply str)))

(defn slicel [^CharSequence s lower]
  {:pre [(positive-integer? lower)]}
  (->> (drop lower s) (apply str)))

(defn slicer [^CharSequence s upper]
  {:pre [(positive-integer? upper)]}
  (->> (drop-last upper s) (apply str)))
