# Strum
[![Build Status](https://travis-ci.org/occamin/strum.svg?branch=master)](https://travis-ci.org/occamin/strum)

Clojure is a excellent, clean and expressive language, but its default
string namespace brings a tear to my eye.

__Strum__ is a drop-in replacement for __clojure.string__ that aims to
provide a richer set of String operations more akin to those found in
Python and Ruby, as well as address some inconsistencies with other
parts of the Clojure standard library (like lack of nil handling).

## Latest Version

[![Clojars Project](http://clojars.org/occamin/strum/latest-version.svg)](http://clojars.org/occamin/strum)

## Usage

Add Strum to your `project.clj`

```clojure
(defproject strum-fun "1.0.0-SNAPSHOT"
  :description "FIXME: write"
  :dependencies [[org.clojure/clojure "1.5.0"]
                [occamin/strum "1.0.0"]])
```

Then get to business:

```clojure
(ns strum-fun.core
  (:require [strum.core :as strum :refer [fmt])

;; All the functions found in clojure.string are available in Strum
;; All functions support nil handling so more NullException explosions

(strum/trim "  hello strum  ")
;; => "hello strum"
(strum/lower-case nil)
;; => nil

;; Ruby-like String interpolation macro

(def name "strum")
(fmt "hello #{name}")
;; => "hello strum"
(fmt "Supports arbitrary nesting of clojure #{(#{\"a\" \"b\"
\"expressions\"} \"expressions\")}")
;; => "Supports arbitrary nesting of clojure expressions"

;; Python-like String slicing

(strum/slice "123456" 2 :- -2)
;; => "34"
(strum/slice "123456" :- 4)
;; => "1234"
(strum/slice "123456" 2 :-)
;; => "3456"

;; Some other useful stuff

(strum/contains? "Spider-man" "man")
;; => true
(strum/prefix? "Batman" "Bat")
;; => true
(strum/suffix? "Superman" "erman")
;; => true
(strum/index "Hello World" "l")
;; => 2
(strum/rindex "Hello World" "l")
;; => 9
```

See [tests](https://github.com/occamin/strum/blob/master/test/strum/core_test.clj) or function docs for more info.

## Planned Features

* Add a few more of the less frequently used string functions from
  Java, Ruby and Python String object.
* Add Clojurescript support with cljx.

## Contribute

* If it is a new feature please create an issue first.
* Fork and send me a pull request. Tests are a must!

## License

Copyright © 2014 Mike Jackson.

Distributed under the permissive [MIT license](http://opensource.org/licenses/MIT).
