(ns domestic.core)

(defmacro defevent
  "Creates an event for a given dispatcher"
  [event-name args dispatcher & fdecl]
  (if (instance? clojure.lang.Symbol dispatcher)
    `(defmethod ~dispatcher ~(keyword event-name)
       ~args
       (let [update-fn# (:update-fn (second ~args))
             state# (get ~args 2)
             next-value# (do ~@fdecl)]

         ;; noop if nil is returned from the fdecl
         (when (some? next-value#)
           (update-fn# next-value#))

         ;; always return state object to better support testing
         state#))
    (throw (Exception. "defevent requires a valid dispatcher."))))
