// Compiled by ClojureScript 1.10.520 {}
goog.provide('hx.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.object');
hx.utils.keyword__GT_str = (function hx$utils$keyword__GT_str(k){
var kw_ns = cljs.core.namespace.call(null,k);
var kw_name = cljs.core.name.call(null,k);
if((kw_ns == null)){
return kw_name;
} else {
return [kw_ns,"/",kw_name].join('');
}
});
hx.utils.props__GT_clj = (function hx$utils$props__GT_clj(props){
var ks = Object.keys(props);
var m = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if((ks == null)){
return m;
} else {
var k = cljs.core.first.call(null,ks);
var v = goog.object.get(props,k);
var G__22127 = cljs.core.next.call(null,ks);
var G__22128 = (function (){var G__22126 = k;
switch (G__22126) {
case "class":
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"className","className",-1983287057),v,new cljs.core.Keyword(null,"class","class",-2030961996),v);

break;
case "className":
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"className","className",-1983287057),v,new cljs.core.Keyword(null,"class","class",-2030961996),v);

break;
case "htmlFor":
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),v,new cljs.core.Keyword(null,"for","for",-1323786319),v);

break;
default:
return cljs.core.assoc.call(null,m,cljs.core.keyword.call(null,k),v);

}
})();
ks = G__22127;
m = G__22128;
continue;
}
break;
}
});
hx.utils.set_obj = (function hx$utils$set_obj(o,k,v){
goog.object.set(o,k,v);

return o;
});
/**
 * Join the `classes` with a whitespace.
 */
hx.utils.join_classes = (function hx$utils$join_classes(classes){
return clojure.string.join.call(null," ",cljs.core.remove.call(null,cljs.core.nil_QMARK_,classes));
});
hx.utils.class_name = (function hx$utils$class_name(x){
if((((x == null)) || ((x instanceof cljs.core.Keyword)) || (typeof x === 'string'))){
return x;
} else {
if(((cljs.core.sequential_QMARK_.call(null,x)) || (cljs.core.set_QMARK_.call(null,x)))){
return hx.utils.join_classes.call(null,x);
} else {
return x;

}
}
});
/**
 * Returns camel case version of the string, e.g. "http-equiv" becomes "httpEquiv".
 */
hx.utils.camel_case_STAR_ = (function hx$utils$camel_case_STAR_(s){
if((((s instanceof cljs.core.Keyword)) || (typeof s === 'string') || ((s instanceof cljs.core.Symbol)))){
var vec__22130 = clojure.string.split.call(null,cljs.core.name.call(null,s),/-/);
var seq__22131 = cljs.core.seq.call(null,vec__22130);
var first__22132 = cljs.core.first.call(null,seq__22131);
var seq__22131__$1 = cljs.core.next.call(null,seq__22131);
var first_word = first__22132;
var words = seq__22131__$1;
if(((cljs.core.empty_QMARK_.call(null,words)) || (cljs.core._EQ_.call(null,"aria",first_word)) || (cljs.core._EQ_.call(null,"data",first_word)))){
return s;
} else {
return clojure.string.join.call(null,cljs.core.conj.call(null,cljs.core.map.call(null,clojure.string.capitalize,words),first_word));
}
} else {
return s;
}
});
hx.utils.map__GT_camel_PLUS_js = (function hx$utils$map__GT_camel_PLUS_js(x){
if(cljs.core.map_QMARK_.call(null,x)){
var ps = cljs.core.seq.call(null,x);
var o = ({});
while(true){
if((ps == null)){
return o;
} else {
var p = cljs.core.first.call(null,ps);
var k = cljs.core.key.call(null,p);
var v = cljs.core.val.call(null,p);
hx.utils.set_obj.call(null,o,hx.utils.camel_case_STAR_.call(null,cljs.core.name.call(null,k)),hx.utils.map__GT_camel_PLUS_js.call(null,v));

var G__22133 = cljs.core.next.call(null,ps);
var G__22134 = o;
ps = G__22133;
o = G__22134;
continue;
}
break;
}
} else {
return x;

}
});
/**
 * Shallowly converts props map to a JS obj. Handles certain special cases:
 * 
 *   1. `:class` -> "className", and joins collections together as a string
 *   2. `:for` -> "htmlFor"
 *   3. `:style` -> deeply converts this prop to a JS obj
 * 
 *   By default, converts kebab-case keys to camelCase strings. pass in `false`
 *   as a second arg to disable this.
 */
hx.utils.clj__GT_props = (function hx$utils$clj__GT_props(var_args){
var G__22136 = arguments.length;
switch (G__22136) {
case 1:
return hx.utils.clj__GT_props.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hx.utils.clj__GT_props.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

hx.utils.clj__GT_props.cljs$core$IFn$_invoke$arity$1 = (function (props){
return hx.utils.clj__GT_props.call(null,props,true);
});

hx.utils.clj__GT_props.cljs$core$IFn$_invoke$arity$2 = (function (props,native_QMARK_){
var pxs = cljs.core.seq.call(null,props);
var js_props = ({});
while(true){
if((pxs == null)){
return js_props;
} else {
var p = cljs.core.first.call(null,pxs);
var k = cljs.core.key.call(null,p);
var v = cljs.core.val.call(null,p);
var G__22137_22139 = k;
var G__22137_22140__$1 = (((G__22137_22139 instanceof cljs.core.Keyword))?G__22137_22139.fqn:null);
switch (G__22137_22140__$1) {
case "style":
hx.utils.set_obj.call(null,js_props,"style",hx.utils.map__GT_camel_PLUS_js.call(null,v));

break;
case "class":
if(cljs.core.truth_(native_QMARK_)){
hx.utils.set_obj.call(null,js_props,"className",hx.utils.class_name.call(null,v));
} else {
hx.utils.set_obj.call(null,js_props,"class",hx.utils.class_name.call(null,v));

hx.utils.set_obj.call(null,js_props,"className",hx.utils.class_name.call(null,v));
}

break;
case "for":
if(cljs.core.truth_(native_QMARK_)){
hx.utils.set_obj.call(null,js_props,"htmlFor",v);
} else {
hx.utils.set_obj.call(null,js_props,"for",v);

hx.utils.set_obj.call(null,js_props,"htmlFor",v);
}

break;
default:
hx.utils.set_obj.call(null,js_props,(cljs.core.truth_(native_QMARK_)?hx.utils.camel_case_STAR_.call(null,hx.utils.keyword__GT_str.call(null,k)):hx.utils.keyword__GT_str.call(null,k)),v);

}

var G__22142 = cljs.core.next.call(null,pxs);
var G__22143 = js_props;
pxs = G__22142;
js_props = G__22143;
continue;
}
break;
}
});

hx.utils.clj__GT_props.cljs$lang$maxFixedArity = 2;


//# sourceMappingURL=utils.js.map
