// Compiled by ClojureScript 1.10.520 {}
goog.provide('hx.hiccup');
goog.require('cljs.core');
goog.require('clojure.walk');
goog.require('hx.utils');

/**
 * @interface
 */
hx.hiccup.IElement = function(){};

/**
 * Converts to an element
 */
hx.hiccup._as_element = (function hx$hiccup$_as_element(el,config){
if((((!((el == null)))) && ((!((el.hx$hiccup$IElement$_as_element$arity$2 == null)))))){
return el.hx$hiccup$IElement$_as_element$arity$2(el,config);
} else {
var x__4433__auto__ = (((el == null))?null:el);
var m__4434__auto__ = (hx.hiccup._as_element[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,el,config);
} else {
var m__4431__auto__ = (hx.hiccup._as_element["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,el,config);
} else {
throw cljs.core.missing_protocol.call(null,"IElement.-as-element",el);
}
}
}
});

if((typeof hx !== 'undefined') && (typeof hx.hiccup !== 'undefined') && (typeof hx.hiccup.tag_registry !== 'undefined')){
} else {
hx.hiccup.tag_registry = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
hx.hiccup.extend_tag = (function hx$hiccup$extend_tag(tag,impl){
return cljs.core.swap_BANG_.call(null,hx.hiccup.tag_registry,cljs.core.assoc,tag,impl);
});
hx.hiccup.tag__GT_impl = (function hx$hiccup$tag__GT_impl(tag){
var temp__5455__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,hx.hiccup.tag_registry),tag,null);
if(cljs.core.truth_(temp__5455__auto__)){
var t = temp__5455__auto__;
return t;
} else {
return cljs.core.name.call(null,tag);
}
});
hx.hiccup.parse_tag = (function hx$hiccup$parse_tag(el){
if((el instanceof cljs.core.Keyword)){
return hx.hiccup.tag__GT_impl.call(null,el);
} else {
if(cljs.core.var_QMARK_.call(null,el)){
return (function() { 
var hx$hiccup$parse_tag_$_VarEl__delegate = function (args){
return cljs.core.apply.call(null,el,args);
};
var hx$hiccup$parse_tag_$_VarEl = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__22172__i = 0, G__22172__a = new Array(arguments.length -  0);
while (G__22172__i < G__22172__a.length) {G__22172__a[G__22172__i] = arguments[G__22172__i + 0]; ++G__22172__i;}
  args = new cljs.core.IndexedSeq(G__22172__a,0,null);
} 
return hx$hiccup$parse_tag_$_VarEl__delegate.call(this,args);};
hx$hiccup$parse_tag_$_VarEl.cljs$lang$maxFixedArity = 0;
hx$hiccup$parse_tag_$_VarEl.cljs$lang$applyTo = (function (arglist__22173){
var args = cljs.core.seq(arglist__22173);
return hx$hiccup$parse_tag_$_VarEl__delegate(args);
});
hx$hiccup$parse_tag_$_VarEl.cljs$core$IFn$_invoke$arity$variadic = hx$hiccup$parse_tag_$_VarEl__delegate;
return hx$hiccup$parse_tag_$_VarEl;
})()
;
} else {
return el;

}
}
});
hx.hiccup.make_element = (function hx$hiccup$make_element(config,el,args){
return new cljs.core.Keyword(null,"create-element","create-element",193243064).cljs$core$IFn$_invoke$arity$1(config).call(null,config,el,args);
});
hx.hiccup.parse = (function hx$hiccup$parse(config,hiccup){
return hx.hiccup.make_element.call(null,config,hx.hiccup.parse_tag.call(null,cljs.core.nth.call(null,hiccup,(0))),cljs.core.rest.call(null,hiccup));
});
hx.hiccup.ex = (function hx$hiccup$ex(s){
return (new Error(s));
});
goog.object.set(hx.hiccup.IElement,"null",true);

goog.object.set(hx.hiccup._as_element,"null",(function (_,___$1){
return null;
}));

goog.object.set(hx.hiccup.IElement,"number",true);

goog.object.set(hx.hiccup._as_element,"number",(function (n,_){
return n;
}));

goog.object.set(hx.hiccup.IElement,"string",true);

goog.object.set(hx.hiccup._as_element,"string",(function (s,_){
return s;
}));

cljs.core.PersistentVector.prototype.hx$hiccup$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.hx$hiccup$IElement$_as_element$arity$2 = (function (form,config){
var form__$1 = this;
return hx.hiccup.make_element.call(null,config,hx.hiccup.parse_tag.call(null,cljs.core.nth.call(null,form__$1,(0))),cljs.core.rest.call(null,form__$1));
});

cljs.core.LazySeq.prototype.hx$hiccup$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.hx$hiccup$IElement$_as_element$arity$2 = (function (a,config){
var a__$1 = this;
return hx.hiccup.make_element.call(null,config,new cljs.core.Keyword(null,"fragment","fragment",826775688).cljs$core$IFn$_invoke$arity$1(config),cljs.core.cons.call(null,null,cljs.core.map.call(null,((function (a__$1){
return (function (p1__22174_SHARP_){
return hx.hiccup._as_element.call(null,p1__22174_SHARP_,config);
});})(a__$1))
,a__$1)));
});

goog.object.set(hx.hiccup.IElement,"array",true);

goog.object.set(hx.hiccup._as_element,"array",(function (a,config){
return hx.hiccup.make_element.call(null,config,new cljs.core.Keyword(null,"fragment","fragment",826775688).cljs$core$IFn$_invoke$arity$1(config),cljs.core.cons.call(null,null,cljs.core.map.call(null,(function (p1__22175_SHARP_){
return hx.hiccup._as_element.call(null,p1__22175_SHARP_,config);
}),a)));
}));

goog.object.set(hx.hiccup.IElement,"_",true);

goog.object.set(hx.hiccup._as_element,"_",(function (el,config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"is-element?","is-element?",-1231778016).cljs$core$IFn$_invoke$arity$1(config).call(null,el))){
return el;
} else {
throw hx.hiccup.ex.call(null,["Unknown element type ",cljs.core.pr_str.call(null,cljs.core.type.call(null,el))," found while parsing hiccup form: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(el.toString())].join(''));

}
}));

//# sourceMappingURL=hiccup.js.map
