(ns hx-frame-sockets.db
  (:require [cljs.spec.alpha :as s]))

(def initial-state
  {:hx-frame-sockets {:status :disconnected
                      :messages {}}})

(s/def ::action keyword?)
(s/def ::data (s/or :vec vector? :map map?))
(s/def ::client-id (s/nilable string?))

(s/def ::name keyword?)
(s/def ::message string?)
(s/def ::stack any?)

(s/def ::error (s/keys :req-un [::name
                                ::message]
                       :opt-un [::stack]))

(s/def ::ws-message (s/keys :req-un [::action]
                            :opt-un [::data
                                     ::error
                                     ::client-id]))
(s/def ::messages (s/coll-of ::message))
(s/def ::status #{:disconnected :connected})

(s/def ::hx-frame-sockets (s/keys :req-un [::status
                                           ::messages]))
