(ns backend-shared.service.respond)
(defn res [code body] (clj->js {:statusCode code
                                :headers {:Access-Control-Allow-Origin "*"}
                                :body body}))

(defmulti  respond (fn [_ [status-code]] status-code))

(defmethod respond :fail [{:keys [callback]} [_ error]] (callback (clj->js error)) nil)
(defmethod respond :denied [{:keys [callback]} [_ error]] (callback (str "[401] " error)))
(defmethod respond :accepted [{:keys [callback]}] (callback nil (clj->js (res 202 nil))))
(defmethod respond :ok [{:keys [callback]} [_ payload]] (callback nil (res 200 payload)))
