(ns backend-shared.service.respond
  (:require [shared.protocols.specced :as sp]
            [shared.protocols.loggable :as log]
            [cljs.spec :as spec]
            [backend-adapters.embedly.index :as embedly]))

(defmulti respond (fn [_ response]
                    (if (sp/resolve response) :default :invalid)))

(defmethod respond :invalid [{:keys [callback]} _]
  (callback "ERROR"))

(defmethod respond :api [{:keys [callback]} {:keys [statusCode body] :as response}]
  (if (>= statusCode 500)
    (callback (.stringify js/JSON (clj->js body)))
    (callback nil (clj->js response))))

(defmethod respond :default [{:keys [callback]} response]
  (if (spec/valid? (spec/coll-of (spec/or :map map?
                                          :many-maps (spec/coll-of map?))) response)
    (callback nil (clj->js (into [] response)))
    (callback nil (clj->js response))))
