(ns backend-shared.models.payload.to-resource.helpers
  (:require [cljs.nodejs :as node]
            [shared.protocols.loggable :as log]
            [shared.protocols.convertible :as cv]
            [clojure.string :as str]))

(def URL (node/require "url"))

(def hostname->type
  {"www.youtube.com" :video})

(def hostname->provider
  {"www.youtube.com" :youtube})

(defn parse-url [url]
  (let [parsed-url (.parse URL url)
        hostname (.-hostname parsed-url)]
    {:hostname hostname
     :provider (hostname->provider hostname)
     :query (.-query parsed-url)
     :resource-type (or (get hostname->type hostname) :html)}))

(defn determine-type [url]
  (:resource-type (parse-url url)))

(defn video-content [url]
  (let [parsed-url (parse-url url)
        id (second (str/split (:query parsed-url) "="))]
    {:provider (:provider parsed-url)
     :id id}))
