(ns backend-shared.service.index
  (:require [backend-shared.aws-event.index :as aws-event]
            [backend-shared.specs.index]
            [backend-shared.protocol-extensions.index]
            [backend-adapters.index :as adapters]
            [backend-shared.service.log :as log]
            [backend-shared.models.payload.index]
            [backend-shared.service.fetch :as fetch]
            [backend-shared.service.perform :as perform]
            [backend-shared.service.check :as check]
            [backend-shared.service.respond :as respond]
            [shared.protocols.convertible :as cv]
            [shared.protocols.actionable :refer [Actionable]]
            [shared.protocols.eventful :refer [Eventful]]
            [shared.protocols.queryable :refer [Queryable]]
            [shared.models.payload.index :as payload]
            [cljs.spec.alpha :as spec]
            [shared.models.error.index :as error]))

(defrecord Service []
  Actionable
  (-perform [service action] (perform/perform service action))
  (-check   [service action] (check/check service action))
  Eventful
  (-respond [service payload] (respond/respond service payload))
  Queryable
  (-fetch [service query] (fetch/fetch service query)))

(defn to-event [raw-event]
  (let [clj-event (cv/to-clj raw-event)]
    (if (spec/valid? :aws/event clj-event)
      (aws-event/create clj-event)
      (payload/create clj-event))))

(defn create [service-name adapters-config event context callback]
  (log/incoming event context)
  (let [adapters (adapters/create adapters-config)
        errors   (keep :error adapters)
        config {:service-name service-name
                :stage (.. js/process -env -STAGE)
                :callback callback
                :context (cv/to-clj context)
                :event   (to-event event)}]
    (map->Service (merge config adapters))))

(def fetch fetch/fetch)
(def perform perform/perform)
(def check check/check)
