(ns backend-adapters.mercury.fetch
  (:require [cljs.core.async :as async]
            [cljs.nodejs :as node]
            [shared.models.payload.index :as payload]
            [shared.protocols.loggable :as log]
            [clojure.string :as str]
           [shared.protocols.convertible :as cv])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(def request (node/require "request"))

(defn create-url [endpoint api-key url]
  (str endpoint "/parser?url=" url))

(defn handle-response [channel error res data]
  (let [status-code                    (aget res "statusCode")
        {:keys [error_code] :as body} (cv/to-clj data)
        error                         (when (or error error_code (>= status-code 400)) res)
        data                          (when-not error (-> body cv/to-clj))]
    (async/put! channel (if error [:failed error] [:found data]))
    (async/close! channel)))

(defn fetch [{:keys [endpoint error api-key] :as this} {:keys [resource-url]}]
  (if error
    (go [:failed error])
    (let [c (async/chan)
          res (request (clj->js {:url (str endpoint "/parser?url=" resource-url)
                                 :headers {:x-api-key api-key}})
                       #(handle-response c %1 %2 %3))]
      c)))
