(ns backend-shared.service.perform
  (:require [shared.protocols.specced :as sp]
            [backend-shared.converters.index :refer [compressed->clj clj->compressed]]
            [cljs.core.async :as async :refer [<!]]
            [shared.models.error.index :as error])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defmulti perform (fn [service action] (sp/resolve action)))

(defmethod perform [:compress :resource] [_ [_ payload]]
  [:compressed {:compressed-data (clj->compressed payload)}])

(defmethod perform [:compress :raw-resource] [_ [_ payload]]
  [:compressed {:compressed-data (clj->compressed payload)}])

(defmethod perform [:compress :error] [_ [_ error]]
  [:failed error])

(defmethod perform [:deflate :compressed-data] [_ [_ payload]]
  [:deflated (compressed->clj payload)])

(defmethod perform :invalid-action [_ action]
  (go [:failed (error/create :invalid-action action)]))
