(ns backend-adapters.mercury.index
  (:require [shared.protocols.queryable :refer [Queryable]]
            [backend-shared.converters.index :refer [url->video-content html->tags]]
            [backend-shared.converters.helpers :refer [determine-type]]
            [backend-adapters.mercury.fetch :refer [fetch]]
            [shared.models.resource.index :as rs]
            [shared.protocols.loggable :as log]))

(defn create [{:keys [error api-keys]}]
  (specify {:api-key (:mercury api-keys)
            :error error
            :endpoint "https://mercury.postlight.com"}
    Queryable
    (-fetch [this query] (fetch this query))))

(defn remove-nil-fields [record]
  (into {} (remove (comp nil? second) record)))

(defmulti to-resource (fn [{:keys [url]}] (determine-type url)))

(defmethod to-resource :video [{:keys [url title excerpt content]}]
  (let [record {:resource-url  url
                :title         title
                :resource-type (determine-type url)
                :content       (url->video-content url)
                :description   excerpt
                :tags          (html->tags content)}]
    (remove-nil-fields record)))

(defmethod to-resource :html [{:keys [url title excerpt content]}]
  (let [record {:resource-url  url
                :title         title
                :resource-type (determine-type url)
                :content       content
                :description   excerpt
                :tags          (html->tags content)}]
    (remove-nil-fields record)))

(defn mercury->resource [raw-resource]
  (-> raw-resource
      to-resource
      remove-nil-fields))
